# Implementation Plan: Dimension-Based Inventory System

## Overview

This implementation plan transforms the Raw Materials (RM) inventory system from quantity-based to dimension-based tracking. The implementation follows a phased approach: database schema changes, backend services, API updates, and frontend integration. Each task builds incrementally to ensure the system remains functional throughout development.

## Tasks

- [x] 1. Database Schema Implementation
  - Create database migrations for all dimension-based tables and fields
  - Add new models for RM inventory pieces and cutting operations
  - Update existing models with dimension fields
  - _Requirements: 1.1, 1.2, 2.1, 8.1_

- [x] 1.1 Create database migration for Products table enhancement
  - Add `unit_of_measure` and `track_by_dimensions` columns to products table
  - Create index for dimension tracking queries
  - Set default values and constraints
  - **Note**: `track_by_dimensions = TRUE` for dimension-based RM, `FALSE` for special items RM
  - _Requirements: 8.1, 13.2_

- [x] 1.2 Write property test for Products dimension enforcement
  - **Property 13: RM Dimension Enforcement**
  - **Validates: Requirements 8.1**

- [x] 1.3 Create RM Inventory Pieces model and migration
  - Create `rm_inventory_pieces` table with full schema
  - Add proper indexes for performance (product_id, status, dimensions)
  - Define foreign key relationships
  - _Requirements: 1.2, 1.3_

- [x] 1.4 Write property test for RM inventory piece creation
  - **Property 2: Dimension-Based Piece Creation**
  - **Validates: Requirements 1.2, 1.3**

- [x] 1.5 Create RM Cutting Operations model and migration
  - Create `rm_cutting_operations` table with JSON fields for waste tracking
  - Add indexes for production order and piece lookups
  - Define relationships to production orders and BOM items
  - _Requirements: 4.1, 11.1_

- [x] 1.6 Write property test for cutting operation audit trail
  - **Property 8: Cutting Operation Audit Trail**
  - **Validates: Requirements 4.1, 11.1**

- [x] 1.7 Enhance existing models with dimension fields
  - Update BOM Items model with dimension requirements fields
  - Update GRN Items model with piece dimension fields
  - Update Inventories model with area summary fields
  - _Requirements: 2.1, 1.1_

- [x] 1.8 Write property test for BOM dimension requirements
  - **Property 4: BOM Dimension Requirements**
  - **Validates: Requirements 2.1, 2.2, 8.3**

- [ ] 2. Core Business Logic Services
  - Implement dimension validation and enforcement services
  - Create material allocation algorithms
  - Build cutting operations management
  - _Requirements: 3.1, 3.2, 4.2, 5.1_

- [x] 2.1 Implement RM dimension validation service
  - Create validation functions for RM products requiring dimensions
  - Implement unit conversion utilities (inches/cm/meters)
  - Add dimension sufficiency checking algorithms
  - _Requirements: 1.4, 8.2, 9.1_

- [x] 2.2 Write property test for dimension validation
  - **Property 1: RM Dimension Validation**
  - **Validates: Requirements 1.1, 1.4, 8.2**

- [x] 2.3 Write property test for unit conversion accuracy
  - **Property 7: Unit Conversion Accuracy**
  - **Validates: Requirements 3.5, 9.1, 9.2**

- [x] 2.4 Implement material allocation service
  - Create intelligent allocation algorithm (FULL → USABLE → WASTE priority)
  - Implement dimension matching with unit conversion
  - Add waste piece suggestion functionality
  - _Requirements: 3.1, 3.2, 5.1, 5.3_

- [x] 2.5 Write property test for material allocation priority
  - **Property 5: Material Allocation Priority**
  - **Validates: Requirements 3.2, 5.1**

- [x] 2.6 Write property test for dimension sufficiency check
  - **Property 6: Dimension Sufficiency Check**
  - **Validates: Requirements 3.1, 3.4**

- [x] 2.7 Implement cutting operations service
  - Create cutting operation processing with waste generation
  - Implement piece status updates after cutting
  - Add scrap identification and tracking
  - _Requirements: 4.2, 4.3, 4.4, 11.2_

- [ ] 2.8 Write property test for waste status management
  - **Property 9: Waste Status Management**
  - **Validates: Requirements 4.3, 5.2**

- [ ] 2.9 Write property test for scrap prevention
  - **Property 10: Scrap Prevention**
  - **Validates: Requirements 5.5, 10.5**

- [x] 3. Inventory Calculation and Reporting Services
  - Implement inventory summary calculations
  - Create area calculation utilities
  - Build material utilization reporting
  - _Requirements: 6.2, 6.3, 12.1_

- [x] 3.1 Implement inventory calculation service
  - Create piece counting algorithms by status
  - Implement area calculations (full, usable, waste, scrap)
  - Add inventory summary generation
  - _Requirements: 6.1, 6.2, 6.3_

- [x] 3.2 Write property test for inventory calculation accuracy
  - **Property 11: Inventory Calculation Accuracy**
  - **Validates: Requirements 6.1, 6.2**

- [x] 3.3 Write property test for area calculation consistency
  - **Property 3: Area Calculation Consistency**
  - **Validates: Requirements 1.6**

- [x] 3.4 Implement material utilization reporting service
  - Create utilization efficiency calculations
  - Implement waste generation and reuse statistics
  - Add cost savings tracking from waste reuse
  - _Requirements: 11.5, 12.1, 12.2_

- [x] 3.5 Write property test for material utilization calculation
  - **Property 18: Material Utilization Calculation**
  - **Validates: Requirements 11.5, 12.1**

- [ ] 4. Checkpoint - Core Services Complete
  - Ensure all core services pass tests, ask the user if questions arise.

- [x] 5. GRN Processing Integration
  - Update GRN processing to handle dimension-based RM
  - Integrate with RM inventory pieces creation
  - Add validation for RM dimension requirements
  - _Requirements: 1.1, 1.2, 1.3_

- [ ] 5.1 Update GRN service for dimension-based processing
  - Modify GRN processing to create RM inventory pieces for dimension-based RM
  - Add validation for dimension-based RM products requiring dimensions
  - Implement multiple dimension scenario handling
  - **Add support for special items RM**: Use standard quantity-based processing (no dimensions)
  - Route to appropriate processing based on `track_by_dimensions` flag
  - _Requirements: 1.1, 1.2, 7.1, 13.3_

- [ ] 5.2 Write property test for multi-dimension independence
  - **Property 12: Multi-Dimension Independence**
  - **Validates: Requirements 7.1, 7.2**

- [ ] 5.3 Update GRN item processing with piece creation
  - Create individual pieces for each dimension set in GRN
  - Implement piece numbering within GRN items
  - Add area calculation for cost allocation
  - _Requirements: 1.3, 7.5_

- [ ] 5.4 Write integration tests for GRN processing
  - Test complete GRN flow with dimension-based RM
  - Test multiple dimension scenarios
  - _Requirements: 1.1, 1.2, 1.3_

- [ ] 6. BOM Management Integration
  - Update BOM creation and validation for dimensions
  - Integrate dimension requirements with material allocation
  - Add BOM validation for RM products
  - _Requirements: 2.1, 2.2, 8.3_

- [x] 6.1 Update BOM service for dimension requirements
  - Add dimension validation for dimension-based RM products in BOM
  - Implement dimension requirement calculations
  - Add unit compatibility validation
  - **Add support for special items RM**: Validate quantity requirements (not dimensions)
  - Support mixed BOMs with both dimension-based and quantity-based RM items
  - _Requirements: 2.1, 2.2, 2.3, 13.4, 13.7_

- [x] 6.2 Write integration tests for BOM dimension validation
  - Test BOM creation with dimension requirements
  - Test validation errors for missing dimensions
  - _Requirements: 2.1, 2.2_

- [x] 6.3 Integrate BOM with material allocation service
  - Connect BOM dimension requirements to allocation algorithms
  - Add production quantity scaling for material calculations
  - Implement mixed BOM support (dimension + quantity based)
  - _Requirements: 2.4, 2.5_

- [x] 6.4 Write property test for fractional dimension support
  - **Property 14: Fractional Dimension Support**
  - **Validates: Requirements 9.4**

- [ ] 7. Production Order Integration
  - Update production confirmation with dimension-based allocation
  - Integrate cutting operations processing
  - Add waste and scrap management
  - _Requirements: 3.1, 4.1, 4.2_

- [x] 7.1 Update production service for dimension-based allocation
  - Integrate material allocation service with production orders
  - Add dimension-based material requirement validation for dimension-based RM
  - Implement production quantity optimization suggestions
  - **Add support for special items RM**: Use standard quantity-based inventory allocation
  - Support mixed production orders with both dimension-based and quantity-based RM
  - _Requirements: 3.1, 3.4, 3.6, 13.5, 13.8_

- [x] 7.2 Implement production cutting operations
  - Add cutting operation creation during production confirmation
  - Implement piece status updates and waste generation
  - Add traceability linking for all resulting pieces
  - _Requirements: 4.1, 4.2, 11.4_

- [x] 7.3 Write property test for cutting traceability
  - **Property 16: Cutting Traceability**
  - **Validates: Requirements 11.4**

- [x] 7.4 Implement waste and scrap management in production
  - Add waste piece creation from cutting operations
  - Implement scrap dimension tracking and write-off
  - Add waste reuse suggestions during production planning
  - _Requirements: 4.3, 4.4, 5.3_

- [x] 7.5 Write property test for waste reuse suggestion
  - **Property 17: Waste Reuse Suggestion**
  - **Validates: Requirements 5.3, 12.4**

- [x] 7.6 Write property test for scrap dimension separation
  - **Property 15: Scrap Dimension Separation**
  - **Validates: Requirements 10.2, 10.3**

- [ ] 8. API Endpoints Implementation
  - Create new API endpoints for RM inventory management
  - Update existing endpoints with dimension support
  - Add waste management and reporting APIs
  - _Requirements: All API-related requirements_

- [ ] 8.1 Create RM inventory API endpoints
  - GET /api/inventory/rm/:productId/pieces - List all pieces with dimensions
  - GET /api/inventory/rm/:productId/summary - Get aggregated dimensions
  - POST /api/inventory/rm/:productId/write-off - Write off scrap dimensions
  - _Requirements: 6.4, 6.5, 10.3_

- [ ] 8.2 Update GRN API endpoints for dimensions
  - Update POST /api/procurement/grns to accept dimension fields for dimension-based RM
  - Update GRN processing endpoints to handle RM pieces creation for dimension-based RM
  - Add validation responses for dimension requirements
  - **Add support for special items RM**: Allow standard quantity-based GRN processing
  - Route to appropriate processing based on product type
  - _Requirements: 1.1, 1.4, 13.3_

- [ ] 8.3 Update BOM API endpoints for dimensions
  - Update POST /api/production/boms to accept dimension fields for dimension-based RM
  - Update BOM validation to require dimensions for dimension-based RM products
  - Add dimension compatibility validation responses
  - **Add support for special items RM**: Accept quantity_per_unit (not dimensions)
  - Support mixed BOMs with both types of RM items
  - _Requirements: 2.1, 2.2, 13.4, 13.7_

- [ ] 8.4 Update Production API endpoints for dimension allocation
  - Update production confirmation to use dimension-based allocation
  - Add material allocation preview endpoints
  - Add waste suggestion endpoints for production planning
  - _Requirements: 3.1, 5.3_

- [ ] 8.5 Write integration tests for all API endpoints
  - Test complete API workflows with dimension data
  - Test error handling and validation responses
  - _Requirements: All API requirements_

- [ ] 9. Frontend Integration (Basic)
  - Update forms to handle dimension inputs
  - Add dimension display components
  - Implement basic waste management UI
  - _Requirements: Frontend-related requirements_

- [ ] 9.1 Update Product form for dimension tracking
  - Add "Track by Dimensions" checkbox (auto-enabled for dimension-based RM, disabled for special items RM)
  - Add "Unit of Measure" dropdown (inch/cm/m) - only for dimension-based RM
  - Add validation for dimension-based RM products requiring dimensions
  - **Add UI to distinguish**: Dimension-based RM vs. Special Items RM
  - Add product type selector or category to identify special items
  - _Requirements: 8.1, 13.2_

- [ ] 9.2 Update GRN form for dimension inputs
  - Add dimension input fields (length, width, unit, pieces count) for dimension-based RM
  - Show/hide dimension fields based on `track_by_dimensions` flag
  - Add area calculation display for cost allocation (dimension-based RM only)
  - **For special items RM**: Show standard quantity input (no dimensions)
  - _Requirements: 1.1, 1.6, 13.3_

- [ ] 9.3 Update BOM form for dimension requirements
  - Add dimension requirement fields for dimension-based RM products
  - Add "Use Dimensions" toggle per BOM item (auto-set based on product type)
  - Show calculated area requirements for dimension-based RM
  - **For special items RM**: Show quantity_per_unit input (no dimensions)
  - Support mixed BOM items in the same form
  - _Requirements: 2.1, 13.4, 13.7_

- [ ] 9.4 Create RM inventory dashboard
  - Display dimension summary (full/usable/waste/scrap areas) for dimension-based RM
  - List individual pieces with dimensions and status for dimension-based RM
  - Add filtering by status and dimension ranges
  - **For special items RM**: Display standard quantity-based inventory (no dimensions)
  - Route to appropriate display based on `track_by_dimensions` flag
  - _Requirements: 6.2, 6.3, 6.4, 13.6_

- [ ] 9.5 Update production interface for dimension allocation
  - Show available pieces with dimensions during production planning
  - Display waste piece suggestions
  - Show cutting operation results and waste creation
  - _Requirements: 3.2, 5.3_

- [ ] 9.6 Write frontend integration tests
  - Test form submissions with dimension data
  - Test UI updates and validation displays
  - _Requirements: Frontend requirements_

- [ ] 10. Data Migration and Validation
  - Create migration scripts for existing RM inventory
  - Implement data validation and cleanup
  - Add migration rollback capabilities
  - _Requirements: Migration strategy_

- [ ] 10.1 Create data migration script for existing RM products
  - Identify dimension-based RM products (fabric, leather, etc.) and set track_by_dimensions = TRUE
  - Identify special items RM products (zippers, buttons, etc.) and set track_by_dimensions = FALSE
  - Add default unit_of_measure values for dimension-based RM
  - Validate existing RM inventory data
  - **Add migration strategy**: How to distinguish between dimension-based and special items RM
  - _Requirements: 8.1, 13.2_

- [ ] 10.2 Implement RM inventory conversion strategy
  - Create conversion options for existing quantity-based RM inventory
  - Add manual dimension entry interface for existing stock
  - Implement validation for converted inventory data
  - _Requirements: Migration strategy_

- [ ] 10.3 Write migration validation tests
  - Test data integrity after migration
  - Test rollback capabilities
  - _Requirements: Migration validation_

- [ ] 11. Performance Optimization and Indexing
  - Optimize database queries for dimension-based operations
  - Add caching for frequently accessed calculations
  - Implement efficient reporting queries
  - _Requirements: Performance requirements_

- [ ] 11.1 Optimize inventory calculation queries
  - Add composite indexes for dimension-based queries
  - Implement query optimization for large inventories
  - Add caching for inventory summary calculations
  - _Requirements: 6.2, 6.3_

- [ ] 11.2 Optimize material allocation performance
  - Add indexes for allocation algorithm queries
  - Implement efficient waste piece matching
  - Add query optimization for production planning
  - _Requirements: 3.1, 5.1_

- [ ] 11.3 Write performance tests
  - Test query performance with large datasets
  - Test concurrent allocation operations
  - _Requirements: Performance validation_

- [ ] 12. Final Integration and Testing
  - Complete end-to-end testing of dimension-based workflows
  - Validate all correctness properties
  - Perform user acceptance testing scenarios
  - _Requirements: All requirements_

- [ ] 12.1 Complete end-to-end workflow testing
  - Test complete GRN → BOM → Production → Waste cycle
  - Test multiple dimension scenarios with waste reuse
  - Validate all business rules and constraints
  - _Requirements: All workflow requirements_

- [ ] 12.2 Run comprehensive property test suite
  - Execute all 18 correctness properties with 100+ iterations each
  - Validate system behavior across all input ranges
  - **Feature: dimension-based-inventory, All Properties**

- [ ] 12.3 Perform user acceptance testing
  - Test real-world clothing manufacturing scenarios
  - Validate waste optimization and cost savings
  - Test system performance under realistic loads
  - _Requirements: All user stories_

- [ ] 13. Final checkpoint - Ensure all tests pass
  - Ensure all tests pass, ask the user if questions arise.

## Notes

- All tasks are now required for comprehensive implementation from the start
- Each task references specific requirements for traceability
- Checkpoints ensure incremental validation throughout development
- Property tests validate universal correctness properties with 100+ iterations
- Unit tests validate specific examples and edge cases
- The implementation maintains backward compatibility for FG products while adding RM dimension tracking

## Important: Special Items RM Support

**Critical Update**: The system must support two types of RM products:
1. **Dimension-Based RM**: Fabric, leather, etc. - tracked by length × width (mandatory dimensions)
2. **Special Items RM**: Zippers, buttons, threads, snaps, labels, tags, etc. - tracked by quantity (no dimensions)

**Key Requirements**:
- Special items RM use `track_by_dimensions = FALSE` (quantity-based tracking)
- Special items RM use standard inventory tracking (`inventories.quantity`), not `rm_inventory_pieces`
- Special items RM in BOMs use `use_dimensions = FALSE` with `quantity_per_unit`
- Special items RM in production use standard quantity-based inventory consumption
- Mixed BOMs must support both dimension-based RM and special items RM together

**Implementation Impact**:
- Product model must distinguish between dimension-based RM and special items RM
- GRN processing must handle both types appropriately
- BOM validation must support both dimension-based and quantity-based RM items
- Production allocation must handle both types in the same production order
- Inventory queries must route to correct tables based on `track_by_dimensions` flag