# Requirements Document

## Introduction

This specification defines the requirements for implementing a dimension-based inventory system for Raw Materials (RM) in the clothing manufacturing POS system. The system will track materials by physical dimensions (length × width) with units of measure, manage waste and reusable pieces, and support cutting operations that generate both finished goods and waste materials.

## Glossary

- **RM**: Raw Materials - fabric, leather, or other materials used in clothing production
- **Dimension-Based RM**: RM products that are tracked by dimensions (length × width) - e.g., fabric, leather
- **Special Items RM**: RM products that are tracked by quantity (not dimensions) - e.g., zippers, buttons, threads, snaps, labels, tags
- **FG**: Finished Goods - completed products ready for sale
- **BOM**: Bill of Materials - recipe defining what RM is needed to produce FG
- **GRN**: Goods Receipt Note - document recording received materials
- **Dimension_Piece**: Individual piece of dimension-based RM with specific length × width dimensions
- **Cutting_Operation**: Production process that cuts RM pieces to create FG and waste
- **Waste_Piece**: Leftover material from cutting that can potentially be reused
- **Scrap**: Material too small or damaged to be useful (to be written off)
- **Unit_of_Measure**: Measurement unit (inches, cm, meters) for dimensions

## Requirements

### Requirement 1: Dimension-Based Procurement

**User Story:** As a procurement manager, I want to receive Raw Materials by dimensions and quantity, so that I can accurately track fabric pieces with their actual sizes.

#### Acceptance Criteria

1. WHEN receiving dimension-based RM through GRN, THE System SHALL require piece dimensions (length × width) and unit of measure
2. WHEN the same dimension-based RM product is received in different dimensions, THE System SHALL create separate inventory pieces for each dimension set
3. WHEN processing a GRN with dimension-based RM items, THE System SHALL create individual rm_inventory_pieces records for each physical piece
4. WHEN dimension-based RM products are received without dimensions, THE System SHALL reject the GRN and display validation error
5. THE System SHALL support multiple units of measure: inches, cm, and meters for each piece
6. WHEN calculating total area, THE System SHALL multiply length × width × pieces_count for cost allocation
7. WHEN receiving special items RM (zippers, buttons, etc.), THE System SHALL use standard quantity-based GRN processing (no dimensions required)

### Requirement 2: Dimension-Based BOM Definition

**User Story:** As a production manager, I want to define BOM requirements by dimensions, so that I can specify exactly what size fabric pieces are needed for each garment.

#### Acceptance Criteria

1. WHEN creating BOM items for dimension-based RM products, THE System SHALL require dimension specifications (required_length × required_width)
2. WHEN dimension-based RM products are added to BOM without dimensions, THE System SHALL reject the BOM item and display validation error
3. THE System SHALL validate that BOM dimension units match available material piece units
4. WHEN calculating material requirements, THE System SHALL multiply required dimensions by production quantity
5. WHEN creating BOM items for special items RM (zippers, buttons, etc.), THE System SHALL require quantity_per_unit (not dimensions)
6. THE System SHALL support mixed BOM items (dimension-based for fabric RM, quantity-based for special items RM and other materials)

### Requirement 3: Intelligent Material Allocation

**User Story:** As a production operator, I want the system to automatically find suitable material pieces for production, so that I can efficiently use available materials including waste pieces.

#### Acceptance Criteria

1. WHEN confirming production orders, THE System SHALL find dimension-based RM pieces where usable dimensions meet or exceed BOM requirements
2. THE System SHALL prioritize material allocation in order: FULL pieces, then USABLE pieces, then WASTE pieces
3. WHEN waste pieces have sufficient dimensions, THE System SHALL suggest them for allocation before using new materials
4. WHEN no pieces meet dimension requirements, THE System SHALL reject production and suggest maximum producible quantity
5. THE System SHALL perform automatic unit conversion between inches, cm, and meters when matching pieces to requirements
6. WHEN allocating special items RM (zippers, buttons, etc.), THE System SHALL use standard quantity-based inventory allocation (check quantity availability, consume by quantity)

### Requirement 4: Cutting Operations and Waste Tracking

**User Story:** As a production operator, I want to record cutting operations and track resulting waste, so that leftover materials can be reused for other products.

#### Acceptance Criteria

1. WHEN confirming production that uses RM, THE System SHALL create cutting operation records with cut dimensions
2. WHEN a piece is partially cut, THE System SHALL update usable dimensions and set status to USABLE
3. WHEN cutting creates reusable leftover pieces, THE System SHALL create new waste pieces with status WASTE
4. WHEN remaining material is too small to be useful, THE System SHALL mark dimensions as SCRAP
5. THE System SHALL track the complete cutting history for each original material piece

### Requirement 5: Waste Reuse Management

**User Story:** As a production manager, I want to reuse waste materials from previous production runs, so that I can minimize material costs and reduce waste.

#### Acceptance Criteria

1. WHEN allocating materials for production, THE System SHALL check waste pieces first if their dimensions are sufficient
2. WHEN waste pieces are allocated to production, THE System SHALL change their status from WASTE to USABLE
3. THE System SHALL suggest available waste pieces that match BOM requirements during production planning
4. WHEN waste pieces are used in production, THE System SHALL track which original GRN they came from
5. THE System SHALL prevent allocation of SCRAP pieces to any production orders

### Requirement 6: RM Inventory Tracking Without UUIDs

**User Story:** As an inventory manager, I want to track RM inventory by dimensions and quantities, so that I can see available materials without individual UUID tracking.

#### Acceptance Criteria

1. THE System SHALL track dimension-based RM inventory by piece count, not individual UUIDs like Finished Goods
2. WHEN querying dimension-based RM inventory, THE System SHALL return total pieces count grouped by status (FULL, USABLE, WASTE, SCRAP)
3. THE System SHALL calculate and display total areas: full area, usable area, waste area, and scrap area
4. WHEN displaying inventory, THE System SHALL show all dimension variations for the same dimension-based RM product
5. THE System SHALL provide inventory summary with piece counts and total areas per dimension-based RM product
6. THE System SHALL track special items RM inventory using standard quantity-based inventory (inventories.quantity), not dimensions

### Requirement 7: Multiple Dimension Scenarios Support

**User Story:** As a procurement manager, I want to receive the same fabric product in different dimensions, so that I can handle various supplier deliveries efficiently.

#### Acceptance Criteria

1. WHEN receiving "Cotton Fabric" in multiple dimensions (2m×2m×5pcs, 3m×3m×3pcs, 6m×6m×2pcs), THE System SHALL create separate inventory pieces for each dimension set
2. THE System SHALL track each dimension set independently while linking them to the same product
3. WHEN viewing inventory, THE System SHALL display all dimension variations with their respective quantities
4. THE System SHALL allow production to use any dimension variation that meets BOM requirements
5. THE System SHALL maintain separate piece numbering for each dimension set within the same GRN

### Requirement 8: Mandatory Dimension Enforcement for RM

**User Story:** As a system administrator, I want to enforce dimension-based tracking for dimension-based RM products, so that there are no shortcuts that could compromise inventory accuracy.

#### Acceptance Criteria

1. WHEN creating dimension-based RM products (fabric, leather, etc.), THE System SHALL automatically set track_by_dimensions to TRUE and prevent disabling
2. WHEN creating special items RM products (zippers, buttons, etc.), THE System SHALL set track_by_dimensions to FALSE (quantity-based tracking)
3. WHEN processing GRN for dimension-based RM products, THE System SHALL reject items without piece_length, piece_width, and dimension_unit
4. WHEN processing GRN for special items RM, THE System SHALL use standard quantity-based processing (no dimensions required)
5. WHEN creating BOM items for dimension-based RM products, THE System SHALL require use_dimensions to be TRUE with dimension specifications
6. WHEN creating BOM items for special items RM, THE System SHALL require use_dimensions to be FALSE with quantity_per_unit
7. WHEN confirming production with dimension-based RM materials, THE System SHALL use only dimension-based allocation algorithms
8. WHEN confirming production with special items RM, THE System SHALL use standard quantity-based inventory consumption
9. THE System SHALL prevent any quantity-based operations for dimension-based RM products in procurement, BOM, or production
10. THE System SHALL allow quantity-based operations for special items RM products (standard inventory tracking)

### Requirement 9: Unit Conversion and Validation

**User Story:** As a production operator, I want the system to handle different units of measure, so that I can work with materials specified in various units.

#### Acceptance Criteria

1. WHEN matching BOM requirements to available pieces, THE System SHALL convert between inches, cm, and meters automatically
2. THE System SHALL validate that converted dimensions maintain accuracy to 3 decimal places
3. WHEN displaying dimensions, THE System SHALL show values in the unit specified for each piece
4. THE System SHALL support fractional dimensions (e.g., 1.5m, 2.25 inches)
5. THE System SHALL prevent invalid unit combinations and display appropriate error messages

### Requirement 10: Scrap Management and Write-off

**User Story:** As an inventory manager, I want to manage scrap materials and write them off, so that inventory reflects only usable materials.

#### Acceptance Criteria

1. WHEN material pieces become too small or damaged, THE System SHALL allow marking dimensions as SCRAP
2. THE System SHALL track scrap dimensions separately from usable dimensions for each piece
3. WHEN writing off scrap materials, THE System SHALL remove scrap dimensions from inventory calculations
4. THE System SHALL maintain audit trail of all scrap write-off operations
5. THE System SHALL prevent production allocation of materials marked as SCRAP

### Requirement 11: Production Size Reduction Operations

**User Story:** As a production operator, I want to record when production reduces material size, so that remaining materials are properly tracked for future use.

#### Acceptance Criteria

1. WHEN production cuts material pieces, THE System SHALL record the exact dimensions cut from each piece
2. WHEN cutting results in remaining usable material, THE System SHALL update the piece's usable dimensions
3. WHEN cutting creates multiple waste pieces, THE System SHALL create separate waste piece records
4. THE System SHALL link all resulting pieces back to the original cutting operation
5. THE System SHALL calculate and track material utilization efficiency for each cutting operation

### Requirement 12: Inventory Reporting and Analytics

**User Story:** As a production manager, I want to see material utilization reports, so that I can optimize cutting patterns and reduce waste.

#### Acceptance Criteria

1. THE System SHALL generate reports showing material utilization percentages by product and time period
2. THE System SHALL display waste generation rates and reuse statistics
3. WHEN viewing dimension-based RM inventory, THE System SHALL show aging of waste pieces to prioritize usage
4. THE System SHALL provide alerts when waste pieces are suitable for pending production orders
5. THE System SHALL track cost savings from waste reuse compared to purchasing new materials

### Requirement 13: Special Items RM Support

**User Story:** As a production manager, I need to include special items like zippers, buttons, and threads in BOMs and track their inventory, so that complete garments can be produced with all required components.

#### Acceptance Criteria

1. THE System SHALL support RM products that are tracked by quantity (not dimensions) - e.g., zippers, buttons, snaps, threads, labels, tags
2. WHEN creating special items RM products, THE System SHALL set track_by_dimensions to FALSE (quantity-based tracking)
3. WHEN processing GRN for special items RM, THE System SHALL use standard quantity-based inventory processing (no dimensions required)
4. WHEN creating BOM items for special items RM, THE System SHALL require quantity_per_unit (not dimensions)
5. WHEN allocating special items RM for production, THE System SHALL use standard quantity-based inventory consumption
6. THE System SHALL track special items RM inventory using standard inventories.quantity (not rm_inventory_pieces)
7. THE System SHALL support mixed BOMs containing both dimension-based RM (fabric) and special items RM (zippers, buttons)
8. THE System SHALL allow complete garment production using both dimension-based and quantity-based RM materials