/**
 * Health Check Endpoint Tests
 * Unit tests for health check functionality
 */

// Import request library for API testing
const request = require('supertest');
// Import Express application
// Note: app.js exports the Express app instance
const app = require('../../app');

/**
 * Health Check Tests
 */
describe('Health Check Endpoint', () => {
  // Test GET /api/health endpoint
  test('GET /api/health should return 200 with success message', async () => {
    // Make GET request to health endpoint
    const response = await request(app)
      .get('/api/health')
      .expect(200); // Expect HTTP 200 status
    
    // Verify response structure
    expect(response.body).toHaveProperty('success'); // Response should have success property
    expect(response.body.success).toBe(true); // Success should be true
    expect(response.body).toHaveProperty('message'); // Response should have message property
    expect(response.body.message).toBe('API is running'); // Message should match expected
    expect(response.body).toHaveProperty('timestamp'); // Response should have timestamp
  });
  
  // Test GET /api/version endpoint
  test('GET /api/version should return version information', async () => {
    // Make GET request to version endpoint
    const response = await request(app)
      .get('/api/version')
      .expect(200); // Expect HTTP 200 status
    
    // Verify response structure
    expect(response.body).toHaveProperty('success'); // Response should have success property
    expect(response.body.success).toBe(true); // Success should be true
    expect(response.body).toHaveProperty('version'); // Response should have version property
    expect(response.body).toHaveProperty('name'); // Response should have name property
  });
  
  // Test GET / (root) endpoint
  test('GET / should return welcome message', async () => {
    // Make GET request to root endpoint
    const response = await request(app)
      .get('/')
      .expect(200); // Expect HTTP 200 status
    
    // Verify response structure
    expect(response.body).toHaveProperty('success'); // Response should have success property
    expect(response.body.success).toBe(true); // Success should be true
    expect(response.body).toHaveProperty('message'); // Response should have message property
  });
});

