/**
 * Product Test Fixtures
 * Test data for product-related tests
 */

// Test products fixtures
const testProducts = {
  // Finished good product
  finishedGood: {
    name: 'Test Product', // Product name
    sku: 'TEST-PROD-001', // SKU
    product_type: 'FG', // Product type (Finished Good)
    default_vat_rate: 16.0, // Default VAT rate (16%)
    track_inventory: true, // Track inventory
    active: true, // Active status
  },
  
  // Raw material product
  rawMaterial: {
    name: 'Test Raw Material', // Product name
    sku: 'TEST-RM-001', // SKU
    product_type: 'RM', // Product type (Raw Material)
    default_vat_rate: 16.0, // Default VAT rate (16%)
    track_inventory: true, // Track inventory
    active: true, // Active status
  },
  
  // Product without inventory tracking
  noInventory: {
    name: 'Test Service', // Product name
    sku: 'TEST-SVC-001', // SKU
    product_type: 'FG', // Product type
    default_vat_rate: 0.0, // No VAT
    track_inventory: false, // Don't track inventory
    active: true, // Active status
  },
};

// Export fixtures
module.exports = {
  testProducts,
};

