/**
 * Category Seeder
 * Creates default product categories
 */

/**
 * Seed categories into database
 * @param {Object} db - Database models object
 */
const seedCategories = async (db) => {
  // Import Category model
  const { Category } = db;
  
  // Check if categories already exist
  const existingCategories = await Category.findAll();
  
  // If categories already exist, skip seeding
  if (existingCategories.length > 0) {
    console.log('⚠️  Categories already exist. Skipping category seeding.');
    return; // Exit function
  }
  
  // Create root categories (parent_id = null)
  const electronics = await Category.create({
    name: 'Electronics', // Category name
    slug: 'electronics', // URL-friendly slug
    parent_id: null, // Root category (no parent)
    description: 'Electronic products and devices', // Description
    sort_order: 1, // Sort order
    active: true, // Active status
  });
  console.log('✅ Created category: Electronics');
  
  const clothing = await Category.create({
    name: 'Clothing', // Category name
    slug: 'clothing', // URL-friendly slug
    parent_id: null, // Root category (no parent)
    description: 'Clothing and apparel', // Description
    sort_order: 2, // Sort order
    active: true, // Active status
  });
  console.log('✅ Created category: Clothing');
  
  const food = await Category.create({
    name: 'Food & Beverages', // Category name
    slug: 'food-beverages', // URL-friendly slug
    parent_id: null, // Root category (no parent)
    description: 'Food and beverage products', // Description
    sort_order: 3, // Sort order
    active: true, // Active status
  });
  console.log('✅ Created category: Food & Beverages');
  
  // Create sub-categories (child categories)
  await Category.create({
    name: 'Phones', // Category name
    slug: 'phones', // URL-friendly slug
    parent_id: electronics.id, // Parent is Electronics
    description: 'Mobile phones and smartphones', // Description
    sort_order: 1, // Sort order
    active: true, // Active status
  });
  console.log('✅ Created category: Phones (under Electronics)');
  
  await Category.create({
    name: 'Laptops', // Category name
    slug: 'laptops', // URL-friendly slug
    parent_id: electronics.id, // Parent is Electronics
    description: 'Laptop computers', // Description
    sort_order: 2, // Sort order
    active: true, // Active status
  });
  console.log('✅ Created category: Laptops (under Electronics)');
  
  console.log('✅ Category seeding completed!');
};

// Export seed function
module.exports = seedCategories;

