-- Migration: Allow NULL inventory_item_id in return_items table
-- Description: This migration updates the return_items table to allow NULL values for inventory_item_id
--              to support quantity-based returns (where items are not UID-tracked).
-- Date: 2026-01-19

-- Allow inventory_item_id to be NULL in return_items table
-- This enables quantity-based returns where items don't have specific inventory_item_ids
ALTER TABLE `return_items`
MODIFY COLUMN `inventory_item_id` BIGINT NULL;

-- Update the foreign key constraint to allow NULL values
-- MySQL automatically handles this when the column is modified to allow NULL
-- The foreign key constraint will remain but will not be enforced for NULL values
