-- Add selling_price column to products table
-- This provides a simple default price that can be used as a fallback
-- when price list prices aren't available

ALTER TABLE `products`
ADD COLUMN `selling_price` DECIMAL(12, 2) DEFAULT NULL
AFTER `sell_on_pos`;

-- Add index for faster price lookups (optional, but helpful)
CREATE INDEX `idx_products_selling_price` ON `products` (`selling_price`);
