/**
 * Procurement Services
 * Main export for all procurement services
 */

// Import vendor service
const vendorService = require('./vendors');
// Import purchase order service
const purchaseOrderService = require('./purchaseOrders');
// Import GRN service
const grnService = require('./grns');

// Export all procurement services
module.exports = {
  // Vendor services
  createVendor: vendorService.createVendor,
  getVendor: vendorService.getVendor,
  updateVendor: vendorService.updateVendor,
  deleteVendor: vendorService.deleteVendor,
  listVendors: vendorService.listVendors,
  // Purchase order services
  createPurchaseOrder: purchaseOrderService.createPurchaseOrder,
  getPurchaseOrder: purchaseOrderService.getPurchaseOrder,
  updatePurchaseOrder: purchaseOrderService.updatePurchaseOrder,
  deletePurchaseOrder: purchaseOrderService.deletePurchaseOrder,
  listPurchaseOrders: purchaseOrderService.listPurchaseOrders,
  updatePurchaseOrderStatus: purchaseOrderService.updatePurchaseOrderStatus,
  // GRN services
  createGRN: grnService.createGRN,
  getGRN: grnService.getGRN,
  listGRNs: grnService.listGRNs,
  processGRN: grnService.processGRN,
};
