/**
 * Label Printing Services
 * Main export for all label printing services
 */

// Import ZPL generator service
const zplGenerator = require('./zplGenerator');
// Import printer service
const printerService = require('./printer');
// Import label printing service
const labelPrinting = require('./labelPrinting');

// Export all services
module.exports = {
  // ZPL generation
  generateZPLTemplate: zplGenerator.generateZPLTemplate,
  generateZPLTemplateWithImage: zplGenerator.generateZPLTemplateWithImage,
  // Printer communication
  printToNetwork: printerService.printToNetwork,
  printToUSB: printerService.printToUSB,
  printLabel: printerService.printLabel,
  // Label printing (high-level)
  printInventoryItemLabel: labelPrinting.printInventoryItemLabel,
  printProductLabel: labelPrinting.printProductLabel,
  generateLabelPreview: labelPrinting.generateLabelPreview,
  generateBatchInventoryItemZPL: labelPrinting.generateBatchInventoryItemZPL,
};
