/**
 * Discount Services
 * Main export for all discount services
 */

// Import discount service
const discountService = require('./discounts');
// Import discount rule service
const discountRuleService = require('./discountRules');
// Import discount calculation service
const discountCalculationService = require('./discountCalculation');

// Export all discount services
module.exports = {
  // Discount services
  createDiscount: discountService.createDiscount,
  getDiscount: discountService.getDiscount,
  getDiscountByCode: discountService.getDiscountByCode,
  getDiscountsForProduct: discountService.getDiscountsForProduct,
  updateDiscount: discountService.updateDiscount,
  deleteDiscount: discountService.deleteDiscount,
  listDiscounts: discountService.listDiscounts,
  // Discount rule services
  createDiscountRule: discountRuleService.createDiscountRule,
  getDiscountRule: discountRuleService.getDiscountRule,
  updateDiscountRule: discountRuleService.updateDiscountRule,
  deleteDiscountRule: discountRuleService.deleteDiscountRule,
  listDiscountRules: discountRuleService.listDiscountRules,
  // Discount calculation services
  validateDiscount: discountCalculationService.validateDiscount,
  applyDiscount: discountCalculationService.applyDiscount,
  calculateDiscountAmount: discountCalculationService.calculateDiscountAmount,
};

