# Production Order Dimension-Based Availability Test

## Overview
This test script validates the production order availability checking and confirmation process for dimension-based materials.

## Usage

### Test a specific production order:
```bash
node server/test-production-dimension-availability.js [production_order_id]
```

### Test with default production order (ID: 2):
```bash
node server/test-production-dimension-availability.js
```

## What it tests

1. **Production Order Details**: Verifies the production order exists and retrieves its details
2. **BOM Retrieval**: Gets the Bill of Materials for the finished good product
3. **Inventory Pieces**: Checks available inventory pieces for dimension-based items
4. **BOM Feasibility**: Tests the BOM feasibility check service
5. **Availability Check**: Tests the production service availability check endpoint
6. **Material Allocation**: Tests material allocation for each BOM item

## Output

The script provides detailed output including:
- ✅ Success indicators (green)
- ❌ Error indicators (red)
- ⚠️  Warning indicators (yellow)
- Detailed JSON output for each test step

## Example Output

```
================================================================================
TEST 1: Get Production Order Details
================================================================================
✅ Production Order 2 found
{
  "id": 2,
  "fg_product_id": 4,
  "quantity": "10.000",
  ...
}
```

## Troubleshooting

If tests fail:
1. Check that the production order exists
2. Verify the BOM is properly configured
3. Ensure inventory pieces exist for dimension-based materials
4. Check that dimension units match between BOM items and inventory pieces
5. Review error messages in the output for specific issues
