# XYZ POS Local Print Service

Windows executable service for detecting label printers and printing ZPL labels.

## Features

- ✅ **Auto-detects label printers** (Zebra, Honeywell, TSC, Intermec, Datamax, etc.)
- ✅ **Direct ZPL printing** to Windows printers
- ✅ **REST API** for web application integration
- ✅ **Background service** - runs quietly in system tray
- ✅ **No installation required** - standalone .exe file
- ✅ **Windows compatible** - works with all Windows versions

## Quick Start

### Option 1: Run from Source (Development)

1. Install Node.js 18+ on Windows
2. Navigate to this directory:
   ```bash
   cd local-print-service
   ```
3. Install dependencies:
   ```bash
   npm install
   ```
4. Run the service:
   ```bash
   npm start
   ```

The service will start on `http://localhost:9101`

### Option 2: Build Executable (.exe)

1. Build the executable:
   ```bash
   npm run build:win
   ```

2. The `.exe` file will be in the `dist/` directory

3. Run the `.exe` file - no Node.js installation needed!

### Option 3: Use Pre-built Executable

Download the pre-built `.exe` from releases and run it directly.

## API Endpoints

### Health Check
```http
GET /health
```

**Response:**
```json
{
  "status": "ok",
  "service": "xyz-pos-print-service",
  "version": "1.0.0",
  "timestamp": "2026-01-14T12:00:00.000Z"
}
```

### Get Printers
```http
GET /printers
```

**Response:**
```json
{
  "success": true,
  "printers": [
    {
      "id": "printer-0-1234567890",
      "name": "Zebra ZD420",
      "driver": "ZDesigner ZD420-203dpi ZPL",
      "port": "USB001",
      "type": "label",
      "brand": "Zebra",
      "description": "Zebra Label Printer"
    }
  ],
  "count": 1
}
```

### Print ZPL
```http
POST /print
Content-Type: application/json

{
  "printer": "Zebra ZD420",
  "zpl": "^XA^FO10,10^A0N,20,20^FDHello World^FS^XZ"
}
```

**Response:**
```json
{
  "success": true,
  "message": "ZPL sent to printer: Zebra ZD420",
  "printer": "Zebra ZD420",
  "method": "copy-command"
}
```

## Configuration

Set environment variables (optional):

- `PORT` - Service port (default: 9101)
- `HOST` - Service host (default: localhost)

## Running as Windows Service

### Using NSSM (Non-Sucking Service Manager)

1. Download NSSM from https://nssm.cc/download
2. Install the service:
   ```bash
   nssm install XYZPOSPrintService "C:\path\to\xyz-pos-print-service.exe"
   ```
3. Start the service:
   ```bash
   nssm start XYZPOSPrintService
   ```

### Using Task Scheduler (Start on Boot)

1. Open Task Scheduler
2. Create Basic Task
3. Set trigger: "When the computer starts"
4. Set action: "Start a program"
5. Browse to the `.exe` file
6. Save and test

## Supported Printers

The service automatically detects:
- **Zebra** printers (all models)
- **Honeywell** printers (PC42d, PC43d, etc.)
- **TSC** printers (TTP series, etc.)
- **Intermec** printers
- **Datamax** printers
- **Sato** printers
- **Printronix** printers
- Any printer with ZPL support

## Troubleshooting

### Service won't start

1. Check if port 9101 is already in use:
   ```powershell
   netstat -ano | findstr :9101
   ```
2. Run as Administrator if needed
3. Check Windows Firewall - allow port 9101

### No printers detected

1. Verify printer drivers are installed
2. Check Windows Printers & Scanners settings
3. Ensure printer is not in "Offline" status

### Print fails

1. Verify printer name matches exactly (case-sensitive)
2. Check printer is not paused or offline
3. Try running service as Administrator
4. Check Windows Event Viewer for printer errors

### Web app can't connect

1. Verify service is running: `http://localhost:9101/health`
2. Check browser console for connection errors
3. Verify CORS is enabled (should be automatic)

## Build Instructions

### Prerequisites

- Node.js 18 or higher
- npm or yarn

### Build Commands

```bash
# Install dependencies
npm install

# Build for Windows 64-bit
npm run build:win

# Build for all platforms
npm run build:all
```

The compiled `.exe` will be in the `dist/` directory.

## Development

```bash
# Install dependencies
npm install

# Run in development mode
npm start

# Watch for changes (if using nodemon)
nodemon service.js
```

## License

ISC
