# Backend API Testing Guide - Special Items RM Support

## Prerequisites

1. **Start the Backend Server**
   ```bash
   cd server
   npm start
   # or for development
   npm run dev
   ```
   
   The server should run on port 4000 (default from .env)

2. **Verify Server is Running**
   ```bash
   curl http://localhost:4000/api/health
   ```

## Test Script

A comprehensive test script has been created: `server/test-special-items-rm-api.js`

### Running the Test

```bash
cd server
node test-special-items-rm-api.js
```

### What the Test Covers

The test script tests the complete workflow for special items RM support:

1. **Login** - Authenticate to get JWT token
2. **Create Special Items RM Product** - Create a zipper product (`track_by_dimensions = false`)
3. **Create Dimension-Based RM Product** - Create a fabric product (`track_by_dimensions = true`)
4. **Create Finished Good Product** - Create a garment product
5. **Create GRN with Special Items RM** - Receive zippers (quantity-based, no dimensions)
6. **Process GRN** - Process the GRN to add inventory
7. **Check Inventory** - Verify special items RM inventory
8. **Create BOM with Special Items RM** - Create BOM with zippers (quantity-based)
9. **Create Production Order** - Create production order for the garment
10. **Check Availability** - Check if materials are available
11. **Confirm Production** - Confirm production and consume materials

## Manual API Testing with cURL

If you prefer to test manually, here are sample cURL commands:

### 1. Login
```bash
TOKEN=$(curl -X POST http://localhost:4000/api/auth/login \
  -H "Content-Type: application/json" \
  -d '{"username":"admin","password":"admin123"}' \
  | jq -r '.data.token')
```

### 2. Create Special Items RM Product (Zipper)
```bash
curl -X POST http://localhost:4000/api/products \
  -H "Authorization: Bearer $TOKEN" \
  -H "Content-Type: application/json" \
  -d '{
    "name": "Metal Zipper",
    "sku": "ZIP-METAL-001",
    "product_type": "RM",
    "track_by_dimensions": false,
    "track_inventory": true,
    "description": "Metal zipper for garments"
  }'
```

### 3. Create GRN with Special Items RM
```bash
curl -X POST http://localhost:4000/api/procurement/grns \
  -H "Authorization: Bearer $TOKEN" \
  -H "Content-Type: application/json" \
  -d '{
    "received_at": "2026-01-13",
    "items": [
      {
        "product_id": 1,
        "quantity": 100,
        "unit_cost": 2.5
      }
    ]
  }'
```

### 4. Process GRN
```bash
curl -X POST http://localhost:4000/api/procurement/grns/1/process \
  -H "Authorization: Bearer $TOKEN" \
  -H "Content-Type: application/json"
```

### 5. Create BOM with Special Items RM
```bash
curl -X POST http://localhost:4000/api/production/boms \
  -H "Authorization: Bearer $TOKEN" \
  -H "Content-Type: application/json" \
  -d '{
    "fg_variant_id": 1,
    "items": [
      {
        "rm_product_id": 1,
        "quantity_per_unit": 1,
        "use_dimensions": false
      }
    ]
  }'
```

## Expected Test Results

When the server is running and tests pass, you should see:

```
✅ Login successful
✅ Special items RM product created: <id>
✅ GRN created with special items RM: <id>
✅ GRN processed successfully
✅ BOM created with special items RM: <id>
✅ Production order created: <id>
✅ Production confirmed
```

## Key Test Points

1. **Product Creation**: Special items RM should have `track_by_dimensions = false`
2. **GRN Processing**: Special items RM should use quantity-based inventory (not dimensions)
3. **BOM Creation**: Special items RM should use `quantity_per_unit` (not dimensions)
4. **Production**: Special items RM should be consumed by quantity (not dimensions)

## Troubleshooting

1. **Server Not Running**: Start the server with `npm start` in the server directory
2. **Port Already in Use**: Check if port 4000 is available, or update PORT in .env
3. **Authentication Errors**: Ensure you have a valid user account (default: admin/admin123)
4. **Database Errors**: Ensure MySQL is running and database is accessible

## Next Steps After Testing

Once backend APIs are verified:
1. Update frontend forms to support special items RM
2. Test complete workflow through UI
3. Perform integration testing
4. User acceptance testing
