# Raw Materials (RM) Products Procurement Guide

## Understanding RM Product Types

Based on your BOM table, you have two types of RM products:

### 1. **Dimension-Based RM Products** (tracked by dimensions)
These need to be tracked by **length × width** (in meters):
- **Fabric**: Schiffon, Linen, Cotton, Satin, Cotton Linen blend, Cotton Shirting
- **Lining**: Various lining fabrics

**Product Setup:**
- `product_type`: `RM`
- `track_by_dimensions`: `true`
- `unit_of_measure`: `m` (meters)

### 2. **Quantity-Based RM Products** (special items)
These are tracked by **quantity** only:
- **Buttons**: "15", "5", "7"
- **Zipper**: "1" (each zipper)
- **Elastic**: "1" (each elastic)

**Product Setup:**
- `product_type`: `RM`
- `track_by_dimensions`: `false`
- `unit_of_measure`: `null` (not needed)

---

## Step-by-Step: How to Buy RM Products

### Step 1: Create RM Products in the System

First, you need to create RM products for each material you'll be buying.

**Example - Dimension-Based RM (Fabric):**
```
Product Name: "Schiffon"
Product Type: RM
Track by Dimensions: Yes
Unit of Measure: m (meters)
```

**Example - Quantity-Based RM (Buttons):**
```
Product Name: "Buttons"
Product Type: RM
Track by Dimensions: No
```

**Create these products:**
- Schiffon (dimension-based)
- Linen (dimension-based)
- Cotton (dimension-based)
- Satin (dimension-based)
- Cotton Linen blend (dimension-based)
- Cotton Shirting (dimension-based)
- Lining (dimension-based)
- Buttons (quantity-based)
- Zipper (quantity-based)
- Elastic (quantity-based)

### Step 2: Create Purchase Order (PO)

When creating a PO, you **order products by quantity** - dimensions are NOT needed yet.

**Example PO:**
```json
{
  "vendor_id": 1,
  "items": [
    {
      "product_id": 10,  // Schiffon fabric
      "quantity": 10,    // Order 10 pieces/rolls
      "unit_cost": 500.00
    },
    {
      "product_id": 11,  // Linen fabric
      "quantity": 5,     // Order 5 pieces/rolls
      "unit_cost": 600.00
    },
    {
      "product_id": 20,  // Buttons
      "quantity": 100,   // Order 100 buttons
      "unit_cost": 2.00
    },
    {
      "product_id": 21,  // Zipper
      "quantity": 50,    // Order 50 zippers
      "unit_cost": 15.00
    }
  ]
}
```

**Key Points:**
- ✅ No dimensions needed in PO
- ✅ Just specify quantity (e.g., 10 pieces of fabric, 100 buttons)
- ✅ Actual dimensions are unknown when ordering

### Step 3: Receive Goods via GRN

When goods arrive, you create a **GRN** (Goods Receipt Note) and **record actual dimensions**.

**For Dimension-Based RM (Fabric, Lining):**

Example: Receiving 10 pieces of Schiffon fabric

```json
{
  "purchase_order_id": 123,
  "items": [
    {
      "product_id": 10,  // Schiffon
      "quantity": 10,    // 10 pieces
      "unit_cost": 500.00,
      "piece_length": 3.0,    // Each piece is 3 meters long
      "piece_width": 1.5,     // Each piece is 1.5 meters wide
      "dimension_unit": "m",  // Meters
      "pieces_count": 10      // 10 pieces with these dimensions
    },
    {
      "product_id": 10,  // More Schiffon (different size)
      "quantity": 5,
      "unit_cost": 500.00,
      "piece_length": 2.5,    // Different size pieces
      "piece_width": 1.0,
      "dimension_unit": "m",
      "pieces_count": 5
    }
  ]
}
```

**For Quantity-Based RM (Buttons, Zipper, Elastic):**

```json
{
  "product_id": 20,  // Buttons
  "quantity": 100,   // Received 100 buttons
  "unit_cost": 2.00
  // No dimensions needed
}
```

**Key Points:**
- ✅ **Dimension-based RM**: Must provide `piece_length`, `piece_width`, `dimension_unit`, `pieces_count`
- ✅ **Quantity-based RM**: Only needs `quantity` (no dimensions)
- ✅ You can receive partial quantities (e.g., receive 5 out of 10 ordered pieces)

---

## Real-World Example

### Scenario: Buying Materials for "Wrap maxi" Dress

**BOM Requirements:**
- Fabric: Schiffon - 3 mtrs needed
- Lining: 1.5 mtrs needed

**Step 1: Create Products**
```
Product 1: "Schiffon" (RM, dimension-based, unit: m)
Product 2: "Lining Fabric" (RM, dimension-based, unit: m)
```

**Step 2: Create PO**
```
PO Item 1: Schiffon - Quantity: 10 pieces - Cost: $500/piece
PO Item 2: Lining Fabric - Quantity: 5 pieces - Cost: $300/piece
```

**Step 3: Receive via GRN**
```
GRN Item 1: Schiffon
  - Piece 1: 3m × 1.5m
  - Piece 2: 3m × 1.5m
  - Piece 3: 2.5m × 1m
  - ... (10 pieces total with various sizes)

GRN Item 2: Lining Fabric
  - Piece 1: 2m × 1m
  - Piece 2: 1.5m × 1m
  - ... (5 pieces total)
```

**Step 4: System Tracks Inventory**
- Each piece is stored with its dimensions
- When producing "Wrap maxi", system finds pieces ≥ 3m × required width

---

## Summary

1. **Create RM Products**: Define all your materials (fabric, buttons, etc.)
2. **Create PO**: Order by quantity only (no dimensions)
3. **Create GRN**: Record actual dimensions when goods arrive
4. **Production**: System automatically finds suitable pieces based on BOM requirements

The key insight: **You order fabric by "pieces" or "rolls", then record the actual dimensions of each piece when you receive them.**
