# Frontend UI Updates Plan - Special Items RM Support

## Overview

The frontend needs to be updated to support the new dimension-based inventory system with special items RM support. This includes forms for creating/editing products, GRNs, BOMs, and production orders.

---

## ✅ Current Status

**Backend:** Complete ✅
- Product model supports special items RM
- GRN processing handles special items RM
- BOM validation supports special items RM
- Production allocation supports special items RM

**Frontend:** Not Started ⏳
- Product forms need updates
- GRN forms need dimension fields
- BOM forms need dimension/quantity fields
- Production interface may need updates
- Inventory dashboard may need updates

---

## 📋 Frontend Tasks

### 1. Product Form Updates (Create & Edit)

**Files to Update:**
- `client/app/(dashboard)/products/new/page.jsx`
- `client/app/(dashboard)/products/[id]/edit/page.jsx`

**Changes Needed:**
- Add `track_by_dimensions` checkbox/toggle
- Add `unit_of_measure` dropdown (inch/cm/m)
- Show/hide fields based on `product_type`:
  - If `product_type = 'RM'`:
    - Show "Track by Dimensions" toggle
    - If `track_by_dimensions = true`: Show "Unit of Measure" dropdown (required)
    - If `track_by_dimensions = false`: Hide "Unit of Measure" (special items RM)
  - If `product_type = 'FG'`: Hide both fields

**Validation:**
- Dimension-based RM: `track_by_dimensions = true`, `unit_of_measure` required
- Special items RM: `track_by_dimensions = false`, `unit_of_measure` optional/null

**UI Design:**
```
Product Type: [RM ▼]
Track by Dimensions: [✓] (checkbox, auto-enabled for RM, can be unchecked for special items)
Unit of Measure: [m ▼] (shown only if track_by_dimensions = true)
  Options: inch, cm, m
```

---

### 2. GRN Form Updates (Create & Process)

**Files to Update:**
- `client/app/(dashboard)/procurement/grns/new/page.jsx`
- `client/app/(dashboard)/procurement/grns/[id]/page.jsx` (process GRN)

**Changes Needed:**
- Add dimension fields for dimension-based RM products:
  - `piece_length` (number)
  - `piece_width` (number)
  - `dimension_unit` (dropdown: inch/cm/m)
  - `pieces_count` (integer, default: 1)
- Show/hide dimension fields based on product's `track_by_dimensions`:
  - If `track_by_dimensions = true`: Show dimension fields (required)
  - If `track_by_dimensions = false`: Hide dimension fields (use quantity only)

**UI Design:**
```
For Dimension-Based RM (track_by_dimensions = true):
  Quantity: [5]
  Piece Length: [2.0] (meters)
  Piece Width: [3.0] (meters)
  Unit: [m ▼]
  Pieces Count: [5] (auto-calculated or manual)
  
For Special Items RM (track_by_dimensions = false):
  Quantity: [10] (standard quantity input)
  Unit Cost: [5.00]
```

---

### 3. BOM Form Updates (Create & Edit)

**Files to Update:**
- `client/app/(dashboard)/production/boms/new/page.jsx`
- `client/app/(dashboard)/production/boms/[id]/edit/page.jsx`

**Changes Needed:**
- Add dimension fields for dimension-based RM:
  - `use_dimensions` (toggle/checkbox)
  - `required_length` (number, shown if use_dimensions = true)
  - `required_width` (number, shown if use_dimensions = true)
  - `dimension_unit` (dropdown, shown if use_dimensions = true)
- Keep `quantity_per_unit` for special items RM
- Auto-set `use_dimensions` based on product's `track_by_dimensions`:
  - Dimension-based RM: `use_dimensions = true` (required dimensions)
  - Special items RM: `use_dimensions = false` (required quantity_per_unit)

**UI Design:**
```
For Dimension-Based RM (track_by_dimensions = true):
  Use Dimensions: [✓] (checked, disabled)
  Required Length: [2.0]
  Required Width: [1.5]
  Unit: [m ▼]
  
For Special Items RM (track_by_dimensions = false):
  Use Dimensions: [ ] (unchecked, disabled)
  Quantity per Unit: [6] (e.g., 6 buttons per garment)
```

---

### 4. Production Order Interface

**Files to Check:**
- `client/app/(dashboard)/production/orders/new/page.jsx`
- `client/app/(dashboard)/production/orders/[id]/page.jsx`

**Changes Needed:**
- Display material requirements clearly:
  - Dimension-based RM: Show dimensions and area requirements
  - Special items RM: Show quantity requirements
- Availability check results should show both types
- Material allocation preview should handle both types

**UI Design:**
```
Material Requirements:
  - Cotton Fabric (Dimension-based): 2m × 1.5m per unit
  - Zipper (Special Item): 1 per unit
  - Buttons (Special Item): 6 per unit
```

---

### 5. Inventory Dashboard

**Files to Check:**
- `client/app/(dashboard)/inventory/items/page.jsx`
- `client/app/(dashboard)/inventory/rm/page.jsx` (if exists)

**Changes Needed:**
- Show different views for:
  - Dimension-based RM: Show pieces with dimensions, areas, status
  - Special items RM: Show quantity-based inventory (standard view)
- Filter/tab between dimension-based and special items RM

---

## 🔄 Implementation Priority

1. **High Priority:**
   - Product form (create/edit) - Users need to create products correctly
   - GRN form (create) - Users need to receive materials with dimensions
   - BOM form (create/edit) - Users need to define material requirements

2. **Medium Priority:**
   - Production order interface - Display requirements clearly
   - Inventory dashboard - Show inventory correctly

3. **Low Priority:**
   - Process GRN page - May work but needs dimension display
   - Other inventory views

---

## 📝 API Requirements

The frontend will need to:
1. Fetch product details including `track_by_dimensions` and `unit_of_measure`
2. Send dimension fields in GRN creation/processing
3. Send dimension/quantity fields in BOM creation/editing
4. Display dimension and quantity information appropriately

---

## 🎨 UI/UX Considerations

1. **Progressive Disclosure:** Show/hide fields based on product type and tracking method
2. **Clear Labels:** Distinguish between dimension-based and quantity-based inputs
3. **Validation Messages:** Clear error messages for missing dimensions/quantities
4. **Help Text:** Tooltips explaining dimension-based vs. special items RM
5. **Visual Indicators:** Icons or badges to identify product tracking type

---

## ✅ Next Steps

1. Update product form to include dimension tracking fields
2. Update GRN form to handle dimension fields
3. Update BOM form to handle dimension/quantity fields
4. Test complete workflow in UI
5. Update production and inventory interfaces as needed
