mysqldump: [Warning] Using a password on the command line interface can be insecure.
-- MySQL dump 10.13  Distrib 8.4.7, for Linux (x86_64)
--
-- Host: localhost    Database: xyz_pos_db
-- ------------------------------------------------------
-- Server version	8.4.7-0ubuntu0.25.10.3

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `bom_items`
--

DROP TABLE IF EXISTS `bom_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `bom_items` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `bom_id` bigint NOT NULL,
  `rm_product_id` bigint NOT NULL,
  `quantity_per_unit` decimal(12,3) NOT NULL,
  `required_length` decimal(12,3) DEFAULT NULL COMMENT 'Required length per unit of FG product',
  `required_width` decimal(12,3) DEFAULT NULL COMMENT 'Required width per unit of FG product',
  `dimension_unit` enum('inch','cm','m') DEFAULT NULL COMMENT 'Unit of measure for dimension requirements',
  `use_dimensions` tinyint(1) DEFAULT '0' COMMENT 'Flag to enable dimension-based BOM (vs quantity-based)',
  PRIMARY KEY (`id`),
  KEY `bom_items_bom_id` (`bom_id`),
  KEY `bom_items_rm_product_id` (`rm_product_id`),
  KEY `idx_use_dimensions` (`use_dimensions`),
  KEY `idx_dimension_requirements` (`required_length`,`required_width`,`dimension_unit`),
  KEY `bom_items_use_dimensions` (`use_dimensions`),
  KEY `bom_items_required_length_required_width_dimension_unit` (`required_length`,`required_width`,`dimension_unit`),
  CONSTRAINT `bom_items_ibfk_5` FOREIGN KEY (`bom_id`) REFERENCES `boms` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `bom_items_ibfk_6` FOREIGN KEY (`rm_product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `chk_dimension_requirements` CHECK (((`use_dimensions` = false) or ((`use_dimensions` = true) and (`required_length` is not null) and (`required_width` is not null) and (`dimension_unit` is not null)))),
  CONSTRAINT `chk_positive_dimension_requirements` CHECK ((((`required_length` is null) or (`required_length` > 0)) and ((`required_width` is null) or (`required_width` > 0))))
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bom_items`
--

LOCK TABLES `bom_items` WRITE;
/*!40000 ALTER TABLE `bom_items` DISABLE KEYS */;
INSERT INTO `bom_items` VALUES (1,1,1,2.000,NULL,NULL,NULL,0),(2,1,2,1.000,NULL,NULL,NULL,0),(3,2,4,3.000,NULL,NULL,NULL,0),(4,2,5,1.000,NULL,NULL,NULL,0),(5,3,5,10.000,NULL,NULL,NULL,0),(6,3,4,13.000,NULL,NULL,NULL,0),(7,8,48,1.000,NULL,NULL,NULL,0),(8,9,51,1.000,NULL,NULL,NULL,0),(9,10,54,1.000,NULL,NULL,NULL,0),(11,11,57,1.000,NULL,NULL,NULL,0),(12,11,58,1.000,2.000,2.000,'m',1);
/*!40000 ALTER TABLE `bom_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `boms`
--

DROP TABLE IF EXISTS `boms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `boms` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `fg_variant_id` bigint NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `boms_fg_variant_id` (`fg_variant_id`),
  CONSTRAINT `boms_ibfk_1` FOREIGN KEY (`fg_variant_id`) REFERENCES `product_variants` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `boms`
--

LOCK TABLES `boms` WRITE;
/*!40000 ALTER TABLE `boms` DISABLE KEYS */;
INSERT INTO `boms` VALUES (1,1,'2025-12-18 15:25:17','2025-12-18 15:25:17'),(2,2,'2025-12-18 16:22:05','2025-12-18 16:22:05'),(3,3,'2026-01-08 12:18:24','2026-01-08 12:18:24'),(4,4,'2026-01-13 15:58:09','2026-01-13 15:58:09'),(5,5,'2026-01-13 16:48:54','2026-01-13 16:48:54'),(6,6,'2026-01-13 16:51:21','2026-01-13 16:51:21'),(7,7,'2026-01-13 16:51:30','2026-01-13 16:51:30'),(8,8,'2026-01-14 07:33:58','2026-01-14 07:33:58'),(9,9,'2026-01-14 07:34:13','2026-01-14 07:34:13'),(10,10,'2026-01-14 07:34:23','2026-01-14 07:34:23'),(11,11,'2026-01-14 07:37:54','2026-01-14 07:37:54');
/*!40000 ALTER TABLE `boms` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cash_counts`
--

DROP TABLE IF EXISTS `cash_counts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cash_counts` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `shift_id` bigint NOT NULL,
  `count_type` enum('OPENING','CLOSING','MID_SHIFT') NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `counted_at` datetime NOT NULL,
  `notes` text,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_counts_shift_id` (`shift_id`),
  KEY `cash_counts_count_type` (`count_type`),
  KEY `cash_counts_counted_at` (`counted_at`),
  CONSTRAINT `cash_counts_ibfk_1` FOREIGN KEY (`shift_id`) REFERENCES `shifts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cash_counts`
--

LOCK TABLES `cash_counts` WRITE;
/*!40000 ALTER TABLE `cash_counts` DISABLE KEYS */;
INSERT INTO `cash_counts` VALUES (1,1,'OPENING',10000.00,'2025-12-18 15:26:32','Opening cash count','2025-12-18 15:26:32','2025-12-18 15:26:32'),(2,1,'MID_SHIFT',15000.00,'2025-12-18 17:03:40','Mid-shift cash count','2025-12-18 17:03:40','2025-12-18 17:03:40');
/*!40000 ALTER TABLE `cash_counts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `slug` varchar(150) DEFAULT NULL,
  `parent_id` bigint DEFAULT NULL,
  `description` text,
  `image_url` varchar(255) DEFAULT NULL,
  `sort_order` int NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `slug` (`slug`),
  UNIQUE KEY `categories_slug` (`slug`),
  UNIQUE KEY `slug_2` (`slug`),
  UNIQUE KEY `slug_3` (`slug`),
  KEY `categories_parent_id` (`parent_id`),
  KEY `categories_active` (`active`),
  KEY `categories_sort_order` (`sort_order`),
  CONSTRAINT `categories_ibfk_1` FOREIGN KEY (`parent_id`) REFERENCES `categories` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Updated Womens Clothing','updated-womens-clothing',NULL,'Updated description',NULL,0,1,'2025-12-19 06:34:09','2025-12-29 13:53:17'),(2,'Dresses','dresses-1',NULL,'All types of dresses',NULL,0,1,'2025-12-19 06:35:56','2025-12-19 06:35:56'),(3,'Womens Clothing','womens-clothing',NULL,'Women clothing products',NULL,0,1,'2025-12-29 13:53:12','2025-12-29 13:53:12'),(4,'Mens Clothing','mens-clothing',NULL,'Men clothing products',NULL,0,1,'2025-12-29 13:53:13','2025-12-29 13:53:13'),(5,'Shirts','shirts',4,'Shirt category',NULL,0,1,'2025-12-29 13:53:13','2025-12-29 13:53:13'),(8,'T shirt','t-shirt',NULL,NULL,NULL,0,1,'2026-01-08 07:23:28','2026-01-08 07:23:28');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `customer_type` enum('B2C','B2B') NOT NULL DEFAULT 'B2C',
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `kra_pin` varchar(20) DEFAULT NULL,
  `credit_limit` decimal(12,2) NOT NULL DEFAULT '0.00',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `price_list_id` bigint DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `price_list_id` (`price_list_id`),
  KEY `idx_customers_email` (`email`),
  KEY `idx_customers_phone` (`phone`),
  CONSTRAINT `customers_ibfk_1` FOREIGN KEY (`price_list_id`) REFERENCES `price_lists` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'Fashion Retailers Ltd','B2B',NULL,NULL,'P123456789A',500000.00,1,NULL,'2025-12-18 15:26:25','2025-12-18 15:26:25'),(2,'Fashion Retailers Ltd','B2B',NULL,NULL,'P123456789A',500000.00,1,NULL,'2025-12-18 16:18:39','2025-12-18 16:18:39'),(3,'Fashion Retailers Ltd','B2B',NULL,NULL,'P123456789A',600000.00,1,NULL,'2025-12-18 16:22:18','2025-12-19 06:33:53'),(4,'Test Delete Customer','B2C',NULL,NULL,NULL,0.00,0,NULL,'2025-12-29 14:10:35','2025-12-29 14:10:35'),(5,'Generic','B2C',NULL,NULL,NULL,0.00,1,3,'2026-01-09 06:54:38','2026-01-09 06:54:38');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `discount_rules`
--

DROP TABLE IF EXISTS `discount_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `discount_rules` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `discount_id` bigint NOT NULL,
  `rule_type` enum('PRODUCT','CATEGORY','CUSTOMER','ALL') NOT NULL,
  `product_id` bigint DEFAULT NULL,
  `category_id` bigint DEFAULT NULL,
  `customer_id` bigint DEFAULT NULL,
  `min_quantity` decimal(12,3) NOT NULL DEFAULT '1.000',
  PRIMARY KEY (`id`),
  KEY `discount_rules_discount_id` (`discount_id`),
  KEY `discount_rules_rule_type` (`rule_type`),
  KEY `discount_rules_product_id` (`product_id`),
  KEY `discount_rules_category_id` (`category_id`),
  KEY `discount_rules_customer_id` (`customer_id`),
  CONSTRAINT `discount_rules_ibfk_10` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `discount_rules_ibfk_11` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `discount_rules_ibfk_12` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `discount_rules_ibfk_9` FOREIGN KEY (`discount_id`) REFERENCES `discounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `discount_rules`
--

LOCK TABLES `discount_rules` WRITE;
/*!40000 ALTER TABLE `discount_rules` DISABLE KEYS */;
INSERT INTO `discount_rules` VALUES (1,1,'PRODUCT',6,NULL,NULL,1.000);
/*!40000 ALTER TABLE `discount_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `discounts`
--

DROP TABLE IF EXISTS `discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `discounts` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `code` varchar(50) DEFAULT NULL,
  `discount_type` enum('PERCENTAGE','FIXED_AMOUNT','BUY_X_GET_Y') NOT NULL,
  `discount_value` decimal(12,2) NOT NULL,
  `min_purchase_amount` decimal(12,2) NOT NULL DEFAULT '0.00',
  `max_discount_amount` decimal(12,2) DEFAULT NULL,
  `effective_from` datetime NOT NULL,
  `effective_to` datetime DEFAULT NULL,
  `max_uses_per_customer` int DEFAULT NULL,
  `max_total_uses` int DEFAULT NULL,
  `usage_count` int NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `description` text,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `discounts_code` (`code`),
  UNIQUE KEY `code_2` (`code`),
  UNIQUE KEY `code_3` (`code`),
  KEY `discounts_discount_type` (`discount_type`),
  KEY `discounts_effective_from` (`effective_from`),
  KEY `discounts_effective_to` (`effective_to`),
  KEY `discounts_active` (`active`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `discounts`
--

LOCK TABLES `discounts` WRITE;
/*!40000 ALTER TABLE `discounts` DISABLE KEYS */;
INSERT INTO `discounts` VALUES (1,'Summer Sale 10%','SUMMER10','PERCENTAGE',10.00,100.00,1000.00,'2025-01-01 00:00:00','2026-01-31 00:00:00',NULL,NULL,0,1,'Updated description','2025-12-18 16:41:59','2026-01-08 09:05:10'),(2,'Summer Sale 10%','RETAIL001','PERCENTAGE',10.00,0.00,10000.00,'2026-01-12 00:00:00','2026-01-30 00:00:00',NULL,NULL,0,1,'','2026-01-12 10:46:35','2026-01-12 10:46:35');
/*!40000 ALTER TABLE `discounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fiscal_receipts`
--

DROP TABLE IF EXISTS `fiscal_receipts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fiscal_receipts` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `sale_id` bigint DEFAULT NULL,
  `return_id` bigint DEFAULT NULL,
  `receipt_category` enum('SALE','CREDIT_NOTE') NOT NULL,
  `receipt_type` enum('B2C','B2B') NOT NULL,
  `customer_pin` varchar(20) DEFAULT NULL,
  `kra_receipt_no` varchar(100) DEFAULT NULL,
  `qr_code` text,
  `fiscal_status` enum('PENDING','FISCALISED','FAILED') NOT NULL DEFAULT 'PENDING',
  `fiscalised_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fiscal_receipts_kra_receipt_no` (`kra_receipt_no`),
  KEY `fiscal_receipts_sale_id` (`sale_id`),
  KEY `fiscal_receipts_return_id` (`return_id`),
  KEY `fiscal_receipts_receipt_category` (`receipt_category`),
  KEY `fiscal_receipts_receipt_type` (`receipt_type`),
  KEY `fiscal_receipts_fiscal_status` (`fiscal_status`),
  KEY `fiscal_receipts_fiscalised_at` (`fiscalised_at`),
  CONSTRAINT `fiscal_receipts_ibfk_5` FOREIGN KEY (`sale_id`) REFERENCES `sales` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fiscal_receipts_ibfk_6` FOREIGN KEY (`return_id`) REFERENCES `returns` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fiscal_receipts`
--

LOCK TABLES `fiscal_receipts` WRITE;
/*!40000 ALTER TABLE `fiscal_receipts` DISABLE KEYS */;
INSERT INTO `fiscal_receipts` VALUES (1,7,NULL,'SALE','B2B',NULL,'MOCK-1766076163219','mock-qr-code','FISCALISED','2025-12-18 16:42:43','2025-12-18 16:42:43');
/*!40000 ALTER TABLE `fiscal_receipts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `grn_items`
--

DROP TABLE IF EXISTS `grn_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `grn_items` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `grn_id` bigint NOT NULL,
  `product_id` bigint NOT NULL,
  `variant_id` bigint DEFAULT NULL,
  `quantity` decimal(12,3) NOT NULL,
  `unit_cost` decimal(12,2) NOT NULL,
  `piece_length` decimal(12,3) DEFAULT NULL COMMENT 'Length of each piece received',
  `piece_width` decimal(12,3) DEFAULT NULL COMMENT 'Width of each piece received',
  `dimension_unit` enum('inch','cm','m') DEFAULT NULL COMMENT 'Unit of measure for piece dimensions',
  `pieces_count` int DEFAULT '1' COMMENT 'Number of pieces with these dimensions',
  PRIMARY KEY (`id`),
  KEY `grn_items_grn_id` (`grn_id`),
  KEY `grn_items_product_id` (`product_id`),
  KEY `grn_items_variant_id` (`variant_id`),
  KEY `idx_piece_dimensions` (`piece_length`,`piece_width`,`dimension_unit`),
  KEY `idx_pieces_count` (`pieces_count`),
  CONSTRAINT `grn_items_ibfk_7` FOREIGN KEY (`grn_id`) REFERENCES `grns` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `grn_items_ibfk_8` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `grn_items_ibfk_9` FOREIGN KEY (`variant_id`) REFERENCES `product_variants` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `chk_positive_piece_dimensions` CHECK ((((`piece_length` is null) or (`piece_length` > 0)) and ((`piece_width` is null) or (`piece_width` > 0)))),
  CONSTRAINT `chk_positive_pieces_count` CHECK ((`pieces_count` > 0))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `grn_items`
--

LOCK TABLES `grn_items` WRITE;
/*!40000 ALTER TABLE `grn_items` DISABLE KEYS */;
INSERT INTO `grn_items` VALUES (1,1,1,NULL,500.000,150.00,NULL,NULL,NULL,1),(2,1,2,NULL,1000.000,50.00,NULL,NULL,NULL,1),(3,2,4,NULL,300.000,50.00,NULL,NULL,NULL,1),(4,2,5,NULL,900.000,10.00,NULL,NULL,NULL,1),(5,3,5,NULL,10.000,200.00,NULL,NULL,NULL,1),(6,5,5,NULL,2.000,200.00,NULL,NULL,NULL,1),(7,6,11,NULL,10.000,100.00,NULL,NULL,NULL,1),(8,7,3,NULL,120.000,100.00,NULL,NULL,NULL,1),(9,7,10,NULL,13.000,200.00,NULL,NULL,NULL,1),(10,11,12,NULL,50.000,100.00,NULL,NULL,NULL,1),(11,11,11,NULL,1.000,100.00,NULL,NULL,NULL,1),(12,12,3,NULL,10.000,300.00,NULL,NULL,NULL,1),(13,13,11,NULL,100.000,100.00,NULL,NULL,NULL,1),(14,14,1,NULL,10000.000,200.00,NULL,NULL,NULL,1),(15,15,1,NULL,1000.000,200.00,NULL,NULL,NULL,1),(16,16,1,NULL,10.000,100.00,NULL,NULL,NULL,1),(17,16,11,NULL,10.000,200.00,NULL,NULL,NULL,1),(18,17,29,NULL,100.000,2.50,NULL,NULL,NULL,1),(19,18,33,NULL,100.000,2.50,NULL,NULL,NULL,1),(20,19,39,NULL,100.000,2.50,NULL,NULL,NULL,1),(21,20,42,NULL,100.000,2.50,NULL,NULL,NULL,1),(22,21,45,NULL,100.000,2.50,NULL,NULL,NULL,1),(23,22,48,NULL,100.000,2.50,NULL,NULL,NULL,1),(24,23,51,NULL,100.000,2.50,NULL,NULL,NULL,1),(25,24,54,NULL,100.000,2.50,NULL,NULL,NULL,1),(26,25,57,NULL,100.000,2.50,NULL,NULL,NULL,1),(27,26,58,NULL,4.000,200.00,2.000,6.000,'m',4),(28,26,58,NULL,7.000,100.00,2.000,2.000,'m',7),(33,31,58,NULL,6.000,200.00,2.000,6.000,'m',6);
/*!40000 ALTER TABLE `grn_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `grns`
--

DROP TABLE IF EXISTS `grns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `grns` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `purchase_order_id` bigint DEFAULT NULL,
  `vendor_id` bigint DEFAULT NULL,
  `received_at` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `processed_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `grns_purchase_order_id` (`purchase_order_id`),
  KEY `grns_vendor_id` (`vendor_id`),
  KEY `grns_received_at` (`received_at`),
  CONSTRAINT `grns_ibfk_5` FOREIGN KEY (`purchase_order_id`) REFERENCES `purchase_orders` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `grns_ibfk_6` FOREIGN KEY (`vendor_id`) REFERENCES `vendors` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `grns`
--

LOCK TABLES `grns` WRITE;
/*!40000 ALTER TABLE `grns` DISABLE KEYS */;
INSERT INTO `grns` VALUES (1,NULL,1,'2024-01-15 10:00:00','2025-12-18 15:24:45','2025-12-18 15:24:45',NULL),(2,NULL,3,'2025-12-18 16:20:22','2025-12-18 16:20:22','2025-12-18 16:20:22',NULL),(3,2,3,'2026-01-05 00:00:00','2026-01-05 06:21:21','2026-01-05 06:21:44','2026-01-05 06:21:44'),(5,2,3,'2026-01-06 00:00:00','2026-01-06 05:23:56','2026-01-06 05:24:06','2026-01-06 05:24:06'),(6,3,3,'2026-01-08 00:00:00','2026-01-08 05:45:21','2026-01-08 05:45:38','2026-01-08 05:45:38'),(7,4,3,'2026-01-08 00:00:00','2026-01-08 10:10:42','2026-01-08 11:51:38','2026-01-08 11:51:38'),(11,5,3,'2026-01-08 00:00:00','2026-01-08 12:11:44','2026-01-08 12:12:09','2026-01-08 12:12:09'),(12,6,2,'2026-01-12 00:00:00','2026-01-12 05:13:59','2026-01-12 05:14:13','2026-01-12 05:14:13'),(13,7,2,'2026-01-12 00:00:00','2026-01-12 05:16:00','2026-01-12 05:16:18','2026-01-12 05:16:18'),(14,8,1,'2026-01-12 00:00:00','2026-01-12 05:18:20','2026-01-12 05:24:12','2026-01-12 05:24:12'),(15,9,3,'2026-01-12 00:00:00','2026-01-12 05:24:51','2026-01-12 05:25:48','2026-01-12 05:25:48'),(16,10,3,'2026-01-12 00:00:00','2026-01-12 11:08:52','2026-01-12 11:10:31','2026-01-12 11:10:31'),(17,NULL,NULL,'2026-01-13 15:57:16','2026-01-13 15:57:16','2026-01-13 15:57:20','2026-01-13 15:57:20'),(18,NULL,NULL,'2026-01-13 15:58:06','2026-01-13 15:58:06','2026-01-13 15:58:09','2026-01-13 15:58:09'),(19,NULL,NULL,'2026-01-13 16:48:51','2026-01-13 16:48:51','2026-01-13 16:48:54','2026-01-13 16:48:54'),(20,NULL,NULL,'2026-01-13 16:51:17','2026-01-13 16:51:17','2026-01-13 16:51:20','2026-01-13 16:51:20'),(21,NULL,NULL,'2026-01-13 16:51:27','2026-01-13 16:51:27','2026-01-13 16:51:30','2026-01-13 16:51:30'),(22,NULL,NULL,'2026-01-14 07:33:54','2026-01-14 07:33:54','2026-01-14 07:33:58','2026-01-14 07:33:58'),(23,NULL,NULL,'2026-01-14 07:34:10','2026-01-14 07:34:10','2026-01-14 07:34:13','2026-01-14 07:34:13'),(24,NULL,NULL,'2026-01-14 07:34:20','2026-01-14 07:34:20','2026-01-14 07:34:23','2026-01-14 07:34:23'),(25,NULL,NULL,'2026-01-14 07:37:51','2026-01-14 07:37:51','2026-01-14 07:37:54','2026-01-14 07:37:54'),(26,13,3,'2026-01-14 00:00:00','2026-01-14 15:20:37','2026-01-14 15:25:37','2026-01-14 15:25:37'),(31,13,3,'2026-01-14 00:00:00','2026-01-14 15:27:17','2026-01-14 15:27:33','2026-01-14 15:27:33');
/*!40000 ALTER TABLE `grns` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventories`
--

DROP TABLE IF EXISTS `inventories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventories` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `product_id` bigint NOT NULL,
  `variant_id` bigint DEFAULT NULL,
  `quantity` decimal(12,3) NOT NULL DEFAULT '0.000',
  `reorder_level` decimal(12,3) NOT NULL DEFAULT '0.000',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `total_full_area` decimal(15,3) DEFAULT NULL COMMENT 'Total area of FULL pieces (denormalized for performance)',
  `total_usable_area` decimal(15,3) DEFAULT NULL COMMENT 'Total usable area (USABLE + WASTE pieces)',
  `total_waste_area` decimal(15,3) DEFAULT NULL COMMENT 'Total area of WASTE pieces',
  `total_scrap_area` decimal(15,3) DEFAULT NULL COMMENT 'Total area of SCRAP pieces',
  `dimension_unit` enum('inch','cm','m') DEFAULT NULL COMMENT 'Primary unit of measure for this product',
  PRIMARY KEY (`id`),
  UNIQUE KEY `inventories_product_id_variant_id` (`product_id`,`variant_id`),
  KEY `inventories_product_id` (`product_id`),
  KEY `inventories_variant_id` (`variant_id`),
  KEY `idx_dimension_areas` (`total_full_area`,`total_usable_area`,`total_waste_area`),
  KEY `idx_dimension_unit` (`dimension_unit`),
  CONSTRAINT `inventories_ibfk_5` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `inventories_ibfk_6` FOREIGN KEY (`variant_id`) REFERENCES `product_variants` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `chk_non_negative_areas` CHECK ((((`total_full_area` is null) or (`total_full_area` >= 0)) and ((`total_usable_area` is null) or (`total_usable_area` >= 0)) and ((`total_waste_area` is null) or (`total_waste_area` >= 0)) and ((`total_scrap_area` is null) or (`total_scrap_area` >= 0))))
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventories`
--

LOCK TABLES `inventories` WRITE;
/*!40000 ALTER TABLE `inventories` DISABLE KEYS */;
INSERT INTO `inventories` VALUES (1,1,NULL,12010.000,0.000,'2025-12-18 15:24:52','2026-01-12 11:10:31',NULL,NULL,NULL,NULL,NULL),(2,2,NULL,0.000,0.000,'2025-12-18 15:24:52','2026-01-09 13:37:54',NULL,NULL,NULL,NULL,NULL),(3,3,1,100.000,0.000,'2025-12-18 15:26:02','2026-01-09 13:37:54',NULL,NULL,NULL,NULL,NULL),(4,4,NULL,860.000,0.000,'2025-12-18 16:21:19','2026-01-12 11:22:04',NULL,NULL,NULL,NULL,NULL),(5,5,NULL,3442.000,0.000,'2025-12-18 16:21:28','2026-01-12 11:22:04',NULL,NULL,NULL,NULL,NULL),(6,6,2,8.000,0.000,'2025-12-18 16:22:45','2026-01-10 14:58:17',NULL,NULL,NULL,NULL,NULL),(7,6,NULL,70.000,0.000,'2025-12-18 16:37:48','2026-01-12 05:54:03',NULL,NULL,NULL,NULL,NULL),(8,11,NULL,131.000,0.000,'2026-01-08 05:45:38','2026-01-12 11:22:05',NULL,NULL,NULL,NULL,NULL),(9,3,NULL,127.000,0.000,'2026-01-08 11:51:34','2026-01-12 05:14:13',NULL,NULL,NULL,NULL,NULL),(10,10,NULL,10.000,0.000,'2026-01-08 11:51:38','2026-01-12 15:02:45',NULL,NULL,NULL,NULL,NULL),(11,12,NULL,42.000,0.000,'2026-01-08 12:12:08','2026-01-12 10:47:11',NULL,NULL,NULL,NULL,NULL),(12,11,3,8.000,0.000,'2026-01-08 12:19:22','2026-01-09 13:37:54',NULL,NULL,NULL,NULL,NULL),(13,29,NULL,100.000,0.000,'2026-01-13 15:57:16','2026-01-13 15:57:20',NULL,NULL,NULL,NULL,NULL),(14,33,NULL,100.000,0.000,'2026-01-13 15:58:06','2026-01-13 15:58:09',NULL,NULL,NULL,NULL,NULL),(15,35,NULL,10.000,0.000,'2026-01-13 15:58:09','2026-01-13 15:58:10',NULL,NULL,NULL,NULL,NULL),(16,39,NULL,100.000,0.000,'2026-01-13 16:48:51','2026-01-13 16:48:54',NULL,NULL,NULL,NULL,NULL),(17,41,NULL,10.000,0.000,'2026-01-13 16:48:54','2026-01-13 16:48:55',NULL,NULL,NULL,NULL,NULL),(18,42,NULL,100.000,0.000,'2026-01-13 16:51:17','2026-01-13 16:51:20',NULL,NULL,NULL,NULL,NULL),(19,44,NULL,10.000,0.000,'2026-01-13 16:51:21','2026-01-13 16:51:21',NULL,NULL,NULL,NULL,NULL),(20,45,NULL,100.000,0.000,'2026-01-13 16:51:27','2026-01-13 16:51:30',NULL,NULL,NULL,NULL,NULL),(21,47,NULL,10.000,0.000,'2026-01-13 16:51:30','2026-01-13 16:51:31',NULL,NULL,NULL,NULL,NULL),(22,48,NULL,90.000,0.000,'2026-01-14 07:33:54','2026-01-14 07:33:58',NULL,NULL,NULL,NULL,NULL),(23,50,NULL,10.000,0.000,'2026-01-14 07:33:58','2026-01-14 07:33:59',NULL,NULL,NULL,NULL,NULL),(24,51,NULL,90.000,0.000,'2026-01-14 07:34:10','2026-01-14 07:34:14',NULL,NULL,NULL,NULL,NULL),(25,53,NULL,10.000,0.000,'2026-01-14 07:34:14','2026-01-14 07:34:14',NULL,NULL,NULL,NULL,NULL),(26,54,NULL,90.000,0.000,'2026-01-14 07:34:20','2026-01-14 07:34:23',NULL,NULL,NULL,NULL,NULL),(27,56,NULL,10.000,0.000,'2026-01-14 07:34:23','2026-01-14 07:34:23',NULL,NULL,NULL,NULL,NULL),(28,57,NULL,90.000,0.000,'2026-01-14 07:37:51','2026-01-14 07:37:54',NULL,NULL,NULL,NULL,NULL),(29,59,NULL,10.000,0.000,'2026-01-14 07:37:54','2026-01-14 07:37:55',NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `inventories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_items`
--

DROP TABLE IF EXISTS `inventory_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_items` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `uid` varchar(100) NOT NULL,
  `product_id` bigint NOT NULL,
  `variant_id` bigint DEFAULT NULL,
  `status` enum('IN_STOCK','RESERVED','SOLD','RETURNED','DAMAGED','SCRAPPED') NOT NULL DEFAULT 'IN_STOCK',
  `source` enum('GRN','PRODUCTION','RETURN') NOT NULL,
  `barcode` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uid` (`uid`),
  UNIQUE KEY `inventory_items_uid` (`uid`),
  UNIQUE KEY `uid_2` (`uid`),
  UNIQUE KEY `uid_3` (`uid`),
  KEY `inventory_items_product_id` (`product_id`),
  KEY `inventory_items_variant_id` (`variant_id`),
  KEY `inventory_items_status` (`status`),
  KEY `inventory_items_barcode` (`barcode`),
  CONSTRAINT `inventory_items_ibfk_5` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `inventory_items_ibfk_6` FOREIGN KEY (`variant_id`) REFERENCES `product_variants` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=18319 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_items`
--

LOCK TABLES `inventory_items` WRITE;
/*!40000 ALTER TABLE `inventory_items` DISABLE KEYS */;
INSERT INTO `inventory_items` VALUES (1,'XYZ-1766071562465-12A35FC9',3,1,'IN_STOCK','PRODUCTION','XYZ422567241','2025-12-18 15:26:02','2025-12-18 15:26:02'),(2,'XYZ-1766071562512-0C7B269D',3,1,'IN_STOCK','PRODUCTION','XYZ396844784','2025-12-18 15:26:02','2025-12-18 15:26:02'),(3,'XYZ-1766071562544-C0C489A1',3,1,'IN_STOCK','PRODUCTION','XYZ456087766','2025-12-18 15:26:02','2025-12-18 15:26:02'),(4,'XYZ-1766071562576-34A96762',3,1,'IN_STOCK','PRODUCTION','XYZ180608540','2025-12-18 15:26:02','2025-12-18 15:26:02'),(5,'XYZ-1766071562600-1C6DCB2A',3,1,'IN_STOCK','PRODUCTION','XYZ513910394','2025-12-18 15:26:02','2025-12-18 15:26:02'),(6,'XYZ-1766071562626-582DBA5C',3,1,'IN_STOCK','PRODUCTION','XYZ881958520','2025-12-18 15:26:02','2025-12-18 15:26:02'),(7,'XYZ-1766071562650-CD9CBCEA',3,1,'IN_STOCK','PRODUCTION','XYZ193383017','2025-12-18 15:26:02','2025-12-18 15:26:02'),(8,'XYZ-1766071562678-AEAB4EB8',3,1,'IN_STOCK','PRODUCTION','XYZ443552927','2025-12-18 15:26:02','2025-12-18 15:26:02'),(9,'XYZ-1766071562706-48296260',3,1,'IN_STOCK','PRODUCTION','XYZ464485074','2025-12-18 15:26:02','2025-12-18 15:26:02'),(10,'XYZ-1766071562733-1C5046B2',3,1,'IN_STOCK','PRODUCTION','XYZ940201040','2025-12-18 15:26:02','2025-12-18 15:26:02'),(11,'XYZ-1766071562760-D7A86B91',3,1,'IN_STOCK','PRODUCTION','XYZ832208076','2025-12-18 15:26:02','2025-12-18 15:26:02'),(12,'XYZ-1766071562788-ADD44384',3,1,'IN_STOCK','PRODUCTION','XYZ076296116','2025-12-18 15:26:02','2025-12-18 15:26:02'),(13,'XYZ-1766071562818-5F99661F',3,1,'IN_STOCK','PRODUCTION','XYZ259601416','2025-12-18 15:26:02','2025-12-18 15:26:02'),(14,'XYZ-1766071562848-5A2AEAB8',3,1,'IN_STOCK','PRODUCTION','XYZ564960212','2025-12-18 15:26:02','2025-12-18 15:26:02'),(15,'XYZ-1766071562877-63249EDD',3,1,'IN_STOCK','PRODUCTION','XYZ400876963','2025-12-18 15:26:02','2025-12-18 15:26:02'),(16,'XYZ-1766071562905-8D191C8E',3,1,'IN_STOCK','PRODUCTION','XYZ235578869','2025-12-18 15:26:02','2025-12-18 15:26:02'),(17,'XYZ-1766071562936-2EFE28A9',3,1,'IN_STOCK','PRODUCTION','XYZ849268378','2025-12-18 15:26:02','2025-12-18 15:26:02'),(18,'XYZ-1766071562965-59A559A3',3,1,'IN_STOCK','PRODUCTION','XYZ212303379','2025-12-18 15:26:02','2025-12-18 15:26:02'),(19,'XYZ-1766071562991-A376035D',3,1,'IN_STOCK','PRODUCTION','XYZ309111431','2025-12-18 15:26:03','2025-12-18 15:26:03'),(20,'XYZ-1766071563019-D123E736',3,1,'IN_STOCK','PRODUCTION','XYZ360632913','2025-12-18 15:26:03','2025-12-18 15:26:03'),(21,'XYZ-1766071563046-ACED3FFD',3,1,'IN_STOCK','PRODUCTION','XYZ917986866','2025-12-18 15:26:03','2025-12-18 15:26:03'),(22,'XYZ-1766071563075-62CD5657',3,1,'IN_STOCK','PRODUCTION','XYZ786540209','2025-12-18 15:26:03','2025-12-18 15:26:03'),(23,'XYZ-1766071563106-166C1861',3,1,'IN_STOCK','PRODUCTION','XYZ656865303','2025-12-18 15:26:03','2025-12-18 15:26:03'),(24,'XYZ-1766071563132-F8B66554',3,1,'IN_STOCK','PRODUCTION','XYZ461066018','2025-12-18 15:26:03','2025-12-18 15:26:03'),(25,'XYZ-1766071563162-A1B746DE',3,1,'IN_STOCK','PRODUCTION','XYZ849532250','2025-12-18 15:26:03','2025-12-18 15:26:03'),(26,'XYZ-1766071563189-FCFCB009',3,1,'IN_STOCK','PRODUCTION','XYZ005270204','2025-12-18 15:26:03','2025-12-18 15:26:03'),(27,'XYZ-1766071563218-92BAAAA4',3,1,'IN_STOCK','PRODUCTION','XYZ250221800','2025-12-18 15:26:03','2025-12-18 15:26:03'),(28,'XYZ-1766071563249-96225372',3,1,'IN_STOCK','PRODUCTION','XYZ018919977','2025-12-18 15:26:03','2025-12-18 15:26:03'),(29,'XYZ-1766071563274-319FDC86',3,1,'IN_STOCK','PRODUCTION','XYZ408765694','2025-12-18 15:26:03','2025-12-18 15:26:03'),(30,'XYZ-1766071563299-07026E73',3,1,'IN_STOCK','PRODUCTION','XYZ076122343','2025-12-18 15:26:03','2025-12-18 15:26:03'),(31,'XYZ-1766071563321-5125F891',3,1,'IN_STOCK','PRODUCTION','XYZ837241492','2025-12-18 15:26:03','2025-12-18 15:26:03'),(32,'XYZ-1766071563344-BF52A70E',3,1,'IN_STOCK','PRODUCTION','XYZ564048210','2025-12-18 15:26:03','2025-12-18 15:26:03'),(33,'XYZ-1766071563367-176D549A',3,1,'IN_STOCK','PRODUCTION','XYZ152088806','2025-12-18 15:26:03','2025-12-18 15:26:03'),(34,'XYZ-1766071563394-FBD035D6',3,1,'IN_STOCK','PRODUCTION','XYZ679074061','2025-12-18 15:26:03','2025-12-18 15:26:03'),(35,'XYZ-1766071563420-57C40D49',3,1,'IN_STOCK','PRODUCTION','XYZ394316427','2025-12-18 15:26:03','2025-12-18 15:26:03'),(36,'XYZ-1766071563449-D5504B32',3,1,'IN_STOCK','PRODUCTION','XYZ392931303','2025-12-18 15:26:03','2025-12-18 15:26:03'),(37,'XYZ-1766071563479-BE94B7FF',3,1,'IN_STOCK','PRODUCTION','XYZ527882519','2025-12-18 15:26:03','2025-12-18 15:26:03'),(38,'XYZ-1766071563509-02EF73BE',3,1,'IN_STOCK','PRODUCTION','XYZ804263970','2025-12-18 15:26:03','2025-12-18 15:26:03'),(39,'XYZ-1766071563537-759A2D2F',3,1,'IN_STOCK','PRODUCTION','XYZ844291159','2025-12-18 15:26:03','2025-12-18 15:26:03'),(40,'XYZ-1766071563566-399C8132',3,1,'IN_STOCK','PRODUCTION','XYZ261806528','2025-12-18 15:26:03','2025-12-18 15:26:03'),(41,'XYZ-1766071563596-20917CC8',3,1,'IN_STOCK','PRODUCTION','XYZ973062561','2025-12-18 15:26:03','2025-12-18 15:26:03'),(42,'XYZ-1766071563624-5C4E9047',3,1,'IN_STOCK','PRODUCTION','XYZ975012214','2025-12-18 15:26:03','2025-12-18 15:26:03'),(43,'XYZ-1766071563647-72D1951B',3,1,'IN_STOCK','PRODUCTION','XYZ316044129','2025-12-18 15:26:03','2025-12-18 15:26:03'),(44,'XYZ-1766071563675-FC0002B1',3,1,'IN_STOCK','PRODUCTION','XYZ359527940','2025-12-18 15:26:03','2025-12-18 15:26:03'),(45,'XYZ-1766071563704-DCBAECC3',3,1,'IN_STOCK','PRODUCTION','XYZ728851164','2025-12-18 15:26:03','2025-12-18 15:26:03'),(46,'XYZ-1766071563732-8B041B52',3,1,'IN_STOCK','PRODUCTION','XYZ736080450','2025-12-18 15:26:03','2025-12-18 15:26:03'),(47,'XYZ-1766071563760-36F8DC49',3,1,'IN_STOCK','PRODUCTION','XYZ875783312','2025-12-18 15:26:03','2025-12-18 15:26:03'),(48,'XYZ-1766071563785-AEEC4A08',3,1,'IN_STOCK','PRODUCTION','XYZ475394147','2025-12-18 15:26:03','2025-12-18 15:26:03'),(49,'XYZ-1766071563814-94009FDA',3,1,'IN_STOCK','PRODUCTION','XYZ889701065','2025-12-18 15:26:03','2025-12-18 15:26:03'),(50,'XYZ-1766071563842-49D4160B',3,1,'IN_STOCK','PRODUCTION','XYZ869091304','2025-12-18 15:26:03','2025-12-18 15:26:03'),(51,'XYZ-1766071563870-2068AD87',3,1,'IN_STOCK','PRODUCTION','XYZ907669405','2025-12-18 15:26:03','2025-12-18 15:26:03'),(52,'XYZ-1766071563896-36F37024',3,1,'IN_STOCK','PRODUCTION','XYZ283397733','2025-12-18 15:26:03','2025-12-18 15:26:03'),(53,'XYZ-1766071563923-D3364CC6',3,1,'IN_STOCK','PRODUCTION','XYZ321547621','2025-12-18 15:26:03','2025-12-18 15:26:03'),(54,'XYZ-1766071563950-6571E9CB',3,1,'IN_STOCK','PRODUCTION','XYZ442371657','2025-12-18 15:26:03','2025-12-18 15:26:03'),(55,'XYZ-1766071563977-BF43DC2B',3,1,'IN_STOCK','PRODUCTION','XYZ217708001','2025-12-18 15:26:03','2025-12-18 15:26:03'),(56,'XYZ-1766071564005-F58D9A33',3,1,'IN_STOCK','PRODUCTION','XYZ761793198','2025-12-18 15:26:04','2025-12-18 15:26:04'),(57,'XYZ-1766071564033-CF4309CD',3,1,'IN_STOCK','PRODUCTION','XYZ968856817','2025-12-18 15:26:04','2025-12-18 15:26:04'),(58,'XYZ-1766071564060-8E89B62C',3,1,'IN_STOCK','PRODUCTION','XYZ166338571','2025-12-18 15:26:04','2025-12-18 15:26:04'),(59,'XYZ-1766071564085-97C15255',3,1,'IN_STOCK','PRODUCTION','XYZ103435729','2025-12-18 15:26:04','2025-12-18 15:26:04'),(60,'XYZ-1766071564112-124B9EA6',3,1,'IN_STOCK','PRODUCTION','XYZ913584460','2025-12-18 15:26:04','2025-12-18 15:26:04'),(61,'XYZ-1766071564138-2FA04EDB',3,1,'IN_STOCK','PRODUCTION','XYZ125461162','2025-12-18 15:26:04','2025-12-18 15:26:04'),(62,'XYZ-1766071564167-5C523B57',3,1,'IN_STOCK','PRODUCTION','XYZ299460711','2025-12-18 15:26:04','2025-12-18 15:26:04'),(63,'XYZ-1766071564193-53513BC6',3,1,'IN_STOCK','PRODUCTION','XYZ791717487','2025-12-18 15:26:04','2025-12-18 15:26:04'),(64,'XYZ-1766071564220-58FE0CE7',3,1,'IN_STOCK','PRODUCTION','XYZ065485786','2025-12-18 15:26:04','2025-12-18 15:26:04'),(65,'XYZ-1766071564248-F3079234',3,1,'IN_STOCK','PRODUCTION','XYZ357009828','2025-12-18 15:26:04','2025-12-18 15:26:04'),(66,'XYZ-1766071564276-A306CF65',3,1,'IN_STOCK','PRODUCTION','XYZ079707547','2025-12-18 15:26:04','2025-12-18 15:26:04'),(67,'XYZ-1766071564305-9FD5AC6B',3,1,'IN_STOCK','PRODUCTION','XYZ616284826','2025-12-18 15:26:04','2025-12-18 15:26:04'),(68,'XYZ-1766071564333-0207C52C',3,1,'IN_STOCK','PRODUCTION','XYZ987518126','2025-12-18 15:26:04','2025-12-18 15:26:04'),(69,'XYZ-1766071564358-1C54244B',3,1,'IN_STOCK','PRODUCTION','XYZ519912349','2025-12-18 15:26:04','2025-12-18 15:26:04'),(70,'XYZ-1766071564385-DA7DA92E',3,1,'IN_STOCK','PRODUCTION','XYZ656942822','2025-12-18 15:26:04','2025-12-18 15:26:04'),(71,'XYZ-1766071564414-ECA51CE1',3,1,'IN_STOCK','PRODUCTION','XYZ382826722','2025-12-18 15:26:04','2025-12-18 15:26:04'),(72,'XYZ-1766071564442-49B15636',3,1,'IN_STOCK','PRODUCTION','XYZ251560513','2025-12-18 15:26:04','2025-12-18 15:26:04'),(73,'XYZ-1766071564470-2B0DAD99',3,1,'IN_STOCK','PRODUCTION','XYZ632306517','2025-12-18 15:26:04','2025-12-18 15:26:04'),(74,'XYZ-1766071564494-34DF14CF',3,1,'IN_STOCK','PRODUCTION','XYZ354732839','2025-12-18 15:26:04','2025-12-18 15:26:04'),(75,'XYZ-1766071564514-5DD10526',3,1,'IN_STOCK','PRODUCTION','XYZ714903270','2025-12-18 15:26:04','2025-12-18 15:26:04'),(76,'XYZ-1766071564540-4E7252D1',3,1,'IN_STOCK','PRODUCTION','XYZ756348511','2025-12-18 15:26:04','2025-12-18 15:26:04'),(77,'XYZ-1766071564564-FCA81D65',3,1,'IN_STOCK','PRODUCTION','XYZ411097064','2025-12-18 15:26:04','2025-12-18 15:26:04'),(78,'XYZ-1766071564585-56ADC846',3,1,'IN_STOCK','PRODUCTION','XYZ161589325','2025-12-18 15:26:04','2025-12-18 15:26:04'),(79,'XYZ-1766071564605-E3A3CAFC',3,1,'IN_STOCK','PRODUCTION','XYZ997005313','2025-12-18 15:26:04','2025-12-18 15:26:04'),(80,'XYZ-1766071564626-1FEE5222',3,1,'IN_STOCK','PRODUCTION','XYZ132237549','2025-12-18 15:26:04','2025-12-18 15:26:04'),(81,'XYZ-1766071564649-DA1F25DF',3,1,'IN_STOCK','PRODUCTION','XYZ409481133','2025-12-18 15:26:04','2025-12-18 15:26:04'),(82,'XYZ-1766071564676-3167743F',3,1,'IN_STOCK','PRODUCTION','XYZ885301908','2025-12-18 15:26:04','2025-12-18 15:26:04'),(83,'XYZ-1766071564704-22473585',3,1,'IN_STOCK','PRODUCTION','XYZ859418432','2025-12-18 15:26:04','2025-12-18 15:26:04'),(84,'XYZ-1766071564729-AF910FF8',3,1,'IN_STOCK','PRODUCTION','XYZ111571685','2025-12-18 15:26:04','2025-12-18 15:26:04'),(85,'XYZ-1766071564755-CCD4CACF',3,1,'IN_STOCK','PRODUCTION','XYZ438483678','2025-12-18 15:26:04','2025-12-18 15:26:04'),(86,'XYZ-1766071564782-5CD36167',3,1,'IN_STOCK','PRODUCTION','XYZ985119052','2025-12-18 15:26:04','2025-12-18 15:26:04'),(87,'XYZ-1766071564808-815B6D4E',3,1,'IN_STOCK','PRODUCTION','XYZ642524141','2025-12-18 15:26:04','2025-12-18 15:26:04'),(88,'XYZ-1766071564832-2C8AB430',3,1,'IN_STOCK','PRODUCTION','XYZ378459479','2025-12-18 15:26:04','2025-12-18 15:26:04'),(89,'XYZ-1766071564860-6DC0E80C',3,1,'IN_STOCK','PRODUCTION','XYZ193680042','2025-12-18 15:26:04','2025-12-18 15:26:04'),(90,'XYZ-1766071564888-3CF0E889',3,1,'IN_STOCK','PRODUCTION','XYZ174655376','2025-12-18 15:26:04','2025-12-18 15:26:04'),(91,'XYZ-1766071564912-C7B3FB58',3,1,'IN_STOCK','PRODUCTION','XYZ961648335','2025-12-18 15:26:04','2025-12-18 15:26:04'),(92,'XYZ-1766071564939-79D5E2D6',3,1,'IN_STOCK','PRODUCTION','XYZ884723689','2025-12-18 15:26:04','2025-12-18 15:26:04'),(93,'XYZ-1766071564963-6ADE7CB7',3,1,'IN_STOCK','PRODUCTION','XYZ141696594','2025-12-18 15:26:04','2025-12-18 15:26:04'),(94,'XYZ-1766071564986-86FC5955',3,1,'IN_STOCK','PRODUCTION','XYZ690039928','2025-12-18 15:26:04','2025-12-18 15:26:04'),(95,'XYZ-1766071565011-A12A1C8A',3,1,'IN_STOCK','PRODUCTION','XYZ541327848','2025-12-18 15:26:05','2025-12-18 15:26:05'),(96,'XYZ-1766071565035-EEAA0A2C',3,1,'IN_STOCK','PRODUCTION','XYZ379161161','2025-12-18 15:26:05','2025-12-18 15:26:05'),(97,'XYZ-1766071565061-31DB8959',3,1,'IN_STOCK','PRODUCTION','XYZ773573658','2025-12-18 15:26:05','2025-12-18 15:26:05'),(98,'XYZ-1766071565084-A3C360BC',3,1,'IN_STOCK','PRODUCTION','XYZ977561159','2025-12-18 15:26:05','2025-12-18 15:26:05'),(99,'XYZ-1766071565110-D4B794C0',3,1,'IN_STOCK','PRODUCTION','XYZ397250336','2025-12-18 15:26:05','2025-12-18 15:26:05'),(100,'XYZ-1766071565136-FE05C713',3,1,'IN_STOCK','PRODUCTION','XYZ644351509','2025-12-18 15:26:05','2025-12-18 15:26:05'),(101,'XYZ-1766074879531-D8E90373',4,NULL,'IN_STOCK','GRN','XYZ113210528','2025-12-18 16:21:19','2025-12-18 16:21:19'),(102,'XYZ-1766074879603-AD610C65',4,NULL,'IN_STOCK','GRN','XYZ874295576','2025-12-18 16:21:19','2025-12-18 16:21:19'),(103,'XYZ-1766074879643-19C146DC',4,NULL,'IN_STOCK','GRN','XYZ348688674','2025-12-18 16:21:19','2025-12-18 16:21:19'),(104,'XYZ-1766074879683-78D0E2BD',4,NULL,'IN_STOCK','GRN','XYZ018831075','2025-12-18 16:21:19','2025-12-18 16:21:19'),(105,'XYZ-1766074879719-4B53CB3E',4,NULL,'IN_STOCK','GRN','XYZ523666722','2025-12-18 16:21:19','2025-12-18 16:21:19'),(106,'XYZ-1766074879760-0012BED5',4,NULL,'IN_STOCK','GRN','XYZ480693575','2025-12-18 16:21:19','2025-12-18 16:21:19'),(107,'XYZ-1766074879798-2D722A71',4,NULL,'IN_STOCK','GRN','XYZ845975654','2025-12-18 16:21:19','2025-12-18 16:21:19'),(108,'XYZ-1766074879831-32E5E5F2',4,NULL,'IN_STOCK','GRN','XYZ187292283','2025-12-18 16:21:19','2025-12-18 16:21:19'),(109,'XYZ-1766074879863-5645C1A6',4,NULL,'IN_STOCK','GRN','XYZ416721059','2025-12-18 16:21:19','2025-12-18 16:21:19'),(110,'XYZ-1766074879897-DA9C79F6',4,NULL,'IN_STOCK','GRN','XYZ008589897','2025-12-18 16:21:19','2025-12-18 16:21:19'),(111,'XYZ-1766074879932-C0B5C90F',4,NULL,'IN_STOCK','GRN','XYZ181704196','2025-12-18 16:21:19','2025-12-18 16:21:19'),(112,'XYZ-1766074879965-D300E60D',4,NULL,'IN_STOCK','GRN','XYZ372875267','2025-12-18 16:21:19','2025-12-18 16:21:19'),(113,'XYZ-1766074879998-B1F17835',4,NULL,'IN_STOCK','GRN','XYZ361903330','2025-12-18 16:21:20','2025-12-18 16:21:20'),(114,'XYZ-1766074880032-15B8B577',4,NULL,'IN_STOCK','GRN','XYZ896060693','2025-12-18 16:21:20','2025-12-18 16:21:20'),(115,'XYZ-1766074880069-12651348',4,NULL,'IN_STOCK','GRN','XYZ269262908','2025-12-18 16:21:20','2025-12-18 16:21:20'),(116,'XYZ-1766074880101-088E78C3',4,NULL,'IN_STOCK','GRN','XYZ201965519','2025-12-18 16:21:20','2025-12-18 16:21:20'),(117,'XYZ-1766074880148-823E2E5F',4,NULL,'IN_STOCK','GRN','XYZ748439047','2025-12-18 16:21:20','2025-12-18 16:21:20'),(118,'XYZ-1766074880178-9AF8C39A',4,NULL,'IN_STOCK','GRN','XYZ980747278','2025-12-18 16:21:20','2025-12-18 16:21:20'),(119,'XYZ-1766074880205-32A26D2F',4,NULL,'IN_STOCK','GRN','XYZ081745900','2025-12-18 16:21:20','2025-12-18 16:21:20'),(120,'XYZ-1766074880231-2D76A418',4,NULL,'IN_STOCK','GRN','XYZ602326686','2025-12-18 16:21:20','2025-12-18 16:21:20'),(121,'XYZ-1766074880259-0C3A44F8',4,NULL,'IN_STOCK','GRN','XYZ461108204','2025-12-18 16:21:20','2025-12-18 16:21:20'),(122,'XYZ-1766074880291-34333DBD',4,NULL,'IN_STOCK','GRN','XYZ165511223','2025-12-18 16:21:20','2025-12-18 16:21:20'),(123,'XYZ-1766074880323-FBD436A1',4,NULL,'IN_STOCK','GRN','XYZ973124819','2025-12-18 16:21:20','2025-12-18 16:21:20'),(124,'XYZ-1766074880358-35D0528D',4,NULL,'IN_STOCK','GRN','XYZ917245176','2025-12-18 16:21:20','2025-12-18 16:21:20'),(125,'XYZ-1766074880390-B873E313',4,NULL,'IN_STOCK','GRN','XYZ727935750','2025-12-18 16:21:20','2025-12-18 16:21:20'),(126,'XYZ-1766074880418-F176925D',4,NULL,'IN_STOCK','GRN','XYZ037338298','2025-12-18 16:21:20','2025-12-18 16:21:20'),(127,'XYZ-1766074880452-253DA59B',4,NULL,'IN_STOCK','GRN','XYZ597729702','2025-12-18 16:21:20','2025-12-18 16:21:20'),(128,'XYZ-1766074880486-EDDB7FCB',4,NULL,'IN_STOCK','GRN','XYZ506371863','2025-12-18 16:21:20','2025-12-18 16:21:20'),(129,'XYZ-1766074880520-9F1623BE',4,NULL,'IN_STOCK','GRN','XYZ634018031','2025-12-18 16:21:20','2025-12-18 16:21:20'),(130,'XYZ-1766074880551-B87A2952',4,NULL,'IN_STOCK','GRN','XYZ569671713','2025-12-18 16:21:20','2025-12-18 16:21:20'),(131,'XYZ-1766074880584-67619C58',4,NULL,'IN_STOCK','GRN','XYZ736464209','2025-12-18 16:21:20','2025-12-18 16:21:20'),(132,'XYZ-1766074880613-E8E13223',4,NULL,'IN_STOCK','GRN','XYZ147478703','2025-12-18 16:21:20','2025-12-18 16:21:20'),(133,'XYZ-1766074880646-844C1565',4,NULL,'IN_STOCK','GRN','XYZ728307978','2025-12-18 16:21:20','2025-12-18 16:21:20'),(134,'XYZ-1766074880681-89CF828A',4,NULL,'IN_STOCK','GRN','XYZ525613438','2025-12-18 16:21:20','2025-12-18 16:21:20'),(135,'XYZ-1766074880714-47C7DEF4',4,NULL,'IN_STOCK','GRN','XYZ791611428','2025-12-18 16:21:20','2025-12-18 16:21:20'),(136,'XYZ-1766074880746-1FDD6034',4,NULL,'IN_STOCK','GRN','XYZ202233850','2025-12-18 16:21:20','2025-12-18 16:21:20'),(137,'XYZ-1766074880778-3BF5DA48',4,NULL,'IN_STOCK','GRN','XYZ112487065','2025-12-18 16:21:20','2025-12-18 16:21:20'),(138,'XYZ-1766074880810-691A3511',4,NULL,'IN_STOCK','GRN','XYZ407453331','2025-12-18 16:21:20','2025-12-18 16:21:20'),(139,'XYZ-1766074880841-147D751F',4,NULL,'IN_STOCK','GRN','XYZ704566330','2025-12-18 16:21:20','2025-12-18 16:21:20'),(140,'XYZ-1766074880874-8A9B041F',4,NULL,'IN_STOCK','GRN','XYZ039653997','2025-12-18 16:21:20','2025-12-18 16:21:20'),(141,'XYZ-1766074880907-46AFEA7E',4,NULL,'IN_STOCK','GRN','XYZ393468005','2025-12-18 16:21:20','2025-12-18 16:21:20'),(142,'XYZ-1766074880940-A4032784',4,NULL,'IN_STOCK','GRN','XYZ063987791','2025-12-18 16:21:20','2025-12-18 16:21:20'),(143,'XYZ-1766074880968-EC369972',4,NULL,'IN_STOCK','GRN','XYZ325966734','2025-12-18 16:21:20','2025-12-18 16:21:20'),(144,'XYZ-1766074881000-D9CEE0B0',4,NULL,'IN_STOCK','GRN','XYZ635604248','2025-12-18 16:21:21','2025-12-18 16:21:21'),(145,'XYZ-1766074881031-43331DE8',4,NULL,'IN_STOCK','GRN','XYZ098422278','2025-12-18 16:21:21','2025-12-18 16:21:21'),(146,'XYZ-1766074881064-993195CE',4,NULL,'IN_STOCK','GRN','XYZ519161373','2025-12-18 16:21:21','2025-12-18 16:21:21'),(147,'XYZ-1766074881091-C5375787',4,NULL,'IN_STOCK','GRN','XYZ055926749','2025-12-18 16:21:21','2025-12-18 16:21:21'),(148,'XYZ-1766074881119-ECB69938',4,NULL,'IN_STOCK','GRN','XYZ179333168','2025-12-18 16:21:21','2025-12-18 16:21:21'),(149,'XYZ-1766074881150-CEC96064',4,NULL,'IN_STOCK','GRN','XYZ787397970','2025-12-18 16:21:21','2025-12-18 16:21:21'),(150,'XYZ-1766074881179-B37046C2',4,NULL,'IN_STOCK','GRN','XYZ082120650','2025-12-18 16:21:21','2025-12-18 16:21:21'),(151,'XYZ-1766074881208-6871F268',4,NULL,'IN_STOCK','GRN','XYZ846835496','2025-12-18 16:21:21','2025-12-18 16:21:21'),(152,'XYZ-1766074881241-2C7FD7FE',4,NULL,'IN_STOCK','GRN','XYZ769865874','2025-12-18 16:21:21','2025-12-18 16:21:21'),(153,'XYZ-1766074881273-A8BF3F7C',4,NULL,'IN_STOCK','GRN','XYZ775040967','2025-12-18 16:21:21','2025-12-18 16:21:21'),(154,'XYZ-1766074881301-90BA1764',4,NULL,'IN_STOCK','GRN','XYZ274222644','2025-12-18 16:21:21','2025-12-18 16:21:21'),(155,'XYZ-1766074881333-A60B848E',4,NULL,'IN_STOCK','GRN','XYZ547515994','2025-12-18 16:21:21','2025-12-18 16:21:21'),(156,'XYZ-1766074881365-53F155A2',4,NULL,'IN_STOCK','GRN','XYZ343724324','2025-12-18 16:21:21','2025-12-18 16:21:21'),(157,'XYZ-1766074881397-883B7D00',4,NULL,'IN_STOCK','GRN','XYZ937849184','2025-12-18 16:21:21','2025-12-18 16:21:21'),(158,'XYZ-1766074881426-96F44A5D',4,NULL,'IN_STOCK','GRN','XYZ319969887','2025-12-18 16:21:21','2025-12-18 16:21:21'),(159,'XYZ-1766074881457-AB56CC9A',4,NULL,'IN_STOCK','GRN','XYZ353525874','2025-12-18 16:21:21','2025-12-18 16:21:21'),(160,'XYZ-1766074881489-2C6B032B',4,NULL,'IN_STOCK','GRN','XYZ780497906','2025-12-18 16:21:21','2025-12-18 16:21:21'),(161,'XYZ-1766074881518-A8FAEE8F',4,NULL,'IN_STOCK','GRN','XYZ613722430','2025-12-18 16:21:21','2025-12-18 16:21:21'),(162,'XYZ-1766074881548-54625D5A',4,NULL,'IN_STOCK','GRN','XYZ133161720','2025-12-18 16:21:21','2025-12-18 16:21:21'),(163,'XYZ-1766074881579-AA6F7A07',4,NULL,'IN_STOCK','GRN','XYZ165929029','2025-12-18 16:21:21','2025-12-18 16:21:21'),(164,'XYZ-1766074881610-30DF649F',4,NULL,'IN_STOCK','GRN','XYZ198449281','2025-12-18 16:21:21','2025-12-18 16:21:21'),(165,'XYZ-1766074881639-3C24BBB1',4,NULL,'IN_STOCK','GRN','XYZ642225115','2025-12-18 16:21:21','2025-12-18 16:21:21'),(166,'XYZ-1766074881671-D46F6EAB',4,NULL,'IN_STOCK','GRN','XYZ405578010','2025-12-18 16:21:21','2025-12-18 16:21:21'),(167,'XYZ-1766074881698-D770F21F',4,NULL,'IN_STOCK','GRN','XYZ125095473','2025-12-18 16:21:21','2025-12-18 16:21:21'),(168,'XYZ-1766074881730-CDF5E0CC',4,NULL,'IN_STOCK','GRN','XYZ833081671','2025-12-18 16:21:21','2025-12-18 16:21:21'),(169,'XYZ-1766074881760-611C9E1B',4,NULL,'IN_STOCK','GRN','XYZ308099953','2025-12-18 16:21:21','2025-12-18 16:21:21'),(170,'XYZ-1766074881789-8ECA3D94',4,NULL,'IN_STOCK','GRN','XYZ113435807','2025-12-18 16:21:21','2025-12-18 16:21:21'),(171,'XYZ-1766074881820-B341D0CF',4,NULL,'IN_STOCK','GRN','XYZ723020424','2025-12-18 16:21:21','2025-12-18 16:21:21'),(172,'XYZ-1766074881853-AB67DDE2',4,NULL,'IN_STOCK','GRN','XYZ384155604','2025-12-18 16:21:21','2025-12-18 16:21:21'),(173,'XYZ-1766074881883-4034D07B',4,NULL,'IN_STOCK','GRN','XYZ139001008','2025-12-18 16:21:21','2025-12-18 16:21:21'),(174,'XYZ-1766074881915-2D85257F',4,NULL,'IN_STOCK','GRN','XYZ777170959','2025-12-18 16:21:21','2025-12-18 16:21:21'),(175,'XYZ-1766074881944-C637C423',4,NULL,'IN_STOCK','GRN','XYZ078723542','2025-12-18 16:21:21','2025-12-18 16:21:21'),(176,'XYZ-1766074881973-321C60CA',4,NULL,'IN_STOCK','GRN','XYZ552075668','2025-12-18 16:21:21','2025-12-18 16:21:21'),(177,'XYZ-1766074882001-78DF9377',4,NULL,'IN_STOCK','GRN','XYZ501069319','2025-12-18 16:21:22','2025-12-18 16:21:22'),(178,'XYZ-1766074882029-3CAEAF3D',4,NULL,'IN_STOCK','GRN','XYZ734368409','2025-12-18 16:21:22','2025-12-18 16:21:22'),(179,'XYZ-1766074882059-7D612805',4,NULL,'IN_STOCK','GRN','XYZ584890565','2025-12-18 16:21:22','2025-12-18 16:21:22'),(180,'XYZ-1766074882091-45337968',4,NULL,'IN_STOCK','GRN','XYZ018114586','2025-12-18 16:21:22','2025-12-18 16:21:22'),(181,'XYZ-1766074882121-5EF93A82',4,NULL,'IN_STOCK','GRN','XYZ012152739','2025-12-18 16:21:22','2025-12-18 16:21:22'),(182,'XYZ-1766074882153-280C6E64',4,NULL,'IN_STOCK','GRN','XYZ464786582','2025-12-18 16:21:22','2025-12-18 16:21:22'),(183,'XYZ-1766074882182-DE6F0F13',4,NULL,'IN_STOCK','GRN','XYZ995004718','2025-12-18 16:21:22','2025-12-18 16:21:22'),(184,'XYZ-1766074882213-3FE3848D',4,NULL,'IN_STOCK','GRN','XYZ423507439','2025-12-18 16:21:22','2025-12-18 16:21:22'),(185,'XYZ-1766074882243-AE93C19F',4,NULL,'IN_STOCK','GRN','XYZ413842437','2025-12-18 16:21:22','2025-12-18 16:21:22'),(186,'XYZ-1766074882274-6A5D70DC',4,NULL,'IN_STOCK','GRN','XYZ288402354','2025-12-18 16:21:22','2025-12-18 16:21:22'),(187,'XYZ-1766074882301-F83E92DA',4,NULL,'IN_STOCK','GRN','XYZ550920805','2025-12-18 16:21:22','2025-12-18 16:21:22'),(188,'XYZ-1766074882331-85791A20',4,NULL,'IN_STOCK','GRN','XYZ606768652','2025-12-18 16:21:22','2025-12-18 16:21:22'),(189,'XYZ-1766074882361-42E604B1',4,NULL,'IN_STOCK','GRN','XYZ355805552','2025-12-18 16:21:22','2025-12-18 16:21:22'),(190,'XYZ-1766074882392-E1685CB4',4,NULL,'IN_STOCK','GRN','XYZ121303781','2025-12-18 16:21:22','2025-12-18 16:21:22'),(191,'XYZ-1766074882421-AF7F31CA',4,NULL,'IN_STOCK','GRN','XYZ762352767','2025-12-18 16:21:22','2025-12-18 16:21:22'),(192,'XYZ-1766074882449-55555AAA',4,NULL,'IN_STOCK','GRN','XYZ780220640','2025-12-18 16:21:22','2025-12-18 16:21:22'),(193,'XYZ-1766074882481-6E508697',4,NULL,'IN_STOCK','GRN','XYZ013146404','2025-12-18 16:21:22','2025-12-18 16:21:22'),(194,'XYZ-1766074882511-68262C14',4,NULL,'IN_STOCK','GRN','XYZ051878426','2025-12-18 16:21:22','2025-12-18 16:21:22'),(195,'XYZ-1766074882543-7E339862',4,NULL,'IN_STOCK','GRN','XYZ140005252','2025-12-18 16:21:22','2025-12-18 16:21:22'),(196,'XYZ-1766074882574-171ACD21',4,NULL,'IN_STOCK','GRN','XYZ793835746','2025-12-18 16:21:22','2025-12-18 16:21:22'),(197,'XYZ-1766074882606-37A9B5B9',4,NULL,'IN_STOCK','GRN','XYZ403514452','2025-12-18 16:21:22','2025-12-18 16:21:22'),(198,'XYZ-1766074882636-DDEB5176',4,NULL,'IN_STOCK','GRN','XYZ476164440','2025-12-18 16:21:22','2025-12-18 16:21:22'),(199,'XYZ-1766074882667-46FF02AB',4,NULL,'IN_STOCK','GRN','XYZ398749646','2025-12-18 16:21:22','2025-12-18 16:21:22'),(200,'XYZ-1766074882697-4978F8C5',4,NULL,'IN_STOCK','GRN','XYZ274472159','2025-12-18 16:21:22','2025-12-18 16:21:22'),(201,'XYZ-1766074882724-1830E2FD',4,NULL,'IN_STOCK','GRN','XYZ499820396','2025-12-18 16:21:22','2025-12-18 16:21:22'),(202,'XYZ-1766074882755-43E2414E',4,NULL,'IN_STOCK','GRN','XYZ581025204','2025-12-18 16:21:22','2025-12-18 16:21:22'),(203,'XYZ-1766074882786-E2ED7B75',4,NULL,'IN_STOCK','GRN','XYZ798331040','2025-12-18 16:21:22','2025-12-18 16:21:22'),(204,'XYZ-1766074882816-511A30D2',4,NULL,'IN_STOCK','GRN','XYZ108396680','2025-12-18 16:21:22','2025-12-18 16:21:22'),(205,'XYZ-1766074882847-304263C6',4,NULL,'IN_STOCK','GRN','XYZ362798159','2025-12-18 16:21:22','2025-12-18 16:21:22'),(206,'XYZ-1766074882876-A349281B',4,NULL,'IN_STOCK','GRN','XYZ841309972','2025-12-18 16:21:22','2025-12-18 16:21:22'),(207,'XYZ-1766074882906-1FFBA26C',4,NULL,'IN_STOCK','GRN','XYZ987675007','2025-12-18 16:21:22','2025-12-18 16:21:22'),(208,'XYZ-1766074882934-5D3B1A4B',4,NULL,'IN_STOCK','GRN','XYZ853466384','2025-12-18 16:21:22','2025-12-18 16:21:22'),(209,'XYZ-1766074882965-91D09B9C',4,NULL,'IN_STOCK','GRN','XYZ000855583','2025-12-18 16:21:22','2025-12-18 16:21:22'),(210,'XYZ-1766074882992-E5768BC7',4,NULL,'IN_STOCK','GRN','XYZ819528108','2025-12-18 16:21:23','2025-12-18 16:21:23'),(211,'XYZ-1766074883021-4DECB4DD',4,NULL,'IN_STOCK','GRN','XYZ751582511','2025-12-18 16:21:23','2025-12-18 16:21:23'),(212,'XYZ-1766074883050-19257FE9',4,NULL,'IN_STOCK','GRN','XYZ229325433','2025-12-18 16:21:23','2025-12-18 16:21:23'),(213,'XYZ-1766074883078-CF9E12D2',4,NULL,'IN_STOCK','GRN','XYZ085874549','2025-12-18 16:21:23','2025-12-18 16:21:23'),(214,'XYZ-1766074883109-C7F3906B',4,NULL,'IN_STOCK','GRN','XYZ678243221','2025-12-18 16:21:23','2025-12-18 16:21:23'),(215,'XYZ-1766074883139-4BEE3EB3',4,NULL,'IN_STOCK','GRN','XYZ024666040','2025-12-18 16:21:23','2025-12-18 16:21:23'),(216,'XYZ-1766074883169-94A02CFC',4,NULL,'IN_STOCK','GRN','XYZ032858209','2025-12-18 16:21:23','2025-12-18 16:21:23'),(217,'XYZ-1766074883197-82B15D3C',4,NULL,'IN_STOCK','GRN','XYZ758822893','2025-12-18 16:21:23','2025-12-18 16:21:23'),(218,'XYZ-1766074883227-9A38C510',4,NULL,'IN_STOCK','GRN','XYZ164721712','2025-12-18 16:21:23','2025-12-18 16:21:23'),(219,'XYZ-1766074883255-2D372AC9',4,NULL,'IN_STOCK','GRN','XYZ485750028','2025-12-18 16:21:23','2025-12-18 16:21:23'),(220,'XYZ-1766074883285-9CA046BE',4,NULL,'IN_STOCK','GRN','XYZ154039197','2025-12-18 16:21:23','2025-12-18 16:21:23'),(221,'XYZ-1766074883313-3E451BB9',4,NULL,'IN_STOCK','GRN','XYZ667170398','2025-12-18 16:21:23','2025-12-18 16:21:23'),(222,'XYZ-1766074883348-0B88BF6F',4,NULL,'IN_STOCK','GRN','XYZ771631512','2025-12-18 16:21:23','2025-12-18 16:21:23'),(223,'XYZ-1766074883378-0AB8E76F',4,NULL,'IN_STOCK','GRN','XYZ270036717','2025-12-18 16:21:23','2025-12-18 16:21:23'),(224,'XYZ-1766074883407-49C0FBDF',4,NULL,'IN_STOCK','GRN','XYZ468191036','2025-12-18 16:21:23','2025-12-18 16:21:23'),(225,'XYZ-1766074883438-8162BA70',4,NULL,'IN_STOCK','GRN','XYZ288782792','2025-12-18 16:21:23','2025-12-18 16:21:23'),(226,'XYZ-1766074883467-25FDB420',4,NULL,'IN_STOCK','GRN','XYZ260487018','2025-12-18 16:21:23','2025-12-18 16:21:23'),(227,'XYZ-1766074883499-1571687E',4,NULL,'IN_STOCK','GRN','XYZ039711833','2025-12-18 16:21:23','2025-12-18 16:21:23'),(228,'XYZ-1766074883527-73C7B067',4,NULL,'IN_STOCK','GRN','XYZ781919062','2025-12-18 16:21:23','2025-12-18 16:21:23'),(229,'XYZ-1766074883553-4DDF2F1E',4,NULL,'IN_STOCK','GRN','XYZ706677611','2025-12-18 16:21:23','2025-12-18 16:21:23'),(230,'XYZ-1766074883582-BE596523',4,NULL,'IN_STOCK','GRN','XYZ206658754','2025-12-18 16:21:23','2025-12-18 16:21:23'),(231,'XYZ-1766074883606-396F61B3',4,NULL,'IN_STOCK','GRN','XYZ753500730','2025-12-18 16:21:23','2025-12-18 16:21:23'),(232,'XYZ-1766074883637-E117A584',4,NULL,'IN_STOCK','GRN','XYZ827147383','2025-12-18 16:21:23','2025-12-18 16:21:23'),(233,'XYZ-1766074883666-5A2420F5',4,NULL,'IN_STOCK','GRN','XYZ937765465','2025-12-18 16:21:23','2025-12-18 16:21:23'),(234,'XYZ-1766074883693-E103A486',4,NULL,'IN_STOCK','GRN','XYZ394991788','2025-12-18 16:21:23','2025-12-18 16:21:23'),(235,'XYZ-1766074883717-7E8F7AF7',4,NULL,'IN_STOCK','GRN','XYZ055910778','2025-12-18 16:21:23','2025-12-18 16:21:23'),(236,'XYZ-1766074883743-4673BF83',4,NULL,'IN_STOCK','GRN','XYZ233614720','2025-12-18 16:21:23','2025-12-18 16:21:23'),(237,'XYZ-1766074883769-F8B2A0E4',4,NULL,'IN_STOCK','GRN','XYZ695930186','2025-12-18 16:21:23','2025-12-18 16:21:23'),(238,'XYZ-1766074883796-605846D2',4,NULL,'IN_STOCK','GRN','XYZ811332377','2025-12-18 16:21:23','2025-12-18 16:21:23'),(239,'XYZ-1766074883825-F6F7A95A',4,NULL,'IN_STOCK','GRN','XYZ058864646','2025-12-18 16:21:23','2025-12-18 16:21:23'),(240,'XYZ-1766074883854-43A5441E',4,NULL,'IN_STOCK','GRN','XYZ512729318','2025-12-18 16:21:23','2025-12-18 16:21:23'),(241,'XYZ-1766074883882-92046184',4,NULL,'IN_STOCK','GRN','XYZ971343929','2025-12-18 16:21:23','2025-12-18 16:21:23'),(242,'XYZ-1766074883910-8A380D1C',4,NULL,'IN_STOCK','GRN','XYZ892647579','2025-12-18 16:21:23','2025-12-18 16:21:23'),(243,'XYZ-1766074883938-AF953948',4,NULL,'IN_STOCK','GRN','XYZ162683750','2025-12-18 16:21:23','2025-12-18 16:21:23'),(244,'XYZ-1766074883966-81BD99AC',4,NULL,'IN_STOCK','GRN','XYZ032816263','2025-12-18 16:21:23','2025-12-18 16:21:23'),(245,'XYZ-1766074883997-EAF65AFA',4,NULL,'IN_STOCK','GRN','XYZ322520667','2025-12-18 16:21:24','2025-12-18 16:21:24'),(246,'XYZ-1766074884023-2344C2F3',4,NULL,'IN_STOCK','GRN','XYZ592535352','2025-12-18 16:21:24','2025-12-18 16:21:24'),(247,'XYZ-1766074884050-D167B76F',4,NULL,'IN_STOCK','GRN','XYZ458937846','2025-12-18 16:21:24','2025-12-18 16:21:24'),(248,'XYZ-1766074884077-A25E6D46',4,NULL,'IN_STOCK','GRN','XYZ684791601','2025-12-18 16:21:24','2025-12-18 16:21:24'),(249,'XYZ-1766074884106-BF487299',4,NULL,'IN_STOCK','GRN','XYZ260713171','2025-12-18 16:21:24','2025-12-18 16:21:24'),(250,'XYZ-1766074884135-DE9FC880',4,NULL,'IN_STOCK','GRN','XYZ961633456','2025-12-18 16:21:24','2025-12-18 16:21:24'),(251,'XYZ-1766074884164-186B0BA6',4,NULL,'IN_STOCK','GRN','XYZ815655039','2025-12-18 16:21:24','2025-12-18 16:21:24'),(252,'XYZ-1766074884192-967F4404',4,NULL,'IN_STOCK','GRN','XYZ509599047','2025-12-18 16:21:24','2025-12-18 16:21:24'),(253,'XYZ-1766074884213-FFC79D14',4,NULL,'IN_STOCK','GRN','XYZ258909233','2025-12-18 16:21:24','2025-12-18 16:21:24'),(254,'XYZ-1766074884240-50D4F38E',4,NULL,'IN_STOCK','GRN','XYZ265757979','2025-12-18 16:21:24','2025-12-18 16:21:24'),(255,'XYZ-1766074884266-86A24632',4,NULL,'IN_STOCK','GRN','XYZ780929536','2025-12-18 16:21:24','2025-12-18 16:21:24'),(256,'XYZ-1766074884291-B1F2788A',4,NULL,'IN_STOCK','GRN','XYZ361775263','2025-12-18 16:21:24','2025-12-18 16:21:24'),(257,'XYZ-1766074884316-C00AE91A',4,NULL,'IN_STOCK','GRN','XYZ067113702','2025-12-18 16:21:24','2025-12-18 16:21:24'),(258,'XYZ-1766074884342-6F68E7C9',4,NULL,'IN_STOCK','GRN','XYZ425449744','2025-12-18 16:21:24','2025-12-18 16:21:24'),(259,'XYZ-1766074884369-ED4F4713',4,NULL,'IN_STOCK','GRN','XYZ450185067','2025-12-18 16:21:24','2025-12-18 16:21:24'),(260,'XYZ-1766074884397-EA126E47',4,NULL,'IN_STOCK','GRN','XYZ413343246','2025-12-18 16:21:24','2025-12-18 16:21:24'),(261,'XYZ-1766074884426-3FBF6CE7',4,NULL,'IN_STOCK','GRN','XYZ908463114','2025-12-18 16:21:24','2025-12-18 16:21:24'),(262,'XYZ-1766074884454-3B7159F3',4,NULL,'IN_STOCK','GRN','XYZ046331231','2025-12-18 16:21:24','2025-12-18 16:21:24'),(263,'XYZ-1766074884480-0721E2B0',4,NULL,'IN_STOCK','GRN','XYZ325733147','2025-12-18 16:21:24','2025-12-18 16:21:24'),(264,'XYZ-1766074884508-560AC5F4',4,NULL,'IN_STOCK','GRN','XYZ171241098','2025-12-18 16:21:24','2025-12-18 16:21:24'),(265,'XYZ-1766074884539-FFF60EF7',4,NULL,'IN_STOCK','GRN','XYZ449770694','2025-12-18 16:21:24','2025-12-18 16:21:24'),(266,'XYZ-1766074884563-AB4ADC7A',4,NULL,'IN_STOCK','GRN','XYZ872645679','2025-12-18 16:21:24','2025-12-18 16:21:24'),(267,'XYZ-1766074884584-91DB0F64',4,NULL,'IN_STOCK','GRN','XYZ688329709','2025-12-18 16:21:24','2025-12-18 16:21:24'),(268,'XYZ-1766074884606-1DF0A54D',4,NULL,'IN_STOCK','GRN','XYZ141493594','2025-12-18 16:21:24','2025-12-18 16:21:24'),(269,'XYZ-1766074884629-2F70A834',4,NULL,'IN_STOCK','GRN','XYZ556027543','2025-12-18 16:21:24','2025-12-18 16:21:24'),(270,'XYZ-1766074884653-1661DB86',4,NULL,'IN_STOCK','GRN','XYZ759813715','2025-12-18 16:21:24','2025-12-18 16:21:24'),(271,'XYZ-1766074884683-FDE7C534',4,NULL,'IN_STOCK','GRN','XYZ452163725','2025-12-18 16:21:24','2025-12-18 16:21:24'),(272,'XYZ-1766074884706-FBEC79C7',4,NULL,'IN_STOCK','GRN','XYZ168854070','2025-12-18 16:21:24','2025-12-18 16:21:24'),(273,'XYZ-1766074884729-71022678',4,NULL,'IN_STOCK','GRN','XYZ839829391','2025-12-18 16:21:24','2025-12-18 16:21:24'),(274,'XYZ-1766074884753-0FEBF0B4',4,NULL,'IN_STOCK','GRN','XYZ062400334','2025-12-18 16:21:24','2025-12-18 16:21:24'),(275,'XYZ-1766074884782-1BC5909F',4,NULL,'IN_STOCK','GRN','XYZ087902165','2025-12-18 16:21:24','2025-12-18 16:21:24'),(276,'XYZ-1766074884808-A9B085E7',4,NULL,'IN_STOCK','GRN','XYZ369457516','2025-12-18 16:21:24','2025-12-18 16:21:24'),(277,'XYZ-1766074884840-3667321A',4,NULL,'IN_STOCK','GRN','XYZ996720399','2025-12-18 16:21:24','2025-12-18 16:21:24'),(278,'XYZ-1766074884870-D9CE59D8',4,NULL,'IN_STOCK','GRN','XYZ208502361','2025-12-18 16:21:24','2025-12-18 16:21:24'),(279,'XYZ-1766074884899-972FCC50',4,NULL,'IN_STOCK','GRN','XYZ032197446','2025-12-18 16:21:24','2025-12-18 16:21:24'),(280,'XYZ-1766074884928-3E998C40',4,NULL,'IN_STOCK','GRN','XYZ162502536','2025-12-18 16:21:24','2025-12-18 16:21:24'),(281,'XYZ-1766074884956-9C90F102',4,NULL,'IN_STOCK','GRN','XYZ140877249','2025-12-18 16:21:24','2025-12-18 16:21:24'),(282,'XYZ-1766074884985-9A7582EC',4,NULL,'IN_STOCK','GRN','XYZ725464785','2025-12-18 16:21:24','2025-12-18 16:21:24'),(283,'XYZ-1766074885014-DC0C1C6D',4,NULL,'IN_STOCK','GRN','XYZ981000948','2025-12-18 16:21:25','2025-12-18 16:21:25'),(284,'XYZ-1766074885041-D9C39D8B',4,NULL,'IN_STOCK','GRN','XYZ592255333','2025-12-18 16:21:25','2025-12-18 16:21:25'),(285,'XYZ-1766074885068-343292C2',4,NULL,'IN_STOCK','GRN','XYZ869838201','2025-12-18 16:21:25','2025-12-18 16:21:25'),(286,'XYZ-1766074885089-B9A13927',4,NULL,'IN_STOCK','GRN','XYZ519113159','2025-12-18 16:21:25','2025-12-18 16:21:25'),(287,'XYZ-1766074885109-2B707117',4,NULL,'IN_STOCK','GRN','XYZ725620614','2025-12-18 16:21:25','2025-12-18 16:21:25'),(288,'XYZ-1766074885131-EE1F9EC4',4,NULL,'IN_STOCK','GRN','XYZ470564331','2025-12-18 16:21:25','2025-12-18 16:21:25'),(289,'XYZ-1766074885157-99974B9D',4,NULL,'IN_STOCK','GRN','XYZ347074319','2025-12-18 16:21:25','2025-12-18 16:21:25'),(290,'XYZ-1766074885186-F3375A70',4,NULL,'IN_STOCK','GRN','XYZ174069291','2025-12-18 16:21:25','2025-12-18 16:21:25'),(291,'XYZ-1766074885211-EC4F7D50',4,NULL,'IN_STOCK','GRN','XYZ444971683','2025-12-18 16:21:25','2025-12-18 16:21:25'),(292,'XYZ-1766074885238-08E0BB3D',4,NULL,'IN_STOCK','GRN','XYZ675998203','2025-12-18 16:21:25','2025-12-18 16:21:25'),(293,'XYZ-1766074885269-68B500C8',4,NULL,'IN_STOCK','GRN','XYZ767916094','2025-12-18 16:21:25','2025-12-18 16:21:25'),(294,'XYZ-1766074885297-9848A59C',4,NULL,'IN_STOCK','GRN','XYZ325168756','2025-12-18 16:21:25','2025-12-18 16:21:25'),(295,'XYZ-1766074885325-A8C0BBE3',4,NULL,'IN_STOCK','GRN','XYZ693343419','2025-12-18 16:21:25','2025-12-18 16:21:25'),(296,'XYZ-1766074885351-754C9356',4,NULL,'IN_STOCK','GRN','XYZ933935648','2025-12-18 16:21:25','2025-12-18 16:21:25'),(297,'XYZ-1766074885379-58DE1112',4,NULL,'IN_STOCK','GRN','XYZ075235164','2025-12-18 16:21:25','2025-12-18 16:21:25'),(298,'XYZ-1766074885407-FD0E6D37',4,NULL,'IN_STOCK','GRN','XYZ847746985','2025-12-18 16:21:25','2025-12-18 16:21:25'),(299,'XYZ-1766074885428-E85A3704',4,NULL,'IN_STOCK','GRN','XYZ223408931','2025-12-18 16:21:25','2025-12-18 16:21:25'),(300,'XYZ-1766074885453-CF69991B',4,NULL,'IN_STOCK','GRN','XYZ424777334','2025-12-18 16:21:25','2025-12-18 16:21:25'),(301,'XYZ-1766074885480-9157790C',4,NULL,'IN_STOCK','GRN','XYZ230136804','2025-12-18 16:21:25','2025-12-18 16:21:25'),(302,'XYZ-1766074885506-A68EEC65',4,NULL,'IN_STOCK','GRN','XYZ542397124','2025-12-18 16:21:25','2025-12-18 16:21:25'),(303,'XYZ-1766074885535-642FCBB8',4,NULL,'IN_STOCK','GRN','XYZ953437002','2025-12-18 16:21:25','2025-12-18 16:21:25'),(304,'XYZ-1766074885563-9CF89479',4,NULL,'IN_STOCK','GRN','XYZ258306770','2025-12-18 16:21:25','2025-12-18 16:21:25'),(305,'XYZ-1766074885591-E16428DA',4,NULL,'IN_STOCK','GRN','XYZ534176021','2025-12-18 16:21:25','2025-12-18 16:21:25'),(306,'XYZ-1766074885621-4CBD5394',4,NULL,'IN_STOCK','GRN','XYZ699921545','2025-12-18 16:21:25','2025-12-18 16:21:25'),(307,'XYZ-1766074885649-148933CC',4,NULL,'IN_STOCK','GRN','XYZ145985140','2025-12-18 16:21:25','2025-12-18 16:21:25'),(308,'XYZ-1766074885679-83F6199E',4,NULL,'IN_STOCK','GRN','XYZ410538673','2025-12-18 16:21:25','2025-12-18 16:21:25'),(309,'XYZ-1766074885702-B482F535',4,NULL,'IN_STOCK','GRN','XYZ636186949','2025-12-18 16:21:25','2025-12-18 16:21:25'),(310,'XYZ-1766074885730-43F790FD',4,NULL,'IN_STOCK','GRN','XYZ371388862','2025-12-18 16:21:25','2025-12-18 16:21:25'),(311,'XYZ-1766074885759-3D5476EF',4,NULL,'IN_STOCK','GRN','XYZ460429850','2025-12-18 16:21:25','2025-12-18 16:21:25'),(312,'XYZ-1766074885786-8ED6D0F4',4,NULL,'IN_STOCK','GRN','XYZ562840548','2025-12-18 16:21:25','2025-12-18 16:21:25'),(313,'XYZ-1766074885811-DBDDE231',4,NULL,'IN_STOCK','GRN','XYZ540636353','2025-12-18 16:21:25','2025-12-18 16:21:25'),(314,'XYZ-1766074885836-66C92FFD',4,NULL,'IN_STOCK','GRN','XYZ190622588','2025-12-18 16:21:25','2025-12-18 16:21:25'),(315,'XYZ-1766074885860-826CE656',4,NULL,'IN_STOCK','GRN','XYZ151300264','2025-12-18 16:21:25','2025-12-18 16:21:25'),(316,'XYZ-1766074885889-B659B513',4,NULL,'IN_STOCK','GRN','XYZ003578792','2025-12-18 16:21:25','2025-12-18 16:21:25'),(317,'XYZ-1766074885919-1A32C166',4,NULL,'IN_STOCK','GRN','XYZ386682661','2025-12-18 16:21:25','2025-12-18 16:21:25'),(318,'XYZ-1766074885948-3894B63E',4,NULL,'IN_STOCK','GRN','XYZ094930586','2025-12-18 16:21:25','2025-12-18 16:21:25'),(319,'XYZ-1766074885976-81EE8DF7',4,NULL,'IN_STOCK','GRN','XYZ548759694','2025-12-18 16:21:25','2025-12-18 16:21:25'),(320,'XYZ-1766074886004-936EDC59',4,NULL,'IN_STOCK','GRN','XYZ821501407','2025-12-18 16:21:26','2025-12-18 16:21:26'),(321,'XYZ-1766074886030-D82E25B7',4,NULL,'IN_STOCK','GRN','XYZ727811323','2025-12-18 16:21:26','2025-12-18 16:21:26'),(322,'XYZ-1766074886058-099F7A16',4,NULL,'IN_STOCK','GRN','XYZ149059689','2025-12-18 16:21:26','2025-12-18 16:21:26'),(323,'XYZ-1766074886086-515ABCA1',4,NULL,'IN_STOCK','GRN','XYZ290863136','2025-12-18 16:21:26','2025-12-18 16:21:26'),(324,'XYZ-1766074886112-325EBB41',4,NULL,'IN_STOCK','GRN','XYZ846620763','2025-12-18 16:21:26','2025-12-18 16:21:26'),(325,'XYZ-1766074886141-1A12E4B2',4,NULL,'IN_STOCK','GRN','XYZ890266828','2025-12-18 16:21:26','2025-12-18 16:21:26'),(326,'XYZ-1766074886169-FE324372',4,NULL,'IN_STOCK','GRN','XYZ958012676','2025-12-18 16:21:26','2025-12-18 16:21:26'),(327,'XYZ-1766074886192-3AC15306',4,NULL,'IN_STOCK','GRN','XYZ586980283','2025-12-18 16:21:26','2025-12-18 16:21:26'),(328,'XYZ-1766074886219-8CDB7978',4,NULL,'IN_STOCK','GRN','XYZ533925166','2025-12-18 16:21:26','2025-12-18 16:21:26'),(329,'XYZ-1766074886246-B139FC5D',4,NULL,'IN_STOCK','GRN','XYZ104555966','2025-12-18 16:21:26','2025-12-18 16:21:26'),(330,'XYZ-1766074886275-6BB6D0E4',4,NULL,'IN_STOCK','GRN','XYZ197407320','2025-12-18 16:21:26','2025-12-18 16:21:26'),(331,'XYZ-1766074886304-98030674',4,NULL,'IN_STOCK','GRN','XYZ437371883','2025-12-18 16:21:26','2025-12-18 16:21:26'),(332,'XYZ-1766074886331-D2E84F0C',4,NULL,'IN_STOCK','GRN','XYZ149749932','2025-12-18 16:21:26','2025-12-18 16:21:26'),(333,'XYZ-1766074886357-DD39A74F',4,NULL,'IN_STOCK','GRN','XYZ012806092','2025-12-18 16:21:26','2025-12-18 16:21:26'),(334,'XYZ-1766074886385-E3D82973',4,NULL,'IN_STOCK','GRN','XYZ819515342','2025-12-18 16:21:26','2025-12-18 16:21:26'),(335,'XYZ-1766074886414-7D281C98',4,NULL,'IN_STOCK','GRN','XYZ621894634','2025-12-18 16:21:26','2025-12-18 16:21:26'),(336,'XYZ-1766074886441-E7B50484',4,NULL,'IN_STOCK','GRN','XYZ003987945','2025-12-18 16:21:26','2025-12-18 16:21:26'),(337,'XYZ-1766074886469-FB591B93',4,NULL,'IN_STOCK','GRN','XYZ155392852','2025-12-18 16:21:26','2025-12-18 16:21:26'),(338,'XYZ-1766074886497-3F487850',4,NULL,'IN_STOCK','GRN','XYZ665786451','2025-12-18 16:21:26','2025-12-18 16:21:26'),(339,'XYZ-1766074886523-B41121AE',4,NULL,'IN_STOCK','GRN','XYZ986428075','2025-12-18 16:21:26','2025-12-18 16:21:26'),(340,'XYZ-1766074886545-92A1C983',4,NULL,'IN_STOCK','GRN','XYZ829279006','2025-12-18 16:21:26','2025-12-18 16:21:26'),(341,'XYZ-1766074886570-49A1BAF6',4,NULL,'IN_STOCK','GRN','XYZ569477048','2025-12-18 16:21:26','2025-12-18 16:21:26'),(342,'XYZ-1766074886595-031768C5',4,NULL,'IN_STOCK','GRN','XYZ054767882','2025-12-18 16:21:26','2025-12-18 16:21:26'),(343,'XYZ-1766074886621-F6FFDA5D',4,NULL,'IN_STOCK','GRN','XYZ642580179','2025-12-18 16:21:26','2025-12-18 16:21:26'),(344,'XYZ-1766074886647-25B3AC70',4,NULL,'IN_STOCK','GRN','XYZ205383016','2025-12-18 16:21:26','2025-12-18 16:21:26'),(345,'XYZ-1766074886675-48C91120',4,NULL,'IN_STOCK','GRN','XYZ186563700','2025-12-18 16:21:26','2025-12-18 16:21:26'),(346,'XYZ-1766074886698-48799A44',4,NULL,'IN_STOCK','GRN','XYZ521606638','2025-12-18 16:21:26','2025-12-18 16:21:26'),(347,'XYZ-1766074886721-05C5698F',4,NULL,'IN_STOCK','GRN','XYZ554058093','2025-12-18 16:21:26','2025-12-18 16:21:26'),(348,'XYZ-1766074886750-63193157',4,NULL,'IN_STOCK','GRN','XYZ540308178','2025-12-18 16:21:26','2025-12-18 16:21:26'),(349,'XYZ-1766074886778-248DA290',4,NULL,'IN_STOCK','GRN','XYZ606646491','2025-12-18 16:21:26','2025-12-18 16:21:26'),(350,'XYZ-1766074886806-9060BF62',4,NULL,'IN_STOCK','GRN','XYZ999644271','2025-12-18 16:21:26','2025-12-18 16:21:26'),(351,'XYZ-1766074886833-BF2F1074',4,NULL,'IN_STOCK','GRN','XYZ607706188','2025-12-18 16:21:26','2025-12-18 16:21:26'),(352,'XYZ-1766074886862-62642D0B',4,NULL,'IN_STOCK','GRN','XYZ968011918','2025-12-18 16:21:26','2025-12-18 16:21:26'),(353,'XYZ-1766074886891-598F0531',4,NULL,'IN_STOCK','GRN','XYZ810601820','2025-12-18 16:21:26','2025-12-18 16:21:26'),(354,'XYZ-1766074886918-8A9F8F45',4,NULL,'IN_STOCK','GRN','XYZ870935785','2025-12-18 16:21:26','2025-12-18 16:21:26'),(355,'XYZ-1766074886945-AAB10892',4,NULL,'IN_STOCK','GRN','XYZ719438512','2025-12-18 16:21:26','2025-12-18 16:21:26'),(356,'XYZ-1766074886972-7991D62E',4,NULL,'IN_STOCK','GRN','XYZ685801957','2025-12-18 16:21:26','2025-12-18 16:21:26'),(357,'XYZ-1766074887002-F08F14A2',4,NULL,'IN_STOCK','GRN','XYZ575320067','2025-12-18 16:21:27','2025-12-18 16:21:27'),(358,'XYZ-1766074887029-2E33BEDE',4,NULL,'IN_STOCK','GRN','XYZ754436849','2025-12-18 16:21:27','2025-12-18 16:21:27'),(359,'XYZ-1766074887057-938A4698',4,NULL,'IN_STOCK','GRN','XYZ604605410','2025-12-18 16:21:27','2025-12-18 16:21:27'),(360,'XYZ-1766074887082-0ECB0D68',4,NULL,'IN_STOCK','GRN','XYZ255312574','2025-12-18 16:21:27','2025-12-18 16:21:27'),(361,'XYZ-1766074887110-91D1A0DA',4,NULL,'IN_STOCK','GRN','XYZ562480250','2025-12-18 16:21:27','2025-12-18 16:21:27'),(362,'XYZ-1766074887136-281ECBD6',4,NULL,'IN_STOCK','GRN','XYZ224909182','2025-12-18 16:21:27','2025-12-18 16:21:27'),(363,'XYZ-1766074887165-E5F261B4',4,NULL,'IN_STOCK','GRN','XYZ447409006','2025-12-18 16:21:27','2025-12-18 16:21:27'),(364,'XYZ-1766074887192-519F83A4',4,NULL,'IN_STOCK','GRN','XYZ861557435','2025-12-18 16:21:27','2025-12-18 16:21:27'),(365,'XYZ-1766074887220-0FDC01E5',4,NULL,'IN_STOCK','GRN','XYZ850395019','2025-12-18 16:21:27','2025-12-18 16:21:27'),(366,'XYZ-1766074887246-CB3E9414',4,NULL,'IN_STOCK','GRN','XYZ685869654','2025-12-18 16:21:27','2025-12-18 16:21:27'),(367,'XYZ-1766074887269-E7680219',4,NULL,'IN_STOCK','GRN','XYZ749404166','2025-12-18 16:21:27','2025-12-18 16:21:27'),(368,'XYZ-1766074887297-ACFBC101',4,NULL,'IN_STOCK','GRN','XYZ181522159','2025-12-18 16:21:27','2025-12-18 16:21:27'),(369,'XYZ-1766074887325-54062BF0',4,NULL,'IN_STOCK','GRN','XYZ579284551','2025-12-18 16:21:27','2025-12-18 16:21:27'),(370,'XYZ-1766074887354-B681F7EF',4,NULL,'IN_STOCK','GRN','XYZ332323781','2025-12-18 16:21:27','2025-12-18 16:21:27'),(371,'XYZ-1766074887382-67774FF5',4,NULL,'IN_STOCK','GRN','XYZ557049192','2025-12-18 16:21:27','2025-12-18 16:21:27'),(372,'XYZ-1766074887407-770242CE',4,NULL,'IN_STOCK','GRN','XYZ524840756','2025-12-18 16:21:27','2025-12-18 16:21:27'),(373,'XYZ-1766074887433-AD16116C',4,NULL,'IN_STOCK','GRN','XYZ013440495','2025-12-18 16:21:27','2025-12-18 16:21:27'),(374,'XYZ-1766074887458-E84E48DC',4,NULL,'IN_STOCK','GRN','XYZ978212535','2025-12-18 16:21:27','2025-12-18 16:21:27'),(375,'XYZ-1766074887479-BEA77B17',4,NULL,'IN_STOCK','GRN','XYZ525706827','2025-12-18 16:21:27','2025-12-18 16:21:27'),(376,'XYZ-1766074887506-2A65AC1F',4,NULL,'IN_STOCK','GRN','XYZ376984847','2025-12-18 16:21:27','2025-12-18 16:21:27'),(377,'XYZ-1766074887534-268C7503',4,NULL,'IN_STOCK','GRN','XYZ733858629','2025-12-18 16:21:27','2025-12-18 16:21:27'),(378,'XYZ-1766074887561-31D2D7F1',4,NULL,'IN_STOCK','GRN','XYZ139092680','2025-12-18 16:21:27','2025-12-18 16:21:27'),(379,'XYZ-1766074887589-01042CA5',4,NULL,'IN_STOCK','GRN','XYZ850534946','2025-12-18 16:21:27','2025-12-18 16:21:27'),(380,'XYZ-1766074887615-3A70F82E',4,NULL,'IN_STOCK','GRN','XYZ152425511','2025-12-18 16:21:27','2025-12-18 16:21:27'),(381,'XYZ-1766074887644-C81246C3',4,NULL,'IN_STOCK','GRN','XYZ884704484','2025-12-18 16:21:27','2025-12-18 16:21:27'),(382,'XYZ-1766074887672-7A6D1694',4,NULL,'IN_STOCK','GRN','XYZ996766475','2025-12-18 16:21:27','2025-12-18 16:21:27'),(383,'XYZ-1766074887700-C825EE5E',4,NULL,'IN_STOCK','GRN','XYZ653845873','2025-12-18 16:21:27','2025-12-18 16:21:27'),(384,'XYZ-1766074887727-ABA47B41',4,NULL,'IN_STOCK','GRN','XYZ377300288','2025-12-18 16:21:27','2025-12-18 16:21:27'),(385,'XYZ-1766074887753-2E24CF83',4,NULL,'IN_STOCK','GRN','XYZ158259384','2025-12-18 16:21:27','2025-12-18 16:21:27'),(386,'XYZ-1766074887778-D3B290C8',4,NULL,'IN_STOCK','GRN','XYZ727319949','2025-12-18 16:21:27','2025-12-18 16:21:27'),(387,'XYZ-1766074887806-B73BCAA2',4,NULL,'IN_STOCK','GRN','XYZ071216047','2025-12-18 16:21:27','2025-12-18 16:21:27'),(388,'XYZ-1766074887832-3566E2A9',4,NULL,'IN_STOCK','GRN','XYZ246891330','2025-12-18 16:21:27','2025-12-18 16:21:27'),(389,'XYZ-1766074887861-D632E7C0',4,NULL,'IN_STOCK','GRN','XYZ051219120','2025-12-18 16:21:27','2025-12-18 16:21:27'),(390,'XYZ-1766074887890-6AD56775',4,NULL,'IN_STOCK','GRN','XYZ567244844','2025-12-18 16:21:27','2025-12-18 16:21:27'),(391,'XYZ-1766074887915-C4D5577F',4,NULL,'IN_STOCK','GRN','XYZ334104035','2025-12-18 16:21:27','2025-12-18 16:21:27'),(392,'XYZ-1766074887942-57FA26AA',4,NULL,'IN_STOCK','GRN','XYZ159154525','2025-12-18 16:21:27','2025-12-18 16:21:27'),(393,'XYZ-1766074887968-367D267D',4,NULL,'IN_STOCK','GRN','XYZ790878977','2025-12-18 16:21:27','2025-12-18 16:21:27'),(394,'XYZ-1766074887994-BEB547BB',4,NULL,'IN_STOCK','GRN','XYZ797883532','2025-12-18 16:21:28','2025-12-18 16:21:28'),(395,'XYZ-1766074888021-7D9B32AC',4,NULL,'IN_STOCK','GRN','XYZ796017981','2025-12-18 16:21:28','2025-12-18 16:21:28'),(396,'XYZ-1766074888046-8102994E',4,NULL,'IN_STOCK','GRN','XYZ530712545','2025-12-18 16:21:28','2025-12-18 16:21:28'),(397,'XYZ-1766074888074-622D91E3',4,NULL,'IN_STOCK','GRN','XYZ855522941','2025-12-18 16:21:28','2025-12-18 16:21:28'),(398,'XYZ-1766074888097-3696574A',4,NULL,'IN_STOCK','GRN','XYZ110808879','2025-12-18 16:21:28','2025-12-18 16:21:28'),(399,'XYZ-1766074888124-6F35673E',4,NULL,'IN_STOCK','GRN','XYZ117722374','2025-12-18 16:21:28','2025-12-18 16:21:28'),(400,'XYZ-1766074888150-0F9D5614',4,NULL,'IN_STOCK','GRN','XYZ113247885','2025-12-18 16:21:28','2025-12-18 16:21:28'),(401,'XYZ-1766074888173-3DC61FBA',5,NULL,'IN_STOCK','GRN','XYZ275815995','2025-12-18 16:21:28','2025-12-18 16:21:28'),(402,'XYZ-1766074888199-720BA633',5,NULL,'IN_STOCK','GRN','XYZ318032985','2025-12-18 16:21:28','2025-12-18 16:21:28'),(403,'XYZ-1766074888227-B03DA6DE',5,NULL,'IN_STOCK','GRN','XYZ839481682','2025-12-18 16:21:28','2025-12-18 16:21:28'),(404,'XYZ-1766074888247-4C033DDE',5,NULL,'IN_STOCK','GRN','XYZ300689315','2025-12-18 16:21:28','2025-12-18 16:21:28'),(405,'XYZ-1766074888269-48E38C4F',5,NULL,'IN_STOCK','GRN','XYZ904321490','2025-12-18 16:21:28','2025-12-18 16:21:28'),(406,'XYZ-1766074888293-64C5BEFF',5,NULL,'IN_STOCK','GRN','XYZ078505962','2025-12-18 16:21:28','2025-12-18 16:21:28'),(407,'XYZ-1766074888319-360FCE84',5,NULL,'IN_STOCK','GRN','XYZ120810857','2025-12-18 16:21:28','2025-12-18 16:21:28'),(408,'XYZ-1766074888345-9B7573F4',5,NULL,'IN_STOCK','GRN','XYZ570213270','2025-12-18 16:21:28','2025-12-18 16:21:28'),(409,'XYZ-1766074888373-30EB2B64',5,NULL,'IN_STOCK','GRN','XYZ207007257','2025-12-18 16:21:28','2025-12-18 16:21:28'),(410,'XYZ-1766074888402-71B10C9F',5,NULL,'IN_STOCK','GRN','XYZ572271730','2025-12-18 16:21:28','2025-12-18 16:21:28'),(411,'XYZ-1766074888428-5158131A',5,NULL,'IN_STOCK','GRN','XYZ880734595','2025-12-18 16:21:28','2025-12-18 16:21:28'),(412,'XYZ-1766074888455-1D5BC98E',5,NULL,'IN_STOCK','GRN','XYZ547341585','2025-12-18 16:21:28','2025-12-18 16:21:28'),(413,'XYZ-1766074888484-CB15B072',5,NULL,'IN_STOCK','GRN','XYZ273643990','2025-12-18 16:21:28','2025-12-18 16:21:28'),(414,'XYZ-1766074888512-4D9D7F3D',5,NULL,'IN_STOCK','GRN','XYZ522998966','2025-12-18 16:21:28','2025-12-18 16:21:28'),(415,'XYZ-1766074888540-DD28D532',5,NULL,'IN_STOCK','GRN','XYZ289799158','2025-12-18 16:21:28','2025-12-18 16:21:28'),(416,'XYZ-1766074888568-DD546AEE',5,NULL,'IN_STOCK','GRN','XYZ852941694','2025-12-18 16:21:28','2025-12-18 16:21:28'),(417,'XYZ-1766074888597-AAB5C754',5,NULL,'IN_STOCK','GRN','XYZ327852387','2025-12-18 16:21:28','2025-12-18 16:21:28'),(418,'XYZ-1766074888625-6EE5BD8D',5,NULL,'IN_STOCK','GRN','XYZ103009054','2025-12-18 16:21:28','2025-12-18 16:21:28'),(419,'XYZ-1766074888653-CE0988DF',5,NULL,'IN_STOCK','GRN','XYZ646380892','2025-12-18 16:21:28','2025-12-18 16:21:28'),(420,'XYZ-1766074888682-EAB49AD5',5,NULL,'IN_STOCK','GRN','XYZ596498865','2025-12-18 16:21:28','2025-12-18 16:21:28'),(421,'XYZ-1766074888711-8EF8644C',5,NULL,'IN_STOCK','GRN','XYZ549867712','2025-12-18 16:21:28','2025-12-18 16:21:28'),(422,'XYZ-1766074888739-19BDCB56',5,NULL,'IN_STOCK','GRN','XYZ777247050','2025-12-18 16:21:28','2025-12-18 16:21:28'),(423,'XYZ-1766074888766-71823344',5,NULL,'IN_STOCK','GRN','XYZ480101131','2025-12-18 16:21:28','2025-12-18 16:21:28'),(424,'XYZ-1766074888795-3584210A',5,NULL,'IN_STOCK','GRN','XYZ999293716','2025-12-18 16:21:28','2025-12-18 16:21:28'),(425,'XYZ-1766074888823-810BCDE1',5,NULL,'IN_STOCK','GRN','XYZ983342587','2025-12-18 16:21:28','2025-12-18 16:21:28'),(426,'XYZ-1766074888850-B2340790',5,NULL,'IN_STOCK','GRN','XYZ964581960','2025-12-18 16:21:28','2025-12-18 16:21:28'),(427,'XYZ-1766074888873-1C65286A',5,NULL,'IN_STOCK','GRN','XYZ734577261','2025-12-18 16:21:28','2025-12-18 16:21:28'),(428,'XYZ-1766074888899-9B4FD461',5,NULL,'IN_STOCK','GRN','XYZ128690649','2025-12-18 16:21:28','2025-12-18 16:21:28'),(429,'XYZ-1766074888928-BAB5E12A',5,NULL,'IN_STOCK','GRN','XYZ475222694','2025-12-18 16:21:28','2025-12-18 16:21:28'),(430,'XYZ-1766074888956-56B7D23E',5,NULL,'IN_STOCK','GRN','XYZ565321181','2025-12-18 16:21:28','2025-12-18 16:21:28'),(431,'XYZ-1766074888985-404A3369',5,NULL,'IN_STOCK','GRN','XYZ072979448','2025-12-18 16:21:28','2025-12-18 16:21:28'),(432,'XYZ-1766074889013-2DEAFDEA',5,NULL,'IN_STOCK','GRN','XYZ698576353','2025-12-18 16:21:29','2025-12-18 16:21:29'),(433,'XYZ-1766074889039-A8DE7D02',5,NULL,'IN_STOCK','GRN','XYZ996865197','2025-12-18 16:21:29','2025-12-18 16:21:29'),(434,'XYZ-1766074889066-6776E336',5,NULL,'IN_STOCK','GRN','XYZ850481460','2025-12-18 16:21:29','2025-12-18 16:21:29'),(435,'XYZ-1766074889094-484AA770',5,NULL,'IN_STOCK','GRN','XYZ578608596','2025-12-18 16:21:29','2025-12-18 16:21:29'),(436,'XYZ-1766074889116-332C4727',5,NULL,'IN_STOCK','GRN','XYZ135815314','2025-12-18 16:21:29','2025-12-18 16:21:29'),(437,'XYZ-1766074889142-3009B900',5,NULL,'IN_STOCK','GRN','XYZ372005452','2025-12-18 16:21:29','2025-12-18 16:21:29'),(438,'XYZ-1766074889170-54283048',5,NULL,'IN_STOCK','GRN','XYZ420644770','2025-12-18 16:21:29','2025-12-18 16:21:29'),(439,'XYZ-1766074889196-5314026B',5,NULL,'IN_STOCK','GRN','XYZ495227252','2025-12-18 16:21:29','2025-12-18 16:21:29'),(440,'XYZ-1766074889223-6F13770F',5,NULL,'IN_STOCK','GRN','XYZ498537470','2025-12-18 16:21:29','2025-12-18 16:21:29'),(441,'XYZ-1766074889249-DA575A14',5,NULL,'IN_STOCK','GRN','XYZ308039106','2025-12-18 16:21:29','2025-12-18 16:21:29'),(442,'XYZ-1766074889274-BA94847D',5,NULL,'IN_STOCK','GRN','XYZ885598758','2025-12-18 16:21:29','2025-12-18 16:21:29'),(443,'XYZ-1766074889300-96D17C28',5,NULL,'IN_STOCK','GRN','XYZ916748079','2025-12-18 16:21:29','2025-12-18 16:21:29'),(444,'XYZ-1766074889327-9C1B2E53',5,NULL,'IN_STOCK','GRN','XYZ552062096','2025-12-18 16:21:29','2025-12-18 16:21:29'),(445,'XYZ-1766074889351-F2F95D90',5,NULL,'IN_STOCK','GRN','XYZ219546124','2025-12-18 16:21:29','2025-12-18 16:21:29'),(446,'XYZ-1766074889376-414A826E',5,NULL,'IN_STOCK','GRN','XYZ602424762','2025-12-18 16:21:29','2025-12-18 16:21:29'),(447,'XYZ-1766074889402-A9E0EFF9',5,NULL,'IN_STOCK','GRN','XYZ520175236','2025-12-18 16:21:29','2025-12-18 16:21:29'),(448,'XYZ-1766074889431-0B303F83',5,NULL,'IN_STOCK','GRN','XYZ968034733','2025-12-18 16:21:29','2025-12-18 16:21:29'),(449,'XYZ-1766074889459-C5E4DC09',5,NULL,'IN_STOCK','GRN','XYZ896994303','2025-12-18 16:21:29','2025-12-18 16:21:29'),(450,'XYZ-1766074889485-E3EB8280',5,NULL,'IN_STOCK','GRN','XYZ371981656','2025-12-18 16:21:29','2025-12-18 16:21:29'),(451,'XYZ-1766074889512-96E56B9B',5,NULL,'IN_STOCK','GRN','XYZ262932774','2025-12-18 16:21:29','2025-12-18 16:21:29'),(452,'XYZ-1766074889539-67A8F88F',5,NULL,'IN_STOCK','GRN','XYZ096062900','2025-12-18 16:21:29','2025-12-18 16:21:29'),(453,'XYZ-1766074889566-D211ABF0',5,NULL,'IN_STOCK','GRN','XYZ197268296','2025-12-18 16:21:29','2025-12-18 16:21:29'),(454,'XYZ-1766074889593-8144B7C3',5,NULL,'IN_STOCK','GRN','XYZ302339602','2025-12-18 16:21:29','2025-12-18 16:21:29'),(455,'XYZ-1766074889622-31116F4C',5,NULL,'IN_STOCK','GRN','XYZ903985929','2025-12-18 16:21:29','2025-12-18 16:21:29'),(456,'XYZ-1766074889645-EEEE0682',5,NULL,'IN_STOCK','GRN','XYZ798763799','2025-12-18 16:21:29','2025-12-18 16:21:29'),(457,'XYZ-1766074889672-C658F773',5,NULL,'IN_STOCK','GRN','XYZ239176045','2025-12-18 16:21:29','2025-12-18 16:21:29'),(458,'XYZ-1766074889700-798A302E',5,NULL,'IN_STOCK','GRN','XYZ284322228','2025-12-18 16:21:29','2025-12-18 16:21:29'),(459,'XYZ-1766074889727-5F9DF0D3',5,NULL,'IN_STOCK','GRN','XYZ881041238','2025-12-18 16:21:29','2025-12-18 16:21:29'),(460,'XYZ-1766074889757-ADA87B6D',5,NULL,'IN_STOCK','GRN','XYZ954998298','2025-12-18 16:21:29','2025-12-18 16:21:29'),(461,'XYZ-1766074889785-D9C0E232',5,NULL,'IN_STOCK','GRN','XYZ398958617','2025-12-18 16:21:29','2025-12-18 16:21:29'),(462,'XYZ-1766074889812-FD594440',5,NULL,'IN_STOCK','GRN','XYZ677201896','2025-12-18 16:21:29','2025-12-18 16:21:29'),(463,'XYZ-1766074889840-FD17BA41',5,NULL,'IN_STOCK','GRN','XYZ076981287','2025-12-18 16:21:29','2025-12-18 16:21:29'),(464,'XYZ-1766074889866-E3B2EF6B',5,NULL,'IN_STOCK','GRN','XYZ396509391','2025-12-18 16:21:29','2025-12-18 16:21:29'),(465,'XYZ-1766074889892-D21509A9',5,NULL,'IN_STOCK','GRN','XYZ594213119','2025-12-18 16:21:29','2025-12-18 16:21:29'),(466,'XYZ-1766074889920-176D7366',5,NULL,'IN_STOCK','GRN','XYZ630226655','2025-12-18 16:21:29','2025-12-18 16:21:29'),(467,'XYZ-1766074889948-146DC3B6',5,NULL,'IN_STOCK','GRN','XYZ038171790','2025-12-18 16:21:29','2025-12-18 16:21:29'),(468,'XYZ-1766074889975-2BBEFDDF',5,NULL,'IN_STOCK','GRN','XYZ338906168','2025-12-18 16:21:29','2025-12-18 16:21:29'),(469,'XYZ-1766074890002-907900F0',5,NULL,'IN_STOCK','GRN','XYZ529778342','2025-12-18 16:21:30','2025-12-18 16:21:30'),(470,'XYZ-1766074890031-B6B382B6',5,NULL,'IN_STOCK','GRN','XYZ350339357','2025-12-18 16:21:30','2025-12-18 16:21:30'),(471,'XYZ-1766074890057-25EB12F7',5,NULL,'IN_STOCK','GRN','XYZ594151767','2025-12-18 16:21:30','2025-12-18 16:21:30'),(472,'XYZ-1766074890082-E378C287',5,NULL,'IN_STOCK','GRN','XYZ413729626','2025-12-18 16:21:30','2025-12-18 16:21:30'),(473,'XYZ-1766074890109-A5F5DBFD',5,NULL,'IN_STOCK','GRN','XYZ750952028','2025-12-18 16:21:30','2025-12-18 16:21:30'),(474,'XYZ-1766074890135-0C2F00E8',5,NULL,'IN_STOCK','GRN','XYZ536647931','2025-12-18 16:21:30','2025-12-18 16:21:30'),(475,'XYZ-1766074890162-FDABB412',5,NULL,'IN_STOCK','GRN','XYZ678076492','2025-12-18 16:21:30','2025-12-18 16:21:30'),(476,'XYZ-1766074890187-7E5661F3',5,NULL,'IN_STOCK','GRN','XYZ105834275','2025-12-18 16:21:30','2025-12-18 16:21:30'),(477,'XYZ-1766074890214-9E84A67B',5,NULL,'IN_STOCK','GRN','XYZ903810539','2025-12-18 16:21:30','2025-12-18 16:21:30'),(478,'XYZ-1766074890241-F3144A46',5,NULL,'IN_STOCK','GRN','XYZ635031863','2025-12-18 16:21:30','2025-12-18 16:21:30'),(479,'XYZ-1766074890263-34659781',5,NULL,'IN_STOCK','GRN','XYZ825539659','2025-12-18 16:21:30','2025-12-18 16:21:30'),(480,'XYZ-1766074890288-F9C78FC1',5,NULL,'IN_STOCK','GRN','XYZ656118688','2025-12-18 16:21:30','2025-12-18 16:21:30'),(481,'XYZ-1766074890309-6A8EBB8C',5,NULL,'IN_STOCK','GRN','XYZ860049200','2025-12-18 16:21:30','2025-12-18 16:21:30'),(482,'XYZ-1766074890329-C6C3FD5B',5,NULL,'IN_STOCK','GRN','XYZ608624085','2025-12-18 16:21:30','2025-12-18 16:21:30'),(483,'XYZ-1766074890353-DD52C1EC',5,NULL,'IN_STOCK','GRN','XYZ380421418','2025-12-18 16:21:30','2025-12-18 16:21:30'),(484,'XYZ-1766074890377-12E2AB23',5,NULL,'IN_STOCK','GRN','XYZ468289798','2025-12-18 16:21:30','2025-12-18 16:21:30'),(485,'XYZ-1766074890397-9F4D1180',5,NULL,'IN_STOCK','GRN','XYZ363533889','2025-12-18 16:21:30','2025-12-18 16:21:30'),(486,'XYZ-1766074890416-3DDC272C',5,NULL,'IN_STOCK','GRN','XYZ359006219','2025-12-18 16:21:30','2025-12-18 16:21:30'),(487,'XYZ-1766074890435-3A8C5CC4',5,NULL,'IN_STOCK','GRN','XYZ505052748','2025-12-18 16:21:30','2025-12-18 16:21:30'),(488,'XYZ-1766074890456-CEC6642C',5,NULL,'IN_STOCK','GRN','XYZ769988670','2025-12-18 16:21:30','2025-12-18 16:21:30'),(489,'XYZ-1766074890485-4B71346D',5,NULL,'IN_STOCK','GRN','XYZ434285422','2025-12-18 16:21:30','2025-12-18 16:21:30'),(490,'XYZ-1766074890512-4BB2C31C',5,NULL,'IN_STOCK','GRN','XYZ946750920','2025-12-18 16:21:30','2025-12-18 16:21:30'),(491,'XYZ-1766074890539-9F5F1B24',5,NULL,'IN_STOCK','GRN','XYZ838670646','2025-12-18 16:21:30','2025-12-18 16:21:30'),(492,'XYZ-1766074890562-48C98631',5,NULL,'IN_STOCK','GRN','XYZ883431288','2025-12-18 16:21:30','2025-12-18 16:21:30'),(493,'XYZ-1766074890589-EFAFAFDD',5,NULL,'IN_STOCK','GRN','XYZ242008571','2025-12-18 16:21:30','2025-12-18 16:21:30'),(494,'XYZ-1766074890610-63EA71D4',5,NULL,'IN_STOCK','GRN','XYZ017730338','2025-12-18 16:21:30','2025-12-18 16:21:30'),(495,'XYZ-1766074890637-7A48AB08',5,NULL,'IN_STOCK','GRN','XYZ022144822','2025-12-18 16:21:30','2025-12-18 16:21:30'),(496,'XYZ-1766074890665-3B059FCF',5,NULL,'IN_STOCK','GRN','XYZ605434013','2025-12-18 16:21:30','2025-12-18 16:21:30'),(497,'XYZ-1766074890691-C249ACFA',5,NULL,'IN_STOCK','GRN','XYZ589807157','2025-12-18 16:21:30','2025-12-18 16:21:30'),(498,'XYZ-1766074890719-F6A1B1CC',5,NULL,'IN_STOCK','GRN','XYZ348498980','2025-12-18 16:21:30','2025-12-18 16:21:30'),(499,'XYZ-1766074890746-EA08256B',5,NULL,'IN_STOCK','GRN','XYZ247612588','2025-12-18 16:21:30','2025-12-18 16:21:30'),(500,'XYZ-1766074890771-5F6A842A',5,NULL,'IN_STOCK','GRN','XYZ608077763','2025-12-18 16:21:30','2025-12-18 16:21:30'),(501,'XYZ-1766074890799-9ABE5FF8',5,NULL,'IN_STOCK','GRN','XYZ697473297','2025-12-18 16:21:30','2025-12-18 16:21:30'),(502,'XYZ-1766074890827-DAF1FD5C',5,NULL,'IN_STOCK','GRN','XYZ635518854','2025-12-18 16:21:30','2025-12-18 16:21:30'),(503,'XYZ-1766074890854-564FF748',5,NULL,'IN_STOCK','GRN','XYZ936663866','2025-12-18 16:21:30','2025-12-18 16:21:30'),(504,'XYZ-1766074890883-7E5EBD6E',5,NULL,'IN_STOCK','GRN','XYZ882185062','2025-12-18 16:21:30','2025-12-18 16:21:30'),(505,'XYZ-1766074890909-A89BBEAB',5,NULL,'IN_STOCK','GRN','XYZ079124343','2025-12-18 16:21:30','2025-12-18 16:21:30'),(506,'XYZ-1766074890935-6E2E6D25',5,NULL,'IN_STOCK','GRN','XYZ933107388','2025-12-18 16:21:30','2025-12-18 16:21:30'),(507,'XYZ-1766074890963-E7572754',5,NULL,'IN_STOCK','GRN','XYZ477090060','2025-12-18 16:21:30','2025-12-18 16:21:30'),(508,'XYZ-1766074890990-DDCC1D1A',5,NULL,'IN_STOCK','GRN','XYZ990372468','2025-12-18 16:21:31','2025-12-18 16:21:31'),(509,'XYZ-1766074891019-7EBE3FFA',5,NULL,'IN_STOCK','GRN','XYZ550506001','2025-12-18 16:21:31','2025-12-18 16:21:31'),(510,'XYZ-1766074891047-CA3E317B',5,NULL,'IN_STOCK','GRN','XYZ281680491','2025-12-18 16:21:31','2025-12-18 16:21:31'),(511,'XYZ-1766074891073-A59E9FCE',5,NULL,'IN_STOCK','GRN','XYZ460662447','2025-12-18 16:21:31','2025-12-18 16:21:31'),(512,'XYZ-1766074891097-2E98DE59',5,NULL,'IN_STOCK','GRN','XYZ373870656','2025-12-18 16:21:31','2025-12-18 16:21:31'),(513,'XYZ-1766074891123-9FE883A0',5,NULL,'IN_STOCK','GRN','XYZ174335363','2025-12-18 16:21:31','2025-12-18 16:21:31'),(514,'XYZ-1766074891151-71D95DF9',5,NULL,'IN_STOCK','GRN','XYZ885178395','2025-12-18 16:21:31','2025-12-18 16:21:31'),(515,'XYZ-1766074891179-6AE4874C',5,NULL,'IN_STOCK','GRN','XYZ032687160','2025-12-18 16:21:31','2025-12-18 16:21:31'),(516,'XYZ-1766074891207-020D1D72',5,NULL,'IN_STOCK','GRN','XYZ932104828','2025-12-18 16:21:31','2025-12-18 16:21:31'),(517,'XYZ-1766074891235-14CF0DD2',5,NULL,'IN_STOCK','GRN','XYZ569321330','2025-12-18 16:21:31','2025-12-18 16:21:31'),(518,'XYZ-1766074891261-AC739332',5,NULL,'IN_STOCK','GRN','XYZ822619280','2025-12-18 16:21:31','2025-12-18 16:21:31'),(519,'XYZ-1766074891286-D4115EC5',5,NULL,'IN_STOCK','GRN','XYZ151903676','2025-12-18 16:21:31','2025-12-18 16:21:31'),(520,'XYZ-1766074891315-DEB0F4D6',5,NULL,'IN_STOCK','GRN','XYZ677320998','2025-12-18 16:21:31','2025-12-18 16:21:31'),(521,'XYZ-1766074891343-06DFA342',5,NULL,'IN_STOCK','GRN','XYZ040474236','2025-12-18 16:21:31','2025-12-18 16:21:31'),(522,'XYZ-1766074891372-DE09207B',5,NULL,'IN_STOCK','GRN','XYZ759963202','2025-12-18 16:21:31','2025-12-18 16:21:31'),(523,'XYZ-1766074891402-FE5159DE',5,NULL,'IN_STOCK','GRN','XYZ099726059','2025-12-18 16:21:31','2025-12-18 16:21:31'),(524,'XYZ-1766074891429-2503D5BB',5,NULL,'IN_STOCK','GRN','XYZ844353558','2025-12-18 16:21:31','2025-12-18 16:21:31'),(525,'XYZ-1766074891452-C4C801C6',5,NULL,'IN_STOCK','GRN','XYZ706003720','2025-12-18 16:21:31','2025-12-18 16:21:31'),(526,'XYZ-1766074891476-F8E90AD0',5,NULL,'IN_STOCK','GRN','XYZ620658033','2025-12-18 16:21:31','2025-12-18 16:21:31'),(527,'XYZ-1766074891505-20BD35F2',5,NULL,'IN_STOCK','GRN','XYZ522615514','2025-12-18 16:21:31','2025-12-18 16:21:31'),(528,'XYZ-1766074891533-E05BF96F',5,NULL,'IN_STOCK','GRN','XYZ320298587','2025-12-18 16:21:31','2025-12-18 16:21:31'),(529,'XYZ-1766074891560-07CF7A55',5,NULL,'IN_STOCK','GRN','XYZ705111071','2025-12-18 16:21:31','2025-12-18 16:21:31'),(530,'XYZ-1766074891588-F3EAF81C',5,NULL,'IN_STOCK','GRN','XYZ676067743','2025-12-18 16:21:31','2025-12-18 16:21:31'),(531,'XYZ-1766074891615-62C29363',5,NULL,'IN_STOCK','GRN','XYZ812689398','2025-12-18 16:21:31','2025-12-18 16:21:31'),(532,'XYZ-1766074891641-B4ED2543',5,NULL,'IN_STOCK','GRN','XYZ589114418','2025-12-18 16:21:31','2025-12-18 16:21:31'),(533,'XYZ-1766074891669-0747E948',5,NULL,'IN_STOCK','GRN','XYZ745820399','2025-12-18 16:21:31','2025-12-18 16:21:31'),(534,'XYZ-1766074891696-F751C8B0',5,NULL,'IN_STOCK','GRN','XYZ874206300','2025-12-18 16:21:31','2025-12-18 16:21:31'),(535,'XYZ-1766074891725-974D018A',5,NULL,'IN_STOCK','GRN','XYZ325003289','2025-12-18 16:21:31','2025-12-18 16:21:31'),(536,'XYZ-1766074891751-C54D640A',5,NULL,'IN_STOCK','GRN','XYZ141471822','2025-12-18 16:21:31','2025-12-18 16:21:31'),(537,'XYZ-1766074891777-EF004126',5,NULL,'IN_STOCK','GRN','XYZ244113121','2025-12-18 16:21:31','2025-12-18 16:21:31'),(538,'XYZ-1766074891802-C172ACE3',5,NULL,'IN_STOCK','GRN','XYZ009998809','2025-12-18 16:21:31','2025-12-18 16:21:31'),(539,'XYZ-1766074891830-13FA4278',5,NULL,'IN_STOCK','GRN','XYZ772181507','2025-12-18 16:21:31','2025-12-18 16:21:31'),(540,'XYZ-1766074891857-616D59C0',5,NULL,'IN_STOCK','GRN','XYZ570688883','2025-12-18 16:21:31','2025-12-18 16:21:31'),(541,'XYZ-1766074891884-95987AD8',5,NULL,'IN_STOCK','GRN','XYZ522311666','2025-12-18 16:21:31','2025-12-18 16:21:31'),(542,'XYZ-1766074891913-DB9A3906',5,NULL,'IN_STOCK','GRN','XYZ994359601','2025-12-18 16:21:31','2025-12-18 16:21:31'),(543,'XYZ-1766074891939-188B1DBA',5,NULL,'IN_STOCK','GRN','XYZ629508716','2025-12-18 16:21:31','2025-12-18 16:21:31'),(544,'XYZ-1766074891964-87DAC18F',5,NULL,'IN_STOCK','GRN','XYZ256637489','2025-12-18 16:21:31','2025-12-18 16:21:31'),(545,'XYZ-1766074891990-A00E63C8',5,NULL,'IN_STOCK','GRN','XYZ226060189','2025-12-18 16:21:32','2025-12-18 16:21:32'),(546,'XYZ-1766074892017-3F7515D3',5,NULL,'IN_STOCK','GRN','XYZ052065307','2025-12-18 16:21:32','2025-12-18 16:21:32'),(547,'XYZ-1766074892046-09A19430',5,NULL,'IN_STOCK','GRN','XYZ024850749','2025-12-18 16:21:32','2025-12-18 16:21:32'),(548,'XYZ-1766074892073-4262D051',5,NULL,'IN_STOCK','GRN','XYZ421427414','2025-12-18 16:21:32','2025-12-18 16:21:32'),(549,'XYZ-1766074892101-DDF1E4AB',5,NULL,'IN_STOCK','GRN','XYZ061682627','2025-12-18 16:21:32','2025-12-18 16:21:32'),(550,'XYZ-1766074892129-E5E2DCAD',5,NULL,'IN_STOCK','GRN','XYZ378017666','2025-12-18 16:21:32','2025-12-18 16:21:32'),(551,'XYZ-1766074892156-BFC01EBA',5,NULL,'IN_STOCK','GRN','XYZ501383773','2025-12-18 16:21:32','2025-12-18 16:21:32'),(552,'XYZ-1766074892180-B3742E1D',5,NULL,'IN_STOCK','GRN','XYZ593427713','2025-12-18 16:21:32','2025-12-18 16:21:32'),(553,'XYZ-1766074892207-90166ECF',5,NULL,'IN_STOCK','GRN','XYZ130983497','2025-12-18 16:21:32','2025-12-18 16:21:32'),(554,'XYZ-1766074892233-BB1AA0E6',5,NULL,'IN_STOCK','GRN','XYZ750826771','2025-12-18 16:21:32','2025-12-18 16:21:32'),(555,'XYZ-1766074892259-361F163F',5,NULL,'IN_STOCK','GRN','XYZ245005830','2025-12-18 16:21:32','2025-12-18 16:21:32'),(556,'XYZ-1766074892284-DEDCECD2',5,NULL,'IN_STOCK','GRN','XYZ766911176','2025-12-18 16:21:32','2025-12-18 16:21:32'),(557,'XYZ-1766074892305-F68CC33A',5,NULL,'IN_STOCK','GRN','XYZ348263339','2025-12-18 16:21:32','2025-12-18 16:21:32'),(558,'XYZ-1766074892334-9D7875FD',5,NULL,'IN_STOCK','GRN','XYZ640777018','2025-12-18 16:21:32','2025-12-18 16:21:32'),(559,'XYZ-1766074892362-AADC4F93',5,NULL,'IN_STOCK','GRN','XYZ147146921','2025-12-18 16:21:32','2025-12-18 16:21:32'),(560,'XYZ-1766074892391-2EA91181',5,NULL,'IN_STOCK','GRN','XYZ135141806','2025-12-18 16:21:32','2025-12-18 16:21:32'),(561,'XYZ-1766074892417-03BE4D5B',5,NULL,'IN_STOCK','GRN','XYZ204316282','2025-12-18 16:21:32','2025-12-18 16:21:32'),(562,'XYZ-1766074892445-AC06A425',5,NULL,'IN_STOCK','GRN','XYZ394543344','2025-12-18 16:21:32','2025-12-18 16:21:32'),(563,'XYZ-1766074892470-272FBF9E',5,NULL,'IN_STOCK','GRN','XYZ866112655','2025-12-18 16:21:32','2025-12-18 16:21:32'),(564,'XYZ-1766074892495-FB43AC61',5,NULL,'IN_STOCK','GRN','XYZ953476345','2025-12-18 16:21:32','2025-12-18 16:21:32'),(565,'XYZ-1766074892521-084FD523',5,NULL,'IN_STOCK','GRN','XYZ747307251','2025-12-18 16:21:32','2025-12-18 16:21:32'),(566,'XYZ-1766074892547-4171F914',5,NULL,'IN_STOCK','GRN','XYZ390973828','2025-12-18 16:21:32','2025-12-18 16:21:32'),(567,'XYZ-1766074892572-11417F9E',5,NULL,'IN_STOCK','GRN','XYZ697490622','2025-12-18 16:21:32','2025-12-18 16:21:32'),(568,'XYZ-1766074892600-6AB8D6BD',5,NULL,'IN_STOCK','GRN','XYZ256005595','2025-12-18 16:21:32','2025-12-18 16:21:32'),(569,'XYZ-1766074892626-D4092A93',5,NULL,'IN_STOCK','GRN','XYZ208098384','2025-12-18 16:21:32','2025-12-18 16:21:32'),(570,'XYZ-1766074892652-1DCF1377',5,NULL,'IN_STOCK','GRN','XYZ260725881','2025-12-18 16:21:32','2025-12-18 16:21:32'),(571,'XYZ-1766074892679-C4D9071B',5,NULL,'IN_STOCK','GRN','XYZ618033875','2025-12-18 16:21:32','2025-12-18 16:21:32'),(572,'XYZ-1766074892706-91887B31',5,NULL,'IN_STOCK','GRN','XYZ450058780','2025-12-18 16:21:32','2025-12-18 16:21:32'),(573,'XYZ-1766074892732-414A72F7',5,NULL,'IN_STOCK','GRN','XYZ609041150','2025-12-18 16:21:32','2025-12-18 16:21:32'),(574,'XYZ-1766074892760-8A0446C4',5,NULL,'IN_STOCK','GRN','XYZ594290905','2025-12-18 16:21:32','2025-12-18 16:21:32'),(575,'XYZ-1766074892786-A80DFF5D',5,NULL,'IN_STOCK','GRN','XYZ918582428','2025-12-18 16:21:32','2025-12-18 16:21:32'),(576,'XYZ-1766074892813-8F232E39',5,NULL,'IN_STOCK','GRN','XYZ135934271','2025-12-18 16:21:32','2025-12-18 16:21:32'),(577,'XYZ-1766074892840-17EF7227',5,NULL,'IN_STOCK','GRN','XYZ428871469','2025-12-18 16:21:32','2025-12-18 16:21:32'),(578,'XYZ-1766074892866-4B9D9E20',5,NULL,'IN_STOCK','GRN','XYZ137284448','2025-12-18 16:21:32','2025-12-18 16:21:32'),(579,'XYZ-1766074892889-BEC7A7F5',5,NULL,'IN_STOCK','GRN','XYZ750229782','2025-12-18 16:21:32','2025-12-18 16:21:32'),(580,'XYZ-1766074892914-7A63BC16',5,NULL,'IN_STOCK','GRN','XYZ595406351','2025-12-18 16:21:32','2025-12-18 16:21:32'),(581,'XYZ-1766074892941-992DEF89',5,NULL,'IN_STOCK','GRN','XYZ293912777','2025-12-18 16:21:32','2025-12-18 16:21:32'),(582,'XYZ-1766074892968-6BF645BA',5,NULL,'IN_STOCK','GRN','XYZ431500165','2025-12-18 16:21:32','2025-12-18 16:21:32'),(583,'XYZ-1766074892994-AF0362C0',5,NULL,'IN_STOCK','GRN','XYZ856340884','2025-12-18 16:21:33','2025-12-18 16:21:33'),(584,'XYZ-1766074893020-4B7D8D45',5,NULL,'IN_STOCK','GRN','XYZ193607749','2025-12-18 16:21:33','2025-12-18 16:21:33'),(585,'XYZ-1766074893047-0424A40B',5,NULL,'IN_STOCK','GRN','XYZ477552839','2025-12-18 16:21:33','2025-12-18 16:21:33'),(586,'XYZ-1766074893075-A0E901C4',5,NULL,'IN_STOCK','GRN','XYZ783129514','2025-12-18 16:21:33','2025-12-18 16:21:33'),(587,'XYZ-1766074893107-60ABE785',5,NULL,'IN_STOCK','GRN','XYZ899901310','2025-12-18 16:21:33','2025-12-18 16:21:33'),(588,'XYZ-1766074893135-6C70B139',5,NULL,'IN_STOCK','GRN','XYZ714391541','2025-12-18 16:21:33','2025-12-18 16:21:33'),(589,'XYZ-1766074893165-2307E4E3',5,NULL,'IN_STOCK','GRN','XYZ228856970','2025-12-18 16:21:33','2025-12-18 16:21:33'),(590,'XYZ-1766074893190-C670DBBD',5,NULL,'IN_STOCK','GRN','XYZ905871799','2025-12-18 16:21:33','2025-12-18 16:21:33'),(591,'XYZ-1766074893216-C7DEF8BF',5,NULL,'IN_STOCK','GRN','XYZ673655920','2025-12-18 16:21:33','2025-12-18 16:21:33'),(592,'XYZ-1766074893250-8D1417E2',5,NULL,'IN_STOCK','GRN','XYZ504757260','2025-12-18 16:21:33','2025-12-18 16:21:33'),(593,'XYZ-1766074893281-26F35296',5,NULL,'IN_STOCK','GRN','XYZ287261056','2025-12-18 16:21:33','2025-12-18 16:21:33'),(594,'XYZ-1766074893309-6E8BDCF6',5,NULL,'IN_STOCK','GRN','XYZ753156546','2025-12-18 16:21:33','2025-12-18 16:21:33'),(595,'XYZ-1766074893338-866E2A30',5,NULL,'IN_STOCK','GRN','XYZ048022808','2025-12-18 16:21:33','2025-12-18 16:21:33'),(596,'XYZ-1766074893363-5C2E98C8',5,NULL,'IN_STOCK','GRN','XYZ703196343','2025-12-18 16:21:33','2025-12-18 16:21:33'),(597,'XYZ-1766074893390-A699653E',5,NULL,'IN_STOCK','GRN','XYZ770086227','2025-12-18 16:21:33','2025-12-18 16:21:33'),(598,'XYZ-1766074893413-7460BA5A',5,NULL,'IN_STOCK','GRN','XYZ766953552','2025-12-18 16:21:33','2025-12-18 16:21:33'),(599,'XYZ-1766074893435-C14BE221',5,NULL,'IN_STOCK','GRN','XYZ935022822','2025-12-18 16:21:33','2025-12-18 16:21:33'),(600,'XYZ-1766074893456-A19C1B93',5,NULL,'IN_STOCK','GRN','XYZ336496769','2025-12-18 16:21:33','2025-12-18 16:21:33'),(601,'XYZ-1766074893483-F8416CEB',5,NULL,'IN_STOCK','GRN','XYZ432964783','2025-12-18 16:21:33','2025-12-18 16:21:33'),(602,'XYZ-1766074893511-9E226DDB',5,NULL,'IN_STOCK','GRN','XYZ756988045','2025-12-18 16:21:33','2025-12-18 16:21:33'),(603,'XYZ-1766074893542-0A083000',5,NULL,'IN_STOCK','GRN','XYZ057532385','2025-12-18 16:21:33','2025-12-18 16:21:33'),(604,'XYZ-1766074893572-80ECCE2E',5,NULL,'IN_STOCK','GRN','XYZ002879239','2025-12-18 16:21:33','2025-12-18 16:21:33'),(605,'XYZ-1766074893599-77CF79FE',5,NULL,'IN_STOCK','GRN','XYZ068693175','2025-12-18 16:21:33','2025-12-18 16:21:33'),(606,'XYZ-1766074893626-BD06A4AE',5,NULL,'IN_STOCK','GRN','XYZ245660684','2025-12-18 16:21:33','2025-12-18 16:21:33'),(607,'XYZ-1766074893652-C1DBD684',5,NULL,'IN_STOCK','GRN','XYZ877991653','2025-12-18 16:21:33','2025-12-18 16:21:33'),(608,'XYZ-1766074893680-96DB213A',5,NULL,'IN_STOCK','GRN','XYZ016855189','2025-12-18 16:21:33','2025-12-18 16:21:33'),(609,'XYZ-1766074893708-EA2A00E7',5,NULL,'IN_STOCK','GRN','XYZ826663779','2025-12-18 16:21:33','2025-12-18 16:21:33'),(610,'XYZ-1766074893735-266F4530',5,NULL,'IN_STOCK','GRN','XYZ419414965','2025-12-18 16:21:33','2025-12-18 16:21:33'),(611,'XYZ-1766074893759-CECE68B1',5,NULL,'IN_STOCK','GRN','XYZ432271461','2025-12-18 16:21:33','2025-12-18 16:21:33'),(612,'XYZ-1766074893789-B9F80CA7',5,NULL,'IN_STOCK','GRN','XYZ276493699','2025-12-18 16:21:33','2025-12-18 16:21:33'),(613,'XYZ-1766074893815-4303AC41',5,NULL,'IN_STOCK','GRN','XYZ110090876','2025-12-18 16:21:33','2025-12-18 16:21:33'),(614,'XYZ-1766074893843-FEA2D52E',5,NULL,'IN_STOCK','GRN','XYZ550091604','2025-12-18 16:21:33','2025-12-18 16:21:33'),(615,'XYZ-1766074893868-0800748C',5,NULL,'IN_STOCK','GRN','XYZ072657765','2025-12-18 16:21:33','2025-12-18 16:21:33'),(616,'XYZ-1766074893894-CA2F8FD2',5,NULL,'IN_STOCK','GRN','XYZ048926898','2025-12-18 16:21:33','2025-12-18 16:21:33'),(617,'XYZ-1766074893920-F1D25D29',5,NULL,'IN_STOCK','GRN','XYZ688828787','2025-12-18 16:21:33','2025-12-18 16:21:33'),(618,'XYZ-1766074893948-1F769D2C',5,NULL,'IN_STOCK','GRN','XYZ162670562','2025-12-18 16:21:33','2025-12-18 16:21:33'),(619,'XYZ-1766074893975-9D8F6CC5',5,NULL,'IN_STOCK','GRN','XYZ628963616','2025-12-18 16:21:33','2025-12-18 16:21:33'),(620,'XYZ-1766074894002-9129EB27',5,NULL,'IN_STOCK','GRN','XYZ824262184','2025-12-18 16:21:34','2025-12-18 16:21:34'),(621,'XYZ-1766074894023-B948C86F',5,NULL,'IN_STOCK','GRN','XYZ932098461','2025-12-18 16:21:34','2025-12-18 16:21:34'),(622,'XYZ-1766074894045-72009C3B',5,NULL,'IN_STOCK','GRN','XYZ296091254','2025-12-18 16:21:34','2025-12-18 16:21:34'),(623,'XYZ-1766074894071-0F61E2C8',5,NULL,'IN_STOCK','GRN','XYZ313888187','2025-12-18 16:21:34','2025-12-18 16:21:34'),(624,'XYZ-1766074894098-2AB3C276',5,NULL,'IN_STOCK','GRN','XYZ319741402','2025-12-18 16:21:34','2025-12-18 16:21:34'),(625,'XYZ-1766074894125-F78BF017',5,NULL,'IN_STOCK','GRN','XYZ751852006','2025-12-18 16:21:34','2025-12-18 16:21:34'),(626,'XYZ-1766074894150-28E62242',5,NULL,'IN_STOCK','GRN','XYZ461801755','2025-12-18 16:21:34','2025-12-18 16:21:34'),(627,'XYZ-1766074894177-1E14AFA1',5,NULL,'IN_STOCK','GRN','XYZ035468905','2025-12-18 16:21:34','2025-12-18 16:21:34'),(628,'XYZ-1766074894203-A02590E3',5,NULL,'IN_STOCK','GRN','XYZ579183330','2025-12-18 16:21:34','2025-12-18 16:21:34'),(629,'XYZ-1766074894227-18FD0B80',5,NULL,'IN_STOCK','GRN','XYZ965922047','2025-12-18 16:21:34','2025-12-18 16:21:34'),(630,'XYZ-1766074894250-A0CCAD24',5,NULL,'IN_STOCK','GRN','XYZ288139482','2025-12-18 16:21:34','2025-12-18 16:21:34'),(631,'XYZ-1766074894276-4AD2D7D2',5,NULL,'IN_STOCK','GRN','XYZ323024025','2025-12-18 16:21:34','2025-12-18 16:21:34'),(632,'XYZ-1766074894302-11B9CAED',5,NULL,'IN_STOCK','GRN','XYZ299179356','2025-12-18 16:21:34','2025-12-18 16:21:34'),(633,'XYZ-1766074894329-720D52A4',5,NULL,'IN_STOCK','GRN','XYZ840716932','2025-12-18 16:21:34','2025-12-18 16:21:34'),(634,'XYZ-1766074894357-10279969',5,NULL,'IN_STOCK','GRN','XYZ220159130','2025-12-18 16:21:34','2025-12-18 16:21:34'),(635,'XYZ-1766074894381-8EE69EA4',5,NULL,'IN_STOCK','GRN','XYZ850706960','2025-12-18 16:21:34','2025-12-18 16:21:34'),(636,'XYZ-1766074894408-FE287B07',5,NULL,'IN_STOCK','GRN','XYZ530557560','2025-12-18 16:21:34','2025-12-18 16:21:34'),(637,'XYZ-1766074894434-4CA01CE0',5,NULL,'IN_STOCK','GRN','XYZ167229587','2025-12-18 16:21:34','2025-12-18 16:21:34'),(638,'XYZ-1766074894456-A83150D6',5,NULL,'IN_STOCK','GRN','XYZ041593033','2025-12-18 16:21:34','2025-12-18 16:21:34'),(639,'XYZ-1766074894482-16AABB6B',5,NULL,'IN_STOCK','GRN','XYZ951688269','2025-12-18 16:21:34','2025-12-18 16:21:34'),(640,'XYZ-1766074894510-70A74139',5,NULL,'IN_STOCK','GRN','XYZ508321581','2025-12-18 16:21:34','2025-12-18 16:21:34'),(641,'XYZ-1766074894537-A1913DC8',5,NULL,'IN_STOCK','GRN','XYZ049530683','2025-12-18 16:21:34','2025-12-18 16:21:34'),(642,'XYZ-1766074894563-8F2C4A9B',5,NULL,'IN_STOCK','GRN','XYZ400018442','2025-12-18 16:21:34','2025-12-18 16:21:34'),(643,'XYZ-1766074894588-9CDED928',5,NULL,'IN_STOCK','GRN','XYZ802130777','2025-12-18 16:21:34','2025-12-18 16:21:34'),(644,'XYZ-1766074894616-C798D6AE',5,NULL,'IN_STOCK','GRN','XYZ663450361','2025-12-18 16:21:34','2025-12-18 16:21:34'),(645,'XYZ-1766074894640-8F34A892',5,NULL,'IN_STOCK','GRN','XYZ166276729','2025-12-18 16:21:34','2025-12-18 16:21:34'),(646,'XYZ-1766074894667-360E6B1E',5,NULL,'IN_STOCK','GRN','XYZ586638460','2025-12-18 16:21:34','2025-12-18 16:21:34'),(647,'XYZ-1766074894695-54A2839F',5,NULL,'IN_STOCK','GRN','XYZ185166189','2025-12-18 16:21:34','2025-12-18 16:21:34'),(648,'XYZ-1766074894722-83515663',5,NULL,'IN_STOCK','GRN','XYZ749951842','2025-12-18 16:21:34','2025-12-18 16:21:34'),(649,'XYZ-1766074894751-EE08E672',5,NULL,'IN_STOCK','GRN','XYZ544903887','2025-12-18 16:21:34','2025-12-18 16:21:34'),(650,'XYZ-1766074894776-722056E6',5,NULL,'IN_STOCK','GRN','XYZ490885410','2025-12-18 16:21:34','2025-12-18 16:21:34'),(651,'XYZ-1766074894804-2FC32385',5,NULL,'IN_STOCK','GRN','XYZ451604309','2025-12-18 16:21:34','2025-12-18 16:21:34'),(652,'XYZ-1766074894826-DE958964',5,NULL,'IN_STOCK','GRN','XYZ823772056','2025-12-18 16:21:34','2025-12-18 16:21:34'),(653,'XYZ-1766074894853-64C259D0',5,NULL,'IN_STOCK','GRN','XYZ762480781','2025-12-18 16:21:34','2025-12-18 16:21:34'),(654,'XYZ-1766074894881-C7631C1F',5,NULL,'IN_STOCK','GRN','XYZ662969317','2025-12-18 16:21:34','2025-12-18 16:21:34'),(655,'XYZ-1766074894908-68B64BFF',5,NULL,'IN_STOCK','GRN','XYZ975291678','2025-12-18 16:21:34','2025-12-18 16:21:34'),(656,'XYZ-1766074894933-A3DB2581',5,NULL,'IN_STOCK','GRN','XYZ834018292','2025-12-18 16:21:34','2025-12-18 16:21:34'),(657,'XYZ-1766074894956-6747EB5A',5,NULL,'IN_STOCK','GRN','XYZ096928144','2025-12-18 16:21:34','2025-12-18 16:21:34'),(658,'XYZ-1766074894978-5E90F7C3',5,NULL,'IN_STOCK','GRN','XYZ590953868','2025-12-18 16:21:34','2025-12-18 16:21:34'),(659,'XYZ-1766074895004-52CF7819',5,NULL,'IN_STOCK','GRN','XYZ120721646','2025-12-18 16:21:35','2025-12-18 16:21:35'),(660,'XYZ-1766074895029-0DAA3041',5,NULL,'IN_STOCK','GRN','XYZ564861190','2025-12-18 16:21:35','2025-12-18 16:21:35'),(661,'XYZ-1766074895057-6FE25111',5,NULL,'IN_STOCK','GRN','XYZ599491368','2025-12-18 16:21:35','2025-12-18 16:21:35'),(662,'XYZ-1766074895084-9B92A30B',5,NULL,'IN_STOCK','GRN','XYZ933136213','2025-12-18 16:21:35','2025-12-18 16:21:35'),(663,'XYZ-1766074895109-741A3DD9',5,NULL,'IN_STOCK','GRN','XYZ004877384','2025-12-18 16:21:35','2025-12-18 16:21:35'),(664,'XYZ-1766074895137-57ADB386',5,NULL,'IN_STOCK','GRN','XYZ519602944','2025-12-18 16:21:35','2025-12-18 16:21:35'),(665,'XYZ-1766074895164-4BF18CC0',5,NULL,'IN_STOCK','GRN','XYZ347396476','2025-12-18 16:21:35','2025-12-18 16:21:35'),(666,'XYZ-1766074895189-EC5EDFED',5,NULL,'IN_STOCK','GRN','XYZ707139421','2025-12-18 16:21:35','2025-12-18 16:21:35'),(667,'XYZ-1766074895216-E4C024AC',5,NULL,'IN_STOCK','GRN','XYZ086544630','2025-12-18 16:21:35','2025-12-18 16:21:35'),(668,'XYZ-1766074895244-196D44A2',5,NULL,'IN_STOCK','GRN','XYZ597014931','2025-12-18 16:21:35','2025-12-18 16:21:35'),(669,'XYZ-1766074895271-3504731B',5,NULL,'IN_STOCK','GRN','XYZ782140287','2025-12-18 16:21:35','2025-12-18 16:21:35'),(670,'XYZ-1766074895296-04BD2732',5,NULL,'IN_STOCK','GRN','XYZ229079534','2025-12-18 16:21:35','2025-12-18 16:21:35'),(671,'XYZ-1766074895323-595DE613',5,NULL,'IN_STOCK','GRN','XYZ218519183','2025-12-18 16:21:35','2025-12-18 16:21:35'),(672,'XYZ-1766074895347-4C4DE676',5,NULL,'IN_STOCK','GRN','XYZ389713834','2025-12-18 16:21:35','2025-12-18 16:21:35'),(673,'XYZ-1766074895375-28CBE2E1',5,NULL,'IN_STOCK','GRN','XYZ266518908','2025-12-18 16:21:35','2025-12-18 16:21:35'),(674,'XYZ-1766074895404-47F4309A',5,NULL,'IN_STOCK','GRN','XYZ625593010','2025-12-18 16:21:35','2025-12-18 16:21:35'),(675,'XYZ-1766074895432-E29F0F71',5,NULL,'IN_STOCK','GRN','XYZ410193985','2025-12-18 16:21:35','2025-12-18 16:21:35'),(676,'XYZ-1766074895460-4DA82086',5,NULL,'IN_STOCK','GRN','XYZ360072682','2025-12-18 16:21:35','2025-12-18 16:21:35'),(677,'XYZ-1766074895482-21B607FC',5,NULL,'IN_STOCK','GRN','XYZ507362092','2025-12-18 16:21:35','2025-12-18 16:21:35'),(678,'XYZ-1766074895512-E697D123',5,NULL,'IN_STOCK','GRN','XYZ604962978','2025-12-18 16:21:35','2025-12-18 16:21:35'),(679,'XYZ-1766074895538-7A53C9E5',5,NULL,'IN_STOCK','GRN','XYZ620593490','2025-12-18 16:21:35','2025-12-18 16:21:35'),(680,'XYZ-1766074895568-E156B92F',5,NULL,'IN_STOCK','GRN','XYZ367596429','2025-12-18 16:21:35','2025-12-18 16:21:35'),(681,'XYZ-1766074895595-61526D51',5,NULL,'IN_STOCK','GRN','XYZ596088927','2025-12-18 16:21:35','2025-12-18 16:21:35'),(682,'XYZ-1766074895623-BC4CF06D',5,NULL,'IN_STOCK','GRN','XYZ629595208','2025-12-18 16:21:35','2025-12-18 16:21:35'),(683,'XYZ-1766074895650-F471F741',5,NULL,'IN_STOCK','GRN','XYZ790251249','2025-12-18 16:21:35','2025-12-18 16:21:35'),(684,'XYZ-1766074895679-5CD03CC8',5,NULL,'IN_STOCK','GRN','XYZ421843886','2025-12-18 16:21:35','2025-12-18 16:21:35'),(685,'XYZ-1766074895706-C8AE7449',5,NULL,'IN_STOCK','GRN','XYZ195264883','2025-12-18 16:21:35','2025-12-18 16:21:35'),(686,'XYZ-1766074895739-C5713A1A',5,NULL,'IN_STOCK','GRN','XYZ630803106','2025-12-18 16:21:35','2025-12-18 16:21:35'),(687,'XYZ-1766074895763-182AA23A',5,NULL,'IN_STOCK','GRN','XYZ088597598','2025-12-18 16:21:35','2025-12-18 16:21:35'),(688,'XYZ-1766074895787-BC34D9EA',5,NULL,'IN_STOCK','GRN','XYZ614365120','2025-12-18 16:21:35','2025-12-18 16:21:35'),(689,'XYZ-1766074895816-0AD3FEF9',5,NULL,'IN_STOCK','GRN','XYZ399088016','2025-12-18 16:21:35','2025-12-18 16:21:35'),(690,'XYZ-1766074895843-CA0E4A9C',5,NULL,'IN_STOCK','GRN','XYZ775599985','2025-12-18 16:21:35','2025-12-18 16:21:35'),(691,'XYZ-1766074895870-D4CE9E1C',5,NULL,'IN_STOCK','GRN','XYZ045648296','2025-12-18 16:21:35','2025-12-18 16:21:35'),(692,'XYZ-1766074895897-DBE97965',5,NULL,'IN_STOCK','GRN','XYZ013334727','2025-12-18 16:21:35','2025-12-18 16:21:35'),(693,'XYZ-1766074895924-BFFC19E5',5,NULL,'IN_STOCK','GRN','XYZ323388976','2025-12-18 16:21:35','2025-12-18 16:21:35'),(694,'XYZ-1766074895951-1C89D46E',5,NULL,'IN_STOCK','GRN','XYZ817682087','2025-12-18 16:21:35','2025-12-18 16:21:35'),(695,'XYZ-1766074895979-9A70589B',5,NULL,'IN_STOCK','GRN','XYZ610184207','2025-12-18 16:21:35','2025-12-18 16:21:35'),(696,'XYZ-1766074896005-C7ABD7F7',5,NULL,'IN_STOCK','GRN','XYZ036220463','2025-12-18 16:21:36','2025-12-18 16:21:36'),(697,'XYZ-1766074896032-FF480103',5,NULL,'IN_STOCK','GRN','XYZ457760796','2025-12-18 16:21:36','2025-12-18 16:21:36'),(698,'XYZ-1766074896059-5BCC966C',5,NULL,'IN_STOCK','GRN','XYZ332966823','2025-12-18 16:21:36','2025-12-18 16:21:36'),(699,'XYZ-1766074896087-831AC2E9',5,NULL,'IN_STOCK','GRN','XYZ370920836','2025-12-18 16:21:36','2025-12-18 16:21:36'),(700,'XYZ-1766074896115-0CD73EAA',5,NULL,'IN_STOCK','GRN','XYZ683289008','2025-12-18 16:21:36','2025-12-18 16:21:36'),(701,'XYZ-1766074896141-D542E12C',5,NULL,'IN_STOCK','GRN','XYZ955183746','2025-12-18 16:21:36','2025-12-18 16:21:36'),(702,'XYZ-1766074896168-8CA65E32',5,NULL,'IN_STOCK','GRN','XYZ118172200','2025-12-18 16:21:36','2025-12-18 16:21:36'),(703,'XYZ-1766074896191-52824221',5,NULL,'IN_STOCK','GRN','XYZ514546324','2025-12-18 16:21:36','2025-12-18 16:21:36'),(704,'XYZ-1766074896218-CAEE457F',5,NULL,'IN_STOCK','GRN','XYZ100213112','2025-12-18 16:21:36','2025-12-18 16:21:36'),(705,'XYZ-1766074896246-E3C27F9A',5,NULL,'IN_STOCK','GRN','XYZ828080330','2025-12-18 16:21:36','2025-12-18 16:21:36'),(706,'XYZ-1766074896272-E13CA1FA',5,NULL,'IN_STOCK','GRN','XYZ108268597','2025-12-18 16:21:36','2025-12-18 16:21:36'),(707,'XYZ-1766074896301-BE5AB1E6',5,NULL,'IN_STOCK','GRN','XYZ335040761','2025-12-18 16:21:36','2025-12-18 16:21:36'),(708,'XYZ-1766074896329-39585392',5,NULL,'IN_STOCK','GRN','XYZ203041135','2025-12-18 16:21:36','2025-12-18 16:21:36'),(709,'XYZ-1766074896356-5ADB036F',5,NULL,'IN_STOCK','GRN','XYZ832137906','2025-12-18 16:21:36','2025-12-18 16:21:36'),(710,'XYZ-1766074896384-A19722D2',5,NULL,'IN_STOCK','GRN','XYZ884264948','2025-12-18 16:21:36','2025-12-18 16:21:36'),(711,'XYZ-1766074896413-29CB9351',5,NULL,'IN_STOCK','GRN','XYZ587879494','2025-12-18 16:21:36','2025-12-18 16:21:36'),(712,'XYZ-1766074896442-77982D0F',5,NULL,'IN_STOCK','GRN','XYZ976697272','2025-12-18 16:21:36','2025-12-18 16:21:36'),(713,'XYZ-1766074896472-5B14D11F',5,NULL,'IN_STOCK','GRN','XYZ579206701','2025-12-18 16:21:36','2025-12-18 16:21:36'),(714,'XYZ-1766074896500-8A29FA48',5,NULL,'IN_STOCK','GRN','XYZ526881803','2025-12-18 16:21:36','2025-12-18 16:21:36'),(715,'XYZ-1766074896527-47D5D531',5,NULL,'IN_STOCK','GRN','XYZ537262750','2025-12-18 16:21:36','2025-12-18 16:21:36'),(716,'XYZ-1766074896548-10B9445D',5,NULL,'IN_STOCK','GRN','XYZ369293727','2025-12-18 16:21:36','2025-12-18 16:21:36'),(717,'XYZ-1766074896573-4FAD1643',5,NULL,'IN_STOCK','GRN','XYZ776226647','2025-12-18 16:21:36','2025-12-18 16:21:36'),(718,'XYZ-1766074896598-DCFAC257',5,NULL,'IN_STOCK','GRN','XYZ485307918','2025-12-18 16:21:36','2025-12-18 16:21:36'),(719,'XYZ-1766074896629-514D61FB',5,NULL,'IN_STOCK','GRN','XYZ291583411','2025-12-18 16:21:36','2025-12-18 16:21:36'),(720,'XYZ-1766074896657-556BD54A',5,NULL,'IN_STOCK','GRN','XYZ087892189','2025-12-18 16:21:36','2025-12-18 16:21:36'),(721,'XYZ-1766074896684-B6EF572C',5,NULL,'IN_STOCK','GRN','XYZ975299435','2025-12-18 16:21:36','2025-12-18 16:21:36'),(722,'XYZ-1766074896713-2A239B39',5,NULL,'IN_STOCK','GRN','XYZ699385924','2025-12-18 16:21:36','2025-12-18 16:21:36'),(723,'XYZ-1766074896740-C0F44B33',5,NULL,'IN_STOCK','GRN','XYZ725941532','2025-12-18 16:21:36','2025-12-18 16:21:36'),(724,'XYZ-1766074896768-1C8EC352',5,NULL,'IN_STOCK','GRN','XYZ639050920','2025-12-18 16:21:36','2025-12-18 16:21:36'),(725,'XYZ-1766074896796-021C215D',5,NULL,'IN_STOCK','GRN','XYZ785300114','2025-12-18 16:21:36','2025-12-18 16:21:36'),(726,'XYZ-1766074896825-0DD82E55',5,NULL,'IN_STOCK','GRN','XYZ059777307','2025-12-18 16:21:36','2025-12-18 16:21:36'),(727,'XYZ-1766074896852-EE999793',5,NULL,'IN_STOCK','GRN','XYZ835485109','2025-12-18 16:21:36','2025-12-18 16:21:36'),(728,'XYZ-1766074896881-91F91455',5,NULL,'IN_STOCK','GRN','XYZ887810972','2025-12-18 16:21:36','2025-12-18 16:21:36'),(729,'XYZ-1766074896906-C2E2DA12',5,NULL,'IN_STOCK','GRN','XYZ942083332','2025-12-18 16:21:36','2025-12-18 16:21:36'),(730,'XYZ-1766074896927-65B6358A',5,NULL,'IN_STOCK','GRN','XYZ605713669','2025-12-18 16:21:36','2025-12-18 16:21:36'),(731,'XYZ-1766074896952-EADAAC9D',5,NULL,'IN_STOCK','GRN','XYZ378483419','2025-12-18 16:21:36','2025-12-18 16:21:36'),(732,'XYZ-1766074896976-A89733BA',5,NULL,'IN_STOCK','GRN','XYZ687326947','2025-12-18 16:21:36','2025-12-18 16:21:36'),(733,'XYZ-1766074897003-A6769522',5,NULL,'IN_STOCK','GRN','XYZ959661987','2025-12-18 16:21:37','2025-12-18 16:21:37'),(734,'XYZ-1766074897029-77258584',5,NULL,'IN_STOCK','GRN','XYZ142935573','2025-12-18 16:21:37','2025-12-18 16:21:37'),(735,'XYZ-1766074897058-C0DD714E',5,NULL,'IN_STOCK','GRN','XYZ700182602','2025-12-18 16:21:37','2025-12-18 16:21:37'),(736,'XYZ-1766074897083-C063AC79',5,NULL,'IN_STOCK','GRN','XYZ959165609','2025-12-18 16:21:37','2025-12-18 16:21:37'),(737,'XYZ-1766074897107-3E86D16D',5,NULL,'IN_STOCK','GRN','XYZ153218494','2025-12-18 16:21:37','2025-12-18 16:21:37'),(738,'XYZ-1766074897132-D648640B',5,NULL,'IN_STOCK','GRN','XYZ993461748','2025-12-18 16:21:37','2025-12-18 16:21:37'),(739,'XYZ-1766074897155-29D70CC2',5,NULL,'IN_STOCK','GRN','XYZ698258450','2025-12-18 16:21:37','2025-12-18 16:21:37'),(740,'XYZ-1766074897178-833E2C76',5,NULL,'IN_STOCK','GRN','XYZ566217048','2025-12-18 16:21:37','2025-12-18 16:21:37'),(741,'XYZ-1766074897200-DA90A99F',5,NULL,'IN_STOCK','GRN','XYZ514305070','2025-12-18 16:21:37','2025-12-18 16:21:37'),(742,'XYZ-1766074897220-3AA5D351',5,NULL,'IN_STOCK','GRN','XYZ689031080','2025-12-18 16:21:37','2025-12-18 16:21:37'),(743,'XYZ-1766074897244-676C8B13',5,NULL,'IN_STOCK','GRN','XYZ788167473','2025-12-18 16:21:37','2025-12-18 16:21:37'),(744,'XYZ-1766074897264-2B590996',5,NULL,'IN_STOCK','GRN','XYZ230928213','2025-12-18 16:21:37','2025-12-18 16:21:37'),(745,'XYZ-1766074897284-FF3F8D58',5,NULL,'IN_STOCK','GRN','XYZ009875528','2025-12-18 16:21:37','2025-12-18 16:21:37'),(746,'XYZ-1766074897304-87FDCA34',5,NULL,'IN_STOCK','GRN','XYZ496530446','2025-12-18 16:21:37','2025-12-18 16:21:37'),(747,'XYZ-1766074897325-07E95F69',5,NULL,'IN_STOCK','GRN','XYZ836414536','2025-12-18 16:21:37','2025-12-18 16:21:37'),(748,'XYZ-1766074897353-EBF966D7',5,NULL,'IN_STOCK','GRN','XYZ020519694','2025-12-18 16:21:37','2025-12-18 16:21:37'),(749,'XYZ-1766074897380-DB1A0B34',5,NULL,'IN_STOCK','GRN','XYZ235370866','2025-12-18 16:21:37','2025-12-18 16:21:37'),(750,'XYZ-1766074897411-8CB5BC6E',5,NULL,'IN_STOCK','GRN','XYZ032391690','2025-12-18 16:21:37','2025-12-18 16:21:37'),(751,'XYZ-1766074897437-D8D7B0B4',5,NULL,'IN_STOCK','GRN','XYZ665929510','2025-12-18 16:21:37','2025-12-18 16:21:37'),(752,'XYZ-1766074897464-B5280CFD',5,NULL,'IN_STOCK','GRN','XYZ755746053','2025-12-18 16:21:37','2025-12-18 16:21:37'),(753,'XYZ-1766074897492-2B16E473',5,NULL,'IN_STOCK','GRN','XYZ118666107','2025-12-18 16:21:37','2025-12-18 16:21:37'),(754,'XYZ-1766074897520-14894CCB',5,NULL,'IN_STOCK','GRN','XYZ623989016','2025-12-18 16:21:37','2025-12-18 16:21:37'),(755,'XYZ-1766074897548-F9CDDD0C',5,NULL,'IN_STOCK','GRN','XYZ651263732','2025-12-18 16:21:37','2025-12-18 16:21:37'),(756,'XYZ-1766074897573-CC4271E4',5,NULL,'IN_STOCK','GRN','XYZ900419339','2025-12-18 16:21:37','2025-12-18 16:21:37'),(757,'XYZ-1766074897606-D166867C',5,NULL,'IN_STOCK','GRN','XYZ662668932','2025-12-18 16:21:37','2025-12-18 16:21:37'),(758,'XYZ-1766074897634-CBFC3FD3',5,NULL,'IN_STOCK','GRN','XYZ421697872','2025-12-18 16:21:37','2025-12-18 16:21:37'),(759,'XYZ-1766074897665-D704E552',5,NULL,'IN_STOCK','GRN','XYZ101456863','2025-12-18 16:21:37','2025-12-18 16:21:37'),(760,'XYZ-1766074897692-2D3FA318',5,NULL,'IN_STOCK','GRN','XYZ697023838','2025-12-18 16:21:37','2025-12-18 16:21:37'),(761,'XYZ-1766074897720-9A3C04D5',5,NULL,'IN_STOCK','GRN','XYZ985184114','2025-12-18 16:21:37','2025-12-18 16:21:37'),(762,'XYZ-1766074897748-C9548ED4',5,NULL,'IN_STOCK','GRN','XYZ481134677','2025-12-18 16:21:37','2025-12-18 16:21:37'),(763,'XYZ-1766074897776-CE8D4773',5,NULL,'IN_STOCK','GRN','XYZ485649464','2025-12-18 16:21:37','2025-12-18 16:21:37'),(764,'XYZ-1766074897806-B8EB5BEC',5,NULL,'IN_STOCK','GRN','XYZ823560456','2025-12-18 16:21:37','2025-12-18 16:21:37'),(765,'XYZ-1766074897834-50439FFF',5,NULL,'IN_STOCK','GRN','XYZ266960491','2025-12-18 16:21:37','2025-12-18 16:21:37'),(766,'XYZ-1766074897862-F657862E',5,NULL,'IN_STOCK','GRN','XYZ147420609','2025-12-18 16:21:37','2025-12-18 16:21:37'),(767,'XYZ-1766074897885-782D50E6',5,NULL,'IN_STOCK','GRN','XYZ326005243','2025-12-18 16:21:37','2025-12-18 16:21:37'),(768,'XYZ-1766074897911-FD2F49B5',5,NULL,'IN_STOCK','GRN','XYZ299739745','2025-12-18 16:21:37','2025-12-18 16:21:37'),(769,'XYZ-1766074897939-2D05D1E0',5,NULL,'IN_STOCK','GRN','XYZ656274523','2025-12-18 16:21:37','2025-12-18 16:21:37'),(770,'XYZ-1766074897965-65FBA6BA',5,NULL,'IN_STOCK','GRN','XYZ158467030','2025-12-18 16:21:37','2025-12-18 16:21:37'),(771,'XYZ-1766074897992-B3E338C2',5,NULL,'IN_STOCK','GRN','XYZ907493044','2025-12-18 16:21:38','2025-12-18 16:21:38'),(772,'XYZ-1766074898020-0A553614',5,NULL,'IN_STOCK','GRN','XYZ069733478','2025-12-18 16:21:38','2025-12-18 16:21:38'),(773,'XYZ-1766074898048-52D570DE',5,NULL,'IN_STOCK','GRN','XYZ844506994','2025-12-18 16:21:38','2025-12-18 16:21:38'),(774,'XYZ-1766074898071-55056740',5,NULL,'IN_STOCK','GRN','XYZ414509134','2025-12-18 16:21:38','2025-12-18 16:21:38'),(775,'XYZ-1766074898098-058EC413',5,NULL,'IN_STOCK','GRN','XYZ139328070','2025-12-18 16:21:38','2025-12-18 16:21:38'),(776,'XYZ-1766074898125-14FCE2FF',5,NULL,'IN_STOCK','GRN','XYZ250013117','2025-12-18 16:21:38','2025-12-18 16:21:38'),(777,'XYZ-1766074898153-0E0AF350',5,NULL,'IN_STOCK','GRN','XYZ677051044','2025-12-18 16:21:38','2025-12-18 16:21:38'),(778,'XYZ-1766074898180-24CAF216',5,NULL,'IN_STOCK','GRN','XYZ454214048','2025-12-18 16:21:38','2025-12-18 16:21:38'),(779,'XYZ-1766074898206-5D3BA631',5,NULL,'IN_STOCK','GRN','XYZ515765710','2025-12-18 16:21:38','2025-12-18 16:21:38'),(780,'XYZ-1766074898232-6BCA9678',5,NULL,'IN_STOCK','GRN','XYZ129934646','2025-12-18 16:21:38','2025-12-18 16:21:38'),(781,'XYZ-1766074898258-7E6CC108',5,NULL,'IN_STOCK','GRN','XYZ860764083','2025-12-18 16:21:38','2025-12-18 16:21:38'),(782,'XYZ-1766074898283-A8622D66',5,NULL,'IN_STOCK','GRN','XYZ339736303','2025-12-18 16:21:38','2025-12-18 16:21:38'),(783,'XYZ-1766074898308-24D5858F',5,NULL,'IN_STOCK','GRN','XYZ386589039','2025-12-18 16:21:38','2025-12-18 16:21:38'),(784,'XYZ-1766074898336-CE4D8EE7',5,NULL,'IN_STOCK','GRN','XYZ251327091','2025-12-18 16:21:38','2025-12-18 16:21:38'),(785,'XYZ-1766074898364-4A5F0CB2',5,NULL,'IN_STOCK','GRN','XYZ156989579','2025-12-18 16:21:38','2025-12-18 16:21:38'),(786,'XYZ-1766074898390-A5842A2A',5,NULL,'IN_STOCK','GRN','XYZ113732154','2025-12-18 16:21:38','2025-12-18 16:21:38'),(787,'XYZ-1766074898416-CF2532FC',5,NULL,'IN_STOCK','GRN','XYZ132397780','2025-12-18 16:21:38','2025-12-18 16:21:38'),(788,'XYZ-1766074898443-69AB5E02',5,NULL,'IN_STOCK','GRN','XYZ527121749','2025-12-18 16:21:38','2025-12-18 16:21:38'),(789,'XYZ-1766074898471-8CA653C3',5,NULL,'IN_STOCK','GRN','XYZ945269505','2025-12-18 16:21:38','2025-12-18 16:21:38'),(790,'XYZ-1766074898498-AB466B3F',5,NULL,'IN_STOCK','GRN','XYZ070296573','2025-12-18 16:21:38','2025-12-18 16:21:38'),(791,'XYZ-1766074898525-350AE3B5',5,NULL,'IN_STOCK','GRN','XYZ341547216','2025-12-18 16:21:38','2025-12-18 16:21:38'),(792,'XYZ-1766074898547-CA630941',5,NULL,'IN_STOCK','GRN','XYZ087187089','2025-12-18 16:21:38','2025-12-18 16:21:38'),(793,'XYZ-1766074898574-AFD1F46B',5,NULL,'IN_STOCK','GRN','XYZ704236502','2025-12-18 16:21:38','2025-12-18 16:21:38'),(794,'XYZ-1766074898601-E4803D4A',5,NULL,'IN_STOCK','GRN','XYZ751449749','2025-12-18 16:21:38','2025-12-18 16:21:38'),(795,'XYZ-1766074898628-2F63962A',5,NULL,'IN_STOCK','GRN','XYZ414224281','2025-12-18 16:21:38','2025-12-18 16:21:38'),(796,'XYZ-1766074898652-8380E374',5,NULL,'IN_STOCK','GRN','XYZ204318597','2025-12-18 16:21:38','2025-12-18 16:21:38'),(797,'XYZ-1766074898677-3783EC9D',5,NULL,'IN_STOCK','GRN','XYZ873405516','2025-12-18 16:21:38','2025-12-18 16:21:38'),(798,'XYZ-1766074898703-1B411C38',5,NULL,'IN_STOCK','GRN','XYZ468681169','2025-12-18 16:21:38','2025-12-18 16:21:38'),(799,'XYZ-1766074898729-305EB93F',5,NULL,'IN_STOCK','GRN','XYZ511432548','2025-12-18 16:21:38','2025-12-18 16:21:38'),(800,'XYZ-1766074898757-9ABC868B',5,NULL,'IN_STOCK','GRN','XYZ226749545','2025-12-18 16:21:38','2025-12-18 16:21:38'),(801,'XYZ-1766074898786-0B43F1FC',5,NULL,'IN_STOCK','GRN','XYZ567416351','2025-12-18 16:21:38','2025-12-18 16:21:38'),(802,'XYZ-1766074898813-58DD4833',5,NULL,'IN_STOCK','GRN','XYZ387813184','2025-12-18 16:21:38','2025-12-18 16:21:38'),(803,'XYZ-1766074898841-E5BB9EC4',5,NULL,'IN_STOCK','GRN','XYZ909165037','2025-12-18 16:21:38','2025-12-18 16:21:38'),(804,'XYZ-1766074898869-7130E59F',5,NULL,'IN_STOCK','GRN','XYZ142245016','2025-12-18 16:21:38','2025-12-18 16:21:38'),(805,'XYZ-1766074898897-04A4ADD2',5,NULL,'IN_STOCK','GRN','XYZ339239430','2025-12-18 16:21:38','2025-12-18 16:21:38'),(806,'XYZ-1766074898925-9F644724',5,NULL,'IN_STOCK','GRN','XYZ767914618','2025-12-18 16:21:38','2025-12-18 16:21:38'),(807,'XYZ-1766074898954-3BE26081',5,NULL,'IN_STOCK','GRN','XYZ079333010','2025-12-18 16:21:38','2025-12-18 16:21:38'),(808,'XYZ-1766074898981-E0660DEE',5,NULL,'IN_STOCK','GRN','XYZ374696321','2025-12-18 16:21:38','2025-12-18 16:21:38'),(809,'XYZ-1766074899009-6BEED676',5,NULL,'IN_STOCK','GRN','XYZ100524702','2025-12-18 16:21:39','2025-12-18 16:21:39'),(810,'XYZ-1766074899035-2B5A3F29',5,NULL,'IN_STOCK','GRN','XYZ058481250','2025-12-18 16:21:39','2025-12-18 16:21:39'),(811,'XYZ-1766074899059-505286E7',5,NULL,'IN_STOCK','GRN','XYZ507387827','2025-12-18 16:21:39','2025-12-18 16:21:39'),(812,'XYZ-1766074899080-E9C26BE9',5,NULL,'IN_STOCK','GRN','XYZ169789748','2025-12-18 16:21:39','2025-12-18 16:21:39'),(813,'XYZ-1766074899099-DF2DC568',5,NULL,'IN_STOCK','GRN','XYZ402605867','2025-12-18 16:21:39','2025-12-18 16:21:39'),(814,'XYZ-1766074899123-EB3F880E',5,NULL,'IN_STOCK','GRN','XYZ241910510','2025-12-18 16:21:39','2025-12-18 16:21:39'),(815,'XYZ-1766074899149-C207BF55',5,NULL,'IN_STOCK','GRN','XYZ637643930','2025-12-18 16:21:39','2025-12-18 16:21:39'),(816,'XYZ-1766074899177-410EBCD5',5,NULL,'IN_STOCK','GRN','XYZ256390318','2025-12-18 16:21:39','2025-12-18 16:21:39'),(817,'XYZ-1766074899202-7139ED5A',5,NULL,'IN_STOCK','GRN','XYZ603138145','2025-12-18 16:21:39','2025-12-18 16:21:39'),(818,'XYZ-1766074899230-9CE4EDE2',5,NULL,'IN_STOCK','GRN','XYZ845036150','2025-12-18 16:21:39','2025-12-18 16:21:39'),(819,'XYZ-1766074899257-11B95766',5,NULL,'IN_STOCK','GRN','XYZ575159170','2025-12-18 16:21:39','2025-12-18 16:21:39'),(820,'XYZ-1766074899284-E4EEDD56',5,NULL,'IN_STOCK','GRN','XYZ572457415','2025-12-18 16:21:39','2025-12-18 16:21:39'),(821,'XYZ-1766074899310-7EAF39F9',5,NULL,'IN_STOCK','GRN','XYZ184273622','2025-12-18 16:21:39','2025-12-18 16:21:39'),(822,'XYZ-1766074899339-365646FA',5,NULL,'IN_STOCK','GRN','XYZ979312691','2025-12-18 16:21:39','2025-12-18 16:21:39'),(823,'XYZ-1766074899365-12267808',5,NULL,'IN_STOCK','GRN','XYZ696084309','2025-12-18 16:21:39','2025-12-18 16:21:39'),(824,'XYZ-1766074899393-65B02001',5,NULL,'IN_STOCK','GRN','XYZ434217709','2025-12-18 16:21:39','2025-12-18 16:21:39'),(825,'XYZ-1766074899422-EBC82D8E',5,NULL,'IN_STOCK','GRN','XYZ049074389','2025-12-18 16:21:39','2025-12-18 16:21:39'),(826,'XYZ-1766074899444-61D5C587',5,NULL,'IN_STOCK','GRN','XYZ784861286','2025-12-18 16:21:39','2025-12-18 16:21:39'),(827,'XYZ-1766074899465-928EE96C',5,NULL,'IN_STOCK','GRN','XYZ357648923','2025-12-18 16:21:39','2025-12-18 16:21:39'),(828,'XYZ-1766074899484-48F0C96C',5,NULL,'IN_STOCK','GRN','XYZ889674835','2025-12-18 16:21:39','2025-12-18 16:21:39'),(829,'XYZ-1766074899504-C52D190E',5,NULL,'IN_STOCK','GRN','XYZ720000386','2025-12-18 16:21:39','2025-12-18 16:21:39'),(830,'XYZ-1766074899527-E4509FAA',5,NULL,'IN_STOCK','GRN','XYZ393357663','2025-12-18 16:21:39','2025-12-18 16:21:39'),(831,'XYZ-1766074899552-209C3B53',5,NULL,'IN_STOCK','GRN','XYZ180361503','2025-12-18 16:21:39','2025-12-18 16:21:39'),(832,'XYZ-1766074899578-9F58C845',5,NULL,'IN_STOCK','GRN','XYZ148349336','2025-12-18 16:21:39','2025-12-18 16:21:39'),(833,'XYZ-1766074899605-5859BC59',5,NULL,'IN_STOCK','GRN','XYZ217703251','2025-12-18 16:21:39','2025-12-18 16:21:39'),(834,'XYZ-1766074899631-7CF0B1B9',5,NULL,'IN_STOCK','GRN','XYZ541607451','2025-12-18 16:21:39','2025-12-18 16:21:39'),(835,'XYZ-1766074899658-90C4041D',5,NULL,'IN_STOCK','GRN','XYZ474636050','2025-12-18 16:21:39','2025-12-18 16:21:39'),(836,'XYZ-1766074899682-D74B51AA',5,NULL,'IN_STOCK','GRN','XYZ344808896','2025-12-18 16:21:39','2025-12-18 16:21:39'),(837,'XYZ-1766074899707-E46A84D8',5,NULL,'IN_STOCK','GRN','XYZ092655684','2025-12-18 16:21:39','2025-12-18 16:21:39'),(838,'XYZ-1766074899731-91B10769',5,NULL,'IN_STOCK','GRN','XYZ566884740','2025-12-18 16:21:39','2025-12-18 16:21:39'),(839,'XYZ-1766074899758-EBE43309',5,NULL,'IN_STOCK','GRN','XYZ162715993','2025-12-18 16:21:39','2025-12-18 16:21:39'),(840,'XYZ-1766074899782-2D422DFB',5,NULL,'IN_STOCK','GRN','XYZ048745358','2025-12-18 16:21:39','2025-12-18 16:21:39'),(841,'XYZ-1766074899808-8CEAE131',5,NULL,'IN_STOCK','GRN','XYZ169874198','2025-12-18 16:21:39','2025-12-18 16:21:39'),(842,'XYZ-1766074899835-1EA0D74B',5,NULL,'IN_STOCK','GRN','XYZ440589349','2025-12-18 16:21:39','2025-12-18 16:21:39'),(843,'XYZ-1766074899860-BDB70155',5,NULL,'IN_STOCK','GRN','XYZ468629738','2025-12-18 16:21:39','2025-12-18 16:21:39'),(844,'XYZ-1766074899887-8DB0FD8B',5,NULL,'IN_STOCK','GRN','XYZ614426088','2025-12-18 16:21:39','2025-12-18 16:21:39'),(845,'XYZ-1766074899913-F88B0A25',5,NULL,'IN_STOCK','GRN','XYZ456420972','2025-12-18 16:21:39','2025-12-18 16:21:39'),(846,'XYZ-1766074899941-A4B373C0',5,NULL,'IN_STOCK','GRN','XYZ710308356','2025-12-18 16:21:39','2025-12-18 16:21:39'),(847,'XYZ-1766074899968-D55B24A4',5,NULL,'IN_STOCK','GRN','XYZ468134726','2025-12-18 16:21:39','2025-12-18 16:21:39'),(848,'XYZ-1766074899996-DDBAFCBC',5,NULL,'IN_STOCK','GRN','XYZ414374429','2025-12-18 16:21:40','2025-12-18 16:21:40'),(849,'XYZ-1766074900023-6B55A470',5,NULL,'IN_STOCK','GRN','XYZ347623618','2025-12-18 16:21:40','2025-12-18 16:21:40'),(850,'XYZ-1766074900049-72BC1840',5,NULL,'IN_STOCK','GRN','XYZ351964403','2025-12-18 16:21:40','2025-12-18 16:21:40'),(851,'XYZ-1766074900073-4B13A492',5,NULL,'IN_STOCK','GRN','XYZ224146036','2025-12-18 16:21:40','2025-12-18 16:21:40'),(852,'XYZ-1766074900094-09604787',5,NULL,'IN_STOCK','GRN','XYZ956260632','2025-12-18 16:21:40','2025-12-18 16:21:40'),(853,'XYZ-1766074900116-B95BDA39',5,NULL,'IN_STOCK','GRN','XYZ245573753','2025-12-18 16:21:40','2025-12-18 16:21:40'),(854,'XYZ-1766074900144-DAB4D7FB',5,NULL,'IN_STOCK','GRN','XYZ424794513','2025-12-18 16:21:40','2025-12-18 16:21:40'),(855,'XYZ-1766074900172-3A070477',5,NULL,'IN_STOCK','GRN','XYZ586382480','2025-12-18 16:21:40','2025-12-18 16:21:40'),(856,'XYZ-1766074900200-41C90E2C',5,NULL,'IN_STOCK','GRN','XYZ856782094','2025-12-18 16:21:40','2025-12-18 16:21:40'),(857,'XYZ-1766074900227-DEBA457B',5,NULL,'IN_STOCK','GRN','XYZ192037878','2025-12-18 16:21:40','2025-12-18 16:21:40'),(858,'XYZ-1766074900253-D3896914',5,NULL,'IN_STOCK','GRN','XYZ329260318','2025-12-18 16:21:40','2025-12-18 16:21:40'),(859,'XYZ-1766074900283-50B3483F',5,NULL,'IN_STOCK','GRN','XYZ172659431','2025-12-18 16:21:40','2025-12-18 16:21:40'),(860,'XYZ-1766074900307-730C2A1A',5,NULL,'IN_STOCK','GRN','XYZ582299581','2025-12-18 16:21:40','2025-12-18 16:21:40'),(861,'XYZ-1766074900336-9DF46F74',5,NULL,'IN_STOCK','GRN','XYZ306958433','2025-12-18 16:21:40','2025-12-18 16:21:40'),(862,'XYZ-1766074900361-67DB9995',5,NULL,'IN_STOCK','GRN','XYZ558034698','2025-12-18 16:21:40','2025-12-18 16:21:40'),(863,'XYZ-1766074900385-494F2507',5,NULL,'IN_STOCK','GRN','XYZ213364716','2025-12-18 16:21:40','2025-12-18 16:21:40'),(864,'XYZ-1766074900408-92AEF483',5,NULL,'IN_STOCK','GRN','XYZ618372802','2025-12-18 16:21:40','2025-12-18 16:21:40'),(865,'XYZ-1766074900432-B70CE095',5,NULL,'IN_STOCK','GRN','XYZ206286406','2025-12-18 16:21:40','2025-12-18 16:21:40'),(866,'XYZ-1766074900454-783B2BAA',5,NULL,'IN_STOCK','GRN','XYZ369130010','2025-12-18 16:21:40','2025-12-18 16:21:40'),(867,'XYZ-1766074900478-20A67E36',5,NULL,'IN_STOCK','GRN','XYZ913959445','2025-12-18 16:21:40','2025-12-18 16:21:40'),(868,'XYZ-1766074900506-88D6016E',5,NULL,'IN_STOCK','GRN','XYZ526645325','2025-12-18 16:21:40','2025-12-18 16:21:40'),(869,'XYZ-1766074900530-04EB5AC7',5,NULL,'IN_STOCK','GRN','XYZ020122219','2025-12-18 16:21:40','2025-12-18 16:21:40'),(870,'XYZ-1766074900556-232C4768',5,NULL,'IN_STOCK','GRN','XYZ513368487','2025-12-18 16:21:40','2025-12-18 16:21:40'),(871,'XYZ-1766074900584-D3FA7E55',5,NULL,'IN_STOCK','GRN','XYZ226608721','2025-12-18 16:21:40','2025-12-18 16:21:40'),(872,'XYZ-1766074900612-C017A09B',5,NULL,'IN_STOCK','GRN','XYZ800547296','2025-12-18 16:21:40','2025-12-18 16:21:40'),(873,'XYZ-1766074900641-603FA209',5,NULL,'IN_STOCK','GRN','XYZ852565428','2025-12-18 16:21:40','2025-12-18 16:21:40'),(874,'XYZ-1766074900672-7E5F93CE',5,NULL,'IN_STOCK','GRN','XYZ000073920','2025-12-18 16:21:40','2025-12-18 16:21:40'),(875,'XYZ-1766074900699-CCA7C0DC',5,NULL,'IN_STOCK','GRN','XYZ603369623','2025-12-18 16:21:40','2025-12-18 16:21:40'),(876,'XYZ-1766074900728-CF1F98D0',5,NULL,'IN_STOCK','GRN','XYZ895568430','2025-12-18 16:21:40','2025-12-18 16:21:40'),(877,'XYZ-1766074900755-B382D767',5,NULL,'IN_STOCK','GRN','XYZ887592507','2025-12-18 16:21:40','2025-12-18 16:21:40'),(878,'XYZ-1766074900784-C8CF885A',5,NULL,'IN_STOCK','GRN','XYZ991097090','2025-12-18 16:21:40','2025-12-18 16:21:40'),(879,'XYZ-1766074900813-9FDEA988',5,NULL,'IN_STOCK','GRN','XYZ699751100','2025-12-18 16:21:40','2025-12-18 16:21:40'),(880,'XYZ-1766074900842-3502172E',5,NULL,'IN_STOCK','GRN','XYZ842459988','2025-12-18 16:21:40','2025-12-18 16:21:40'),(881,'XYZ-1766074900869-307D5EA2',5,NULL,'IN_STOCK','GRN','XYZ196057479','2025-12-18 16:21:40','2025-12-18 16:21:40'),(882,'XYZ-1766074900897-DD17EFCB',5,NULL,'IN_STOCK','GRN','XYZ545518330','2025-12-18 16:21:40','2025-12-18 16:21:40'),(883,'XYZ-1766074900924-00CD1C0D',5,NULL,'IN_STOCK','GRN','XYZ024107545','2025-12-18 16:21:40','2025-12-18 16:21:40'),(884,'XYZ-1766074900951-F86D3269',5,NULL,'IN_STOCK','GRN','XYZ001372284','2025-12-18 16:21:40','2025-12-18 16:21:40'),(885,'XYZ-1766074900978-E970F764',5,NULL,'IN_STOCK','GRN','XYZ179401894','2025-12-18 16:21:40','2025-12-18 16:21:40'),(886,'XYZ-1766074901007-8897C690',5,NULL,'IN_STOCK','GRN','XYZ414720807','2025-12-18 16:21:41','2025-12-18 16:21:41'),(887,'XYZ-1766074901034-103AE55D',5,NULL,'IN_STOCK','GRN','XYZ649516806','2025-12-18 16:21:41','2025-12-18 16:21:41'),(888,'XYZ-1766074901063-51C24D35',5,NULL,'IN_STOCK','GRN','XYZ295385066','2025-12-18 16:21:41','2025-12-18 16:21:41'),(889,'XYZ-1766074901084-FB92909B',5,NULL,'IN_STOCK','GRN','XYZ321461170','2025-12-18 16:21:41','2025-12-18 16:21:41'),(890,'XYZ-1766074901104-EAD354BA',5,NULL,'IN_STOCK','GRN','XYZ480116413','2025-12-18 16:21:41','2025-12-18 16:21:41'),(891,'XYZ-1766074901125-6393DA5B',5,NULL,'IN_STOCK','GRN','XYZ102748060','2025-12-18 16:21:41','2025-12-18 16:21:41'),(892,'XYZ-1766074901153-121F7F09',5,NULL,'IN_STOCK','GRN','XYZ127530127','2025-12-18 16:21:41','2025-12-18 16:21:41'),(893,'XYZ-1766074901180-CAD5E242',5,NULL,'IN_STOCK','GRN','XYZ208096511','2025-12-18 16:21:41','2025-12-18 16:21:41'),(894,'XYZ-1766074901209-0F3ED4A4',5,NULL,'IN_STOCK','GRN','XYZ610709969','2025-12-18 16:21:41','2025-12-18 16:21:41'),(895,'XYZ-1766074901236-74DCC054',5,NULL,'IN_STOCK','GRN','XYZ599207304','2025-12-18 16:21:41','2025-12-18 16:21:41'),(896,'XYZ-1766074901259-65950064',5,NULL,'IN_STOCK','GRN','XYZ289863027','2025-12-18 16:21:41','2025-12-18 16:21:41'),(897,'XYZ-1766074901282-C2FE45DF',5,NULL,'IN_STOCK','GRN','XYZ775983224','2025-12-18 16:21:41','2025-12-18 16:21:41'),(898,'XYZ-1766074901307-BC236F42',5,NULL,'IN_STOCK','GRN','XYZ193005531','2025-12-18 16:21:41','2025-12-18 16:21:41'),(899,'XYZ-1766074901332-166E1113',5,NULL,'IN_STOCK','GRN','XYZ372029502','2025-12-18 16:21:41','2025-12-18 16:21:41'),(900,'XYZ-1766074901360-75638031',5,NULL,'IN_STOCK','GRN','XYZ124986463','2025-12-18 16:21:41','2025-12-18 16:21:41'),(901,'XYZ-1766074901387-2155501B',5,NULL,'IN_STOCK','GRN','XYZ893733935','2025-12-18 16:21:41','2025-12-18 16:21:41'),(902,'XYZ-1766074901411-29DA75F9',5,NULL,'IN_STOCK','GRN','XYZ737400803','2025-12-18 16:21:41','2025-12-18 16:21:41'),(903,'XYZ-1766074901439-3EAE4D39',5,NULL,'IN_STOCK','GRN','XYZ684336658','2025-12-18 16:21:41','2025-12-18 16:21:41'),(904,'XYZ-1766074901465-FE1835E2',5,NULL,'IN_STOCK','GRN','XYZ822310537','2025-12-18 16:21:41','2025-12-18 16:21:41'),(905,'XYZ-1766074901491-6C5A460E',5,NULL,'IN_STOCK','GRN','XYZ611678466','2025-12-18 16:21:41','2025-12-18 16:21:41'),(906,'XYZ-1766074901518-5B433EC8',5,NULL,'IN_STOCK','GRN','XYZ180086657','2025-12-18 16:21:41','2025-12-18 16:21:41'),(907,'XYZ-1766074901545-B3D26FC2',5,NULL,'IN_STOCK','GRN','XYZ609719059','2025-12-18 16:21:41','2025-12-18 16:21:41'),(908,'XYZ-1766074901573-BE3013B4',5,NULL,'IN_STOCK','GRN','XYZ984603918','2025-12-18 16:21:41','2025-12-18 16:21:41'),(909,'XYZ-1766074901599-37C602AC',5,NULL,'IN_STOCK','GRN','XYZ828553522','2025-12-18 16:21:41','2025-12-18 16:21:41'),(910,'XYZ-1766074901626-2D79C586',5,NULL,'IN_STOCK','GRN','XYZ839475988','2025-12-18 16:21:41','2025-12-18 16:21:41'),(911,'XYZ-1766074901654-E928723B',5,NULL,'IN_STOCK','GRN','XYZ813582876','2025-12-18 16:21:41','2025-12-18 16:21:41'),(912,'XYZ-1766074901683-95629144',5,NULL,'IN_STOCK','GRN','XYZ271280439','2025-12-18 16:21:41','2025-12-18 16:21:41'),(913,'XYZ-1766074901711-935D7E14',5,NULL,'IN_STOCK','GRN','XYZ726342460','2025-12-18 16:21:41','2025-12-18 16:21:41'),(914,'XYZ-1766074901733-960192A3',5,NULL,'IN_STOCK','GRN','XYZ979433897','2025-12-18 16:21:41','2025-12-18 16:21:41'),(915,'XYZ-1766074901752-D3B6D314',5,NULL,'IN_STOCK','GRN','XYZ317882546','2025-12-18 16:21:41','2025-12-18 16:21:41'),(916,'XYZ-1766074901776-C0F188A7',5,NULL,'IN_STOCK','GRN','XYZ682100894','2025-12-18 16:21:41','2025-12-18 16:21:41'),(917,'XYZ-1766074901802-1431688F',5,NULL,'IN_STOCK','GRN','XYZ986929179','2025-12-18 16:21:41','2025-12-18 16:21:41'),(918,'XYZ-1766074901829-7B0C286A',5,NULL,'IN_STOCK','GRN','XYZ382921241','2025-12-18 16:21:41','2025-12-18 16:21:41'),(919,'XYZ-1766074901856-52405202',5,NULL,'IN_STOCK','GRN','XYZ622262121','2025-12-18 16:21:41','2025-12-18 16:21:41'),(920,'XYZ-1766074901883-770684FB',5,NULL,'IN_STOCK','GRN','XYZ681674519','2025-12-18 16:21:41','2025-12-18 16:21:41'),(921,'XYZ-1766074901908-25704273',5,NULL,'IN_STOCK','GRN','XYZ173011912','2025-12-18 16:21:41','2025-12-18 16:21:41'),(922,'XYZ-1766074901934-D6BC9C3E',5,NULL,'IN_STOCK','GRN','XYZ174866876','2025-12-18 16:21:41','2025-12-18 16:21:41'),(923,'XYZ-1766074901961-38CCD801',5,NULL,'IN_STOCK','GRN','XYZ702453696','2025-12-18 16:21:41','2025-12-18 16:21:41'),(924,'XYZ-1766074901989-E4E60E59',5,NULL,'IN_STOCK','GRN','XYZ975574660','2025-12-18 16:21:41','2025-12-18 16:21:41'),(925,'XYZ-1766074902013-0CF1B851',5,NULL,'IN_STOCK','GRN','XYZ746775264','2025-12-18 16:21:42','2025-12-18 16:21:42'),(926,'XYZ-1766074902040-19E919D6',5,NULL,'IN_STOCK','GRN','XYZ796289271','2025-12-18 16:21:42','2025-12-18 16:21:42'),(927,'XYZ-1766074902066-B4B4FD50',5,NULL,'IN_STOCK','GRN','XYZ987328115','2025-12-18 16:21:42','2025-12-18 16:21:42'),(928,'XYZ-1766074902092-D3C3F4BE',5,NULL,'IN_STOCK','GRN','XYZ957333971','2025-12-18 16:21:42','2025-12-18 16:21:42'),(929,'XYZ-1766074902121-019D926C',5,NULL,'IN_STOCK','GRN','XYZ148013680','2025-12-18 16:21:42','2025-12-18 16:21:42'),(930,'XYZ-1766074902146-C699D82D',5,NULL,'IN_STOCK','GRN','XYZ315885603','2025-12-18 16:21:42','2025-12-18 16:21:42'),(931,'XYZ-1766074902174-DE988D59',5,NULL,'IN_STOCK','GRN','XYZ510536905','2025-12-18 16:21:42','2025-12-18 16:21:42'),(932,'XYZ-1766074902203-07EAAD3D',5,NULL,'IN_STOCK','GRN','XYZ497087678','2025-12-18 16:21:42','2025-12-18 16:21:42'),(933,'XYZ-1766074902230-4E97A6DE',5,NULL,'IN_STOCK','GRN','XYZ325552902','2025-12-18 16:21:42','2025-12-18 16:21:42'),(934,'XYZ-1766074902256-81DF4EE0',5,NULL,'IN_STOCK','GRN','XYZ117392086','2025-12-18 16:21:42','2025-12-18 16:21:42'),(935,'XYZ-1766074902283-FA79586B',5,NULL,'IN_STOCK','GRN','XYZ773653214','2025-12-18 16:21:42','2025-12-18 16:21:42'),(936,'XYZ-1766074902307-122052B1',5,NULL,'IN_STOCK','GRN','XYZ395141808','2025-12-18 16:21:42','2025-12-18 16:21:42'),(937,'XYZ-1766074902327-848953A0',5,NULL,'IN_STOCK','GRN','XYZ908644592','2025-12-18 16:21:42','2025-12-18 16:21:42'),(938,'XYZ-1766074902347-5CA3C46B',5,NULL,'IN_STOCK','GRN','XYZ924843714','2025-12-18 16:21:42','2025-12-18 16:21:42'),(939,'XYZ-1766074902370-A6FF7167',5,NULL,'IN_STOCK','GRN','XYZ642579630','2025-12-18 16:21:42','2025-12-18 16:21:42'),(940,'XYZ-1766074902395-AE3109DE',5,NULL,'IN_STOCK','GRN','XYZ106182852','2025-12-18 16:21:42','2025-12-18 16:21:42'),(941,'XYZ-1766074902416-7C4D4977',5,NULL,'IN_STOCK','GRN','XYZ644662511','2025-12-18 16:21:42','2025-12-18 16:21:42'),(942,'XYZ-1766074902441-CF672188',5,NULL,'IN_STOCK','GRN','XYZ394376737','2025-12-18 16:21:42','2025-12-18 16:21:42'),(943,'XYZ-1766074902468-AD3CC9C2',5,NULL,'IN_STOCK','GRN','XYZ431240163','2025-12-18 16:21:42','2025-12-18 16:21:42'),(944,'XYZ-1766074902495-EDEE1730',5,NULL,'IN_STOCK','GRN','XYZ944267270','2025-12-18 16:21:42','2025-12-18 16:21:42'),(945,'XYZ-1766074902522-58BE437F',5,NULL,'IN_STOCK','GRN','XYZ657218959','2025-12-18 16:21:42','2025-12-18 16:21:42'),(946,'XYZ-1766074902549-B2EF36B5',5,NULL,'IN_STOCK','GRN','XYZ455999991','2025-12-18 16:21:42','2025-12-18 16:21:42'),(947,'XYZ-1766074902575-898102E7',5,NULL,'IN_STOCK','GRN','XYZ473699289','2025-12-18 16:21:42','2025-12-18 16:21:42'),(948,'XYZ-1766074902601-B1CB0F0D',5,NULL,'IN_STOCK','GRN','XYZ198114782','2025-12-18 16:21:42','2025-12-18 16:21:42'),(949,'XYZ-1766074902625-E94AF0EE',5,NULL,'IN_STOCK','GRN','XYZ070023697','2025-12-18 16:21:42','2025-12-18 16:21:42'),(950,'XYZ-1766074902652-F288E7CB',5,NULL,'IN_STOCK','GRN','XYZ203480016','2025-12-18 16:21:42','2025-12-18 16:21:42'),(951,'XYZ-1766074902678-FA52D278',5,NULL,'IN_STOCK','GRN','XYZ620534745','2025-12-18 16:21:42','2025-12-18 16:21:42'),(952,'XYZ-1766074902708-8D6A2F37',5,NULL,'IN_STOCK','GRN','XYZ440431219','2025-12-18 16:21:42','2025-12-18 16:21:42'),(953,'XYZ-1766074902737-23ED72CD',5,NULL,'IN_STOCK','GRN','XYZ726635495','2025-12-18 16:21:42','2025-12-18 16:21:42'),(954,'XYZ-1766074902763-6024D642',5,NULL,'IN_STOCK','GRN','XYZ113267402','2025-12-18 16:21:42','2025-12-18 16:21:42'),(955,'XYZ-1766074902791-8731FEB4',5,NULL,'IN_STOCK','GRN','XYZ464583016','2025-12-18 16:21:42','2025-12-18 16:21:42'),(956,'XYZ-1766074902816-FFCAD885',5,NULL,'IN_STOCK','GRN','XYZ304406542','2025-12-18 16:21:42','2025-12-18 16:21:42'),(957,'XYZ-1766074902843-AF65C1BB',5,NULL,'IN_STOCK','GRN','XYZ524505107','2025-12-18 16:21:42','2025-12-18 16:21:42'),(958,'XYZ-1766074902870-515BF3D3',5,NULL,'IN_STOCK','GRN','XYZ906570570','2025-12-18 16:21:42','2025-12-18 16:21:42'),(959,'XYZ-1766074902897-6C9EE2CC',5,NULL,'IN_STOCK','GRN','XYZ435611368','2025-12-18 16:21:42','2025-12-18 16:21:42'),(960,'XYZ-1766074902924-3A3FC9DD',5,NULL,'IN_STOCK','GRN','XYZ282598949','2025-12-18 16:21:42','2025-12-18 16:21:42'),(961,'XYZ-1766074902949-BD032314',5,NULL,'IN_STOCK','GRN','XYZ489990157','2025-12-18 16:21:42','2025-12-18 16:21:42'),(962,'XYZ-1766074902972-D29AF282',5,NULL,'IN_STOCK','GRN','XYZ664066031','2025-12-18 16:21:42','2025-12-18 16:21:42'),(963,'XYZ-1766074902997-9454D629',5,NULL,'IN_STOCK','GRN','XYZ527139940','2025-12-18 16:21:43','2025-12-18 16:21:43'),(964,'XYZ-1766074903024-F6E0FF0F',5,NULL,'IN_STOCK','GRN','XYZ136731989','2025-12-18 16:21:43','2025-12-18 16:21:43'),(965,'XYZ-1766074903050-B4075456',5,NULL,'IN_STOCK','GRN','XYZ454257824','2025-12-18 16:21:43','2025-12-18 16:21:43'),(966,'XYZ-1766074903077-24CFE238',5,NULL,'IN_STOCK','GRN','XYZ036442562','2025-12-18 16:21:43','2025-12-18 16:21:43'),(967,'XYZ-1766074903104-EC16EB77',5,NULL,'IN_STOCK','GRN','XYZ575923196','2025-12-18 16:21:43','2025-12-18 16:21:43'),(968,'XYZ-1766074903132-FD61A1F6',5,NULL,'IN_STOCK','GRN','XYZ795351662','2025-12-18 16:21:43','2025-12-18 16:21:43'),(969,'XYZ-1766074903156-5F2B13F9',5,NULL,'IN_STOCK','GRN','XYZ627004262','2025-12-18 16:21:43','2025-12-18 16:21:43'),(970,'XYZ-1766074903185-EA431714',5,NULL,'IN_STOCK','GRN','XYZ081522285','2025-12-18 16:21:43','2025-12-18 16:21:43'),(971,'XYZ-1766074903213-67C94C0E',5,NULL,'IN_STOCK','GRN','XYZ620322485','2025-12-18 16:21:43','2025-12-18 16:21:43'),(972,'XYZ-1766074903240-3EFBEE94',5,NULL,'IN_STOCK','GRN','XYZ169302657','2025-12-18 16:21:43','2025-12-18 16:21:43'),(973,'XYZ-1766074903268-57359DAE',5,NULL,'IN_STOCK','GRN','XYZ224772518','2025-12-18 16:21:43','2025-12-18 16:21:43'),(974,'XYZ-1766074903293-DD776A08',5,NULL,'IN_STOCK','GRN','XYZ864204503','2025-12-18 16:21:43','2025-12-18 16:21:43'),(975,'XYZ-1766074903316-CA863FCE',5,NULL,'IN_STOCK','GRN','XYZ812016388','2025-12-18 16:21:43','2025-12-18 16:21:43'),(976,'XYZ-1766074903339-6D430971',5,NULL,'IN_STOCK','GRN','XYZ183841018','2025-12-18 16:21:43','2025-12-18 16:21:43'),(977,'XYZ-1766074903359-C06830EC',5,NULL,'IN_STOCK','GRN','XYZ498270347','2025-12-18 16:21:43','2025-12-18 16:21:43'),(978,'XYZ-1766074903378-CA1115F7',5,NULL,'IN_STOCK','GRN','XYZ958457308','2025-12-18 16:21:43','2025-12-18 16:21:43'),(979,'XYZ-1766074903398-7A4B6CB9',5,NULL,'IN_STOCK','GRN','XYZ927060175','2025-12-18 16:21:43','2025-12-18 16:21:43'),(980,'XYZ-1766074903421-2E8FF206',5,NULL,'IN_STOCK','GRN','XYZ000117551','2025-12-18 16:21:43','2025-12-18 16:21:43'),(981,'XYZ-1766074903447-6F045837',5,NULL,'IN_STOCK','GRN','XYZ080805418','2025-12-18 16:21:43','2025-12-18 16:21:43'),(982,'XYZ-1766074903474-AF41BAB4',5,NULL,'IN_STOCK','GRN','XYZ052309048','2025-12-18 16:21:43','2025-12-18 16:21:43'),(983,'XYZ-1766074903501-04A6E7FB',5,NULL,'IN_STOCK','GRN','XYZ331054961','2025-12-18 16:21:43','2025-12-18 16:21:43'),(984,'XYZ-1766074903527-43053463',5,NULL,'IN_STOCK','GRN','XYZ995802241','2025-12-18 16:21:43','2025-12-18 16:21:43'),(985,'XYZ-1766074903554-51E93339',5,NULL,'IN_STOCK','GRN','XYZ386249278','2025-12-18 16:21:43','2025-12-18 16:21:43'),(986,'XYZ-1766074903579-8E3FF625',5,NULL,'IN_STOCK','GRN','XYZ299303390','2025-12-18 16:21:43','2025-12-18 16:21:43'),(987,'XYZ-1766074903607-C4090271',5,NULL,'IN_STOCK','GRN','XYZ436844856','2025-12-18 16:21:43','2025-12-18 16:21:43'),(988,'XYZ-1766074903634-8918465A',5,NULL,'IN_STOCK','GRN','XYZ533039888','2025-12-18 16:21:43','2025-12-18 16:21:43'),(989,'XYZ-1766074903661-5205F6B7',5,NULL,'IN_STOCK','GRN','XYZ935829047','2025-12-18 16:21:43','2025-12-18 16:21:43'),(990,'XYZ-1766074903683-783E82E6',5,NULL,'IN_STOCK','GRN','XYZ940873454','2025-12-18 16:21:43','2025-12-18 16:21:43'),(991,'XYZ-1766074903707-436598D9',5,NULL,'IN_STOCK','GRN','XYZ400255855','2025-12-18 16:21:43','2025-12-18 16:21:43'),(992,'XYZ-1766074903733-A6089D37',5,NULL,'IN_STOCK','GRN','XYZ247848144','2025-12-18 16:21:43','2025-12-18 16:21:43'),(993,'XYZ-1766074903755-0D84E5AD',5,NULL,'IN_STOCK','GRN','XYZ450238577','2025-12-18 16:21:43','2025-12-18 16:21:43'),(994,'XYZ-1766074903775-A2DA1BD9',5,NULL,'IN_STOCK','GRN','XYZ008090055','2025-12-18 16:21:43','2025-12-18 16:21:43'),(995,'XYZ-1766074903796-F86949A6',5,NULL,'IN_STOCK','GRN','XYZ538877960','2025-12-18 16:21:43','2025-12-18 16:21:43'),(996,'XYZ-1766074903815-7E5E84D0',5,NULL,'IN_STOCK','GRN','XYZ114204476','2025-12-18 16:21:43','2025-12-18 16:21:43'),(997,'XYZ-1766074903835-40DBFF4F',5,NULL,'IN_STOCK','GRN','XYZ596995955','2025-12-18 16:21:43','2025-12-18 16:21:43'),(998,'XYZ-1766074903857-FB169D10',5,NULL,'IN_STOCK','GRN','XYZ735295441','2025-12-18 16:21:43','2025-12-18 16:21:43'),(999,'XYZ-1766074903880-ED866273',5,NULL,'IN_STOCK','GRN','XYZ617511836','2025-12-18 16:21:43','2025-12-18 16:21:43'),(1000,'XYZ-1766074903902-26216E7D',5,NULL,'IN_STOCK','GRN','XYZ928424335','2025-12-18 16:21:43','2025-12-18 16:21:43'),(1001,'XYZ-1766074903927-C6FDA982',5,NULL,'IN_STOCK','GRN','XYZ299948006','2025-12-18 16:21:43','2025-12-18 16:21:43'),(1002,'XYZ-1766074903951-900F2C70',5,NULL,'IN_STOCK','GRN','XYZ192857809','2025-12-18 16:21:43','2025-12-18 16:21:43'),(1003,'XYZ-1766074903974-FE8EC369',5,NULL,'IN_STOCK','GRN','XYZ083342600','2025-12-18 16:21:43','2025-12-18 16:21:43'),(1004,'XYZ-1766074903997-391EB76E',5,NULL,'IN_STOCK','GRN','XYZ488798659','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1005,'XYZ-1766074904017-B3211836',5,NULL,'IN_STOCK','GRN','XYZ078134594','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1006,'XYZ-1766074904038-C81F4C1A',5,NULL,'IN_STOCK','GRN','XYZ093577920','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1007,'XYZ-1766074904062-0092F46F',5,NULL,'IN_STOCK','GRN','XYZ412005950','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1008,'XYZ-1766074904085-A32ABE8C',5,NULL,'IN_STOCK','GRN','XYZ286165263','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1009,'XYZ-1766074904111-DD80E87F',5,NULL,'IN_STOCK','GRN','XYZ798292150','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1010,'XYZ-1766074904138-744C8F21',5,NULL,'IN_STOCK','GRN','XYZ645052686','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1011,'XYZ-1766074904166-A893F5CD',5,NULL,'IN_STOCK','GRN','XYZ917854727','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1012,'XYZ-1766074904191-FAABCC14',5,NULL,'IN_STOCK','GRN','XYZ778036658','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1013,'XYZ-1766074904215-B3BDDCCB',5,NULL,'IN_STOCK','GRN','XYZ643894378','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1014,'XYZ-1766074904241-AA31DF1C',5,NULL,'IN_STOCK','GRN','XYZ485160365','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1015,'XYZ-1766074904269-895F0FAB',5,NULL,'IN_STOCK','GRN','XYZ900702505','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1016,'XYZ-1766074904297-B3C0A896',5,NULL,'IN_STOCK','GRN','XYZ302650790','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1017,'XYZ-1766074904324-4ADCF7A1',5,NULL,'IN_STOCK','GRN','XYZ864717181','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1018,'XYZ-1766074904351-BD563C59',5,NULL,'IN_STOCK','GRN','XYZ373626209','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1019,'XYZ-1766074904378-CB926D73',5,NULL,'IN_STOCK','GRN','XYZ928776673','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1020,'XYZ-1766074904404-EF9DEDE7',5,NULL,'IN_STOCK','GRN','XYZ226771895','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1021,'XYZ-1766074904428-D6A8E341',5,NULL,'IN_STOCK','GRN','XYZ031060792','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1022,'XYZ-1766074904455-F49DE470',5,NULL,'IN_STOCK','GRN','XYZ150097025','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1023,'XYZ-1766074904481-3F817127',5,NULL,'IN_STOCK','GRN','XYZ473842543','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1024,'XYZ-1766074904508-7E0F3CFB',5,NULL,'IN_STOCK','GRN','XYZ951315841','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1025,'XYZ-1766074904534-8BCA2202',5,NULL,'IN_STOCK','GRN','XYZ215776293','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1026,'XYZ-1766074904560-2D312BF1',5,NULL,'IN_STOCK','GRN','XYZ294828124','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1027,'XYZ-1766074904584-FB184134',5,NULL,'IN_STOCK','GRN','XYZ176446237','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1028,'XYZ-1766074904606-516FD369',5,NULL,'IN_STOCK','GRN','XYZ295624635','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1029,'XYZ-1766074904633-3BE395E0',5,NULL,'IN_STOCK','GRN','XYZ429525142','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1030,'XYZ-1766074904660-B3CB634C',5,NULL,'IN_STOCK','GRN','XYZ624320235','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1031,'XYZ-1766074904690-713B3B8D',5,NULL,'IN_STOCK','GRN','XYZ077532515','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1032,'XYZ-1766074904716-CCCC832C',5,NULL,'IN_STOCK','GRN','XYZ528527741','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1033,'XYZ-1766074904743-2080CA58',5,NULL,'IN_STOCK','GRN','XYZ546857729','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1034,'XYZ-1766074904767-52721FDC',5,NULL,'IN_STOCK','GRN','XYZ209208395','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1035,'XYZ-1766074904792-B172C707',5,NULL,'IN_STOCK','GRN','XYZ056403003','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1036,'XYZ-1766074904820-A35F2297',5,NULL,'IN_STOCK','GRN','XYZ343479445','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1037,'XYZ-1766074904848-E6C476AC',5,NULL,'IN_STOCK','GRN','XYZ913502536','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1038,'XYZ-1766074904875-46420167',5,NULL,'IN_STOCK','GRN','XYZ190369314','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1039,'XYZ-1766074904901-37DC0927',5,NULL,'IN_STOCK','GRN','XYZ556477468','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1040,'XYZ-1766074904928-D3F70928',5,NULL,'IN_STOCK','GRN','XYZ368197903','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1041,'XYZ-1766074904955-A882C3FF',5,NULL,'IN_STOCK','GRN','XYZ830040337','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1042,'XYZ-1766074904981-E91FD6F8',5,NULL,'IN_STOCK','GRN','XYZ845928588','2025-12-18 16:21:44','2025-12-18 16:21:44'),(1043,'XYZ-1766074905006-8ED25FDE',5,NULL,'IN_STOCK','GRN','XYZ811310024','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1044,'XYZ-1766074905033-4CD8F09F',5,NULL,'IN_STOCK','GRN','XYZ205030100','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1045,'XYZ-1766074905059-91700547',5,NULL,'IN_STOCK','GRN','XYZ833959839','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1046,'XYZ-1766074905084-1CAF9D94',5,NULL,'IN_STOCK','GRN','XYZ343601073','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1047,'XYZ-1766074905110-9D07400C',5,NULL,'IN_STOCK','GRN','XYZ567843684','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1048,'XYZ-1766074905133-58569DD1',5,NULL,'IN_STOCK','GRN','XYZ122413498','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1049,'XYZ-1766074905160-39BDE846',5,NULL,'IN_STOCK','GRN','XYZ035730305','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1050,'XYZ-1766074905187-043AA109',5,NULL,'IN_STOCK','GRN','XYZ932853576','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1051,'XYZ-1766074905215-5C6BDFA0',5,NULL,'IN_STOCK','GRN','XYZ423419421','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1052,'XYZ-1766074905241-5D1D293A',5,NULL,'IN_STOCK','GRN','XYZ001647294','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1053,'XYZ-1766074905267-68BA9992',5,NULL,'IN_STOCK','GRN','XYZ799798444','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1054,'XYZ-1766074905293-668960B9',5,NULL,'IN_STOCK','GRN','XYZ949427395','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1055,'XYZ-1766074905316-8EF46800',5,NULL,'IN_STOCK','GRN','XYZ432310857','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1056,'XYZ-1766074905342-8B98D510',5,NULL,'IN_STOCK','GRN','XYZ956460976','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1057,'XYZ-1766074905368-13DD77CC',5,NULL,'IN_STOCK','GRN','XYZ701961977','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1058,'XYZ-1766074905396-3A4FA788',5,NULL,'IN_STOCK','GRN','XYZ527654260','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1059,'XYZ-1766074905427-80E4666E',5,NULL,'IN_STOCK','GRN','XYZ909625752','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1060,'XYZ-1766074905452-1E4D6961',5,NULL,'IN_STOCK','GRN','XYZ931734622','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1061,'XYZ-1766074905471-9E963FD8',5,NULL,'IN_STOCK','GRN','XYZ265434059','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1062,'XYZ-1766074905492-F15933AD',5,NULL,'IN_STOCK','GRN','XYZ390551901','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1063,'XYZ-1766074905514-12AEF151',5,NULL,'IN_STOCK','GRN','XYZ389032753','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1064,'XYZ-1766074905541-18A20358',5,NULL,'IN_STOCK','GRN','XYZ977106330','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1065,'XYZ-1766074905561-EE5113DB',5,NULL,'IN_STOCK','GRN','XYZ164376700','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1066,'XYZ-1766074905582-4EC14A77',5,NULL,'IN_STOCK','GRN','XYZ630870872','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1067,'XYZ-1766074905607-60FF391D',5,NULL,'IN_STOCK','GRN','XYZ213288395','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1068,'XYZ-1766074905625-98D74FDA',5,NULL,'IN_STOCK','GRN','XYZ005886148','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1069,'XYZ-1766074905643-7DA59148',5,NULL,'IN_STOCK','GRN','XYZ535161822','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1070,'XYZ-1766074905662-8558FBCD',5,NULL,'IN_STOCK','GRN','XYZ977505856','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1071,'XYZ-1766074905681-841EADF6',5,NULL,'IN_STOCK','GRN','XYZ354177375','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1072,'XYZ-1766074905701-D66B7037',5,NULL,'IN_STOCK','GRN','XYZ110136954','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1073,'XYZ-1766074905721-3BE9850C',5,NULL,'IN_STOCK','GRN','XYZ475439816','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1074,'XYZ-1766074905741-83BB20D7',5,NULL,'IN_STOCK','GRN','XYZ864239182','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1075,'XYZ-1766074905761-C67E9E2D',5,NULL,'IN_STOCK','GRN','XYZ704219229','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1076,'XYZ-1766074905780-2B796E5E',5,NULL,'IN_STOCK','GRN','XYZ230647721','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1077,'XYZ-1766074905799-D4DF5C8E',5,NULL,'IN_STOCK','GRN','XYZ110611388','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1078,'XYZ-1766074905820-93FBAC88',5,NULL,'IN_STOCK','GRN','XYZ898429365','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1079,'XYZ-1766074905843-ED49D54F',5,NULL,'IN_STOCK','GRN','XYZ833441039','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1080,'XYZ-1766074905863-DF16B053',5,NULL,'IN_STOCK','GRN','XYZ477212463','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1081,'XYZ-1766074905882-97C06B90',5,NULL,'IN_STOCK','GRN','XYZ169648708','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1082,'XYZ-1766074905903-4507046A',5,NULL,'IN_STOCK','GRN','XYZ283222568','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1083,'XYZ-1766074905923-D2F17058',5,NULL,'IN_STOCK','GRN','XYZ101290521','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1084,'XYZ-1766074905944-3EC334B8',5,NULL,'IN_STOCK','GRN','XYZ974597413','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1085,'XYZ-1766074905970-AC2066F8',5,NULL,'IN_STOCK','GRN','XYZ639893443','2025-12-18 16:21:45','2025-12-18 16:21:45'),(1086,'XYZ-1766074905997-DD33523D',5,NULL,'IN_STOCK','GRN','XYZ893481223','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1087,'XYZ-1766074906023-88DE39FE',5,NULL,'IN_STOCK','GRN','XYZ046354567','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1088,'XYZ-1766074906049-E660DEBA',5,NULL,'IN_STOCK','GRN','XYZ548176334','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1089,'XYZ-1766074906078-8AEF6968',5,NULL,'IN_STOCK','GRN','XYZ891578363','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1090,'XYZ-1766074906101-D82645F2',5,NULL,'IN_STOCK','GRN','XYZ518843403','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1091,'XYZ-1766074906128-606FF2C1',5,NULL,'IN_STOCK','GRN','XYZ013230727','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1092,'XYZ-1766074906153-743FA14A',5,NULL,'IN_STOCK','GRN','XYZ409663669','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1093,'XYZ-1766074906180-B42AD503',5,NULL,'IN_STOCK','GRN','XYZ516489736','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1094,'XYZ-1766074906207-1D6C22FA',5,NULL,'IN_STOCK','GRN','XYZ094930524','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1095,'XYZ-1766074906234-4E7FA562',5,NULL,'IN_STOCK','GRN','XYZ287229160','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1096,'XYZ-1766074906263-635E25C6',5,NULL,'IN_STOCK','GRN','XYZ175555049','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1097,'XYZ-1766074906290-6ACD867C',5,NULL,'IN_STOCK','GRN','XYZ581962340','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1098,'XYZ-1766074906318-D4C9A921',5,NULL,'IN_STOCK','GRN','XYZ589429281','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1099,'XYZ-1766074906345-B428DC49',5,NULL,'IN_STOCK','GRN','XYZ045165185','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1100,'XYZ-1766074906372-540DC424',5,NULL,'IN_STOCK','GRN','XYZ017542433','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1101,'XYZ-1766074906399-D59DAFFD',5,NULL,'IN_STOCK','GRN','XYZ444557367','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1102,'XYZ-1766074906427-D66C68B4',5,NULL,'IN_STOCK','GRN','XYZ363786597','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1103,'XYZ-1766074906455-34173A71',5,NULL,'IN_STOCK','GRN','XYZ667519274','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1104,'XYZ-1766074906482-3B84A5A7',5,NULL,'IN_STOCK','GRN','XYZ561108883','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1105,'XYZ-1766074906509-4C727A60',5,NULL,'IN_STOCK','GRN','XYZ517615512','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1106,'XYZ-1766074906534-7723489E',5,NULL,'IN_STOCK','GRN','XYZ210470705','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1107,'XYZ-1766074906562-9AE2409D',5,NULL,'IN_STOCK','GRN','XYZ552966742','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1108,'XYZ-1766074906589-413FB314',5,NULL,'IN_STOCK','GRN','XYZ821306158','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1109,'XYZ-1766074906615-370ED83E',5,NULL,'IN_STOCK','GRN','XYZ313760645','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1110,'XYZ-1766074906640-EF1E13F4',5,NULL,'IN_STOCK','GRN','XYZ532758836','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1111,'XYZ-1766074906667-18917400',5,NULL,'IN_STOCK','GRN','XYZ536376395','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1112,'XYZ-1766074906694-F4A99986',5,NULL,'IN_STOCK','GRN','XYZ602732611','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1113,'XYZ-1766074906722-43B95AB9',5,NULL,'IN_STOCK','GRN','XYZ291077893','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1114,'XYZ-1766074906751-96E75795',5,NULL,'IN_STOCK','GRN','XYZ847134713','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1115,'XYZ-1766074906785-09CF0497',5,NULL,'IN_STOCK','GRN','XYZ893163617','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1116,'XYZ-1766074906811-7732D619',5,NULL,'IN_STOCK','GRN','XYZ824553958','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1117,'XYZ-1766074906838-0C1E6919',5,NULL,'IN_STOCK','GRN','XYZ856682768','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1118,'XYZ-1766074906866-DB2522B0',5,NULL,'IN_STOCK','GRN','XYZ447716889','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1119,'XYZ-1766074906890-90C231FF',5,NULL,'IN_STOCK','GRN','XYZ639490013','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1120,'XYZ-1766074906916-70B194C2',5,NULL,'IN_STOCK','GRN','XYZ904212495','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1121,'XYZ-1766074906944-52980B24',5,NULL,'IN_STOCK','GRN','XYZ332454225','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1122,'XYZ-1766074906970-E4372896',5,NULL,'IN_STOCK','GRN','XYZ778079087','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1123,'XYZ-1766074906990-B9BA604A',5,NULL,'IN_STOCK','GRN','XYZ003399082','2025-12-18 16:21:46','2025-12-18 16:21:46'),(1124,'XYZ-1766074907014-0E648EE1',5,NULL,'IN_STOCK','GRN','XYZ313986610','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1125,'XYZ-1766074907039-648024E7',5,NULL,'IN_STOCK','GRN','XYZ335163357','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1126,'XYZ-1766074907067-13B9B59E',5,NULL,'IN_STOCK','GRN','XYZ795509672','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1127,'XYZ-1766074907098-3641C789',5,NULL,'IN_STOCK','GRN','XYZ672402762','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1128,'XYZ-1766074907125-362C8815',5,NULL,'IN_STOCK','GRN','XYZ488647473','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1129,'XYZ-1766074907154-318CF5DB',5,NULL,'IN_STOCK','GRN','XYZ629733257','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1130,'XYZ-1766074907181-7BDBE2E4',5,NULL,'IN_STOCK','GRN','XYZ768986475','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1131,'XYZ-1766074907208-93C92CD9',5,NULL,'IN_STOCK','GRN','XYZ396486044','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1132,'XYZ-1766074907238-7707F4A4',5,NULL,'IN_STOCK','GRN','XYZ559305331','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1133,'XYZ-1766074907264-7C588979',5,NULL,'IN_STOCK','GRN','XYZ183878394','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1134,'XYZ-1766074907292-A362DD4B',5,NULL,'IN_STOCK','GRN','XYZ294464101','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1135,'XYZ-1766074907317-A456EE44',5,NULL,'IN_STOCK','GRN','XYZ171894941','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1136,'XYZ-1766074907341-8A849ACF',5,NULL,'IN_STOCK','GRN','XYZ165631926','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1137,'XYZ-1766074907363-206DBC95',5,NULL,'IN_STOCK','GRN','XYZ007522348','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1138,'XYZ-1766074907390-1E5513B3',5,NULL,'IN_STOCK','GRN','XYZ880955432','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1139,'XYZ-1766074907413-798CCE79',5,NULL,'IN_STOCK','GRN','XYZ686595477','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1140,'XYZ-1766074907435-890BEA8F',5,NULL,'IN_STOCK','GRN','XYZ102123538','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1141,'XYZ-1766074907459-AC291699',5,NULL,'IN_STOCK','GRN','XYZ432031733','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1142,'XYZ-1766074907482-576F2C8A',5,NULL,'IN_STOCK','GRN','XYZ296404510','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1143,'XYZ-1766074907505-72FAADD2',5,NULL,'IN_STOCK','GRN','XYZ778150067','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1144,'XYZ-1766074907527-5E8498DB',5,NULL,'IN_STOCK','GRN','XYZ898054291','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1145,'XYZ-1766074907550-6CAC7A8E',5,NULL,'IN_STOCK','GRN','XYZ213149914','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1146,'XYZ-1766074907573-B0596DFA',5,NULL,'IN_STOCK','GRN','XYZ714114832','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1147,'XYZ-1766074907596-58FF3952',5,NULL,'IN_STOCK','GRN','XYZ408465255','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1148,'XYZ-1766074907622-45294B1A',5,NULL,'IN_STOCK','GRN','XYZ256911471','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1149,'XYZ-1766074907648-58A8A13D',5,NULL,'IN_STOCK','GRN','XYZ653341478','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1150,'XYZ-1766074907672-2FB8C989',5,NULL,'IN_STOCK','GRN','XYZ345787017','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1151,'XYZ-1766074907694-5A75B2DC',5,NULL,'IN_STOCK','GRN','XYZ980653526','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1152,'XYZ-1766074907720-E8640682',5,NULL,'IN_STOCK','GRN','XYZ036383708','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1153,'XYZ-1766074907745-196027D4',5,NULL,'IN_STOCK','GRN','XYZ950595498','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1154,'XYZ-1766074907771-AB666B41',5,NULL,'IN_STOCK','GRN','XYZ466728633','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1155,'XYZ-1766074907799-9EB32C0B',5,NULL,'IN_STOCK','GRN','XYZ272740692','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1156,'XYZ-1766074907826-823F0046',5,NULL,'IN_STOCK','GRN','XYZ902956823','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1157,'XYZ-1766074907851-6E014665',5,NULL,'IN_STOCK','GRN','XYZ225776387','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1158,'XYZ-1766074907877-D5448555',5,NULL,'IN_STOCK','GRN','XYZ671668703','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1159,'XYZ-1766074907901-02011FE5',5,NULL,'IN_STOCK','GRN','XYZ827952177','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1160,'XYZ-1766074907929-E19EE3AF',5,NULL,'IN_STOCK','GRN','XYZ912579485','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1161,'XYZ-1766074907956-78F7F620',5,NULL,'IN_STOCK','GRN','XYZ920121052','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1162,'XYZ-1766074907984-6FA77E31',5,NULL,'IN_STOCK','GRN','XYZ276589902','2025-12-18 16:21:47','2025-12-18 16:21:47'),(1163,'XYZ-1766074908012-411FF122',5,NULL,'IN_STOCK','GRN','XYZ715677154','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1164,'XYZ-1766074908039-6B97F81D',5,NULL,'IN_STOCK','GRN','XYZ980242734','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1165,'XYZ-1766074908063-DC68B6EE',5,NULL,'IN_STOCK','GRN','XYZ161533521','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1166,'XYZ-1766074908088-094183B4',5,NULL,'IN_STOCK','GRN','XYZ277455756','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1167,'XYZ-1766074908113-1E3B61A1',5,NULL,'IN_STOCK','GRN','XYZ604236240','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1168,'XYZ-1766074908134-54D0BE3E',5,NULL,'IN_STOCK','GRN','XYZ591499125','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1169,'XYZ-1766074908156-4BD0802C',5,NULL,'IN_STOCK','GRN','XYZ824055060','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1170,'XYZ-1766074908183-FEC439C4',5,NULL,'IN_STOCK','GRN','XYZ866924118','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1171,'XYZ-1766074908202-AB80BD5F',5,NULL,'IN_STOCK','GRN','XYZ704475728','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1172,'XYZ-1766074908228-343A57FE',5,NULL,'IN_STOCK','GRN','XYZ222777165','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1173,'XYZ-1766074908252-A4A93ED0',5,NULL,'IN_STOCK','GRN','XYZ077939345','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1174,'XYZ-1766074908275-304905CD',5,NULL,'IN_STOCK','GRN','XYZ497676173','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1175,'XYZ-1766074908298-B06561D9',5,NULL,'IN_STOCK','GRN','XYZ715697509','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1176,'XYZ-1766074908317-4887B503',5,NULL,'IN_STOCK','GRN','XYZ339437916','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1177,'XYZ-1766074908343-18DBE118',5,NULL,'IN_STOCK','GRN','XYZ365935651','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1178,'XYZ-1766074908370-324FC94F',5,NULL,'IN_STOCK','GRN','XYZ892574421','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1179,'XYZ-1766074908397-5353A61A',5,NULL,'IN_STOCK','GRN','XYZ856941865','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1180,'XYZ-1766074908425-8454FFBE',5,NULL,'IN_STOCK','GRN','XYZ753247856','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1181,'XYZ-1766074908451-F38C2584',5,NULL,'IN_STOCK','GRN','XYZ024186982','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1182,'XYZ-1766074908479-40973909',5,NULL,'IN_STOCK','GRN','XYZ366243792','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1183,'XYZ-1766074908505-0EBA55C1',5,NULL,'IN_STOCK','GRN','XYZ607680052','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1184,'XYZ-1766074908532-4ACDD4B2',5,NULL,'IN_STOCK','GRN','XYZ668755055','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1185,'XYZ-1766074908560-A6AA3917',5,NULL,'IN_STOCK','GRN','XYZ506704304','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1186,'XYZ-1766074908586-5AAA7DCA',5,NULL,'IN_STOCK','GRN','XYZ111990477','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1187,'XYZ-1766074908610-54EEF10A',5,NULL,'IN_STOCK','GRN','XYZ520657193','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1188,'XYZ-1766074908637-F38BB8A0',5,NULL,'IN_STOCK','GRN','XYZ038157291','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1189,'XYZ-1766074908664-A1FB3B7C',5,NULL,'IN_STOCK','GRN','XYZ002854412','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1190,'XYZ-1766074908691-1FCBDEB3',5,NULL,'IN_STOCK','GRN','XYZ317009490','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1191,'XYZ-1766074908718-0ED4D5F6',5,NULL,'IN_STOCK','GRN','XYZ030736724','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1192,'XYZ-1766074908746-9FBF5535',5,NULL,'IN_STOCK','GRN','XYZ998194773','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1193,'XYZ-1766074908773-5D824B46',5,NULL,'IN_STOCK','GRN','XYZ654045030','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1194,'XYZ-1766074908798-5450F356',5,NULL,'IN_STOCK','GRN','XYZ111404450','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1195,'XYZ-1766074908824-7044B17E',5,NULL,'IN_STOCK','GRN','XYZ955371774','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1196,'XYZ-1766074908849-FF002F0F',5,NULL,'IN_STOCK','GRN','XYZ145066952','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1197,'XYZ-1766074908873-9B2BC4AB',5,NULL,'IN_STOCK','GRN','XYZ297578288','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1198,'XYZ-1766074908902-4A226FC8',5,NULL,'IN_STOCK','GRN','XYZ197837633','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1199,'XYZ-1766074908930-7C531BA0',5,NULL,'IN_STOCK','GRN','XYZ296941065','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1200,'XYZ-1766074908957-FBA9CC62',5,NULL,'IN_STOCK','GRN','XYZ849250633','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1201,'XYZ-1766074908986-07F7A5B9',5,NULL,'IN_STOCK','GRN','XYZ965193555','2025-12-18 16:21:48','2025-12-18 16:21:48'),(1202,'XYZ-1766074909018-4E2D3E82',5,NULL,'IN_STOCK','GRN','XYZ260827830','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1203,'XYZ-1766074909046-6C3DBC04',5,NULL,'IN_STOCK','GRN','XYZ006633127','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1204,'XYZ-1766074909075-D733F0C2',5,NULL,'IN_STOCK','GRN','XYZ707399006','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1205,'XYZ-1766074909100-5E19289F',5,NULL,'IN_STOCK','GRN','XYZ894657411','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1206,'XYZ-1766074909128-B99F24AA',5,NULL,'IN_STOCK','GRN','XYZ647880668','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1207,'XYZ-1766074909154-634590AA',5,NULL,'IN_STOCK','GRN','XYZ709294433','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1208,'XYZ-1766074909181-EDA66F20',5,NULL,'IN_STOCK','GRN','XYZ260911026','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1209,'XYZ-1766074909207-0A6BC0C6',5,NULL,'IN_STOCK','GRN','XYZ712209254','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1210,'XYZ-1766074909233-9AA989C7',5,NULL,'IN_STOCK','GRN','XYZ884630333','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1211,'XYZ-1766074909254-C889EAAC',5,NULL,'IN_STOCK','GRN','XYZ589178533','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1212,'XYZ-1766074909274-F47F8D69',5,NULL,'IN_STOCK','GRN','XYZ818739133','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1213,'XYZ-1766074909294-4FB8228D',5,NULL,'IN_STOCK','GRN','XYZ632976996','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1214,'XYZ-1766074909320-FF7CA000',5,NULL,'IN_STOCK','GRN','XYZ569471464','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1215,'XYZ-1766074909346-D165A0A7',5,NULL,'IN_STOCK','GRN','XYZ725731675','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1216,'XYZ-1766074909374-10BE6C13',5,NULL,'IN_STOCK','GRN','XYZ463481470','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1217,'XYZ-1766074909398-46D0E092',5,NULL,'IN_STOCK','GRN','XYZ375712833','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1218,'XYZ-1766074909423-3EEABE3C',5,NULL,'IN_STOCK','GRN','XYZ294091745','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1219,'XYZ-1766074909444-2D15A4DA',5,NULL,'IN_STOCK','GRN','XYZ655283039','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1220,'XYZ-1766074909465-3778DD45',5,NULL,'IN_STOCK','GRN','XYZ269705732','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1221,'XYZ-1766074909489-E722E4F8',5,NULL,'IN_STOCK','GRN','XYZ697649397','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1222,'XYZ-1766074909513-EB7AD5F4',5,NULL,'IN_STOCK','GRN','XYZ828722612','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1223,'XYZ-1766074909541-1F019A6B',5,NULL,'IN_STOCK','GRN','XYZ345801859','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1224,'XYZ-1766074909567-BFF4024E',5,NULL,'IN_STOCK','GRN','XYZ327935918','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1225,'XYZ-1766074909589-BC99BB11',5,NULL,'IN_STOCK','GRN','XYZ019108183','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1226,'XYZ-1766074909611-553D1CD5',5,NULL,'IN_STOCK','GRN','XYZ577058526','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1227,'XYZ-1766074909634-BBC32F0D',5,NULL,'IN_STOCK','GRN','XYZ477846136','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1228,'XYZ-1766074909661-37BE8FB5',5,NULL,'IN_STOCK','GRN','XYZ154899216','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1229,'XYZ-1766074909684-FF3EEE90',5,NULL,'IN_STOCK','GRN','XYZ214169194','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1230,'XYZ-1766074909711-21A5FD48',5,NULL,'IN_STOCK','GRN','XYZ276183526','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1231,'XYZ-1766074909739-426E6240',5,NULL,'IN_STOCK','GRN','XYZ639139393','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1232,'XYZ-1766074909765-05AEDDC9',5,NULL,'IN_STOCK','GRN','XYZ571070964','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1233,'XYZ-1766074909790-3EDA0CDB',5,NULL,'IN_STOCK','GRN','XYZ656267356','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1234,'XYZ-1766074909814-5CEE8108',5,NULL,'IN_STOCK','GRN','XYZ446470890','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1235,'XYZ-1766074909837-066D53AB',5,NULL,'IN_STOCK','GRN','XYZ031611659','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1236,'XYZ-1766074909857-F0B2F890',5,NULL,'IN_STOCK','GRN','XYZ889784049','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1237,'XYZ-1766074909877-B17A388A',5,NULL,'IN_STOCK','GRN','XYZ422401014','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1238,'XYZ-1766074909897-DB6AC545',5,NULL,'IN_STOCK','GRN','XYZ073642565','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1239,'XYZ-1766074909917-3E408408',5,NULL,'IN_STOCK','GRN','XYZ977338018','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1240,'XYZ-1766074909936-9DC6E20D',5,NULL,'IN_STOCK','GRN','XYZ579602657','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1241,'XYZ-1766074909955-AD2A214A',5,NULL,'IN_STOCK','GRN','XYZ551779971','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1242,'XYZ-1766074909976-45C718E0',5,NULL,'IN_STOCK','GRN','XYZ656393610','2025-12-18 16:21:49','2025-12-18 16:21:49'),(1243,'XYZ-1766074909995-4BC771F1',5,NULL,'IN_STOCK','GRN','XYZ009226698','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1244,'XYZ-1766074910014-318E55FC',5,NULL,'IN_STOCK','GRN','XYZ797445344','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1245,'XYZ-1766074910034-5938AD9E',5,NULL,'IN_STOCK','GRN','XYZ944647937','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1246,'XYZ-1766074910054-C319C43D',5,NULL,'IN_STOCK','GRN','XYZ331214357','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1247,'XYZ-1766074910075-2A1B5BEE',5,NULL,'IN_STOCK','GRN','XYZ619193343','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1248,'XYZ-1766074910103-3F3E7CE6',5,NULL,'IN_STOCK','GRN','XYZ720069920','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1249,'XYZ-1766074910131-DE437FDC',5,NULL,'IN_STOCK','GRN','XYZ291962422','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1250,'XYZ-1766074910158-7D9322ED',5,NULL,'IN_STOCK','GRN','XYZ913085115','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1251,'XYZ-1766074910186-388F4D79',5,NULL,'IN_STOCK','GRN','XYZ480291348','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1252,'XYZ-1766074910213-9B8D9BFD',5,NULL,'IN_STOCK','GRN','XYZ303788646','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1253,'XYZ-1766074910241-2AF8C389',5,NULL,'IN_STOCK','GRN','XYZ645035930','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1254,'XYZ-1766074910268-265C1BA9',5,NULL,'IN_STOCK','GRN','XYZ387269085','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1255,'XYZ-1766074910293-7AF2FA2A',5,NULL,'IN_STOCK','GRN','XYZ760895254','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1256,'XYZ-1766074910316-E2949F02',5,NULL,'IN_STOCK','GRN','XYZ525287050','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1257,'XYZ-1766074910344-A2F19016',5,NULL,'IN_STOCK','GRN','XYZ689192051','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1258,'XYZ-1766074910369-8D512F72',5,NULL,'IN_STOCK','GRN','XYZ272845441','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1259,'XYZ-1766074910395-3829D158',5,NULL,'IN_STOCK','GRN','XYZ444557132','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1260,'XYZ-1766074910420-FEB8E612',5,NULL,'IN_STOCK','GRN','XYZ481507219','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1261,'XYZ-1766074910448-2C18574B',5,NULL,'IN_STOCK','GRN','XYZ903374425','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1262,'XYZ-1766074910475-D33B14FF',5,NULL,'IN_STOCK','GRN','XYZ273960334','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1263,'XYZ-1766074910502-B198CB98',5,NULL,'IN_STOCK','GRN','XYZ751393601','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1264,'XYZ-1766074910526-A4CDE8CE',5,NULL,'IN_STOCK','GRN','XYZ767614634','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1265,'XYZ-1766074910552-8C6C7B71',5,NULL,'IN_STOCK','GRN','XYZ496460256','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1266,'XYZ-1766074910579-DF620296',5,NULL,'IN_STOCK','GRN','XYZ219876469','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1267,'XYZ-1766074910606-7A773875',5,NULL,'IN_STOCK','GRN','XYZ627578962','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1268,'XYZ-1766074910635-2CE99950',5,NULL,'IN_STOCK','GRN','XYZ458408466','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1269,'XYZ-1766074910662-8B170F84',5,NULL,'IN_STOCK','GRN','XYZ818564774','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1270,'XYZ-1766074910690-B31C335B',5,NULL,'IN_STOCK','GRN','XYZ314844841','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1271,'XYZ-1766074910717-1DC8CCAD',5,NULL,'IN_STOCK','GRN','XYZ060923046','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1272,'XYZ-1766074910745-2D42FA70',5,NULL,'IN_STOCK','GRN','XYZ281442533','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1273,'XYZ-1766074910772-C4B10770',5,NULL,'IN_STOCK','GRN','XYZ174392034','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1274,'XYZ-1766074910799-6358109B',5,NULL,'IN_STOCK','GRN','XYZ153480322','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1275,'XYZ-1766074910827-E515D5BF',5,NULL,'IN_STOCK','GRN','XYZ987703557','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1276,'XYZ-1766074910855-9BFBE998',5,NULL,'IN_STOCK','GRN','XYZ291444488','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1277,'XYZ-1766074910881-65E57C6E',5,NULL,'IN_STOCK','GRN','XYZ720883853','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1278,'XYZ-1766074910905-AE9FC8AF',5,NULL,'IN_STOCK','GRN','XYZ121468892','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1279,'XYZ-1766074910932-9061B99A',5,NULL,'IN_STOCK','GRN','XYZ841230087','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1280,'XYZ-1766074910957-0970651E',5,NULL,'IN_STOCK','GRN','XYZ547791512','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1281,'XYZ-1766074910984-36500CCF',5,NULL,'IN_STOCK','GRN','XYZ167829804','2025-12-18 16:21:50','2025-12-18 16:21:50'),(1282,'XYZ-1766074911011-B347386D',5,NULL,'IN_STOCK','GRN','XYZ696899542','2025-12-18 16:21:51','2025-12-18 16:21:51'),(1283,'XYZ-1766074911039-98D6257C',5,NULL,'IN_STOCK','GRN','XYZ750959795','2025-12-18 16:21:51','2025-12-18 16:21:51'),(1284,'XYZ-1766074911068-E1AC3F70',5,NULL,'IN_STOCK','GRN','XYZ182297273','2025-12-18 16:21:51','2025-12-18 16:21:51'),(1285,'XYZ-1766074911091-7CC083F8',5,NULL,'IN_STOCK','GRN','XYZ419753256','2025-12-18 16:21:51','2025-12-18 16:21:51'),(1286,'XYZ-1766074911120-1800F864',5,NULL,'IN_STOCK','GRN','XYZ545836067','2025-12-18 16:21:51','2025-12-18 16:21:51'),(1287,'XYZ-1766074911146-C55D6F51',5,NULL,'IN_STOCK','GRN','XYZ089358921','2025-12-18 16:21:51','2025-12-18 16:21:51'),(1288,'XYZ-1766074911174-92E3C366',5,NULL,'IN_STOCK','GRN','XYZ504845394','2025-12-18 16:21:51','2025-12-18 16:21:51'),(1289,'XYZ-1766074911195-D8F82E58',5,NULL,'IN_STOCK','GRN','XYZ945507573','2025-12-18 16:21:51','2025-12-18 16:21:51'),(1290,'XYZ-1766074911222-B99591F7',5,NULL,'IN_STOCK','GRN','XYZ650605539','2025-12-18 16:21:51','2025-12-18 16:21:51'),(1291,'XYZ-1766074911248-23E74526',5,NULL,'IN_STOCK','GRN','XYZ611178014','2025-12-18 16:21:51','2025-12-18 16:21:51'),(1292,'XYZ-1766074911276-1CFE5051',5,NULL,'IN_STOCK','GRN','XYZ072285313','2025-12-18 16:21:51','2025-12-18 16:21:51'),(1293,'XYZ-1766074911303-628ACFD9',5,NULL,'IN_STOCK','GRN','XYZ396523942','2025-12-18 16:21:51','2025-12-18 16:21:51'),(1294,'XYZ-1766074911331-72B99018',5,NULL,'IN_STOCK','GRN','XYZ971655554','2025-12-18 16:21:51','2025-12-18 16:21:51'),(1295,'XYZ-1766074911359-7D7E616B',5,NULL,'IN_STOCK','GRN','XYZ064386075','2025-12-18 16:21:51','2025-12-18 16:21:51'),(1296,'XYZ-1766074911386-1EA11D71',5,NULL,'IN_STOCK','GRN','XYZ205178005','2025-12-18 16:21:51','2025-12-18 16:21:51'),(1297,'XYZ-1766074911414-D4FAF7B1',5,NULL,'IN_STOCK','GRN','XYZ589145743','2025-12-18 16:21:51','2025-12-18 16:21:51'),(1298,'XYZ-1766074911441-4E24AB8C',5,NULL,'IN_STOCK','GRN','XYZ056906422','2025-12-18 16:21:51','2025-12-18 16:21:51'),(1299,'XYZ-1766074911470-6D7A9254',5,NULL,'IN_STOCK','GRN','XYZ272747023','2025-12-18 16:21:51','2025-12-18 16:21:51'),(1300,'XYZ-1766074911500-90543956',5,NULL,'IN_STOCK','GRN','XYZ790231407','2025-12-18 16:21:51','2025-12-18 16:21:51'),(1301,'XYZ-1767592386046-46D49CE4',4,NULL,'IN_STOCK','GRN','XYZ355389448','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1302,'XYZ-1767592386136-9B72FD30',4,NULL,'IN_STOCK','GRN','XYZ309424327','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1303,'XYZ-1767592386174-49A548DE',4,NULL,'IN_STOCK','GRN','XYZ053835045','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1304,'XYZ-1767592386206-69EB03A0',4,NULL,'IN_STOCK','GRN','XYZ184649518','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1305,'XYZ-1767592386255-F4F1AEB7',4,NULL,'IN_STOCK','GRN','XYZ333299335','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1306,'XYZ-1767592386286-B44A314E',4,NULL,'IN_STOCK','GRN','XYZ119712518','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1307,'XYZ-1767592386317-0C5B0808',4,NULL,'IN_STOCK','GRN','XYZ083311601','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1308,'XYZ-1767592386349-6A365E44',4,NULL,'IN_STOCK','GRN','XYZ254272972','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1309,'XYZ-1767592386381-CE34BE72',4,NULL,'IN_STOCK','GRN','XYZ286552323','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1310,'XYZ-1767592386414-CD8C961C',4,NULL,'IN_STOCK','GRN','XYZ734093749','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1311,'XYZ-1767592386445-8206747D',4,NULL,'IN_STOCK','GRN','XYZ027648563','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1312,'XYZ-1767592386475-2B47A29D',4,NULL,'IN_STOCK','GRN','XYZ118548945','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1313,'XYZ-1767592386505-96F3C127',4,NULL,'IN_STOCK','GRN','XYZ187332655','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1314,'XYZ-1767592386533-01EFA69B',4,NULL,'IN_STOCK','GRN','XYZ115554710','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1315,'XYZ-1767592386559-32223D46',4,NULL,'IN_STOCK','GRN','XYZ887373187','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1316,'XYZ-1767592386588-ACA06221',4,NULL,'IN_STOCK','GRN','XYZ684578099','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1317,'XYZ-1767592386614-B8187CD2',4,NULL,'IN_STOCK','GRN','XYZ335494768','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1318,'XYZ-1767592386643-BC31DACD',4,NULL,'IN_STOCK','GRN','XYZ782500409','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1319,'XYZ-1767592386672-1BC179F7',4,NULL,'IN_STOCK','GRN','XYZ015245153','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1320,'XYZ-1767592386702-901BAF23',4,NULL,'IN_STOCK','GRN','XYZ497347200','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1321,'XYZ-1767592386730-0244C54B',4,NULL,'IN_STOCK','GRN','XYZ070166757','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1322,'XYZ-1767592386755-23EA5804',4,NULL,'IN_STOCK','GRN','XYZ003952793','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1323,'XYZ-1767592386783-B3BCEDD0',4,NULL,'IN_STOCK','GRN','XYZ486813953','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1324,'XYZ-1767592386811-22ABEE22',4,NULL,'IN_STOCK','GRN','XYZ923391767','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1325,'XYZ-1767592386837-237C4E65',4,NULL,'IN_STOCK','GRN','XYZ364377594','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1326,'XYZ-1767592386863-8D79CF36',4,NULL,'IN_STOCK','GRN','XYZ418810945','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1327,'XYZ-1767592386893-2638D788',4,NULL,'IN_STOCK','GRN','XYZ754621620','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1328,'XYZ-1767592386923-3257CE4C',4,NULL,'IN_STOCK','GRN','XYZ440456730','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1329,'XYZ-1767592386949-3033A96C',4,NULL,'IN_STOCK','GRN','XYZ729880934','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1330,'XYZ-1767592386979-C28671C0',4,NULL,'IN_STOCK','GRN','XYZ193997619','2026-01-05 05:53:06','2026-01-05 05:53:06'),(1331,'XYZ-1767592387013-3F1AABC6',4,NULL,'IN_STOCK','GRN','XYZ830113217','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1332,'XYZ-1767592387042-9E31E2A9',4,NULL,'IN_STOCK','GRN','XYZ119430063','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1333,'XYZ-1767592387070-6A79B39C',4,NULL,'IN_STOCK','GRN','XYZ030256963','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1334,'XYZ-1767592387096-A08AC758',4,NULL,'IN_STOCK','GRN','XYZ272947116','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1335,'XYZ-1767592387123-9E58F23E',4,NULL,'IN_STOCK','GRN','XYZ186204246','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1336,'XYZ-1767592387148-91F76788',4,NULL,'IN_STOCK','GRN','XYZ749004701','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1337,'XYZ-1767592387177-0EC094E7',4,NULL,'IN_STOCK','GRN','XYZ828139217','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1338,'XYZ-1767592387203-113CF6B1',4,NULL,'IN_STOCK','GRN','XYZ263206381','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1339,'XYZ-1767592387228-D917BABB',4,NULL,'IN_STOCK','GRN','XYZ343997813','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1340,'XYZ-1767592387255-6DC7FAF8',4,NULL,'IN_STOCK','GRN','XYZ945321549','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1341,'XYZ-1767592387281-B2C556CC',4,NULL,'IN_STOCK','GRN','XYZ869416052','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1342,'XYZ-1767592387309-96C1F568',4,NULL,'IN_STOCK','GRN','XYZ943324550','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1343,'XYZ-1767592387339-60EDDEA2',4,NULL,'IN_STOCK','GRN','XYZ520469029','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1344,'XYZ-1767592387370-AE66BE07',4,NULL,'IN_STOCK','GRN','XYZ151211658','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1345,'XYZ-1767592387402-2AB03DDB',4,NULL,'IN_STOCK','GRN','XYZ151385488','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1346,'XYZ-1767592387433-DBF8450A',4,NULL,'IN_STOCK','GRN','XYZ838845472','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1347,'XYZ-1767592387459-50E91DEC',4,NULL,'IN_STOCK','GRN','XYZ716866884','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1348,'XYZ-1767592387484-9AB2A459',4,NULL,'IN_STOCK','GRN','XYZ603346107','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1349,'XYZ-1767592387512-08C48708',4,NULL,'IN_STOCK','GRN','XYZ104889776','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1350,'XYZ-1767592387537-76FBBDE9',4,NULL,'IN_STOCK','GRN','XYZ442243926','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1351,'XYZ-1767592387562-7102CFFD',4,NULL,'IN_STOCK','GRN','XYZ122589046','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1352,'XYZ-1767592387587-CFE53CB9',4,NULL,'IN_STOCK','GRN','XYZ051787541','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1353,'XYZ-1767592387612-E52DCE66',4,NULL,'IN_STOCK','GRN','XYZ108784322','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1354,'XYZ-1767592387636-0800694A',4,NULL,'IN_STOCK','GRN','XYZ444937515','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1355,'XYZ-1767592387662-C1C344DA',4,NULL,'IN_STOCK','GRN','XYZ723657229','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1356,'XYZ-1767592387689-E621C467',4,NULL,'IN_STOCK','GRN','XYZ936694282','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1357,'XYZ-1767592387716-AFCD347C',4,NULL,'IN_STOCK','GRN','XYZ477881094','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1358,'XYZ-1767592387745-50FF99D6',4,NULL,'IN_STOCK','GRN','XYZ460981832','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1359,'XYZ-1767592387775-247CFA00',4,NULL,'IN_STOCK','GRN','XYZ419370818','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1360,'XYZ-1767592387803-57C63111',4,NULL,'IN_STOCK','GRN','XYZ221671506','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1361,'XYZ-1767592387832-799BD17C',4,NULL,'IN_STOCK','GRN','XYZ066889031','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1362,'XYZ-1767592387863-0195E51E',4,NULL,'IN_STOCK','GRN','XYZ976809004','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1363,'XYZ-1767592387893-62C86139',4,NULL,'IN_STOCK','GRN','XYZ523052505','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1364,'XYZ-1767592387923-765DEF1F',4,NULL,'IN_STOCK','GRN','XYZ945224708','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1365,'XYZ-1767592387948-0137C535',4,NULL,'IN_STOCK','GRN','XYZ403086432','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1366,'XYZ-1767592387974-FDD8B6F7',4,NULL,'IN_STOCK','GRN','XYZ622635965','2026-01-05 05:53:07','2026-01-05 05:53:07'),(1367,'XYZ-1767592387999-47CBFE2E',4,NULL,'IN_STOCK','GRN','XYZ009834883','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1368,'XYZ-1767592388027-977C41C3',4,NULL,'IN_STOCK','GRN','XYZ574771887','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1369,'XYZ-1767592388053-EC20BE42',4,NULL,'IN_STOCK','GRN','XYZ912053164','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1370,'XYZ-1767592388082-4D7B7F59',4,NULL,'IN_STOCK','GRN','XYZ703126765','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1371,'XYZ-1767592388110-100DCC66',4,NULL,'IN_STOCK','GRN','XYZ473716633','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1372,'XYZ-1767592388138-9DD04C68',4,NULL,'IN_STOCK','GRN','XYZ467717973','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1373,'XYZ-1767592388168-6494F235',4,NULL,'IN_STOCK','GRN','XYZ741123044','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1374,'XYZ-1767592388194-1793299B',4,NULL,'IN_STOCK','GRN','XYZ950135019','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1375,'XYZ-1767592388225-097CCAD0',4,NULL,'IN_STOCK','GRN','XYZ880662761','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1376,'XYZ-1767592388252-AB50C891',4,NULL,'IN_STOCK','GRN','XYZ670256939','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1377,'XYZ-1767592388278-A0CE26C5',4,NULL,'IN_STOCK','GRN','XYZ148945382','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1378,'XYZ-1767592388307-736631B7',4,NULL,'IN_STOCK','GRN','XYZ953008948','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1379,'XYZ-1767592388336-95EA78D7',4,NULL,'IN_STOCK','GRN','XYZ364703003','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1380,'XYZ-1767592388365-F5D20CD6',4,NULL,'IN_STOCK','GRN','XYZ070883123','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1381,'XYZ-1767592388392-0CB6BBF6',4,NULL,'IN_STOCK','GRN','XYZ987860167','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1382,'XYZ-1767592388418-76820A7A',4,NULL,'IN_STOCK','GRN','XYZ735952058','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1383,'XYZ-1767592388446-EB5B0D6F',4,NULL,'IN_STOCK','GRN','XYZ036918316','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1384,'XYZ-1767592388475-A7024EFF',4,NULL,'IN_STOCK','GRN','XYZ965159566','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1385,'XYZ-1767592388504-1ECC2F3F',4,NULL,'IN_STOCK','GRN','XYZ905273926','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1386,'XYZ-1767592388531-453366B2',4,NULL,'IN_STOCK','GRN','XYZ958473074','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1387,'XYZ-1767592388560-9371BE1B',4,NULL,'IN_STOCK','GRN','XYZ812265499','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1388,'XYZ-1767592388588-86A8E8FE',4,NULL,'IN_STOCK','GRN','XYZ057491445','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1389,'XYZ-1767592388615-1E02C507',4,NULL,'IN_STOCK','GRN','XYZ125480279','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1390,'XYZ-1767592388640-DEB4CF26',4,NULL,'IN_STOCK','GRN','XYZ957184297','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1391,'XYZ-1767592388667-2544581B',4,NULL,'IN_STOCK','GRN','XYZ438067751','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1392,'XYZ-1767592388695-3A988390',4,NULL,'IN_STOCK','GRN','XYZ361976724','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1393,'XYZ-1767592388724-EBC6A31B',4,NULL,'IN_STOCK','GRN','XYZ467236084','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1394,'XYZ-1767592388750-BAC4622A',4,NULL,'IN_STOCK','GRN','XYZ438388747','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1395,'XYZ-1767592388780-1E444378',4,NULL,'IN_STOCK','GRN','XYZ964970223','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1396,'XYZ-1767592388812-26462F15',4,NULL,'IN_STOCK','GRN','XYZ119722318','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1397,'XYZ-1767592388839-34EEE173',4,NULL,'IN_STOCK','GRN','XYZ707492275','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1398,'XYZ-1767592388870-303936DD',4,NULL,'IN_STOCK','GRN','XYZ148488706','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1399,'XYZ-1767592388897-3C565076',4,NULL,'IN_STOCK','GRN','XYZ489402166','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1400,'XYZ-1767592388934-8B9B849D',4,NULL,'IN_STOCK','GRN','XYZ269806160','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1401,'XYZ-1767592388964-54C7EDDE',4,NULL,'IN_STOCK','GRN','XYZ331875613','2026-01-05 05:53:08','2026-01-05 05:53:08'),(1402,'XYZ-1767592388994-124EDA1B',4,NULL,'IN_STOCK','GRN','XYZ600229207','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1403,'XYZ-1767592389022-E5F72855',4,NULL,'IN_STOCK','GRN','XYZ694069443','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1404,'XYZ-1767592389053-53310628',4,NULL,'IN_STOCK','GRN','XYZ825626490','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1405,'XYZ-1767592389090-80E6D9F7',4,NULL,'IN_STOCK','GRN','XYZ780359225','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1406,'XYZ-1767592389118-4AB7C621',4,NULL,'IN_STOCK','GRN','XYZ144267223','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1407,'XYZ-1767592389146-C1966D8B',4,NULL,'IN_STOCK','GRN','XYZ532427241','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1408,'XYZ-1767592389174-C44CD57B',4,NULL,'IN_STOCK','GRN','XYZ476044396','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1409,'XYZ-1767592389202-69D27E7E',4,NULL,'IN_STOCK','GRN','XYZ392433951','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1410,'XYZ-1767592389229-8CC476CF',4,NULL,'IN_STOCK','GRN','XYZ576432890','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1411,'XYZ-1767592389256-9FEE7905',4,NULL,'IN_STOCK','GRN','XYZ293647615','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1412,'XYZ-1767592389280-ECD6AB7B',4,NULL,'IN_STOCK','GRN','XYZ789597281','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1413,'XYZ-1767592389311-E2168CCA',4,NULL,'IN_STOCK','GRN','XYZ789912974','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1414,'XYZ-1767592389337-22069E8A',4,NULL,'IN_STOCK','GRN','XYZ273535641','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1415,'XYZ-1767592389363-9BE14819',4,NULL,'IN_STOCK','GRN','XYZ697773843','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1416,'XYZ-1767592389388-B7D9BD8D',4,NULL,'IN_STOCK','GRN','XYZ627312937','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1417,'XYZ-1767592389411-1EB69D8E',4,NULL,'IN_STOCK','GRN','XYZ305146021','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1418,'XYZ-1767592389438-5BC20B97',4,NULL,'IN_STOCK','GRN','XYZ823031334','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1419,'XYZ-1767592389467-D2D2847E',4,NULL,'IN_STOCK','GRN','XYZ302194573','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1420,'XYZ-1767592389498-B057A08C',4,NULL,'IN_STOCK','GRN','XYZ573990827','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1421,'XYZ-1767592389530-15EE2B15',4,NULL,'IN_STOCK','GRN','XYZ108918042','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1422,'XYZ-1767592389559-EDF71DFC',4,NULL,'IN_STOCK','GRN','XYZ572873843','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1423,'XYZ-1767592389591-A56D20D0',4,NULL,'IN_STOCK','GRN','XYZ564556610','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1424,'XYZ-1767592389619-D94B4CF2',4,NULL,'IN_STOCK','GRN','XYZ361431350','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1425,'XYZ-1767592389646-994410B7',4,NULL,'IN_STOCK','GRN','XYZ796132827','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1426,'XYZ-1767592389672-AB50650A',4,NULL,'IN_STOCK','GRN','XYZ128642048','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1427,'XYZ-1767592389700-E289D80C',4,NULL,'IN_STOCK','GRN','XYZ915401340','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1428,'XYZ-1767592389729-0F090F59',4,NULL,'IN_STOCK','GRN','XYZ697090324','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1429,'XYZ-1767592389757-C6E0485E',4,NULL,'IN_STOCK','GRN','XYZ907531582','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1430,'XYZ-1767592389786-21383CAE',4,NULL,'IN_STOCK','GRN','XYZ386518028','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1431,'XYZ-1767592389815-968AA173',4,NULL,'IN_STOCK','GRN','XYZ727135323','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1432,'XYZ-1767592389844-8208F4E4',4,NULL,'IN_STOCK','GRN','XYZ602012307','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1433,'XYZ-1767592389874-402C18E7',4,NULL,'IN_STOCK','GRN','XYZ367902218','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1434,'XYZ-1767592389899-FD79519E',4,NULL,'IN_STOCK','GRN','XYZ076743822','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1435,'XYZ-1767592389925-E1682E4C',4,NULL,'IN_STOCK','GRN','XYZ525421356','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1436,'XYZ-1767592389949-12C71428',4,NULL,'IN_STOCK','GRN','XYZ403593891','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1437,'XYZ-1767592389975-92783FCC',4,NULL,'IN_STOCK','GRN','XYZ592641170','2026-01-05 05:53:09','2026-01-05 05:53:09'),(1438,'XYZ-1767592389999-A58604F8',4,NULL,'IN_STOCK','GRN','XYZ268431270','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1439,'XYZ-1767592390025-21B20547',4,NULL,'IN_STOCK','GRN','XYZ775540242','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1440,'XYZ-1767592390055-50E2AA83',4,NULL,'IN_STOCK','GRN','XYZ961448127','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1441,'XYZ-1767592390085-EDEF5B33',4,NULL,'IN_STOCK','GRN','XYZ032263663','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1442,'XYZ-1767592390115-BE7DD5D9',4,NULL,'IN_STOCK','GRN','XYZ665456691','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1443,'XYZ-1767592390146-03C17BE5',4,NULL,'IN_STOCK','GRN','XYZ670589570','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1444,'XYZ-1767592390176-E233478C',4,NULL,'IN_STOCK','GRN','XYZ333238879','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1445,'XYZ-1767592390205-F015C4B6',4,NULL,'IN_STOCK','GRN','XYZ422970840','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1446,'XYZ-1767592390234-DC48AB4D',4,NULL,'IN_STOCK','GRN','XYZ832640161','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1447,'XYZ-1767592390264-048FF062',4,NULL,'IN_STOCK','GRN','XYZ929657856','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1448,'XYZ-1767592390294-5E9A1285',4,NULL,'IN_STOCK','GRN','XYZ566106278','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1449,'XYZ-1767592390323-821C7EF2',4,NULL,'IN_STOCK','GRN','XYZ477405432','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1450,'XYZ-1767592390345-11B31047',4,NULL,'IN_STOCK','GRN','XYZ182247849','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1451,'XYZ-1767592390370-70854E87',4,NULL,'IN_STOCK','GRN','XYZ874562805','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1452,'XYZ-1767592390394-3CF199E3',4,NULL,'IN_STOCK','GRN','XYZ674466296','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1453,'XYZ-1767592390415-C93FB0FC',4,NULL,'IN_STOCK','GRN','XYZ068340228','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1454,'XYZ-1767592390437-13E89965',4,NULL,'IN_STOCK','GRN','XYZ236537278','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1455,'XYZ-1767592390459-ED9A9C02',4,NULL,'IN_STOCK','GRN','XYZ316645442','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1456,'XYZ-1767592390479-AF5F6825',4,NULL,'IN_STOCK','GRN','XYZ858271087','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1457,'XYZ-1767592390499-30E24EE2',4,NULL,'IN_STOCK','GRN','XYZ676566857','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1458,'XYZ-1767592390521-165C5B0A',4,NULL,'IN_STOCK','GRN','XYZ650305249','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1459,'XYZ-1767592390546-E669FA9B',4,NULL,'IN_STOCK','GRN','XYZ570480298','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1460,'XYZ-1767592390574-CA4ADE0D',4,NULL,'IN_STOCK','GRN','XYZ167024149','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1461,'XYZ-1767592390597-A04EA160',4,NULL,'IN_STOCK','GRN','XYZ358178840','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1462,'XYZ-1767592390619-3CCFA717',4,NULL,'IN_STOCK','GRN','XYZ972780648','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1463,'XYZ-1767592390641-CFB48BCF',4,NULL,'IN_STOCK','GRN','XYZ929889237','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1464,'XYZ-1767592390663-7F84092C',4,NULL,'IN_STOCK','GRN','XYZ128482248','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1465,'XYZ-1767592390687-C9951EA9',4,NULL,'IN_STOCK','GRN','XYZ564521475','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1466,'XYZ-1767592390712-E0F1CBD7',4,NULL,'IN_STOCK','GRN','XYZ166063023','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1467,'XYZ-1767592390739-6887BE6C',4,NULL,'IN_STOCK','GRN','XYZ183981130','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1468,'XYZ-1767592390764-3FFA8E55',4,NULL,'IN_STOCK','GRN','XYZ343726196','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1469,'XYZ-1767592390794-328F714A',4,NULL,'IN_STOCK','GRN','XYZ494480970','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1470,'XYZ-1767592390820-47549340',4,NULL,'IN_STOCK','GRN','XYZ468632265','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1471,'XYZ-1767592390846-7FB19DB4',4,NULL,'IN_STOCK','GRN','XYZ273007309','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1472,'XYZ-1767592390875-53D410A4',4,NULL,'IN_STOCK','GRN','XYZ281315264','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1473,'XYZ-1767592390904-87DAB454',4,NULL,'IN_STOCK','GRN','XYZ124274262','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1474,'XYZ-1767592390935-2C4C1186',4,NULL,'IN_STOCK','GRN','XYZ796893788','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1475,'XYZ-1767592390963-2B41D58F',4,NULL,'IN_STOCK','GRN','XYZ372378295','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1476,'XYZ-1767592390986-69AFF6C3',4,NULL,'IN_STOCK','GRN','XYZ242028675','2026-01-05 05:53:10','2026-01-05 05:53:10'),(1477,'XYZ-1767592391013-39378A02',4,NULL,'IN_STOCK','GRN','XYZ418491010','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1478,'XYZ-1767592391036-2EFE3F24',4,NULL,'IN_STOCK','GRN','XYZ886149847','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1479,'XYZ-1767592391060-D03871BB',4,NULL,'IN_STOCK','GRN','XYZ963397204','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1480,'XYZ-1767592391087-0F19B841',4,NULL,'IN_STOCK','GRN','XYZ137268449','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1481,'XYZ-1767592391112-BD88DD1C',4,NULL,'IN_STOCK','GRN','XYZ560550373','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1482,'XYZ-1767592391138-81AD5147',4,NULL,'IN_STOCK','GRN','XYZ708132398','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1483,'XYZ-1767592391164-9176FA97',4,NULL,'IN_STOCK','GRN','XYZ582250557','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1484,'XYZ-1767592391189-3103E9CA',4,NULL,'IN_STOCK','GRN','XYZ128263831','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1485,'XYZ-1767592391217-13A694E5',4,NULL,'IN_STOCK','GRN','XYZ596113226','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1486,'XYZ-1767592391245-0B77137B',4,NULL,'IN_STOCK','GRN','XYZ563797969','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1487,'XYZ-1767592391272-FC59662D',4,NULL,'IN_STOCK','GRN','XYZ967369913','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1488,'XYZ-1767592391300-4A077955',4,NULL,'IN_STOCK','GRN','XYZ681136728','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1489,'XYZ-1767592391326-56E3DC3D',4,NULL,'IN_STOCK','GRN','XYZ040693568','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1490,'XYZ-1767592391350-4FCB68CB',4,NULL,'IN_STOCK','GRN','XYZ277214036','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1491,'XYZ-1767592391379-FE6B05E2',4,NULL,'IN_STOCK','GRN','XYZ433967964','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1492,'XYZ-1767592391408-40AE3E6E',4,NULL,'IN_STOCK','GRN','XYZ175501706','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1493,'XYZ-1767592391435-7B147F48',4,NULL,'IN_STOCK','GRN','XYZ823088355','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1494,'XYZ-1767592391462-B1669953',4,NULL,'IN_STOCK','GRN','XYZ685713448','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1495,'XYZ-1767592391488-69A1C1D9',4,NULL,'IN_STOCK','GRN','XYZ876241518','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1496,'XYZ-1767592391513-77DD2E96',4,NULL,'IN_STOCK','GRN','XYZ377149246','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1497,'XYZ-1767592391532-6F2D24CC',4,NULL,'IN_STOCK','GRN','XYZ956858689','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1498,'XYZ-1767592391560-1C73BBAD',4,NULL,'IN_STOCK','GRN','XYZ809599322','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1499,'XYZ-1767592391587-9628A141',4,NULL,'IN_STOCK','GRN','XYZ610373217','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1500,'XYZ-1767592391613-17ED0A78',4,NULL,'IN_STOCK','GRN','XYZ434249429','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1501,'XYZ-1767592391641-E87F15AA',4,NULL,'IN_STOCK','GRN','XYZ403666446','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1502,'XYZ-1767592391668-FB56D992',4,NULL,'IN_STOCK','GRN','XYZ441112693','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1503,'XYZ-1767592391696-C4C2D3C2',4,NULL,'IN_STOCK','GRN','XYZ146338248','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1504,'XYZ-1767592391725-0E1DBB83',4,NULL,'IN_STOCK','GRN','XYZ323677424','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1505,'XYZ-1767592391751-409793AC',4,NULL,'IN_STOCK','GRN','XYZ541685341','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1506,'XYZ-1767592391778-4DDCBAA6',4,NULL,'IN_STOCK','GRN','XYZ634696898','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1507,'XYZ-1767592391802-AA9AA9CA',4,NULL,'IN_STOCK','GRN','XYZ110713029','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1508,'XYZ-1767592391829-761EAAF5',4,NULL,'IN_STOCK','GRN','XYZ909489314','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1509,'XYZ-1767592391854-CC692969',4,NULL,'IN_STOCK','GRN','XYZ889442693','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1510,'XYZ-1767592391880-9406A1CC',4,NULL,'IN_STOCK','GRN','XYZ088737859','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1511,'XYZ-1767592391907-E9D0057D',4,NULL,'IN_STOCK','GRN','XYZ330458001','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1512,'XYZ-1767592391935-D4936367',4,NULL,'IN_STOCK','GRN','XYZ101288838','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1513,'XYZ-1767592391962-C23FBAF6',4,NULL,'IN_STOCK','GRN','XYZ349972496','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1514,'XYZ-1767592391985-58A4E25A',4,NULL,'IN_STOCK','GRN','XYZ582350115','2026-01-05 05:53:11','2026-01-05 05:53:11'),(1515,'XYZ-1767592392012-1378BAF6',4,NULL,'IN_STOCK','GRN','XYZ647448350','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1516,'XYZ-1767592392039-DF3BB70C',4,NULL,'IN_STOCK','GRN','XYZ933236106','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1517,'XYZ-1767592392067-793D1AA9',4,NULL,'IN_STOCK','GRN','XYZ850220987','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1518,'XYZ-1767592392097-1966B3CA',4,NULL,'IN_STOCK','GRN','XYZ723515338','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1519,'XYZ-1767592392122-E72BA495',4,NULL,'IN_STOCK','GRN','XYZ578493708','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1520,'XYZ-1767592392148-3386A378',4,NULL,'IN_STOCK','GRN','XYZ355395015','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1521,'XYZ-1767592392175-F61FE333',4,NULL,'IN_STOCK','GRN','XYZ910430926','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1522,'XYZ-1767592392202-491E688E',4,NULL,'IN_STOCK','GRN','XYZ585850971','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1523,'XYZ-1767592392228-AB7183EF',4,NULL,'IN_STOCK','GRN','XYZ776999917','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1524,'XYZ-1767592392252-2275A416',4,NULL,'IN_STOCK','GRN','XYZ395305539','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1525,'XYZ-1767592392280-056D126E',4,NULL,'IN_STOCK','GRN','XYZ305246225','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1526,'XYZ-1767592392308-A2200D9B',4,NULL,'IN_STOCK','GRN','XYZ911741228','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1527,'XYZ-1767592392335-B1CAA237',4,NULL,'IN_STOCK','GRN','XYZ416190600','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1528,'XYZ-1767592392365-40F87A06',4,NULL,'IN_STOCK','GRN','XYZ552375084','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1529,'XYZ-1767592392391-490E9596',4,NULL,'IN_STOCK','GRN','XYZ857636479','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1530,'XYZ-1767592392419-47134959',4,NULL,'IN_STOCK','GRN','XYZ135184819','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1531,'XYZ-1767592392446-DF32FCAE',4,NULL,'IN_STOCK','GRN','XYZ801603818','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1532,'XYZ-1767592392473-24CA72C5',4,NULL,'IN_STOCK','GRN','XYZ572563706','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1533,'XYZ-1767592392496-A00DF3E2',4,NULL,'IN_STOCK','GRN','XYZ154452618','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1534,'XYZ-1767592392523-8340EC19',4,NULL,'IN_STOCK','GRN','XYZ368993272','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1535,'XYZ-1767592392544-21966FB5',4,NULL,'IN_STOCK','GRN','XYZ389429819','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1536,'XYZ-1767592392570-329F2B22',4,NULL,'IN_STOCK','GRN','XYZ032445217','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1537,'XYZ-1767592392595-2ABD5A8F',4,NULL,'IN_STOCK','GRN','XYZ965754343','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1538,'XYZ-1767592392621-A351D974',4,NULL,'IN_STOCK','GRN','XYZ000920772','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1539,'XYZ-1767592392643-B4653E1C',4,NULL,'IN_STOCK','GRN','XYZ407808974','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1540,'XYZ-1767592392667-1C06EFD9',4,NULL,'IN_STOCK','GRN','XYZ895157522','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1541,'XYZ-1767592392689-AF4C7410',4,NULL,'IN_STOCK','GRN','XYZ944713650','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1542,'XYZ-1767592392711-DE43F83A',4,NULL,'IN_STOCK','GRN','XYZ953454360','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1543,'XYZ-1767592392736-AAA20149',4,NULL,'IN_STOCK','GRN','XYZ827780704','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1544,'XYZ-1767592392765-FE023C7A',4,NULL,'IN_STOCK','GRN','XYZ983368022','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1545,'XYZ-1767592392796-9407F845',4,NULL,'IN_STOCK','GRN','XYZ158964753','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1546,'XYZ-1767592392826-AAFD80FB',4,NULL,'IN_STOCK','GRN','XYZ945789948','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1547,'XYZ-1767592392850-872C13E4',4,NULL,'IN_STOCK','GRN','XYZ813964252','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1548,'XYZ-1767592392874-5C4663CC',4,NULL,'IN_STOCK','GRN','XYZ215781221','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1549,'XYZ-1767592392902-9A28D4FB',4,NULL,'IN_STOCK','GRN','XYZ483796907','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1550,'XYZ-1767592392928-50F8D91A',4,NULL,'IN_STOCK','GRN','XYZ073805018','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1551,'XYZ-1767592392954-0D1C71E4',4,NULL,'IN_STOCK','GRN','XYZ644238567','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1552,'XYZ-1767592392980-4E540AB9',4,NULL,'IN_STOCK','GRN','XYZ327256304','2026-01-05 05:53:12','2026-01-05 05:53:12'),(1553,'XYZ-1767592393004-B2EA2153',4,NULL,'IN_STOCK','GRN','XYZ844557122','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1554,'XYZ-1767592393030-81A426BD',4,NULL,'IN_STOCK','GRN','XYZ429117786','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1555,'XYZ-1767592393053-8EF1778F',4,NULL,'IN_STOCK','GRN','XYZ103938184','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1556,'XYZ-1767592393076-1DB9519F',4,NULL,'IN_STOCK','GRN','XYZ552919862','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1557,'XYZ-1767592393102-09E4A90B',4,NULL,'IN_STOCK','GRN','XYZ907340705','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1558,'XYZ-1767592393127-2785DD3A',4,NULL,'IN_STOCK','GRN','XYZ179280672','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1559,'XYZ-1767592393154-00A4BF56',4,NULL,'IN_STOCK','GRN','XYZ243623254','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1560,'XYZ-1767592393182-81AFF301',4,NULL,'IN_STOCK','GRN','XYZ527859160','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1561,'XYZ-1767592393208-C1BF50F7',4,NULL,'IN_STOCK','GRN','XYZ609595435','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1562,'XYZ-1767592393237-18EB3626',4,NULL,'IN_STOCK','GRN','XYZ985945928','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1563,'XYZ-1767592393264-919E5D52',4,NULL,'IN_STOCK','GRN','XYZ963965962','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1564,'XYZ-1767592393293-201738AC',4,NULL,'IN_STOCK','GRN','XYZ280168569','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1565,'XYZ-1767592393324-98A486CD',4,NULL,'IN_STOCK','GRN','XYZ810280143','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1566,'XYZ-1767592393349-BB180E3B',4,NULL,'IN_STOCK','GRN','XYZ405789725','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1567,'XYZ-1767592393376-9CECB3B3',4,NULL,'IN_STOCK','GRN','XYZ810486841','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1568,'XYZ-1767592393404-6616A676',4,NULL,'IN_STOCK','GRN','XYZ657492161','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1569,'XYZ-1767592393429-B04F0A7A',4,NULL,'IN_STOCK','GRN','XYZ410146124','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1570,'XYZ-1767592393457-9DF8476E',4,NULL,'IN_STOCK','GRN','XYZ927047989','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1571,'XYZ-1767592393483-6FE69C26',4,NULL,'IN_STOCK','GRN','XYZ023668112','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1572,'XYZ-1767592393507-7E0DA3E2',4,NULL,'IN_STOCK','GRN','XYZ940542472','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1573,'XYZ-1767592393536-F7A2EF7E',4,NULL,'IN_STOCK','GRN','XYZ237219904','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1574,'XYZ-1767592393563-129495AD',4,NULL,'IN_STOCK','GRN','XYZ784792067','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1575,'XYZ-1767592393591-3E5A6799',4,NULL,'IN_STOCK','GRN','XYZ969797974','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1576,'XYZ-1767592393615-E2471C37',4,NULL,'IN_STOCK','GRN','XYZ768646830','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1577,'XYZ-1767592393645-ECC07392',4,NULL,'IN_STOCK','GRN','XYZ465965425','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1578,'XYZ-1767592393670-733FC85B',4,NULL,'IN_STOCK','GRN','XYZ140627693','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1579,'XYZ-1767592393696-EBF5D192',4,NULL,'IN_STOCK','GRN','XYZ425754695','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1580,'XYZ-1767592393721-61B9BADA',4,NULL,'IN_STOCK','GRN','XYZ532523483','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1581,'XYZ-1767592393748-E11D3835',4,NULL,'IN_STOCK','GRN','XYZ273654179','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1582,'XYZ-1767592393773-8B7E8B86',4,NULL,'IN_STOCK','GRN','XYZ355591843','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1583,'XYZ-1767592393802-87577686',4,NULL,'IN_STOCK','GRN','XYZ228974718','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1584,'XYZ-1767592393826-FD62672E',4,NULL,'IN_STOCK','GRN','XYZ890267790','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1585,'XYZ-1767592393853-FA6E1C5A',4,NULL,'IN_STOCK','GRN','XYZ303933570','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1586,'XYZ-1767592393878-6D37B5F4',4,NULL,'IN_STOCK','GRN','XYZ820775328','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1587,'XYZ-1767592393905-EF8CB2B1',4,NULL,'IN_STOCK','GRN','XYZ956321527','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1588,'XYZ-1767592393929-02E1A485',4,NULL,'IN_STOCK','GRN','XYZ303497006','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1589,'XYZ-1767592393956-DF6542E3',4,NULL,'IN_STOCK','GRN','XYZ527034550','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1590,'XYZ-1767592393983-093C0403',4,NULL,'IN_STOCK','GRN','XYZ536777169','2026-01-05 05:53:13','2026-01-05 05:53:13'),(1591,'XYZ-1767592394008-7CDAEDF2',4,NULL,'IN_STOCK','GRN','XYZ657390553','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1592,'XYZ-1767592394036-E090CF47',4,NULL,'IN_STOCK','GRN','XYZ638316691','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1593,'XYZ-1767592394061-50D098CB',4,NULL,'IN_STOCK','GRN','XYZ156646387','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1594,'XYZ-1767592394085-23790E43',4,NULL,'IN_STOCK','GRN','XYZ733284972','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1595,'XYZ-1767592394110-08CD3F8A',4,NULL,'IN_STOCK','GRN','XYZ846598183','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1596,'XYZ-1767592394136-5DCACE9B',4,NULL,'IN_STOCK','GRN','XYZ706276994','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1597,'XYZ-1767592394158-5AB6CA17',4,NULL,'IN_STOCK','GRN','XYZ886223144','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1598,'XYZ-1767592394179-D4B96184',4,NULL,'IN_STOCK','GRN','XYZ953536824','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1599,'XYZ-1767592394208-B75B4134',4,NULL,'IN_STOCK','GRN','XYZ892824524','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1600,'XYZ-1767592394232-10EF405F',4,NULL,'IN_STOCK','GRN','XYZ674857584','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1601,'XYZ-1767592394264-CFAD7019',5,NULL,'IN_STOCK','GRN','XYZ022808945','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1602,'XYZ-1767592394289-B49C973E',5,NULL,'IN_STOCK','GRN','XYZ152869290','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1603,'XYZ-1767592394312-02D53A4D',5,NULL,'IN_STOCK','GRN','XYZ933059310','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1604,'XYZ-1767592394338-AE8C64B3',5,NULL,'IN_STOCK','GRN','XYZ889559288','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1605,'XYZ-1767592394362-ECEB3B6A',5,NULL,'IN_STOCK','GRN','XYZ486077361','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1606,'XYZ-1767592394384-B3A7CAA2',5,NULL,'IN_STOCK','GRN','XYZ530240427','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1607,'XYZ-1767592394410-BFD3322A',5,NULL,'IN_STOCK','GRN','XYZ221487136','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1608,'XYZ-1767592394432-5680C596',5,NULL,'IN_STOCK','GRN','XYZ649127018','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1609,'XYZ-1767592394455-D677E86D',5,NULL,'IN_STOCK','GRN','XYZ985859797','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1610,'XYZ-1767592394477-AA1ED399',5,NULL,'IN_STOCK','GRN','XYZ614140126','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1611,'XYZ-1767592394498-4DD87AE2',5,NULL,'IN_STOCK','GRN','XYZ228351873','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1612,'XYZ-1767592394519-F61F3563',5,NULL,'IN_STOCK','GRN','XYZ247276019','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1613,'XYZ-1767592394544-BEB3667C',5,NULL,'IN_STOCK','GRN','XYZ895767316','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1614,'XYZ-1767592394572-F511E2EE',5,NULL,'IN_STOCK','GRN','XYZ431749308','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1615,'XYZ-1767592394599-ABA8A944',5,NULL,'IN_STOCK','GRN','XYZ754136716','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1616,'XYZ-1767592394627-0D4ECBD3',5,NULL,'IN_STOCK','GRN','XYZ266555415','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1617,'XYZ-1767592394655-04073580',5,NULL,'IN_STOCK','GRN','XYZ600643270','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1618,'XYZ-1767592394681-BF35B1C2',5,NULL,'IN_STOCK','GRN','XYZ576218283','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1619,'XYZ-1767592394709-DA6D4A0F',5,NULL,'IN_STOCK','GRN','XYZ826689106','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1620,'XYZ-1767592394735-F447F3C4',5,NULL,'IN_STOCK','GRN','XYZ110332889','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1621,'XYZ-1767592394762-3D73D560',5,NULL,'IN_STOCK','GRN','XYZ571984215','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1622,'XYZ-1767592394789-EEA3FAD0',5,NULL,'IN_STOCK','GRN','XYZ873996653','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1623,'XYZ-1767592394817-BE85FDB1',5,NULL,'IN_STOCK','GRN','XYZ927068427','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1624,'XYZ-1767592394843-843F204D',5,NULL,'IN_STOCK','GRN','XYZ322099730','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1625,'XYZ-1767592394870-5CCA5AC2',5,NULL,'IN_STOCK','GRN','XYZ764321385','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1626,'XYZ-1767592394898-71F1A9FA',5,NULL,'IN_STOCK','GRN','XYZ259361008','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1627,'XYZ-1767592394922-CDC5DC0B',5,NULL,'IN_STOCK','GRN','XYZ079141209','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1628,'XYZ-1767592394948-263E418B',5,NULL,'IN_STOCK','GRN','XYZ732506624','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1629,'XYZ-1767592394974-EC1AE33D',5,NULL,'IN_STOCK','GRN','XYZ182793319','2026-01-05 05:53:14','2026-01-05 05:53:14'),(1630,'XYZ-1767592394997-AC936C86',5,NULL,'IN_STOCK','GRN','XYZ601061588','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1631,'XYZ-1767592395020-9D1C6ADE',5,NULL,'IN_STOCK','GRN','XYZ885526458','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1632,'XYZ-1767592395042-8733198F',5,NULL,'IN_STOCK','GRN','XYZ636958699','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1633,'XYZ-1767592395066-D4D04200',5,NULL,'IN_STOCK','GRN','XYZ911081154','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1634,'XYZ-1767592395091-CF36C2B3',5,NULL,'IN_STOCK','GRN','XYZ153115204','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1635,'XYZ-1767592395116-9E0E1D5C',5,NULL,'IN_STOCK','GRN','XYZ054387303','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1636,'XYZ-1767592395142-F1922E84',5,NULL,'IN_STOCK','GRN','XYZ235762010','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1637,'XYZ-1767592395166-7784B939',5,NULL,'IN_STOCK','GRN','XYZ698496283','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1638,'XYZ-1767592395194-53532F9A',5,NULL,'IN_STOCK','GRN','XYZ640615842','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1639,'XYZ-1767592395221-B0D6CC32',5,NULL,'IN_STOCK','GRN','XYZ823440046','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1640,'XYZ-1767592395246-C5802BC2',5,NULL,'IN_STOCK','GRN','XYZ524360056','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1641,'XYZ-1767592395274-C484856E',5,NULL,'IN_STOCK','GRN','XYZ434074906','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1642,'XYZ-1767592395300-67CC97CC',5,NULL,'IN_STOCK','GRN','XYZ949848187','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1643,'XYZ-1767592395328-3A3853C7',5,NULL,'IN_STOCK','GRN','XYZ582113151','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1644,'XYZ-1767592395354-CC718AC0',5,NULL,'IN_STOCK','GRN','XYZ007298637','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1645,'XYZ-1767592395377-E0BB1825',5,NULL,'IN_STOCK','GRN','XYZ236519295','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1646,'XYZ-1767592395398-B500043B',5,NULL,'IN_STOCK','GRN','XYZ908117989','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1647,'XYZ-1767592395420-B0890805',5,NULL,'IN_STOCK','GRN','XYZ992931624','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1648,'XYZ-1767592395444-BED3A0DC',5,NULL,'IN_STOCK','GRN','XYZ747480828','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1649,'XYZ-1767592395465-8CDFC7C4',5,NULL,'IN_STOCK','GRN','XYZ973105993','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1650,'XYZ-1767592395486-9564816D',5,NULL,'IN_STOCK','GRN','XYZ036371506','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1651,'XYZ-1767592395511-37D78378',5,NULL,'IN_STOCK','GRN','XYZ261181080','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1652,'XYZ-1767592395537-C6009253',5,NULL,'IN_STOCK','GRN','XYZ684668409','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1653,'XYZ-1767592395564-172237E1',5,NULL,'IN_STOCK','GRN','XYZ940575494','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1654,'XYZ-1767592395588-A9806FAB',5,NULL,'IN_STOCK','GRN','XYZ432949446','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1655,'XYZ-1767592395615-9D94D982',5,NULL,'IN_STOCK','GRN','XYZ902468737','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1656,'XYZ-1767592395642-0FAF3045',5,NULL,'IN_STOCK','GRN','XYZ746678854','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1657,'XYZ-1767592395667-52ECD3CC',5,NULL,'IN_STOCK','GRN','XYZ629314181','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1658,'XYZ-1767592395693-BEF81306',5,NULL,'IN_STOCK','GRN','XYZ498070047','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1659,'XYZ-1767592395718-9314654B',5,NULL,'IN_STOCK','GRN','XYZ342444364','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1660,'XYZ-1767592395745-10F151A9',5,NULL,'IN_STOCK','GRN','XYZ616303528','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1661,'XYZ-1767592395773-1AD4E81B',5,NULL,'IN_STOCK','GRN','XYZ585793658','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1662,'XYZ-1767592395799-CD66A00A',5,NULL,'IN_STOCK','GRN','XYZ358078518','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1663,'XYZ-1767592395822-98512E64',5,NULL,'IN_STOCK','GRN','XYZ603116193','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1664,'XYZ-1767592395844-42B0B540',5,NULL,'IN_STOCK','GRN','XYZ246621369','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1665,'XYZ-1767592395867-EF6B3B3B',5,NULL,'IN_STOCK','GRN','XYZ026767330','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1666,'XYZ-1767592395889-204C1CC6',5,NULL,'IN_STOCK','GRN','XYZ661096759','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1667,'XYZ-1767592395915-8BF6943D',5,NULL,'IN_STOCK','GRN','XYZ302275286','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1668,'XYZ-1767592395940-84E57838',5,NULL,'IN_STOCK','GRN','XYZ636402282','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1669,'XYZ-1767592395964-5B3325E1',5,NULL,'IN_STOCK','GRN','XYZ203556282','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1670,'XYZ-1767592395990-60DD2A25',5,NULL,'IN_STOCK','GRN','XYZ706317202','2026-01-05 05:53:15','2026-01-05 05:53:15'),(1671,'XYZ-1767592396010-6407E4D4',5,NULL,'IN_STOCK','GRN','XYZ547845727','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1672,'XYZ-1767592396037-CC1C1334',5,NULL,'IN_STOCK','GRN','XYZ214428908','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1673,'XYZ-1767592396062-2C5ED53A',5,NULL,'IN_STOCK','GRN','XYZ420785882','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1674,'XYZ-1767592396085-EEB13BC8',5,NULL,'IN_STOCK','GRN','XYZ041742008','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1675,'XYZ-1767592396110-2B55E27B',5,NULL,'IN_STOCK','GRN','XYZ229226155','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1676,'XYZ-1767592396135-6C923137',5,NULL,'IN_STOCK','GRN','XYZ678395940','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1677,'XYZ-1767592396161-517A331A',5,NULL,'IN_STOCK','GRN','XYZ533535852','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1678,'XYZ-1767592396185-237A2A7B',5,NULL,'IN_STOCK','GRN','XYZ639501038','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1679,'XYZ-1767592396211-0D98C3E5',5,NULL,'IN_STOCK','GRN','XYZ165851236','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1680,'XYZ-1767592396238-8735A33B',5,NULL,'IN_STOCK','GRN','XYZ248070712','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1681,'XYZ-1767592396263-D6E17CE6',5,NULL,'IN_STOCK','GRN','XYZ102777781','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1682,'XYZ-1767592396292-E8009F24',5,NULL,'IN_STOCK','GRN','XYZ867854235','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1683,'XYZ-1767592396319-C7CAEF39',5,NULL,'IN_STOCK','GRN','XYZ014667603','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1684,'XYZ-1767592396344-5809A7CE',5,NULL,'IN_STOCK','GRN','XYZ403490749','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1685,'XYZ-1767592396367-4F79498A',5,NULL,'IN_STOCK','GRN','XYZ096745906','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1686,'XYZ-1767592396392-4484773B',5,NULL,'IN_STOCK','GRN','XYZ424848565','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1687,'XYZ-1767592396417-37605BE2',5,NULL,'IN_STOCK','GRN','XYZ754765356','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1688,'XYZ-1767592396442-82D0F288',5,NULL,'IN_STOCK','GRN','XYZ384661771','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1689,'XYZ-1767592396469-5796DC99',5,NULL,'IN_STOCK','GRN','XYZ418835852','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1690,'XYZ-1767592396494-DE00A8CA',5,NULL,'IN_STOCK','GRN','XYZ695852605','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1691,'XYZ-1767592396519-995CC518',5,NULL,'IN_STOCK','GRN','XYZ785043367','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1692,'XYZ-1767592396545-DC568516',5,NULL,'IN_STOCK','GRN','XYZ335228941','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1693,'XYZ-1767592396571-41C3CB2C',5,NULL,'IN_STOCK','GRN','XYZ493699775','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1694,'XYZ-1767592396597-909CBAD1',5,NULL,'IN_STOCK','GRN','XYZ770052424','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1695,'XYZ-1767592396620-94098989',5,NULL,'IN_STOCK','GRN','XYZ089700779','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1696,'XYZ-1767592396647-491F70A3',5,NULL,'IN_STOCK','GRN','XYZ918332603','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1697,'XYZ-1767592396671-9B302BD2',5,NULL,'IN_STOCK','GRN','XYZ483458700','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1698,'XYZ-1767592396698-AE3C57EF',5,NULL,'IN_STOCK','GRN','XYZ995038799','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1699,'XYZ-1767592396725-FDD6154E',5,NULL,'IN_STOCK','GRN','XYZ054674688','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1700,'XYZ-1767592396753-5A647933',5,NULL,'IN_STOCK','GRN','XYZ073391542','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1701,'XYZ-1767592396780-CA85075F',5,NULL,'IN_STOCK','GRN','XYZ410812671','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1702,'XYZ-1767592396806-0E4CDDF1',5,NULL,'IN_STOCK','GRN','XYZ821701963','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1703,'XYZ-1767592396834-E22C6031',5,NULL,'IN_STOCK','GRN','XYZ196410123','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1704,'XYZ-1767592396862-F0A21E9E',5,NULL,'IN_STOCK','GRN','XYZ074439758','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1705,'XYZ-1767592396888-2CA2F9C2',5,NULL,'IN_STOCK','GRN','XYZ493428036','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1706,'XYZ-1767592396915-DFF16A5F',5,NULL,'IN_STOCK','GRN','XYZ958701204','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1707,'XYZ-1767592396942-E363AF9C',5,NULL,'IN_STOCK','GRN','XYZ194994298','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1708,'XYZ-1767592396968-59981F9B',5,NULL,'IN_STOCK','GRN','XYZ013789984','2026-01-05 05:53:16','2026-01-05 05:53:16'),(1709,'XYZ-1767592396996-D918536F',5,NULL,'IN_STOCK','GRN','XYZ763737910','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1710,'XYZ-1767592397023-BA220B1A',5,NULL,'IN_STOCK','GRN','XYZ609116239','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1711,'XYZ-1767592397051-42C90FEF',5,NULL,'IN_STOCK','GRN','XYZ857236088','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1712,'XYZ-1767592397077-06CDD25C',5,NULL,'IN_STOCK','GRN','XYZ908139426','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1713,'XYZ-1767592397103-45B2BA16',5,NULL,'IN_STOCK','GRN','XYZ639619179','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1714,'XYZ-1767592397130-AB8E1921',5,NULL,'IN_STOCK','GRN','XYZ730654351','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1715,'XYZ-1767592397157-D46C9036',5,NULL,'IN_STOCK','GRN','XYZ439294744','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1716,'XYZ-1767592397184-165DF581',5,NULL,'IN_STOCK','GRN','XYZ428888398','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1717,'XYZ-1767592397210-8070C84D',5,NULL,'IN_STOCK','GRN','XYZ408272678','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1718,'XYZ-1767592397234-E4AE3F35',5,NULL,'IN_STOCK','GRN','XYZ022490859','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1719,'XYZ-1767592397261-293B7BCB',5,NULL,'IN_STOCK','GRN','XYZ415508631','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1720,'XYZ-1767592397288-20456C7B',5,NULL,'IN_STOCK','GRN','XYZ043548273','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1721,'XYZ-1767592397315-F0A2E5D5',5,NULL,'IN_STOCK','GRN','XYZ354466942','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1722,'XYZ-1767592397342-BA915015',5,NULL,'IN_STOCK','GRN','XYZ847430293','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1723,'XYZ-1767592397368-3CE9B110',5,NULL,'IN_STOCK','GRN','XYZ545158152','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1724,'XYZ-1767592397394-A1EBE5A5',5,NULL,'IN_STOCK','GRN','XYZ767917823','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1725,'XYZ-1767592397421-87138F0C',5,NULL,'IN_STOCK','GRN','XYZ906978804','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1726,'XYZ-1767592397445-B410C285',5,NULL,'IN_STOCK','GRN','XYZ789563405','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1727,'XYZ-1767592397471-22BE665F',5,NULL,'IN_STOCK','GRN','XYZ054201625','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1728,'XYZ-1767592397496-48FB15DF',5,NULL,'IN_STOCK','GRN','XYZ313223671','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1729,'XYZ-1767592397520-8BD16B35',5,NULL,'IN_STOCK','GRN','XYZ386207252','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1730,'XYZ-1767592397545-85699ED2',5,NULL,'IN_STOCK','GRN','XYZ896746258','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1731,'XYZ-1767592397572-873D59F9',5,NULL,'IN_STOCK','GRN','XYZ789738691','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1732,'XYZ-1767592397598-C2313DC5',5,NULL,'IN_STOCK','GRN','XYZ909064624','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1733,'XYZ-1767592397624-615F7074',5,NULL,'IN_STOCK','GRN','XYZ087523961','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1734,'XYZ-1767592397652-2E17B9ED',5,NULL,'IN_STOCK','GRN','XYZ135532004','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1735,'XYZ-1767592397680-958A5515',5,NULL,'IN_STOCK','GRN','XYZ521136724','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1736,'XYZ-1767592397706-736F6F55',5,NULL,'IN_STOCK','GRN','XYZ258782970','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1737,'XYZ-1767592397733-5C46FE1A',5,NULL,'IN_STOCK','GRN','XYZ746777709','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1738,'XYZ-1767592397761-5399D834',5,NULL,'IN_STOCK','GRN','XYZ182538250','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1739,'XYZ-1767592397790-126E45C3',5,NULL,'IN_STOCK','GRN','XYZ410359379','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1740,'XYZ-1767592397814-4987C4F2',5,NULL,'IN_STOCK','GRN','XYZ634297597','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1741,'XYZ-1767592397839-61B71052',5,NULL,'IN_STOCK','GRN','XYZ746167237','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1742,'XYZ-1767592397861-F0EE7A08',5,NULL,'IN_STOCK','GRN','XYZ546455214','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1743,'XYZ-1767592397888-8BEAEA03',5,NULL,'IN_STOCK','GRN','XYZ173080694','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1744,'XYZ-1767592397908-796C1B27',5,NULL,'IN_STOCK','GRN','XYZ178753047','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1745,'XYZ-1767592397929-9921AD05',5,NULL,'IN_STOCK','GRN','XYZ091288848','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1746,'XYZ-1767592397949-60EDB89E',5,NULL,'IN_STOCK','GRN','XYZ538256967','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1747,'XYZ-1767592397971-75A2CB58',5,NULL,'IN_STOCK','GRN','XYZ429758899','2026-01-05 05:53:17','2026-01-05 05:53:17'),(1748,'XYZ-1767592397996-B5E1C30F',5,NULL,'IN_STOCK','GRN','XYZ141607137','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1749,'XYZ-1767592398023-BA11A865',5,NULL,'IN_STOCK','GRN','XYZ286073209','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1750,'XYZ-1767592398051-37EF86A4',5,NULL,'IN_STOCK','GRN','XYZ076095639','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1751,'XYZ-1767592398077-BD33C8ED',5,NULL,'IN_STOCK','GRN','XYZ254396212','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1752,'XYZ-1767592398103-082E9CDA',5,NULL,'IN_STOCK','GRN','XYZ584076974','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1753,'XYZ-1767592398129-15A71A54',5,NULL,'IN_STOCK','GRN','XYZ027089812','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1754,'XYZ-1767592398153-2498679C',5,NULL,'IN_STOCK','GRN','XYZ179231136','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1755,'XYZ-1767592398178-187A8F60',5,NULL,'IN_STOCK','GRN','XYZ221250900','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1756,'XYZ-1767592398199-79D34C59',5,NULL,'IN_STOCK','GRN','XYZ838700385','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1757,'XYZ-1767592398225-3D88BE77',5,NULL,'IN_STOCK','GRN','XYZ946496023','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1758,'XYZ-1767592398253-8F8D04AD',5,NULL,'IN_STOCK','GRN','XYZ260996150','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1759,'XYZ-1767592398282-3D769E27',5,NULL,'IN_STOCK','GRN','XYZ246848411','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1760,'XYZ-1767592398311-030DCF63',5,NULL,'IN_STOCK','GRN','XYZ497251750','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1761,'XYZ-1767592398336-7DF293E9',5,NULL,'IN_STOCK','GRN','XYZ760880531','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1762,'XYZ-1767592398359-9D404192',5,NULL,'IN_STOCK','GRN','XYZ897958677','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1763,'XYZ-1767592398380-B74644D6',5,NULL,'IN_STOCK','GRN','XYZ488153262','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1764,'XYZ-1767592398402-8330986D',5,NULL,'IN_STOCK','GRN','XYZ564844851','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1765,'XYZ-1767592398424-8E162213',5,NULL,'IN_STOCK','GRN','XYZ584846314','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1766,'XYZ-1767592398446-4A00BAEB',5,NULL,'IN_STOCK','GRN','XYZ141282096','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1767,'XYZ-1767592398471-5D024043',5,NULL,'IN_STOCK','GRN','XYZ506144665','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1768,'XYZ-1767592398493-75F52B81',5,NULL,'IN_STOCK','GRN','XYZ244889569','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1769,'XYZ-1767592398514-B92BE8E3',5,NULL,'IN_STOCK','GRN','XYZ487908096','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1770,'XYZ-1767592398536-F009B02F',5,NULL,'IN_STOCK','GRN','XYZ830459188','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1771,'XYZ-1767592398557-61AC1CAE',5,NULL,'IN_STOCK','GRN','XYZ550813930','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1772,'XYZ-1767592398579-2103FCA9',5,NULL,'IN_STOCK','GRN','XYZ825665657','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1773,'XYZ-1767592398600-E632073B',5,NULL,'IN_STOCK','GRN','XYZ810984798','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1774,'XYZ-1767592398624-4184D2BF',5,NULL,'IN_STOCK','GRN','XYZ479620504','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1775,'XYZ-1767592398650-E19C1B16',5,NULL,'IN_STOCK','GRN','XYZ123683413','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1776,'XYZ-1767592398673-B4B7D860',5,NULL,'IN_STOCK','GRN','XYZ039979986','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1777,'XYZ-1767592398695-002B21A4',5,NULL,'IN_STOCK','GRN','XYZ150870466','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1778,'XYZ-1767592398724-5B6282A2',5,NULL,'IN_STOCK','GRN','XYZ020579357','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1779,'XYZ-1767592398751-501E4B47',5,NULL,'IN_STOCK','GRN','XYZ176519877','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1780,'XYZ-1767592398777-06BF67BC',5,NULL,'IN_STOCK','GRN','XYZ795155631','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1781,'XYZ-1767592398804-BA7B921A',5,NULL,'IN_STOCK','GRN','XYZ451464364','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1782,'XYZ-1767592398831-B5653393',5,NULL,'IN_STOCK','GRN','XYZ550319696','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1783,'XYZ-1767592398857-445F113E',5,NULL,'IN_STOCK','GRN','XYZ167619566','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1784,'XYZ-1767592398883-23875BB8',5,NULL,'IN_STOCK','GRN','XYZ432589624','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1785,'XYZ-1767592398909-80D839CD',5,NULL,'IN_STOCK','GRN','XYZ007713111','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1786,'XYZ-1767592398936-76EDD4E4',5,NULL,'IN_STOCK','GRN','XYZ169459732','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1787,'XYZ-1767592398962-0DF5289E',5,NULL,'IN_STOCK','GRN','XYZ048118966','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1788,'XYZ-1767592398984-029A56E4',5,NULL,'IN_STOCK','GRN','XYZ668416088','2026-01-05 05:53:18','2026-01-05 05:53:18'),(1789,'XYZ-1767592399006-6DEA4F6B',5,NULL,'IN_STOCK','GRN','XYZ330451244','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1790,'XYZ-1767592399030-669F38FD',5,NULL,'IN_STOCK','GRN','XYZ900392305','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1791,'XYZ-1767592399057-4B5BB0C6',5,NULL,'IN_STOCK','GRN','XYZ064410881','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1792,'XYZ-1767592399083-12A32CAE',5,NULL,'IN_STOCK','GRN','XYZ585490511','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1793,'XYZ-1767592399113-97FF7671',5,NULL,'IN_STOCK','GRN','XYZ781214029','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1794,'XYZ-1767592399143-B9D3DD3D',5,NULL,'IN_STOCK','GRN','XYZ642411465','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1795,'XYZ-1767592399169-7BA4EC84',5,NULL,'IN_STOCK','GRN','XYZ032276561','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1796,'XYZ-1767592399197-AD9EFCA7',5,NULL,'IN_STOCK','GRN','XYZ482395749','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1797,'XYZ-1767592399223-5C265965',5,NULL,'IN_STOCK','GRN','XYZ820419982','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1798,'XYZ-1767592399250-D479D239',5,NULL,'IN_STOCK','GRN','XYZ160405695','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1799,'XYZ-1767592399278-A66F4146',5,NULL,'IN_STOCK','GRN','XYZ545034818','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1800,'XYZ-1767592399302-302BFECA',5,NULL,'IN_STOCK','GRN','XYZ747827901','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1801,'XYZ-1767592399331-88D03BC7',5,NULL,'IN_STOCK','GRN','XYZ076168793','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1802,'XYZ-1767592399350-65E8C2E3',5,NULL,'IN_STOCK','GRN','XYZ537796395','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1803,'XYZ-1767592399375-EBA0F464',5,NULL,'IN_STOCK','GRN','XYZ784246006','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1804,'XYZ-1767592399399-E7B4B552',5,NULL,'IN_STOCK','GRN','XYZ159680058','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1805,'XYZ-1767592399424-ABB13334',5,NULL,'IN_STOCK','GRN','XYZ236443264','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1806,'XYZ-1767592399454-B9043ED7',5,NULL,'IN_STOCK','GRN','XYZ409278093','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1807,'XYZ-1767592399479-5A32A337',5,NULL,'IN_STOCK','GRN','XYZ632733578','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1808,'XYZ-1767592399503-7261D28E',5,NULL,'IN_STOCK','GRN','XYZ110785562','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1809,'XYZ-1767592399529-FB281439',5,NULL,'IN_STOCK','GRN','XYZ334239477','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1810,'XYZ-1767592399556-B5102C11',5,NULL,'IN_STOCK','GRN','XYZ548776957','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1811,'XYZ-1767592399583-EE22B45A',5,NULL,'IN_STOCK','GRN','XYZ238083707','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1812,'XYZ-1767592399612-B055EEF8',5,NULL,'IN_STOCK','GRN','XYZ039774385','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1813,'XYZ-1767592399638-94378AF4',5,NULL,'IN_STOCK','GRN','XYZ790389416','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1814,'XYZ-1767592399664-594A7E22',5,NULL,'IN_STOCK','GRN','XYZ183328620','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1815,'XYZ-1767592399690-606DDE67',5,NULL,'IN_STOCK','GRN','XYZ920951731','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1816,'XYZ-1767592399714-3803E226',5,NULL,'IN_STOCK','GRN','XYZ965575956','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1817,'XYZ-1767592399740-F1A3BDF2',5,NULL,'IN_STOCK','GRN','XYZ369688422','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1818,'XYZ-1767592399764-FB81B270',5,NULL,'IN_STOCK','GRN','XYZ144312566','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1819,'XYZ-1767592399790-E97FC0D8',5,NULL,'IN_STOCK','GRN','XYZ593500486','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1820,'XYZ-1767592399819-2C8989D3',5,NULL,'IN_STOCK','GRN','XYZ087830143','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1821,'XYZ-1767592399861-B65A52D9',5,NULL,'IN_STOCK','GRN','XYZ138014869','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1822,'XYZ-1767592399866-4A639228',4,NULL,'IN_STOCK','GRN','XYZ538076130','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1823,'XYZ-1767592399889-B551958E',5,NULL,'IN_STOCK','GRN','XYZ716921462','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1824,'XYZ-1767592399914-8DE0055D',5,NULL,'IN_STOCK','GRN','XYZ302297288','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1825,'XYZ-1767592399938-6EED599D',5,NULL,'IN_STOCK','GRN','XYZ244413944','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1826,'XYZ-1767592399964-1794A19C',5,NULL,'IN_STOCK','GRN','XYZ875389168','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1827,'XYZ-1767592399987-25BD1A8B',5,NULL,'IN_STOCK','GRN','XYZ528258127','2026-01-05 05:53:19','2026-01-05 05:53:19'),(1828,'XYZ-1767592400010-03FB2A92',5,NULL,'IN_STOCK','GRN','XYZ358101515','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1829,'XYZ-1767592400035-DB6D8964',5,NULL,'IN_STOCK','GRN','XYZ299446292','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1830,'XYZ-1767592400058-59ADB686',5,NULL,'IN_STOCK','GRN','XYZ738460500','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1831,'XYZ-1767592400082-12814810',5,NULL,'IN_STOCK','GRN','XYZ016180510','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1832,'XYZ-1767592400103-5C18BB24',5,NULL,'IN_STOCK','GRN','XYZ589238904','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1833,'XYZ-1767592400126-556D3DCF',5,NULL,'IN_STOCK','GRN','XYZ276286700','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1834,'XYZ-1767592400149-21F7BDAB',5,NULL,'IN_STOCK','GRN','XYZ783332597','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1835,'XYZ-1767592400175-8CB2D20E',5,NULL,'IN_STOCK','GRN','XYZ013829893','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1836,'XYZ-1767592400203-14C5327C',5,NULL,'IN_STOCK','GRN','XYZ392552099','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1837,'XYZ-1767592400232-03C8ABAD',5,NULL,'IN_STOCK','GRN','XYZ999249648','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1838,'XYZ-1767592400255-E4F3F194',5,NULL,'IN_STOCK','GRN','XYZ996510790','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1839,'XYZ-1767592400278-A543C6E1',5,NULL,'IN_STOCK','GRN','XYZ960814947','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1840,'XYZ-1767592400301-194F2620',5,NULL,'IN_STOCK','GRN','XYZ769095636','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1841,'XYZ-1767592400327-47A9FD11',5,NULL,'IN_STOCK','GRN','XYZ073690669','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1842,'XYZ-1767592400350-82B74AB1',5,NULL,'IN_STOCK','GRN','XYZ303341699','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1843,'XYZ-1767592400370-8361CC55',5,NULL,'IN_STOCK','GRN','XYZ549945929','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1844,'XYZ-1767592400391-4F279541',5,NULL,'IN_STOCK','GRN','XYZ111006958','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1845,'XYZ-1767592400415-D67A14D8',5,NULL,'IN_STOCK','GRN','XYZ610243683','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1846,'XYZ-1767592400441-949F4547',5,NULL,'IN_STOCK','GRN','XYZ885778473','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1847,'XYZ-1767592400466-75D2AAE3',5,NULL,'IN_STOCK','GRN','XYZ112658665','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1848,'XYZ-1767592400489-99FEDF40',5,NULL,'IN_STOCK','GRN','XYZ835811039','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1849,'XYZ-1767592400514-900EF155',5,NULL,'IN_STOCK','GRN','XYZ399193010','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1850,'XYZ-1767592400537-F058131D',5,NULL,'IN_STOCK','GRN','XYZ554223566','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1851,'XYZ-1767592400560-7152F017',5,NULL,'IN_STOCK','GRN','XYZ808894174','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1852,'XYZ-1767592400583-835B07EF',5,NULL,'IN_STOCK','GRN','XYZ059406912','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1853,'XYZ-1767592400606-E0F70AA2',5,NULL,'IN_STOCK','GRN','XYZ984044937','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1854,'XYZ-1767592400629-7EFB4EB3',5,NULL,'IN_STOCK','GRN','XYZ307011452','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1855,'XYZ-1767592400651-D75992B3',5,NULL,'IN_STOCK','GRN','XYZ227341480','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1856,'XYZ-1767592400672-A603C61C',5,NULL,'IN_STOCK','GRN','XYZ145003356','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1857,'XYZ-1767592400694-EF106ED0',5,NULL,'IN_STOCK','GRN','XYZ361178071','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1858,'XYZ-1767592400718-500BBA2A',5,NULL,'IN_STOCK','GRN','XYZ372258204','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1859,'XYZ-1767592400741-807FFACC',5,NULL,'IN_STOCK','GRN','XYZ574067064','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1860,'XYZ-1767592400769-FA51E93B',5,NULL,'IN_STOCK','GRN','XYZ430108981','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1861,'XYZ-1767592400796-096FE55A',5,NULL,'IN_STOCK','GRN','XYZ376366449','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1862,'XYZ-1767592400820-13464840',5,NULL,'IN_STOCK','GRN','XYZ407698678','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1863,'XYZ-1767592400845-E693C615',5,NULL,'IN_STOCK','GRN','XYZ187852527','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1864,'XYZ-1767592400869-56F3C75A',5,NULL,'IN_STOCK','GRN','XYZ129608568','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1865,'XYZ-1767592400892-24C57BC7',5,NULL,'IN_STOCK','GRN','XYZ303443117','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1866,'XYZ-1767592400914-B25A2255',5,NULL,'IN_STOCK','GRN','XYZ229079048','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1867,'XYZ-1767592400936-D2D23994',5,NULL,'IN_STOCK','GRN','XYZ675748331','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1868,'XYZ-1767592400957-BBAAF729',5,NULL,'IN_STOCK','GRN','XYZ163689702','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1869,'XYZ-1767592400979-748D95B1',5,NULL,'IN_STOCK','GRN','XYZ926070619','2026-01-05 05:53:20','2026-01-05 05:53:20'),(1870,'XYZ-1767592401001-28A4D97F',5,NULL,'IN_STOCK','GRN','XYZ459941112','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1871,'XYZ-1767592401025-783D0B33',5,NULL,'IN_STOCK','GRN','XYZ399088262','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1872,'XYZ-1767592401050-38CC9618',5,NULL,'IN_STOCK','GRN','XYZ222550404','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1873,'XYZ-1767592401075-A5F19F9C',5,NULL,'IN_STOCK','GRN','XYZ163629192','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1874,'XYZ-1767592401101-40D6A57F',5,NULL,'IN_STOCK','GRN','XYZ057145967','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1875,'XYZ-1767592401127-35BC56A5',5,NULL,'IN_STOCK','GRN','XYZ399539500','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1876,'XYZ-1767592401153-0C02FBC2',5,NULL,'IN_STOCK','GRN','XYZ306584495','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1877,'XYZ-1767592401177-46293B28',5,NULL,'IN_STOCK','GRN','XYZ354304009','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1878,'XYZ-1767592401200-BC36D5A4',5,NULL,'IN_STOCK','GRN','XYZ653616273','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1879,'XYZ-1767592401223-44C8C9AE',5,NULL,'IN_STOCK','GRN','XYZ749950916','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1880,'XYZ-1767592401245-ED83B36D',5,NULL,'IN_STOCK','GRN','XYZ032633789','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1881,'XYZ-1767592401268-F9BEC69C',5,NULL,'IN_STOCK','GRN','XYZ655418403','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1882,'XYZ-1767592401294-3199BEA1',5,NULL,'IN_STOCK','GRN','XYZ018998941','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1883,'XYZ-1767592401318-93C455C7',5,NULL,'IN_STOCK','GRN','XYZ356754895','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1884,'XYZ-1767592401342-ABF80126',5,NULL,'IN_STOCK','GRN','XYZ160840089','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1885,'XYZ-1767592401380-4F91382B',5,NULL,'IN_STOCK','GRN','XYZ348600288','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1886,'XYZ-1767592401385-2243A3DB',4,NULL,'IN_STOCK','GRN','XYZ591559517','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1887,'XYZ-1767592401406-D9FB3215',5,NULL,'IN_STOCK','GRN','XYZ477964008','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1888,'XYZ-1767592401425-A25954D5',5,NULL,'IN_STOCK','GRN','XYZ577373086','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1889,'XYZ-1767592401444-6CF769B0',5,NULL,'IN_STOCK','GRN','XYZ226458288','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1890,'XYZ-1767592401463-03E76376',5,NULL,'IN_STOCK','GRN','XYZ125174109','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1891,'XYZ-1767592401482-7F723605',5,NULL,'IN_STOCK','GRN','XYZ848455638','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1892,'XYZ-1767592401501-389B8044',5,NULL,'IN_STOCK','GRN','XYZ075095643','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1893,'XYZ-1767592401523-1B427676',5,NULL,'IN_STOCK','GRN','XYZ954603581','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1894,'XYZ-1767592401545-B195B287',5,NULL,'IN_STOCK','GRN','XYZ852953343','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1895,'XYZ-1767592401571-D77A901E',5,NULL,'IN_STOCK','GRN','XYZ872046225','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1896,'XYZ-1767592401594-F5F6A088',5,NULL,'IN_STOCK','GRN','XYZ872615677','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1897,'XYZ-1767592401616-C6CC0E0B',5,NULL,'IN_STOCK','GRN','XYZ161330957','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1898,'XYZ-1767592401641-2509B57A',5,NULL,'IN_STOCK','GRN','XYZ410118296','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1899,'XYZ-1767592401664-DEC68182',5,NULL,'IN_STOCK','GRN','XYZ920823534','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1900,'XYZ-1767592401686-234A6336',5,NULL,'IN_STOCK','GRN','XYZ589927325','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1901,'XYZ-1767592401709-65E48CEE',5,NULL,'IN_STOCK','GRN','XYZ010514914','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1902,'XYZ-1767592401734-F7C771B1',5,NULL,'IN_STOCK','GRN','XYZ906733332','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1903,'XYZ-1767592401764-2D2BE8F9',5,NULL,'IN_STOCK','GRN','XYZ322225775','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1904,'XYZ-1767592401790-F58ACBFE',5,NULL,'IN_STOCK','GRN','XYZ286563152','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1905,'XYZ-1767592401817-6D7140F2',5,NULL,'IN_STOCK','GRN','XYZ635957685','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1906,'XYZ-1767592401843-2E24C6FE',5,NULL,'IN_STOCK','GRN','XYZ714807792','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1907,'XYZ-1767592401873-C514DF31',5,NULL,'IN_STOCK','GRN','XYZ851547575','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1908,'XYZ-1767592401898-25385B45',5,NULL,'IN_STOCK','GRN','XYZ405507687','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1909,'XYZ-1767592401924-71586820',5,NULL,'IN_STOCK','GRN','XYZ329932321','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1910,'XYZ-1767592401949-D3439544',5,NULL,'IN_STOCK','GRN','XYZ338104414','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1911,'XYZ-1767592401971-B88B6C95',5,NULL,'IN_STOCK','GRN','XYZ211512471','2026-01-05 05:53:21','2026-01-05 05:53:21'),(1912,'XYZ-1767592401993-00291AF4',5,NULL,'IN_STOCK','GRN','XYZ897456827','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1913,'XYZ-1767592402020-837B259F',5,NULL,'IN_STOCK','GRN','XYZ153062219','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1914,'XYZ-1767592402048-36150F86',5,NULL,'IN_STOCK','GRN','XYZ340470026','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1915,'XYZ-1767592402073-AE174486',5,NULL,'IN_STOCK','GRN','XYZ794031111','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1916,'XYZ-1767592402100-7213D5C7',5,NULL,'IN_STOCK','GRN','XYZ981868911','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1917,'XYZ-1767592402127-0A1D5579',5,NULL,'IN_STOCK','GRN','XYZ380496897','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1918,'XYZ-1767592402149-45CE5996',5,NULL,'IN_STOCK','GRN','XYZ722550289','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1919,'XYZ-1767592402169-CF425FD2',5,NULL,'IN_STOCK','GRN','XYZ006713491','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1920,'XYZ-1767592402188-3C3A1BAC',5,NULL,'IN_STOCK','GRN','XYZ608136789','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1921,'XYZ-1767592402208-47EDC520',5,NULL,'IN_STOCK','GRN','XYZ971707747','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1922,'XYZ-1767592402227-A6821067',5,NULL,'IN_STOCK','GRN','XYZ213249961','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1923,'XYZ-1767592402246-4DA95DC3',5,NULL,'IN_STOCK','GRN','XYZ390031299','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1924,'XYZ-1767592402268-187F9E60',5,NULL,'IN_STOCK','GRN','XYZ716806159','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1925,'XYZ-1767592402290-5078ADBF',5,NULL,'IN_STOCK','GRN','XYZ599515116','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1926,'XYZ-1767592402311-EA6849C5',5,NULL,'IN_STOCK','GRN','XYZ905837748','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1927,'XYZ-1767592402331-62216706',5,NULL,'IN_STOCK','GRN','XYZ814419231','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1928,'XYZ-1767592402356-127D7DA7',5,NULL,'IN_STOCK','GRN','XYZ428972643','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1929,'XYZ-1767592402380-FEE2A290',5,NULL,'IN_STOCK','GRN','XYZ605476516','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1930,'XYZ-1767592402402-3AB0C257',5,NULL,'IN_STOCK','GRN','XYZ501554425','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1931,'XYZ-1767592402427-701849F8',5,NULL,'IN_STOCK','GRN','XYZ144883780','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1932,'XYZ-1767592402452-FE72ECFB',5,NULL,'IN_STOCK','GRN','XYZ157241290','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1933,'XYZ-1767592402474-7E65AA61',5,NULL,'IN_STOCK','GRN','XYZ285948665','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1934,'XYZ-1767592402496-37710C0F',5,NULL,'IN_STOCK','GRN','XYZ007656023','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1935,'XYZ-1767592402518-58926AA1',5,NULL,'IN_STOCK','GRN','XYZ727391952','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1936,'XYZ-1767592402545-D220FCE4',5,NULL,'IN_STOCK','GRN','XYZ319286921','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1937,'XYZ-1767592402571-4632417D',5,NULL,'IN_STOCK','GRN','XYZ548094023','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1938,'XYZ-1767592402597-8402F10A',5,NULL,'IN_STOCK','GRN','XYZ713945915','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1939,'XYZ-1767592402619-633D24E1',5,NULL,'IN_STOCK','GRN','XYZ438057695','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1940,'XYZ-1767592402641-5317CCCB',5,NULL,'IN_STOCK','GRN','XYZ136053787','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1941,'XYZ-1767592402663-81FDE956',5,NULL,'IN_STOCK','GRN','XYZ295638930','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1942,'XYZ-1767592402685-1569C4D1',5,NULL,'IN_STOCK','GRN','XYZ941756677','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1943,'XYZ-1767592402707-65A6C674',5,NULL,'IN_STOCK','GRN','XYZ518294601','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1944,'XYZ-1767592402731-EE0193FF',5,NULL,'IN_STOCK','GRN','XYZ933654618','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1945,'XYZ-1767592402750-9F156132',5,NULL,'IN_STOCK','GRN','XYZ153279220','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1946,'XYZ-1767592402772-CA27CF2A',5,NULL,'IN_STOCK','GRN','XYZ993677522','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1947,'XYZ-1767592402797-D5322F98',5,NULL,'IN_STOCK','GRN','XYZ939608235','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1948,'XYZ-1767592402822-0F6D915B',5,NULL,'IN_STOCK','GRN','XYZ245739720','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1949,'XYZ-1767592402847-49D83888',5,NULL,'IN_STOCK','GRN','XYZ704760727','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1950,'XYZ-1767592402871-AFFC63E0',5,NULL,'IN_STOCK','GRN','XYZ203748195','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1951,'XYZ-1767592402894-38C14111',5,NULL,'IN_STOCK','GRN','XYZ158451635','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1952,'XYZ-1767592402919-EB7E1CB6',5,NULL,'IN_STOCK','GRN','XYZ873394460','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1953,'XYZ-1767592402942-4845CEEF',5,NULL,'IN_STOCK','GRN','XYZ836460963','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1954,'XYZ-1767592402964-0EDFBDE6',5,NULL,'IN_STOCK','GRN','XYZ429449247','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1955,'XYZ-1767592402987-3AB4E1D0',5,NULL,'IN_STOCK','GRN','XYZ354110226','2026-01-05 05:53:22','2026-01-05 05:53:22'),(1956,'XYZ-1767592403009-318E6BA3',5,NULL,'IN_STOCK','GRN','XYZ304292020','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1957,'XYZ-1767592403031-4D120B36',5,NULL,'IN_STOCK','GRN','XYZ963544354','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1958,'XYZ-1767592403053-0B7D4D45',5,NULL,'IN_STOCK','GRN','XYZ722958208','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1959,'XYZ-1767592403075-EFA2F21F',5,NULL,'IN_STOCK','GRN','XYZ703420994','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1960,'XYZ-1767592403097-FF8DB2CC',5,NULL,'IN_STOCK','GRN','XYZ624513217','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1961,'XYZ-1767592403120-42C26693',5,NULL,'IN_STOCK','GRN','XYZ469334045','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1962,'XYZ-1767592403143-57A24378',5,NULL,'IN_STOCK','GRN','XYZ705335894','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1963,'XYZ-1767592403168-53854809',5,NULL,'IN_STOCK','GRN','XYZ922124997','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1964,'XYZ-1767592403190-EC3F6E41',5,NULL,'IN_STOCK','GRN','XYZ824572508','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1965,'XYZ-1767592403213-ADD37C21',5,NULL,'IN_STOCK','GRN','XYZ257391750','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1966,'XYZ-1767592403238-62119D1E',5,NULL,'IN_STOCK','GRN','XYZ709646004','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1967,'XYZ-1767592403265-6ABCFC19',5,NULL,'IN_STOCK','GRN','XYZ202715370','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1968,'XYZ-1767592403287-93C81C9E',5,NULL,'IN_STOCK','GRN','XYZ211770855','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1969,'XYZ-1767592403312-65CCDDC3',5,NULL,'IN_STOCK','GRN','XYZ963594550','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1970,'XYZ-1767592403335-E0FA067B',5,NULL,'IN_STOCK','GRN','XYZ434056840','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1971,'XYZ-1767592403355-4E9F36B8',5,NULL,'IN_STOCK','GRN','XYZ338893748','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1972,'XYZ-1767592403381-3680C142',5,NULL,'IN_STOCK','GRN','XYZ686165641','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1973,'XYZ-1767592403404-A1F2B096',5,NULL,'IN_STOCK','GRN','XYZ925734172','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1974,'XYZ-1767592403426-0297C81A',5,NULL,'IN_STOCK','GRN','XYZ973204461','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1975,'XYZ-1767592403448-04A5F697',5,NULL,'IN_STOCK','GRN','XYZ214815036','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1976,'XYZ-1767592403471-53FF45CC',5,NULL,'IN_STOCK','GRN','XYZ427633003','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1977,'XYZ-1767592403493-4AED05A6',5,NULL,'IN_STOCK','GRN','XYZ814451759','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1978,'XYZ-1767592403518-CBF6F45D',5,NULL,'IN_STOCK','GRN','XYZ784960205','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1979,'XYZ-1767592403540-3CB66617',5,NULL,'IN_STOCK','GRN','XYZ359249980','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1980,'XYZ-1767592403566-7C680759',5,NULL,'IN_STOCK','GRN','XYZ194917754','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1981,'XYZ-1767592403588-E40C6E9C',5,NULL,'IN_STOCK','GRN','XYZ187536400','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1982,'XYZ-1767592403609-070B9B05',5,NULL,'IN_STOCK','GRN','XYZ198500895','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1983,'XYZ-1767592403634-9D9DBAC7',5,NULL,'IN_STOCK','GRN','XYZ891703355','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1984,'XYZ-1767592403659-AAA71296',5,NULL,'IN_STOCK','GRN','XYZ648958020','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1985,'XYZ-1767592403683-D02DB30E',5,NULL,'IN_STOCK','GRN','XYZ275768997','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1986,'XYZ-1767592403706-6FF86085',5,NULL,'IN_STOCK','GRN','XYZ991853846','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1987,'XYZ-1767592403730-F7DFB09A',5,NULL,'IN_STOCK','GRN','XYZ739864471','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1988,'XYZ-1767592403753-0D4C09E6',5,NULL,'IN_STOCK','GRN','XYZ227945146','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1989,'XYZ-1767592403779-B4F6445D',5,NULL,'IN_STOCK','GRN','XYZ276469797','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1990,'XYZ-1767592403802-0B07CAE2',5,NULL,'IN_STOCK','GRN','XYZ424121744','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1991,'XYZ-1767592403823-83D68D86',5,NULL,'IN_STOCK','GRN','XYZ187726033','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1992,'XYZ-1767592403844-C002D7DD',5,NULL,'IN_STOCK','GRN','XYZ415007139','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1993,'XYZ-1767592403863-7B31E054',5,NULL,'IN_STOCK','GRN','XYZ379430083','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1994,'XYZ-1767592403885-5F439AD4',5,NULL,'IN_STOCK','GRN','XYZ622005054','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1995,'XYZ-1767592403906-721B7047',5,NULL,'IN_STOCK','GRN','XYZ248885721','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1996,'XYZ-1767592403929-AA82E41F',5,NULL,'IN_STOCK','GRN','XYZ682203061','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1997,'XYZ-1767592403951-E76BF011',5,NULL,'IN_STOCK','GRN','XYZ969900061','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1998,'XYZ-1767592403972-68BB0587',5,NULL,'IN_STOCK','GRN','XYZ078767569','2026-01-05 05:53:23','2026-01-05 05:53:23'),(1999,'XYZ-1767592403996-5370AFC1',5,NULL,'IN_STOCK','GRN','XYZ213320357','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2000,'XYZ-1767592404017-CADFE4D8',5,NULL,'IN_STOCK','GRN','XYZ598194114','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2001,'XYZ-1767592404041-15C61B9C',5,NULL,'IN_STOCK','GRN','XYZ770185014','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2002,'XYZ-1767592404064-14AAE5EB',5,NULL,'IN_STOCK','GRN','XYZ589100097','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2003,'XYZ-1767592404086-172D12AD',5,NULL,'IN_STOCK','GRN','XYZ364820963','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2004,'XYZ-1767592404104-11CEE7C5',5,NULL,'IN_STOCK','GRN','XYZ219666594','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2005,'XYZ-1767592404126-70A573C3',5,NULL,'IN_STOCK','GRN','XYZ051435161','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2006,'XYZ-1767592404146-847EFFA3',5,NULL,'IN_STOCK','GRN','XYZ656435682','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2007,'XYZ-1767592404165-D57B7415',5,NULL,'IN_STOCK','GRN','XYZ287431350','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2008,'XYZ-1767592404190-B5A3E151',5,NULL,'IN_STOCK','GRN','XYZ841849233','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2009,'XYZ-1767592404212-9CABCD71',5,NULL,'IN_STOCK','GRN','XYZ145868388','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2010,'XYZ-1767592404234-8D2C9830',5,NULL,'IN_STOCK','GRN','XYZ219004248','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2011,'XYZ-1767592404258-D8B67D13',5,NULL,'IN_STOCK','GRN','XYZ477890420','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2012,'XYZ-1767592404283-670E5D5B',5,NULL,'IN_STOCK','GRN','XYZ456293608','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2013,'XYZ-1767592404308-DBF9A5A4',5,NULL,'IN_STOCK','GRN','XYZ492836408','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2014,'XYZ-1767592404335-BBD802E6',5,NULL,'IN_STOCK','GRN','XYZ208042770','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2015,'XYZ-1767592404362-F32E6D75',5,NULL,'IN_STOCK','GRN','XYZ844782301','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2016,'XYZ-1767592404391-B0A0E91E',5,NULL,'IN_STOCK','GRN','XYZ373302185','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2017,'XYZ-1767592404417-25184C5C',5,NULL,'IN_STOCK','GRN','XYZ051342552','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2018,'XYZ-1767592404445-3C72BF31',5,NULL,'IN_STOCK','GRN','XYZ449657336','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2019,'XYZ-1767592404472-D4DCE52B',5,NULL,'IN_STOCK','GRN','XYZ607604610','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2020,'XYZ-1767592404499-8BC10D39',5,NULL,'IN_STOCK','GRN','XYZ331335155','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2021,'XYZ-1767592404524-C0F7BDB4',5,NULL,'IN_STOCK','GRN','XYZ599236647','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2022,'XYZ-1767592404544-0CD7E0C0',5,NULL,'IN_STOCK','GRN','XYZ883538387','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2023,'XYZ-1767592404563-B5214112',5,NULL,'IN_STOCK','GRN','XYZ478042483','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2024,'XYZ-1767592404586-59B3C685',5,NULL,'IN_STOCK','GRN','XYZ791059651','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2025,'XYZ-1767592404613-85A402A2',5,NULL,'IN_STOCK','GRN','XYZ717706683','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2026,'XYZ-1767592404640-8CC2EC43',5,NULL,'IN_STOCK','GRN','XYZ165979902','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2027,'XYZ-1767592404666-7D138F23',5,NULL,'IN_STOCK','GRN','XYZ172562682','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2028,'XYZ-1767592404693-CA5E4560',5,NULL,'IN_STOCK','GRN','XYZ410631231','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2029,'XYZ-1767592404720-2131CFEA',5,NULL,'IN_STOCK','GRN','XYZ602584227','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2030,'XYZ-1767592404746-E91A82DA',5,NULL,'IN_STOCK','GRN','XYZ513942055','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2031,'XYZ-1767592404773-A8D9D7F9',5,NULL,'IN_STOCK','GRN','XYZ121568682','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2032,'XYZ-1767592404802-DA79A27C',5,NULL,'IN_STOCK','GRN','XYZ587114339','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2033,'XYZ-1767592404846-20EDF5DC',5,NULL,'IN_STOCK','GRN','XYZ776848949','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2034,'XYZ-1767592404872-10B06654',5,NULL,'IN_STOCK','GRN','XYZ085036786','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2035,'XYZ-1767592404899-9E0419AB',5,NULL,'IN_STOCK','GRN','XYZ017071704','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2036,'XYZ-1767592404927-8FB005EE',5,NULL,'IN_STOCK','GRN','XYZ246176860','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2037,'XYZ-1767592404954-24D26FF4',5,NULL,'IN_STOCK','GRN','XYZ756749866','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2038,'XYZ-1767592404983-2634B80F',5,NULL,'IN_STOCK','GRN','XYZ804063463','2026-01-05 05:53:24','2026-01-05 05:53:24'),(2039,'XYZ-1767592405015-ADDADDD7',5,NULL,'IN_STOCK','GRN','XYZ230613138','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2040,'XYZ-1767592405046-A2FEBB1D',5,NULL,'IN_STOCK','GRN','XYZ695478352','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2041,'XYZ-1767592405083-56E62E42',5,NULL,'IN_STOCK','GRN','XYZ039144338','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2042,'XYZ-1767592405116-ABA41551',5,NULL,'IN_STOCK','GRN','XYZ634615791','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2043,'XYZ-1767592405145-A6314BBC',5,NULL,'IN_STOCK','GRN','XYZ866331751','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2044,'XYZ-1767592405176-7A3B3C26',5,NULL,'IN_STOCK','GRN','XYZ439933187','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2045,'XYZ-1767592405219-664C87D1',5,NULL,'IN_STOCK','GRN','XYZ201674773','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2046,'XYZ-1767592405251-D85AF147',5,NULL,'IN_STOCK','GRN','XYZ442567968','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2047,'XYZ-1767592405297-2257B22D',5,NULL,'IN_STOCK','GRN','XYZ799472875','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2048,'XYZ-1767592405332-A6DFCC06',5,NULL,'IN_STOCK','GRN','XYZ524004725','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2049,'XYZ-1767592405363-96764AB2',5,NULL,'IN_STOCK','GRN','XYZ373306761','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2050,'XYZ-1767592405394-134D96D6',5,NULL,'IN_STOCK','GRN','XYZ906717085','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2051,'XYZ-1767592405421-80A223F1',5,NULL,'IN_STOCK','GRN','XYZ315649378','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2052,'XYZ-1767592405450-45A75449',5,NULL,'IN_STOCK','GRN','XYZ494146558','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2053,'XYZ-1767592405474-140C3B77',5,NULL,'IN_STOCK','GRN','XYZ910166714','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2054,'XYZ-1767592405499-8CBB7692',5,NULL,'IN_STOCK','GRN','XYZ750283520','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2055,'XYZ-1767592405526-0D290DB7',5,NULL,'IN_STOCK','GRN','XYZ419757277','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2056,'XYZ-1767592405553-8F07AA77',5,NULL,'IN_STOCK','GRN','XYZ493682602','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2057,'XYZ-1767592405579-94230760',5,NULL,'IN_STOCK','GRN','XYZ559745979','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2058,'XYZ-1767592405606-11652E2D',5,NULL,'IN_STOCK','GRN','XYZ539042648','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2059,'XYZ-1767592405635-3E455B7B',5,NULL,'IN_STOCK','GRN','XYZ884094106','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2060,'XYZ-1767592405662-7EC5EE89',5,NULL,'IN_STOCK','GRN','XYZ762696106','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2061,'XYZ-1767592405690-0608A85B',5,NULL,'IN_STOCK','GRN','XYZ733094287','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2062,'XYZ-1767592405718-4C53FF61',5,NULL,'IN_STOCK','GRN','XYZ717676855','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2063,'XYZ-1767592405743-50BC1480',5,NULL,'IN_STOCK','GRN','XYZ204232242','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2064,'XYZ-1767592405766-3D56C0DB',5,NULL,'IN_STOCK','GRN','XYZ670976003','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2065,'XYZ-1767592405790-95025308',5,NULL,'IN_STOCK','GRN','XYZ440027458','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2066,'XYZ-1767592405817-D7572361',5,NULL,'IN_STOCK','GRN','XYZ059579351','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2067,'XYZ-1767592405840-E60578AD',5,NULL,'IN_STOCK','GRN','XYZ858216958','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2068,'XYZ-1767592405867-44166420',5,NULL,'IN_STOCK','GRN','XYZ595799600','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2069,'XYZ-1767592405896-FB758AFA',5,NULL,'IN_STOCK','GRN','XYZ996484605','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2070,'XYZ-1767592405926-454AEB9D',5,NULL,'IN_STOCK','GRN','XYZ221863433','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2071,'XYZ-1767592405954-1D08B717',5,NULL,'IN_STOCK','GRN','XYZ900722399','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2072,'XYZ-1767592405982-3552231D',5,NULL,'IN_STOCK','GRN','XYZ517336529','2026-01-05 05:53:25','2026-01-05 05:53:25'),(2073,'XYZ-1767592406009-E3F967C1',5,NULL,'IN_STOCK','GRN','XYZ149802359','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2074,'XYZ-1767592406039-5F7AF1E7',5,NULL,'IN_STOCK','GRN','XYZ145000997','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2075,'XYZ-1767592406067-290C457D',5,NULL,'IN_STOCK','GRN','XYZ710693325','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2076,'XYZ-1767592406094-C2BBA61E',5,NULL,'IN_STOCK','GRN','XYZ083523335','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2077,'XYZ-1767592406123-E3C1B63E',5,NULL,'IN_STOCK','GRN','XYZ624555855','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2078,'XYZ-1767592406149-C7F120FC',5,NULL,'IN_STOCK','GRN','XYZ006397550','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2079,'XYZ-1767592406178-EF529267',5,NULL,'IN_STOCK','GRN','XYZ267219287','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2080,'XYZ-1767592406209-E341FB33',5,NULL,'IN_STOCK','GRN','XYZ476406006','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2081,'XYZ-1767592406245-F21E5E17',5,NULL,'IN_STOCK','GRN','XYZ167043458','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2082,'XYZ-1767592406275-864EE2EA',5,NULL,'IN_STOCK','GRN','XYZ119212425','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2083,'XYZ-1767592406310-D37FB8D2',5,NULL,'IN_STOCK','GRN','XYZ196212294','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2084,'XYZ-1767592406341-DD52165D',5,NULL,'IN_STOCK','GRN','XYZ661323609','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2085,'XYZ-1767592406372-C1E34DB4',5,NULL,'IN_STOCK','GRN','XYZ638360049','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2086,'XYZ-1767592406402-09A24C27',5,NULL,'IN_STOCK','GRN','XYZ658176974','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2087,'XYZ-1767592406435-7EDD5C37',5,NULL,'IN_STOCK','GRN','XYZ669174745','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2088,'XYZ-1767592406464-3A5F50E1',5,NULL,'IN_STOCK','GRN','XYZ917869915','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2089,'XYZ-1767592406493-420FBF2F',5,NULL,'IN_STOCK','GRN','XYZ644330131','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2090,'XYZ-1767592406521-6AF003BD',5,NULL,'IN_STOCK','GRN','XYZ582868439','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2091,'XYZ-1767592406561-CFCB8BE6',5,NULL,'IN_STOCK','GRN','XYZ359893015','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2092,'XYZ-1767592406596-3C91EB91',5,NULL,'IN_STOCK','GRN','XYZ305839601','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2093,'XYZ-1767592406623-35AD51E3',5,NULL,'IN_STOCK','GRN','XYZ309487982','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2094,'XYZ-1767592406651-AC1ED885',5,NULL,'IN_STOCK','GRN','XYZ583822557','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2095,'XYZ-1767592406677-58AA4E06',5,NULL,'IN_STOCK','GRN','XYZ970272318','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2096,'XYZ-1767592406701-58A4CB0F',5,NULL,'IN_STOCK','GRN','XYZ578616258','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2097,'XYZ-1767592406723-6191C651',5,NULL,'IN_STOCK','GRN','XYZ554814920','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2098,'XYZ-1767592406749-4448C7FD',5,NULL,'IN_STOCK','GRN','XYZ004075182','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2099,'XYZ-1767592406775-179B82E3',5,NULL,'IN_STOCK','GRN','XYZ343423825','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2100,'XYZ-1767592406801-AC8A2EFD',5,NULL,'IN_STOCK','GRN','XYZ944403249','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2101,'XYZ-1767592406827-670693C2',5,NULL,'IN_STOCK','GRN','XYZ472263439','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2102,'XYZ-1767592406853-23F5B0FD',5,NULL,'IN_STOCK','GRN','XYZ831055684','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2103,'XYZ-1767592406881-745AD6A5',5,NULL,'IN_STOCK','GRN','XYZ423344940','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2104,'XYZ-1767592406906-727E8E7C',5,NULL,'IN_STOCK','GRN','XYZ378496270','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2105,'XYZ-1767592406931-83164EA0',5,NULL,'IN_STOCK','GRN','XYZ257902539','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2106,'XYZ-1767592406961-17BC2C61',5,NULL,'IN_STOCK','GRN','XYZ851685878','2026-01-05 05:53:26','2026-01-05 05:53:26'),(2107,'XYZ-1767592406990-CCFDCCAA',5,NULL,'IN_STOCK','GRN','XYZ364948126','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2108,'XYZ-1767592407021-C2CE866D',5,NULL,'IN_STOCK','GRN','XYZ851752920','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2109,'XYZ-1767592407047-14C7110D',5,NULL,'IN_STOCK','GRN','XYZ424704899','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2110,'XYZ-1767592407074-0105FC9B',5,NULL,'IN_STOCK','GRN','XYZ389329055','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2111,'XYZ-1767592407101-8D97922D',5,NULL,'IN_STOCK','GRN','XYZ104691396','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2112,'XYZ-1767592407129-F3F464A7',5,NULL,'IN_STOCK','GRN','XYZ645590288','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2113,'XYZ-1767592407157-1643F748',5,NULL,'IN_STOCK','GRN','XYZ534487511','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2114,'XYZ-1767592407187-838149F1',5,NULL,'IN_STOCK','GRN','XYZ718189788','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2115,'XYZ-1767592407215-9576B82E',5,NULL,'IN_STOCK','GRN','XYZ832010379','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2116,'XYZ-1767592407242-C39041D8',5,NULL,'IN_STOCK','GRN','XYZ871606079','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2117,'XYZ-1767592407268-DFA6FD85',5,NULL,'IN_STOCK','GRN','XYZ988407726','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2118,'XYZ-1767592407295-0092EC85',5,NULL,'IN_STOCK','GRN','XYZ939855196','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2119,'XYZ-1767592407318-B66F82FA',5,NULL,'IN_STOCK','GRN','XYZ207216169','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2120,'XYZ-1767592407343-A36AAD94',5,NULL,'IN_STOCK','GRN','XYZ504039319','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2121,'XYZ-1767592407367-9FC3EDF5',5,NULL,'IN_STOCK','GRN','XYZ741505150','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2122,'XYZ-1767592407389-2E09C494',5,NULL,'IN_STOCK','GRN','XYZ478616270','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2123,'XYZ-1767592407411-2A9C4E76',5,NULL,'IN_STOCK','GRN','XYZ972696810','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2124,'XYZ-1767592407433-E0D6406E',5,NULL,'IN_STOCK','GRN','XYZ555943137','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2125,'XYZ-1767592407457-08B77DD2',5,NULL,'IN_STOCK','GRN','XYZ624298800','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2126,'XYZ-1767592407482-6A39D876',5,NULL,'IN_STOCK','GRN','XYZ000177987','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2127,'XYZ-1767592407505-7071783D',5,NULL,'IN_STOCK','GRN','XYZ467337478','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2128,'XYZ-1767592407528-4294EAC5',5,NULL,'IN_STOCK','GRN','XYZ472307757','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2129,'XYZ-1767592407551-51DF84DD',5,NULL,'IN_STOCK','GRN','XYZ459891300','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2130,'XYZ-1767592407575-EBD5A053',5,NULL,'IN_STOCK','GRN','XYZ648533066','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2131,'XYZ-1767592407599-4C66497D',5,NULL,'IN_STOCK','GRN','XYZ545873206','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2132,'XYZ-1767592407624-B9CBF643',5,NULL,'IN_STOCK','GRN','XYZ471761624','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2133,'XYZ-1767592407647-B7350096',5,NULL,'IN_STOCK','GRN','XYZ929663910','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2134,'XYZ-1767592407668-06AE41A1',5,NULL,'IN_STOCK','GRN','XYZ948978114','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2135,'XYZ-1767592407691-93F8B69D',5,NULL,'IN_STOCK','GRN','XYZ539532015','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2136,'XYZ-1767592407715-06798FFB',5,NULL,'IN_STOCK','GRN','XYZ713301277','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2137,'XYZ-1767592407742-7772CBC1',5,NULL,'IN_STOCK','GRN','XYZ753615854','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2138,'XYZ-1767592407767-D518E1D3',5,NULL,'IN_STOCK','GRN','XYZ855328520','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2139,'XYZ-1767592407793-76D54EE6',5,NULL,'IN_STOCK','GRN','XYZ904524205','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2140,'XYZ-1767592407818-F533508E',5,NULL,'IN_STOCK','GRN','XYZ627900793','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2141,'XYZ-1767592407843-F9964DB9',5,NULL,'IN_STOCK','GRN','XYZ933166344','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2142,'XYZ-1767592407865-6D3D5703',5,NULL,'IN_STOCK','GRN','XYZ078535956','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2143,'XYZ-1767592407891-DB16B78E',5,NULL,'IN_STOCK','GRN','XYZ471181572','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2144,'XYZ-1767592407915-F1CD1834',5,NULL,'IN_STOCK','GRN','XYZ592972395','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2145,'XYZ-1767592407938-5BE1D5F6',5,NULL,'IN_STOCK','GRN','XYZ846761967','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2146,'XYZ-1767592407961-8ADFC48B',5,NULL,'IN_STOCK','GRN','XYZ923944907','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2147,'XYZ-1767592407983-4F13AA4D',5,NULL,'IN_STOCK','GRN','XYZ656662775','2026-01-05 05:53:27','2026-01-05 05:53:27'),(2148,'XYZ-1767592408005-6D7B83A2',5,NULL,'IN_STOCK','GRN','XYZ328286536','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2149,'XYZ-1767592408028-3769F134',5,NULL,'IN_STOCK','GRN','XYZ538150603','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2150,'XYZ-1767592408054-FDFBB977',5,NULL,'IN_STOCK','GRN','XYZ049522855','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2151,'XYZ-1767592408077-0D5DE661',5,NULL,'IN_STOCK','GRN','XYZ961039358','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2152,'XYZ-1767592408099-7B71F087',5,NULL,'IN_STOCK','GRN','XYZ992536427','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2153,'XYZ-1767592408122-3E436BAF',5,NULL,'IN_STOCK','GRN','XYZ099373229','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2154,'XYZ-1767592408143-8842BE6E',5,NULL,'IN_STOCK','GRN','XYZ982816948','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2155,'XYZ-1767592408165-7765810D',5,NULL,'IN_STOCK','GRN','XYZ550792984','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2156,'XYZ-1767592408188-C5DC22F6',5,NULL,'IN_STOCK','GRN','XYZ841479853','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2157,'XYZ-1767592408212-9CF673FD',5,NULL,'IN_STOCK','GRN','XYZ635645267','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2158,'XYZ-1767592408237-F2E8AD2E',5,NULL,'IN_STOCK','GRN','XYZ716733546','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2159,'XYZ-1767592408266-7C89AC4B',5,NULL,'IN_STOCK','GRN','XYZ618380134','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2160,'XYZ-1767592408292-2B612E33',5,NULL,'IN_STOCK','GRN','XYZ399780906','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2161,'XYZ-1767592408314-79400666',5,NULL,'IN_STOCK','GRN','XYZ486061634','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2162,'XYZ-1767592408340-D87C90B7',5,NULL,'IN_STOCK','GRN','XYZ611023130','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2163,'XYZ-1767592408364-5A1911F5',5,NULL,'IN_STOCK','GRN','XYZ012335406','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2164,'XYZ-1767592408387-4746F212',5,NULL,'IN_STOCK','GRN','XYZ552572974','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2165,'XYZ-1767592408409-624F9072',5,NULL,'IN_STOCK','GRN','XYZ588307273','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2166,'XYZ-1767592408431-CC1417D0',5,NULL,'IN_STOCK','GRN','XYZ225108281','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2167,'XYZ-1767592408455-A23466FC',5,NULL,'IN_STOCK','GRN','XYZ013566335','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2168,'XYZ-1767592408476-6E0A5A5F',5,NULL,'IN_STOCK','GRN','XYZ792215816','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2169,'XYZ-1767592408501-33B66007',5,NULL,'IN_STOCK','GRN','XYZ211829542','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2170,'XYZ-1767592408527-6C28D7DE',5,NULL,'IN_STOCK','GRN','XYZ584587503','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2171,'XYZ-1767592408549-CB4E4C49',5,NULL,'IN_STOCK','GRN','XYZ903666170','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2172,'XYZ-1767592408571-8BFB9B9D',5,NULL,'IN_STOCK','GRN','XYZ376459368','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2173,'XYZ-1767592408594-47F91B62',5,NULL,'IN_STOCK','GRN','XYZ915787509','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2174,'XYZ-1767592408617-5C3342B9',5,NULL,'IN_STOCK','GRN','XYZ549183371','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2175,'XYZ-1767592408641-C8B2145B',5,NULL,'IN_STOCK','GRN','XYZ799253185','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2176,'XYZ-1767592408666-D8B43F71',5,NULL,'IN_STOCK','GRN','XYZ359307898','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2177,'XYZ-1767592408692-F3F1F57D',5,NULL,'IN_STOCK','GRN','XYZ183708992','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2178,'XYZ-1767592408716-2336B088',5,NULL,'IN_STOCK','GRN','XYZ075492787','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2179,'XYZ-1767592408741-55929BF5',5,NULL,'IN_STOCK','GRN','XYZ101740974','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2180,'XYZ-1767592408765-60EA2FDD',5,NULL,'IN_STOCK','GRN','XYZ038554668','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2181,'XYZ-1767592408792-6A6B430E',5,NULL,'IN_STOCK','GRN','XYZ074708104','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2182,'XYZ-1767592408816-3C9098E9',5,NULL,'IN_STOCK','GRN','XYZ182187700','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2183,'XYZ-1767592408842-EF42187D',5,NULL,'IN_STOCK','GRN','XYZ950605965','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2184,'XYZ-1767592408867-A50C9D49',5,NULL,'IN_STOCK','GRN','XYZ399380652','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2185,'XYZ-1767592408892-4CDC46C4',5,NULL,'IN_STOCK','GRN','XYZ986139823','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2186,'XYZ-1767592408917-90839EB0',5,NULL,'IN_STOCK','GRN','XYZ581819898','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2187,'XYZ-1767592408940-B20B17E1',5,NULL,'IN_STOCK','GRN','XYZ076093493','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2188,'XYZ-1767592408963-58208A5D',5,NULL,'IN_STOCK','GRN','XYZ885322737','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2189,'XYZ-1767592408985-17288968',5,NULL,'IN_STOCK','GRN','XYZ204667183','2026-01-05 05:53:28','2026-01-05 05:53:28'),(2190,'XYZ-1767592409010-5D7BAA07',5,NULL,'IN_STOCK','GRN','XYZ007345061','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2191,'XYZ-1767592409037-EF04E33F',5,NULL,'IN_STOCK','GRN','XYZ006440544','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2192,'XYZ-1767592409058-892B1EB1',5,NULL,'IN_STOCK','GRN','XYZ626599976','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2193,'XYZ-1767592409081-7081B65A',5,NULL,'IN_STOCK','GRN','XYZ688768743','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2194,'XYZ-1767592409102-8CCA5EE4',5,NULL,'IN_STOCK','GRN','XYZ408804115','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2195,'XYZ-1767592409124-3C32D2F2',5,NULL,'IN_STOCK','GRN','XYZ219904646','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2196,'XYZ-1767592409146-2AB2D3C3',5,NULL,'IN_STOCK','GRN','XYZ090687904','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2197,'XYZ-1767592409169-6902EACF',5,NULL,'IN_STOCK','GRN','XYZ402123127','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2198,'XYZ-1767592409191-EF626299',5,NULL,'IN_STOCK','GRN','XYZ715057346','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2199,'XYZ-1767592409216-0EA3798D',5,NULL,'IN_STOCK','GRN','XYZ880491875','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2200,'XYZ-1767592409238-5ED012B7',5,NULL,'IN_STOCK','GRN','XYZ873551552','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2201,'XYZ-1767592409263-35A57CE9',5,NULL,'IN_STOCK','GRN','XYZ956014131','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2202,'XYZ-1767592409288-01F9AEE5',5,NULL,'IN_STOCK','GRN','XYZ394056953','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2203,'XYZ-1767592409310-3A15EBB1',5,NULL,'IN_STOCK','GRN','XYZ199145154','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2204,'XYZ-1767592409331-60D9CF77',5,NULL,'IN_STOCK','GRN','XYZ473424695','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2205,'XYZ-1767592409353-3D42D796',5,NULL,'IN_STOCK','GRN','XYZ749047273','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2206,'XYZ-1767592409374-7AD4F767',5,NULL,'IN_STOCK','GRN','XYZ512635382','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2207,'XYZ-1767592409424-02696053',5,NULL,'IN_STOCK','GRN','XYZ545035805','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2208,'XYZ-1767592409445-D995D20F',5,NULL,'IN_STOCK','GRN','XYZ908180222','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2209,'XYZ-1767592409467-84193AB3',5,NULL,'IN_STOCK','GRN','XYZ065948897','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2210,'XYZ-1767592409493-4A4C1BFC',5,NULL,'IN_STOCK','GRN','XYZ479728640','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2211,'XYZ-1767592409520-0E23E660',5,NULL,'IN_STOCK','GRN','XYZ300607460','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2212,'XYZ-1767592409544-690AAA39',5,NULL,'IN_STOCK','GRN','XYZ299008426','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2213,'XYZ-1767592409566-C3E85641',5,NULL,'IN_STOCK','GRN','XYZ770178529','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2214,'XYZ-1767592409593-349132D0',5,NULL,'IN_STOCK','GRN','XYZ906144789','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2215,'XYZ-1767592409619-5321501F',5,NULL,'IN_STOCK','GRN','XYZ408496891','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2216,'XYZ-1767592409646-70ADFFF3',5,NULL,'IN_STOCK','GRN','XYZ495472543','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2217,'XYZ-1767592409673-6602C43B',5,NULL,'IN_STOCK','GRN','XYZ686722603','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2218,'XYZ-1767592409698-C4D31778',5,NULL,'IN_STOCK','GRN','XYZ321511925','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2219,'XYZ-1767592409726-CA179488',5,NULL,'IN_STOCK','GRN','XYZ010432004','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2220,'XYZ-1767592409753-F0E53078',5,NULL,'IN_STOCK','GRN','XYZ776660631','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2221,'XYZ-1767592409779-56DAF1F5',5,NULL,'IN_STOCK','GRN','XYZ607254191','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2222,'XYZ-1767592409805-DD5F4F25',5,NULL,'IN_STOCK','GRN','XYZ820579357','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2223,'XYZ-1767592409830-8D3F9A0B',5,NULL,'IN_STOCK','GRN','XYZ986105407','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2224,'XYZ-1767592409855-6813222F',5,NULL,'IN_STOCK','GRN','XYZ705935073','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2225,'XYZ-1767592409879-E6DDFE78',5,NULL,'IN_STOCK','GRN','XYZ069224518','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2226,'XYZ-1767592409902-ED162869',5,NULL,'IN_STOCK','GRN','XYZ067117894','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2227,'XYZ-1767592409925-085109D4',5,NULL,'IN_STOCK','GRN','XYZ143044607','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2228,'XYZ-1767592409947-D605B90B',5,NULL,'IN_STOCK','GRN','XYZ113455552','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2229,'XYZ-1767592409968-C8F6D396',5,NULL,'IN_STOCK','GRN','XYZ197719459','2026-01-05 05:53:29','2026-01-05 05:53:29'),(2230,'XYZ-1767592409993-2FC6FF6B',5,NULL,'IN_STOCK','GRN','XYZ670712055','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2231,'XYZ-1767592410019-BDAFA983',5,NULL,'IN_STOCK','GRN','XYZ531642564','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2232,'XYZ-1767592410046-EFF1EBBB',5,NULL,'IN_STOCK','GRN','XYZ788336743','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2233,'XYZ-1767592410072-7869B602',5,NULL,'IN_STOCK','GRN','XYZ414787074','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2234,'XYZ-1767592410096-5857DD06',5,NULL,'IN_STOCK','GRN','XYZ659815793','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2235,'XYZ-1767592410123-886A1CB4',5,NULL,'IN_STOCK','GRN','XYZ834272514','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2236,'XYZ-1767592410147-2B8F041C',5,NULL,'IN_STOCK','GRN','XYZ649477107','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2237,'XYZ-1767592410173-B8153C4A',5,NULL,'IN_STOCK','GRN','XYZ073958084','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2238,'XYZ-1767592410199-E5D56F1D',5,NULL,'IN_STOCK','GRN','XYZ980233705','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2239,'XYZ-1767592410224-B1B52991',5,NULL,'IN_STOCK','GRN','XYZ162312955','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2240,'XYZ-1767592410247-25267CE4',5,NULL,'IN_STOCK','GRN','XYZ687541888','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2241,'XYZ-1767592410272-660CB244',5,NULL,'IN_STOCK','GRN','XYZ638562229','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2242,'XYZ-1767592410297-73072D04',5,NULL,'IN_STOCK','GRN','XYZ515286989','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2243,'XYZ-1767592410325-042AAACB',5,NULL,'IN_STOCK','GRN','XYZ332704956','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2244,'XYZ-1767592410356-4A9AD8CA',5,NULL,'IN_STOCK','GRN','XYZ707416461','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2245,'XYZ-1767592410393-E23AE9D4',5,NULL,'IN_STOCK','GRN','XYZ692067899','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2246,'XYZ-1767592410429-25426D09',5,NULL,'IN_STOCK','GRN','XYZ594268871','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2247,'XYZ-1767592410464-0A4AFB27',5,NULL,'IN_STOCK','GRN','XYZ344433956','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2248,'XYZ-1767592410494-F07AEB94',5,NULL,'IN_STOCK','GRN','XYZ208990211','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2249,'XYZ-1767592410523-197F212F',5,NULL,'IN_STOCK','GRN','XYZ163157733','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2250,'XYZ-1767592410555-10F7F622',5,NULL,'IN_STOCK','GRN','XYZ212051172','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2251,'XYZ-1767592410583-80FC476D',5,NULL,'IN_STOCK','GRN','XYZ613106431','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2252,'XYZ-1767592410609-79BF1BD9',5,NULL,'IN_STOCK','GRN','XYZ940144700','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2253,'XYZ-1767592410635-5F18EB40',5,NULL,'IN_STOCK','GRN','XYZ565735934','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2254,'XYZ-1767592410659-207D2AEE',5,NULL,'IN_STOCK','GRN','XYZ007780716','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2255,'XYZ-1767592410682-AB5B6A81',5,NULL,'IN_STOCK','GRN','XYZ851974641','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2256,'XYZ-1767592410704-0986A8A6',5,NULL,'IN_STOCK','GRN','XYZ916455540','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2257,'XYZ-1767592410726-FA31C8B2',5,NULL,'IN_STOCK','GRN','XYZ782956463','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2258,'XYZ-1767592410751-1AD213BB',5,NULL,'IN_STOCK','GRN','XYZ613980144','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2259,'XYZ-1767592410778-25553896',5,NULL,'IN_STOCK','GRN','XYZ127111608','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2260,'XYZ-1767592410805-DC012066',5,NULL,'IN_STOCK','GRN','XYZ068041047','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2261,'XYZ-1767592410830-887609FB',5,NULL,'IN_STOCK','GRN','XYZ127329715','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2262,'XYZ-1767592410858-5FBE3634',5,NULL,'IN_STOCK','GRN','XYZ997959590','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2263,'XYZ-1767592410884-D040A2CA',5,NULL,'IN_STOCK','GRN','XYZ035125236','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2264,'XYZ-1767592410912-713E6E53',5,NULL,'IN_STOCK','GRN','XYZ806833889','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2265,'XYZ-1767592410936-0B2B5013',5,NULL,'IN_STOCK','GRN','XYZ779408336','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2266,'XYZ-1767592410961-45E4C76F',5,NULL,'IN_STOCK','GRN','XYZ612280438','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2267,'XYZ-1767592410987-85FC8189',5,NULL,'IN_STOCK','GRN','XYZ470719950','2026-01-05 05:53:30','2026-01-05 05:53:30'),(2268,'XYZ-1767592411013-71627F1A',5,NULL,'IN_STOCK','GRN','XYZ861379649','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2269,'XYZ-1767592411039-DE6513B7',5,NULL,'IN_STOCK','GRN','XYZ252990113','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2270,'XYZ-1767592411063-71C82C8B',5,NULL,'IN_STOCK','GRN','XYZ480434167','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2271,'XYZ-1767592411085-5C2067D4',5,NULL,'IN_STOCK','GRN','XYZ435994664','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2272,'XYZ-1767592411110-2A8100D3',5,NULL,'IN_STOCK','GRN','XYZ222982069','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2273,'XYZ-1767592411131-869C828F',5,NULL,'IN_STOCK','GRN','XYZ053975386','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2274,'XYZ-1767592411154-1ECBF9D9',5,NULL,'IN_STOCK','GRN','XYZ569459157','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2275,'XYZ-1767592411179-D123AF44',5,NULL,'IN_STOCK','GRN','XYZ672561906','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2276,'XYZ-1767592411206-8E736FFA',5,NULL,'IN_STOCK','GRN','XYZ771181103','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2277,'XYZ-1767592411233-0DA18BAE',5,NULL,'IN_STOCK','GRN','XYZ858180487','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2278,'XYZ-1767592411258-C37AF8CA',5,NULL,'IN_STOCK','GRN','XYZ143221643','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2279,'XYZ-1767592411282-6E898C77',5,NULL,'IN_STOCK','GRN','XYZ151742440','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2280,'XYZ-1767592411309-7BF7C820',5,NULL,'IN_STOCK','GRN','XYZ741816371','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2281,'XYZ-1767592411336-0CBAB36A',5,NULL,'IN_STOCK','GRN','XYZ157554233','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2282,'XYZ-1767592411363-75AD18CB',5,NULL,'IN_STOCK','GRN','XYZ980558089','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2283,'XYZ-1767592411388-4A1BDE55',5,NULL,'IN_STOCK','GRN','XYZ802489294','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2284,'XYZ-1767592411416-C83FFB72',5,NULL,'IN_STOCK','GRN','XYZ184315216','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2285,'XYZ-1767592411447-2678F3DF',5,NULL,'IN_STOCK','GRN','XYZ730005901','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2286,'XYZ-1767592411478-4F9B0327',5,NULL,'IN_STOCK','GRN','XYZ498654713','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2287,'XYZ-1767592411506-9C97A689',5,NULL,'IN_STOCK','GRN','XYZ371640158','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2288,'XYZ-1767592411538-23DE12F0',5,NULL,'IN_STOCK','GRN','XYZ539446910','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2289,'XYZ-1767592411567-183B17CC',5,NULL,'IN_STOCK','GRN','XYZ931166438','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2290,'XYZ-1767592411597-A3C7FEFD',5,NULL,'IN_STOCK','GRN','XYZ036929658','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2291,'XYZ-1767592411625-B3F6581A',5,NULL,'IN_STOCK','GRN','XYZ780826941','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2292,'XYZ-1767592411652-53949367',5,NULL,'IN_STOCK','GRN','XYZ342363309','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2293,'XYZ-1767592411679-487E40E8',5,NULL,'IN_STOCK','GRN','XYZ780350010','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2294,'XYZ-1767592411705-5EEE5100',5,NULL,'IN_STOCK','GRN','XYZ122486538','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2295,'XYZ-1767592411734-F1AB9F87',5,NULL,'IN_STOCK','GRN','XYZ843085772','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2296,'XYZ-1767592411760-4F610CA3',5,NULL,'IN_STOCK','GRN','XYZ084175808','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2297,'XYZ-1767592411791-6728BBE6',5,NULL,'IN_STOCK','GRN','XYZ124056323','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2298,'XYZ-1767592411813-B5D9046C',5,NULL,'IN_STOCK','GRN','XYZ175598162','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2299,'XYZ-1767592411835-ABFFF0BD',5,NULL,'IN_STOCK','GRN','XYZ897079210','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2300,'XYZ-1767592411857-4CF9E240',5,NULL,'IN_STOCK','GRN','XYZ586703344','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2301,'XYZ-1767592411878-C91BA6D2',5,NULL,'IN_STOCK','GRN','XYZ524149055','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2302,'XYZ-1767592411904-B91915A3',5,NULL,'IN_STOCK','GRN','XYZ566988885','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2303,'XYZ-1767592411931-9B8FD6EA',5,NULL,'IN_STOCK','GRN','XYZ833087415','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2304,'XYZ-1767592411962-1AF94ECF',5,NULL,'IN_STOCK','GRN','XYZ389407653','2026-01-05 05:53:31','2026-01-05 05:53:31'),(2305,'XYZ-1767592411990-1F15276B',5,NULL,'IN_STOCK','GRN','XYZ288559555','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2306,'XYZ-1767592412016-3547BE22',5,NULL,'IN_STOCK','GRN','XYZ688278150','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2307,'XYZ-1767592412048-58F6877C',5,NULL,'IN_STOCK','GRN','XYZ490777434','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2308,'XYZ-1767592412076-1AA6CC23',5,NULL,'IN_STOCK','GRN','XYZ929508224','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2309,'XYZ-1767592412104-CB937225',5,NULL,'IN_STOCK','GRN','XYZ990086725','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2310,'XYZ-1767592412131-82ED99FB',5,NULL,'IN_STOCK','GRN','XYZ252508796','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2311,'XYZ-1767592412159-B3C6B8A0',5,NULL,'IN_STOCK','GRN','XYZ843284060','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2312,'XYZ-1767592412188-2E15C3D1',5,NULL,'IN_STOCK','GRN','XYZ427263376','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2313,'XYZ-1767592412211-1298BBC8',5,NULL,'IN_STOCK','GRN','XYZ836594989','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2314,'XYZ-1767592412239-66C67C4C',5,NULL,'IN_STOCK','GRN','XYZ401066645','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2315,'XYZ-1767592412262-2097F553',5,NULL,'IN_STOCK','GRN','XYZ200576724','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2316,'XYZ-1767592412293-A26783BB',5,NULL,'IN_STOCK','GRN','XYZ255844960','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2317,'XYZ-1767592412321-50F56BAC',5,NULL,'IN_STOCK','GRN','XYZ039669569','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2318,'XYZ-1767592412347-BCC82F0D',5,NULL,'IN_STOCK','GRN','XYZ864090989','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2319,'XYZ-1767592412366-BD8441D1',5,NULL,'IN_STOCK','GRN','XYZ931049015','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2320,'XYZ-1767592412389-AB8F7D97',5,NULL,'IN_STOCK','GRN','XYZ672442636','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2321,'XYZ-1767592412416-ACE10A40',5,NULL,'IN_STOCK','GRN','XYZ817902759','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2322,'XYZ-1767592412439-72C53EA5',5,NULL,'IN_STOCK','GRN','XYZ623798595','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2323,'XYZ-1767592412460-09BA6378',5,NULL,'IN_STOCK','GRN','XYZ412326831','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2324,'XYZ-1767592412485-780E191A',5,NULL,'IN_STOCK','GRN','XYZ006366368','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2325,'XYZ-1767592412510-9DDE8C47',5,NULL,'IN_STOCK','GRN','XYZ580702899','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2326,'XYZ-1767592412537-90BE36E9',5,NULL,'IN_STOCK','GRN','XYZ738766450','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2327,'XYZ-1767592412561-A9A59DC7',5,NULL,'IN_STOCK','GRN','XYZ656298936','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2328,'XYZ-1767592412586-34B80953',5,NULL,'IN_STOCK','GRN','XYZ022227891','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2329,'XYZ-1767592412609-2A984CF4',5,NULL,'IN_STOCK','GRN','XYZ377191877','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2330,'XYZ-1767592412633-9248244B',5,NULL,'IN_STOCK','GRN','XYZ918569750','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2331,'XYZ-1767592412658-5941ECD8',5,NULL,'IN_STOCK','GRN','XYZ211853473','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2332,'XYZ-1767592412684-89F767FA',5,NULL,'IN_STOCK','GRN','XYZ136642098','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2333,'XYZ-1767592412709-B655A7CB',5,NULL,'IN_STOCK','GRN','XYZ613123361','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2334,'XYZ-1767592412731-CEAFFA35',5,NULL,'IN_STOCK','GRN','XYZ719980600','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2335,'XYZ-1767592412752-D4D8CB7E',5,NULL,'IN_STOCK','GRN','XYZ885580751','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2336,'XYZ-1767592412776-8FF11005',5,NULL,'IN_STOCK','GRN','XYZ285020836','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2337,'XYZ-1767592412800-AFF2161A',5,NULL,'IN_STOCK','GRN','XYZ508375425','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2338,'XYZ-1767592412821-F711FF66',5,NULL,'IN_STOCK','GRN','XYZ709766924','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2339,'XYZ-1767592412843-2032E576',5,NULL,'IN_STOCK','GRN','XYZ558732953','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2340,'XYZ-1767592412867-E85CA6BC',5,NULL,'IN_STOCK','GRN','XYZ418591775','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2341,'XYZ-1767592412887-583F326A',5,NULL,'IN_STOCK','GRN','XYZ461401173','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2342,'XYZ-1767592412909-A62EFBF3',5,NULL,'IN_STOCK','GRN','XYZ783759216','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2343,'XYZ-1767592412932-3529A61D',5,NULL,'IN_STOCK','GRN','XYZ460714911','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2344,'XYZ-1767592412958-35157A64',5,NULL,'IN_STOCK','GRN','XYZ260275244','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2345,'XYZ-1767592412984-00E52EF1',5,NULL,'IN_STOCK','GRN','XYZ227844721','2026-01-05 05:53:32','2026-01-05 05:53:32'),(2346,'XYZ-1767592413011-9D950736',5,NULL,'IN_STOCK','GRN','XYZ332607767','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2347,'XYZ-1767592413037-823CB607',5,NULL,'IN_STOCK','GRN','XYZ622615091','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2348,'XYZ-1767592413066-8294F92E',5,NULL,'IN_STOCK','GRN','XYZ634973217','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2349,'XYZ-1767592413093-0C8D8577',5,NULL,'IN_STOCK','GRN','XYZ593475301','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2350,'XYZ-1767592413123-4997C91A',5,NULL,'IN_STOCK','GRN','XYZ159714235','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2351,'XYZ-1767592413148-FD986EB0',5,NULL,'IN_STOCK','GRN','XYZ783669408','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2352,'XYZ-1767592413176-00FA57E9',5,NULL,'IN_STOCK','GRN','XYZ932384497','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2353,'XYZ-1767592413200-D400CD71',5,NULL,'IN_STOCK','GRN','XYZ421426928','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2354,'XYZ-1767592413225-29ACE8F2',5,NULL,'IN_STOCK','GRN','XYZ793376005','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2355,'XYZ-1767592413252-7C498A7A',5,NULL,'IN_STOCK','GRN','XYZ274439442','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2356,'XYZ-1767592413280-DB4862CC',5,NULL,'IN_STOCK','GRN','XYZ789992008','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2357,'XYZ-1767592413311-30B1E978',5,NULL,'IN_STOCK','GRN','XYZ026032750','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2358,'XYZ-1767592413340-BCD3B5BD',5,NULL,'IN_STOCK','GRN','XYZ849327693','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2359,'XYZ-1767592413365-1AC9A460',5,NULL,'IN_STOCK','GRN','XYZ655520971','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2360,'XYZ-1767592413394-3953CB92',5,NULL,'IN_STOCK','GRN','XYZ290862704','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2361,'XYZ-1767592413419-9ECA4853',5,NULL,'IN_STOCK','GRN','XYZ717081231','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2362,'XYZ-1767592413445-29907396',5,NULL,'IN_STOCK','GRN','XYZ196271158','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2363,'XYZ-1767592413471-3E833611',5,NULL,'IN_STOCK','GRN','XYZ833342947','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2364,'XYZ-1767592413495-258FFA09',5,NULL,'IN_STOCK','GRN','XYZ389197769','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2365,'XYZ-1767592413520-3A12D321',5,NULL,'IN_STOCK','GRN','XYZ736583833','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2366,'XYZ-1767592413548-6D050798',5,NULL,'IN_STOCK','GRN','XYZ488606528','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2367,'XYZ-1767592413576-DE36A8ED',5,NULL,'IN_STOCK','GRN','XYZ174093833','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2368,'XYZ-1767592413602-001FF035',5,NULL,'IN_STOCK','GRN','XYZ823955120','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2369,'XYZ-1767592413631-AC2DF096',5,NULL,'IN_STOCK','GRN','XYZ955497627','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2370,'XYZ-1767592413659-CBA671A9',5,NULL,'IN_STOCK','GRN','XYZ119728472','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2371,'XYZ-1767592413684-698603F7',5,NULL,'IN_STOCK','GRN','XYZ250782092','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2372,'XYZ-1767592413711-F44D1332',5,NULL,'IN_STOCK','GRN','XYZ727447616','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2373,'XYZ-1767592413739-DA599938',5,NULL,'IN_STOCK','GRN','XYZ097522126','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2374,'XYZ-1767592413765-192C36EA',5,NULL,'IN_STOCK','GRN','XYZ184737748','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2375,'XYZ-1767592413791-8F41ACB9',5,NULL,'IN_STOCK','GRN','XYZ345407418','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2376,'XYZ-1767592413817-5B2A76E2',5,NULL,'IN_STOCK','GRN','XYZ346192024','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2377,'XYZ-1767592413841-FB4E79CF',5,NULL,'IN_STOCK','GRN','XYZ131541625','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2378,'XYZ-1767592413866-13FDB389',5,NULL,'IN_STOCK','GRN','XYZ493877771','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2379,'XYZ-1767592413887-1D2622F7',5,NULL,'IN_STOCK','GRN','XYZ656094547','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2380,'XYZ-1767592413909-02B7475D',5,NULL,'IN_STOCK','GRN','XYZ596123487','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2381,'XYZ-1767592413933-437B3E87',5,NULL,'IN_STOCK','GRN','XYZ028021600','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2382,'XYZ-1767592413962-5B62BDD7',5,NULL,'IN_STOCK','GRN','XYZ352892967','2026-01-05 05:53:33','2026-01-05 05:53:33'),(2383,'XYZ-1767592413990-F4B9AED8',5,NULL,'IN_STOCK','GRN','XYZ970854717','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2384,'XYZ-1767592414013-062C80FB',5,NULL,'IN_STOCK','GRN','XYZ219732846','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2385,'XYZ-1767592414034-47130494',5,NULL,'IN_STOCK','GRN','XYZ229231160','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2386,'XYZ-1767592414056-3CF27DA9',5,NULL,'IN_STOCK','GRN','XYZ594429207','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2387,'XYZ-1767592414084-BD62D957',5,NULL,'IN_STOCK','GRN','XYZ388272018','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2388,'XYZ-1767592414105-C296A383',5,NULL,'IN_STOCK','GRN','XYZ999171974','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2389,'XYZ-1767592414131-DE28B2E6',5,NULL,'IN_STOCK','GRN','XYZ968780683','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2390,'XYZ-1767592414159-F7BC909D',5,NULL,'IN_STOCK','GRN','XYZ758915516','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2391,'XYZ-1767592414185-73D5FE7F',5,NULL,'IN_STOCK','GRN','XYZ656795808','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2392,'XYZ-1767592414210-C6F70DF1',5,NULL,'IN_STOCK','GRN','XYZ069832501','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2393,'XYZ-1767592414234-24D4E635',5,NULL,'IN_STOCK','GRN','XYZ316966046','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2394,'XYZ-1767592414257-4385857B',5,NULL,'IN_STOCK','GRN','XYZ842598627','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2395,'XYZ-1767592414280-19D7C2C5',5,NULL,'IN_STOCK','GRN','XYZ905561730','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2396,'XYZ-1767592414304-D6055E35',5,NULL,'IN_STOCK','GRN','XYZ771280283','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2397,'XYZ-1767592414330-6E0BD56F',5,NULL,'IN_STOCK','GRN','XYZ399189027','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2398,'XYZ-1767592414358-7CD9680A',5,NULL,'IN_STOCK','GRN','XYZ782532861','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2399,'XYZ-1767592414382-39F4F6DC',5,NULL,'IN_STOCK','GRN','XYZ723970781','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2400,'XYZ-1767592414407-EF5691DE',5,NULL,'IN_STOCK','GRN','XYZ396410117','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2401,'XYZ-1767592414430-E69DF1D6',5,NULL,'IN_STOCK','GRN','XYZ323932714','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2402,'XYZ-1767592414457-18474203',5,NULL,'IN_STOCK','GRN','XYZ719157166','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2403,'XYZ-1767592414486-9E74E586',5,NULL,'IN_STOCK','GRN','XYZ165922612','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2404,'XYZ-1767592414512-E3640C38',5,NULL,'IN_STOCK','GRN','XYZ040313672','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2405,'XYZ-1767592414540-B6AB902F',5,NULL,'IN_STOCK','GRN','XYZ360959826','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2406,'XYZ-1767592414568-2F9C889D',5,NULL,'IN_STOCK','GRN','XYZ008551159','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2407,'XYZ-1767592414596-9DD5BD79',5,NULL,'IN_STOCK','GRN','XYZ041644851','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2408,'XYZ-1767592414624-A8D3C31F',5,NULL,'IN_STOCK','GRN','XYZ769071793','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2409,'XYZ-1767592414652-E7577755',5,NULL,'IN_STOCK','GRN','XYZ415731029','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2410,'XYZ-1767592414679-D194A0D9',5,NULL,'IN_STOCK','GRN','XYZ169280472','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2411,'XYZ-1767592414706-B4FA2563',5,NULL,'IN_STOCK','GRN','XYZ014301211','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2412,'XYZ-1767592414731-AD7E767D',5,NULL,'IN_STOCK','GRN','XYZ319559868','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2413,'XYZ-1767592414754-12BEA8A0',5,NULL,'IN_STOCK','GRN','XYZ504302719','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2414,'XYZ-1767592414779-57C8D493',5,NULL,'IN_STOCK','GRN','XYZ965217012','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2415,'XYZ-1767592414804-DAE6B261',5,NULL,'IN_STOCK','GRN','XYZ141819276','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2416,'XYZ-1767592414832-7DB356C0',5,NULL,'IN_STOCK','GRN','XYZ540889423','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2417,'XYZ-1767592414857-1F3EB38D',5,NULL,'IN_STOCK','GRN','XYZ274208534','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2418,'XYZ-1767592414883-101CE42D',5,NULL,'IN_STOCK','GRN','XYZ713185367','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2419,'XYZ-1767592414904-642A627D',5,NULL,'IN_STOCK','GRN','XYZ892890343','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2420,'XYZ-1767592414928-2EED67FC',5,NULL,'IN_STOCK','GRN','XYZ272085796','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2421,'XYZ-1767592414954-81AB9ED2',5,NULL,'IN_STOCK','GRN','XYZ894199284','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2422,'XYZ-1767592414979-7E48DDBB',5,NULL,'IN_STOCK','GRN','XYZ856401142','2026-01-05 05:53:34','2026-01-05 05:53:34'),(2423,'XYZ-1767592415007-1243D18B',5,NULL,'IN_STOCK','GRN','XYZ392312807','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2424,'XYZ-1767592415029-CC593E6F',5,NULL,'IN_STOCK','GRN','XYZ048821413','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2425,'XYZ-1767592415053-973A7191',5,NULL,'IN_STOCK','GRN','XYZ906205244','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2426,'XYZ-1767592415077-032E4560',5,NULL,'IN_STOCK','GRN','XYZ201466184','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2427,'XYZ-1767592415101-AB3CA50C',5,NULL,'IN_STOCK','GRN','XYZ998324057','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2428,'XYZ-1767592415124-79722480',5,NULL,'IN_STOCK','GRN','XYZ921532411','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2429,'XYZ-1767592415151-F4A09D69',5,NULL,'IN_STOCK','GRN','XYZ585518539','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2430,'XYZ-1767592415177-C80CF526',5,NULL,'IN_STOCK','GRN','XYZ364644782','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2431,'XYZ-1767592415203-FD973CCE',5,NULL,'IN_STOCK','GRN','XYZ575158638','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2432,'XYZ-1767592415224-EE02CC44',5,NULL,'IN_STOCK','GRN','XYZ597948472','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2433,'XYZ-1767592415245-2E0B061E',5,NULL,'IN_STOCK','GRN','XYZ574638080','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2434,'XYZ-1767592415267-D9A51A03',5,NULL,'IN_STOCK','GRN','XYZ763593529','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2435,'XYZ-1767592415296-837BC330',5,NULL,'IN_STOCK','GRN','XYZ319865704','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2436,'XYZ-1767592415323-9CBD3002',5,NULL,'IN_STOCK','GRN','XYZ505221972','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2437,'XYZ-1767592415353-4093B360',5,NULL,'IN_STOCK','GRN','XYZ672059713','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2438,'XYZ-1767592415382-AAFFA008',5,NULL,'IN_STOCK','GRN','XYZ581638661','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2439,'XYZ-1767592415410-1F1EC94B',5,NULL,'IN_STOCK','GRN','XYZ026752381','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2440,'XYZ-1767592415440-C78E38D7',5,NULL,'IN_STOCK','GRN','XYZ116086907','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2441,'XYZ-1767592415469-4D08B7E3',5,NULL,'IN_STOCK','GRN','XYZ728850559','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2442,'XYZ-1767592415497-B0645E2C',5,NULL,'IN_STOCK','GRN','XYZ259087311','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2443,'XYZ-1767592415525-616A3CE9',5,NULL,'IN_STOCK','GRN','XYZ710001027','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2444,'XYZ-1767592415553-A6F3D813',5,NULL,'IN_STOCK','GRN','XYZ150039293','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2445,'XYZ-1767592415582-24565FD1',5,NULL,'IN_STOCK','GRN','XYZ426002263','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2446,'XYZ-1767592415637-5B8E99BB',5,NULL,'IN_STOCK','GRN','XYZ866868446','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2447,'XYZ-1767592415677-9EA98283',5,NULL,'IN_STOCK','GRN','XYZ872103266','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2448,'XYZ-1767592415704-1814C00C',5,NULL,'IN_STOCK','GRN','XYZ762059939','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2449,'XYZ-1767592415731-906CD869',5,NULL,'IN_STOCK','GRN','XYZ553943863','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2450,'XYZ-1767592415759-B1855A8D',5,NULL,'IN_STOCK','GRN','XYZ381999872','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2451,'XYZ-1767592415783-65F7E4FA',5,NULL,'IN_STOCK','GRN','XYZ393414441','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2452,'XYZ-1767592415807-8ACAB9AD',5,NULL,'IN_STOCK','GRN','XYZ198918487','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2453,'XYZ-1767592415831-EA2BEADD',5,NULL,'IN_STOCK','GRN','XYZ179917272','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2454,'XYZ-1767592415852-13345ED8',5,NULL,'IN_STOCK','GRN','XYZ629719941','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2455,'XYZ-1767592415879-4CD2D09C',5,NULL,'IN_STOCK','GRN','XYZ967838701','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2456,'XYZ-1767592415905-109AE990',5,NULL,'IN_STOCK','GRN','XYZ068162474','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2457,'XYZ-1767592415930-0FBA97E5',5,NULL,'IN_STOCK','GRN','XYZ622237977','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2458,'XYZ-1767592415961-B486B9FD',5,NULL,'IN_STOCK','GRN','XYZ828611058','2026-01-05 05:53:35','2026-01-05 05:53:35'),(2459,'XYZ-1767592415990-42319272',5,NULL,'IN_STOCK','GRN','XYZ103952803','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2460,'XYZ-1767592416040-DF131319',5,NULL,'IN_STOCK','GRN','XYZ337624025','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2461,'XYZ-1767592416069-BBD1AEC8',5,NULL,'IN_STOCK','GRN','XYZ592835528','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2462,'XYZ-1767592416091-AC3ABFEC',5,NULL,'IN_STOCK','GRN','XYZ071272114','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2463,'XYZ-1767592416113-08287627',5,NULL,'IN_STOCK','GRN','XYZ085633583','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2464,'XYZ-1767592416135-AC39AB2F',5,NULL,'IN_STOCK','GRN','XYZ549279993','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2465,'XYZ-1767592416159-E3688ADD',5,NULL,'IN_STOCK','GRN','XYZ417546385','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2466,'XYZ-1767592416182-2E7D0B7F',5,NULL,'IN_STOCK','GRN','XYZ446807691','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2467,'XYZ-1767592416208-407DF2B4',5,NULL,'IN_STOCK','GRN','XYZ445364763','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2468,'XYZ-1767592416234-8E35FB01',5,NULL,'IN_STOCK','GRN','XYZ399227547','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2469,'XYZ-1767592416260-0D817D2B',5,NULL,'IN_STOCK','GRN','XYZ838848443','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2470,'XYZ-1767592416286-400E184F',5,NULL,'IN_STOCK','GRN','XYZ385131814','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2471,'XYZ-1767592416310-AE11013D',5,NULL,'IN_STOCK','GRN','XYZ494298314','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2472,'XYZ-1767592416334-EBA21116',5,NULL,'IN_STOCK','GRN','XYZ774497491','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2473,'XYZ-1767592416359-BC8AE9B0',5,NULL,'IN_STOCK','GRN','XYZ082915029','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2474,'XYZ-1767592416378-45EDA920',5,NULL,'IN_STOCK','GRN','XYZ116193510','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2475,'XYZ-1767592416397-FAEBA574',5,NULL,'IN_STOCK','GRN','XYZ318076414','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2476,'XYZ-1767592416416-C56DCE64',5,NULL,'IN_STOCK','GRN','XYZ670873511','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2477,'XYZ-1767592416435-3CC5D913',5,NULL,'IN_STOCK','GRN','XYZ649929328','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2478,'XYZ-1767592416455-AC510ED2',5,NULL,'IN_STOCK','GRN','XYZ681714014','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2479,'XYZ-1767592416474-0AB51345',5,NULL,'IN_STOCK','GRN','XYZ786636323','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2480,'XYZ-1767592416493-EE82E425',5,NULL,'IN_STOCK','GRN','XYZ784820399','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2481,'XYZ-1767592416512-A84E29C6',5,NULL,'IN_STOCK','GRN','XYZ546191756','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2482,'XYZ-1767592416532-157FBA64',5,NULL,'IN_STOCK','GRN','XYZ248576818','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2483,'XYZ-1767592416551-4B16BCAA',5,NULL,'IN_STOCK','GRN','XYZ746839290','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2484,'XYZ-1767592416573-C4131487',5,NULL,'IN_STOCK','GRN','XYZ285061214','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2485,'XYZ-1767592416596-0084FE01',5,NULL,'IN_STOCK','GRN','XYZ902917869','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2486,'XYZ-1767592416619-C97C3558',5,NULL,'IN_STOCK','GRN','XYZ879657662','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2487,'XYZ-1767592416643-98290195',5,NULL,'IN_STOCK','GRN','XYZ741830317','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2488,'XYZ-1767592416667-441F78E6',5,NULL,'IN_STOCK','GRN','XYZ802413531','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2489,'XYZ-1767592416693-7E428A43',5,NULL,'IN_STOCK','GRN','XYZ084613131','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2490,'XYZ-1767592416716-F43E64DC',5,NULL,'IN_STOCK','GRN','XYZ815791610','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2491,'XYZ-1767592416739-F8699710',5,NULL,'IN_STOCK','GRN','XYZ952788736','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2492,'XYZ-1767592416762-45985D0E',5,NULL,'IN_STOCK','GRN','XYZ625718535','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2493,'XYZ-1767592416785-FBFDBAD6',5,NULL,'IN_STOCK','GRN','XYZ052769824','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2494,'XYZ-1767592416808-86917B58',5,NULL,'IN_STOCK','GRN','XYZ732811938','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2495,'XYZ-1767592416827-9F50D563',5,NULL,'IN_STOCK','GRN','XYZ732564813','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2496,'XYZ-1767592416851-452BCC86',5,NULL,'IN_STOCK','GRN','XYZ646955805','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2497,'XYZ-1767592416878-92B1185D',5,NULL,'IN_STOCK','GRN','XYZ353303464','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2498,'XYZ-1767592416907-30B74823',5,NULL,'IN_STOCK','GRN','XYZ843674559','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2499,'XYZ-1767592416934-DEA7A2A3',5,NULL,'IN_STOCK','GRN','XYZ057454766','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2500,'XYZ-1767592416961-18C9C19C',5,NULL,'IN_STOCK','GRN','XYZ386618224','2026-01-05 05:53:36','2026-01-05 05:53:36'),(2501,'XYZ-1767592416988-76130FC4',5,NULL,'IN_STOCK','GRN','XYZ986688681','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2502,'XYZ-1767592417015-7E583C0A',5,NULL,'IN_STOCK','GRN','XYZ004231527','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2503,'XYZ-1767592417124-9DAAFD8E',4,NULL,'IN_STOCK','GRN','XYZ805631661','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2504,'XYZ-1767592417151-D4EAC8FA',4,NULL,'IN_STOCK','GRN','XYZ091757636','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2505,'XYZ-1767592417180-04774AF1',4,NULL,'IN_STOCK','GRN','XYZ061573366','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2506,'XYZ-1767592417208-7BDA00D5',4,NULL,'IN_STOCK','GRN','XYZ514850808','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2507,'XYZ-1767592417240-045D26EE',4,NULL,'IN_STOCK','GRN','XYZ700237542','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2508,'XYZ-1767592417271-0C7B5624',4,NULL,'IN_STOCK','GRN','XYZ313650891','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2509,'XYZ-1767592417298-0B0D7752',4,NULL,'IN_STOCK','GRN','XYZ832321669','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2510,'XYZ-1767592417330-9F2A760C',4,NULL,'IN_STOCK','GRN','XYZ828188457','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2511,'XYZ-1767592417361-6CBA694B',4,NULL,'IN_STOCK','GRN','XYZ353136462','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2512,'XYZ-1767592417391-C33E9162',4,NULL,'IN_STOCK','GRN','XYZ141986970','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2513,'XYZ-1767592417421-8C74AE0D',4,NULL,'IN_STOCK','GRN','XYZ099348154','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2514,'XYZ-1767592417451-85378ED7',4,NULL,'IN_STOCK','GRN','XYZ516220536','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2515,'XYZ-1767592417476-F84E11A5',4,NULL,'IN_STOCK','GRN','XYZ974663781','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2516,'XYZ-1767592417504-E630928E',4,NULL,'IN_STOCK','GRN','XYZ292168404','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2517,'XYZ-1767592417529-B147DA28',4,NULL,'IN_STOCK','GRN','XYZ498518800','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2518,'XYZ-1767592417553-7ACF7D7B',4,NULL,'IN_STOCK','GRN','XYZ814197289','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2519,'XYZ-1767592417577-C5311690',4,NULL,'IN_STOCK','GRN','XYZ236708232','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2520,'XYZ-1767592417602-1FE4C002',4,NULL,'IN_STOCK','GRN','XYZ125758624','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2521,'XYZ-1767592417628-650B268B',4,NULL,'IN_STOCK','GRN','XYZ717142423','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2522,'XYZ-1767592417653-A9733A90',4,NULL,'IN_STOCK','GRN','XYZ216551259','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2523,'XYZ-1767592417678-847BD46F',4,NULL,'IN_STOCK','GRN','XYZ952742391','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2524,'XYZ-1767592417710-0ACF2B90',4,NULL,'IN_STOCK','GRN','XYZ379727559','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2525,'XYZ-1767592417738-0C29B742',4,NULL,'IN_STOCK','GRN','XYZ328650447','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2526,'XYZ-1767592417773-08ACB2B7',4,NULL,'IN_STOCK','GRN','XYZ043271928','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2527,'XYZ-1767592417857-49D1845A',4,NULL,'IN_STOCK','GRN','XYZ295606503','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2528,'XYZ-1767592417884-0B998E91',4,NULL,'IN_STOCK','GRN','XYZ579719880','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2529,'XYZ-1767592417907-602543DD',4,NULL,'IN_STOCK','GRN','XYZ678525024','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2530,'XYZ-1767592417931-35034608',4,NULL,'IN_STOCK','GRN','XYZ039208436','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2531,'XYZ-1767592417954-561DCA2F',4,NULL,'IN_STOCK','GRN','XYZ188431452','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2532,'XYZ-1767592417976-FCF2F8A7',4,NULL,'IN_STOCK','GRN','XYZ705981320','2026-01-05 05:53:37','2026-01-05 05:53:37'),(2533,'XYZ-1767592417995-6D05B1F0',4,NULL,'IN_STOCK','GRN','XYZ637609857','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2534,'XYZ-1767592418014-05DD4052',4,NULL,'IN_STOCK','GRN','XYZ776463963','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2535,'XYZ-1767592418032-099C2586',4,NULL,'IN_STOCK','GRN','XYZ264817494','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2536,'XYZ-1767592418050-54687E18',4,NULL,'IN_STOCK','GRN','XYZ330476858','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2537,'XYZ-1767592418073-E55BC11B',4,NULL,'IN_STOCK','GRN','XYZ632520283','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2538,'XYZ-1767592418095-0D64E921',4,NULL,'IN_STOCK','GRN','XYZ074143040','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2539,'XYZ-1767592418120-A4F2907A',4,NULL,'IN_STOCK','GRN','XYZ299828529','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2540,'XYZ-1767592418144-AA6E2639',4,NULL,'IN_STOCK','GRN','XYZ268376958','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2541,'XYZ-1767592418167-C5041FA4',4,NULL,'IN_STOCK','GRN','XYZ600156255','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2542,'XYZ-1767592418188-1EAF73D6',4,NULL,'IN_STOCK','GRN','XYZ949859759','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2543,'XYZ-1767592418214-A2477A2C',4,NULL,'IN_STOCK','GRN','XYZ139965449','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2544,'XYZ-1767592418237-C11EC857',4,NULL,'IN_STOCK','GRN','XYZ438386753','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2545,'XYZ-1767592418261-37DAE13A',4,NULL,'IN_STOCK','GRN','XYZ146925504','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2546,'XYZ-1767592418286-3CF8B645',4,NULL,'IN_STOCK','GRN','XYZ102618493','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2547,'XYZ-1767592418312-B28C5B8D',4,NULL,'IN_STOCK','GRN','XYZ058123730','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2548,'XYZ-1767592418337-CA0649CC',4,NULL,'IN_STOCK','GRN','XYZ922891375','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2549,'XYZ-1767592418357-D9BDD32F',4,NULL,'IN_STOCK','GRN','XYZ353242125','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2550,'XYZ-1767592418378-C768157B',4,NULL,'IN_STOCK','GRN','XYZ247923676','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2551,'XYZ-1767592418401-BAEECDA1',4,NULL,'IN_STOCK','GRN','XYZ295184872','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2552,'XYZ-1767592418429-11BE9A65',4,NULL,'IN_STOCK','GRN','XYZ966534198','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2553,'XYZ-1767592418457-56F5704C',4,NULL,'IN_STOCK','GRN','XYZ919599931','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2554,'XYZ-1767592418484-38C68584',4,NULL,'IN_STOCK','GRN','XYZ435954505','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2555,'XYZ-1767592418511-5EF6EBCD',4,NULL,'IN_STOCK','GRN','XYZ875153827','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2556,'XYZ-1767592418540-10C29BE8',4,NULL,'IN_STOCK','GRN','XYZ193767636','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2557,'XYZ-1767592418567-0E157FF5',4,NULL,'IN_STOCK','GRN','XYZ398023331','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2558,'XYZ-1767592418596-4B399758',4,NULL,'IN_STOCK','GRN','XYZ960050896','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2559,'XYZ-1767592418623-1003A5D3',4,NULL,'IN_STOCK','GRN','XYZ726356048','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2560,'XYZ-1767592418650-2BBF840F',4,NULL,'IN_STOCK','GRN','XYZ405004879','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2561,'XYZ-1767592418678-5122A573',4,NULL,'IN_STOCK','GRN','XYZ849622849','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2562,'XYZ-1767592418705-37C7F1BE',4,NULL,'IN_STOCK','GRN','XYZ209649508','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2563,'XYZ-1767592418731-0461A961',4,NULL,'IN_STOCK','GRN','XYZ747401157','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2564,'XYZ-1767592418757-7F6E208E',4,NULL,'IN_STOCK','GRN','XYZ842053456','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2565,'XYZ-1767592418783-35663CDC',4,NULL,'IN_STOCK','GRN','XYZ829227654','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2566,'XYZ-1767592418811-CD975AAD',4,NULL,'IN_STOCK','GRN','XYZ868419273','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2567,'XYZ-1767592418833-FA8747AF',4,NULL,'IN_STOCK','GRN','XYZ095954188','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2568,'XYZ-1767592418855-6FBBB601',4,NULL,'IN_STOCK','GRN','XYZ782516367','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2569,'XYZ-1767592418880-19B9BF16',4,NULL,'IN_STOCK','GRN','XYZ946964041','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2570,'XYZ-1767592418908-657EA97E',4,NULL,'IN_STOCK','GRN','XYZ342613748','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2571,'XYZ-1767592418936-054A43B4',4,NULL,'IN_STOCK','GRN','XYZ211441466','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2572,'XYZ-1767592418964-787BF418',4,NULL,'IN_STOCK','GRN','XYZ595613953','2026-01-05 05:53:38','2026-01-05 05:53:38'),(2573,'XYZ-1767592418990-D8DED762',4,NULL,'IN_STOCK','GRN','XYZ045722800','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2574,'XYZ-1767592419019-DA14A9F4',4,NULL,'IN_STOCK','GRN','XYZ481195081','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2575,'XYZ-1767592419047-30616D28',4,NULL,'IN_STOCK','GRN','XYZ633581021','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2576,'XYZ-1767592419074-15C7C789',4,NULL,'IN_STOCK','GRN','XYZ059194497','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2577,'XYZ-1767592419100-675240CD',4,NULL,'IN_STOCK','GRN','XYZ804920159','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2578,'XYZ-1767592419126-CEFC5C12',4,NULL,'IN_STOCK','GRN','XYZ614052457','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2579,'XYZ-1767592419153-492DBBF2',4,NULL,'IN_STOCK','GRN','XYZ617666220','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2580,'XYZ-1767592419178-49ECFD40',4,NULL,'IN_STOCK','GRN','XYZ988740204','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2581,'XYZ-1767592419205-409E8687',4,NULL,'IN_STOCK','GRN','XYZ757115201','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2582,'XYZ-1767592419230-7506EBDC',4,NULL,'IN_STOCK','GRN','XYZ580047924','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2583,'XYZ-1767592419258-F9D0AC9F',4,NULL,'IN_STOCK','GRN','XYZ123190795','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2584,'XYZ-1767592419285-DD45B8B5',4,NULL,'IN_STOCK','GRN','XYZ702377583','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2585,'XYZ-1767592419321-357FD4E1',4,NULL,'IN_STOCK','GRN','XYZ972946206','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2586,'XYZ-1767592419350-DF7F6CCF',4,NULL,'IN_STOCK','GRN','XYZ815913510','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2587,'XYZ-1767592419379-9D4E9B41',4,NULL,'IN_STOCK','GRN','XYZ227797278','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2588,'XYZ-1767592419410-A2ACA1D1',4,NULL,'IN_STOCK','GRN','XYZ659839541','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2589,'XYZ-1767592419436-718ADF4F',4,NULL,'IN_STOCK','GRN','XYZ791078012','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2590,'XYZ-1767592419462-CC11818B',4,NULL,'IN_STOCK','GRN','XYZ498890413','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2591,'XYZ-1767592419485-A06F6E7A',4,NULL,'IN_STOCK','GRN','XYZ701125267','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2592,'XYZ-1767592419509-7407854F',4,NULL,'IN_STOCK','GRN','XYZ583228749','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2593,'XYZ-1767592419535-DBD7C3E8',4,NULL,'IN_STOCK','GRN','XYZ357633887','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2594,'XYZ-1767592419560-A64E78D4',4,NULL,'IN_STOCK','GRN','XYZ162034261','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2595,'XYZ-1767592419586-CF8E5B8F',4,NULL,'IN_STOCK','GRN','XYZ055494843','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2596,'XYZ-1767592419612-FDF1EBB3',4,NULL,'IN_STOCK','GRN','XYZ587282024','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2597,'XYZ-1767592419633-0EF29D64',4,NULL,'IN_STOCK','GRN','XYZ126381602','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2598,'XYZ-1767592419658-8B6E9961',4,NULL,'IN_STOCK','GRN','XYZ432599883','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2599,'XYZ-1767592419684-7993AC79',4,NULL,'IN_STOCK','GRN','XYZ472501899','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2600,'XYZ-1767592419708-0B242F6D',4,NULL,'IN_STOCK','GRN','XYZ168021349','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2601,'XYZ-1767592419735-4A4F8797',4,NULL,'IN_STOCK','GRN','XYZ806132986','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2602,'XYZ-1767592419761-BF0E80FD',4,NULL,'IN_STOCK','GRN','XYZ039022436','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2603,'XYZ-1767592419787-F59B5CAE',4,NULL,'IN_STOCK','GRN','XYZ982834247','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2604,'XYZ-1767592419813-95CEFC5F',4,NULL,'IN_STOCK','GRN','XYZ989289171','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2605,'XYZ-1767592419836-E29D80F0',4,NULL,'IN_STOCK','GRN','XYZ241858033','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2606,'XYZ-1767592419858-C5B9B1C8',4,NULL,'IN_STOCK','GRN','XYZ796944266','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2607,'XYZ-1767592419880-4779D53A',4,NULL,'IN_STOCK','GRN','XYZ872887513','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2608,'XYZ-1767592419905-2D66849A',4,NULL,'IN_STOCK','GRN','XYZ107591037','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2609,'XYZ-1767592419928-E081DDB9',4,NULL,'IN_STOCK','GRN','XYZ510587367','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2610,'XYZ-1767592419950-9CE61ED4',4,NULL,'IN_STOCK','GRN','XYZ753292602','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2611,'XYZ-1767592419976-4556193E',4,NULL,'IN_STOCK','GRN','XYZ559447145','2026-01-05 05:53:39','2026-01-05 05:53:39'),(2612,'XYZ-1767592420001-D118C8DC',4,NULL,'IN_STOCK','GRN','XYZ653966415','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2613,'XYZ-1767592420025-54BA1E13',4,NULL,'IN_STOCK','GRN','XYZ136478190','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2614,'XYZ-1767592420050-D4AAF589',4,NULL,'IN_STOCK','GRN','XYZ257696720','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2615,'XYZ-1767592420080-DDD77073',4,NULL,'IN_STOCK','GRN','XYZ677730179','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2616,'XYZ-1767592420106-C71A4F68',4,NULL,'IN_STOCK','GRN','XYZ319947450','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2617,'XYZ-1767592420132-BF44526B',4,NULL,'IN_STOCK','GRN','XYZ915421496','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2618,'XYZ-1767592420159-893412CE',4,NULL,'IN_STOCK','GRN','XYZ521608381','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2619,'XYZ-1767592420185-224417B4',4,NULL,'IN_STOCK','GRN','XYZ544393526','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2620,'XYZ-1767592420215-F06E1C33',4,NULL,'IN_STOCK','GRN','XYZ378529242','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2621,'XYZ-1767592420243-37896167',4,NULL,'IN_STOCK','GRN','XYZ096967214','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2622,'XYZ-1767592420264-16541392',4,NULL,'IN_STOCK','GRN','XYZ830890139','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2623,'XYZ-1767592420291-B35824FA',4,NULL,'IN_STOCK','GRN','XYZ399794538','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2624,'XYZ-1767592420317-336BC405',4,NULL,'IN_STOCK','GRN','XYZ478885386','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2625,'XYZ-1767592420344-6C14FACB',4,NULL,'IN_STOCK','GRN','XYZ238264098','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2626,'XYZ-1767592420369-AF1993A5',4,NULL,'IN_STOCK','GRN','XYZ667524328','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2627,'XYZ-1767592420393-3DC1D6D3',4,NULL,'IN_STOCK','GRN','XYZ423139450','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2628,'XYZ-1767592420418-E635F61B',4,NULL,'IN_STOCK','GRN','XYZ276751458','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2629,'XYZ-1767592420440-4B9AB331',4,NULL,'IN_STOCK','GRN','XYZ594929539','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2630,'XYZ-1767592420463-AE563D16',4,NULL,'IN_STOCK','GRN','XYZ940799853','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2631,'XYZ-1767592420493-CAC9132D',4,NULL,'IN_STOCK','GRN','XYZ833599417','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2632,'XYZ-1767592420520-A7439F90',4,NULL,'IN_STOCK','GRN','XYZ538907012','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2633,'XYZ-1767592420547-DE7BD8DA',4,NULL,'IN_STOCK','GRN','XYZ805773445','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2634,'XYZ-1767592420573-A218A441',4,NULL,'IN_STOCK','GRN','XYZ234330354','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2635,'XYZ-1767592420599-47A7539F',4,NULL,'IN_STOCK','GRN','XYZ505302006','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2636,'XYZ-1767592420628-A08D76BF',4,NULL,'IN_STOCK','GRN','XYZ512087729','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2637,'XYZ-1767592420658-DA964C82',4,NULL,'IN_STOCK','GRN','XYZ163312336','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2638,'XYZ-1767592420693-F4F4B1D3',4,NULL,'IN_STOCK','GRN','XYZ670181155','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2639,'XYZ-1767592420722-1927198C',4,NULL,'IN_STOCK','GRN','XYZ528082850','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2640,'XYZ-1767592420752-4E809EEA',4,NULL,'IN_STOCK','GRN','XYZ389002307','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2641,'XYZ-1767592420783-94B6B90C',4,NULL,'IN_STOCK','GRN','XYZ858111597','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2642,'XYZ-1767592420815-1EA871E4',4,NULL,'IN_STOCK','GRN','XYZ289971225','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2643,'XYZ-1767592420844-05DAB89A',4,NULL,'IN_STOCK','GRN','XYZ821185977','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2644,'XYZ-1767592420870-67A36C51',4,NULL,'IN_STOCK','GRN','XYZ919170433','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2645,'XYZ-1767592420899-9520EDEC',4,NULL,'IN_STOCK','GRN','XYZ555194224','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2646,'XYZ-1767592420924-215617CC',4,NULL,'IN_STOCK','GRN','XYZ161442672','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2647,'XYZ-1767592420948-99E965FF',4,NULL,'IN_STOCK','GRN','XYZ670882111','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2648,'XYZ-1767592420973-8233B7AA',4,NULL,'IN_STOCK','GRN','XYZ681267043','2026-01-05 05:53:40','2026-01-05 05:53:40'),(2649,'XYZ-1767592420998-D67DAD16',4,NULL,'IN_STOCK','GRN','XYZ109140052','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2650,'XYZ-1767592421024-948D52B4',4,NULL,'IN_STOCK','GRN','XYZ870993306','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2651,'XYZ-1767592421048-4F6604BA',4,NULL,'IN_STOCK','GRN','XYZ098113400','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2652,'XYZ-1767592421074-31173775',4,NULL,'IN_STOCK','GRN','XYZ278219998','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2653,'XYZ-1767592421098-62FF77BA',4,NULL,'IN_STOCK','GRN','XYZ182159595','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2654,'XYZ-1767592421124-1001C12D',4,NULL,'IN_STOCK','GRN','XYZ384883289','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2655,'XYZ-1767592421149-E061B549',4,NULL,'IN_STOCK','GRN','XYZ803413570','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2656,'XYZ-1767592421175-579AF96C',4,NULL,'IN_STOCK','GRN','XYZ873792819','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2657,'XYZ-1767592421200-C958C9C2',4,NULL,'IN_STOCK','GRN','XYZ969163169','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2658,'XYZ-1767592421223-BB4AE0C0',4,NULL,'IN_STOCK','GRN','XYZ011185425','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2659,'XYZ-1767592421248-5A4BE532',4,NULL,'IN_STOCK','GRN','XYZ131117446','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2660,'XYZ-1767592421274-6D5EC1F1',4,NULL,'IN_STOCK','GRN','XYZ146096709','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2661,'XYZ-1767592421300-9D73AD2F',4,NULL,'IN_STOCK','GRN','XYZ975333570','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2662,'XYZ-1767592421326-AA645B36',4,NULL,'IN_STOCK','GRN','XYZ917219902','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2663,'XYZ-1767592421354-B981E20F',4,NULL,'IN_STOCK','GRN','XYZ726972778','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2664,'XYZ-1767592421382-33593D23',4,NULL,'IN_STOCK','GRN','XYZ821574748','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2665,'XYZ-1767592421409-BE49F5A8',4,NULL,'IN_STOCK','GRN','XYZ656593650','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2666,'XYZ-1767592421438-E922A307',4,NULL,'IN_STOCK','GRN','XYZ556248182','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2667,'XYZ-1767592421463-3125259E',4,NULL,'IN_STOCK','GRN','XYZ318186338','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2668,'XYZ-1767592421489-FE3E12B7',4,NULL,'IN_STOCK','GRN','XYZ539082328','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2669,'XYZ-1767592421515-097AE36A',4,NULL,'IN_STOCK','GRN','XYZ643125712','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2670,'XYZ-1767592421542-70E8F15A',4,NULL,'IN_STOCK','GRN','XYZ629320688','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2671,'XYZ-1767592421568-28F8577E',4,NULL,'IN_STOCK','GRN','XYZ035679942','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2672,'XYZ-1767592421595-D7596D52',4,NULL,'IN_STOCK','GRN','XYZ536703602','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2673,'XYZ-1767592421624-9E098E1D',4,NULL,'IN_STOCK','GRN','XYZ310872889','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2674,'XYZ-1767592421654-22AB3DF7',4,NULL,'IN_STOCK','GRN','XYZ819533358','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2675,'XYZ-1767592421679-57D86619',4,NULL,'IN_STOCK','GRN','XYZ301995733','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2676,'XYZ-1767592421708-9112DA97',4,NULL,'IN_STOCK','GRN','XYZ570579416','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2677,'XYZ-1767592421735-01E81EFB',4,NULL,'IN_STOCK','GRN','XYZ357082786','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2678,'XYZ-1767592421762-F24B8F94',4,NULL,'IN_STOCK','GRN','XYZ899823925','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2679,'XYZ-1767592421788-5A3F3877',4,NULL,'IN_STOCK','GRN','XYZ174017139','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2680,'XYZ-1767592421813-261D48AA',4,NULL,'IN_STOCK','GRN','XYZ760699633','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2681,'XYZ-1767592421839-0F4ED9C5',4,NULL,'IN_STOCK','GRN','XYZ611031108','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2682,'XYZ-1767592421863-D55A0A98',4,NULL,'IN_STOCK','GRN','XYZ015326066','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2683,'XYZ-1767592421889-633FA9F9',4,NULL,'IN_STOCK','GRN','XYZ913747246','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2684,'XYZ-1767592421914-025E499A',4,NULL,'IN_STOCK','GRN','XYZ893073684','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2685,'XYZ-1767592421940-CA580F54',4,NULL,'IN_STOCK','GRN','XYZ245513343','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2686,'XYZ-1767592421964-68A55780',4,NULL,'IN_STOCK','GRN','XYZ504446072','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2687,'XYZ-1767592421989-3801EF1B',4,NULL,'IN_STOCK','GRN','XYZ373534903','2026-01-05 05:53:41','2026-01-05 05:53:41'),(2688,'XYZ-1767592422009-E117E6D8',4,NULL,'IN_STOCK','GRN','XYZ097270461','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2689,'XYZ-1767592422030-6CCD08F3',4,NULL,'IN_STOCK','GRN','XYZ645701752','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2690,'XYZ-1767592422053-1DDE6CD2',4,NULL,'IN_STOCK','GRN','XYZ933898845','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2691,'XYZ-1767592422078-93D63DB8',4,NULL,'IN_STOCK','GRN','XYZ150367071','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2692,'XYZ-1767592422102-8BF90222',4,NULL,'IN_STOCK','GRN','XYZ939585235','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2693,'XYZ-1767592422129-E4B88298',4,NULL,'IN_STOCK','GRN','XYZ217819557','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2694,'XYZ-1767592422155-6390EAF6',4,NULL,'IN_STOCK','GRN','XYZ933446665','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2695,'XYZ-1767592422179-5919163F',4,NULL,'IN_STOCK','GRN','XYZ690846611','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2696,'XYZ-1767592422205-1E7893BA',4,NULL,'IN_STOCK','GRN','XYZ229477929','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2697,'XYZ-1767592422230-58C993EA',4,NULL,'IN_STOCK','GRN','XYZ590400351','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2698,'XYZ-1767592422255-A4C7CA70',4,NULL,'IN_STOCK','GRN','XYZ290092099','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2699,'XYZ-1767592422281-3ED2A612',4,NULL,'IN_STOCK','GRN','XYZ051215149','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2700,'XYZ-1767592422307-249A1A61',4,NULL,'IN_STOCK','GRN','XYZ748578068','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2701,'XYZ-1767592422334-B5C012BC',4,NULL,'IN_STOCK','GRN','XYZ551140814','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2702,'XYZ-1767592422360-FD16BFBA',4,NULL,'IN_STOCK','GRN','XYZ067464487','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2703,'XYZ-1767592422385-DDF6A585',4,NULL,'IN_STOCK','GRN','XYZ445203772','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2704,'XYZ-1767592422412-950E22D8',4,NULL,'IN_STOCK','GRN','XYZ901234755','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2705,'XYZ-1767592422438-5E85EDDB',4,NULL,'IN_STOCK','GRN','XYZ643232936','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2706,'XYZ-1767592422459-931B46DF',4,NULL,'IN_STOCK','GRN','XYZ461198354','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2707,'XYZ-1767592422479-5676E46C',4,NULL,'IN_STOCK','GRN','XYZ046229344','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2708,'XYZ-1767592422504-7251E484',4,NULL,'IN_STOCK','GRN','XYZ669094543','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2709,'XYZ-1767592422531-BF95A955',4,NULL,'IN_STOCK','GRN','XYZ459490279','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2710,'XYZ-1767592422560-09FA6A75',4,NULL,'IN_STOCK','GRN','XYZ474813539','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2711,'XYZ-1767592422586-7C2C762D',4,NULL,'IN_STOCK','GRN','XYZ031664254','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2712,'XYZ-1767592422611-6B72068D',4,NULL,'IN_STOCK','GRN','XYZ278582598','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2713,'XYZ-1767592422636-F49F0044',4,NULL,'IN_STOCK','GRN','XYZ030716572','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2714,'XYZ-1767592422660-3525F2B3',4,NULL,'IN_STOCK','GRN','XYZ556234456','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2715,'XYZ-1767592422682-D9F6FEDD',4,NULL,'IN_STOCK','GRN','XYZ206504790','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2716,'XYZ-1767592422703-E5895434',4,NULL,'IN_STOCK','GRN','XYZ501246122','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2717,'XYZ-1767592422726-0053625A',4,NULL,'IN_STOCK','GRN','XYZ168267801','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2718,'XYZ-1767592422747-9BF0B8A7',4,NULL,'IN_STOCK','GRN','XYZ631428842','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2719,'XYZ-1767592422769-9A18D245',4,NULL,'IN_STOCK','GRN','XYZ928017664','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2720,'XYZ-1767592422795-E8F2054F',4,NULL,'IN_STOCK','GRN','XYZ433282987','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2721,'XYZ-1767592422817-996B23C9',4,NULL,'IN_STOCK','GRN','XYZ733365323','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2722,'XYZ-1767592422841-DFA472AE',4,NULL,'IN_STOCK','GRN','XYZ005163887','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2723,'XYZ-1767592422863-D908A723',4,NULL,'IN_STOCK','GRN','XYZ693871741','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2724,'XYZ-1767592422884-86281055',4,NULL,'IN_STOCK','GRN','XYZ692622066','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2725,'XYZ-1767592422906-1774CFBA',4,NULL,'IN_STOCK','GRN','XYZ729452339','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2726,'XYZ-1767592422929-A6C0C006',4,NULL,'IN_STOCK','GRN','XYZ027997738','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2727,'XYZ-1767592422953-74D64BE5',4,NULL,'IN_STOCK','GRN','XYZ546171094','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2728,'XYZ-1767592422976-C618CDE5',4,NULL,'IN_STOCK','GRN','XYZ543985251','2026-01-05 05:53:42','2026-01-05 05:53:42'),(2729,'XYZ-1767592423000-9ED66D7B',4,NULL,'IN_STOCK','GRN','XYZ010047198','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2730,'XYZ-1767592423021-0366B2E2',4,NULL,'IN_STOCK','GRN','XYZ862761894','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2731,'XYZ-1767592423041-2B54DF93',4,NULL,'IN_STOCK','GRN','XYZ570912396','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2732,'XYZ-1767592423066-89EED8EC',4,NULL,'IN_STOCK','GRN','XYZ146176626','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2733,'XYZ-1767592423088-12F54DE2',4,NULL,'IN_STOCK','GRN','XYZ373339999','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2734,'XYZ-1767592423106-BD8F6FBB',4,NULL,'IN_STOCK','GRN','XYZ457837946','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2735,'XYZ-1767592423126-57562FDB',4,NULL,'IN_STOCK','GRN','XYZ720141240','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2736,'XYZ-1767592423143-4609D5B7',4,NULL,'IN_STOCK','GRN','XYZ322876527','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2737,'XYZ-1767592423166-36DA92B5',4,NULL,'IN_STOCK','GRN','XYZ689850014','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2738,'XYZ-1767592423186-D35C9281',4,NULL,'IN_STOCK','GRN','XYZ942845949','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2739,'XYZ-1767592423206-C60AE414',4,NULL,'IN_STOCK','GRN','XYZ891354757','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2740,'XYZ-1767592423228-7525B02D',4,NULL,'IN_STOCK','GRN','XYZ502331326','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2741,'XYZ-1767592423252-A5839E0E',4,NULL,'IN_STOCK','GRN','XYZ427712802','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2742,'XYZ-1767592423274-48A56347',4,NULL,'IN_STOCK','GRN','XYZ008170835','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2743,'XYZ-1767592423299-805ED50E',4,NULL,'IN_STOCK','GRN','XYZ931065023','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2744,'XYZ-1767592423322-763E9D4C',4,NULL,'IN_STOCK','GRN','XYZ313339082','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2745,'XYZ-1767592423339-14ABB2EC',4,NULL,'IN_STOCK','GRN','XYZ724171045','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2746,'XYZ-1767592423361-6F6F77CA',4,NULL,'IN_STOCK','GRN','XYZ301377253','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2747,'XYZ-1767592423386-A0D48FDA',4,NULL,'IN_STOCK','GRN','XYZ720362460','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2748,'XYZ-1767592423410-D5B0FF49',4,NULL,'IN_STOCK','GRN','XYZ013700838','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2749,'XYZ-1767592423431-D0279EFD',4,NULL,'IN_STOCK','GRN','XYZ178137491','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2750,'XYZ-1767592423456-23381705',4,NULL,'IN_STOCK','GRN','XYZ038767237','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2751,'XYZ-1767592423478-B2E2D0C5',4,NULL,'IN_STOCK','GRN','XYZ737260651','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2752,'XYZ-1767592423499-6FF341EE',4,NULL,'IN_STOCK','GRN','XYZ373169054','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2753,'XYZ-1767592423524-CDD1A0CB',4,NULL,'IN_STOCK','GRN','XYZ277436571','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2754,'XYZ-1767592423549-2F0D4B52',4,NULL,'IN_STOCK','GRN','XYZ297362366','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2755,'XYZ-1767592423572-AA295472',4,NULL,'IN_STOCK','GRN','XYZ785527319','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2756,'XYZ-1767592423596-F274A0EE',4,NULL,'IN_STOCK','GRN','XYZ053285066','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2757,'XYZ-1767592423620-2BCEA10B',4,NULL,'IN_STOCK','GRN','XYZ429600794','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2758,'XYZ-1767592423645-496FB34D',4,NULL,'IN_STOCK','GRN','XYZ206384698','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2759,'XYZ-1767592423671-EB2F6C69',4,NULL,'IN_STOCK','GRN','XYZ410523556','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2760,'XYZ-1767592423690-553F0B9F',4,NULL,'IN_STOCK','GRN','XYZ191128423','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2761,'XYZ-1767592423712-76AA83FA',4,NULL,'IN_STOCK','GRN','XYZ721279606','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2762,'XYZ-1767592423735-F4626CA0',4,NULL,'IN_STOCK','GRN','XYZ563687335','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2763,'XYZ-1767592423758-2FC59600',4,NULL,'IN_STOCK','GRN','XYZ983863571','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2764,'XYZ-1767592423778-E2ACE478',4,NULL,'IN_STOCK','GRN','XYZ350325130','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2765,'XYZ-1767592423804-D17A070D',4,NULL,'IN_STOCK','GRN','XYZ817801171','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2766,'XYZ-1767592423828-37C13C23',4,NULL,'IN_STOCK','GRN','XYZ829765720','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2767,'XYZ-1767592423853-379E286B',4,NULL,'IN_STOCK','GRN','XYZ408669165','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2768,'XYZ-1767592423878-413AD63E',4,NULL,'IN_STOCK','GRN','XYZ554215522','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2769,'XYZ-1767592423905-E2964242',4,NULL,'IN_STOCK','GRN','XYZ951168155','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2770,'XYZ-1767592423930-119F83A5',4,NULL,'IN_STOCK','GRN','XYZ492607236','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2771,'XYZ-1767592423953-41098093',4,NULL,'IN_STOCK','GRN','XYZ786062272','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2772,'XYZ-1767592423977-A513E97B',4,NULL,'IN_STOCK','GRN','XYZ193009796','2026-01-05 05:53:43','2026-01-05 05:53:43'),(2773,'XYZ-1767592424003-48AF865F',4,NULL,'IN_STOCK','GRN','XYZ737259539','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2774,'XYZ-1767592424027-1915E703',4,NULL,'IN_STOCK','GRN','XYZ044269862','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2775,'XYZ-1767592424050-B9FE5805',4,NULL,'IN_STOCK','GRN','XYZ174373579','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2776,'XYZ-1767592424071-6D2C39CF',4,NULL,'IN_STOCK','GRN','XYZ799741377','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2777,'XYZ-1767592424091-FD748962',4,NULL,'IN_STOCK','GRN','XYZ355766383','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2778,'XYZ-1767592424112-EAF0D704',4,NULL,'IN_STOCK','GRN','XYZ640088821','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2779,'XYZ-1767592424136-430FC44B',4,NULL,'IN_STOCK','GRN','XYZ954650288','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2780,'XYZ-1767592424158-E28451FA',4,NULL,'IN_STOCK','GRN','XYZ732582321','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2781,'XYZ-1767592424182-25235FC2',4,NULL,'IN_STOCK','GRN','XYZ567174061','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2782,'XYZ-1767592424206-C6A371B4',4,NULL,'IN_STOCK','GRN','XYZ965325101','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2783,'XYZ-1767592424228-F8FF8434',4,NULL,'IN_STOCK','GRN','XYZ446172485','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2784,'XYZ-1767592424250-EFB766D3',4,NULL,'IN_STOCK','GRN','XYZ610212337','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2785,'XYZ-1767592424272-212C88D4',4,NULL,'IN_STOCK','GRN','XYZ163468930','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2786,'XYZ-1767592424296-83234BDB',4,NULL,'IN_STOCK','GRN','XYZ272277347','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2787,'XYZ-1767592424321-B1370FA3',4,NULL,'IN_STOCK','GRN','XYZ373995924','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2788,'XYZ-1767592424346-D8049A62',4,NULL,'IN_STOCK','GRN','XYZ946217883','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2789,'XYZ-1767592424372-CEF7A170',4,NULL,'IN_STOCK','GRN','XYZ856899197','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2790,'XYZ-1767592424398-AECD501D',4,NULL,'IN_STOCK','GRN','XYZ391104972','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2791,'XYZ-1767592424421-DE7B2EFE',4,NULL,'IN_STOCK','GRN','XYZ703099018','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2792,'XYZ-1767592424446-271897AA',4,NULL,'IN_STOCK','GRN','XYZ220506660','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2793,'XYZ-1767592424470-01CE8D10',4,NULL,'IN_STOCK','GRN','XYZ011720840','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2794,'XYZ-1767592424496-A233AEAE',4,NULL,'IN_STOCK','GRN','XYZ576320726','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2795,'XYZ-1767592424522-9192572F',4,NULL,'IN_STOCK','GRN','XYZ071385325','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2796,'XYZ-1767592424547-ABA9FFCD',4,NULL,'IN_STOCK','GRN','XYZ282935117','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2797,'XYZ-1767592424573-B966E5CD',4,NULL,'IN_STOCK','GRN','XYZ452329655','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2798,'XYZ-1767592424599-0B5E1ADA',4,NULL,'IN_STOCK','GRN','XYZ615331727','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2799,'XYZ-1767592424625-2729AF52',4,NULL,'IN_STOCK','GRN','XYZ461652945','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2800,'XYZ-1767592424651-164094A1',4,NULL,'IN_STOCK','GRN','XYZ602472358','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2801,'XYZ-1767592424677-D1ACA7FC',4,NULL,'IN_STOCK','GRN','XYZ871257567','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2802,'XYZ-1767592424704-49245318',5,NULL,'IN_STOCK','GRN','XYZ723609803','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2803,'XYZ-1767592424733-5D6D5F93',5,NULL,'IN_STOCK','GRN','XYZ545377603','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2804,'XYZ-1767592424760-8194BE92',5,NULL,'IN_STOCK','GRN','XYZ094760557','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2805,'XYZ-1767592424781-B961D047',5,NULL,'IN_STOCK','GRN','XYZ834180626','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2806,'XYZ-1767592424803-43D5E6A7',5,NULL,'IN_STOCK','GRN','XYZ622553386','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2807,'XYZ-1767592424826-35C1D015',5,NULL,'IN_STOCK','GRN','XYZ682791220','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2808,'XYZ-1767592424848-5C7958E8',5,NULL,'IN_STOCK','GRN','XYZ073265449','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2809,'XYZ-1767592424875-856510E3',5,NULL,'IN_STOCK','GRN','XYZ264199018','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2810,'XYZ-1767592424897-BBBA9AC1',5,NULL,'IN_STOCK','GRN','XYZ687142848','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2811,'XYZ-1767592424921-C223BB8A',5,NULL,'IN_STOCK','GRN','XYZ304744557','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2812,'XYZ-1767592424947-6D42F943',5,NULL,'IN_STOCK','GRN','XYZ224878292','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2813,'XYZ-1767592424969-E0B450BC',5,NULL,'IN_STOCK','GRN','XYZ153853692','2026-01-05 05:53:44','2026-01-05 05:53:44'),(2814,'XYZ-1767592424991-2A9FDAB6',5,NULL,'IN_STOCK','GRN','XYZ458256413','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2815,'XYZ-1767592425016-A501CC07',5,NULL,'IN_STOCK','GRN','XYZ513496496','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2816,'XYZ-1767592425041-3867CD5A',5,NULL,'IN_STOCK','GRN','XYZ083065615','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2817,'XYZ-1767592425065-F66BB03B',5,NULL,'IN_STOCK','GRN','XYZ303631527','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2818,'XYZ-1767592425089-C21685D6',5,NULL,'IN_STOCK','GRN','XYZ558620553','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2819,'XYZ-1767592425115-899C6597',5,NULL,'IN_STOCK','GRN','XYZ026621671','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2820,'XYZ-1767592425141-0EAE54D8',5,NULL,'IN_STOCK','GRN','XYZ348970867','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2821,'XYZ-1767592425167-98293BA8',5,NULL,'IN_STOCK','GRN','XYZ502038463','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2822,'XYZ-1767592425193-E366ACAC',5,NULL,'IN_STOCK','GRN','XYZ528669758','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2823,'XYZ-1767592425217-A0337B19',5,NULL,'IN_STOCK','GRN','XYZ441907222','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2824,'XYZ-1767592425244-6912F223',5,NULL,'IN_STOCK','GRN','XYZ835866110','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2825,'XYZ-1767592425266-DEEE3809',5,NULL,'IN_STOCK','GRN','XYZ248695326','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2826,'XYZ-1767592425291-31C50C6F',5,NULL,'IN_STOCK','GRN','XYZ623332197','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2827,'XYZ-1767592425315-EEA1A727',5,NULL,'IN_STOCK','GRN','XYZ097251143','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2828,'XYZ-1767592425341-9D610610',5,NULL,'IN_STOCK','GRN','XYZ305181597','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2829,'XYZ-1767592425366-4B28DA8A',5,NULL,'IN_STOCK','GRN','XYZ343652487','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2830,'XYZ-1767592425392-41494310',5,NULL,'IN_STOCK','GRN','XYZ271799011','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2831,'XYZ-1767592425418-82AF120F',5,NULL,'IN_STOCK','GRN','XYZ717089968','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2832,'XYZ-1767592425441-7C525806',5,NULL,'IN_STOCK','GRN','XYZ952794109','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2833,'XYZ-1767592425464-6F7B65C7',5,NULL,'IN_STOCK','GRN','XYZ252740782','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2834,'XYZ-1767592425486-A818AFE1',5,NULL,'IN_STOCK','GRN','XYZ440133782','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2835,'XYZ-1767592425509-95B441AB',5,NULL,'IN_STOCK','GRN','XYZ541809884','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2836,'XYZ-1767592425534-5509A526',5,NULL,'IN_STOCK','GRN','XYZ408004828','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2837,'XYZ-1767592425559-7D20DAEE',5,NULL,'IN_STOCK','GRN','XYZ205839972','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2838,'XYZ-1767592425586-949219EB',5,NULL,'IN_STOCK','GRN','XYZ269389879','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2839,'XYZ-1767592425613-D8C89B7D',5,NULL,'IN_STOCK','GRN','XYZ553649662','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2840,'XYZ-1767592425634-565C1A7B',5,NULL,'IN_STOCK','GRN','XYZ362802694','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2841,'XYZ-1767592425656-2A2B16AF',5,NULL,'IN_STOCK','GRN','XYZ557749554','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2842,'XYZ-1767592425681-AEFDFD67',5,NULL,'IN_STOCK','GRN','XYZ435615985','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2843,'XYZ-1767592425707-181B66C7',5,NULL,'IN_STOCK','GRN','XYZ604200897','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2844,'XYZ-1767592425731-8196960A',5,NULL,'IN_STOCK','GRN','XYZ035207150','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2845,'XYZ-1767592425753-E4DC033E',5,NULL,'IN_STOCK','GRN','XYZ252343872','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2846,'XYZ-1767592425773-1F06097F',5,NULL,'IN_STOCK','GRN','XYZ009530460','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2847,'XYZ-1767592425795-ABEF28D9',5,NULL,'IN_STOCK','GRN','XYZ044791971','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2848,'XYZ-1767592425820-DE37DB25',5,NULL,'IN_STOCK','GRN','XYZ357731619','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2849,'XYZ-1767592425845-033C26B5',5,NULL,'IN_STOCK','GRN','XYZ903907265','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2850,'XYZ-1767592425869-0C595AB2',5,NULL,'IN_STOCK','GRN','XYZ847519205','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2851,'XYZ-1767592425891-5D97EEFE',5,NULL,'IN_STOCK','GRN','XYZ316163353','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2852,'XYZ-1767592425913-8BBD5952',5,NULL,'IN_STOCK','GRN','XYZ047852458','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2853,'XYZ-1767592425934-9E243A6A',5,NULL,'IN_STOCK','GRN','XYZ019641202','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2854,'XYZ-1767592425955-CD13C69C',5,NULL,'IN_STOCK','GRN','XYZ948425648','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2855,'XYZ-1767592425977-A03D28E2',5,NULL,'IN_STOCK','GRN','XYZ639802375','2026-01-05 05:53:45','2026-01-05 05:53:45'),(2856,'XYZ-1767592425998-7936E44E',5,NULL,'IN_STOCK','GRN','XYZ199945614','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2857,'XYZ-1767592426015-329E6826',5,NULL,'IN_STOCK','GRN','XYZ484337439','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2858,'XYZ-1767592426039-AB5364D3',5,NULL,'IN_STOCK','GRN','XYZ681206452','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2859,'XYZ-1767592426059-B288F7A1',5,NULL,'IN_STOCK','GRN','XYZ371312563','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2860,'XYZ-1767592426081-AEA85044',5,NULL,'IN_STOCK','GRN','XYZ218239519','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2861,'XYZ-1767592426107-87FFBE80',5,NULL,'IN_STOCK','GRN','XYZ098359518','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2862,'XYZ-1767592426128-516CBAEE',5,NULL,'IN_STOCK','GRN','XYZ684179128','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2863,'XYZ-1767592426152-144AB3CD',5,NULL,'IN_STOCK','GRN','XYZ458221526','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2864,'XYZ-1767592426177-BDC59622',5,NULL,'IN_STOCK','GRN','XYZ705022624','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2865,'XYZ-1767592426203-99B4F1B2',5,NULL,'IN_STOCK','GRN','XYZ201888197','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2866,'XYZ-1767592426225-E198D73E',5,NULL,'IN_STOCK','GRN','XYZ857832355','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2867,'XYZ-1767592426245-843F15B4',5,NULL,'IN_STOCK','GRN','XYZ137018655','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2868,'XYZ-1767592426264-B0032624',5,NULL,'IN_STOCK','GRN','XYZ130880218','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2869,'XYZ-1767592426286-918CF5F2',5,NULL,'IN_STOCK','GRN','XYZ846026283','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2870,'XYZ-1767592426310-38E7ADE3',5,NULL,'IN_STOCK','GRN','XYZ219386190','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2871,'XYZ-1767592426329-EA0E770A',5,NULL,'IN_STOCK','GRN','XYZ992357745','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2872,'XYZ-1767592426353-F6C74FBF',5,NULL,'IN_STOCK','GRN','XYZ507805023','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2873,'XYZ-1767592426376-E75C6669',5,NULL,'IN_STOCK','GRN','XYZ866726116','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2874,'XYZ-1767592426399-578C7EDF',5,NULL,'IN_STOCK','GRN','XYZ949280105','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2875,'XYZ-1767592426425-2C9B9773',5,NULL,'IN_STOCK','GRN','XYZ091674354','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2876,'XYZ-1767592426448-979FBD11',5,NULL,'IN_STOCK','GRN','XYZ062118043','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2877,'XYZ-1767592426474-D70EBF50',5,NULL,'IN_STOCK','GRN','XYZ547305533','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2878,'XYZ-1767592426498-8F71A739',5,NULL,'IN_STOCK','GRN','XYZ435886612','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2879,'XYZ-1767592426520-2DE2A36D',5,NULL,'IN_STOCK','GRN','XYZ696925201','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2880,'XYZ-1767592426542-0DD6F427',5,NULL,'IN_STOCK','GRN','XYZ689616611','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2881,'XYZ-1767592426566-68A672A9',5,NULL,'IN_STOCK','GRN','XYZ076813109','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2882,'XYZ-1767592426587-8FDED3D8',5,NULL,'IN_STOCK','GRN','XYZ818047576','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2883,'XYZ-1767592426610-6F0E62A0',5,NULL,'IN_STOCK','GRN','XYZ087258437','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2884,'XYZ-1767592426634-C8CAD07C',5,NULL,'IN_STOCK','GRN','XYZ736359773','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2885,'XYZ-1767592426660-0244FCB9',5,NULL,'IN_STOCK','GRN','XYZ900127685','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2886,'XYZ-1767592426681-D293411D',5,NULL,'IN_STOCK','GRN','XYZ936882580','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2887,'XYZ-1767592426701-3BAAF642',5,NULL,'IN_STOCK','GRN','XYZ983278148','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2888,'XYZ-1767592426725-14B009EA',5,NULL,'IN_STOCK','GRN','XYZ245141645','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2889,'XYZ-1767592426750-CE34C229',5,NULL,'IN_STOCK','GRN','XYZ701275284','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2890,'XYZ-1767592426774-45E004F8',5,NULL,'IN_STOCK','GRN','XYZ622416027','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2891,'XYZ-1767592426798-FF8A6804',5,NULL,'IN_STOCK','GRN','XYZ832376357','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2892,'XYZ-1767592426821-51C8BEC4',5,NULL,'IN_STOCK','GRN','XYZ106661119','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2893,'XYZ-1767592426844-BE904A41',5,NULL,'IN_STOCK','GRN','XYZ339574169','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2894,'XYZ-1767592426868-002BC319',5,NULL,'IN_STOCK','GRN','XYZ987086736','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2895,'XYZ-1767592426893-FE19F4C2',5,NULL,'IN_STOCK','GRN','XYZ710010185','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2896,'XYZ-1767592426918-BC3C1633',5,NULL,'IN_STOCK','GRN','XYZ352696616','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2897,'XYZ-1767592426940-50E3CF37',5,NULL,'IN_STOCK','GRN','XYZ517871171','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2898,'XYZ-1767592426963-ACA8216A',5,NULL,'IN_STOCK','GRN','XYZ464996416','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2899,'XYZ-1767592426985-327ED651',5,NULL,'IN_STOCK','GRN','XYZ811572579','2026-01-05 05:53:46','2026-01-05 05:53:46'),(2900,'XYZ-1767592427011-183AAEE3',5,NULL,'IN_STOCK','GRN','XYZ816648532','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2901,'XYZ-1767592427036-BB668687',5,NULL,'IN_STOCK','GRN','XYZ154260900','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2902,'XYZ-1767592427060-A040C68E',5,NULL,'IN_STOCK','GRN','XYZ431356024','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2903,'XYZ-1767592427084-6D8B5331',5,NULL,'IN_STOCK','GRN','XYZ695389983','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2904,'XYZ-1767592427111-135AE349',5,NULL,'IN_STOCK','GRN','XYZ124254079','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2905,'XYZ-1767592427137-BF2A7165',5,NULL,'IN_STOCK','GRN','XYZ955241006','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2906,'XYZ-1767592427159-00BAF6E5',5,NULL,'IN_STOCK','GRN','XYZ535144256','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2907,'XYZ-1767592427182-13E3563F',5,NULL,'IN_STOCK','GRN','XYZ638921722','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2908,'XYZ-1767592427208-D6666498',5,NULL,'IN_STOCK','GRN','XYZ500904520','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2909,'XYZ-1767592427235-0B25E18A',5,NULL,'IN_STOCK','GRN','XYZ454126756','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2910,'XYZ-1767592427259-E1AF2A19',5,NULL,'IN_STOCK','GRN','XYZ340733365','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2911,'XYZ-1767592427285-227F1994',5,NULL,'IN_STOCK','GRN','XYZ425882018','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2912,'XYZ-1767592427311-C81BEEF7',5,NULL,'IN_STOCK','GRN','XYZ213719850','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2913,'XYZ-1767592427338-9918074D',5,NULL,'IN_STOCK','GRN','XYZ474296705','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2914,'XYZ-1767592427363-F3AD229D',5,NULL,'IN_STOCK','GRN','XYZ830453468','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2915,'XYZ-1767592427388-168BEDD8',5,NULL,'IN_STOCK','GRN','XYZ817870674','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2916,'XYZ-1767592427414-AC4E9995',5,NULL,'IN_STOCK','GRN','XYZ932713260','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2917,'XYZ-1767592427438-60073BC9',5,NULL,'IN_STOCK','GRN','XYZ176121601','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2918,'XYZ-1767592427459-F78C07CB',5,NULL,'IN_STOCK','GRN','XYZ240221261','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2919,'XYZ-1767592427485-E589B824',5,NULL,'IN_STOCK','GRN','XYZ140367293','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2920,'XYZ-1767592427511-27BABF3F',5,NULL,'IN_STOCK','GRN','XYZ840955470','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2921,'XYZ-1767592427538-E0FB0D24',5,NULL,'IN_STOCK','GRN','XYZ703846961','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2922,'XYZ-1767592427562-4AC85C74',5,NULL,'IN_STOCK','GRN','XYZ557834020','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2923,'XYZ-1767592427584-AD84D321',5,NULL,'IN_STOCK','GRN','XYZ406640925','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2924,'XYZ-1767592427611-E3AF2FBB',5,NULL,'IN_STOCK','GRN','XYZ124851342','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2925,'XYZ-1767592427639-F0165897',5,NULL,'IN_STOCK','GRN','XYZ392234453','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2926,'XYZ-1767592427664-46EB1900',5,NULL,'IN_STOCK','GRN','XYZ110163617','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2927,'XYZ-1767592427690-D0F86FB1',5,NULL,'IN_STOCK','GRN','XYZ586835614','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2928,'XYZ-1767592427716-78B0496F',5,NULL,'IN_STOCK','GRN','XYZ586925281','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2929,'XYZ-1767592427739-730DBD92',5,NULL,'IN_STOCK','GRN','XYZ163680095','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2930,'XYZ-1767592427763-0DF1D8D1',5,NULL,'IN_STOCK','GRN','XYZ915412585','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2931,'XYZ-1767592427786-3B9CC40B',5,NULL,'IN_STOCK','GRN','XYZ094362122','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2932,'XYZ-1767592427809-0592CF55',5,NULL,'IN_STOCK','GRN','XYZ732350025','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2933,'XYZ-1767592427830-EB668441',5,NULL,'IN_STOCK','GRN','XYZ105429020','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2934,'XYZ-1767592427852-AE80DA1E',5,NULL,'IN_STOCK','GRN','XYZ302706590','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2935,'XYZ-1767592427874-83F06139',5,NULL,'IN_STOCK','GRN','XYZ658077836','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2936,'XYZ-1767592427897-F066165F',5,NULL,'IN_STOCK','GRN','XYZ102309584','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2937,'XYZ-1767592427920-07FF6011',5,NULL,'IN_STOCK','GRN','XYZ077609733','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2938,'XYZ-1767592427943-4449FF28',5,NULL,'IN_STOCK','GRN','XYZ783140391','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2939,'XYZ-1767592427965-2F630A62',5,NULL,'IN_STOCK','GRN','XYZ739718842','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2940,'XYZ-1767592427986-A2ED70F0',5,NULL,'IN_STOCK','GRN','XYZ623195638','2026-01-05 05:53:47','2026-01-05 05:53:47'),(2941,'XYZ-1767592428009-EED7BA18',5,NULL,'IN_STOCK','GRN','XYZ501856402','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2942,'XYZ-1767592428033-D7BF9E9E',5,NULL,'IN_STOCK','GRN','XYZ713186223','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2943,'XYZ-1767592428057-06FA3579',5,NULL,'IN_STOCK','GRN','XYZ035028605','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2944,'XYZ-1767592428081-5FA7AF80',5,NULL,'IN_STOCK','GRN','XYZ812997392','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2945,'XYZ-1767592428103-B2FFE1A0',5,NULL,'IN_STOCK','GRN','XYZ187806118','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2946,'XYZ-1767592428125-7480D781',5,NULL,'IN_STOCK','GRN','XYZ038547744','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2947,'XYZ-1767592428143-F0C77614',5,NULL,'IN_STOCK','GRN','XYZ144273533','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2948,'XYZ-1767592428166-B01480BB',5,NULL,'IN_STOCK','GRN','XYZ349443251','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2949,'XYZ-1767592428192-55B5D0EF',5,NULL,'IN_STOCK','GRN','XYZ125912113','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2950,'XYZ-1767592428217-35F688F9',5,NULL,'IN_STOCK','GRN','XYZ419415243','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2951,'XYZ-1767592428238-C261BF57',5,NULL,'IN_STOCK','GRN','XYZ765348974','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2952,'XYZ-1767592428258-C2394AC9',5,NULL,'IN_STOCK','GRN','XYZ400523639','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2953,'XYZ-1767592428279-1549DDB5',5,NULL,'IN_STOCK','GRN','XYZ456532695','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2954,'XYZ-1767592428299-2223DBCA',5,NULL,'IN_STOCK','GRN','XYZ212224738','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2955,'XYZ-1767592428324-504A854C',5,NULL,'IN_STOCK','GRN','XYZ859270286','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2956,'XYZ-1767592428348-98FF737B',5,NULL,'IN_STOCK','GRN','XYZ159553023','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2957,'XYZ-1767592428376-6B667BAE',5,NULL,'IN_STOCK','GRN','XYZ562112389','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2958,'XYZ-1767592428401-CDD8F976',5,NULL,'IN_STOCK','GRN','XYZ322823996','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2959,'XYZ-1767592428426-88E52745',5,NULL,'IN_STOCK','GRN','XYZ921180988','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2960,'XYZ-1767592428452-B5DF8839',5,NULL,'IN_STOCK','GRN','XYZ886143419','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2961,'XYZ-1767592428478-A43715A1',5,NULL,'IN_STOCK','GRN','XYZ186647855','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2962,'XYZ-1767592428503-5BB77639',5,NULL,'IN_STOCK','GRN','XYZ805715443','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2963,'XYZ-1767592428528-FD0D3A36',5,NULL,'IN_STOCK','GRN','XYZ477653099','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2964,'XYZ-1767592428554-7E3CFFC1',5,NULL,'IN_STOCK','GRN','XYZ397308208','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2965,'XYZ-1767592428580-E513399F',5,NULL,'IN_STOCK','GRN','XYZ944818130','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2966,'XYZ-1767592428608-D25F3610',5,NULL,'IN_STOCK','GRN','XYZ916073977','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2967,'XYZ-1767592428645-F300601B',5,NULL,'IN_STOCK','GRN','XYZ870296451','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2968,'XYZ-1767592428674-91FD645D',5,NULL,'IN_STOCK','GRN','XYZ039994984','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2969,'XYZ-1767592428700-F6C673E0',5,NULL,'IN_STOCK','GRN','XYZ008401613','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2970,'XYZ-1767592428726-2758219E',5,NULL,'IN_STOCK','GRN','XYZ256090079','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2971,'XYZ-1767592428751-1B7ED814',5,NULL,'IN_STOCK','GRN','XYZ151629852','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2972,'XYZ-1767592428773-AB1B18C4',5,NULL,'IN_STOCK','GRN','XYZ654377788','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2973,'XYZ-1767592428797-19368531',5,NULL,'IN_STOCK','GRN','XYZ552644973','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2974,'XYZ-1767592428818-06CF7126',5,NULL,'IN_STOCK','GRN','XYZ498664895','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2975,'XYZ-1767592428843-BDA9A371',5,NULL,'IN_STOCK','GRN','XYZ293004956','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2976,'XYZ-1767592428864-1EBB47F9',5,NULL,'IN_STOCK','GRN','XYZ708676756','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2977,'XYZ-1767592428889-D2EF1147',5,NULL,'IN_STOCK','GRN','XYZ123543248','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2978,'XYZ-1767592428912-7AFE462A',5,NULL,'IN_STOCK','GRN','XYZ324563977','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2979,'XYZ-1767592428932-0D57CE5D',5,NULL,'IN_STOCK','GRN','XYZ062337429','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2980,'XYZ-1767592428955-0108EAA8',5,NULL,'IN_STOCK','GRN','XYZ897682156','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2981,'XYZ-1767592428977-04EA50A6',5,NULL,'IN_STOCK','GRN','XYZ202924352','2026-01-05 05:53:48','2026-01-05 05:53:48'),(2982,'XYZ-1767592429000-2EBA8F97',5,NULL,'IN_STOCK','GRN','XYZ271942088','2026-01-05 05:53:49','2026-01-05 05:53:49'),(2983,'XYZ-1767592429025-D477A25B',5,NULL,'IN_STOCK','GRN','XYZ819823700','2026-01-05 05:53:49','2026-01-05 05:53:49'),(2984,'XYZ-1767592429049-E6202767',5,NULL,'IN_STOCK','GRN','XYZ453189596','2026-01-05 05:53:49','2026-01-05 05:53:49'),(2985,'XYZ-1767592429071-833A2320',5,NULL,'IN_STOCK','GRN','XYZ384526584','2026-01-05 05:53:49','2026-01-05 05:53:49'),(2986,'XYZ-1767592429094-B8F2FB15',5,NULL,'IN_STOCK','GRN','XYZ438560891','2026-01-05 05:53:49','2026-01-05 05:53:49'),(2987,'XYZ-1767592429117-F6BF56E5',5,NULL,'IN_STOCK','GRN','XYZ803296312','2026-01-05 05:53:49','2026-01-05 05:53:49'),(2988,'XYZ-1767592429141-AE04F312',5,NULL,'IN_STOCK','GRN','XYZ398873789','2026-01-05 05:53:49','2026-01-05 05:53:49'),(2989,'XYZ-1767592429164-6ACE1EF9',5,NULL,'IN_STOCK','GRN','XYZ384519909','2026-01-05 05:53:49','2026-01-05 05:53:49'),(2990,'XYZ-1767592429186-7DA2637B',5,NULL,'IN_STOCK','GRN','XYZ866224628','2026-01-05 05:53:49','2026-01-05 05:53:49'),(2991,'XYZ-1767592429207-2D6E7923',5,NULL,'IN_STOCK','GRN','XYZ945393717','2026-01-05 05:53:49','2026-01-05 05:53:49'),(2992,'XYZ-1767592429230-57CAD148',5,NULL,'IN_STOCK','GRN','XYZ779963482','2026-01-05 05:53:49','2026-01-05 05:53:49'),(2993,'XYZ-1767592429252-6618AD95',5,NULL,'IN_STOCK','GRN','XYZ511508669','2026-01-05 05:53:49','2026-01-05 05:53:49'),(2994,'XYZ-1767592429278-599ED860',5,NULL,'IN_STOCK','GRN','XYZ345679177','2026-01-05 05:53:49','2026-01-05 05:53:49'),(2995,'XYZ-1767592429301-1DDBEFE7',5,NULL,'IN_STOCK','GRN','XYZ750285161','2026-01-05 05:53:49','2026-01-05 05:53:49'),(2996,'XYZ-1767592429328-AF63D932',5,NULL,'IN_STOCK','GRN','XYZ642629055','2026-01-05 05:53:49','2026-01-05 05:53:49'),(2997,'XYZ-1767592429354-87479892',5,NULL,'IN_STOCK','GRN','XYZ562614077','2026-01-05 05:53:49','2026-01-05 05:53:49'),(2998,'XYZ-1767592429379-B1D5719A',5,NULL,'IN_STOCK','GRN','XYZ336640284','2026-01-05 05:53:49','2026-01-05 05:53:49'),(2999,'XYZ-1767592429406-3BB9C118',5,NULL,'IN_STOCK','GRN','XYZ906422159','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3000,'XYZ-1767592429433-F7B9EC5B',5,NULL,'IN_STOCK','GRN','XYZ444190718','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3001,'XYZ-1767592429458-4C4367EB',5,NULL,'IN_STOCK','GRN','XYZ724018946','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3002,'XYZ-1767592429483-05394382',5,NULL,'IN_STOCK','GRN','XYZ727005654','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3003,'XYZ-1767592429504-6D449694',5,NULL,'IN_STOCK','GRN','XYZ223518637','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3004,'XYZ-1767592429528-127D703B',5,NULL,'IN_STOCK','GRN','XYZ919437814','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3005,'XYZ-1767592429550-C09A9C4A',5,NULL,'IN_STOCK','GRN','XYZ474167307','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3006,'XYZ-1767592429571-80CF0FF6',5,NULL,'IN_STOCK','GRN','XYZ075060546','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3007,'XYZ-1767592429592-7C34CEE3',5,NULL,'IN_STOCK','GRN','XYZ512465347','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3008,'XYZ-1767592429611-23935930',5,NULL,'IN_STOCK','GRN','XYZ843940291','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3009,'XYZ-1767592429635-1BAF5AB0',5,NULL,'IN_STOCK','GRN','XYZ572354291','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3010,'XYZ-1767592429659-1CD0009B',5,NULL,'IN_STOCK','GRN','XYZ432486670','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3011,'XYZ-1767592429679-A1552ADD',5,NULL,'IN_STOCK','GRN','XYZ646343988','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3012,'XYZ-1767592429701-3BADABFF',5,NULL,'IN_STOCK','GRN','XYZ319959712','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3013,'XYZ-1767592429725-91640B6E',5,NULL,'IN_STOCK','GRN','XYZ055775282','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3014,'XYZ-1767592429750-9568F9C8',5,NULL,'IN_STOCK','GRN','XYZ921761477','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3015,'XYZ-1767592429775-719F7D9B',5,NULL,'IN_STOCK','GRN','XYZ010710585','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3016,'XYZ-1767592429798-F40FC5D7',5,NULL,'IN_STOCK','GRN','XYZ264301022','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3017,'XYZ-1767592429822-D66B3A10',5,NULL,'IN_STOCK','GRN','XYZ683325164','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3018,'XYZ-1767592429846-32730E1B',5,NULL,'IN_STOCK','GRN','XYZ711221379','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3019,'XYZ-1767592429867-9E93FBA1',5,NULL,'IN_STOCK','GRN','XYZ811039905','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3020,'XYZ-1767592429890-C4CACD0F',5,NULL,'IN_STOCK','GRN','XYZ232804448','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3021,'XYZ-1767592429909-163977DA',5,NULL,'IN_STOCK','GRN','XYZ633705894','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3022,'XYZ-1767592429931-A3E21D46',5,NULL,'IN_STOCK','GRN','XYZ422728056','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3023,'XYZ-1767592429955-A133843D',5,NULL,'IN_STOCK','GRN','XYZ617942370','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3024,'XYZ-1767592429979-870C6132',5,NULL,'IN_STOCK','GRN','XYZ587258718','2026-01-05 05:53:49','2026-01-05 05:53:49'),(3025,'XYZ-1767592430000-BC3A4AE5',5,NULL,'IN_STOCK','GRN','XYZ646749528','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3026,'XYZ-1767592430025-5EAD8967',5,NULL,'IN_STOCK','GRN','XYZ109610937','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3027,'XYZ-1767592430047-1CD308D6',5,NULL,'IN_STOCK','GRN','XYZ625314485','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3028,'XYZ-1767592430070-93784F93',5,NULL,'IN_STOCK','GRN','XYZ776847538','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3029,'XYZ-1767592430095-6FECB885',5,NULL,'IN_STOCK','GRN','XYZ067833360','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3030,'XYZ-1767592430120-11DF0302',5,NULL,'IN_STOCK','GRN','XYZ253994773','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3031,'XYZ-1767592430143-07961093',5,NULL,'IN_STOCK','GRN','XYZ438956037','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3032,'XYZ-1767592430165-E5FBCE03',5,NULL,'IN_STOCK','GRN','XYZ204982163','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3033,'XYZ-1767592430189-5C03A885',5,NULL,'IN_STOCK','GRN','XYZ749875781','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3034,'XYZ-1767592430214-A9207B69',5,NULL,'IN_STOCK','GRN','XYZ644603393','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3035,'XYZ-1767592430240-C280C0FB',5,NULL,'IN_STOCK','GRN','XYZ499213504','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3036,'XYZ-1767592430264-91DF8370',5,NULL,'IN_STOCK','GRN','XYZ770128026','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3037,'XYZ-1767592430286-8CA860A2',5,NULL,'IN_STOCK','GRN','XYZ493921133','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3038,'XYZ-1767592430310-ABCD89A9',5,NULL,'IN_STOCK','GRN','XYZ829719118','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3039,'XYZ-1767592430332-36B2BE04',5,NULL,'IN_STOCK','GRN','XYZ702826035','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3040,'XYZ-1767592430359-898D7361',5,NULL,'IN_STOCK','GRN','XYZ289223811','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3041,'XYZ-1767592430386-52A6598E',5,NULL,'IN_STOCK','GRN','XYZ236982318','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3042,'XYZ-1767592430417-C868D904',5,NULL,'IN_STOCK','GRN','XYZ211435705','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3043,'XYZ-1767592430445-7A43DE4A',5,NULL,'IN_STOCK','GRN','XYZ628718455','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3044,'XYZ-1767592430471-4810F16A',5,NULL,'IN_STOCK','GRN','XYZ787522479','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3045,'XYZ-1767592430495-98F56E22',5,NULL,'IN_STOCK','GRN','XYZ890600984','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3046,'XYZ-1767592430522-E949BADA',5,NULL,'IN_STOCK','GRN','XYZ738067339','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3047,'XYZ-1767592430544-3164495B',5,NULL,'IN_STOCK','GRN','XYZ765587402','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3048,'XYZ-1767592430566-21B57C46',5,NULL,'IN_STOCK','GRN','XYZ929339715','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3049,'XYZ-1767592430590-815CDA66',5,NULL,'IN_STOCK','GRN','XYZ365460330','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3050,'XYZ-1767592430611-67D8EDDA',5,NULL,'IN_STOCK','GRN','XYZ758916788','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3051,'XYZ-1767592430635-BCB7D666',5,NULL,'IN_STOCK','GRN','XYZ933635287','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3052,'XYZ-1767592430661-4B9627FC',5,NULL,'IN_STOCK','GRN','XYZ603906359','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3053,'XYZ-1767592430684-AC5B323F',5,NULL,'IN_STOCK','GRN','XYZ701435062','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3054,'XYZ-1767592430706-5B5B582E',5,NULL,'IN_STOCK','GRN','XYZ107365154','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3055,'XYZ-1767592430732-812C4EFD',5,NULL,'IN_STOCK','GRN','XYZ593468814','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3056,'XYZ-1767592430754-2E5086B9',5,NULL,'IN_STOCK','GRN','XYZ560737253','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3057,'XYZ-1767592430780-854D1BF9',5,NULL,'IN_STOCK','GRN','XYZ137895969','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3058,'XYZ-1767592430803-B7B3E243',5,NULL,'IN_STOCK','GRN','XYZ966629786','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3059,'XYZ-1767592430829-3D090641',5,NULL,'IN_STOCK','GRN','XYZ186170456','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3060,'XYZ-1767592430854-63F28D1C',5,NULL,'IN_STOCK','GRN','XYZ902282028','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3061,'XYZ-1767592430881-A137564E',5,NULL,'IN_STOCK','GRN','XYZ292848648','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3062,'XYZ-1767592430908-601B218C',5,NULL,'IN_STOCK','GRN','XYZ650207047','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3063,'XYZ-1767592430933-E6D9B9F0',5,NULL,'IN_STOCK','GRN','XYZ616300158','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3064,'XYZ-1767592430960-C0CBDCD5',5,NULL,'IN_STOCK','GRN','XYZ008194473','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3065,'XYZ-1767592430983-753DF293',5,NULL,'IN_STOCK','GRN','XYZ203458985','2026-01-05 05:53:50','2026-01-05 05:53:50'),(3066,'XYZ-1767592431008-A4F6F12D',5,NULL,'IN_STOCK','GRN','XYZ290902076','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3067,'XYZ-1767592431037-5EB67D8A',5,NULL,'IN_STOCK','GRN','XYZ757955758','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3068,'XYZ-1767592431064-6BA02F08',5,NULL,'IN_STOCK','GRN','XYZ903936914','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3069,'XYZ-1767592431091-08D50C10',5,NULL,'IN_STOCK','GRN','XYZ594138114','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3070,'XYZ-1767592431120-6D1AA3AA',5,NULL,'IN_STOCK','GRN','XYZ372492566','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3071,'XYZ-1767592431145-51E97737',5,NULL,'IN_STOCK','GRN','XYZ838189371','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3072,'XYZ-1767592431171-72EF8A86',5,NULL,'IN_STOCK','GRN','XYZ709922937','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3073,'XYZ-1767592431197-C20F58F6',5,NULL,'IN_STOCK','GRN','XYZ625383706','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3074,'XYZ-1767592431220-9D20DA9E',5,NULL,'IN_STOCK','GRN','XYZ015139828','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3075,'XYZ-1767592431243-E1BE2A3F',5,NULL,'IN_STOCK','GRN','XYZ726803314','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3076,'XYZ-1767592431268-791AE985',5,NULL,'IN_STOCK','GRN','XYZ225524485','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3077,'XYZ-1767592431293-E779CF38',5,NULL,'IN_STOCK','GRN','XYZ326967693','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3078,'XYZ-1767592431318-4420DD55',5,NULL,'IN_STOCK','GRN','XYZ996220419','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3079,'XYZ-1767592431342-9265CA00',5,NULL,'IN_STOCK','GRN','XYZ620418452','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3080,'XYZ-1767592431371-458061B0',5,NULL,'IN_STOCK','GRN','XYZ867701619','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3081,'XYZ-1767592431399-56457FF9',5,NULL,'IN_STOCK','GRN','XYZ443073057','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3082,'XYZ-1767592431426-257D3C7A',5,NULL,'IN_STOCK','GRN','XYZ013297399','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3083,'XYZ-1767592431456-D578E953',5,NULL,'IN_STOCK','GRN','XYZ553908228','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3084,'XYZ-1767592431483-E026D480',5,NULL,'IN_STOCK','GRN','XYZ558372736','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3085,'XYZ-1767592431508-58F50319',5,NULL,'IN_STOCK','GRN','XYZ173531435','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3086,'XYZ-1767592431536-F46EE195',5,NULL,'IN_STOCK','GRN','XYZ344439623','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3087,'XYZ-1767592431563-26A5E9C3',5,NULL,'IN_STOCK','GRN','XYZ491821770','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3088,'XYZ-1767592431592-E6C9B9E0',5,NULL,'IN_STOCK','GRN','XYZ905247167','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3089,'XYZ-1767592431619-B7DA62F4',5,NULL,'IN_STOCK','GRN','XYZ896058887','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3090,'XYZ-1767592431647-C2F63373',5,NULL,'IN_STOCK','GRN','XYZ568682262','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3091,'XYZ-1767592431674-7EA9742C',5,NULL,'IN_STOCK','GRN','XYZ758613671','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3092,'XYZ-1767592431701-BAA6948D',5,NULL,'IN_STOCK','GRN','XYZ412357715','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3093,'XYZ-1767592431729-BF15168C',5,NULL,'IN_STOCK','GRN','XYZ719591507','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3094,'XYZ-1767592431757-7554EFB6',5,NULL,'IN_STOCK','GRN','XYZ663825329','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3095,'XYZ-1767592431784-7FE457FB',5,NULL,'IN_STOCK','GRN','XYZ807389959','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3096,'XYZ-1767592431811-B40B4395',5,NULL,'IN_STOCK','GRN','XYZ896212876','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3097,'XYZ-1767592431840-A407F6B2',5,NULL,'IN_STOCK','GRN','XYZ499890247','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3098,'XYZ-1767592431867-AC81A04F',5,NULL,'IN_STOCK','GRN','XYZ079407520','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3099,'XYZ-1767592431894-084FDEB2',5,NULL,'IN_STOCK','GRN','XYZ301607149','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3100,'XYZ-1767592431921-2E0FD875',5,NULL,'IN_STOCK','GRN','XYZ110028537','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3101,'XYZ-1767592431950-8EEBCF63',5,NULL,'IN_STOCK','GRN','XYZ309472455','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3102,'XYZ-1767592431977-F9EE28C5',5,NULL,'IN_STOCK','GRN','XYZ718460904','2026-01-05 05:53:51','2026-01-05 05:53:51'),(3103,'XYZ-1767592432004-B7BA1660',5,NULL,'IN_STOCK','GRN','XYZ942978267','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3104,'XYZ-1767592432031-95E52984',5,NULL,'IN_STOCK','GRN','XYZ681738365','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3105,'XYZ-1767592432057-3CA4BC61',5,NULL,'IN_STOCK','GRN','XYZ283915172','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3106,'XYZ-1767592432084-4261620B',5,NULL,'IN_STOCK','GRN','XYZ517040179','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3107,'XYZ-1767592432113-B60A8D33',5,NULL,'IN_STOCK','GRN','XYZ218157646','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3108,'XYZ-1767592432140-258EC9E9',5,NULL,'IN_STOCK','GRN','XYZ107624966','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3109,'XYZ-1767592432168-94C89478',5,NULL,'IN_STOCK','GRN','XYZ730829547','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3110,'XYZ-1767592432195-C9A8A48C',5,NULL,'IN_STOCK','GRN','XYZ351301070','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3111,'XYZ-1767592432222-40CABE9B',5,NULL,'IN_STOCK','GRN','XYZ067875498','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3112,'XYZ-1767592432248-61872336',5,NULL,'IN_STOCK','GRN','XYZ976505958','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3113,'XYZ-1767592432274-F0D1CC28',5,NULL,'IN_STOCK','GRN','XYZ143905257','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3114,'XYZ-1767592432297-E1C65B5A',5,NULL,'IN_STOCK','GRN','XYZ618262203','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3115,'XYZ-1767592432324-D350074A',5,NULL,'IN_STOCK','GRN','XYZ608400717','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3116,'XYZ-1767592432348-7F94958E',5,NULL,'IN_STOCK','GRN','XYZ176690597','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3117,'XYZ-1767592432368-AE6E0155',5,NULL,'IN_STOCK','GRN','XYZ048796740','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3118,'XYZ-1767592432389-539EFD5A',5,NULL,'IN_STOCK','GRN','XYZ308179907','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3119,'XYZ-1767592432412-9C350048',5,NULL,'IN_STOCK','GRN','XYZ239988148','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3120,'XYZ-1767592432432-15A469C8',5,NULL,'IN_STOCK','GRN','XYZ686438663','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3121,'XYZ-1767592432453-CC9B5D9B',5,NULL,'IN_STOCK','GRN','XYZ453685033','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3122,'XYZ-1767592432478-F289B10C',5,NULL,'IN_STOCK','GRN','XYZ014800291','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3123,'XYZ-1767592432504-055B32E8',5,NULL,'IN_STOCK','GRN','XYZ027636342','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3124,'XYZ-1767592432531-4509782E',5,NULL,'IN_STOCK','GRN','XYZ335799970','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3125,'XYZ-1767592432557-24947780',5,NULL,'IN_STOCK','GRN','XYZ956132489','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3126,'XYZ-1767592432584-289971BB',5,NULL,'IN_STOCK','GRN','XYZ207527468','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3127,'XYZ-1767592432608-972C808B',5,NULL,'IN_STOCK','GRN','XYZ632550880','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3128,'XYZ-1767592432633-9BFFF617',5,NULL,'IN_STOCK','GRN','XYZ124255245','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3129,'XYZ-1767592432659-745828A7',5,NULL,'IN_STOCK','GRN','XYZ613893525','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3130,'XYZ-1767592432685-FF790615',5,NULL,'IN_STOCK','GRN','XYZ006414712','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3131,'XYZ-1767592432709-C2E330E1',5,NULL,'IN_STOCK','GRN','XYZ320532298','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3132,'XYZ-1767592432732-4711E805',5,NULL,'IN_STOCK','GRN','XYZ035719436','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3133,'XYZ-1767592432756-63C4212E',5,NULL,'IN_STOCK','GRN','XYZ834575600','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3134,'XYZ-1767592432777-E7EAB81A',5,NULL,'IN_STOCK','GRN','XYZ421818222','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3135,'XYZ-1767592432800-D75577A0',5,NULL,'IN_STOCK','GRN','XYZ421224455','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3136,'XYZ-1767592432828-25F54F80',5,NULL,'IN_STOCK','GRN','XYZ886227117','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3137,'XYZ-1767592432852-463DE337',5,NULL,'IN_STOCK','GRN','XYZ035327255','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3138,'XYZ-1767592432879-79BE17D7',5,NULL,'IN_STOCK','GRN','XYZ993806610','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3139,'XYZ-1767592432904-23DC3589',5,NULL,'IN_STOCK','GRN','XYZ517746502','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3140,'XYZ-1767592432930-9DF2CD32',5,NULL,'IN_STOCK','GRN','XYZ232050806','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3141,'XYZ-1767592432955-CE425A7F',5,NULL,'IN_STOCK','GRN','XYZ721499804','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3142,'XYZ-1767592432982-BABFAAEA',5,NULL,'IN_STOCK','GRN','XYZ311745023','2026-01-05 05:53:52','2026-01-05 05:53:52'),(3143,'XYZ-1767592433007-F4F13D39',5,NULL,'IN_STOCK','GRN','XYZ066910135','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3144,'XYZ-1767592433031-5CBCE387',5,NULL,'IN_STOCK','GRN','XYZ877042263','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3145,'XYZ-1767592433052-EDEF00E9',5,NULL,'IN_STOCK','GRN','XYZ242961145','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3146,'XYZ-1767592433073-88A44A1D',5,NULL,'IN_STOCK','GRN','XYZ054520705','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3147,'XYZ-1767592433094-06B2BA5F',5,NULL,'IN_STOCK','GRN','XYZ055071621','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3148,'XYZ-1767592433117-FA33A646',5,NULL,'IN_STOCK','GRN','XYZ116453065','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3149,'XYZ-1767592433140-1D632371',5,NULL,'IN_STOCK','GRN','XYZ501348444','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3150,'XYZ-1767592433165-691B6100',5,NULL,'IN_STOCK','GRN','XYZ807990947','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3151,'XYZ-1767592433191-584C7612',5,NULL,'IN_STOCK','GRN','XYZ462724712','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3152,'XYZ-1767592433216-A7D104E5',5,NULL,'IN_STOCK','GRN','XYZ502477569','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3153,'XYZ-1767592433242-9E6549A4',5,NULL,'IN_STOCK','GRN','XYZ353121410','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3154,'XYZ-1767592433267-50AB2039',5,NULL,'IN_STOCK','GRN','XYZ021011099','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3155,'XYZ-1767592433292-9B578F20',5,NULL,'IN_STOCK','GRN','XYZ293960819','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3156,'XYZ-1767592433314-DFD18AB5',5,NULL,'IN_STOCK','GRN','XYZ793152155','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3157,'XYZ-1767592433335-CFB2656A',5,NULL,'IN_STOCK','GRN','XYZ306280828','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3158,'XYZ-1767592433361-3AB66ECD',5,NULL,'IN_STOCK','GRN','XYZ306604122','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3159,'XYZ-1767592433386-30E1C207',5,NULL,'IN_STOCK','GRN','XYZ338300387','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3160,'XYZ-1767592433411-72FBBF3E',5,NULL,'IN_STOCK','GRN','XYZ214158794','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3161,'XYZ-1767592433435-9AFC63DC',5,NULL,'IN_STOCK','GRN','XYZ066812091','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3162,'XYZ-1767592433462-BF7894F4',5,NULL,'IN_STOCK','GRN','XYZ325220877','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3163,'XYZ-1767592433489-CF293AAA',5,NULL,'IN_STOCK','GRN','XYZ557883834','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3164,'XYZ-1767592433516-5B87D4DC',5,NULL,'IN_STOCK','GRN','XYZ476641017','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3165,'XYZ-1767592433542-ACC42A49',5,NULL,'IN_STOCK','GRN','XYZ606698564','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3166,'XYZ-1767592433571-68121278',5,NULL,'IN_STOCK','GRN','XYZ203147510','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3167,'XYZ-1767592433596-F3C83900',5,NULL,'IN_STOCK','GRN','XYZ215521287','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3168,'XYZ-1767592433624-48A776A7',5,NULL,'IN_STOCK','GRN','XYZ474601206','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3169,'XYZ-1767592433648-421BED90',5,NULL,'IN_STOCK','GRN','XYZ129747204','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3170,'XYZ-1767592433671-29563EAF',5,NULL,'IN_STOCK','GRN','XYZ728960500','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3171,'XYZ-1767592433694-9A1A4DB4',5,NULL,'IN_STOCK','GRN','XYZ496702300','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3172,'XYZ-1767592433720-C604F298',5,NULL,'IN_STOCK','GRN','XYZ056012963','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3173,'XYZ-1767592433743-322432F0',5,NULL,'IN_STOCK','GRN','XYZ345428962','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3174,'XYZ-1767592433765-0DF27A9F',5,NULL,'IN_STOCK','GRN','XYZ701533901','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3175,'XYZ-1767592433784-3AED9040',5,NULL,'IN_STOCK','GRN','XYZ650625861','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3176,'XYZ-1767592433808-4151A01D',5,NULL,'IN_STOCK','GRN','XYZ135702159','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3177,'XYZ-1767592433829-9046619A',5,NULL,'IN_STOCK','GRN','XYZ817108789','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3178,'XYZ-1767592433855-96436F0F',5,NULL,'IN_STOCK','GRN','XYZ225653146','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3179,'XYZ-1767592433876-A0B5B178',5,NULL,'IN_STOCK','GRN','XYZ996745239','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3180,'XYZ-1767592433897-8335BDFB',5,NULL,'IN_STOCK','GRN','XYZ036102510','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3181,'XYZ-1767592433918-19295131',5,NULL,'IN_STOCK','GRN','XYZ568565059','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3182,'XYZ-1767592433941-CB0171E9',5,NULL,'IN_STOCK','GRN','XYZ508282912','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3183,'XYZ-1767592433963-A399A57F',5,NULL,'IN_STOCK','GRN','XYZ036367905','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3184,'XYZ-1767592433984-D90C05F6',5,NULL,'IN_STOCK','GRN','XYZ546326637','2026-01-05 05:53:53','2026-01-05 05:53:53'),(3185,'XYZ-1767592434007-09F63BA9',5,NULL,'IN_STOCK','GRN','XYZ573048241','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3186,'XYZ-1767592434030-742C0E5F',5,NULL,'IN_STOCK','GRN','XYZ764603239','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3187,'XYZ-1767592434052-054E5834',5,NULL,'IN_STOCK','GRN','XYZ127482347','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3188,'XYZ-1767592434076-7EDB4ED6',5,NULL,'IN_STOCK','GRN','XYZ129462094','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3189,'XYZ-1767592434100-8D4F8DF0',5,NULL,'IN_STOCK','GRN','XYZ769834252','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3190,'XYZ-1767592434124-85B7CA9F',5,NULL,'IN_STOCK','GRN','XYZ031709065','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3191,'XYZ-1767592434145-AF0F293F',5,NULL,'IN_STOCK','GRN','XYZ634034566','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3192,'XYZ-1767592434166-BD6065E9',5,NULL,'IN_STOCK','GRN','XYZ076804724','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3193,'XYZ-1767592434190-C7F46AF2',5,NULL,'IN_STOCK','GRN','XYZ578508156','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3194,'XYZ-1767592434211-5C013F05',5,NULL,'IN_STOCK','GRN','XYZ690592791','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3195,'XYZ-1767592434232-CD8F1B6F',5,NULL,'IN_STOCK','GRN','XYZ827530737','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3196,'XYZ-1767592434258-799C3F0F',5,NULL,'IN_STOCK','GRN','XYZ545071114','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3197,'XYZ-1767592434282-80EC82D4',5,NULL,'IN_STOCK','GRN','XYZ721132979','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3198,'XYZ-1767592434306-F2FE68D6',5,NULL,'IN_STOCK','GRN','XYZ840963112','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3199,'XYZ-1767592434328-66736EAF',5,NULL,'IN_STOCK','GRN','XYZ211570424','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3200,'XYZ-1767592434350-D0024B3A',5,NULL,'IN_STOCK','GRN','XYZ976274263','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3201,'XYZ-1767592434373-07DBAA51',5,NULL,'IN_STOCK','GRN','XYZ224853868','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3202,'XYZ-1767592434399-B61A0C1F',5,NULL,'IN_STOCK','GRN','XYZ404942233','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3203,'XYZ-1767592434423-801F491B',5,NULL,'IN_STOCK','GRN','XYZ792262504','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3204,'XYZ-1767592434446-5D855FE9',5,NULL,'IN_STOCK','GRN','XYZ617542410','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3205,'XYZ-1767592434472-8571D284',5,NULL,'IN_STOCK','GRN','XYZ543839201','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3206,'XYZ-1767592434497-05A20966',5,NULL,'IN_STOCK','GRN','XYZ610985104','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3207,'XYZ-1767592434518-D47998B2',5,NULL,'IN_STOCK','GRN','XYZ966193184','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3208,'XYZ-1767592434543-5BA11C9C',5,NULL,'IN_STOCK','GRN','XYZ586481331','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3209,'XYZ-1767592434566-359C650F',5,NULL,'IN_STOCK','GRN','XYZ438842185','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3210,'XYZ-1767592434591-1DA44F7A',5,NULL,'IN_STOCK','GRN','XYZ198929885','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3211,'XYZ-1767592434616-C9A3960A',5,NULL,'IN_STOCK','GRN','XYZ533499692','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3212,'XYZ-1767592434640-6F937F34',5,NULL,'IN_STOCK','GRN','XYZ833180956','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3213,'XYZ-1767592434666-49A3F41B',5,NULL,'IN_STOCK','GRN','XYZ176113419','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3214,'XYZ-1767592434693-222A0EFA',5,NULL,'IN_STOCK','GRN','XYZ520541726','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3215,'XYZ-1767592434719-8F428EB0',5,NULL,'IN_STOCK','GRN','XYZ758639265','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3216,'XYZ-1767592434745-4B58CFE7',5,NULL,'IN_STOCK','GRN','XYZ232819716','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3217,'XYZ-1767592434770-5EF7F592',5,NULL,'IN_STOCK','GRN','XYZ768086052','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3218,'XYZ-1767592434796-650005F4',5,NULL,'IN_STOCK','GRN','XYZ938387877','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3219,'XYZ-1767592434821-D97FE59F',5,NULL,'IN_STOCK','GRN','XYZ770022385','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3220,'XYZ-1767592434846-3793D82C',5,NULL,'IN_STOCK','GRN','XYZ024067425','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3221,'XYZ-1767592434874-BBD52FF6',5,NULL,'IN_STOCK','GRN','XYZ865691080','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3222,'XYZ-1767592434903-75E7B664',5,NULL,'IN_STOCK','GRN','XYZ655425964','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3223,'XYZ-1767592434935-E1FF0FF2',5,NULL,'IN_STOCK','GRN','XYZ038688594','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3224,'XYZ-1767592434964-D74A07D7',5,NULL,'IN_STOCK','GRN','XYZ637666469','2026-01-05 05:53:54','2026-01-05 05:53:54'),(3225,'XYZ-1767592434992-95A7F750',5,NULL,'IN_STOCK','GRN','XYZ552253860','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3226,'XYZ-1767592435021-DEE8439E',5,NULL,'IN_STOCK','GRN','XYZ986926177','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3227,'XYZ-1767592435051-87F9FBB5',5,NULL,'IN_STOCK','GRN','XYZ719874237','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3228,'XYZ-1767592435078-AA286B0D',5,NULL,'IN_STOCK','GRN','XYZ447827245','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3229,'XYZ-1767592435112-03570519',5,NULL,'IN_STOCK','GRN','XYZ506056582','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3230,'XYZ-1767592435140-7FB8C675',5,NULL,'IN_STOCK','GRN','XYZ368504485','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3231,'XYZ-1767592435164-7A531D0F',5,NULL,'IN_STOCK','GRN','XYZ888183025','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3232,'XYZ-1767592435189-049958C2',5,NULL,'IN_STOCK','GRN','XYZ760441839','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3233,'XYZ-1767592435217-2C17A7F5',5,NULL,'IN_STOCK','GRN','XYZ469072502','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3234,'XYZ-1767592435241-35334B35',5,NULL,'IN_STOCK','GRN','XYZ102236464','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3235,'XYZ-1767592435263-045A0D7E',5,NULL,'IN_STOCK','GRN','XYZ897355500','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3236,'XYZ-1767592435287-928C46AB',5,NULL,'IN_STOCK','GRN','XYZ223776194','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3237,'XYZ-1767592435315-1A1B9203',5,NULL,'IN_STOCK','GRN','XYZ535297672','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3238,'XYZ-1767592435340-C1855CD1',5,NULL,'IN_STOCK','GRN','XYZ850695063','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3239,'XYZ-1767592435362-BC2C36C9',5,NULL,'IN_STOCK','GRN','XYZ781839561','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3240,'XYZ-1767592435386-488BA318',5,NULL,'IN_STOCK','GRN','XYZ778807144','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3241,'XYZ-1767592435410-FBD9587E',5,NULL,'IN_STOCK','GRN','XYZ049426557','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3242,'XYZ-1767592435434-5B8850C6',5,NULL,'IN_STOCK','GRN','XYZ102605440','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3243,'XYZ-1767592435457-363848AA',5,NULL,'IN_STOCK','GRN','XYZ911511301','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3244,'XYZ-1767592435478-93A3B6AB',5,NULL,'IN_STOCK','GRN','XYZ687878282','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3245,'XYZ-1767592435503-5A708E2A',5,NULL,'IN_STOCK','GRN','XYZ528683646','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3246,'XYZ-1767592435545-16B814D7',5,NULL,'IN_STOCK','GRN','XYZ557198253','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3247,'XYZ-1767592435570-197B7E07',5,NULL,'IN_STOCK','GRN','XYZ787035316','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3248,'XYZ-1767592435595-63570AA2',5,NULL,'IN_STOCK','GRN','XYZ305466775','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3249,'XYZ-1767592435618-17F9E34F',5,NULL,'IN_STOCK','GRN','XYZ309049938','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3250,'XYZ-1767592435645-E35AB775',5,NULL,'IN_STOCK','GRN','XYZ401222515','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3251,'XYZ-1767592435670-3572E55E',5,NULL,'IN_STOCK','GRN','XYZ889139388','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3252,'XYZ-1767592435698-3D6BE9D9',5,NULL,'IN_STOCK','GRN','XYZ319922069','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3253,'XYZ-1767592435726-B69350EB',5,NULL,'IN_STOCK','GRN','XYZ211128296','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3254,'XYZ-1767592435754-0E932EC3',5,NULL,'IN_STOCK','GRN','XYZ786647997','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3255,'XYZ-1767592435779-115D6824',5,NULL,'IN_STOCK','GRN','XYZ038577790','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3256,'XYZ-1767592435807-2ECB977A',5,NULL,'IN_STOCK','GRN','XYZ298133677','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3257,'XYZ-1767592435837-A0B3B808',5,NULL,'IN_STOCK','GRN','XYZ701473708','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3258,'XYZ-1767592435867-8742C0D8',5,NULL,'IN_STOCK','GRN','XYZ239432663','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3259,'XYZ-1767592435900-BCCEAC92',5,NULL,'IN_STOCK','GRN','XYZ669655459','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3260,'XYZ-1767592435927-E0A7EAAD',5,NULL,'IN_STOCK','GRN','XYZ470048419','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3261,'XYZ-1767592435954-F99D9F57',5,NULL,'IN_STOCK','GRN','XYZ114739394','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3262,'XYZ-1767592435981-5A3DC52A',5,NULL,'IN_STOCK','GRN','XYZ912787622','2026-01-05 05:53:55','2026-01-05 05:53:55'),(3263,'XYZ-1767592436010-A64114BD',5,NULL,'IN_STOCK','GRN','XYZ289808004','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3264,'XYZ-1767592436036-5364E74A',5,NULL,'IN_STOCK','GRN','XYZ997124238','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3265,'XYZ-1767592436060-173E8975',5,NULL,'IN_STOCK','GRN','XYZ559734610','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3266,'XYZ-1767592436083-1DCF9FFD',5,NULL,'IN_STOCK','GRN','XYZ052344022','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3267,'XYZ-1767592436111-B66F6F51',5,NULL,'IN_STOCK','GRN','XYZ011914670','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3268,'XYZ-1767592436132-EB54AB24',5,NULL,'IN_STOCK','GRN','XYZ984641426','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3269,'XYZ-1767592436158-C899D6C5',5,NULL,'IN_STOCK','GRN','XYZ223710152','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3270,'XYZ-1767592436185-1942CF65',5,NULL,'IN_STOCK','GRN','XYZ750428440','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3271,'XYZ-1767592436207-EFA9CCCA',5,NULL,'IN_STOCK','GRN','XYZ411371417','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3272,'XYZ-1767592436229-AB6BA303',5,NULL,'IN_STOCK','GRN','XYZ039821224','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3273,'XYZ-1767592436253-3F6DFEE2',5,NULL,'IN_STOCK','GRN','XYZ023623156','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3274,'XYZ-1767592436276-38733C67',5,NULL,'IN_STOCK','GRN','XYZ887423507','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3275,'XYZ-1767592436300-16044353',5,NULL,'IN_STOCK','GRN','XYZ805918117','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3276,'XYZ-1767592436324-00CC614C',5,NULL,'IN_STOCK','GRN','XYZ603509988','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3277,'XYZ-1767592436348-BB91E704',5,NULL,'IN_STOCK','GRN','XYZ230605415','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3278,'XYZ-1767592436371-A4F375C0',5,NULL,'IN_STOCK','GRN','XYZ067970119','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3279,'XYZ-1767592436397-70840689',5,NULL,'IN_STOCK','GRN','XYZ799893486','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3280,'XYZ-1767592436423-BB51A3D1',5,NULL,'IN_STOCK','GRN','XYZ634010497','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3281,'XYZ-1767592436447-057ED327',5,NULL,'IN_STOCK','GRN','XYZ258398933','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3282,'XYZ-1767592436472-058E036B',5,NULL,'IN_STOCK','GRN','XYZ630226165','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3283,'XYZ-1767592436498-F8DE132F',5,NULL,'IN_STOCK','GRN','XYZ847465066','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3284,'XYZ-1767592436521-7EBC1CC8',5,NULL,'IN_STOCK','GRN','XYZ665326455','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3285,'XYZ-1767592436544-425A61AF',5,NULL,'IN_STOCK','GRN','XYZ124570062','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3286,'XYZ-1767592436567-8B818EA0',5,NULL,'IN_STOCK','GRN','XYZ928380530','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3287,'XYZ-1767592436592-5164505B',5,NULL,'IN_STOCK','GRN','XYZ839655297','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3288,'XYZ-1767592436612-DF6EAD79',5,NULL,'IN_STOCK','GRN','XYZ973047227','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3289,'XYZ-1767592436634-FA00FFD3',5,NULL,'IN_STOCK','GRN','XYZ922782273','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3290,'XYZ-1767592436660-32D4F803',5,NULL,'IN_STOCK','GRN','XYZ502594182','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3291,'XYZ-1767592436685-E9335633',5,NULL,'IN_STOCK','GRN','XYZ729179958','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3292,'XYZ-1767592436715-5AC74B1F',5,NULL,'IN_STOCK','GRN','XYZ132456196','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3293,'XYZ-1767592436743-F85E927C',5,NULL,'IN_STOCK','GRN','XYZ843223726','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3294,'XYZ-1767592436771-FC9B8297',5,NULL,'IN_STOCK','GRN','XYZ700658711','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3295,'XYZ-1767592436799-31803321',5,NULL,'IN_STOCK','GRN','XYZ727514013','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3296,'XYZ-1767592436825-AA7CF7C7',5,NULL,'IN_STOCK','GRN','XYZ148610375','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3297,'XYZ-1767592436852-3EE5403E',5,NULL,'IN_STOCK','GRN','XYZ165042366','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3298,'XYZ-1767592436879-66F8C8D6',5,NULL,'IN_STOCK','GRN','XYZ883221141','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3299,'XYZ-1767592436906-EB4B8D08',5,NULL,'IN_STOCK','GRN','XYZ473010145','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3300,'XYZ-1767592436931-3CFB7CD8',5,NULL,'IN_STOCK','GRN','XYZ285886027','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3301,'XYZ-1767592436958-50A3C089',5,NULL,'IN_STOCK','GRN','XYZ819644913','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3302,'XYZ-1767592436983-F9093B77',5,NULL,'IN_STOCK','GRN','XYZ438358415','2026-01-05 05:53:56','2026-01-05 05:53:56'),(3303,'XYZ-1767592437010-DBD221BB',5,NULL,'IN_STOCK','GRN','XYZ697097549','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3304,'XYZ-1767592437039-45062D05',5,NULL,'IN_STOCK','GRN','XYZ401810603','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3305,'XYZ-1767592437066-60319163',5,NULL,'IN_STOCK','GRN','XYZ413046924','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3306,'XYZ-1767592437090-977820CB',5,NULL,'IN_STOCK','GRN','XYZ036156299','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3307,'XYZ-1767592437114-F9119130',5,NULL,'IN_STOCK','GRN','XYZ909181777','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3308,'XYZ-1767592437138-E22B6F60',5,NULL,'IN_STOCK','GRN','XYZ221477490','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3309,'XYZ-1767592437161-49F113F2',5,NULL,'IN_STOCK','GRN','XYZ935978442','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3310,'XYZ-1767592437186-58ADE13A',5,NULL,'IN_STOCK','GRN','XYZ113320802','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3311,'XYZ-1767592437209-FE020E00',5,NULL,'IN_STOCK','GRN','XYZ153017739','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3312,'XYZ-1767592437233-44776205',5,NULL,'IN_STOCK','GRN','XYZ352629348','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3313,'XYZ-1767592437261-C1BA9980',5,NULL,'IN_STOCK','GRN','XYZ480128649','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3314,'XYZ-1767592437286-D05AA23A',5,NULL,'IN_STOCK','GRN','XYZ974286657','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3315,'XYZ-1767592437312-CEF617C3',5,NULL,'IN_STOCK','GRN','XYZ156547149','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3316,'XYZ-1767592437340-E850BF67',5,NULL,'IN_STOCK','GRN','XYZ206313240','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3317,'XYZ-1767592437366-7B00F1CF',5,NULL,'IN_STOCK','GRN','XYZ180550241','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3318,'XYZ-1767592437391-6E7DE833',5,NULL,'IN_STOCK','GRN','XYZ438200404','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3319,'XYZ-1767592437416-1018DBA7',5,NULL,'IN_STOCK','GRN','XYZ445809027','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3320,'XYZ-1767592437444-23BBD636',5,NULL,'IN_STOCK','GRN','XYZ416938830','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3321,'XYZ-1767592437468-EBCB9EBD',5,NULL,'IN_STOCK','GRN','XYZ577514951','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3322,'XYZ-1767592437497-81894350',5,NULL,'IN_STOCK','GRN','XYZ415443608','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3323,'XYZ-1767592437524-EB311763',5,NULL,'IN_STOCK','GRN','XYZ014017698','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3324,'XYZ-1767592437552-6F200AFF',5,NULL,'IN_STOCK','GRN','XYZ808970409','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3325,'XYZ-1767592437579-39BBD430',5,NULL,'IN_STOCK','GRN','XYZ761934526','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3326,'XYZ-1767592437607-ECC0F306',5,NULL,'IN_STOCK','GRN','XYZ036535623','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3327,'XYZ-1767592437636-4CD5DDA0',5,NULL,'IN_STOCK','GRN','XYZ341698362','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3328,'XYZ-1767592437663-A644BB61',5,NULL,'IN_STOCK','GRN','XYZ853019299','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3329,'XYZ-1767592437691-540EFD4B',5,NULL,'IN_STOCK','GRN','XYZ149054130','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3330,'XYZ-1767592437718-199AD86A',5,NULL,'IN_STOCK','GRN','XYZ730424794','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3331,'XYZ-1767592437746-73D6E67D',5,NULL,'IN_STOCK','GRN','XYZ806958236','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3332,'XYZ-1767592437772-0E22013D',5,NULL,'IN_STOCK','GRN','XYZ365081567','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3333,'XYZ-1767592437799-08AA722B',5,NULL,'IN_STOCK','GRN','XYZ340866061','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3334,'XYZ-1767592437826-D0D174F3',5,NULL,'IN_STOCK','GRN','XYZ311931523','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3335,'XYZ-1767592437852-88F9BAF4',5,NULL,'IN_STOCK','GRN','XYZ579974120','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3336,'XYZ-1767592437876-1D2FA924',5,NULL,'IN_STOCK','GRN','XYZ794038422','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3337,'XYZ-1767592437897-D4CF79EE',5,NULL,'IN_STOCK','GRN','XYZ113032849','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3338,'XYZ-1767592437919-5EF47E53',5,NULL,'IN_STOCK','GRN','XYZ473906002','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3339,'XYZ-1767592437941-87F62142',5,NULL,'IN_STOCK','GRN','XYZ901818932','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3340,'XYZ-1767592437966-5CA1794F',5,NULL,'IN_STOCK','GRN','XYZ454417338','2026-01-05 05:53:57','2026-01-05 05:53:57'),(3341,'XYZ-1767592437991-7C0E1634',5,NULL,'IN_STOCK','GRN','XYZ401205295','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3342,'XYZ-1767592438015-3EFB413B',5,NULL,'IN_STOCK','GRN','XYZ374471700','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3343,'XYZ-1767592438040-978ECA6F',5,NULL,'IN_STOCK','GRN','XYZ192001108','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3344,'XYZ-1767592438064-642F54F9',5,NULL,'IN_STOCK','GRN','XYZ182959023','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3345,'XYZ-1767592438088-76B8A626',5,NULL,'IN_STOCK','GRN','XYZ859573189','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3346,'XYZ-1767592438109-A1A888AF',5,NULL,'IN_STOCK','GRN','XYZ932614697','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3347,'XYZ-1767592438138-7627FEC4',5,NULL,'IN_STOCK','GRN','XYZ598891219','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3348,'XYZ-1767592438163-46DE284E',5,NULL,'IN_STOCK','GRN','XYZ212049037','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3349,'XYZ-1767592438182-EBB6500A',5,NULL,'IN_STOCK','GRN','XYZ221922468','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3350,'XYZ-1767592438204-C8AECC58',5,NULL,'IN_STOCK','GRN','XYZ399740267','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3351,'XYZ-1767592438228-D708D8AB',5,NULL,'IN_STOCK','GRN','XYZ978099780','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3352,'XYZ-1767592438254-5F46467D',5,NULL,'IN_STOCK','GRN','XYZ622705818','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3353,'XYZ-1767592438282-39333580',5,NULL,'IN_STOCK','GRN','XYZ124447522','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3354,'XYZ-1767592438309-3EAEB773',5,NULL,'IN_STOCK','GRN','XYZ590773116','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3355,'XYZ-1767592438337-56F06A89',5,NULL,'IN_STOCK','GRN','XYZ098895856','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3356,'XYZ-1767592438364-F15A5992',5,NULL,'IN_STOCK','GRN','XYZ285166118','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3357,'XYZ-1767592438391-34AFCCAE',5,NULL,'IN_STOCK','GRN','XYZ657095786','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3358,'XYZ-1767592438417-CFE07347',5,NULL,'IN_STOCK','GRN','XYZ796871920','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3359,'XYZ-1767592438443-AFB8D2C1',5,NULL,'IN_STOCK','GRN','XYZ112993061','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3360,'XYZ-1767592438471-B89889A5',5,NULL,'IN_STOCK','GRN','XYZ212763414','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3361,'XYZ-1767592438499-B82F6F40',5,NULL,'IN_STOCK','GRN','XYZ204682603','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3362,'XYZ-1767592438524-06BA4BDF',5,NULL,'IN_STOCK','GRN','XYZ192438507','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3363,'XYZ-1767592438546-C51FC675',5,NULL,'IN_STOCK','GRN','XYZ835653044','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3364,'XYZ-1767592438570-0480ECE6',5,NULL,'IN_STOCK','GRN','XYZ816737915','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3365,'XYZ-1767592438597-A9F06667',5,NULL,'IN_STOCK','GRN','XYZ047758702','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3366,'XYZ-1767592438622-E8E07275',5,NULL,'IN_STOCK','GRN','XYZ850082518','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3367,'XYZ-1767592438647-C813F585',5,NULL,'IN_STOCK','GRN','XYZ536654038','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3368,'XYZ-1767592438671-EF815AD2',5,NULL,'IN_STOCK','GRN','XYZ479502459','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3369,'XYZ-1767592438697-FA37554D',5,NULL,'IN_STOCK','GRN','XYZ618871978','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3370,'XYZ-1767592438723-5820FCFA',5,NULL,'IN_STOCK','GRN','XYZ573738034','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3371,'XYZ-1767592438750-898C4BD5',5,NULL,'IN_STOCK','GRN','XYZ668962199','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3372,'XYZ-1767592438776-4D310AAC',5,NULL,'IN_STOCK','GRN','XYZ532353364','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3373,'XYZ-1767592438803-DDA57D05',5,NULL,'IN_STOCK','GRN','XYZ871404646','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3374,'XYZ-1767592438829-FE6FE391',5,NULL,'IN_STOCK','GRN','XYZ296445621','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3375,'XYZ-1767592438854-7599719E',5,NULL,'IN_STOCK','GRN','XYZ174608554','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3376,'XYZ-1767592438881-AA43B5E2',5,NULL,'IN_STOCK','GRN','XYZ887655200','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3377,'XYZ-1767592438909-AC6DA4C8',5,NULL,'IN_STOCK','GRN','XYZ578074379','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3378,'XYZ-1767592438933-85E26E84',5,NULL,'IN_STOCK','GRN','XYZ544548509','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3379,'XYZ-1767592438957-0C09B9ED',5,NULL,'IN_STOCK','GRN','XYZ459966710','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3380,'XYZ-1767592438978-BBE8BD3A',5,NULL,'IN_STOCK','GRN','XYZ339699227','2026-01-05 05:53:58','2026-01-05 05:53:58'),(3381,'XYZ-1767592439003-D14E9E88',5,NULL,'IN_STOCK','GRN','XYZ667224709','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3382,'XYZ-1767592439028-F21BB7AB',5,NULL,'IN_STOCK','GRN','XYZ648188275','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3383,'XYZ-1767592439052-BED1B03B',5,NULL,'IN_STOCK','GRN','XYZ429672644','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3384,'XYZ-1767592439079-0BBCC1DF',5,NULL,'IN_STOCK','GRN','XYZ230236643','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3385,'XYZ-1767592439106-3986EFD0',5,NULL,'IN_STOCK','GRN','XYZ085685761','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3386,'XYZ-1767592439129-7FF41FFE',5,NULL,'IN_STOCK','GRN','XYZ870093458','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3387,'XYZ-1767592439151-8DF9F54F',5,NULL,'IN_STOCK','GRN','XYZ030444121','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3388,'XYZ-1767592439171-8BBD7E4D',5,NULL,'IN_STOCK','GRN','XYZ341223902','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3389,'XYZ-1767592439195-ADFC556C',5,NULL,'IN_STOCK','GRN','XYZ326167466','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3390,'XYZ-1767592439220-F504F327',5,NULL,'IN_STOCK','GRN','XYZ859977107','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3391,'XYZ-1767592439245-9F9D203B',5,NULL,'IN_STOCK','GRN','XYZ411198723','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3392,'XYZ-1767592439271-2C7A30E8',5,NULL,'IN_STOCK','GRN','XYZ619505306','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3393,'XYZ-1767592439297-BBDFFD66',5,NULL,'IN_STOCK','GRN','XYZ727621591','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3394,'XYZ-1767592439324-361B10B2',5,NULL,'IN_STOCK','GRN','XYZ674864713','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3395,'XYZ-1767592439349-AE046E91',5,NULL,'IN_STOCK','GRN','XYZ327627095','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3396,'XYZ-1767592439374-D9F33116',5,NULL,'IN_STOCK','GRN','XYZ933532961','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3397,'XYZ-1767592439401-CB3B138F',5,NULL,'IN_STOCK','GRN','XYZ696714170','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3398,'XYZ-1767592439427-5AF12199',5,NULL,'IN_STOCK','GRN','XYZ909775698','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3399,'XYZ-1767592439452-85C3EB3D',5,NULL,'IN_STOCK','GRN','XYZ469970361','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3400,'XYZ-1767592439477-DE4A14F0',5,NULL,'IN_STOCK','GRN','XYZ862108623','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3401,'XYZ-1767592439503-94C72182',5,NULL,'IN_STOCK','GRN','XYZ765923545','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3402,'XYZ-1767592439528-46D50A17',5,NULL,'IN_STOCK','GRN','XYZ796016910','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3403,'XYZ-1767592439554-5F1E82E9',5,NULL,'IN_STOCK','GRN','XYZ463812169','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3404,'XYZ-1767592439579-61B8E68E',5,NULL,'IN_STOCK','GRN','XYZ407909492','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3405,'XYZ-1767592439606-F5BABE41',5,NULL,'IN_STOCK','GRN','XYZ306899108','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3406,'XYZ-1767592439631-64CA09DB',5,NULL,'IN_STOCK','GRN','XYZ586567365','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3407,'XYZ-1767592439655-1982709D',5,NULL,'IN_STOCK','GRN','XYZ740160154','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3408,'XYZ-1767592439678-0589A6A9',5,NULL,'IN_STOCK','GRN','XYZ598173118','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3409,'XYZ-1767592439703-FB589938',5,NULL,'IN_STOCK','GRN','XYZ556655637','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3410,'XYZ-1767592439730-1CAD4743',5,NULL,'IN_STOCK','GRN','XYZ675966707','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3411,'XYZ-1767592439756-FB2BF2AC',5,NULL,'IN_STOCK','GRN','XYZ832309599','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3412,'XYZ-1767592439780-4CAA623C',5,NULL,'IN_STOCK','GRN','XYZ526415943','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3413,'XYZ-1767592439804-11AB3976',5,NULL,'IN_STOCK','GRN','XYZ436352877','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3414,'XYZ-1767592439826-5242E7E8',5,NULL,'IN_STOCK','GRN','XYZ538305566','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3415,'XYZ-1767592439848-C3918580',5,NULL,'IN_STOCK','GRN','XYZ557440091','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3416,'XYZ-1767592439874-2ED0FEDD',5,NULL,'IN_STOCK','GRN','XYZ048919564','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3417,'XYZ-1767592439899-E45B043B',5,NULL,'IN_STOCK','GRN','XYZ308972335','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3418,'XYZ-1767592439925-4E0800B6',5,NULL,'IN_STOCK','GRN','XYZ379153506','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3419,'XYZ-1767592439950-5FD2EB32',5,NULL,'IN_STOCK','GRN','XYZ303332017','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3420,'XYZ-1767592439974-7FC61FB3',5,NULL,'IN_STOCK','GRN','XYZ720546553','2026-01-05 05:53:59','2026-01-05 05:53:59'),(3421,'XYZ-1767592439995-44647E7E',5,NULL,'IN_STOCK','GRN','XYZ461759747','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3422,'XYZ-1767592440022-D88CE961',5,NULL,'IN_STOCK','GRN','XYZ914680140','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3423,'XYZ-1767592440047-83B56D77',5,NULL,'IN_STOCK','GRN','XYZ314251637','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3424,'XYZ-1767592440071-1BACE006',5,NULL,'IN_STOCK','GRN','XYZ530266790','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3425,'XYZ-1767592440096-4AACA0A8',5,NULL,'IN_STOCK','GRN','XYZ463396743','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3426,'XYZ-1767592440122-8F0663CB',5,NULL,'IN_STOCK','GRN','XYZ069308027','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3427,'XYZ-1767592440149-90336EA0',5,NULL,'IN_STOCK','GRN','XYZ831314528','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3428,'XYZ-1767592440177-8E0D869F',5,NULL,'IN_STOCK','GRN','XYZ165408841','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3429,'XYZ-1767592440201-1C03EB34',5,NULL,'IN_STOCK','GRN','XYZ542148167','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3430,'XYZ-1767592440227-6C96B91B',5,NULL,'IN_STOCK','GRN','XYZ361172555','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3431,'XYZ-1767592440251-B466AFFD',5,NULL,'IN_STOCK','GRN','XYZ794492020','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3432,'XYZ-1767592440273-07BF6909',5,NULL,'IN_STOCK','GRN','XYZ980184725','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3433,'XYZ-1767592440298-49B0FEBA',5,NULL,'IN_STOCK','GRN','XYZ271930629','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3434,'XYZ-1767592440321-386ABBC0',5,NULL,'IN_STOCK','GRN','XYZ885423823','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3435,'XYZ-1767592440348-C8BFC145',5,NULL,'IN_STOCK','GRN','XYZ622244265','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3436,'XYZ-1767592440373-40733293',5,NULL,'IN_STOCK','GRN','XYZ813310227','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3437,'XYZ-1767592440397-2C03DE9A',5,NULL,'IN_STOCK','GRN','XYZ903256971','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3438,'XYZ-1767592440421-2105821B',5,NULL,'IN_STOCK','GRN','XYZ575743632','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3439,'XYZ-1767592440443-137D3511',5,NULL,'IN_STOCK','GRN','XYZ123783161','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3440,'XYZ-1767592440465-22109043',5,NULL,'IN_STOCK','GRN','XYZ275011395','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3441,'XYZ-1767592440487-90139F15',5,NULL,'IN_STOCK','GRN','XYZ616501064','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3442,'XYZ-1767592440512-56B6747A',5,NULL,'IN_STOCK','GRN','XYZ247327195','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3443,'XYZ-1767592440536-A43BEC69',5,NULL,'IN_STOCK','GRN','XYZ560753485','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3444,'XYZ-1767592440558-01137D62',5,NULL,'IN_STOCK','GRN','XYZ572430745','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3445,'XYZ-1767592440582-2E86FE32',5,NULL,'IN_STOCK','GRN','XYZ207820553','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3446,'XYZ-1767592440606-860B9622',5,NULL,'IN_STOCK','GRN','XYZ981430335','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3447,'XYZ-1767592440631-A9B4D5B9',5,NULL,'IN_STOCK','GRN','XYZ622236170','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3448,'XYZ-1767592440656-32DAF3F0',5,NULL,'IN_STOCK','GRN','XYZ369110730','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3449,'XYZ-1767592440684-E92CCE4E',5,NULL,'IN_STOCK','GRN','XYZ628593848','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3450,'XYZ-1767592440707-1412E2D9',5,NULL,'IN_STOCK','GRN','XYZ626566335','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3451,'XYZ-1767592440732-EA59418F',5,NULL,'IN_STOCK','GRN','XYZ504395902','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3452,'XYZ-1767592440754-4AB0DB6F',5,NULL,'IN_STOCK','GRN','XYZ276020932','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3453,'XYZ-1767592440776-815083AB',5,NULL,'IN_STOCK','GRN','XYZ379029113','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3454,'XYZ-1767592440797-1A1CE503',5,NULL,'IN_STOCK','GRN','XYZ765592323','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3455,'XYZ-1767592440823-A51D8567',5,NULL,'IN_STOCK','GRN','XYZ384276599','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3456,'XYZ-1767592440846-481DDDD2',5,NULL,'IN_STOCK','GRN','XYZ216592382','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3457,'XYZ-1767592440872-D48DE05C',5,NULL,'IN_STOCK','GRN','XYZ861740772','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3458,'XYZ-1767592440895-7E45A995',5,NULL,'IN_STOCK','GRN','XYZ265126425','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3459,'XYZ-1767592440924-F29D1245',5,NULL,'IN_STOCK','GRN','XYZ663307096','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3460,'XYZ-1767592440950-72F8EC10',5,NULL,'IN_STOCK','GRN','XYZ433964552','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3461,'XYZ-1767592440976-866D625D',5,NULL,'IN_STOCK','GRN','XYZ641382263','2026-01-05 05:54:00','2026-01-05 05:54:00'),(3462,'XYZ-1767592441002-BA9D8452',5,NULL,'IN_STOCK','GRN','XYZ371174166','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3463,'XYZ-1767592441027-1D06D59D',5,NULL,'IN_STOCK','GRN','XYZ370763140','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3464,'XYZ-1767592441049-8C64BB44',5,NULL,'IN_STOCK','GRN','XYZ338142078','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3465,'XYZ-1767592441070-DEFB7425',5,NULL,'IN_STOCK','GRN','XYZ474566512','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3466,'XYZ-1767592441092-9CCD32FF',5,NULL,'IN_STOCK','GRN','XYZ947401269','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3467,'XYZ-1767592441113-33FD77B9',5,NULL,'IN_STOCK','GRN','XYZ695614364','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3468,'XYZ-1767592441137-E12B91F6',5,NULL,'IN_STOCK','GRN','XYZ416705628','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3469,'XYZ-1767592441162-5F0D3B39',5,NULL,'IN_STOCK','GRN','XYZ675461704','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3470,'XYZ-1767592441186-8F4FAC1D',5,NULL,'IN_STOCK','GRN','XYZ824435720','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3471,'XYZ-1767592441209-B4255C49',5,NULL,'IN_STOCK','GRN','XYZ479380610','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3472,'XYZ-1767592441234-71E012CB',5,NULL,'IN_STOCK','GRN','XYZ631546745','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3473,'XYZ-1767592441259-86266193',5,NULL,'IN_STOCK','GRN','XYZ036122267','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3474,'XYZ-1767592441285-FECA4A6E',5,NULL,'IN_STOCK','GRN','XYZ005874354','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3475,'XYZ-1767592441313-E8076030',5,NULL,'IN_STOCK','GRN','XYZ838465078','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3476,'XYZ-1767592441339-1FDF71A0',5,NULL,'IN_STOCK','GRN','XYZ799879683','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3477,'XYZ-1767592441366-BECBBE8D',5,NULL,'IN_STOCK','GRN','XYZ623778763','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3478,'XYZ-1767592441390-4AC98BED',5,NULL,'IN_STOCK','GRN','XYZ811142636','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3479,'XYZ-1767592441415-1B461CF8',5,NULL,'IN_STOCK','GRN','XYZ358131294','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3480,'XYZ-1767592441442-9EBC494D',5,NULL,'IN_STOCK','GRN','XYZ741064687','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3481,'XYZ-1767592441469-926E485F',5,NULL,'IN_STOCK','GRN','XYZ639305862','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3482,'XYZ-1767592441496-B95BF751',5,NULL,'IN_STOCK','GRN','XYZ534131597','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3483,'XYZ-1767592441523-9721AC37',5,NULL,'IN_STOCK','GRN','XYZ956562265','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3484,'XYZ-1767592441549-FDFF4FAE',5,NULL,'IN_STOCK','GRN','XYZ617376313','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3485,'XYZ-1767592441575-071770D5',5,NULL,'IN_STOCK','GRN','XYZ196621936','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3486,'XYZ-1767592441599-F722C077',5,NULL,'IN_STOCK','GRN','XYZ841880140','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3487,'XYZ-1767592441626-5B5C7676',5,NULL,'IN_STOCK','GRN','XYZ577187235','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3488,'XYZ-1767592441651-58762577',5,NULL,'IN_STOCK','GRN','XYZ617549640','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3489,'XYZ-1767592441678-4F6CF844',5,NULL,'IN_STOCK','GRN','XYZ127847573','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3490,'XYZ-1767592441705-B882F50E',5,NULL,'IN_STOCK','GRN','XYZ176903435','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3491,'XYZ-1767592441729-EA0741CD',5,NULL,'IN_STOCK','GRN','XYZ679624155','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3492,'XYZ-1767592441752-FF14B655',5,NULL,'IN_STOCK','GRN','XYZ030900422','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3493,'XYZ-1767592441775-CA63C6BE',5,NULL,'IN_STOCK','GRN','XYZ318792817','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3494,'XYZ-1767592441793-E49FE448',5,NULL,'IN_STOCK','GRN','XYZ982881269','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3495,'XYZ-1767592441813-7CE51056',5,NULL,'IN_STOCK','GRN','XYZ687388542','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3496,'XYZ-1767592441839-F50AF1E1',5,NULL,'IN_STOCK','GRN','XYZ285848392','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3497,'XYZ-1767592441861-822C8A86',5,NULL,'IN_STOCK','GRN','XYZ781301520','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3498,'XYZ-1767592441883-86B23327',5,NULL,'IN_STOCK','GRN','XYZ587062965','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3499,'XYZ-1767592441908-DCF61B92',5,NULL,'IN_STOCK','GRN','XYZ312319406','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3500,'XYZ-1767592441934-DA668FD6',5,NULL,'IN_STOCK','GRN','XYZ829706675','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3501,'XYZ-1767592441957-251654A6',5,NULL,'IN_STOCK','GRN','XYZ731105819','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3502,'XYZ-1767592441978-020C015D',5,NULL,'IN_STOCK','GRN','XYZ286334055','2026-01-05 05:54:01','2026-01-05 05:54:01'),(3503,'XYZ-1767592442006-456F6C5D',5,NULL,'IN_STOCK','GRN','XYZ755935931','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3504,'XYZ-1767592442034-4C017A15',5,NULL,'IN_STOCK','GRN','XYZ406981334','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3505,'XYZ-1767592442059-F514CC91',5,NULL,'IN_STOCK','GRN','XYZ563686993','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3506,'XYZ-1767592442087-0880AFA2',5,NULL,'IN_STOCK','GRN','XYZ223840803','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3507,'XYZ-1767592442115-84EA5846',5,NULL,'IN_STOCK','GRN','XYZ416154475','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3508,'XYZ-1767592442140-56FAC977',5,NULL,'IN_STOCK','GRN','XYZ934838382','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3509,'XYZ-1767592442164-6AA31F0C',5,NULL,'IN_STOCK','GRN','XYZ537232643','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3510,'XYZ-1767592442189-8E657AE9',5,NULL,'IN_STOCK','GRN','XYZ548063387','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3511,'XYZ-1767592442213-2251D54D',5,NULL,'IN_STOCK','GRN','XYZ964893454','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3512,'XYZ-1767592442237-B6D75088',5,NULL,'IN_STOCK','GRN','XYZ486331824','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3513,'XYZ-1767592442263-519CFA95',5,NULL,'IN_STOCK','GRN','XYZ260355327','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3514,'XYZ-1767592442287-AD29A7C3',5,NULL,'IN_STOCK','GRN','XYZ929798819','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3515,'XYZ-1767592442313-505C1B6E',5,NULL,'IN_STOCK','GRN','XYZ362927906','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3516,'XYZ-1767592442339-65AA7842',5,NULL,'IN_STOCK','GRN','XYZ117225131','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3517,'XYZ-1767592442363-E0921F19',5,NULL,'IN_STOCK','GRN','XYZ263689041','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3518,'XYZ-1767592442385-80018C69',5,NULL,'IN_STOCK','GRN','XYZ042315285','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3519,'XYZ-1767592442408-11891DC7',5,NULL,'IN_STOCK','GRN','XYZ423202055','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3520,'XYZ-1767592442433-9D0D72D6',5,NULL,'IN_STOCK','GRN','XYZ257702965','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3521,'XYZ-1767592442456-6DC4DC61',5,NULL,'IN_STOCK','GRN','XYZ772589910','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3522,'XYZ-1767592442478-3A39EE6B',5,NULL,'IN_STOCK','GRN','XYZ954925231','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3523,'XYZ-1767592442502-2C9F9454',5,NULL,'IN_STOCK','GRN','XYZ150112878','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3524,'XYZ-1767592442529-5EA31825',5,NULL,'IN_STOCK','GRN','XYZ951886192','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3525,'XYZ-1767592442559-033AC84B',5,NULL,'IN_STOCK','GRN','XYZ501744429','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3526,'XYZ-1767592442585-607C7629',5,NULL,'IN_STOCK','GRN','XYZ789086547','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3527,'XYZ-1767592442611-7E01FC61',5,NULL,'IN_STOCK','GRN','XYZ274817353','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3528,'XYZ-1767592442638-CE134E7E',5,NULL,'IN_STOCK','GRN','XYZ489372365','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3529,'XYZ-1767592442657-59D09E22',5,NULL,'IN_STOCK','GRN','XYZ342173150','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3530,'XYZ-1767592442677-158832AC',5,NULL,'IN_STOCK','GRN','XYZ676179472','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3531,'XYZ-1767592442695-C8052011',5,NULL,'IN_STOCK','GRN','XYZ367834048','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3532,'XYZ-1767592442714-942CC688',5,NULL,'IN_STOCK','GRN','XYZ591204690','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3533,'XYZ-1767592442735-2304999B',5,NULL,'IN_STOCK','GRN','XYZ543940932','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3534,'XYZ-1767592442764-75B267BD',5,NULL,'IN_STOCK','GRN','XYZ682393753','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3535,'XYZ-1767592442793-CC40D9EA',5,NULL,'IN_STOCK','GRN','XYZ972968681','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3536,'XYZ-1767592442819-27870473',5,NULL,'IN_STOCK','GRN','XYZ746743374','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3537,'XYZ-1767592442846-9673A05F',5,NULL,'IN_STOCK','GRN','XYZ912144589','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3538,'XYZ-1767592442868-CC056AD5',5,NULL,'IN_STOCK','GRN','XYZ754140209','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3539,'XYZ-1767592442890-8C2B6F0C',5,NULL,'IN_STOCK','GRN','XYZ947158438','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3540,'XYZ-1767592442911-493CA596',5,NULL,'IN_STOCK','GRN','XYZ737258501','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3541,'XYZ-1767592442934-367A7EAD',5,NULL,'IN_STOCK','GRN','XYZ837024402','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3542,'XYZ-1767592442960-5D5866C2',5,NULL,'IN_STOCK','GRN','XYZ874356831','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3543,'XYZ-1767592442983-B3CAC84C',5,NULL,'IN_STOCK','GRN','XYZ105980285','2026-01-05 05:54:02','2026-01-05 05:54:02'),(3544,'XYZ-1767592443004-EE1EE43B',5,NULL,'IN_STOCK','GRN','XYZ018902748','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3545,'XYZ-1767592443026-CA014DA4',5,NULL,'IN_STOCK','GRN','XYZ152700093','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3546,'XYZ-1767592443049-9692BAC5',5,NULL,'IN_STOCK','GRN','XYZ836704726','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3547,'XYZ-1767592443073-02300D54',5,NULL,'IN_STOCK','GRN','XYZ361968836','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3548,'XYZ-1767592443095-8DAA13B3',5,NULL,'IN_STOCK','GRN','XYZ148115239','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3549,'XYZ-1767592443114-6434BC1E',5,NULL,'IN_STOCK','GRN','XYZ943318430','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3550,'XYZ-1767592443138-4486423A',5,NULL,'IN_STOCK','GRN','XYZ469826778','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3551,'XYZ-1767592443162-26E182DB',5,NULL,'IN_STOCK','GRN','XYZ839361116','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3552,'XYZ-1767592443188-E142E424',5,NULL,'IN_STOCK','GRN','XYZ576566843','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3553,'XYZ-1767592443211-D208D07A',5,NULL,'IN_STOCK','GRN','XYZ717748039','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3554,'XYZ-1767592443233-170ED049',5,NULL,'IN_STOCK','GRN','XYZ196864496','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3555,'XYZ-1767592443258-84ECA8AE',5,NULL,'IN_STOCK','GRN','XYZ382446633','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3556,'XYZ-1767592443282-9666EBD1',5,NULL,'IN_STOCK','GRN','XYZ930071084','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3557,'XYZ-1767592443305-944BBDE7',5,NULL,'IN_STOCK','GRN','XYZ874187745','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3558,'XYZ-1767592443327-31415C6E',5,NULL,'IN_STOCK','GRN','XYZ107989927','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3559,'XYZ-1767592443352-E3EC7C82',5,NULL,'IN_STOCK','GRN','XYZ955485009','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3560,'XYZ-1767592443372-906AA24C',5,NULL,'IN_STOCK','GRN','XYZ509466460','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3561,'XYZ-1767592443391-8B5C9032',5,NULL,'IN_STOCK','GRN','XYZ164241118','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3562,'XYZ-1767592443409-7361A969',5,NULL,'IN_STOCK','GRN','XYZ528562925','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3563,'XYZ-1767592443429-186595C4',5,NULL,'IN_STOCK','GRN','XYZ856941397','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3564,'XYZ-1767592443449-709FF1F6',5,NULL,'IN_STOCK','GRN','XYZ070100462','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3565,'XYZ-1767592443470-F2BE5DD3',5,NULL,'IN_STOCK','GRN','XYZ875261684','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3566,'XYZ-1767592443489-9E2CE7A4',5,NULL,'IN_STOCK','GRN','XYZ780291224','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3567,'XYZ-1767592443509-7D787352',5,NULL,'IN_STOCK','GRN','XYZ892653913','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3568,'XYZ-1767592443529-6B2EF313',5,NULL,'IN_STOCK','GRN','XYZ251434849','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3569,'XYZ-1767592443549-03485403',5,NULL,'IN_STOCK','GRN','XYZ395424813','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3570,'XYZ-1767592443569-52DC27BA',5,NULL,'IN_STOCK','GRN','XYZ940721134','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3571,'XYZ-1767592443590-E6F15C34',5,NULL,'IN_STOCK','GRN','XYZ047262740','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3572,'XYZ-1767592443610-5F62950B',5,NULL,'IN_STOCK','GRN','XYZ040487642','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3573,'XYZ-1767592443630-33214B77',5,NULL,'IN_STOCK','GRN','XYZ047859315','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3574,'XYZ-1767592443654-177D59D8',5,NULL,'IN_STOCK','GRN','XYZ724467247','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3575,'XYZ-1767592443677-1EB2B44E',5,NULL,'IN_STOCK','GRN','XYZ414494737','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3576,'XYZ-1767592443699-54D2818D',5,NULL,'IN_STOCK','GRN','XYZ262583442','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3577,'XYZ-1767592443720-9D0A7C5F',5,NULL,'IN_STOCK','GRN','XYZ043150202','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3578,'XYZ-1767592443743-F782B165',5,NULL,'IN_STOCK','GRN','XYZ288757205','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3579,'XYZ-1767592443769-E5DCA186',5,NULL,'IN_STOCK','GRN','XYZ074231185','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3580,'XYZ-1767592443796-0BBD9AF8',5,NULL,'IN_STOCK','GRN','XYZ887959685','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3581,'XYZ-1767592443822-23CA9D94',5,NULL,'IN_STOCK','GRN','XYZ651223819','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3582,'XYZ-1767592443849-A9340C98',5,NULL,'IN_STOCK','GRN','XYZ088028469','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3583,'XYZ-1767592443875-FC30E168',5,NULL,'IN_STOCK','GRN','XYZ499132968','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3584,'XYZ-1767592443899-A4231395',5,NULL,'IN_STOCK','GRN','XYZ362164522','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3585,'XYZ-1767592443927-6C079D19',5,NULL,'IN_STOCK','GRN','XYZ254288123','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3586,'XYZ-1767592443951-65785F97',5,NULL,'IN_STOCK','GRN','XYZ931469554','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3587,'XYZ-1767592443974-F2C7D5D9',5,NULL,'IN_STOCK','GRN','XYZ159253183','2026-01-05 05:54:03','2026-01-05 05:54:03'),(3588,'XYZ-1767592444000-2065310F',5,NULL,'IN_STOCK','GRN','XYZ254247132','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3589,'XYZ-1767592444025-1BE3A828',5,NULL,'IN_STOCK','GRN','XYZ810594755','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3590,'XYZ-1767592444049-0288CD10',5,NULL,'IN_STOCK','GRN','XYZ960256872','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3591,'XYZ-1767592444073-0BE23528',5,NULL,'IN_STOCK','GRN','XYZ939912532','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3592,'XYZ-1767592444096-5679BE23',5,NULL,'IN_STOCK','GRN','XYZ041058905','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3593,'XYZ-1767592444120-62EC2940',5,NULL,'IN_STOCK','GRN','XYZ412153312','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3594,'XYZ-1767592444143-793A5D3A',5,NULL,'IN_STOCK','GRN','XYZ359261062','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3595,'XYZ-1767592444166-DAF65D3F',5,NULL,'IN_STOCK','GRN','XYZ577875212','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3596,'XYZ-1767592444191-EE9E7C0D',5,NULL,'IN_STOCK','GRN','XYZ080408198','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3597,'XYZ-1767592444216-C9B79933',5,NULL,'IN_STOCK','GRN','XYZ710817002','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3598,'XYZ-1767592444241-953B5B9D',5,NULL,'IN_STOCK','GRN','XYZ579941535','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3599,'XYZ-1767592444266-D41BF997',5,NULL,'IN_STOCK','GRN','XYZ130037427','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3600,'XYZ-1767592444292-E1E4878C',5,NULL,'IN_STOCK','GRN','XYZ632134573','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3601,'XYZ-1767592444317-4F65DA8D',5,NULL,'IN_STOCK','GRN','XYZ619335383','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3602,'XYZ-1767592444344-8F8E64DF',5,NULL,'IN_STOCK','GRN','XYZ178560146','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3603,'XYZ-1767592444371-8838BCBB',5,NULL,'IN_STOCK','GRN','XYZ971957003','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3604,'XYZ-1767592444398-ECD2DFBF',5,NULL,'IN_STOCK','GRN','XYZ653391533','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3605,'XYZ-1767592444424-418B7091',5,NULL,'IN_STOCK','GRN','XYZ143058953','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3606,'XYZ-1767592444445-2ED6F63E',5,NULL,'IN_STOCK','GRN','XYZ317901471','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3607,'XYZ-1767592444464-24F99159',5,NULL,'IN_STOCK','GRN','XYZ915117934','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3608,'XYZ-1767592444484-D9CE63AF',5,NULL,'IN_STOCK','GRN','XYZ629697334','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3609,'XYZ-1767592444507-DD1731E5',5,NULL,'IN_STOCK','GRN','XYZ293864607','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3610,'XYZ-1767592444531-29EEB6E6',5,NULL,'IN_STOCK','GRN','XYZ542453214','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3611,'XYZ-1767592444557-3324F809',5,NULL,'IN_STOCK','GRN','XYZ152274120','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3612,'XYZ-1767592444586-DC499755',5,NULL,'IN_STOCK','GRN','XYZ319744466','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3613,'XYZ-1767592444613-7F839159',5,NULL,'IN_STOCK','GRN','XYZ280054115','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3614,'XYZ-1767592444639-9B742998',5,NULL,'IN_STOCK','GRN','XYZ000603567','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3615,'XYZ-1767592444665-E4D43A2F',5,NULL,'IN_STOCK','GRN','XYZ070149223','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3616,'XYZ-1767592444691-4AD3595C',5,NULL,'IN_STOCK','GRN','XYZ599355284','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3617,'XYZ-1767592444719-62D299F6',5,NULL,'IN_STOCK','GRN','XYZ000482384','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3618,'XYZ-1767592444745-4A83AA0F',5,NULL,'IN_STOCK','GRN','XYZ812096278','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3619,'XYZ-1767592444771-341C1C2F',5,NULL,'IN_STOCK','GRN','XYZ410863119','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3620,'XYZ-1767592444795-B30618A8',5,NULL,'IN_STOCK','GRN','XYZ660835631','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3621,'XYZ-1767592444823-59CD3E0F',5,NULL,'IN_STOCK','GRN','XYZ923718711','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3622,'XYZ-1767592444851-E097385E',5,NULL,'IN_STOCK','GRN','XYZ472247271','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3623,'XYZ-1767592444877-27B10A58',5,NULL,'IN_STOCK','GRN','XYZ139891948','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3624,'XYZ-1767592444904-C202E16F',5,NULL,'IN_STOCK','GRN','XYZ600111813','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3625,'XYZ-1767592444928-03220C64',5,NULL,'IN_STOCK','GRN','XYZ843886898','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3626,'XYZ-1767592444953-5D92D5F7',5,NULL,'IN_STOCK','GRN','XYZ490336923','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3627,'XYZ-1767592444979-B3FACC68',5,NULL,'IN_STOCK','GRN','XYZ991164010','2026-01-05 05:54:04','2026-01-05 05:54:04'),(3628,'XYZ-1767592445003-06ABE291',5,NULL,'IN_STOCK','GRN','XYZ945911460','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3629,'XYZ-1767592445027-BB61E527',5,NULL,'IN_STOCK','GRN','XYZ118396767','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3630,'XYZ-1767592445048-0679924A',5,NULL,'IN_STOCK','GRN','XYZ841115740','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3631,'XYZ-1767592445074-E8A7E8E0',5,NULL,'IN_STOCK','GRN','XYZ242056483','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3632,'XYZ-1767592445099-58E7DE6C',5,NULL,'IN_STOCK','GRN','XYZ531862662','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3633,'XYZ-1767592445123-13AFF7C1',5,NULL,'IN_STOCK','GRN','XYZ503560925','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3634,'XYZ-1767592445149-52222047',5,NULL,'IN_STOCK','GRN','XYZ632614214','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3635,'XYZ-1767592445176-8170EEBE',5,NULL,'IN_STOCK','GRN','XYZ295455863','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3636,'XYZ-1767592445202-C7933204',5,NULL,'IN_STOCK','GRN','XYZ516829899','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3637,'XYZ-1767592445229-739DEB58',5,NULL,'IN_STOCK','GRN','XYZ081803066','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3638,'XYZ-1767592445253-E8C1F2E0',5,NULL,'IN_STOCK','GRN','XYZ669368771','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3639,'XYZ-1767592445279-E055A7DC',5,NULL,'IN_STOCK','GRN','XYZ990317494','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3640,'XYZ-1767592445307-AF018458',5,NULL,'IN_STOCK','GRN','XYZ150860600','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3641,'XYZ-1767592445334-95D0CA93',5,NULL,'IN_STOCK','GRN','XYZ046787359','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3642,'XYZ-1767592445360-BF086B23',5,NULL,'IN_STOCK','GRN','XYZ440065904','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3643,'XYZ-1767592445389-E656253D',5,NULL,'IN_STOCK','GRN','XYZ787488663','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3644,'XYZ-1767592445412-9BC98BA2',5,NULL,'IN_STOCK','GRN','XYZ447675084','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3645,'XYZ-1767592445438-7C8D9124',5,NULL,'IN_STOCK','GRN','XYZ159643599','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3646,'XYZ-1767592445466-32F1FE89',5,NULL,'IN_STOCK','GRN','XYZ637264010','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3647,'XYZ-1767592445492-989B608D',5,NULL,'IN_STOCK','GRN','XYZ790889651','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3648,'XYZ-1767592445514-BC8A7625',5,NULL,'IN_STOCK','GRN','XYZ668811769','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3649,'XYZ-1767592445539-0DC7F331',5,NULL,'IN_STOCK','GRN','XYZ006768987','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3650,'XYZ-1767592445563-24CDF877',5,NULL,'IN_STOCK','GRN','XYZ574728396','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3651,'XYZ-1767592445587-F73571A1',5,NULL,'IN_STOCK','GRN','XYZ882069879','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3652,'XYZ-1767592445614-D4BBBF27',5,NULL,'IN_STOCK','GRN','XYZ155912438','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3653,'XYZ-1767592445641-61ACFACB',5,NULL,'IN_STOCK','GRN','XYZ529948384','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3654,'XYZ-1767592445669-37EC7E02',5,NULL,'IN_STOCK','GRN','XYZ881016761','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3655,'XYZ-1767592445695-50B8FDEF',5,NULL,'IN_STOCK','GRN','XYZ334803009','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3656,'XYZ-1767592445721-D1EFD8AC',5,NULL,'IN_STOCK','GRN','XYZ591862099','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3657,'XYZ-1767592445745-CABFC90F',5,NULL,'IN_STOCK','GRN','XYZ453171934','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3658,'XYZ-1767592445771-81476DE4',5,NULL,'IN_STOCK','GRN','XYZ452118106','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3659,'XYZ-1767592445794-D6B2DAF4',5,NULL,'IN_STOCK','GRN','XYZ932903636','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3660,'XYZ-1767592445822-86A33AD9',5,NULL,'IN_STOCK','GRN','XYZ816104805','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3661,'XYZ-1767592445847-D87F11A6',5,NULL,'IN_STOCK','GRN','XYZ907281617','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3662,'XYZ-1767592445871-CFCDAA87',5,NULL,'IN_STOCK','GRN','XYZ986699434','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3663,'XYZ-1767592445896-B31627E2',5,NULL,'IN_STOCK','GRN','XYZ200408953','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3664,'XYZ-1767592445922-C438741E',5,NULL,'IN_STOCK','GRN','XYZ112984923','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3665,'XYZ-1767592445948-73457A4B',5,NULL,'IN_STOCK','GRN','XYZ127843719','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3666,'XYZ-1767592445972-9E2B2635',5,NULL,'IN_STOCK','GRN','XYZ590986689','2026-01-05 05:54:05','2026-01-05 05:54:05'),(3667,'XYZ-1767592445998-73EECABB',5,NULL,'IN_STOCK','GRN','XYZ011594499','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3668,'XYZ-1767592446026-BB976624',5,NULL,'IN_STOCK','GRN','XYZ386718745','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3669,'XYZ-1767592446050-E2317915',5,NULL,'IN_STOCK','GRN','XYZ476673019','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3670,'XYZ-1767592446074-8DE785F5',5,NULL,'IN_STOCK','GRN','XYZ969835743','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3671,'XYZ-1767592446099-77244CDE',5,NULL,'IN_STOCK','GRN','XYZ542717341','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3672,'XYZ-1767592446125-2D6DCC56',5,NULL,'IN_STOCK','GRN','XYZ858123142','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3673,'XYZ-1767592446153-28E64B77',5,NULL,'IN_STOCK','GRN','XYZ981359680','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3674,'XYZ-1767592446177-CDB35E4A',5,NULL,'IN_STOCK','GRN','XYZ908645842','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3675,'XYZ-1767592446202-762CEC04',5,NULL,'IN_STOCK','GRN','XYZ636844598','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3676,'XYZ-1767592446225-D8521C13',5,NULL,'IN_STOCK','GRN','XYZ512745473','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3677,'XYZ-1767592446247-9E79031E',5,NULL,'IN_STOCK','GRN','XYZ089556957','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3678,'XYZ-1767592446270-D259CCA2',5,NULL,'IN_STOCK','GRN','XYZ505784521','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3679,'XYZ-1767592446296-1FCAAC1B',5,NULL,'IN_STOCK','GRN','XYZ985100915','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3680,'XYZ-1767592446323-20D8359F',5,NULL,'IN_STOCK','GRN','XYZ169468323','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3681,'XYZ-1767592446352-7523ADCC',5,NULL,'IN_STOCK','GRN','XYZ416618674','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3682,'XYZ-1767592446378-CC402449',5,NULL,'IN_STOCK','GRN','XYZ281750683','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3683,'XYZ-1767592446407-9F473585',5,NULL,'IN_STOCK','GRN','XYZ756192789','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3684,'XYZ-1767592446434-D4CE93B2',5,NULL,'IN_STOCK','GRN','XYZ054849091','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3685,'XYZ-1767592446460-6DDDDB7C',5,NULL,'IN_STOCK','GRN','XYZ452068178','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3686,'XYZ-1767592446487-B9CDF478',5,NULL,'IN_STOCK','GRN','XYZ685480215','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3687,'XYZ-1767592446510-E4F0B5A2',5,NULL,'IN_STOCK','GRN','XYZ933982992','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3688,'XYZ-1767592446535-BB1B8175',5,NULL,'IN_STOCK','GRN','XYZ429424545','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3689,'XYZ-1767592446561-C1A7B299',5,NULL,'IN_STOCK','GRN','XYZ320709206','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3690,'XYZ-1767592446586-4CF71CE5',5,NULL,'IN_STOCK','GRN','XYZ758684276','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3691,'XYZ-1767592446608-9391B606',5,NULL,'IN_STOCK','GRN','XYZ420563814','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3692,'XYZ-1767592446627-ACEBB992',5,NULL,'IN_STOCK','GRN','XYZ073636261','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3693,'XYZ-1767592446651-2E7EF4CF',5,NULL,'IN_STOCK','GRN','XYZ856292442','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3694,'XYZ-1767592446674-53B2C76C',5,NULL,'IN_STOCK','GRN','XYZ195575593','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3695,'XYZ-1767592446696-264B757C',5,NULL,'IN_STOCK','GRN','XYZ669405610','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3696,'XYZ-1767592446721-C033DA83',5,NULL,'IN_STOCK','GRN','XYZ838455714','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3697,'XYZ-1767592446746-BC45E96D',5,NULL,'IN_STOCK','GRN','XYZ098346876','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3698,'XYZ-1767592446770-5F85EFF0',5,NULL,'IN_STOCK','GRN','XYZ063319072','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3699,'XYZ-1767592446793-16DA4566',5,NULL,'IN_STOCK','GRN','XYZ877559651','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3700,'XYZ-1767592446814-7A5F0765',5,NULL,'IN_STOCK','GRN','XYZ637810626','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3701,'XYZ-1767592446837-557C3F5B',5,NULL,'IN_STOCK','GRN','XYZ209838564','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3702,'XYZ-1767592446908-DD6CA1BA',4,NULL,'IN_STOCK','GRN','XYZ081153930','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3703,'XYZ-1767592446931-831A2CAC',4,NULL,'IN_STOCK','GRN','XYZ055125854','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3704,'XYZ-1767592446951-F562E397',4,NULL,'IN_STOCK','GRN','XYZ721626476','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3705,'XYZ-1767592446975-CF2F6905',4,NULL,'IN_STOCK','GRN','XYZ048077551','2026-01-05 05:54:06','2026-01-05 05:54:06'),(3706,'XYZ-1767592446999-529E5E8D',4,NULL,'IN_STOCK','GRN','XYZ217380823','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3707,'XYZ-1767592447023-4580BBB7',4,NULL,'IN_STOCK','GRN','XYZ852142558','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3708,'XYZ-1767592447046-B48F8CEE',4,NULL,'IN_STOCK','GRN','XYZ244575241','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3709,'XYZ-1767592447068-DDE524EC',4,NULL,'IN_STOCK','GRN','XYZ295991383','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3710,'XYZ-1767592447092-3A7EB873',4,NULL,'IN_STOCK','GRN','XYZ743287300','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3711,'XYZ-1767592447117-E57B51A8',4,NULL,'IN_STOCK','GRN','XYZ556654748','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3712,'XYZ-1767592447141-DEC57A18',4,NULL,'IN_STOCK','GRN','XYZ073087946','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3713,'XYZ-1767592447164-7FF88F46',4,NULL,'IN_STOCK','GRN','XYZ787376443','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3714,'XYZ-1767592447189-11607A3E',4,NULL,'IN_STOCK','GRN','XYZ243300425','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3715,'XYZ-1767592447213-25D0D8A6',4,NULL,'IN_STOCK','GRN','XYZ353069863','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3716,'XYZ-1767592447238-39CF30A0',4,NULL,'IN_STOCK','GRN','XYZ317994261','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3717,'XYZ-1767592447263-B2785928',4,NULL,'IN_STOCK','GRN','XYZ959933280','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3718,'XYZ-1767592447291-03105C90',4,NULL,'IN_STOCK','GRN','XYZ374533531','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3719,'XYZ-1767592447313-016BEBD4',4,NULL,'IN_STOCK','GRN','XYZ215774847','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3720,'XYZ-1767592447338-A2CE9123',4,NULL,'IN_STOCK','GRN','XYZ603615277','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3721,'XYZ-1767592447360-FA6C9030',4,NULL,'IN_STOCK','GRN','XYZ777569105','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3722,'XYZ-1767592447385-C12E7854',4,NULL,'IN_STOCK','GRN','XYZ665104862','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3723,'XYZ-1767592447409-CC020B56',4,NULL,'IN_STOCK','GRN','XYZ513323537','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3724,'XYZ-1767592447433-98F32BDC',4,NULL,'IN_STOCK','GRN','XYZ253898669','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3725,'XYZ-1767592447458-3D315F79',4,NULL,'IN_STOCK','GRN','XYZ172995202','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3726,'XYZ-1767592447480-0FD8C64C',4,NULL,'IN_STOCK','GRN','XYZ488696464','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3727,'XYZ-1767592447502-02C81B98',4,NULL,'IN_STOCK','GRN','XYZ996235451','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3728,'XYZ-1767592447523-7BAEF8B6',4,NULL,'IN_STOCK','GRN','XYZ481286258','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3729,'XYZ-1767592447542-86537D00',4,NULL,'IN_STOCK','GRN','XYZ516532897','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3730,'XYZ-1767592447562-A9A44A18',4,NULL,'IN_STOCK','GRN','XYZ361126618','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3731,'XYZ-1767592447584-2DD00D14',4,NULL,'IN_STOCK','GRN','XYZ402620762','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3732,'XYZ-1767592447605-6D4D762F',4,NULL,'IN_STOCK','GRN','XYZ056758309','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3733,'XYZ-1767592447629-E83D784B',4,NULL,'IN_STOCK','GRN','XYZ400933988','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3734,'XYZ-1767592447652-89EC16C8',4,NULL,'IN_STOCK','GRN','XYZ290177122','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3735,'XYZ-1767592447674-8E58572F',4,NULL,'IN_STOCK','GRN','XYZ651020233','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3736,'XYZ-1767592447694-D70AC258',4,NULL,'IN_STOCK','GRN','XYZ928425074','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3737,'XYZ-1767592447714-3FBB80FD',4,NULL,'IN_STOCK','GRN','XYZ629766096','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3738,'XYZ-1767592447736-4295575C',4,NULL,'IN_STOCK','GRN','XYZ710042711','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3739,'XYZ-1767592447756-5009DB94',4,NULL,'IN_STOCK','GRN','XYZ664759009','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3740,'XYZ-1767592447777-BCC4704F',4,NULL,'IN_STOCK','GRN','XYZ474824714','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3741,'XYZ-1767592447797-76573152',4,NULL,'IN_STOCK','GRN','XYZ711460876','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3742,'XYZ-1767592447818-251743F1',4,NULL,'IN_STOCK','GRN','XYZ886458417','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3743,'XYZ-1767592447841-52FA02D2',4,NULL,'IN_STOCK','GRN','XYZ318548204','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3744,'XYZ-1767592447864-674FEBAA',4,NULL,'IN_STOCK','GRN','XYZ346386542','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3745,'XYZ-1767592447886-51BEA302',4,NULL,'IN_STOCK','GRN','XYZ149705193','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3746,'XYZ-1767592447911-8F491CB1',4,NULL,'IN_STOCK','GRN','XYZ206230555','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3747,'XYZ-1767592447933-CDD37C9A',4,NULL,'IN_STOCK','GRN','XYZ466019916','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3748,'XYZ-1767592447956-2A7E1558',4,NULL,'IN_STOCK','GRN','XYZ449769638','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3749,'XYZ-1767592447977-00295343',4,NULL,'IN_STOCK','GRN','XYZ902943240','2026-01-05 05:54:07','2026-01-05 05:54:07'),(3750,'XYZ-1767592447999-23709F5B',4,NULL,'IN_STOCK','GRN','XYZ399001830','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3751,'XYZ-1767592448024-42745031',4,NULL,'IN_STOCK','GRN','XYZ662176389','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3752,'XYZ-1767592448044-72C0AED2',4,NULL,'IN_STOCK','GRN','XYZ057061404','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3753,'XYZ-1767592448067-BC19A205',4,NULL,'IN_STOCK','GRN','XYZ759216117','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3754,'XYZ-1767592448088-55A7A929',4,NULL,'IN_STOCK','GRN','XYZ177906260','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3755,'XYZ-1767592448108-6B2E4045',4,NULL,'IN_STOCK','GRN','XYZ886143213','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3756,'XYZ-1767592448129-20E2D032',4,NULL,'IN_STOCK','GRN','XYZ434303120','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3757,'XYZ-1767592448151-656D4603',4,NULL,'IN_STOCK','GRN','XYZ108936498','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3758,'XYZ-1767592448172-A3B947DB',4,NULL,'IN_STOCK','GRN','XYZ104203156','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3759,'XYZ-1767592448191-1D8AE62E',4,NULL,'IN_STOCK','GRN','XYZ296608125','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3760,'XYZ-1767592448213-EBB9EAAC',4,NULL,'IN_STOCK','GRN','XYZ853226607','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3761,'XYZ-1767592448236-4995AE6D',4,NULL,'IN_STOCK','GRN','XYZ258195737','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3762,'XYZ-1767592448261-3A7C69B6',4,NULL,'IN_STOCK','GRN','XYZ906382136','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3763,'XYZ-1767592448281-E848F423',4,NULL,'IN_STOCK','GRN','XYZ927681360','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3764,'XYZ-1767592448303-04FE6F22',4,NULL,'IN_STOCK','GRN','XYZ715028249','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3765,'XYZ-1767592448325-BA8382C4',4,NULL,'IN_STOCK','GRN','XYZ113817009','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3766,'XYZ-1767592448350-419946B9',4,NULL,'IN_STOCK','GRN','XYZ706201090','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3767,'XYZ-1767592448374-726FCF8B',4,NULL,'IN_STOCK','GRN','XYZ134939139','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3768,'XYZ-1767592448395-4D1FD760',4,NULL,'IN_STOCK','GRN','XYZ899725846','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3769,'XYZ-1767592448419-47F5225A',4,NULL,'IN_STOCK','GRN','XYZ185250988','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3770,'XYZ-1767592448444-344097FA',4,NULL,'IN_STOCK','GRN','XYZ959705380','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3771,'XYZ-1767592448469-AA21A19C',4,NULL,'IN_STOCK','GRN','XYZ172359223','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3772,'XYZ-1767592448491-F4BFC17D',4,NULL,'IN_STOCK','GRN','XYZ361864867','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3773,'XYZ-1767592448515-DCDCD7F2',4,NULL,'IN_STOCK','GRN','XYZ508527272','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3774,'XYZ-1767592448536-EDC08008',4,NULL,'IN_STOCK','GRN','XYZ809512027','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3775,'XYZ-1767592448557-CDD5B5BD',4,NULL,'IN_STOCK','GRN','XYZ989311657','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3776,'XYZ-1767592448580-AC86113A',4,NULL,'IN_STOCK','GRN','XYZ842833745','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3777,'XYZ-1767592448602-9CE15587',4,NULL,'IN_STOCK','GRN','XYZ938544494','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3778,'XYZ-1767592448623-F09FD859',4,NULL,'IN_STOCK','GRN','XYZ033526204','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3779,'XYZ-1767592448646-83D584C2',4,NULL,'IN_STOCK','GRN','XYZ018707988','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3780,'XYZ-1767592448670-0CEE3001',4,NULL,'IN_STOCK','GRN','XYZ698129027','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3781,'XYZ-1767592448694-77F32AC4',4,NULL,'IN_STOCK','GRN','XYZ410746559','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3782,'XYZ-1767592448717-1AF32D85',4,NULL,'IN_STOCK','GRN','XYZ024232490','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3783,'XYZ-1767592448743-B1395501',4,NULL,'IN_STOCK','GRN','XYZ835571614','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3784,'XYZ-1767592448765-B2D63719',4,NULL,'IN_STOCK','GRN','XYZ596110975','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3785,'XYZ-1767592448784-D36219E4',4,NULL,'IN_STOCK','GRN','XYZ396848340','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3786,'XYZ-1767592448804-2EB85543',4,NULL,'IN_STOCK','GRN','XYZ213462805','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3787,'XYZ-1767592448824-7D017F0C',4,NULL,'IN_STOCK','GRN','XYZ737454764','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3788,'XYZ-1767592448842-76209D66',4,NULL,'IN_STOCK','GRN','XYZ383433926','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3789,'XYZ-1767592448859-35F74C3B',4,NULL,'IN_STOCK','GRN','XYZ596058043','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3790,'XYZ-1767592448876-BBECDDF8',4,NULL,'IN_STOCK','GRN','XYZ771800070','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3791,'XYZ-1767592448893-2F415541',4,NULL,'IN_STOCK','GRN','XYZ898024406','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3792,'XYZ-1767592448911-F1717FAF',4,NULL,'IN_STOCK','GRN','XYZ710297719','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3793,'XYZ-1767592448929-41A9ADBE',4,NULL,'IN_STOCK','GRN','XYZ058766762','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3794,'XYZ-1767592448953-F9ED5A27',4,NULL,'IN_STOCK','GRN','XYZ703253395','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3795,'XYZ-1767592448975-E4F60935',4,NULL,'IN_STOCK','GRN','XYZ221029819','2026-01-05 05:54:08','2026-01-05 05:54:08'),(3796,'XYZ-1767592448995-82F9C1F1',4,NULL,'IN_STOCK','GRN','XYZ197063773','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3797,'XYZ-1767592449023-B208AFF2',4,NULL,'IN_STOCK','GRN','XYZ461642800','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3798,'XYZ-1767592449046-F2649B2E',4,NULL,'IN_STOCK','GRN','XYZ034731185','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3799,'XYZ-1767592449069-9334E3BB',4,NULL,'IN_STOCK','GRN','XYZ142746728','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3800,'XYZ-1767592449093-0D765D9D',4,NULL,'IN_STOCK','GRN','XYZ787178981','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3801,'XYZ-1767592449117-E6EF4DF1',4,NULL,'IN_STOCK','GRN','XYZ597199018','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3802,'XYZ-1767592449139-AD5C6B3C',4,NULL,'IN_STOCK','GRN','XYZ835278453','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3803,'XYZ-1767592449161-8CACF6B9',4,NULL,'IN_STOCK','GRN','XYZ258319265','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3804,'XYZ-1767592449181-6F51448C',4,NULL,'IN_STOCK','GRN','XYZ861707484','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3805,'XYZ-1767592449200-BC4ABCA5',4,NULL,'IN_STOCK','GRN','XYZ354625674','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3806,'XYZ-1767592449220-2DA50721',4,NULL,'IN_STOCK','GRN','XYZ491577861','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3807,'XYZ-1767592449241-E35A6BD8',4,NULL,'IN_STOCK','GRN','XYZ659369297','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3808,'XYZ-1767592449261-2CE1109D',4,NULL,'IN_STOCK','GRN','XYZ637881453','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3809,'XYZ-1767592449280-728AF935',4,NULL,'IN_STOCK','GRN','XYZ499709064','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3810,'XYZ-1767592449305-F6317A10',4,NULL,'IN_STOCK','GRN','XYZ270156335','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3811,'XYZ-1767592449326-D86B2188',4,NULL,'IN_STOCK','GRN','XYZ783172720','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3812,'XYZ-1767592449347-1AFA6ACF',4,NULL,'IN_STOCK','GRN','XYZ290582868','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3813,'XYZ-1767592449368-F49DF64D',4,NULL,'IN_STOCK','GRN','XYZ663839122','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3814,'XYZ-1767592449390-C829FC1D',4,NULL,'IN_STOCK','GRN','XYZ102947709','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3815,'XYZ-1767592449414-5E75D2AB',4,NULL,'IN_STOCK','GRN','XYZ391028504','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3816,'XYZ-1767592449436-0B796AB2',4,NULL,'IN_STOCK','GRN','XYZ410032521','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3817,'XYZ-1767592449462-A6F8D3A4',4,NULL,'IN_STOCK','GRN','XYZ180431978','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3818,'XYZ-1767592449485-5F6A4C5D',4,NULL,'IN_STOCK','GRN','XYZ034769094','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3819,'XYZ-1767592449508-EEB490FB',4,NULL,'IN_STOCK','GRN','XYZ949469904','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3820,'XYZ-1767592449532-F0A51706',4,NULL,'IN_STOCK','GRN','XYZ068172206','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3821,'XYZ-1767592449556-B4A44B40',4,NULL,'IN_STOCK','GRN','XYZ019741404','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3822,'XYZ-1767592449580-ABF0C289',4,NULL,'IN_STOCK','GRN','XYZ249819537','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3823,'XYZ-1767592449606-40F90CEF',4,NULL,'IN_STOCK','GRN','XYZ659075328','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3824,'XYZ-1767592449628-3FE57E86',4,NULL,'IN_STOCK','GRN','XYZ279149152','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3825,'XYZ-1767592449651-E7842533',4,NULL,'IN_STOCK','GRN','XYZ319242208','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3826,'XYZ-1767592449673-062B35DA',4,NULL,'IN_STOCK','GRN','XYZ221315047','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3827,'XYZ-1767592449696-2D8A53B6',4,NULL,'IN_STOCK','GRN','XYZ246830980','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3828,'XYZ-1767592449722-3332EA53',4,NULL,'IN_STOCK','GRN','XYZ518885673','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3829,'XYZ-1767592449745-4CA06F4F',4,NULL,'IN_STOCK','GRN','XYZ182854245','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3830,'XYZ-1767592449768-065F3791',4,NULL,'IN_STOCK','GRN','XYZ341974018','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3831,'XYZ-1767592449791-DD1A459E',4,NULL,'IN_STOCK','GRN','XYZ894440128','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3832,'XYZ-1767592449812-D867E4F9',4,NULL,'IN_STOCK','GRN','XYZ586907046','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3833,'XYZ-1767592449836-7D31D1BB',4,NULL,'IN_STOCK','GRN','XYZ190932185','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3834,'XYZ-1767592449857-D7973F7D',4,NULL,'IN_STOCK','GRN','XYZ915677344','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3835,'XYZ-1767592449878-46D93D29',4,NULL,'IN_STOCK','GRN','XYZ512478631','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3836,'XYZ-1767592449898-16D6E3F5',4,NULL,'IN_STOCK','GRN','XYZ359031939','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3837,'XYZ-1767592449918-E7D172BF',4,NULL,'IN_STOCK','GRN','XYZ868530991','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3838,'XYZ-1767592449940-FE81C9ED',4,NULL,'IN_STOCK','GRN','XYZ835177101','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3839,'XYZ-1767592449964-861C746C',4,NULL,'IN_STOCK','GRN','XYZ222346925','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3840,'XYZ-1767592449987-61C62CA9',4,NULL,'IN_STOCK','GRN','XYZ714088363','2026-01-05 05:54:09','2026-01-05 05:54:09'),(3841,'XYZ-1767592450007-D9433E06',4,NULL,'IN_STOCK','GRN','XYZ709060100','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3842,'XYZ-1767592450028-0AC1CE1E',4,NULL,'IN_STOCK','GRN','XYZ423548273','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3843,'XYZ-1767592450048-A8F05B2E',4,NULL,'IN_STOCK','GRN','XYZ630489524','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3844,'XYZ-1767592450073-708EDE17',4,NULL,'IN_STOCK','GRN','XYZ445938437','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3845,'XYZ-1767592450097-0FF64324',4,NULL,'IN_STOCK','GRN','XYZ671146091','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3846,'XYZ-1767592450120-AF033394',4,NULL,'IN_STOCK','GRN','XYZ384065596','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3847,'XYZ-1767592450144-519B6CC2',4,NULL,'IN_STOCK','GRN','XYZ121308188','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3848,'XYZ-1767592450167-31692E9D',4,NULL,'IN_STOCK','GRN','XYZ513377308','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3849,'XYZ-1767592450191-A5C97D88',4,NULL,'IN_STOCK','GRN','XYZ023958516','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3850,'XYZ-1767592450214-39856EFA',4,NULL,'IN_STOCK','GRN','XYZ362095099','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3851,'XYZ-1767592450238-9DBCB164',4,NULL,'IN_STOCK','GRN','XYZ841678089','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3852,'XYZ-1767592450261-7BA39E30',4,NULL,'IN_STOCK','GRN','XYZ831073805','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3853,'XYZ-1767592450283-F4B78A9A',4,NULL,'IN_STOCK','GRN','XYZ146472948','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3854,'XYZ-1767592450303-A9B107CF',4,NULL,'IN_STOCK','GRN','XYZ731199180','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3855,'XYZ-1767592450323-5405FE41',4,NULL,'IN_STOCK','GRN','XYZ004124477','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3856,'XYZ-1767592450345-EB632607',4,NULL,'IN_STOCK','GRN','XYZ778475436','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3857,'XYZ-1767592450368-0A1142C3',4,NULL,'IN_STOCK','GRN','XYZ557004349','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3858,'XYZ-1767592450390-F28B999C',4,NULL,'IN_STOCK','GRN','XYZ633639087','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3859,'XYZ-1767592450413-0AC84E8E',4,NULL,'IN_STOCK','GRN','XYZ287431764','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3860,'XYZ-1767592450434-D8192FA8',4,NULL,'IN_STOCK','GRN','XYZ239430766','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3861,'XYZ-1767592450454-15547908',4,NULL,'IN_STOCK','GRN','XYZ484260804','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3862,'XYZ-1767592450475-C9E4901C',4,NULL,'IN_STOCK','GRN','XYZ856746627','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3863,'XYZ-1767592450495-E7B9CCC9',4,NULL,'IN_STOCK','GRN','XYZ275463807','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3864,'XYZ-1767592450516-4DBF8637',4,NULL,'IN_STOCK','GRN','XYZ192540010','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3865,'XYZ-1767592450538-97808A9F',4,NULL,'IN_STOCK','GRN','XYZ247264657','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3866,'XYZ-1767592450559-46842C45',4,NULL,'IN_STOCK','GRN','XYZ415827201','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3867,'XYZ-1767592450581-BFC833D2',4,NULL,'IN_STOCK','GRN','XYZ230604342','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3868,'XYZ-1767592450604-7A0FEDF6',4,NULL,'IN_STOCK','GRN','XYZ840150538','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3869,'XYZ-1767592450626-C4F39D00',4,NULL,'IN_STOCK','GRN','XYZ105141873','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3870,'XYZ-1767592450647-19630281',4,NULL,'IN_STOCK','GRN','XYZ212041018','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3871,'XYZ-1767592450668-63F556A5',4,NULL,'IN_STOCK','GRN','XYZ169440034','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3872,'XYZ-1767592450694-0F446950',4,NULL,'IN_STOCK','GRN','XYZ471792268','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3873,'XYZ-1767592450716-585467E7',4,NULL,'IN_STOCK','GRN','XYZ089635881','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3874,'XYZ-1767592450741-1F8C91A2',4,NULL,'IN_STOCK','GRN','XYZ080199894','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3875,'XYZ-1767592450764-CFA20D13',4,NULL,'IN_STOCK','GRN','XYZ114898457','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3876,'XYZ-1767592450787-5316FF69',4,NULL,'IN_STOCK','GRN','XYZ866681674','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3877,'XYZ-1767592450811-60EAEFC8',4,NULL,'IN_STOCK','GRN','XYZ501207143','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3878,'XYZ-1767592450836-6B006E2F',4,NULL,'IN_STOCK','GRN','XYZ186961823','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3879,'XYZ-1767592450858-CE29D4F2',4,NULL,'IN_STOCK','GRN','XYZ068809955','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3880,'XYZ-1767592450883-336FF04F',4,NULL,'IN_STOCK','GRN','XYZ402291935','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3881,'XYZ-1767592450906-DA873745',4,NULL,'IN_STOCK','GRN','XYZ047292886','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3882,'XYZ-1767592450929-85788ABF',4,NULL,'IN_STOCK','GRN','XYZ484650622','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3883,'XYZ-1767592450949-256014D5',4,NULL,'IN_STOCK','GRN','XYZ755125128','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3884,'XYZ-1767592450973-2489DAAE',4,NULL,'IN_STOCK','GRN','XYZ138676717','2026-01-05 05:54:10','2026-01-05 05:54:10'),(3885,'XYZ-1767592450995-ADD3115B',4,NULL,'IN_STOCK','GRN','XYZ785138269','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3886,'XYZ-1767592451018-CF6EBF2B',4,NULL,'IN_STOCK','GRN','XYZ921195507','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3887,'XYZ-1767592451038-BD9F46EB',4,NULL,'IN_STOCK','GRN','XYZ740146114','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3888,'XYZ-1767592451061-60D99165',4,NULL,'IN_STOCK','GRN','XYZ833102287','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3889,'XYZ-1767592451081-C7D750EC',4,NULL,'IN_STOCK','GRN','XYZ708117111','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3890,'XYZ-1767592451101-3F9451A8',4,NULL,'IN_STOCK','GRN','XYZ859369723','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3891,'XYZ-1767592451121-A167DE80',4,NULL,'IN_STOCK','GRN','XYZ101542528','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3892,'XYZ-1767592451141-8ADBD213',4,NULL,'IN_STOCK','GRN','XYZ135078534','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3893,'XYZ-1767592451164-F865E80B',4,NULL,'IN_STOCK','GRN','XYZ153280629','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3894,'XYZ-1767592451188-2AA75557',4,NULL,'IN_STOCK','GRN','XYZ599540545','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3895,'XYZ-1767592451209-2B44B85A',4,NULL,'IN_STOCK','GRN','XYZ729911329','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3896,'XYZ-1767592451231-B476C5F4',4,NULL,'IN_STOCK','GRN','XYZ033022662','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3897,'XYZ-1767592451255-30006F3B',4,NULL,'IN_STOCK','GRN','XYZ847699096','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3898,'XYZ-1767592451278-AB9A7DBF',4,NULL,'IN_STOCK','GRN','XYZ151804681','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3899,'XYZ-1767592451298-3C192BA3',4,NULL,'IN_STOCK','GRN','XYZ905175816','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3900,'XYZ-1767592451320-FD8D21B3',4,NULL,'IN_STOCK','GRN','XYZ835370431','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3901,'XYZ-1767592451343-8DE0EBC8',4,NULL,'IN_STOCK','GRN','XYZ727173749','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3902,'XYZ-1767592451366-F4349EA4',4,NULL,'IN_STOCK','GRN','XYZ575256942','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3903,'XYZ-1767592451391-1CB905D9',4,NULL,'IN_STOCK','GRN','XYZ383822476','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3904,'XYZ-1767592451415-C58775CD',4,NULL,'IN_STOCK','GRN','XYZ434081985','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3905,'XYZ-1767592451434-3BD5FD0A',4,NULL,'IN_STOCK','GRN','XYZ540392700','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3906,'XYZ-1767592451454-2ECB78E7',4,NULL,'IN_STOCK','GRN','XYZ622214493','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3907,'XYZ-1767592451478-E5B664D4',4,NULL,'IN_STOCK','GRN','XYZ899026507','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3908,'XYZ-1767592451502-4485BF02',4,NULL,'IN_STOCK','GRN','XYZ817226249','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3909,'XYZ-1767592451527-5529DF94',4,NULL,'IN_STOCK','GRN','XYZ224528080','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3910,'XYZ-1767592451553-B7417EE3',4,NULL,'IN_STOCK','GRN','XYZ779461882','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3911,'XYZ-1767592451579-568A11BD',4,NULL,'IN_STOCK','GRN','XYZ249400944','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3912,'XYZ-1767592451605-EC7CDF05',4,NULL,'IN_STOCK','GRN','XYZ375132750','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3913,'XYZ-1767592451630-26269DC4',4,NULL,'IN_STOCK','GRN','XYZ698417416','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3914,'XYZ-1767592451651-AF8C008F',4,NULL,'IN_STOCK','GRN','XYZ410268751','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3915,'XYZ-1767592451672-0754B139',4,NULL,'IN_STOCK','GRN','XYZ606614262','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3916,'XYZ-1767592451693-B921228A',4,NULL,'IN_STOCK','GRN','XYZ909603965','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3917,'XYZ-1767592451716-873679DF',4,NULL,'IN_STOCK','GRN','XYZ463022949','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3918,'XYZ-1767592451738-7A233073',4,NULL,'IN_STOCK','GRN','XYZ474701512','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3919,'XYZ-1767592451762-4F0162F5',4,NULL,'IN_STOCK','GRN','XYZ923917399','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3920,'XYZ-1767592451785-18BED54E',4,NULL,'IN_STOCK','GRN','XYZ199883913','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3921,'XYZ-1767592451807-CACEFCC9',4,NULL,'IN_STOCK','GRN','XYZ612687960','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3922,'XYZ-1767592451828-25F1D233',4,NULL,'IN_STOCK','GRN','XYZ551222579','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3923,'XYZ-1767592451850-02528C47',4,NULL,'IN_STOCK','GRN','XYZ134326362','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3924,'XYZ-1767592451873-7FD4A171',4,NULL,'IN_STOCK','GRN','XYZ804617927','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3925,'XYZ-1767592451898-3A30AC94',4,NULL,'IN_STOCK','GRN','XYZ063712716','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3926,'XYZ-1767592451922-BB14CE9E',4,NULL,'IN_STOCK','GRN','XYZ850593807','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3927,'XYZ-1767592451947-043D6FFD',4,NULL,'IN_STOCK','GRN','XYZ447073189','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3928,'XYZ-1767592451969-65953ADB',4,NULL,'IN_STOCK','GRN','XYZ273047081','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3929,'XYZ-1767592451991-B6C14D05',4,NULL,'IN_STOCK','GRN','XYZ553163615','2026-01-05 05:54:11','2026-01-05 05:54:11'),(3930,'XYZ-1767592452013-49211DF1',4,NULL,'IN_STOCK','GRN','XYZ923468487','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3931,'XYZ-1767592452037-509FFECA',4,NULL,'IN_STOCK','GRN','XYZ643329593','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3932,'XYZ-1767592452060-C57A51E9',4,NULL,'IN_STOCK','GRN','XYZ813574862','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3933,'XYZ-1767592452083-237BC423',4,NULL,'IN_STOCK','GRN','XYZ995258514','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3934,'XYZ-1767592452101-C5D04C78',4,NULL,'IN_STOCK','GRN','XYZ711309980','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3935,'XYZ-1767592452125-08090550',4,NULL,'IN_STOCK','GRN','XYZ154390386','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3936,'XYZ-1767592452149-1C8C1AEF',4,NULL,'IN_STOCK','GRN','XYZ303343637','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3937,'XYZ-1767592452173-ECD0206E',4,NULL,'IN_STOCK','GRN','XYZ242135923','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3938,'XYZ-1767592452194-A045481B',4,NULL,'IN_STOCK','GRN','XYZ561223983','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3939,'XYZ-1767592452216-84B57A27',4,NULL,'IN_STOCK','GRN','XYZ117858370','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3940,'XYZ-1767592452240-C5678AC6',4,NULL,'IN_STOCK','GRN','XYZ363323068','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3941,'XYZ-1767592452261-5F348D71',4,NULL,'IN_STOCK','GRN','XYZ024030598','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3942,'XYZ-1767592452285-B0FFF17A',4,NULL,'IN_STOCK','GRN','XYZ990289527','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3943,'XYZ-1767592452306-96A9FE28',4,NULL,'IN_STOCK','GRN','XYZ426527093','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3944,'XYZ-1767592452331-1F5A89C0',4,NULL,'IN_STOCK','GRN','XYZ626078390','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3945,'XYZ-1767592452356-02317031',4,NULL,'IN_STOCK','GRN','XYZ744099551','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3946,'XYZ-1767592452379-95FB66DE',4,NULL,'IN_STOCK','GRN','XYZ145924834','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3947,'XYZ-1767592452402-B3A18C4A',4,NULL,'IN_STOCK','GRN','XYZ441431273','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3948,'XYZ-1767592452426-6FFB5F0E',4,NULL,'IN_STOCK','GRN','XYZ351825720','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3949,'XYZ-1767592452451-D91D1350',4,NULL,'IN_STOCK','GRN','XYZ429052505','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3950,'XYZ-1767592452474-ABC8E707',4,NULL,'IN_STOCK','GRN','XYZ249258402','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3951,'XYZ-1767592452491-A4ADB8E3',4,NULL,'IN_STOCK','GRN','XYZ946547344','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3952,'XYZ-1767592452516-E8FB4261',4,NULL,'IN_STOCK','GRN','XYZ404674966','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3953,'XYZ-1767592452538-E47F006C',4,NULL,'IN_STOCK','GRN','XYZ662554292','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3954,'XYZ-1767592452562-72368C98',4,NULL,'IN_STOCK','GRN','XYZ970612432','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3955,'XYZ-1767592452585-58A39C47',4,NULL,'IN_STOCK','GRN','XYZ620307422','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3956,'XYZ-1767592452610-475012A2',4,NULL,'IN_STOCK','GRN','XYZ031392625','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3957,'XYZ-1767592452634-A57B1501',4,NULL,'IN_STOCK','GRN','XYZ951681899','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3958,'XYZ-1767592452658-80CDE5F8',4,NULL,'IN_STOCK','GRN','XYZ480026305','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3959,'XYZ-1767592452681-19B392B4',4,NULL,'IN_STOCK','GRN','XYZ838181778','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3960,'XYZ-1767592452704-D1A09319',4,NULL,'IN_STOCK','GRN','XYZ699985041','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3961,'XYZ-1767592452728-7A298158',4,NULL,'IN_STOCK','GRN','XYZ341529869','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3962,'XYZ-1767592452750-4D7ACF9B',4,NULL,'IN_STOCK','GRN','XYZ053152550','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3963,'XYZ-1767592452772-3D9B9F7D',4,NULL,'IN_STOCK','GRN','XYZ404661564','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3964,'XYZ-1767592452793-5CF6CC40',4,NULL,'IN_STOCK','GRN','XYZ044683740','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3965,'XYZ-1767592452813-29B2737D',4,NULL,'IN_STOCK','GRN','XYZ013797215','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3966,'XYZ-1767592452831-0680EF54',4,NULL,'IN_STOCK','GRN','XYZ474206619','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3967,'XYZ-1767592452851-9976A3D6',4,NULL,'IN_STOCK','GRN','XYZ604842767','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3968,'XYZ-1767592452873-9E0D7E5C',4,NULL,'IN_STOCK','GRN','XYZ581365521','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3969,'XYZ-1767592452895-BDE94516',4,NULL,'IN_STOCK','GRN','XYZ929531918','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3970,'XYZ-1767592452918-D1394CC2',4,NULL,'IN_STOCK','GRN','XYZ791051352','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3971,'XYZ-1767592452942-065C4BF7',4,NULL,'IN_STOCK','GRN','XYZ407216824','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3972,'XYZ-1767592452965-D0BCB4FE',4,NULL,'IN_STOCK','GRN','XYZ196238704','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3973,'XYZ-1767592452989-3BE3E0E3',4,NULL,'IN_STOCK','GRN','XYZ482322946','2026-01-05 05:54:12','2026-01-05 05:54:12'),(3974,'XYZ-1767592453013-A2790508',4,NULL,'IN_STOCK','GRN','XYZ627441157','2026-01-05 05:54:13','2026-01-05 05:54:13'),(3975,'XYZ-1767592453037-417057FA',4,NULL,'IN_STOCK','GRN','XYZ437813838','2026-01-05 05:54:13','2026-01-05 05:54:13'),(3976,'XYZ-1767592453059-3430C32C',4,NULL,'IN_STOCK','GRN','XYZ598683153','2026-01-05 05:54:13','2026-01-05 05:54:13'),(3977,'XYZ-1767592453081-FC737C77',4,NULL,'IN_STOCK','GRN','XYZ075387951','2026-01-05 05:54:13','2026-01-05 05:54:13'),(3978,'XYZ-1767592453107-FDBC30A3',4,NULL,'IN_STOCK','GRN','XYZ660383479','2026-01-05 05:54:13','2026-01-05 05:54:13'),(3979,'XYZ-1767592453130-02055B3E',4,NULL,'IN_STOCK','GRN','XYZ756352482','2026-01-05 05:54:13','2026-01-05 05:54:13'),(3980,'XYZ-1767592453149-1F17BBCF',4,NULL,'IN_STOCK','GRN','XYZ903892226','2026-01-05 05:54:13','2026-01-05 05:54:13'),(3981,'XYZ-1767592453167-9EE83A6F',4,NULL,'IN_STOCK','GRN','XYZ435920153','2026-01-05 05:54:13','2026-01-05 05:54:13'),(3982,'XYZ-1767592453190-8F1E948B',4,NULL,'IN_STOCK','GRN','XYZ923763798','2026-01-05 05:54:13','2026-01-05 05:54:13'),(3983,'XYZ-1767592453216-E4C5979C',4,NULL,'IN_STOCK','GRN','XYZ427428118','2026-01-05 05:54:13','2026-01-05 05:54:13'),(3984,'XYZ-1767592453240-3FD688C7',4,NULL,'IN_STOCK','GRN','XYZ082791611','2026-01-05 05:54:13','2026-01-05 05:54:13'),(3985,'XYZ-1767592453265-E4FBBCF4',4,NULL,'IN_STOCK','GRN','XYZ131368384','2026-01-05 05:54:13','2026-01-05 05:54:13'),(3986,'XYZ-1767592453289-5A7A6F3F',4,NULL,'IN_STOCK','GRN','XYZ707637847','2026-01-05 05:54:13','2026-01-05 05:54:13'),(3987,'XYZ-1767592453313-6314E65F',4,NULL,'IN_STOCK','GRN','XYZ836806566','2026-01-05 05:54:13','2026-01-05 05:54:13'),(3988,'XYZ-1767592453337-DB067684',4,NULL,'IN_STOCK','GRN','XYZ736940726','2026-01-05 05:54:13','2026-01-05 05:54:13'),(3989,'XYZ-1767592453361-E44212AA',4,NULL,'IN_STOCK','GRN','XYZ384501580','2026-01-05 05:54:13','2026-01-05 05:54:13'),(3990,'XYZ-1767592453387-03E348AE',4,NULL,'IN_STOCK','GRN','XYZ859949828','2026-01-05 05:54:13','2026-01-05 05:54:13'),(3991,'XYZ-1767592453411-9F53E796',4,NULL,'IN_STOCK','GRN','XYZ379424556','2026-01-05 05:54:13','2026-01-05 05:54:13'),(3992,'XYZ-1767592453431-91494E8A',4,NULL,'IN_STOCK','GRN','XYZ285557860','2026-01-05 05:54:13','2026-01-05 05:54:13'),(3993,'XYZ-1767592453448-D4016060',4,NULL,'IN_STOCK','GRN','XYZ048298614','2026-01-05 05:54:13','2026-01-05 05:54:13'),(3994,'XYZ-1767592453468-4274D81D',4,NULL,'IN_STOCK','GRN','XYZ385391015','2026-01-05 05:54:13','2026-01-05 05:54:13'),(3995,'XYZ-1767592453490-6FB00C4D',4,NULL,'IN_STOCK','GRN','XYZ096767242','2026-01-05 05:54:13','2026-01-05 05:54:13'),(3996,'XYZ-1767592453513-A1578075',4,NULL,'IN_STOCK','GRN','XYZ470326782','2026-01-05 05:54:13','2026-01-05 05:54:13'),(3997,'XYZ-1767592453535-9BC8336C',4,NULL,'IN_STOCK','GRN','XYZ735973937','2026-01-05 05:54:13','2026-01-05 05:54:13'),(3998,'XYZ-1767592453557-AD6DD51E',4,NULL,'IN_STOCK','GRN','XYZ489955511','2026-01-05 05:54:13','2026-01-05 05:54:13'),(3999,'XYZ-1767592453580-23E845A3',4,NULL,'IN_STOCK','GRN','XYZ318598099','2026-01-05 05:54:13','2026-01-05 05:54:13'),(4000,'XYZ-1767592453601-043AAEC4',4,NULL,'IN_STOCK','GRN','XYZ481712501','2026-01-05 05:54:13','2026-01-05 05:54:13'),(4001,'XYZ-1767592453629-566D08D4',5,NULL,'IN_STOCK','GRN','XYZ496948282','2026-01-05 05:54:13','2026-01-05 05:54:13'),(4002,'XYZ-1767592453658-A1FE1469',5,NULL,'IN_STOCK','GRN','XYZ544833249','2026-01-05 05:54:13','2026-01-05 05:54:13'),(4003,'XYZ-1767592453682-6E0EA3B1',5,NULL,'IN_STOCK','GRN','XYZ306070533','2026-01-05 05:54:13','2026-01-05 05:54:13'),(4004,'XYZ-1767592453706-ED90912F',5,NULL,'IN_STOCK','GRN','XYZ251034202','2026-01-05 05:54:13','2026-01-05 05:54:13'),(4005,'XYZ-1767592453727-F86B8EC8',5,NULL,'IN_STOCK','GRN','XYZ085180057','2026-01-05 05:54:13','2026-01-05 05:54:13'),(4006,'XYZ-1767592453747-D5C134D0',5,NULL,'IN_STOCK','GRN','XYZ916420787','2026-01-05 05:54:13','2026-01-05 05:54:13'),(4007,'XYZ-1767592453771-B0CF0E40',5,NULL,'IN_STOCK','GRN','XYZ502888381','2026-01-05 05:54:13','2026-01-05 05:54:13'),(4008,'XYZ-1767592453792-F686DB5B',5,NULL,'IN_STOCK','GRN','XYZ541502938','2026-01-05 05:54:13','2026-01-05 05:54:13'),(4009,'XYZ-1767592453814-BEE2E5CB',5,NULL,'IN_STOCK','GRN','XYZ940958497','2026-01-05 05:54:13','2026-01-05 05:54:13'),(4010,'XYZ-1767592453837-613FC46C',5,NULL,'IN_STOCK','GRN','XYZ084403447','2026-01-05 05:54:13','2026-01-05 05:54:13'),(4011,'XYZ-1767592453858-346EDB59',5,NULL,'IN_STOCK','GRN','XYZ213599065','2026-01-05 05:54:13','2026-01-05 05:54:13'),(4012,'XYZ-1767592453884-D92BE333',5,NULL,'IN_STOCK','GRN','XYZ537886698','2026-01-05 05:54:13','2026-01-05 05:54:13'),(4013,'XYZ-1767592453907-2E2EE412',5,NULL,'IN_STOCK','GRN','XYZ092754323','2026-01-05 05:54:13','2026-01-05 05:54:13'),(4014,'XYZ-1767592453928-E1A5F623',5,NULL,'IN_STOCK','GRN','XYZ775811236','2026-01-05 05:54:13','2026-01-05 05:54:13'),(4015,'XYZ-1767592453952-A6FD1E1D',5,NULL,'IN_STOCK','GRN','XYZ792515290','2026-01-05 05:54:13','2026-01-05 05:54:13'),(4016,'XYZ-1767592453976-6CA16AB7',5,NULL,'IN_STOCK','GRN','XYZ705366816','2026-01-05 05:54:13','2026-01-05 05:54:13'),(4017,'XYZ-1767592453997-7F29DACD',5,NULL,'IN_STOCK','GRN','XYZ751105277','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4018,'XYZ-1767592454019-CA5D9C25',5,NULL,'IN_STOCK','GRN','XYZ863508303','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4019,'XYZ-1767592454041-2339F37A',5,NULL,'IN_STOCK','GRN','XYZ221776860','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4020,'XYZ-1767592454063-BBC9BA42',5,NULL,'IN_STOCK','GRN','XYZ367294041','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4021,'XYZ-1767592454087-C292E782',5,NULL,'IN_STOCK','GRN','XYZ641223163','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4022,'XYZ-1767592454111-CF06320C',5,NULL,'IN_STOCK','GRN','XYZ946314934','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4023,'XYZ-1767592454135-9BF196DF',5,NULL,'IN_STOCK','GRN','XYZ412827998','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4024,'XYZ-1767592454160-285B5624',5,NULL,'IN_STOCK','GRN','XYZ044240065','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4025,'XYZ-1767592454182-16721E32',5,NULL,'IN_STOCK','GRN','XYZ010843202','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4026,'XYZ-1767592454206-6B743412',5,NULL,'IN_STOCK','GRN','XYZ233627461','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4027,'XYZ-1767592454231-6BC32B08',5,NULL,'IN_STOCK','GRN','XYZ002060201','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4028,'XYZ-1767592454253-98259B5C',5,NULL,'IN_STOCK','GRN','XYZ360032725','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4029,'XYZ-1767592454276-06D476AB',5,NULL,'IN_STOCK','GRN','XYZ528395278','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4030,'XYZ-1767592454301-A505003A',5,NULL,'IN_STOCK','GRN','XYZ802804957','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4031,'XYZ-1767592454325-13EE35E3',5,NULL,'IN_STOCK','GRN','XYZ758894745','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4032,'XYZ-1767592454351-1908C582',5,NULL,'IN_STOCK','GRN','XYZ534455481','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4033,'XYZ-1767592454374-BC16556A',5,NULL,'IN_STOCK','GRN','XYZ198549088','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4034,'XYZ-1767592454397-75397E04',5,NULL,'IN_STOCK','GRN','XYZ095301822','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4035,'XYZ-1767592454418-D33712DD',5,NULL,'IN_STOCK','GRN','XYZ136498455','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4036,'XYZ-1767592454440-8E87352C',5,NULL,'IN_STOCK','GRN','XYZ295120411','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4037,'XYZ-1767592454462-AEFF50B9',5,NULL,'IN_STOCK','GRN','XYZ685493919','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4038,'XYZ-1767592454486-B17E2C33',5,NULL,'IN_STOCK','GRN','XYZ199225764','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4039,'XYZ-1767592454510-A695C293',5,NULL,'IN_STOCK','GRN','XYZ257531507','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4040,'XYZ-1767592454535-B90A3032',5,NULL,'IN_STOCK','GRN','XYZ277108931','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4041,'XYZ-1767592454560-39717BCC',5,NULL,'IN_STOCK','GRN','XYZ233106999','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4042,'XYZ-1767592454584-4088EE60',5,NULL,'IN_STOCK','GRN','XYZ904588533','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4043,'XYZ-1767592454605-38646F32',5,NULL,'IN_STOCK','GRN','XYZ221841441','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4044,'XYZ-1767592454630-33AE9DB9',5,NULL,'IN_STOCK','GRN','XYZ661884005','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4045,'XYZ-1767592454648-CB90702E',5,NULL,'IN_STOCK','GRN','XYZ112699812','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4046,'XYZ-1767592454668-8034A795',5,NULL,'IN_STOCK','GRN','XYZ467848749','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4047,'XYZ-1767592454691-3FFD4F43',5,NULL,'IN_STOCK','GRN','XYZ559826241','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4048,'XYZ-1767592454712-A7909E9C',5,NULL,'IN_STOCK','GRN','XYZ604608544','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4049,'XYZ-1767592454729-C6D3B5C9',5,NULL,'IN_STOCK','GRN','XYZ584162587','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4050,'XYZ-1767592454748-0F4761A0',5,NULL,'IN_STOCK','GRN','XYZ499712400','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4051,'XYZ-1767592454769-1945EA0E',5,NULL,'IN_STOCK','GRN','XYZ433408679','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4052,'XYZ-1767592454792-69B24848',5,NULL,'IN_STOCK','GRN','XYZ046723855','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4053,'XYZ-1767592454810-DA09AFAE',5,NULL,'IN_STOCK','GRN','XYZ585202329','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4054,'XYZ-1767592454832-1203200F',5,NULL,'IN_STOCK','GRN','XYZ759579343','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4055,'XYZ-1767592454851-413513FF',5,NULL,'IN_STOCK','GRN','XYZ326123001','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4056,'XYZ-1767592454872-D6CF61C3',5,NULL,'IN_STOCK','GRN','XYZ471613873','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4057,'XYZ-1767592454892-356678FC',5,NULL,'IN_STOCK','GRN','XYZ552609878','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4058,'XYZ-1767592454911-51A53ABB',5,NULL,'IN_STOCK','GRN','XYZ545763909','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4059,'XYZ-1767592454930-463A5A0B',5,NULL,'IN_STOCK','GRN','XYZ088473208','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4060,'XYZ-1767592454949-43C1A782',5,NULL,'IN_STOCK','GRN','XYZ293356399','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4061,'XYZ-1767592454967-69D3E244',5,NULL,'IN_STOCK','GRN','XYZ147913392','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4062,'XYZ-1767592454986-20166FA5',5,NULL,'IN_STOCK','GRN','XYZ778143365','2026-01-05 05:54:14','2026-01-05 05:54:14'),(4063,'XYZ-1767592455005-6E8B84A0',5,NULL,'IN_STOCK','GRN','XYZ282662709','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4064,'XYZ-1767592455026-B5AE3D7C',5,NULL,'IN_STOCK','GRN','XYZ473624940','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4065,'XYZ-1767592455048-34B174BB',5,NULL,'IN_STOCK','GRN','XYZ707652511','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4066,'XYZ-1767592455066-1A69769F',5,NULL,'IN_STOCK','GRN','XYZ125988235','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4067,'XYZ-1767592455086-C249AF74',5,NULL,'IN_STOCK','GRN','XYZ103089637','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4068,'XYZ-1767592455105-8E2502A2',5,NULL,'IN_STOCK','GRN','XYZ999004336','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4069,'XYZ-1767592455126-C050D6B0',5,NULL,'IN_STOCK','GRN','XYZ370857325','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4070,'XYZ-1767592455150-AFC2FDB2',5,NULL,'IN_STOCK','GRN','XYZ601432826','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4071,'XYZ-1767592455170-E9433794',5,NULL,'IN_STOCK','GRN','XYZ291745013','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4072,'XYZ-1767592455192-6F7773E4',5,NULL,'IN_STOCK','GRN','XYZ223921407','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4073,'XYZ-1767592455217-5A4D682F',5,NULL,'IN_STOCK','GRN','XYZ867998919','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4074,'XYZ-1767592455241-B46548FB',5,NULL,'IN_STOCK','GRN','XYZ496363472','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4075,'XYZ-1767592455262-2E169BA5',5,NULL,'IN_STOCK','GRN','XYZ956351677','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4076,'XYZ-1767592455282-E8097A90',5,NULL,'IN_STOCK','GRN','XYZ089124514','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4077,'XYZ-1767592455305-8CBB737A',5,NULL,'IN_STOCK','GRN','XYZ316642844','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4078,'XYZ-1767592455324-B0FD5ED5',5,NULL,'IN_STOCK','GRN','XYZ239101347','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4079,'XYZ-1767592455344-CF7DD1B7',5,NULL,'IN_STOCK','GRN','XYZ140526093','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4080,'XYZ-1767592455363-BB01AEFA',5,NULL,'IN_STOCK','GRN','XYZ397141037','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4081,'XYZ-1767592455382-01BE842A',5,NULL,'IN_STOCK','GRN','XYZ239141998','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4082,'XYZ-1767592455401-D46808CD',5,NULL,'IN_STOCK','GRN','XYZ015909834','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4083,'XYZ-1767592455420-B6C641F9',5,NULL,'IN_STOCK','GRN','XYZ128850710','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4084,'XYZ-1767592455439-357BE9B1',5,NULL,'IN_STOCK','GRN','XYZ166522390','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4085,'XYZ-1767592455458-2D97719A',5,NULL,'IN_STOCK','GRN','XYZ543355644','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4086,'XYZ-1767592455478-C3A2D35E',5,NULL,'IN_STOCK','GRN','XYZ533062477','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4087,'XYZ-1767592455498-AD07AE4F',5,NULL,'IN_STOCK','GRN','XYZ630485252','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4088,'XYZ-1767592455518-67BD24B1',5,NULL,'IN_STOCK','GRN','XYZ749347280','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4089,'XYZ-1767592455540-162007D8',5,NULL,'IN_STOCK','GRN','XYZ404378589','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4090,'XYZ-1767592455563-0A662C5A',5,NULL,'IN_STOCK','GRN','XYZ982747452','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4091,'XYZ-1767592455587-FA6FFBF0',5,NULL,'IN_STOCK','GRN','XYZ999000953','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4092,'XYZ-1767592455610-983F282E',5,NULL,'IN_STOCK','GRN','XYZ570132563','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4093,'XYZ-1767592455630-49D1A646',5,NULL,'IN_STOCK','GRN','XYZ074979482','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4094,'XYZ-1767592455652-F90D0DC6',5,NULL,'IN_STOCK','GRN','XYZ342449287','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4095,'XYZ-1767592455675-8A9433C9',5,NULL,'IN_STOCK','GRN','XYZ330086834','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4096,'XYZ-1767592455696-A7BF168E',5,NULL,'IN_STOCK','GRN','XYZ385719702','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4097,'XYZ-1767592455719-E30C052B',5,NULL,'IN_STOCK','GRN','XYZ805944081','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4098,'XYZ-1767592455743-7442916A',5,NULL,'IN_STOCK','GRN','XYZ132921047','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4099,'XYZ-1767592455767-098F7A4B',5,NULL,'IN_STOCK','GRN','XYZ528005650','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4100,'XYZ-1767592455787-AEF420BE',5,NULL,'IN_STOCK','GRN','XYZ694993624','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4101,'XYZ-1767592455812-27E3C13E',5,NULL,'IN_STOCK','GRN','XYZ549183455','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4102,'XYZ-1767592455837-174835D2',5,NULL,'IN_STOCK','GRN','XYZ528091994','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4103,'XYZ-1767592455861-D51DB4DD',5,NULL,'IN_STOCK','GRN','XYZ028704887','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4104,'XYZ-1767592455881-5218B7F1',5,NULL,'IN_STOCK','GRN','XYZ827853718','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4105,'XYZ-1767592455903-BB4663E6',5,NULL,'IN_STOCK','GRN','XYZ043356045','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4106,'XYZ-1767592455927-CC12E7CC',5,NULL,'IN_STOCK','GRN','XYZ104400844','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4107,'XYZ-1767592455948-3BB2CF06',5,NULL,'IN_STOCK','GRN','XYZ006086357','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4108,'XYZ-1767592455973-487B9B7E',5,NULL,'IN_STOCK','GRN','XYZ782837012','2026-01-05 05:54:15','2026-01-05 05:54:15'),(4109,'XYZ-1767592455997-F26BBD16',5,NULL,'IN_STOCK','GRN','XYZ177374946','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4110,'XYZ-1767592456021-D20D07DC',5,NULL,'IN_STOCK','GRN','XYZ622569021','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4111,'XYZ-1767592456044-72F66415',5,NULL,'IN_STOCK','GRN','XYZ835343170','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4112,'XYZ-1767592456066-6BFB8CF5',5,NULL,'IN_STOCK','GRN','XYZ400868343','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4113,'XYZ-1767592456089-8B2B97FB',5,NULL,'IN_STOCK','GRN','XYZ445937173','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4114,'XYZ-1767592456107-7FB77C76',5,NULL,'IN_STOCK','GRN','XYZ149252319','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4115,'XYZ-1767592456132-B8E5DFBB',5,NULL,'IN_STOCK','GRN','XYZ508011917','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4116,'XYZ-1767592456152-980F8722',5,NULL,'IN_STOCK','GRN','XYZ378696771','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4117,'XYZ-1767592456174-75A5AF9E',5,NULL,'IN_STOCK','GRN','XYZ635561972','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4118,'XYZ-1767592456199-CE6BCC8F',5,NULL,'IN_STOCK','GRN','XYZ253775061','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4119,'XYZ-1767592456221-B05F3B94',5,NULL,'IN_STOCK','GRN','XYZ132148833','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4120,'XYZ-1767592456243-38528FD7',5,NULL,'IN_STOCK','GRN','XYZ080342586','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4121,'XYZ-1767592456267-195BCA3E',5,NULL,'IN_STOCK','GRN','XYZ058257249','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4122,'XYZ-1767592456288-42B24570',5,NULL,'IN_STOCK','GRN','XYZ189659257','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4123,'XYZ-1767592456308-53912AB2',5,NULL,'IN_STOCK','GRN','XYZ143643153','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4124,'XYZ-1767592456331-525C8A70',5,NULL,'IN_STOCK','GRN','XYZ161741523','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4125,'XYZ-1767592456355-F943E0D9',5,NULL,'IN_STOCK','GRN','XYZ021369222','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4126,'XYZ-1767592456376-EAEF25A3',5,NULL,'IN_STOCK','GRN','XYZ657797517','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4127,'XYZ-1767592456398-410EEFE2',5,NULL,'IN_STOCK','GRN','XYZ534236687','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4128,'XYZ-1767592456423-3D8347AC',5,NULL,'IN_STOCK','GRN','XYZ451559343','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4129,'XYZ-1767592456447-7FC33DAA',5,NULL,'IN_STOCK','GRN','XYZ628410858','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4130,'XYZ-1767592456469-901E5408',5,NULL,'IN_STOCK','GRN','XYZ916936662','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4131,'XYZ-1767592456490-C1F3F503',5,NULL,'IN_STOCK','GRN','XYZ620353559','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4132,'XYZ-1767592456509-8EA49838',5,NULL,'IN_STOCK','GRN','XYZ099598935','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4133,'XYZ-1767592456526-AAAD8EBF',5,NULL,'IN_STOCK','GRN','XYZ771872074','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4134,'XYZ-1767592456544-8EDBB8C6',5,NULL,'IN_STOCK','GRN','XYZ256377293','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4135,'XYZ-1767592456564-713DD2F4',5,NULL,'IN_STOCK','GRN','XYZ570700178','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4136,'XYZ-1767592456587-5C46C367',5,NULL,'IN_STOCK','GRN','XYZ735060863','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4137,'XYZ-1767592456610-1B8BC8A8',5,NULL,'IN_STOCK','GRN','XYZ888718820','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4138,'XYZ-1767592456631-0000F39C',5,NULL,'IN_STOCK','GRN','XYZ427819871','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4139,'XYZ-1767592456652-24149F2B',5,NULL,'IN_STOCK','GRN','XYZ958046851','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4140,'XYZ-1767592456674-03658DB0',5,NULL,'IN_STOCK','GRN','XYZ980265543','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4141,'XYZ-1767592456698-5952E95E',5,NULL,'IN_STOCK','GRN','XYZ549487175','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4142,'XYZ-1767592456721-871F3107',5,NULL,'IN_STOCK','GRN','XYZ849083981','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4143,'XYZ-1767592456740-538910E2',5,NULL,'IN_STOCK','GRN','XYZ062114638','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4144,'XYZ-1767592456760-7F1E10CA',5,NULL,'IN_STOCK','GRN','XYZ191146838','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4145,'XYZ-1767592456779-31868DBB',5,NULL,'IN_STOCK','GRN','XYZ018012193','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4146,'XYZ-1767592456794-A1139765',5,NULL,'IN_STOCK','GRN','XYZ315401958','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4147,'XYZ-1767592456812-E9C76A4E',5,NULL,'IN_STOCK','GRN','XYZ465668217','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4148,'XYZ-1767592456831-28F064BE',5,NULL,'IN_STOCK','GRN','XYZ124769594','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4149,'XYZ-1767592456849-D8FAACE4',5,NULL,'IN_STOCK','GRN','XYZ509426107','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4150,'XYZ-1767592456867-CF181CA2',5,NULL,'IN_STOCK','GRN','XYZ636833458','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4151,'XYZ-1767592456886-598C088F',5,NULL,'IN_STOCK','GRN','XYZ321752601','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4152,'XYZ-1767592456906-19B94384',5,NULL,'IN_STOCK','GRN','XYZ986583716','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4153,'XYZ-1767592456931-36CFA287',5,NULL,'IN_STOCK','GRN','XYZ237187453','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4154,'XYZ-1767592456953-93D738B9',5,NULL,'IN_STOCK','GRN','XYZ600460571','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4155,'XYZ-1767592456974-2B7F6F34',5,NULL,'IN_STOCK','GRN','XYZ958261527','2026-01-05 05:54:16','2026-01-05 05:54:16'),(4156,'XYZ-1767592456998-075B2AD9',5,NULL,'IN_STOCK','GRN','XYZ905705397','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4157,'XYZ-1767592457021-63925E6F',5,NULL,'IN_STOCK','GRN','XYZ750635602','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4158,'XYZ-1767592457043-272FB1BD',5,NULL,'IN_STOCK','GRN','XYZ795646777','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4159,'XYZ-1767592457064-93B6B45E',5,NULL,'IN_STOCK','GRN','XYZ711815564','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4160,'XYZ-1767592457085-40A6150E',5,NULL,'IN_STOCK','GRN','XYZ407970796','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4161,'XYZ-1767592457110-89994867',5,NULL,'IN_STOCK','GRN','XYZ003555043','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4162,'XYZ-1767592457135-B5B2E698',5,NULL,'IN_STOCK','GRN','XYZ714657529','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4163,'XYZ-1767592457161-46C9369B',5,NULL,'IN_STOCK','GRN','XYZ454094023','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4164,'XYZ-1767592457185-704F3323',5,NULL,'IN_STOCK','GRN','XYZ414327819','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4165,'XYZ-1767592457208-15E758A9',5,NULL,'IN_STOCK','GRN','XYZ613259614','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4166,'XYZ-1767592457232-7B551E65',5,NULL,'IN_STOCK','GRN','XYZ872607131','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4167,'XYZ-1767592457257-6D3434DF',5,NULL,'IN_STOCK','GRN','XYZ757122934','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4168,'XYZ-1767592457282-A7EDFD9F',5,NULL,'IN_STOCK','GRN','XYZ435887270','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4169,'XYZ-1767592457307-7A7858A7',5,NULL,'IN_STOCK','GRN','XYZ496362545','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4170,'XYZ-1767592457332-E8BCE402',5,NULL,'IN_STOCK','GRN','XYZ051082863','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4171,'XYZ-1767592457356-2461F973',5,NULL,'IN_STOCK','GRN','XYZ185572310','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4172,'XYZ-1767592457380-54FED20F',5,NULL,'IN_STOCK','GRN','XYZ710280369','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4173,'XYZ-1767592457400-41D87FAB',5,NULL,'IN_STOCK','GRN','XYZ034159371','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4174,'XYZ-1767592457419-77A3205A',5,NULL,'IN_STOCK','GRN','XYZ452904916','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4175,'XYZ-1767592457437-FEC87EFB',5,NULL,'IN_STOCK','GRN','XYZ984201252','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4176,'XYZ-1767592457455-D9A3195E',5,NULL,'IN_STOCK','GRN','XYZ262751063','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4177,'XYZ-1767592457476-DA39D956',5,NULL,'IN_STOCK','GRN','XYZ110737193','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4178,'XYZ-1767592457502-36781031',5,NULL,'IN_STOCK','GRN','XYZ323895103','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4179,'XYZ-1767592457525-B7E73840',5,NULL,'IN_STOCK','GRN','XYZ746148102','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4180,'XYZ-1767592457547-13E05B6F',5,NULL,'IN_STOCK','GRN','XYZ777666707','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4181,'XYZ-1767592457569-87B5DE22',5,NULL,'IN_STOCK','GRN','XYZ568548311','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4182,'XYZ-1767592457590-EECF3F5B',5,NULL,'IN_STOCK','GRN','XYZ421668438','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4183,'XYZ-1767592457615-B33C107F',5,NULL,'IN_STOCK','GRN','XYZ232187837','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4184,'XYZ-1767592457640-A431EA80',5,NULL,'IN_STOCK','GRN','XYZ202665017','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4185,'XYZ-1767592457664-28885546',5,NULL,'IN_STOCK','GRN','XYZ033121228','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4186,'XYZ-1767592457688-B5EDBE8B',5,NULL,'IN_STOCK','GRN','XYZ687767689','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4187,'XYZ-1767592457710-67298A38',5,NULL,'IN_STOCK','GRN','XYZ930755416','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4188,'XYZ-1767592457735-14F73D88',5,NULL,'IN_STOCK','GRN','XYZ254198684','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4189,'XYZ-1767592457760-301BEDEA',5,NULL,'IN_STOCK','GRN','XYZ222867320','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4190,'XYZ-1767592457784-0C7CCE84',5,NULL,'IN_STOCK','GRN','XYZ533262007','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4191,'XYZ-1767592457811-19ABBD96',5,NULL,'IN_STOCK','GRN','XYZ439726561','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4192,'XYZ-1767592457835-05FCBBE4',5,NULL,'IN_STOCK','GRN','XYZ092270485','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4193,'XYZ-1767592457859-B1A57EFF',5,NULL,'IN_STOCK','GRN','XYZ881401005','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4194,'XYZ-1767592457885-AD489BDD',5,NULL,'IN_STOCK','GRN','XYZ769381785','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4195,'XYZ-1767592457909-2837F5B7',5,NULL,'IN_STOCK','GRN','XYZ315635020','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4196,'XYZ-1767592457930-1F7C250B',5,NULL,'IN_STOCK','GRN','XYZ248734554','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4197,'XYZ-1767592457952-4A04628C',5,NULL,'IN_STOCK','GRN','XYZ390877132','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4198,'XYZ-1767592457971-7C19AC6A',5,NULL,'IN_STOCK','GRN','XYZ350685359','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4199,'XYZ-1767592457990-5F24B6EE',5,NULL,'IN_STOCK','GRN','XYZ674859829','2026-01-05 05:54:17','2026-01-05 05:54:17'),(4200,'XYZ-1767592458009-D70C41AA',5,NULL,'IN_STOCK','GRN','XYZ675091546','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4201,'XYZ-1767592458030-E0EF33F5',5,NULL,'IN_STOCK','GRN','XYZ163960118','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4202,'XYZ-1767592458055-169D8027',5,NULL,'IN_STOCK','GRN','XYZ551182154','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4203,'XYZ-1767592458076-00E026D8',5,NULL,'IN_STOCK','GRN','XYZ129780474','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4204,'XYZ-1767592458098-F70A81C0',5,NULL,'IN_STOCK','GRN','XYZ381510115','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4205,'XYZ-1767592458122-A409BD56',5,NULL,'IN_STOCK','GRN','XYZ613536937','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4206,'XYZ-1767592458146-0F75C3BA',5,NULL,'IN_STOCK','GRN','XYZ438452070','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4207,'XYZ-1767592458169-6B623364',5,NULL,'IN_STOCK','GRN','XYZ600523287','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4208,'XYZ-1767592458193-FEE54FCA',5,NULL,'IN_STOCK','GRN','XYZ476974794','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4209,'XYZ-1767592458213-7D60B8FC',5,NULL,'IN_STOCK','GRN','XYZ825972937','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4210,'XYZ-1767592458233-E175B5B1',5,NULL,'IN_STOCK','GRN','XYZ842008530','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4211,'XYZ-1767592458254-D8234EC2',5,NULL,'IN_STOCK','GRN','XYZ931571712','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4212,'XYZ-1767592458281-6C3B19CF',5,NULL,'IN_STOCK','GRN','XYZ425022403','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4213,'XYZ-1767592458306-2D9E358C',5,NULL,'IN_STOCK','GRN','XYZ161664327','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4214,'XYZ-1767592458327-C51C7976',5,NULL,'IN_STOCK','GRN','XYZ681094637','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4215,'XYZ-1767592458345-9F47F3CD',5,NULL,'IN_STOCK','GRN','XYZ244373646','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4216,'XYZ-1767592458363-BF6EFFBC',5,NULL,'IN_STOCK','GRN','XYZ663562920','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4217,'XYZ-1767592458389-1C103B48',5,NULL,'IN_STOCK','GRN','XYZ933942373','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4218,'XYZ-1767592458412-703223F8',5,NULL,'IN_STOCK','GRN','XYZ965190493','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4219,'XYZ-1767592458432-F1AC59B0',5,NULL,'IN_STOCK','GRN','XYZ904709219','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4220,'XYZ-1767592458453-8AA79B67',5,NULL,'IN_STOCK','GRN','XYZ249187729','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4221,'XYZ-1767592458476-C41B1FD3',5,NULL,'IN_STOCK','GRN','XYZ980850951','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4222,'XYZ-1767592458501-43B10576',5,NULL,'IN_STOCK','GRN','XYZ469723312','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4223,'XYZ-1767592458521-AB9BC564',5,NULL,'IN_STOCK','GRN','XYZ462163205','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4224,'XYZ-1767592458543-10A25DAD',5,NULL,'IN_STOCK','GRN','XYZ963322516','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4225,'XYZ-1767592458564-A2D1BC97',5,NULL,'IN_STOCK','GRN','XYZ905826616','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4226,'XYZ-1767592458587-B7DAAC4D',5,NULL,'IN_STOCK','GRN','XYZ914492485','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4227,'XYZ-1767592458610-5D34B371',5,NULL,'IN_STOCK','GRN','XYZ538965644','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4228,'XYZ-1767592458633-671F8653',5,NULL,'IN_STOCK','GRN','XYZ078153666','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4229,'XYZ-1767592458654-E2270A5E',5,NULL,'IN_STOCK','GRN','XYZ368601174','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4230,'XYZ-1767592458675-E84DAB52',5,NULL,'IN_STOCK','GRN','XYZ633611191','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4231,'XYZ-1767592458696-F55795E8',5,NULL,'IN_STOCK','GRN','XYZ260563820','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4232,'XYZ-1767592458718-B3B7FFA6',5,NULL,'IN_STOCK','GRN','XYZ547800710','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4233,'XYZ-1767592458742-9919D20E',5,NULL,'IN_STOCK','GRN','XYZ977056885','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4234,'XYZ-1767592458763-795C0C08',5,NULL,'IN_STOCK','GRN','XYZ549758789','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4235,'XYZ-1767592458786-5F08C949',5,NULL,'IN_STOCK','GRN','XYZ574442731','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4236,'XYZ-1767592458807-E046B532',5,NULL,'IN_STOCK','GRN','XYZ953678002','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4237,'XYZ-1767592458829-8D995628',5,NULL,'IN_STOCK','GRN','XYZ488375079','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4238,'XYZ-1767592458850-46F0DA03',5,NULL,'IN_STOCK','GRN','XYZ210005252','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4239,'XYZ-1767592458873-32C275F5',5,NULL,'IN_STOCK','GRN','XYZ215672314','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4240,'XYZ-1767592458894-B9130F6C',5,NULL,'IN_STOCK','GRN','XYZ109592344','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4241,'XYZ-1767592458917-286561DF',5,NULL,'IN_STOCK','GRN','XYZ386921481','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4242,'XYZ-1767592458941-E4115723',5,NULL,'IN_STOCK','GRN','XYZ966674152','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4243,'XYZ-1767592458963-0F18F0DB',5,NULL,'IN_STOCK','GRN','XYZ948203849','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4244,'XYZ-1767592458985-8D09CB46',5,NULL,'IN_STOCK','GRN','XYZ282845652','2026-01-05 05:54:18','2026-01-05 05:54:18'),(4245,'XYZ-1767592459008-CFB3FC7C',5,NULL,'IN_STOCK','GRN','XYZ275790808','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4246,'XYZ-1767592459032-9C42326C',5,NULL,'IN_STOCK','GRN','XYZ332835836','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4247,'XYZ-1767592459058-C9246121',5,NULL,'IN_STOCK','GRN','XYZ406889138','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4248,'XYZ-1767592459084-1D47A7AD',5,NULL,'IN_STOCK','GRN','XYZ618601875','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4249,'XYZ-1767592459106-49A53FEA',5,NULL,'IN_STOCK','GRN','XYZ819523472','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4250,'XYZ-1767592459127-0EF87991',5,NULL,'IN_STOCK','GRN','XYZ580871445','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4251,'XYZ-1767592459147-B93B1208',5,NULL,'IN_STOCK','GRN','XYZ521498769','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4252,'XYZ-1767592459166-FDC5EFA7',5,NULL,'IN_STOCK','GRN','XYZ457469748','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4253,'XYZ-1767592459187-58F91657',5,NULL,'IN_STOCK','GRN','XYZ736091172','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4254,'XYZ-1767592459208-661AF9B7',5,NULL,'IN_STOCK','GRN','XYZ874853621','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4255,'XYZ-1767592459232-F21924FC',5,NULL,'IN_STOCK','GRN','XYZ946261950','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4256,'XYZ-1767592459255-94EAB41D',5,NULL,'IN_STOCK','GRN','XYZ792787897','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4257,'XYZ-1767592459278-94FE7589',5,NULL,'IN_STOCK','GRN','XYZ321103145','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4258,'XYZ-1767592459301-4BF1D873',5,NULL,'IN_STOCK','GRN','XYZ513586653','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4259,'XYZ-1767592459326-D65D63B3',5,NULL,'IN_STOCK','GRN','XYZ050400121','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4260,'XYZ-1767592459350-0FBB2EAF',5,NULL,'IN_STOCK','GRN','XYZ526143793','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4261,'XYZ-1767592459376-2FCD416E',5,NULL,'IN_STOCK','GRN','XYZ661388175','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4262,'XYZ-1767592459399-8475A1A5',5,NULL,'IN_STOCK','GRN','XYZ658334199','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4263,'XYZ-1767592459425-16DBD32A',5,NULL,'IN_STOCK','GRN','XYZ349794071','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4264,'XYZ-1767592459448-F03CF563',5,NULL,'IN_STOCK','GRN','XYZ361048540','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4265,'XYZ-1767592459471-C717CDC7',5,NULL,'IN_STOCK','GRN','XYZ275606782','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4266,'XYZ-1767592459493-E703C469',5,NULL,'IN_STOCK','GRN','XYZ610266152','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4267,'XYZ-1767592459517-A459766E',5,NULL,'IN_STOCK','GRN','XYZ008920889','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4268,'XYZ-1767592459540-0519AC94',5,NULL,'IN_STOCK','GRN','XYZ684273742','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4269,'XYZ-1767592459563-1E906FBB',5,NULL,'IN_STOCK','GRN','XYZ038375692','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4270,'XYZ-1767592459585-3B9E21F8',5,NULL,'IN_STOCK','GRN','XYZ484858972','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4271,'XYZ-1767592459609-9D214B65',5,NULL,'IN_STOCK','GRN','XYZ368958851','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4272,'XYZ-1767592459632-9BFA9C9E',5,NULL,'IN_STOCK','GRN','XYZ880812497','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4273,'XYZ-1767592459656-4AC9AEE4',5,NULL,'IN_STOCK','GRN','XYZ444108582','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4274,'XYZ-1767592459678-F0597573',5,NULL,'IN_STOCK','GRN','XYZ372675396','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4275,'XYZ-1767592459703-DA6ABFBA',5,NULL,'IN_STOCK','GRN','XYZ228414783','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4276,'XYZ-1767592459728-30899BC1',5,NULL,'IN_STOCK','GRN','XYZ083851270','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4277,'XYZ-1767592459750-E2CF6DC2',5,NULL,'IN_STOCK','GRN','XYZ866992348','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4278,'XYZ-1767592459774-471BD47A',5,NULL,'IN_STOCK','GRN','XYZ600343384','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4279,'XYZ-1767592459798-9365B95C',5,NULL,'IN_STOCK','GRN','XYZ997277466','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4280,'XYZ-1767592459819-F141CC3D',5,NULL,'IN_STOCK','GRN','XYZ275043383','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4281,'XYZ-1767592459842-21D644C8',5,NULL,'IN_STOCK','GRN','XYZ424116234','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4282,'XYZ-1767592459865-69A0DE29',5,NULL,'IN_STOCK','GRN','XYZ513212282','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4283,'XYZ-1767592459888-EC7BE82C',5,NULL,'IN_STOCK','GRN','XYZ676440746','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4284,'XYZ-1767592459914-482268B6',5,NULL,'IN_STOCK','GRN','XYZ886565899','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4285,'XYZ-1767592459939-16B97F66',5,NULL,'IN_STOCK','GRN','XYZ505280710','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4286,'XYZ-1767592459963-93F400F8',5,NULL,'IN_STOCK','GRN','XYZ819475495','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4287,'XYZ-1767592459988-55BA5739',5,NULL,'IN_STOCK','GRN','XYZ138257080','2026-01-05 05:54:19','2026-01-05 05:54:19'),(4288,'XYZ-1767592460010-129B26D5',5,NULL,'IN_STOCK','GRN','XYZ310567109','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4289,'XYZ-1767592460033-DC8C412D',5,NULL,'IN_STOCK','GRN','XYZ839087572','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4290,'XYZ-1767592460054-F8FF6208',5,NULL,'IN_STOCK','GRN','XYZ838075436','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4291,'XYZ-1767592460075-F34B0537',5,NULL,'IN_STOCK','GRN','XYZ605978442','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4292,'XYZ-1767592460096-55E67ECC',5,NULL,'IN_STOCK','GRN','XYZ826505615','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4293,'XYZ-1767592460115-638AF2B5',5,NULL,'IN_STOCK','GRN','XYZ361785302','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4294,'XYZ-1767592460136-B797A0AF',5,NULL,'IN_STOCK','GRN','XYZ362878421','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4295,'XYZ-1767592460157-CD7A98E9',5,NULL,'IN_STOCK','GRN','XYZ433176568','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4296,'XYZ-1767592460179-CFAC055E',5,NULL,'IN_STOCK','GRN','XYZ603291828','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4297,'XYZ-1767592460202-7E87F48F',5,NULL,'IN_STOCK','GRN','XYZ272616349','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4298,'XYZ-1767592460224-FE4DAF36',5,NULL,'IN_STOCK','GRN','XYZ856261851','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4299,'XYZ-1767592460247-1020391A',5,NULL,'IN_STOCK','GRN','XYZ629225403','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4300,'XYZ-1767592460268-0CCFFB62',5,NULL,'IN_STOCK','GRN','XYZ049369628','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4301,'XYZ-1767592460291-78737878',5,NULL,'IN_STOCK','GRN','XYZ976804535','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4302,'XYZ-1767592460315-6036F11F',5,NULL,'IN_STOCK','GRN','XYZ349409542','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4303,'XYZ-1767592460341-786C1BCB',5,NULL,'IN_STOCK','GRN','XYZ711162577','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4304,'XYZ-1767592460364-B39BDFDD',5,NULL,'IN_STOCK','GRN','XYZ312652344','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4305,'XYZ-1767592460386-54CC43EE',5,NULL,'IN_STOCK','GRN','XYZ313296315','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4306,'XYZ-1767592460409-A201293F',5,NULL,'IN_STOCK','GRN','XYZ196627401','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4307,'XYZ-1767592460432-A8A8E874',5,NULL,'IN_STOCK','GRN','XYZ700005628','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4308,'XYZ-1767592460454-43AABE1A',5,NULL,'IN_STOCK','GRN','XYZ506687283','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4309,'XYZ-1767592460475-CDBA663C',5,NULL,'IN_STOCK','GRN','XYZ409411353','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4310,'XYZ-1767592460496-E9566617',5,NULL,'IN_STOCK','GRN','XYZ922426345','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4311,'XYZ-1767592460516-D16C052B',5,NULL,'IN_STOCK','GRN','XYZ977274476','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4312,'XYZ-1767592460536-97CF151A',5,NULL,'IN_STOCK','GRN','XYZ917716740','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4313,'XYZ-1767592460557-B8EBA600',5,NULL,'IN_STOCK','GRN','XYZ869186378','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4314,'XYZ-1767592460579-0C0A9926',5,NULL,'IN_STOCK','GRN','XYZ000522995','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4315,'XYZ-1767592460603-A3BE8A77',5,NULL,'IN_STOCK','GRN','XYZ008873684','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4316,'XYZ-1767592460625-FFE0D12A',5,NULL,'IN_STOCK','GRN','XYZ016353610','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4317,'XYZ-1767592460647-14364651',5,NULL,'IN_STOCK','GRN','XYZ567302774','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4318,'XYZ-1767592460667-261409B2',5,NULL,'IN_STOCK','GRN','XYZ478255621','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4319,'XYZ-1767592460688-42698048',5,NULL,'IN_STOCK','GRN','XYZ467273308','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4320,'XYZ-1767592460712-1A077166',5,NULL,'IN_STOCK','GRN','XYZ767977450','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4321,'XYZ-1767592460734-97A976F8',5,NULL,'IN_STOCK','GRN','XYZ409791095','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4322,'XYZ-1767592460755-A151C876',5,NULL,'IN_STOCK','GRN','XYZ921742710','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4323,'XYZ-1767592460775-0DE257CB',5,NULL,'IN_STOCK','GRN','XYZ171313245','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4324,'XYZ-1767592460796-FEA304E5',5,NULL,'IN_STOCK','GRN','XYZ194330089','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4325,'XYZ-1767592460818-741F3122',5,NULL,'IN_STOCK','GRN','XYZ434730703','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4326,'XYZ-1767592460842-4CF5AF62',5,NULL,'IN_STOCK','GRN','XYZ881755917','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4327,'XYZ-1767592460866-F6D05578',5,NULL,'IN_STOCK','GRN','XYZ369394637','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4328,'XYZ-1767592460891-91DC364A',5,NULL,'IN_STOCK','GRN','XYZ901632827','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4329,'XYZ-1767592460916-E135FF00',5,NULL,'IN_STOCK','GRN','XYZ697323565','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4330,'XYZ-1767592460939-DBD0891B',5,NULL,'IN_STOCK','GRN','XYZ805066180','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4331,'XYZ-1767592460964-099FADA9',5,NULL,'IN_STOCK','GRN','XYZ393633615','2026-01-05 05:54:20','2026-01-05 05:54:20'),(4332,'XYZ-1767592460991-35D0BB08',5,NULL,'IN_STOCK','GRN','XYZ335319637','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4333,'XYZ-1767592461015-0F1381B5',5,NULL,'IN_STOCK','GRN','XYZ649932335','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4334,'XYZ-1767592461039-B1FBFF11',5,NULL,'IN_STOCK','GRN','XYZ644860427','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4335,'XYZ-1767592461059-98524516',5,NULL,'IN_STOCK','GRN','XYZ760571331','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4336,'XYZ-1767592461082-4D314671',5,NULL,'IN_STOCK','GRN','XYZ052470376','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4337,'XYZ-1767592461107-CAEA7902',5,NULL,'IN_STOCK','GRN','XYZ451386897','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4338,'XYZ-1767592461128-C821570F',5,NULL,'IN_STOCK','GRN','XYZ716304396','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4339,'XYZ-1767592461148-DA90A6D2',5,NULL,'IN_STOCK','GRN','XYZ622726244','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4340,'XYZ-1767592461169-B811A4CA',5,NULL,'IN_STOCK','GRN','XYZ894635892','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4341,'XYZ-1767592461190-12D2313D',5,NULL,'IN_STOCK','GRN','XYZ828501901','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4342,'XYZ-1767592461211-1165674F',5,NULL,'IN_STOCK','GRN','XYZ321633981','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4343,'XYZ-1767592461233-B6A9E4AC',5,NULL,'IN_STOCK','GRN','XYZ654530540','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4344,'XYZ-1767592461254-317ED396',5,NULL,'IN_STOCK','GRN','XYZ987348203','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4345,'XYZ-1767592461275-740B27C4',5,NULL,'IN_STOCK','GRN','XYZ283586392','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4346,'XYZ-1767592461295-97F6B07B',5,NULL,'IN_STOCK','GRN','XYZ762556846','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4347,'XYZ-1767592461316-20725C3C',5,NULL,'IN_STOCK','GRN','XYZ607161172','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4348,'XYZ-1767592461336-A599BAE7',5,NULL,'IN_STOCK','GRN','XYZ874971929','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4349,'XYZ-1767592461357-744A9C5F',5,NULL,'IN_STOCK','GRN','XYZ212553912','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4350,'XYZ-1767592461381-051D298B',5,NULL,'IN_STOCK','GRN','XYZ192326169','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4351,'XYZ-1767592461401-5299D8A3',5,NULL,'IN_STOCK','GRN','XYZ213873171','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4352,'XYZ-1767592461421-AD6EDE1F',5,NULL,'IN_STOCK','GRN','XYZ422120144','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4353,'XYZ-1767592461442-D4EF0839',5,NULL,'IN_STOCK','GRN','XYZ486985462','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4354,'XYZ-1767592461462-0746C8DB',5,NULL,'IN_STOCK','GRN','XYZ712584215','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4355,'XYZ-1767592461485-68F107E4',5,NULL,'IN_STOCK','GRN','XYZ780469781','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4356,'XYZ-1767592461507-E520639A',5,NULL,'IN_STOCK','GRN','XYZ070928143','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4357,'XYZ-1767592461530-051376BA',5,NULL,'IN_STOCK','GRN','XYZ629047209','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4358,'XYZ-1767592461550-7F5EDFBD',5,NULL,'IN_STOCK','GRN','XYZ679572715','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4359,'XYZ-1767592461575-8A1BB4BB',5,NULL,'IN_STOCK','GRN','XYZ683028773','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4360,'XYZ-1767592461600-D5316FC8',5,NULL,'IN_STOCK','GRN','XYZ627183155','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4361,'XYZ-1767592461625-61EDD46E',5,NULL,'IN_STOCK','GRN','XYZ633711299','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4362,'XYZ-1767592461650-2E5CD6F7',5,NULL,'IN_STOCK','GRN','XYZ567392894','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4363,'XYZ-1767592461674-7156E880',5,NULL,'IN_STOCK','GRN','XYZ571345165','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4364,'XYZ-1767592461699-2D02986D',5,NULL,'IN_STOCK','GRN','XYZ316816725','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4365,'XYZ-1767592461722-9EB612BB',5,NULL,'IN_STOCK','GRN','XYZ704673345','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4366,'XYZ-1767592461746-9A6AC130',5,NULL,'IN_STOCK','GRN','XYZ974266303','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4367,'XYZ-1767592461769-E032FE09',5,NULL,'IN_STOCK','GRN','XYZ866852470','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4368,'XYZ-1767592461793-4E915AE0',5,NULL,'IN_STOCK','GRN','XYZ349328093','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4369,'XYZ-1767592461814-068232B9',5,NULL,'IN_STOCK','GRN','XYZ454489892','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4370,'XYZ-1767592461835-748223AE',5,NULL,'IN_STOCK','GRN','XYZ012535235','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4371,'XYZ-1767592461861-D16B0FE7',5,NULL,'IN_STOCK','GRN','XYZ808893885','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4372,'XYZ-1767592461884-AAA431B8',5,NULL,'IN_STOCK','GRN','XYZ184535013','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4373,'XYZ-1767592461909-B9892724',5,NULL,'IN_STOCK','GRN','XYZ678644812','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4374,'XYZ-1767592461931-2355AD15',5,NULL,'IN_STOCK','GRN','XYZ898719953','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4375,'XYZ-1767592461957-2B1301BB',5,NULL,'IN_STOCK','GRN','XYZ242266352','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4376,'XYZ-1767592461980-80100BE2',5,NULL,'IN_STOCK','GRN','XYZ452770790','2026-01-05 05:54:21','2026-01-05 05:54:21'),(4377,'XYZ-1767592462002-E0E12849',5,NULL,'IN_STOCK','GRN','XYZ714090583','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4378,'XYZ-1767592462025-D65A589A',5,NULL,'IN_STOCK','GRN','XYZ986842182','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4379,'XYZ-1767592462050-134F236E',5,NULL,'IN_STOCK','GRN','XYZ822456192','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4380,'XYZ-1767592462074-743815B2',5,NULL,'IN_STOCK','GRN','XYZ209312332','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4381,'XYZ-1767592462095-4BD15674',5,NULL,'IN_STOCK','GRN','XYZ372651186','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4382,'XYZ-1767592462115-5093280C',5,NULL,'IN_STOCK','GRN','XYZ524705400','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4383,'XYZ-1767592462135-C6EE7EA8',5,NULL,'IN_STOCK','GRN','XYZ990415590','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4384,'XYZ-1767592462158-8077CB9C',5,NULL,'IN_STOCK','GRN','XYZ922674249','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4385,'XYZ-1767592462181-ACCD7E08',5,NULL,'IN_STOCK','GRN','XYZ079212429','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4386,'XYZ-1767592462205-9B614FBE',5,NULL,'IN_STOCK','GRN','XYZ330247005','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4387,'XYZ-1767592462229-7CD580B1',5,NULL,'IN_STOCK','GRN','XYZ009896905','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4388,'XYZ-1767592462255-70461486',5,NULL,'IN_STOCK','GRN','XYZ888010228','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4389,'XYZ-1767592462281-D6B00D94',5,NULL,'IN_STOCK','GRN','XYZ344894376','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4390,'XYZ-1767592462301-BDA395AC',5,NULL,'IN_STOCK','GRN','XYZ378567440','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4391,'XYZ-1767592462321-FE442D05',5,NULL,'IN_STOCK','GRN','XYZ338635376','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4392,'XYZ-1767592462337-E1C70A80',5,NULL,'IN_STOCK','GRN','XYZ611762960','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4393,'XYZ-1767592462358-AADD8397',5,NULL,'IN_STOCK','GRN','XYZ828501834','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4394,'XYZ-1767592462381-3FAF0F94',5,NULL,'IN_STOCK','GRN','XYZ968433350','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4395,'XYZ-1767592462403-FDF9A663',5,NULL,'IN_STOCK','GRN','XYZ208037029','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4396,'XYZ-1767592462423-23B855FE',5,NULL,'IN_STOCK','GRN','XYZ462275231','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4397,'XYZ-1767592462446-2B345F22',5,NULL,'IN_STOCK','GRN','XYZ246708450','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4398,'XYZ-1767592462468-A5E1DA5F',5,NULL,'IN_STOCK','GRN','XYZ780585355','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4399,'XYZ-1767592462490-495A96D6',5,NULL,'IN_STOCK','GRN','XYZ408542581','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4400,'XYZ-1767592462511-ACFF1D1E',5,NULL,'IN_STOCK','GRN','XYZ063124865','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4401,'XYZ-1767592462529-BAED81FF',5,NULL,'IN_STOCK','GRN','XYZ854042009','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4402,'XYZ-1767592462547-4CD82226',5,NULL,'IN_STOCK','GRN','XYZ378258784','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4403,'XYZ-1767592462564-0110EDAC',5,NULL,'IN_STOCK','GRN','XYZ959132827','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4404,'XYZ-1767592462583-F84F2FA6',5,NULL,'IN_STOCK','GRN','XYZ289599522','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4405,'XYZ-1767592462603-1D1DF086',5,NULL,'IN_STOCK','GRN','XYZ679814466','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4406,'XYZ-1767592462625-AC34A445',5,NULL,'IN_STOCK','GRN','XYZ438707659','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4407,'XYZ-1767592462644-DC9156AC',5,NULL,'IN_STOCK','GRN','XYZ203033677','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4408,'XYZ-1767592462663-69A1FADD',5,NULL,'IN_STOCK','GRN','XYZ902410583','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4409,'XYZ-1767592462684-31AD43E4',5,NULL,'IN_STOCK','GRN','XYZ938801544','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4410,'XYZ-1767592462704-70C36244',5,NULL,'IN_STOCK','GRN','XYZ465904757','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4411,'XYZ-1767592462727-84B082B3',5,NULL,'IN_STOCK','GRN','XYZ485528705','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4412,'XYZ-1767592462751-7D3415C6',5,NULL,'IN_STOCK','GRN','XYZ424266624','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4413,'XYZ-1767592462774-CF3DCE3F',5,NULL,'IN_STOCK','GRN','XYZ098451380','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4414,'XYZ-1767592462798-BC38FEDD',5,NULL,'IN_STOCK','GRN','XYZ945800963','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4415,'XYZ-1767592462821-FF33DC17',5,NULL,'IN_STOCK','GRN','XYZ930109622','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4416,'XYZ-1767592462842-5CEAF189',5,NULL,'IN_STOCK','GRN','XYZ588092987','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4417,'XYZ-1767592462864-99F71644',5,NULL,'IN_STOCK','GRN','XYZ551880235','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4418,'XYZ-1767592462885-F76BF427',5,NULL,'IN_STOCK','GRN','XYZ406428391','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4419,'XYZ-1767592462906-833D9B8F',5,NULL,'IN_STOCK','GRN','XYZ412730640','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4420,'XYZ-1767592462929-C8428629',5,NULL,'IN_STOCK','GRN','XYZ898160444','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4421,'XYZ-1767592462954-762F18F6',5,NULL,'IN_STOCK','GRN','XYZ907761501','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4422,'XYZ-1767592462979-1B720DB6',5,NULL,'IN_STOCK','GRN','XYZ831679922','2026-01-05 05:54:22','2026-01-05 05:54:22'),(4423,'XYZ-1767592462999-E14B4B1A',5,NULL,'IN_STOCK','GRN','XYZ303077392','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4424,'XYZ-1767592463017-F17F604D',5,NULL,'IN_STOCK','GRN','XYZ515762938','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4425,'XYZ-1767592463038-E6672C72',5,NULL,'IN_STOCK','GRN','XYZ678568767','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4426,'XYZ-1767592463061-9EC7BED9',5,NULL,'IN_STOCK','GRN','XYZ605931961','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4427,'XYZ-1767592463083-5696F0E3',5,NULL,'IN_STOCK','GRN','XYZ834060893','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4428,'XYZ-1767592463107-7FB8742F',5,NULL,'IN_STOCK','GRN','XYZ853777835','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4429,'XYZ-1767592463133-268342F5',5,NULL,'IN_STOCK','GRN','XYZ992887966','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4430,'XYZ-1767592463155-A42333BC',5,NULL,'IN_STOCK','GRN','XYZ370457706','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4431,'XYZ-1767592463178-C350E51B',5,NULL,'IN_STOCK','GRN','XYZ977519316','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4432,'XYZ-1767592463199-09B971E5',5,NULL,'IN_STOCK','GRN','XYZ852372470','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4433,'XYZ-1767592463222-B52D514D',5,NULL,'IN_STOCK','GRN','XYZ376868636','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4434,'XYZ-1767592463242-7C333354',5,NULL,'IN_STOCK','GRN','XYZ769452511','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4435,'XYZ-1767592463265-487BE180',5,NULL,'IN_STOCK','GRN','XYZ245132279','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4436,'XYZ-1767592463290-E422EBF2',5,NULL,'IN_STOCK','GRN','XYZ566140701','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4437,'XYZ-1767592463311-97A32F6E',5,NULL,'IN_STOCK','GRN','XYZ573090819','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4438,'XYZ-1767592463332-2E1C255C',5,NULL,'IN_STOCK','GRN','XYZ294236097','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4439,'XYZ-1767592463353-8D3E9D28',5,NULL,'IN_STOCK','GRN','XYZ573710476','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4440,'XYZ-1767592463374-B5154A9A',5,NULL,'IN_STOCK','GRN','XYZ693641234','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4441,'XYZ-1767592463399-01F09699',5,NULL,'IN_STOCK','GRN','XYZ585514630','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4442,'XYZ-1767592463424-0796248B',5,NULL,'IN_STOCK','GRN','XYZ283187439','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4443,'XYZ-1767592463448-1767EFF9',5,NULL,'IN_STOCK','GRN','XYZ304982254','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4444,'XYZ-1767592463471-D2086971',5,NULL,'IN_STOCK','GRN','XYZ657427034','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4445,'XYZ-1767592463493-697CCCA7',5,NULL,'IN_STOCK','GRN','XYZ254352409','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4446,'XYZ-1767592463516-90B272A6',5,NULL,'IN_STOCK','GRN','XYZ895115977','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4447,'XYZ-1767592463538-894E32C3',5,NULL,'IN_STOCK','GRN','XYZ164072937','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4448,'XYZ-1767592463560-225BEFC4',5,NULL,'IN_STOCK','GRN','XYZ706134973','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4449,'XYZ-1767592463580-4382A3EA',5,NULL,'IN_STOCK','GRN','XYZ420633907','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4450,'XYZ-1767592463604-858D3AB5',5,NULL,'IN_STOCK','GRN','XYZ804137119','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4451,'XYZ-1767592463628-F3336407',5,NULL,'IN_STOCK','GRN','XYZ010291653','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4452,'XYZ-1767592463656-8804DC68',5,NULL,'IN_STOCK','GRN','XYZ672566221','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4453,'XYZ-1767592463682-F5AA5518',5,NULL,'IN_STOCK','GRN','XYZ657755020','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4454,'XYZ-1767592463706-7372B64B',5,NULL,'IN_STOCK','GRN','XYZ908004155','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4455,'XYZ-1767592463733-253FAEE4',5,NULL,'IN_STOCK','GRN','XYZ901535588','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4456,'XYZ-1767592463758-DE1359DA',5,NULL,'IN_STOCK','GRN','XYZ657085496','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4457,'XYZ-1767592463783-03F1E2F2',5,NULL,'IN_STOCK','GRN','XYZ443388372','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4458,'XYZ-1767592463802-FBC76EE9',5,NULL,'IN_STOCK','GRN','XYZ045627214','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4459,'XYZ-1767592463825-26F03E82',5,NULL,'IN_STOCK','GRN','XYZ753340569','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4460,'XYZ-1767592463851-8DAEFB94',5,NULL,'IN_STOCK','GRN','XYZ196186539','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4461,'XYZ-1767592463876-108F1D4D',5,NULL,'IN_STOCK','GRN','XYZ732440744','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4462,'XYZ-1767592463902-46D9C91D',5,NULL,'IN_STOCK','GRN','XYZ238485658','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4463,'XYZ-1767592463926-1D137591',5,NULL,'IN_STOCK','GRN','XYZ112475347','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4464,'XYZ-1767592463950-2A936A5F',5,NULL,'IN_STOCK','GRN','XYZ061649224','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4465,'XYZ-1767592463975-1CD7DFA9',5,NULL,'IN_STOCK','GRN','XYZ437194167','2026-01-05 05:54:23','2026-01-05 05:54:23'),(4466,'XYZ-1767592463999-94045B2E',5,NULL,'IN_STOCK','GRN','XYZ978052568','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4467,'XYZ-1767592464022-0C80B865',5,NULL,'IN_STOCK','GRN','XYZ381486052','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4468,'XYZ-1767592464047-D76BC463',5,NULL,'IN_STOCK','GRN','XYZ677444721','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4469,'XYZ-1767592464071-DA490E8B',5,NULL,'IN_STOCK','GRN','XYZ157269941','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4470,'XYZ-1767592464096-6D690683',5,NULL,'IN_STOCK','GRN','XYZ948694165','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4471,'XYZ-1767592464122-C86A57A1',5,NULL,'IN_STOCK','GRN','XYZ306768963','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4472,'XYZ-1767592464145-7BD1D4A2',5,NULL,'IN_STOCK','GRN','XYZ327291123','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4473,'XYZ-1767592464169-486E5AFF',5,NULL,'IN_STOCK','GRN','XYZ376918374','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4474,'XYZ-1767592464192-335265FE',5,NULL,'IN_STOCK','GRN','XYZ405269661','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4475,'XYZ-1767592464212-4C3BB4EF',5,NULL,'IN_STOCK','GRN','XYZ955777639','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4476,'XYZ-1767592464236-8DE26B08',5,NULL,'IN_STOCK','GRN','XYZ781598014','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4477,'XYZ-1767592464258-747F9DF2',5,NULL,'IN_STOCK','GRN','XYZ633456065','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4478,'XYZ-1767592464285-175D7482',5,NULL,'IN_STOCK','GRN','XYZ472725281','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4479,'XYZ-1767592464310-324A3D4E',5,NULL,'IN_STOCK','GRN','XYZ947357673','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4480,'XYZ-1767592464336-60AD92CF',5,NULL,'IN_STOCK','GRN','XYZ981074743','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4481,'XYZ-1767592464359-3F6F5537',5,NULL,'IN_STOCK','GRN','XYZ109392653','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4482,'XYZ-1767592464383-800936D8',5,NULL,'IN_STOCK','GRN','XYZ540949872','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4483,'XYZ-1767592464406-F6634DCA',5,NULL,'IN_STOCK','GRN','XYZ330124945','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4484,'XYZ-1767592464433-714E4447',5,NULL,'IN_STOCK','GRN','XYZ921401883','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4485,'XYZ-1767592464459-64863ED9',5,NULL,'IN_STOCK','GRN','XYZ922554293','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4486,'XYZ-1767592464486-3A102012',5,NULL,'IN_STOCK','GRN','XYZ724562256','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4487,'XYZ-1767592464512-4BB63CB8',5,NULL,'IN_STOCK','GRN','XYZ544901474','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4488,'XYZ-1767592464536-3CCB9250',5,NULL,'IN_STOCK','GRN','XYZ280392344','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4489,'XYZ-1767592464561-4A5B7950',5,NULL,'IN_STOCK','GRN','XYZ311256827','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4490,'XYZ-1767592464589-8C56FBC9',5,NULL,'IN_STOCK','GRN','XYZ292815835','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4491,'XYZ-1767592464613-54E194EE',5,NULL,'IN_STOCK','GRN','XYZ094707383','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4492,'XYZ-1767592464638-CB18B4DB',5,NULL,'IN_STOCK','GRN','XYZ948001817','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4493,'XYZ-1767592464661-5D701674',5,NULL,'IN_STOCK','GRN','XYZ930177690','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4494,'XYZ-1767592464685-9BCC128B',5,NULL,'IN_STOCK','GRN','XYZ556257077','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4495,'XYZ-1767592464709-7D0D9C74',5,NULL,'IN_STOCK','GRN','XYZ649990412','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4496,'XYZ-1767592464736-B90BC9E0',5,NULL,'IN_STOCK','GRN','XYZ741644804','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4497,'XYZ-1767592464758-E13212BF',5,NULL,'IN_STOCK','GRN','XYZ775090970','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4498,'XYZ-1767592464780-9FE9B10F',5,NULL,'IN_STOCK','GRN','XYZ007674512','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4499,'XYZ-1767592464803-F39B585B',5,NULL,'IN_STOCK','GRN','XYZ698957378','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4500,'XYZ-1767592464827-24C4C9D1',5,NULL,'IN_STOCK','GRN','XYZ690958501','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4501,'XYZ-1767592464849-0CC5026E',5,NULL,'IN_STOCK','GRN','XYZ900468694','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4502,'XYZ-1767592464872-92CC8393',5,NULL,'IN_STOCK','GRN','XYZ633148068','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4503,'XYZ-1767592464896-E5BF9C43',5,NULL,'IN_STOCK','GRN','XYZ038801467','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4504,'XYZ-1767592464920-507BD232',5,NULL,'IN_STOCK','GRN','XYZ905661976','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4505,'XYZ-1767592464942-133D88CD',5,NULL,'IN_STOCK','GRN','XYZ403394643','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4506,'XYZ-1767592464966-3127AA9A',5,NULL,'IN_STOCK','GRN','XYZ235939352','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4507,'XYZ-1767592464987-D204CAF4',5,NULL,'IN_STOCK','GRN','XYZ107167035','2026-01-05 05:54:24','2026-01-05 05:54:24'),(4508,'XYZ-1767592465009-07EE1626',5,NULL,'IN_STOCK','GRN','XYZ316554720','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4509,'XYZ-1767592465030-8F87BB26',5,NULL,'IN_STOCK','GRN','XYZ774061983','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4510,'XYZ-1767592465052-45A7D67E',5,NULL,'IN_STOCK','GRN','XYZ739422460','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4511,'XYZ-1767592465075-DE2CB924',5,NULL,'IN_STOCK','GRN','XYZ861650425','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4512,'XYZ-1767592465096-BF83A054',5,NULL,'IN_STOCK','GRN','XYZ778513270','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4513,'XYZ-1767592465120-E126FC2C',5,NULL,'IN_STOCK','GRN','XYZ818284129','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4514,'XYZ-1767592465147-F52AE046',5,NULL,'IN_STOCK','GRN','XYZ417633472','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4515,'XYZ-1767592465181-307E3030',5,NULL,'IN_STOCK','GRN','XYZ957648909','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4516,'XYZ-1767592465209-AA1332A2',5,NULL,'IN_STOCK','GRN','XYZ437124006','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4517,'XYZ-1767592465237-282A8F04',5,NULL,'IN_STOCK','GRN','XYZ215780219','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4518,'XYZ-1767592465266-B71B6BC2',5,NULL,'IN_STOCK','GRN','XYZ184794362','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4519,'XYZ-1767592465290-085361DD',5,NULL,'IN_STOCK','GRN','XYZ369491371','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4520,'XYZ-1767592465315-F8C21EA7',5,NULL,'IN_STOCK','GRN','XYZ267483974','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4521,'XYZ-1767592465341-84BDFC48',5,NULL,'IN_STOCK','GRN','XYZ376674709','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4522,'XYZ-1767592465367-DD12D4A6',5,NULL,'IN_STOCK','GRN','XYZ145069480','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4523,'XYZ-1767592465393-8CD25A22',5,NULL,'IN_STOCK','GRN','XYZ853492691','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4524,'XYZ-1767592465419-2A597F11',5,NULL,'IN_STOCK','GRN','XYZ173064926','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4525,'XYZ-1767592465446-65E53BF3',5,NULL,'IN_STOCK','GRN','XYZ929813634','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4526,'XYZ-1767592465474-95D95F28',5,NULL,'IN_STOCK','GRN','XYZ491465776','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4527,'XYZ-1767592465499-170C1481',5,NULL,'IN_STOCK','GRN','XYZ319089026','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4528,'XYZ-1767592465524-59BEF7A1',5,NULL,'IN_STOCK','GRN','XYZ229686270','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4529,'XYZ-1767592465546-B4C8402B',5,NULL,'IN_STOCK','GRN','XYZ822363701','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4530,'XYZ-1767592465566-2155F814',5,NULL,'IN_STOCK','GRN','XYZ747413795','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4531,'XYZ-1767592465595-87B19051',5,NULL,'IN_STOCK','GRN','XYZ755533060','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4532,'XYZ-1767592465623-260D66E0',5,NULL,'IN_STOCK','GRN','XYZ213949356','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4533,'XYZ-1767592465648-D7B9F6C5',5,NULL,'IN_STOCK','GRN','XYZ548891720','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4534,'XYZ-1767592465677-0EF611AC',5,NULL,'IN_STOCK','GRN','XYZ440492962','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4535,'XYZ-1767592465706-F74F72AE',5,NULL,'IN_STOCK','GRN','XYZ917892228','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4536,'XYZ-1767592465733-776156C7',5,NULL,'IN_STOCK','GRN','XYZ401604770','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4537,'XYZ-1767592465759-219B477C',5,NULL,'IN_STOCK','GRN','XYZ521307234','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4538,'XYZ-1767592465783-79B3F641',5,NULL,'IN_STOCK','GRN','XYZ024193274','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4539,'XYZ-1767592465807-A84A0AB7',5,NULL,'IN_STOCK','GRN','XYZ589927682','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4540,'XYZ-1767592465836-4D1C1451',5,NULL,'IN_STOCK','GRN','XYZ455147373','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4541,'XYZ-1767592465862-9B6E6B1B',5,NULL,'IN_STOCK','GRN','XYZ801693103','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4542,'XYZ-1767592465888-212A4747',5,NULL,'IN_STOCK','GRN','XYZ004811134','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4543,'XYZ-1767592465914-18237A34',5,NULL,'IN_STOCK','GRN','XYZ194021939','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4544,'XYZ-1767592465941-877C9DAA',5,NULL,'IN_STOCK','GRN','XYZ262042576','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4545,'XYZ-1767592465966-0226C590',5,NULL,'IN_STOCK','GRN','XYZ873746714','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4546,'XYZ-1767592465989-6961048F',5,NULL,'IN_STOCK','GRN','XYZ876859007','2026-01-05 05:54:25','2026-01-05 05:54:25'),(4547,'XYZ-1767592466013-B776B4B9',5,NULL,'IN_STOCK','GRN','XYZ428748645','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4548,'XYZ-1767592466036-AC1F8045',5,NULL,'IN_STOCK','GRN','XYZ821599170','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4549,'XYZ-1767592466063-B7A7D1A3',5,NULL,'IN_STOCK','GRN','XYZ583870907','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4550,'XYZ-1767592466088-ABA6C49A',5,NULL,'IN_STOCK','GRN','XYZ007262739','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4551,'XYZ-1767592466115-97C754CA',5,NULL,'IN_STOCK','GRN','XYZ315403195','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4552,'XYZ-1767592466142-4E50D78C',5,NULL,'IN_STOCK','GRN','XYZ706040131','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4553,'XYZ-1767592466168-13D74F63',5,NULL,'IN_STOCK','GRN','XYZ112071629','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4554,'XYZ-1767592466194-DF1C120D',5,NULL,'IN_STOCK','GRN','XYZ565691259','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4555,'XYZ-1767592466216-F55FEB81',5,NULL,'IN_STOCK','GRN','XYZ421582925','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4556,'XYZ-1767592466243-F662F9DB',5,NULL,'IN_STOCK','GRN','XYZ005429622','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4557,'XYZ-1767592466269-B3987590',5,NULL,'IN_STOCK','GRN','XYZ801140386','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4558,'XYZ-1767592466297-A91E26A5',5,NULL,'IN_STOCK','GRN','XYZ648349930','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4559,'XYZ-1767592466323-377F3BF9',5,NULL,'IN_STOCK','GRN','XYZ972096271','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4560,'XYZ-1767592466346-EA9D964B',5,NULL,'IN_STOCK','GRN','XYZ718959309','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4561,'XYZ-1767592466373-9A5CD078',5,NULL,'IN_STOCK','GRN','XYZ665597677','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4562,'XYZ-1767592466399-E7A1F651',5,NULL,'IN_STOCK','GRN','XYZ265915076','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4563,'XYZ-1767592466425-629091F5',5,NULL,'IN_STOCK','GRN','XYZ471425007','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4564,'XYZ-1767592466452-5BF2255E',5,NULL,'IN_STOCK','GRN','XYZ270527658','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4565,'XYZ-1767592466477-AE04841D',5,NULL,'IN_STOCK','GRN','XYZ373024271','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4566,'XYZ-1767592466499-A28DF510',5,NULL,'IN_STOCK','GRN','XYZ445745278','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4567,'XYZ-1767592466520-E6E0E21B',5,NULL,'IN_STOCK','GRN','XYZ645113650','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4568,'XYZ-1767592466542-817E4AE7',5,NULL,'IN_STOCK','GRN','XYZ929816749','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4569,'XYZ-1767592466566-9D0C1588',5,NULL,'IN_STOCK','GRN','XYZ714298962','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4570,'XYZ-1767592466587-222C7CC2',5,NULL,'IN_STOCK','GRN','XYZ370368721','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4571,'XYZ-1767592466611-4FA63E33',5,NULL,'IN_STOCK','GRN','XYZ433993044','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4572,'XYZ-1767592466634-85EDA8E0',5,NULL,'IN_STOCK','GRN','XYZ448562534','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4573,'XYZ-1767592466656-5169B363',5,NULL,'IN_STOCK','GRN','XYZ985256300','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4574,'XYZ-1767592466677-5E610352',5,NULL,'IN_STOCK','GRN','XYZ990854793','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4575,'XYZ-1767592466698-E72C3041',5,NULL,'IN_STOCK','GRN','XYZ111942424','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4576,'XYZ-1767592466719-AE4ACAFB',5,NULL,'IN_STOCK','GRN','XYZ115730284','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4577,'XYZ-1767592466740-25284107',5,NULL,'IN_STOCK','GRN','XYZ449492269','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4578,'XYZ-1767592466765-35D8D524',5,NULL,'IN_STOCK','GRN','XYZ638972973','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4579,'XYZ-1767592466789-21D5B3E8',5,NULL,'IN_STOCK','GRN','XYZ128238909','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4580,'XYZ-1767592466812-7FF210B3',5,NULL,'IN_STOCK','GRN','XYZ937166622','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4581,'XYZ-1767592466834-8074F1D6',5,NULL,'IN_STOCK','GRN','XYZ695564447','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4582,'XYZ-1767592466859-8A84AECD',5,NULL,'IN_STOCK','GRN','XYZ891933050','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4583,'XYZ-1767592466882-6BAA17CA',5,NULL,'IN_STOCK','GRN','XYZ158507406','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4584,'XYZ-1767592466903-3EFEC34F',5,NULL,'IN_STOCK','GRN','XYZ248977416','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4585,'XYZ-1767592466926-0D89A902',5,NULL,'IN_STOCK','GRN','XYZ723545751','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4586,'XYZ-1767592466949-502BDF40',5,NULL,'IN_STOCK','GRN','XYZ791699444','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4587,'XYZ-1767592466973-BC32FB70',5,NULL,'IN_STOCK','GRN','XYZ609834663','2026-01-05 05:54:26','2026-01-05 05:54:26'),(4588,'XYZ-1767592466996-A0ACA916',5,NULL,'IN_STOCK','GRN','XYZ778743215','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4589,'XYZ-1767592467018-6E3ECF76',5,NULL,'IN_STOCK','GRN','XYZ095096977','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4590,'XYZ-1767592467039-3325954A',5,NULL,'IN_STOCK','GRN','XYZ601487073','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4591,'XYZ-1767592467061-ABF23F6B',5,NULL,'IN_STOCK','GRN','XYZ197048509','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4592,'XYZ-1767592467084-9381A0C4',5,NULL,'IN_STOCK','GRN','XYZ026889047','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4593,'XYZ-1767592467109-8A7FFE7B',5,NULL,'IN_STOCK','GRN','XYZ927926522','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4594,'XYZ-1767592467132-3F086073',5,NULL,'IN_STOCK','GRN','XYZ881123309','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4595,'XYZ-1767592467154-5A3FAFC7',5,NULL,'IN_STOCK','GRN','XYZ466838298','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4596,'XYZ-1767592467179-5B8BDB50',5,NULL,'IN_STOCK','GRN','XYZ838328153','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4597,'XYZ-1767592467203-2FE9D833',5,NULL,'IN_STOCK','GRN','XYZ577207231','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4598,'XYZ-1767592467224-3F5193C1',5,NULL,'IN_STOCK','GRN','XYZ767570078','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4599,'XYZ-1767592467246-D615D88B',5,NULL,'IN_STOCK','GRN','XYZ459105984','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4600,'XYZ-1767592467271-6DD79FED',5,NULL,'IN_STOCK','GRN','XYZ819890186','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4601,'XYZ-1767592467296-9AF61E6B',5,NULL,'IN_STOCK','GRN','XYZ141527712','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4602,'XYZ-1767592467322-6CF8EDBD',5,NULL,'IN_STOCK','GRN','XYZ270358525','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4603,'XYZ-1767592467346-5F94E7D4',5,NULL,'IN_STOCK','GRN','XYZ344672348','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4604,'XYZ-1767592467369-ACA5CC90',5,NULL,'IN_STOCK','GRN','XYZ533810566','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4605,'XYZ-1767592467393-296C6506',5,NULL,'IN_STOCK','GRN','XYZ443442896','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4606,'XYZ-1767592467419-272E722B',5,NULL,'IN_STOCK','GRN','XYZ988234761','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4607,'XYZ-1767592467442-14E501D1',5,NULL,'IN_STOCK','GRN','XYZ180125551','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4608,'XYZ-1767592467463-F7C2246A',5,NULL,'IN_STOCK','GRN','XYZ441149906','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4609,'XYZ-1767592467484-F92396CC',5,NULL,'IN_STOCK','GRN','XYZ755561068','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4610,'XYZ-1767592467509-0430C6AE',5,NULL,'IN_STOCK','GRN','XYZ049548475','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4611,'XYZ-1767592467535-2202DAD0',5,NULL,'IN_STOCK','GRN','XYZ899716874','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4612,'XYZ-1767592467559-79BAAA69',5,NULL,'IN_STOCK','GRN','XYZ558024214','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4613,'XYZ-1767592467585-A69F42E4',5,NULL,'IN_STOCK','GRN','XYZ993433426','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4614,'XYZ-1767592467610-52324BB8',5,NULL,'IN_STOCK','GRN','XYZ532164808','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4615,'XYZ-1767592467633-5A7C276C',5,NULL,'IN_STOCK','GRN','XYZ047111806','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4616,'XYZ-1767592467655-DA0CDDC7',5,NULL,'IN_STOCK','GRN','XYZ482905030','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4617,'XYZ-1767592467675-E8A33070',5,NULL,'IN_STOCK','GRN','XYZ776174746','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4618,'XYZ-1767592467697-0D84D4C2',5,NULL,'IN_STOCK','GRN','XYZ402235014','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4619,'XYZ-1767592467722-FF63A298',5,NULL,'IN_STOCK','GRN','XYZ008074955','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4620,'XYZ-1767592467746-F3F01E13',5,NULL,'IN_STOCK','GRN','XYZ929615799','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4621,'XYZ-1767592467769-08E82112',5,NULL,'IN_STOCK','GRN','XYZ952355040','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4622,'XYZ-1767592467794-3699FFB3',5,NULL,'IN_STOCK','GRN','XYZ117666840','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4623,'XYZ-1767592467819-DD335017',5,NULL,'IN_STOCK','GRN','XYZ164618466','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4624,'XYZ-1767592467843-178E691D',5,NULL,'IN_STOCK','GRN','XYZ732326160','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4625,'XYZ-1767592467867-ECFAD741',5,NULL,'IN_STOCK','GRN','XYZ168598274','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4626,'XYZ-1767592467891-121B2D0C',5,NULL,'IN_STOCK','GRN','XYZ394251341','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4627,'XYZ-1767592467916-AABFA31B',5,NULL,'IN_STOCK','GRN','XYZ723109717','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4628,'XYZ-1767592467938-BE25ED6C',5,NULL,'IN_STOCK','GRN','XYZ563447869','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4629,'XYZ-1767592467961-71444300',5,NULL,'IN_STOCK','GRN','XYZ315415915','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4630,'XYZ-1767592467984-101B8286',5,NULL,'IN_STOCK','GRN','XYZ415787657','2026-01-05 05:54:27','2026-01-05 05:54:27'),(4631,'XYZ-1767592468008-043FE103',5,NULL,'IN_STOCK','GRN','XYZ901021106','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4632,'XYZ-1767592468030-95E46EFB',5,NULL,'IN_STOCK','GRN','XYZ871928134','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4633,'XYZ-1767592468053-C8C0D9C4',5,NULL,'IN_STOCK','GRN','XYZ484010846','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4634,'XYZ-1767592468074-F38F8E93',5,NULL,'IN_STOCK','GRN','XYZ310313811','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4635,'XYZ-1767592468096-3D805C2A',5,NULL,'IN_STOCK','GRN','XYZ848078957','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4636,'XYZ-1767592468118-6B976491',5,NULL,'IN_STOCK','GRN','XYZ449037658','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4637,'XYZ-1767592468143-4B7CAC22',5,NULL,'IN_STOCK','GRN','XYZ436781855','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4638,'XYZ-1767592468170-F99AB783',5,NULL,'IN_STOCK','GRN','XYZ752405627','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4639,'XYZ-1767592468194-7D559520',5,NULL,'IN_STOCK','GRN','XYZ202935053','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4640,'XYZ-1767592468215-B8745128',5,NULL,'IN_STOCK','GRN','XYZ441312374','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4641,'XYZ-1767592468237-C848613A',5,NULL,'IN_STOCK','GRN','XYZ730823513','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4642,'XYZ-1767592468257-4785D205',5,NULL,'IN_STOCK','GRN','XYZ270785278','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4643,'XYZ-1767592468278-ABEAEFBC',5,NULL,'IN_STOCK','GRN','XYZ025726076','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4644,'XYZ-1767592468299-4C09CA0D',5,NULL,'IN_STOCK','GRN','XYZ644953835','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4645,'XYZ-1767592468320-65332301',5,NULL,'IN_STOCK','GRN','XYZ414902304','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4646,'XYZ-1767592468344-419437D4',5,NULL,'IN_STOCK','GRN','XYZ730722243','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4647,'XYZ-1767592468365-A751DD03',5,NULL,'IN_STOCK','GRN','XYZ527539174','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4648,'XYZ-1767592468387-101F1025',5,NULL,'IN_STOCK','GRN','XYZ696704811','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4649,'XYZ-1767592468410-84D08F99',5,NULL,'IN_STOCK','GRN','XYZ651027748','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4650,'XYZ-1767592468433-BDAA6C49',5,NULL,'IN_STOCK','GRN','XYZ955136284','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4651,'XYZ-1767592468458-239422F4',5,NULL,'IN_STOCK','GRN','XYZ443725364','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4652,'XYZ-1767592468481-0B4BBF94',5,NULL,'IN_STOCK','GRN','XYZ877386736','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4653,'XYZ-1767592468503-1D82B9DA',5,NULL,'IN_STOCK','GRN','XYZ220128972','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4654,'XYZ-1767592468526-E07780CA',5,NULL,'IN_STOCK','GRN','XYZ103179307','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4655,'XYZ-1767592468547-8A9C851F',5,NULL,'IN_STOCK','GRN','XYZ000619546','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4656,'XYZ-1767592468571-0826EE80',5,NULL,'IN_STOCK','GRN','XYZ039295442','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4657,'XYZ-1767592468592-0586BFAA',5,NULL,'IN_STOCK','GRN','XYZ924337971','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4658,'XYZ-1767592468613-3777EB3B',5,NULL,'IN_STOCK','GRN','XYZ205814817','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4659,'XYZ-1767592468638-02AA1BDD',5,NULL,'IN_STOCK','GRN','XYZ801562915','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4660,'XYZ-1767592468663-6DDAF557',5,NULL,'IN_STOCK','GRN','XYZ758821038','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4661,'XYZ-1767592468687-A5BFAA35',5,NULL,'IN_STOCK','GRN','XYZ486720258','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4662,'XYZ-1767592468709-8E75B679',5,NULL,'IN_STOCK','GRN','XYZ173838921','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4663,'XYZ-1767592468731-77FA7BF8',5,NULL,'IN_STOCK','GRN','XYZ500490166','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4664,'XYZ-1767592468756-CCE7469A',5,NULL,'IN_STOCK','GRN','XYZ921397361','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4665,'XYZ-1767592468781-9A7B2B41',5,NULL,'IN_STOCK','GRN','XYZ744484762','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4666,'XYZ-1767592468805-4BD0A8BA',5,NULL,'IN_STOCK','GRN','XYZ834120929','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4667,'XYZ-1767592468827-41107B52',5,NULL,'IN_STOCK','GRN','XYZ025552919','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4668,'XYZ-1767592468850-D26E3A1F',5,NULL,'IN_STOCK','GRN','XYZ138526313','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4669,'XYZ-1767592468872-CB7AFBF4',5,NULL,'IN_STOCK','GRN','XYZ042325757','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4670,'XYZ-1767592468897-661A7221',5,NULL,'IN_STOCK','GRN','XYZ954407318','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4671,'XYZ-1767592468920-0D8392BC',5,NULL,'IN_STOCK','GRN','XYZ516271648','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4672,'XYZ-1767592468944-E02F487B',5,NULL,'IN_STOCK','GRN','XYZ600429047','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4673,'XYZ-1767592468965-62579548',5,NULL,'IN_STOCK','GRN','XYZ094481470','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4674,'XYZ-1767592468987-C8A94210',5,NULL,'IN_STOCK','GRN','XYZ830947081','2026-01-05 05:54:28','2026-01-05 05:54:28'),(4675,'XYZ-1767592469012-47E91BF8',5,NULL,'IN_STOCK','GRN','XYZ250477856','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4676,'XYZ-1767592469034-08695EB4',5,NULL,'IN_STOCK','GRN','XYZ336822481','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4677,'XYZ-1767592469058-C01F1219',5,NULL,'IN_STOCK','GRN','XYZ642732584','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4678,'XYZ-1767592469083-1249DBD5',5,NULL,'IN_STOCK','GRN','XYZ597058464','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4679,'XYZ-1767592469109-9237AD08',5,NULL,'IN_STOCK','GRN','XYZ787301535','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4680,'XYZ-1767592469132-EBB70954',5,NULL,'IN_STOCK','GRN','XYZ574552149','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4681,'XYZ-1767592469154-0A7AFAC3',5,NULL,'IN_STOCK','GRN','XYZ576147650','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4682,'XYZ-1767592469175-ACBCBBFB',5,NULL,'IN_STOCK','GRN','XYZ033970002','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4683,'XYZ-1767592469198-B1CE3FE1',5,NULL,'IN_STOCK','GRN','XYZ015900567','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4684,'XYZ-1767592469221-78963538',5,NULL,'IN_STOCK','GRN','XYZ008271105','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4685,'XYZ-1767592469246-D7E93E78',5,NULL,'IN_STOCK','GRN','XYZ378534722','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4686,'XYZ-1767592469270-51ADC38B',5,NULL,'IN_STOCK','GRN','XYZ602357980','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4687,'XYZ-1767592469292-44242AD1',5,NULL,'IN_STOCK','GRN','XYZ929679762','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4688,'XYZ-1767592469314-414C3321',5,NULL,'IN_STOCK','GRN','XYZ066582734','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4689,'XYZ-1767592469337-F99A83D4',5,NULL,'IN_STOCK','GRN','XYZ687875914','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4690,'XYZ-1767592469358-1D5F15DF',5,NULL,'IN_STOCK','GRN','XYZ580395246','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4691,'XYZ-1767592469381-D8222EAF',5,NULL,'IN_STOCK','GRN','XYZ229141010','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4692,'XYZ-1767592469405-0BAA065A',5,NULL,'IN_STOCK','GRN','XYZ241951176','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4693,'XYZ-1767592469431-D1AB3DD4',5,NULL,'IN_STOCK','GRN','XYZ206297302','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4694,'XYZ-1767592469453-E864E598',5,NULL,'IN_STOCK','GRN','XYZ621445844','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4695,'XYZ-1767592469476-8FC27EB1',5,NULL,'IN_STOCK','GRN','XYZ831272780','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4696,'XYZ-1767592469499-E5FC3619',5,NULL,'IN_STOCK','GRN','XYZ873145053','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4697,'XYZ-1767592469524-C3385D05',5,NULL,'IN_STOCK','GRN','XYZ851547577','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4698,'XYZ-1767592469548-35D6B57E',5,NULL,'IN_STOCK','GRN','XYZ114969146','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4699,'XYZ-1767592469573-779C9966',5,NULL,'IN_STOCK','GRN','XYZ491234746','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4700,'XYZ-1767592469601-408BBE3C',5,NULL,'IN_STOCK','GRN','XYZ077992612','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4701,'XYZ-1767592469631-B1D8B181',5,NULL,'IN_STOCK','GRN','XYZ831274477','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4702,'XYZ-1767592469655-BBAA5E39',5,NULL,'IN_STOCK','GRN','XYZ986307767','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4703,'XYZ-1767592469676-C98FF70A',5,NULL,'IN_STOCK','GRN','XYZ396456039','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4704,'XYZ-1767592469702-B4EAF611',5,NULL,'IN_STOCK','GRN','XYZ714265488','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4705,'XYZ-1767592469726-6E487D9E',5,NULL,'IN_STOCK','GRN','XYZ465503650','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4706,'XYZ-1767592469751-5D9C3F8D',5,NULL,'IN_STOCK','GRN','XYZ595499914','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4707,'XYZ-1767592469774-461DD43E',5,NULL,'IN_STOCK','GRN','XYZ734251777','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4708,'XYZ-1767592469799-ED781A4E',5,NULL,'IN_STOCK','GRN','XYZ122439532','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4709,'XYZ-1767592469825-E9A1FF69',5,NULL,'IN_STOCK','GRN','XYZ463192083','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4710,'XYZ-1767592469850-E23B00CB',5,NULL,'IN_STOCK','GRN','XYZ017396620','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4711,'XYZ-1767592469875-23FBE919',5,NULL,'IN_STOCK','GRN','XYZ039000687','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4712,'XYZ-1767592469901-36134A21',5,NULL,'IN_STOCK','GRN','XYZ804167241','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4713,'XYZ-1767592469927-F06A47C2',5,NULL,'IN_STOCK','GRN','XYZ017651051','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4714,'XYZ-1767592469953-BA2FDF89',5,NULL,'IN_STOCK','GRN','XYZ706074653','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4715,'XYZ-1767592469980-8A22CDED',5,NULL,'IN_STOCK','GRN','XYZ066167787','2026-01-05 05:54:29','2026-01-05 05:54:29'),(4716,'XYZ-1767592470002-B12AC42E',5,NULL,'IN_STOCK','GRN','XYZ415396071','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4717,'XYZ-1767592470027-6D201F17',5,NULL,'IN_STOCK','GRN','XYZ470659614','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4718,'XYZ-1767592470049-197A4082',5,NULL,'IN_STOCK','GRN','XYZ650727117','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4719,'XYZ-1767592470073-7A2AE695',5,NULL,'IN_STOCK','GRN','XYZ236029611','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4720,'XYZ-1767592470099-F3E9630A',5,NULL,'IN_STOCK','GRN','XYZ256557089','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4721,'XYZ-1767592470123-833C23AA',5,NULL,'IN_STOCK','GRN','XYZ056495839','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4722,'XYZ-1767592470150-F4F0A7CB',5,NULL,'IN_STOCK','GRN','XYZ758893913','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4723,'XYZ-1767592470177-32FC160A',5,NULL,'IN_STOCK','GRN','XYZ674110219','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4724,'XYZ-1767592470200-C9A2604A',5,NULL,'IN_STOCK','GRN','XYZ835105506','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4725,'XYZ-1767592470228-CD154DC3',5,NULL,'IN_STOCK','GRN','XYZ967166371','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4726,'XYZ-1767592470254-63016810',5,NULL,'IN_STOCK','GRN','XYZ866751074','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4727,'XYZ-1767592470280-B0C87327',5,NULL,'IN_STOCK','GRN','XYZ872969026','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4728,'XYZ-1767592470303-EFD6EA59',5,NULL,'IN_STOCK','GRN','XYZ398313451','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4729,'XYZ-1767592470328-AA0224BD',5,NULL,'IN_STOCK','GRN','XYZ845733569','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4730,'XYZ-1767592470353-F0304794',5,NULL,'IN_STOCK','GRN','XYZ399813158','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4731,'XYZ-1767592470379-566AC083',5,NULL,'IN_STOCK','GRN','XYZ763427912','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4732,'XYZ-1767592470404-DC312DBA',5,NULL,'IN_STOCK','GRN','XYZ521519676','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4733,'XYZ-1767592470427-ABAD48D5',5,NULL,'IN_STOCK','GRN','XYZ321550378','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4734,'XYZ-1767592470451-D6E96C46',5,NULL,'IN_STOCK','GRN','XYZ560515206','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4735,'XYZ-1767592470474-56C7DF45',5,NULL,'IN_STOCK','GRN','XYZ773230683','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4736,'XYZ-1767592470499-C13981C4',5,NULL,'IN_STOCK','GRN','XYZ776076262','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4737,'XYZ-1767592470525-70742A35',5,NULL,'IN_STOCK','GRN','XYZ201406978','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4738,'XYZ-1767592470552-BA86EA9B',5,NULL,'IN_STOCK','GRN','XYZ008144970','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4739,'XYZ-1767592470577-D2F08619',5,NULL,'IN_STOCK','GRN','XYZ135403642','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4740,'XYZ-1767592470601-FB615450',5,NULL,'IN_STOCK','GRN','XYZ556549630','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4741,'XYZ-1767592470627-239ECC63',5,NULL,'IN_STOCK','GRN','XYZ265745867','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4742,'XYZ-1767592470652-85503316',5,NULL,'IN_STOCK','GRN','XYZ796168685','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4743,'XYZ-1767592470677-C4D44842',5,NULL,'IN_STOCK','GRN','XYZ168182092','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4744,'XYZ-1767592470702-C40E5379',5,NULL,'IN_STOCK','GRN','XYZ453477451','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4745,'XYZ-1767592470729-A4FB6861',5,NULL,'IN_STOCK','GRN','XYZ622945279','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4746,'XYZ-1767592470755-7F9D4B1D',5,NULL,'IN_STOCK','GRN','XYZ025106540','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4747,'XYZ-1767592470779-0FFC47CE',5,NULL,'IN_STOCK','GRN','XYZ537004597','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4748,'XYZ-1767592470803-CA24DE7F',5,NULL,'IN_STOCK','GRN','XYZ864283957','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4749,'XYZ-1767592470828-FD76BA34',5,NULL,'IN_STOCK','GRN','XYZ522881128','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4750,'XYZ-1767592470850-A53B1CBB',5,NULL,'IN_STOCK','GRN','XYZ906940304','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4751,'XYZ-1767592470870-6C239B5C',5,NULL,'IN_STOCK','GRN','XYZ270458002','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4752,'XYZ-1767592470890-618CF1CE',5,NULL,'IN_STOCK','GRN','XYZ806350325','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4753,'XYZ-1767592470910-A1A03AE1',5,NULL,'IN_STOCK','GRN','XYZ966801608','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4754,'XYZ-1767592470936-6771B932',5,NULL,'IN_STOCK','GRN','XYZ649365976','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4755,'XYZ-1767592470961-965FBD36',5,NULL,'IN_STOCK','GRN','XYZ478321215','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4756,'XYZ-1767592470986-F3448A8D',5,NULL,'IN_STOCK','GRN','XYZ521755617','2026-01-05 05:54:30','2026-01-05 05:54:30'),(4757,'XYZ-1767592471011-29670FF7',5,NULL,'IN_STOCK','GRN','XYZ015258906','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4758,'XYZ-1767592471036-D1EDC569',5,NULL,'IN_STOCK','GRN','XYZ778813392','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4759,'XYZ-1767592471061-30F764BF',5,NULL,'IN_STOCK','GRN','XYZ669553093','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4760,'XYZ-1767592471083-B817BD80',5,NULL,'IN_STOCK','GRN','XYZ081362184','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4761,'XYZ-1767592471109-B2273384',5,NULL,'IN_STOCK','GRN','XYZ813467435','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4762,'XYZ-1767592471133-BAB4E6C9',5,NULL,'IN_STOCK','GRN','XYZ683167149','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4763,'XYZ-1767592471160-78E8A97D',5,NULL,'IN_STOCK','GRN','XYZ111864255','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4764,'XYZ-1767592471185-312A75EC',5,NULL,'IN_STOCK','GRN','XYZ072383955','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4765,'XYZ-1767592471209-F4C001BC',5,NULL,'IN_STOCK','GRN','XYZ850200276','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4766,'XYZ-1767592471231-80417EF0',5,NULL,'IN_STOCK','GRN','XYZ363627742','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4767,'XYZ-1767592471252-81EDB29F',5,NULL,'IN_STOCK','GRN','XYZ613336455','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4768,'XYZ-1767592471273-3A0F99AD',5,NULL,'IN_STOCK','GRN','XYZ665367891','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4769,'XYZ-1767592471295-2D489CE8',5,NULL,'IN_STOCK','GRN','XYZ044364361','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4770,'XYZ-1767592471325-566A85D8',5,NULL,'IN_STOCK','GRN','XYZ551101109','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4771,'XYZ-1767592471356-A7E421A9',5,NULL,'IN_STOCK','GRN','XYZ341620900','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4772,'XYZ-1767592471380-3C89AA20',5,NULL,'IN_STOCK','GRN','XYZ286369153','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4773,'XYZ-1767592471408-D46CD322',5,NULL,'IN_STOCK','GRN','XYZ785849432','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4774,'XYZ-1767592471435-1E1B35DF',5,NULL,'IN_STOCK','GRN','XYZ574774155','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4775,'XYZ-1767592471460-9A5B5D1D',5,NULL,'IN_STOCK','GRN','XYZ216401985','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4776,'XYZ-1767592471485-CFD0F0BE',5,NULL,'IN_STOCK','GRN','XYZ365765807','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4777,'XYZ-1767592471512-C8AFD834',5,NULL,'IN_STOCK','GRN','XYZ320857312','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4778,'XYZ-1767592471540-BDE827AC',5,NULL,'IN_STOCK','GRN','XYZ133769414','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4779,'XYZ-1767592471566-4D12E522',5,NULL,'IN_STOCK','GRN','XYZ530460234','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4780,'XYZ-1767592471591-E1BB30C7',5,NULL,'IN_STOCK','GRN','XYZ634007695','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4781,'XYZ-1767592471618-9C23421B',5,NULL,'IN_STOCK','GRN','XYZ622844306','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4782,'XYZ-1767592471646-2BFEB2B0',5,NULL,'IN_STOCK','GRN','XYZ638944342','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4783,'XYZ-1767592471671-375E8038',5,NULL,'IN_STOCK','GRN','XYZ978682133','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4784,'XYZ-1767592471694-08BF7003',5,NULL,'IN_STOCK','GRN','XYZ147323547','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4785,'XYZ-1767592471715-99075090',5,NULL,'IN_STOCK','GRN','XYZ662218745','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4786,'XYZ-1767592471740-0CF9C644',5,NULL,'IN_STOCK','GRN','XYZ606381188','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4787,'XYZ-1767592471764-5FF58104',5,NULL,'IN_STOCK','GRN','XYZ329309749','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4788,'XYZ-1767592471798-F493326A',5,NULL,'IN_STOCK','GRN','XYZ149683822','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4789,'XYZ-1767592471830-A1F9BCBC',5,NULL,'IN_STOCK','GRN','XYZ327464715','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4790,'XYZ-1767592471862-60C56625',5,NULL,'IN_STOCK','GRN','XYZ905636021','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4791,'XYZ-1767592471904-D7F6AF15',5,NULL,'IN_STOCK','GRN','XYZ873652031','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4792,'XYZ-1767592471935-92B6E50B',5,NULL,'IN_STOCK','GRN','XYZ223641872','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4793,'XYZ-1767592471965-6D9F5CA8',5,NULL,'IN_STOCK','GRN','XYZ572904521','2026-01-05 05:54:31','2026-01-05 05:54:31'),(4794,'XYZ-1767592471995-A9A8C4AE',5,NULL,'IN_STOCK','GRN','XYZ862839992','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4795,'XYZ-1767592472025-02FD949B',5,NULL,'IN_STOCK','GRN','XYZ345227251','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4796,'XYZ-1767592472057-95DD1E51',5,NULL,'IN_STOCK','GRN','XYZ038177675','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4797,'XYZ-1767592472086-7BC6E3BB',5,NULL,'IN_STOCK','GRN','XYZ196384118','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4798,'XYZ-1767592472116-E9029B33',5,NULL,'IN_STOCK','GRN','XYZ944215987','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4799,'XYZ-1767592472144-6D778241',5,NULL,'IN_STOCK','GRN','XYZ985914140','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4800,'XYZ-1767592472175-F1B66F78',5,NULL,'IN_STOCK','GRN','XYZ524254744','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4801,'XYZ-1767592472207-57E7662B',5,NULL,'IN_STOCK','GRN','XYZ880097819','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4802,'XYZ-1767592472240-F53F11AE',5,NULL,'IN_STOCK','GRN','XYZ962597795','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4803,'XYZ-1767592472269-4EFD71F0',5,NULL,'IN_STOCK','GRN','XYZ804568988','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4804,'XYZ-1767592472301-C0B063A5',5,NULL,'IN_STOCK','GRN','XYZ625896049','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4805,'XYZ-1767592472332-7A4BA495',5,NULL,'IN_STOCK','GRN','XYZ525814642','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4806,'XYZ-1767592472361-1EB030C5',5,NULL,'IN_STOCK','GRN','XYZ558530051','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4807,'XYZ-1767592472393-C6824D1D',5,NULL,'IN_STOCK','GRN','XYZ436848450','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4808,'XYZ-1767592472427-A9C9F686',5,NULL,'IN_STOCK','GRN','XYZ510213898','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4809,'XYZ-1767592472457-4346D30C',5,NULL,'IN_STOCK','GRN','XYZ941315187','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4810,'XYZ-1767592472486-38E2A1D8',5,NULL,'IN_STOCK','GRN','XYZ794180956','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4811,'XYZ-1767592472513-3F1A1471',5,NULL,'IN_STOCK','GRN','XYZ302804048','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4812,'XYZ-1767592472540-85CFF870',5,NULL,'IN_STOCK','GRN','XYZ540204888','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4813,'XYZ-1767592472568-4060D4B6',5,NULL,'IN_STOCK','GRN','XYZ987559465','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4814,'XYZ-1767592472596-AC53A124',5,NULL,'IN_STOCK','GRN','XYZ628076891','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4815,'XYZ-1767592472622-BF7C0031',5,NULL,'IN_STOCK','GRN','XYZ769273709','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4816,'XYZ-1767592472648-71A4E2C8',5,NULL,'IN_STOCK','GRN','XYZ237253791','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4817,'XYZ-1767592472675-E4267966',5,NULL,'IN_STOCK','GRN','XYZ877713933','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4818,'XYZ-1767592472700-2AC3D1E4',5,NULL,'IN_STOCK','GRN','XYZ730180549','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4819,'XYZ-1767592472725-D669202E',5,NULL,'IN_STOCK','GRN','XYZ179095443','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4820,'XYZ-1767592472750-DC1D2CFC',5,NULL,'IN_STOCK','GRN','XYZ966117188','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4821,'XYZ-1767592472775-52901776',5,NULL,'IN_STOCK','GRN','XYZ835859186','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4822,'XYZ-1767592472800-EF8F0779',5,NULL,'IN_STOCK','GRN','XYZ938597419','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4823,'XYZ-1767592472825-3BE1AAED',5,NULL,'IN_STOCK','GRN','XYZ675879065','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4824,'XYZ-1767592472853-03C749AB',5,NULL,'IN_STOCK','GRN','XYZ114073783','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4825,'XYZ-1767592472879-ED8743D2',5,NULL,'IN_STOCK','GRN','XYZ509507083','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4826,'XYZ-1767592472902-AD1A2593',5,NULL,'IN_STOCK','GRN','XYZ209924300','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4827,'XYZ-1767592472923-91BDB7EB',5,NULL,'IN_STOCK','GRN','XYZ046938745','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4828,'XYZ-1767592472944-9429AD70',5,NULL,'IN_STOCK','GRN','XYZ912160612','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4829,'XYZ-1767592472965-A5EF0CBD',5,NULL,'IN_STOCK','GRN','XYZ938716302','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4830,'XYZ-1767592472986-E952A524',5,NULL,'IN_STOCK','GRN','XYZ310493628','2026-01-05 05:54:32','2026-01-05 05:54:32'),(4831,'XYZ-1767592473007-891650D9',5,NULL,'IN_STOCK','GRN','XYZ486055941','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4832,'XYZ-1767592473028-939472B6',5,NULL,'IN_STOCK','GRN','XYZ991286850','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4833,'XYZ-1767592473049-9C4D7867',5,NULL,'IN_STOCK','GRN','XYZ562617906','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4834,'XYZ-1767592473070-5D094B69',5,NULL,'IN_STOCK','GRN','XYZ885783977','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4835,'XYZ-1767592473091-4DCF4661',5,NULL,'IN_STOCK','GRN','XYZ147591750','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4836,'XYZ-1767592473112-BD93AA53',5,NULL,'IN_STOCK','GRN','XYZ172889103','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4837,'XYZ-1767592473136-208991B9',5,NULL,'IN_STOCK','GRN','XYZ761773442','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4838,'XYZ-1767592473161-5A430D0F',5,NULL,'IN_STOCK','GRN','XYZ790834324','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4839,'XYZ-1767592473186-9CAB44F0',5,NULL,'IN_STOCK','GRN','XYZ373655717','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4840,'XYZ-1767592473211-39166FAE',5,NULL,'IN_STOCK','GRN','XYZ990755606','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4841,'XYZ-1767592473234-26BAFCDF',5,NULL,'IN_STOCK','GRN','XYZ041713316','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4842,'XYZ-1767592473255-4DBF591C',5,NULL,'IN_STOCK','GRN','XYZ568735170','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4843,'XYZ-1767592473277-780EF744',5,NULL,'IN_STOCK','GRN','XYZ737692136','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4844,'XYZ-1767592473302-8A33E280',5,NULL,'IN_STOCK','GRN','XYZ594868148','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4845,'XYZ-1767592473328-C7C3217C',5,NULL,'IN_STOCK','GRN','XYZ041232011','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4846,'XYZ-1767592473354-99E8C02E',5,NULL,'IN_STOCK','GRN','XYZ528300891','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4847,'XYZ-1767592473379-B33D024B',5,NULL,'IN_STOCK','GRN','XYZ064672662','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4848,'XYZ-1767592473404-356D7468',5,NULL,'IN_STOCK','GRN','XYZ601753598','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4849,'XYZ-1767592473427-0EBC1936',5,NULL,'IN_STOCK','GRN','XYZ639938612','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4850,'XYZ-1767592473452-10511C50',5,NULL,'IN_STOCK','GRN','XYZ527067988','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4851,'XYZ-1767592473472-877AAC09',5,NULL,'IN_STOCK','GRN','XYZ537158331','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4852,'XYZ-1767592473493-E57CADD8',5,NULL,'IN_STOCK','GRN','XYZ359434643','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4853,'XYZ-1767592473514-4993B577',5,NULL,'IN_STOCK','GRN','XYZ230891815','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4854,'XYZ-1767592473538-54DBEFF8',5,NULL,'IN_STOCK','GRN','XYZ334862851','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4855,'XYZ-1767592473559-903814AA',5,NULL,'IN_STOCK','GRN','XYZ502112380','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4856,'XYZ-1767592473580-739B22C3',5,NULL,'IN_STOCK','GRN','XYZ413186638','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4857,'XYZ-1767592473601-E8595C10',5,NULL,'IN_STOCK','GRN','XYZ937372806','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4858,'XYZ-1767592473626-02484449',5,NULL,'IN_STOCK','GRN','XYZ753135118','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4859,'XYZ-1767592473649-9DBB2219',5,NULL,'IN_STOCK','GRN','XYZ052566544','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4860,'XYZ-1767592473674-4E827449',5,NULL,'IN_STOCK','GRN','XYZ863311298','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4861,'XYZ-1767592473695-3B751D0D',5,NULL,'IN_STOCK','GRN','XYZ834275606','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4862,'XYZ-1767592473719-75E71ECE',5,NULL,'IN_STOCK','GRN','XYZ737975323','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4863,'XYZ-1767592473740-F754797A',5,NULL,'IN_STOCK','GRN','XYZ018021396','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4864,'XYZ-1767592473762-8D63D90F',5,NULL,'IN_STOCK','GRN','XYZ572046537','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4865,'XYZ-1767592473786-785495D3',5,NULL,'IN_STOCK','GRN','XYZ887889559','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4866,'XYZ-1767592473810-D22E4EFB',5,NULL,'IN_STOCK','GRN','XYZ528463955','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4867,'XYZ-1767592473831-67E284E2',5,NULL,'IN_STOCK','GRN','XYZ594083068','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4868,'XYZ-1767592473852-E147209F',5,NULL,'IN_STOCK','GRN','XYZ909596796','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4869,'XYZ-1767592473873-9D577A1F',5,NULL,'IN_STOCK','GRN','XYZ079327868','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4870,'XYZ-1767592473894-2DD09D2A',5,NULL,'IN_STOCK','GRN','XYZ253814069','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4871,'XYZ-1767592473921-8AE3F19B',5,NULL,'IN_STOCK','GRN','XYZ981901846','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4872,'XYZ-1767592473946-33230F2B',5,NULL,'IN_STOCK','GRN','XYZ806810791','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4873,'XYZ-1767592473969-ED7AB2E1',5,NULL,'IN_STOCK','GRN','XYZ529620015','2026-01-05 05:54:33','2026-01-05 05:54:33'),(4874,'XYZ-1767592473993-4BD2AFBA',5,NULL,'IN_STOCK','GRN','XYZ617418150','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4875,'XYZ-1767592474013-5BF5D454',5,NULL,'IN_STOCK','GRN','XYZ591962761','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4876,'XYZ-1767592474034-6BDACE44',5,NULL,'IN_STOCK','GRN','XYZ670060710','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4877,'XYZ-1767592474056-DC1C1F6D',5,NULL,'IN_STOCK','GRN','XYZ881234868','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4878,'XYZ-1767592474078-CBCE9B86',5,NULL,'IN_STOCK','GRN','XYZ538041801','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4879,'XYZ-1767592474098-1798B58E',5,NULL,'IN_STOCK','GRN','XYZ550951706','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4880,'XYZ-1767592474120-5674FC10',5,NULL,'IN_STOCK','GRN','XYZ755368138','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4881,'XYZ-1767592474141-DF6251C4',5,NULL,'IN_STOCK','GRN','XYZ200000956','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4882,'XYZ-1767592474163-602145F4',5,NULL,'IN_STOCK','GRN','XYZ266208852','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4883,'XYZ-1767592474185-42600332',5,NULL,'IN_STOCK','GRN','XYZ428056252','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4884,'XYZ-1767592474206-DE0C6DF0',5,NULL,'IN_STOCK','GRN','XYZ444082181','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4885,'XYZ-1767592474227-038A03B2',5,NULL,'IN_STOCK','GRN','XYZ434496933','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4886,'XYZ-1767592474248-BAC87468',5,NULL,'IN_STOCK','GRN','XYZ808730103','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4887,'XYZ-1767592474269-C8F3B603',5,NULL,'IN_STOCK','GRN','XYZ410514805','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4888,'XYZ-1767592474290-F81E6242',5,NULL,'IN_STOCK','GRN','XYZ480500920','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4889,'XYZ-1767592474311-2B4B0145',5,NULL,'IN_STOCK','GRN','XYZ527123043','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4890,'XYZ-1767592474332-54A32590',5,NULL,'IN_STOCK','GRN','XYZ469329061','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4891,'XYZ-1767592474357-66184969',5,NULL,'IN_STOCK','GRN','XYZ009538052','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4892,'XYZ-1767592474379-2D21B10E',5,NULL,'IN_STOCK','GRN','XYZ236896547','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4893,'XYZ-1767592474401-F7686599',5,NULL,'IN_STOCK','GRN','XYZ965231750','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4894,'XYZ-1767592474424-8E38BC0F',5,NULL,'IN_STOCK','GRN','XYZ706148564','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4895,'XYZ-1767592474448-6493F8E4',5,NULL,'IN_STOCK','GRN','XYZ273998978','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4896,'XYZ-1767592474472-36A23AAE',5,NULL,'IN_STOCK','GRN','XYZ075808034','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4897,'XYZ-1767592474499-2939B025',5,NULL,'IN_STOCK','GRN','XYZ680287239','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4898,'XYZ-1767592474524-E807CA94',5,NULL,'IN_STOCK','GRN','XYZ382225735','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4899,'XYZ-1767592474546-2966954C',5,NULL,'IN_STOCK','GRN','XYZ459496108','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4900,'XYZ-1767592474567-A3105993',5,NULL,'IN_STOCK','GRN','XYZ519105263','2026-01-05 05:54:34','2026-01-05 05:54:34'),(4901,'XYZ-1767594104191-5F425183',5,NULL,'IN_STOCK','GRN','XYZ229737773','2026-01-05 06:21:44','2026-01-05 06:21:44'),(4902,'XYZ-1767594104246-B35AC22C',5,NULL,'IN_STOCK','GRN','XYZ258764228','2026-01-05 06:21:44','2026-01-05 06:21:44'),(4903,'XYZ-1767594104281-1532D7E9',5,NULL,'IN_STOCK','GRN','XYZ567282189','2026-01-05 06:21:44','2026-01-05 06:21:44'),(4904,'XYZ-1767594104311-8C8A76AD',5,NULL,'IN_STOCK','GRN','XYZ465143637','2026-01-05 06:21:44','2026-01-05 06:21:44'),(4905,'XYZ-1767594104346-ED9C796B',5,NULL,'IN_STOCK','GRN','XYZ362164107','2026-01-05 06:21:44','2026-01-05 06:21:44'),(4906,'XYZ-1767594104378-52C9ABEE',5,NULL,'IN_STOCK','GRN','XYZ069695499','2026-01-05 06:21:44','2026-01-05 06:21:44'),(4907,'XYZ-1767594104410-4AA4D45A',5,NULL,'IN_STOCK','GRN','XYZ528876398','2026-01-05 06:21:44','2026-01-05 06:21:44'),(4908,'XYZ-1767594104439-8E1594B3',5,NULL,'IN_STOCK','GRN','XYZ036337330','2026-01-05 06:21:44','2026-01-05 06:21:44'),(4909,'XYZ-1767594104471-D7C7517E',5,NULL,'IN_STOCK','GRN','XYZ257096387','2026-01-05 06:21:44','2026-01-05 06:21:44'),(4910,'XYZ-1767594104499-C92C8282',5,NULL,'IN_STOCK','GRN','XYZ151336840','2026-01-05 06:21:44','2026-01-05 06:21:44'),(4911,'XYZ-1767677045992-EF4654CB',5,NULL,'IN_STOCK','GRN','XYZ214910784','2026-01-06 05:24:06','2026-01-06 05:24:06'),(4912,'XYZ-1767677046047-A9DCDC64',5,NULL,'IN_STOCK','GRN','XYZ016108318','2026-01-06 05:24:06','2026-01-06 05:24:06'),(4913,'XYZ-1767851138091-2A89B961',11,NULL,'IN_STOCK','GRN','XYZ983626325','2026-01-08 05:45:38','2026-01-08 05:45:38'),(4914,'XYZ-1767851138160-54C367CF',11,NULL,'IN_STOCK','GRN','XYZ956300527','2026-01-08 05:45:38','2026-01-08 05:45:38'),(4915,'XYZ-1767851138189-AB2F5077',11,NULL,'IN_STOCK','GRN','XYZ057329178','2026-01-08 05:45:38','2026-01-08 05:45:38'),(4916,'XYZ-1767851138222-26112805',11,NULL,'IN_STOCK','GRN','XYZ972766043','2026-01-08 05:45:38','2026-01-08 05:45:38'),(4917,'XYZ-1767851138259-BAF0E20F',11,NULL,'IN_STOCK','GRN','XYZ071957814','2026-01-08 05:45:38','2026-01-08 05:45:38'),(4918,'XYZ-1767851138298-1D627972',11,NULL,'IN_STOCK','GRN','XYZ823504951','2026-01-08 05:45:38','2026-01-08 05:45:38'),(4919,'XYZ-1767851138329-B7645C55',11,NULL,'IN_STOCK','GRN','XYZ605042380','2026-01-08 05:45:38','2026-01-08 05:45:38'),(4920,'XYZ-1767851138360-7BBE3A8B',11,NULL,'IN_STOCK','GRN','XYZ081848426','2026-01-08 05:45:38','2026-01-08 05:45:38'),(4921,'XYZ-1767851138390-078DB95B',11,NULL,'IN_STOCK','GRN','XYZ823953552','2026-01-08 05:45:38','2026-01-08 05:45:38'),(4922,'XYZ-1767851138421-D0465546',11,NULL,'IN_STOCK','GRN','XYZ482816784','2026-01-08 05:45:38','2026-01-08 05:45:38'),(4923,'XYZ-1767873094429-369179D2',3,NULL,'SOLD','GRN','XYZ267250997','2026-01-08 11:51:34','2026-01-10 14:58:22'),(4924,'XYZ-1767873094501-9A74BFEC',3,NULL,'SOLD','GRN','XYZ002044863','2026-01-08 11:51:34','2026-01-10 16:00:46'),(4925,'XYZ-1767873094536-DD04D719',3,NULL,'IN_STOCK','GRN','XYZ282482868','2026-01-08 11:51:34','2026-01-08 11:51:34'),(4926,'XYZ-1767873094572-910DFABE',3,NULL,'IN_STOCK','GRN','XYZ116538683','2026-01-08 11:51:34','2026-01-08 11:51:34'),(4927,'XYZ-1767873094605-0E21A67E',3,NULL,'IN_STOCK','GRN','XYZ584115833','2026-01-08 11:51:34','2026-01-08 11:51:34'),(4928,'XYZ-1767873094638-92DCD2AD',3,NULL,'IN_STOCK','GRN','XYZ895182183','2026-01-08 11:51:34','2026-01-08 11:51:34'),(4929,'XYZ-1767873094670-92D15684',3,NULL,'IN_STOCK','GRN','XYZ209398182','2026-01-08 11:51:34','2026-01-08 11:51:34'),(4930,'XYZ-1767873094702-E28A1394',3,NULL,'IN_STOCK','GRN','XYZ726194669','2026-01-08 11:51:34','2026-01-08 11:51:34'),(4931,'XYZ-1767873094733-7E032A0A',3,NULL,'IN_STOCK','GRN','XYZ303264350','2026-01-08 11:51:34','2026-01-08 11:51:34'),(4932,'XYZ-1767873094760-A01572AA',3,NULL,'IN_STOCK','GRN','XYZ434468699','2026-01-08 11:51:34','2026-01-08 11:51:34'),(4933,'XYZ-1767873094790-A8596159',3,NULL,'IN_STOCK','GRN','XYZ001649515','2026-01-08 11:51:34','2026-01-08 11:51:34'),(4934,'XYZ-1767873094822-09844460',3,NULL,'IN_STOCK','GRN','XYZ413079861','2026-01-08 11:51:34','2026-01-08 11:51:34'),(4935,'XYZ-1767873094856-1AC6F1C3',3,NULL,'IN_STOCK','GRN','XYZ360354329','2026-01-08 11:51:34','2026-01-08 11:51:34'),(4936,'XYZ-1767873094889-DEDC621B',3,NULL,'IN_STOCK','GRN','XYZ314547705','2026-01-08 11:51:34','2026-01-08 11:51:34'),(4937,'XYZ-1767873094924-9B0C9C87',3,NULL,'IN_STOCK','GRN','XYZ868151643','2026-01-08 11:51:34','2026-01-08 11:51:34'),(4938,'XYZ-1767873094958-BCECE161',3,NULL,'IN_STOCK','GRN','XYZ411664474','2026-01-08 11:51:34','2026-01-08 11:51:34'),(4939,'XYZ-1767873094991-61299012',3,NULL,'IN_STOCK','GRN','XYZ629069696','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4940,'XYZ-1767873095025-80C0E66D',3,NULL,'IN_STOCK','GRN','XYZ636130621','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4941,'XYZ-1767873095060-18BB8C5C',3,NULL,'IN_STOCK','GRN','XYZ677818737','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4942,'XYZ-1767873095094-0D621E69',3,NULL,'IN_STOCK','GRN','XYZ255297816','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4943,'XYZ-1767873095126-DA6816FC',3,NULL,'IN_STOCK','GRN','XYZ570805131','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4944,'XYZ-1767873095156-9F730609',3,NULL,'IN_STOCK','GRN','XYZ343416752','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4945,'XYZ-1767873095183-B0F12EAA',3,NULL,'IN_STOCK','GRN','XYZ539481557','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4946,'XYZ-1767873095216-B2C9514F',3,NULL,'IN_STOCK','GRN','XYZ205856551','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4947,'XYZ-1767873095248-253A403C',3,NULL,'IN_STOCK','GRN','XYZ533833052','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4948,'XYZ-1767873095281-35FD4C15',3,NULL,'IN_STOCK','GRN','XYZ710171227','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4949,'XYZ-1767873095312-7EE56E50',3,NULL,'IN_STOCK','GRN','XYZ137502684','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4950,'XYZ-1767873095343-F9BC51A2',3,NULL,'IN_STOCK','GRN','XYZ507194172','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4951,'XYZ-1767873095373-DE7BC4EC',3,NULL,'IN_STOCK','GRN','XYZ377583713','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4952,'XYZ-1767873095404-13F41585',3,NULL,'IN_STOCK','GRN','XYZ247168644','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4953,'XYZ-1767873095432-8C6BF5EE',3,NULL,'IN_STOCK','GRN','XYZ535423498','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4954,'XYZ-1767873095469-00A4AF33',3,NULL,'IN_STOCK','GRN','XYZ426963431','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4955,'XYZ-1767873095500-65CBA820',3,NULL,'IN_STOCK','GRN','XYZ820719863','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4956,'XYZ-1767873095530-6A616E7E',3,NULL,'IN_STOCK','GRN','XYZ452933883','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4957,'XYZ-1767873095561-1B4D582D',3,NULL,'IN_STOCK','GRN','XYZ779039669','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4958,'XYZ-1767873095592-B3369EC6',3,NULL,'IN_STOCK','GRN','XYZ094714841','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4959,'XYZ-1767873095626-5D8E4D7D',3,NULL,'IN_STOCK','GRN','XYZ911885882','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4960,'XYZ-1767873095660-83E55F2A',3,NULL,'IN_STOCK','GRN','XYZ606560637','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4961,'XYZ-1767873095693-4A999006',3,NULL,'IN_STOCK','GRN','XYZ462814333','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4962,'XYZ-1767873095725-58ABB788',3,NULL,'IN_STOCK','GRN','XYZ343112317','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4963,'XYZ-1767873095756-B2DDFF2D',3,NULL,'IN_STOCK','GRN','XYZ246821179','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4964,'XYZ-1767873095783-B118B0ED',3,NULL,'IN_STOCK','GRN','XYZ108292752','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4965,'XYZ-1767873095813-E0C9DA18',3,NULL,'IN_STOCK','GRN','XYZ661569422','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4966,'XYZ-1767873095845-E4C41CFD',3,NULL,'IN_STOCK','GRN','XYZ675161494','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4967,'XYZ-1767873095877-EEA21DAA',3,NULL,'IN_STOCK','GRN','XYZ436102320','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4968,'XYZ-1767873095911-22BE8E4B',3,NULL,'IN_STOCK','GRN','XYZ521218570','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4969,'XYZ-1767873095941-024BB835',3,NULL,'IN_STOCK','GRN','XYZ805530088','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4970,'XYZ-1767873095972-E2ABA5E3',3,NULL,'IN_STOCK','GRN','XYZ477843665','2026-01-08 11:51:35','2026-01-08 11:51:35'),(4971,'XYZ-1767873096002-5673AF16',3,NULL,'IN_STOCK','GRN','XYZ005858148','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4972,'XYZ-1767873096031-D0DDB9C1',3,NULL,'IN_STOCK','GRN','XYZ397498741','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4973,'XYZ-1767873096061-6E75B9F3',3,NULL,'IN_STOCK','GRN','XYZ630692335','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4974,'XYZ-1767873096091-98F0BF5E',3,NULL,'IN_STOCK','GRN','XYZ319331238','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4975,'XYZ-1767873096121-C0ECF207',3,NULL,'IN_STOCK','GRN','XYZ631706990','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4976,'XYZ-1767873096150-D595F0DD',3,NULL,'IN_STOCK','GRN','XYZ195658774','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4977,'XYZ-1767873096174-01CAE460',3,NULL,'IN_STOCK','GRN','XYZ503858575','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4978,'XYZ-1767873096203-2C0020C2',3,NULL,'IN_STOCK','GRN','XYZ259800546','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4979,'XYZ-1767873096233-6DDDB290',3,NULL,'IN_STOCK','GRN','XYZ972086814','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4980,'XYZ-1767873096264-C014D8B0',3,NULL,'IN_STOCK','GRN','XYZ145575120','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4981,'XYZ-1767873096294-73B8F66F',3,NULL,'IN_STOCK','GRN','XYZ706168343','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4982,'XYZ-1767873096325-9E7CDBB4',3,NULL,'IN_STOCK','GRN','XYZ116238162','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4983,'XYZ-1767873096353-8ED8DEEE',3,NULL,'IN_STOCK','GRN','XYZ483491506','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4984,'XYZ-1767873096380-74110DD0',3,NULL,'IN_STOCK','GRN','XYZ895950974','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4985,'XYZ-1767873096407-9F1D5C69',3,NULL,'IN_STOCK','GRN','XYZ517987501','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4986,'XYZ-1767873096435-E5846D4F',3,NULL,'IN_STOCK','GRN','XYZ600870724','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4987,'XYZ-1767873096462-FAE2502A',3,NULL,'IN_STOCK','GRN','XYZ475894497','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4988,'XYZ-1767873096486-EDA49A29',3,NULL,'IN_STOCK','GRN','XYZ733991784','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4989,'XYZ-1767873096511-41FDF41F',3,NULL,'IN_STOCK','GRN','XYZ407054741','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4990,'XYZ-1767873096535-10D6DBB6',3,NULL,'IN_STOCK','GRN','XYZ824125290','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4991,'XYZ-1767873096559-F62B0AF7',3,NULL,'IN_STOCK','GRN','XYZ201407258','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4992,'XYZ-1767873096583-8188E293',3,NULL,'IN_STOCK','GRN','XYZ531250168','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4993,'XYZ-1767873096614-93A5F099',3,NULL,'IN_STOCK','GRN','XYZ046850763','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4994,'XYZ-1767873096644-5724F05B',3,NULL,'IN_STOCK','GRN','XYZ839428941','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4995,'XYZ-1767873096673-EC6182A6',3,NULL,'IN_STOCK','GRN','XYZ993712441','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4996,'XYZ-1767873096702-C8D7171D',3,NULL,'IN_STOCK','GRN','XYZ580943314','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4997,'XYZ-1767873096732-96E7134F',3,NULL,'IN_STOCK','GRN','XYZ794870213','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4998,'XYZ-1767873096761-D796261C',3,NULL,'IN_STOCK','GRN','XYZ426037096','2026-01-08 11:51:36','2026-01-08 11:51:36'),(4999,'XYZ-1767873096790-D8C0ECC6',3,NULL,'IN_STOCK','GRN','XYZ798839499','2026-01-08 11:51:36','2026-01-08 11:51:36'),(5000,'XYZ-1767873096818-74746265',3,NULL,'IN_STOCK','GRN','XYZ663301352','2026-01-08 11:51:36','2026-01-08 11:51:36'),(5001,'XYZ-1767873096848-B73B5CEB',3,NULL,'IN_STOCK','GRN','XYZ911575501','2026-01-08 11:51:36','2026-01-08 11:51:36'),(5002,'XYZ-1767873096878-7108B1C3',3,NULL,'IN_STOCK','GRN','XYZ137426780','2026-01-08 11:51:36','2026-01-08 11:51:36'),(5003,'XYZ-1767873096909-A3FFB799',3,NULL,'IN_STOCK','GRN','XYZ398082576','2026-01-08 11:51:36','2026-01-08 11:51:36'),(5004,'XYZ-1767873096937-892804AF',3,NULL,'IN_STOCK','GRN','XYZ679301371','2026-01-08 11:51:36','2026-01-08 11:51:36'),(5005,'XYZ-1767873096968-2C89D393',3,NULL,'IN_STOCK','GRN','XYZ383310516','2026-01-08 11:51:36','2026-01-08 11:51:36'),(5006,'XYZ-1767873096997-0BFEAC71',3,NULL,'IN_STOCK','GRN','XYZ066654070','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5007,'XYZ-1767873097026-0AB88077',3,NULL,'IN_STOCK','GRN','XYZ205036077','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5008,'XYZ-1767873097053-07AA316A',3,NULL,'IN_STOCK','GRN','XYZ509502727','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5009,'XYZ-1767873097082-DCF1495D',3,NULL,'IN_STOCK','GRN','XYZ195778789','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5010,'XYZ-1767873097111-F052103C',3,NULL,'IN_STOCK','GRN','XYZ720228437','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5011,'XYZ-1767873097140-B665A868',3,NULL,'IN_STOCK','GRN','XYZ159308032','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5012,'XYZ-1767873097170-D5C9F372',3,NULL,'IN_STOCK','GRN','XYZ459872948','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5013,'XYZ-1767873097198-E3F29D89',3,NULL,'IN_STOCK','GRN','XYZ319607263','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5014,'XYZ-1767873097231-4144D32A',3,NULL,'IN_STOCK','GRN','XYZ476504250','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5015,'XYZ-1767873097261-C143C97C',3,NULL,'IN_STOCK','GRN','XYZ464704915','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5016,'XYZ-1767873097292-29ED7366',3,NULL,'IN_STOCK','GRN','XYZ799818964','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5017,'XYZ-1767873097320-44E14EFA',3,NULL,'IN_STOCK','GRN','XYZ043456636','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5018,'XYZ-1767873097350-B847BA86',3,NULL,'IN_STOCK','GRN','XYZ461746537','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5019,'XYZ-1767873097376-FF88490F',3,NULL,'IN_STOCK','GRN','XYZ809926831','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5020,'XYZ-1767873097403-FFD8732E',3,NULL,'IN_STOCK','GRN','XYZ318967927','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5021,'XYZ-1767873097437-5DD69094',3,NULL,'IN_STOCK','GRN','XYZ123863399','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5022,'XYZ-1767873097463-3B0A5328',3,NULL,'IN_STOCK','GRN','XYZ932706311','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5023,'XYZ-1767873097491-F0DA4F71',3,NULL,'IN_STOCK','GRN','XYZ838688153','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5024,'XYZ-1767873097519-07E02FD4',3,NULL,'IN_STOCK','GRN','XYZ614120321','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5025,'XYZ-1767873097547-F0A1F246',3,NULL,'IN_STOCK','GRN','XYZ927537995','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5026,'XYZ-1767873097575-942ED85C',3,NULL,'IN_STOCK','GRN','XYZ250057719','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5027,'XYZ-1767873097604-D0A2103D',3,NULL,'IN_STOCK','GRN','XYZ655135517','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5028,'XYZ-1767873097634-D01E863F',3,NULL,'IN_STOCK','GRN','XYZ483506633','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5029,'XYZ-1767873097661-BCD6503A',3,NULL,'IN_STOCK','GRN','XYZ838226085','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5030,'XYZ-1767873097689-B04E0661',3,NULL,'IN_STOCK','GRN','XYZ367302411','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5031,'XYZ-1767873097716-ED7BCA0B',3,NULL,'IN_STOCK','GRN','XYZ232054555','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5032,'XYZ-1767873097738-65AD8F6F',3,NULL,'IN_STOCK','GRN','XYZ081894093','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5033,'XYZ-1767873097760-21771B3A',3,NULL,'IN_STOCK','GRN','XYZ119995259','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5034,'XYZ-1767873097783-DCB70E50',3,NULL,'IN_STOCK','GRN','XYZ676117736','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5035,'XYZ-1767873097807-9A216A32',3,NULL,'IN_STOCK','GRN','XYZ487187481','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5036,'XYZ-1767873097829-05CE673D',3,NULL,'IN_STOCK','GRN','XYZ007712818','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5037,'XYZ-1767873097852-474917F6',3,NULL,'IN_STOCK','GRN','XYZ989045441','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5038,'XYZ-1767873097873-019E29A6',3,NULL,'IN_STOCK','GRN','XYZ576262406','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5039,'XYZ-1767873097894-F6B8D955',3,NULL,'IN_STOCK','GRN','XYZ129797376','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5040,'XYZ-1767873097919-C6D6103A',3,NULL,'IN_STOCK','GRN','XYZ599399587','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5041,'XYZ-1767873097940-25A6BF8B',3,NULL,'IN_STOCK','GRN','XYZ232902230','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5042,'XYZ-1767873097962-CBF2E56D',3,NULL,'IN_STOCK','GRN','XYZ297410956','2026-01-08 11:51:37','2026-01-08 11:51:37'),(5043,'XYZ-1767873097989-0F669E1F',10,NULL,'IN_STOCK','GRN','XYZ996117417','2026-01-08 11:51:38','2026-01-08 11:51:38'),(5044,'XYZ-1767873098018-86D4D4D0',10,NULL,'IN_STOCK','GRN','XYZ384964325','2026-01-08 11:51:38','2026-01-08 11:51:38'),(5045,'XYZ-1767873098043-A10F74C7',10,NULL,'IN_STOCK','GRN','XYZ058523246','2026-01-08 11:51:38','2026-01-08 11:51:38'),(5046,'XYZ-1767873098066-FEA7B14F',10,NULL,'IN_STOCK','GRN','XYZ441190672','2026-01-08 11:51:38','2026-01-08 11:51:38'),(5047,'XYZ-1767873098090-03BBD67E',10,NULL,'IN_STOCK','GRN','XYZ696975760','2026-01-08 11:51:38','2026-01-08 11:51:38'),(5048,'XYZ-1767873098115-BA0CBC80',10,NULL,'IN_STOCK','GRN','XYZ795658235','2026-01-08 11:51:38','2026-01-08 11:51:38'),(5049,'XYZ-1767873098140-90965B24',10,NULL,'IN_STOCK','GRN','XYZ164148369','2026-01-08 11:51:38','2026-01-08 11:51:38'),(5050,'XYZ-1767873098166-78185835',10,NULL,'IN_STOCK','GRN','XYZ479215455','2026-01-08 11:51:38','2026-01-08 11:51:38'),(5051,'XYZ-1767873098186-CF1363D5',10,NULL,'IN_STOCK','GRN','XYZ890289866','2026-01-08 11:51:38','2026-01-08 11:51:38'),(5052,'XYZ-1767873098206-8043B4D8',10,NULL,'IN_STOCK','GRN','XYZ928664738','2026-01-08 11:51:38','2026-01-08 11:51:38'),(5053,'XYZ-1767873098227-BEEEA398',10,NULL,'IN_STOCK','GRN','XYZ422907994','2026-01-08 11:51:38','2026-01-08 11:51:38'),(5054,'XYZ-1767873098247-6731D4E9',10,NULL,'IN_STOCK','GRN','XYZ862261457','2026-01-08 11:51:38','2026-01-08 11:51:38'),(5055,'XYZ-1767873098270-07BCF66C',10,NULL,'IN_STOCK','GRN','XYZ782559212','2026-01-08 11:51:38','2026-01-08 11:51:38'),(5056,'XYZ-1767874328363-BF8D6213',12,NULL,'SOLD','GRN','XYZ542874866','2026-01-08 12:12:08','2026-01-12 10:41:20'),(5057,'XYZ-1767874328427-3C8FA425',12,NULL,'IN_STOCK','GRN','XYZ829655848','2026-01-08 12:12:08','2026-01-08 12:12:08'),(5058,'XYZ-1767874328461-4479CE14',12,NULL,'IN_STOCK','GRN','XYZ115628392','2026-01-08 12:12:08','2026-01-08 12:12:08'),(5059,'XYZ-1767874328496-8BB09F9E',12,NULL,'IN_STOCK','GRN','XYZ863446960','2026-01-08 12:12:08','2026-01-08 12:12:08'),(5060,'XYZ-1767874328530-62D86387',12,NULL,'IN_STOCK','GRN','XYZ931481264','2026-01-08 12:12:08','2026-01-08 12:12:08'),(5061,'XYZ-1767874328567-4410BC32',12,NULL,'IN_STOCK','GRN','XYZ937963457','2026-01-08 12:12:08','2026-01-08 12:12:08'),(5062,'XYZ-1767874328602-E97F6417',12,NULL,'IN_STOCK','GRN','XYZ681966148','2026-01-08 12:12:08','2026-01-08 12:12:08'),(5063,'XYZ-1767874328635-6162E68E',12,NULL,'IN_STOCK','GRN','XYZ062087216','2026-01-08 12:12:08','2026-01-08 12:12:08'),(5064,'XYZ-1767874328665-667745A0',12,NULL,'IN_STOCK','GRN','XYZ496790631','2026-01-08 12:12:08','2026-01-08 12:12:08'),(5065,'XYZ-1767874328701-49FBCDB5',12,NULL,'IN_STOCK','GRN','XYZ178505345','2026-01-08 12:12:08','2026-01-08 12:12:08'),(5066,'XYZ-1767874328735-4FE3CC3A',12,NULL,'IN_STOCK','GRN','XYZ757442423','2026-01-08 12:12:08','2026-01-08 12:12:08'),(5067,'XYZ-1767874328764-511E31DF',12,NULL,'IN_STOCK','GRN','XYZ357807483','2026-01-08 12:12:08','2026-01-08 12:12:08'),(5068,'XYZ-1767874328790-46DD12A7',12,NULL,'IN_STOCK','GRN','XYZ628741649','2026-01-08 12:12:08','2026-01-08 12:12:08'),(5069,'XYZ-1767874328822-579ECD31',12,NULL,'IN_STOCK','GRN','XYZ712970889','2026-01-08 12:12:08','2026-01-08 12:12:08'),(5070,'XYZ-1767874328851-3069BE60',12,NULL,'IN_STOCK','GRN','XYZ173158911','2026-01-08 12:12:08','2026-01-08 12:12:08'),(5071,'XYZ-1767874328881-E97AF00E',12,NULL,'IN_STOCK','GRN','XYZ316388820','2026-01-08 12:12:08','2026-01-08 12:12:08'),(5072,'XYZ-1767874328910-A1D226D1',12,NULL,'IN_STOCK','GRN','XYZ968358581','2026-01-08 12:12:08','2026-01-08 12:12:08'),(5073,'XYZ-1767874328937-AC3B88DE',12,NULL,'IN_STOCK','GRN','XYZ573905850','2026-01-08 12:12:08','2026-01-08 12:12:08'),(5074,'XYZ-1767874328965-7C1326D4',12,NULL,'IN_STOCK','GRN','XYZ447013508','2026-01-08 12:12:08','2026-01-08 12:12:08'),(5075,'XYZ-1767874328996-E4962726',12,NULL,'IN_STOCK','GRN','XYZ419896906','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5076,'XYZ-1767874329024-D23E0EFC',12,NULL,'IN_STOCK','GRN','XYZ048653374','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5077,'XYZ-1767874329051-126E2053',12,NULL,'IN_STOCK','GRN','XYZ830083096','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5078,'XYZ-1767874329082-18DBB4E5',12,NULL,'IN_STOCK','GRN','XYZ085371947','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5079,'XYZ-1767874329109-F4071C44',12,NULL,'IN_STOCK','GRN','XYZ102058036','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5080,'XYZ-1767874329136-AEA28485',12,NULL,'IN_STOCK','GRN','XYZ186249867','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5081,'XYZ-1767874329162-8F2C5B31',12,NULL,'IN_STOCK','GRN','XYZ902768829','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5082,'XYZ-1767874329188-508D7632',12,NULL,'IN_STOCK','GRN','XYZ905530832','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5083,'XYZ-1767874329219-BB3F3882',12,NULL,'IN_STOCK','GRN','XYZ406138348','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5084,'XYZ-1767874329246-70778FEF',12,NULL,'IN_STOCK','GRN','XYZ827230134','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5085,'XYZ-1767874329276-53BAA3D8',12,NULL,'IN_STOCK','GRN','XYZ895566263','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5086,'XYZ-1767874329304-16EDEA0D',12,NULL,'IN_STOCK','GRN','XYZ286150038','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5087,'XYZ-1767874329335-A5A75D9D',12,NULL,'IN_STOCK','GRN','XYZ978379885','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5088,'XYZ-1767874329361-9C75BE27',12,NULL,'IN_STOCK','GRN','XYZ541220691','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5089,'XYZ-1767874329385-9A2AF69D',12,NULL,'IN_STOCK','GRN','XYZ526309485','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5090,'XYZ-1767874329418-A93369A5',12,NULL,'IN_STOCK','GRN','XYZ045770171','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5091,'XYZ-1767874329444-E9FE35A6',12,NULL,'IN_STOCK','GRN','XYZ304737062','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5092,'XYZ-1767874329470-502A960E',12,NULL,'IN_STOCK','GRN','XYZ639835226','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5093,'XYZ-1767874329497-C23AA671',12,NULL,'IN_STOCK','GRN','XYZ944183124','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5094,'XYZ-1767874329521-100275FB',12,NULL,'IN_STOCK','GRN','XYZ377645158','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5095,'XYZ-1767874329547-A82D2E59',12,NULL,'IN_STOCK','GRN','XYZ398419255','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5096,'XYZ-1767874329575-C77A731F',12,NULL,'IN_STOCK','GRN','XYZ028725744','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5097,'XYZ-1767874329605-1A97F3B6',12,NULL,'IN_STOCK','GRN','XYZ836120093','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5098,'XYZ-1767874329636-CEF015FF',12,NULL,'IN_STOCK','GRN','XYZ129243008','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5099,'XYZ-1767874329661-08AFBF81',12,NULL,'IN_STOCK','GRN','XYZ399087496','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5100,'XYZ-1767874329687-457C2937',12,NULL,'IN_STOCK','GRN','XYZ807051722','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5101,'XYZ-1767874329712-5811C9E0',12,NULL,'IN_STOCK','GRN','XYZ977289834','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5102,'XYZ-1767874329741-C9B14C26',12,NULL,'IN_STOCK','GRN','XYZ407025141','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5103,'XYZ-1767874329767-A73DBAE8',12,NULL,'IN_STOCK','GRN','XYZ010760255','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5104,'XYZ-1767874329791-622C1586',12,NULL,'IN_STOCK','GRN','XYZ455932988','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5105,'XYZ-1767874329815-230805E3',12,NULL,'IN_STOCK','GRN','XYZ878289054','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5106,'XYZ-1767874329846-2B192CA0',11,NULL,'IN_STOCK','GRN','XYZ922313269','2026-01-08 12:12:09','2026-01-08 12:12:09'),(5107,'XYZ-1767874662548-144CF9B0',6,2,'IN_STOCK','PRODUCTION','XYZ349210898','2026-01-08 12:17:42','2026-01-08 12:17:42'),(5108,'XYZ-1767874662593-7488B825',6,2,'IN_STOCK','PRODUCTION','XYZ658068193','2026-01-08 12:17:42','2026-01-08 12:17:42'),(5109,'XYZ-1767874662633-7CFB7F2B',6,2,'IN_STOCK','PRODUCTION','XYZ853860994','2026-01-08 12:17:42','2026-01-08 12:17:42'),(5110,'XYZ-1767874662669-597351CF',6,2,'IN_STOCK','PRODUCTION','XYZ969071691','2026-01-08 12:17:42','2026-01-08 12:17:42'),(5111,'XYZ-1767874662702-1DCAD97B',6,2,'IN_STOCK','PRODUCTION','XYZ900001379','2026-01-08 12:17:42','2026-01-08 12:17:42'),(5112,'XYZ-1767874662745-FD0DFCB8',6,2,'IN_STOCK','PRODUCTION','XYZ299807706','2026-01-08 12:17:42','2026-01-08 12:17:42'),(5113,'XYZ-1767874662780-0F662457',6,2,'IN_STOCK','PRODUCTION','XYZ384609792','2026-01-08 12:17:42','2026-01-08 12:17:42'),(5114,'XYZ-1767874662816-5E801768',6,2,'IN_STOCK','PRODUCTION','XYZ232891927','2026-01-08 12:17:42','2026-01-08 12:17:42'),(5115,'XYZ-1767874662853-04FD6AB3',6,2,'SOLD','PRODUCTION','XYZ342096086','2026-01-08 12:17:42','2026-01-10 14:58:22'),(5116,'XYZ-1767874662889-614E2BDD',6,2,'IN_STOCK','PRODUCTION','XYZ738310715','2026-01-08 12:17:42','2026-01-08 12:17:42'),(5117,'XYZ-1767874762955-5E58C047',11,3,'IN_STOCK','PRODUCTION','XYZ434338870','2026-01-08 12:19:22','2026-01-08 12:19:22'),(5118,'XYZ-1767874762993-4DD3422A',11,3,'IN_STOCK','PRODUCTION','XYZ526714841','2026-01-08 12:19:23','2026-01-08 12:19:23'),(5119,'XYZ-1767874763022-50AA5A1B',11,3,'IN_STOCK','PRODUCTION','XYZ265928468','2026-01-08 12:19:23','2026-01-08 12:19:23'),(5120,'XYZ-1767874763053-89395D4C',11,3,'IN_STOCK','PRODUCTION','XYZ935493848','2026-01-08 12:19:23','2026-01-08 12:19:23'),(5121,'XYZ-1767877781205-856C65C0',11,3,'IN_STOCK','PRODUCTION','XYZ714342188','2026-01-08 13:09:41','2026-01-08 13:09:41'),(5122,'XYZ-1767877781250-279640DE',11,3,'IN_STOCK','PRODUCTION','XYZ531945596','2026-01-08 13:09:41','2026-01-08 13:09:41'),(5123,'XYZ-1767877781289-65C8662A',11,3,'IN_STOCK','PRODUCTION','XYZ390279097','2026-01-08 13:09:41','2026-01-08 13:09:41'),(5124,'XYZ-1767877781327-34B8955E',11,3,'IN_STOCK','PRODUCTION','XYZ641851700','2026-01-08 13:09:41','2026-01-08 13:09:41'),(5125,'XYZ-1768194853000-FDA48D71',3,NULL,'IN_STOCK','GRN','XYZ785535353','2026-01-12 05:14:13','2026-01-12 05:14:13'),(5126,'XYZ-1768194853013-FD666F8C',3,NULL,'IN_STOCK','GRN','XYZ860427365','2026-01-12 05:14:13','2026-01-12 05:14:13'),(5127,'XYZ-1768194853017-EC78921F',3,NULL,'IN_STOCK','GRN','XYZ248653670','2026-01-12 05:14:13','2026-01-12 05:14:13'),(5128,'XYZ-1768194853022-D10D6C9E',3,NULL,'IN_STOCK','GRN','XYZ691127338','2026-01-12 05:14:13','2026-01-12 05:14:13'),(5129,'XYZ-1768194853026-EB2C96AB',3,NULL,'IN_STOCK','GRN','XYZ149765570','2026-01-12 05:14:13','2026-01-12 05:14:13'),(5130,'XYZ-1768194853029-942BCF7A',3,NULL,'IN_STOCK','GRN','XYZ226924619','2026-01-12 05:14:13','2026-01-12 05:14:13'),(5131,'XYZ-1768194853032-25CADB4B',3,NULL,'IN_STOCK','GRN','XYZ893958207','2026-01-12 05:14:13','2026-01-12 05:14:13'),(5132,'XYZ-1768194853036-7B94F6CF',3,NULL,'IN_STOCK','GRN','XYZ867082239','2026-01-12 05:14:13','2026-01-12 05:14:13'),(5133,'XYZ-1768194853040-76FE1BBD',3,NULL,'IN_STOCK','GRN','XYZ062964577','2026-01-12 05:14:13','2026-01-12 05:14:13'),(5134,'XYZ-1768194853044-77C9EC56',3,NULL,'IN_STOCK','GRN','XYZ697247683','2026-01-12 05:14:13','2026-01-12 05:14:13'),(5135,'XYZ-1768194978055-3BBF1979',11,NULL,'IN_STOCK','GRN','XYZ809553078','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5136,'XYZ-1768194978062-65193F11',11,NULL,'IN_STOCK','GRN','XYZ606437194','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5137,'XYZ-1768194978066-2594ED03',11,NULL,'IN_STOCK','GRN','XYZ693855988','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5138,'XYZ-1768194978070-66C5984F',11,NULL,'IN_STOCK','GRN','XYZ378634249','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5139,'XYZ-1768194978074-0E577C13',11,NULL,'IN_STOCK','GRN','XYZ445873217','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5140,'XYZ-1768194978078-210F9734',11,NULL,'IN_STOCK','GRN','XYZ399552518','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5141,'XYZ-1768194978080-4DD88680',11,NULL,'IN_STOCK','GRN','XYZ603833980','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5142,'XYZ-1768194978083-753B5CE6',11,NULL,'IN_STOCK','GRN','XYZ052939884','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5143,'XYZ-1768194978087-19B08DCC',11,NULL,'IN_STOCK','GRN','XYZ159739464','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5144,'XYZ-1768194978091-09C82A5C',11,NULL,'IN_STOCK','GRN','XYZ606344192','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5145,'XYZ-1768194978094-DAC10A1C',11,NULL,'IN_STOCK','GRN','XYZ381251075','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5146,'XYZ-1768194978097-99E34992',11,NULL,'IN_STOCK','GRN','XYZ070004453','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5147,'XYZ-1768194978100-339292AA',11,NULL,'IN_STOCK','GRN','XYZ341303962','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5148,'XYZ-1768194978104-5054AD55',11,NULL,'IN_STOCK','GRN','XYZ799678151','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5149,'XYZ-1768194978108-0C738A29',11,NULL,'IN_STOCK','GRN','XYZ810647884','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5150,'XYZ-1768194978110-CF1A09F2',11,NULL,'IN_STOCK','GRN','XYZ925480119','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5151,'XYZ-1768194978113-657B18B0',11,NULL,'IN_STOCK','GRN','XYZ732422303','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5152,'XYZ-1768194978116-AC050264',11,NULL,'IN_STOCK','GRN','XYZ282460227','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5153,'XYZ-1768194978119-D2C74F48',11,NULL,'IN_STOCK','GRN','XYZ561528144','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5154,'XYZ-1768194978121-EB44BBE2',11,NULL,'IN_STOCK','GRN','XYZ370020103','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5155,'XYZ-1768194978126-19889FA9',11,NULL,'IN_STOCK','GRN','XYZ469193895','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5156,'XYZ-1768194978129-7F7A857E',11,NULL,'IN_STOCK','GRN','XYZ289791276','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5157,'XYZ-1768194978131-361CD9CE',11,NULL,'IN_STOCK','GRN','XYZ730123702','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5158,'XYZ-1768194978134-EB5913E8',11,NULL,'IN_STOCK','GRN','XYZ623872689','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5159,'XYZ-1768194978137-F2727A01',11,NULL,'IN_STOCK','GRN','XYZ936040257','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5160,'XYZ-1768194978141-90D23FE0',11,NULL,'IN_STOCK','GRN','XYZ163434666','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5161,'XYZ-1768194978143-B6AFAD86',11,NULL,'IN_STOCK','GRN','XYZ016557783','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5162,'XYZ-1768194978146-E918FBC1',11,NULL,'IN_STOCK','GRN','XYZ517259438','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5163,'XYZ-1768194978149-501FACDA',11,NULL,'IN_STOCK','GRN','XYZ048455542','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5164,'XYZ-1768194978152-97875083',11,NULL,'IN_STOCK','GRN','XYZ592376008','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5165,'XYZ-1768194978156-D7AC5950',11,NULL,'IN_STOCK','GRN','XYZ040206619','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5166,'XYZ-1768194978159-F9C4D7B4',11,NULL,'IN_STOCK','GRN','XYZ178166114','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5167,'XYZ-1768194978161-CFAE6B25',11,NULL,'IN_STOCK','GRN','XYZ612108198','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5168,'XYZ-1768194978164-EADF354F',11,NULL,'IN_STOCK','GRN','XYZ920680088','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5169,'XYZ-1768194978167-AFDA06C6',11,NULL,'IN_STOCK','GRN','XYZ160815998','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5170,'XYZ-1768194978171-709ACCF0',11,NULL,'IN_STOCK','GRN','XYZ062043047','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5171,'XYZ-1768194978174-01265E1B',11,NULL,'IN_STOCK','GRN','XYZ932460520','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5172,'XYZ-1768194978175-CCFC1E5E',11,NULL,'IN_STOCK','GRN','XYZ872710137','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5173,'XYZ-1768194978177-B5CB7B27',11,NULL,'IN_STOCK','GRN','XYZ469044481','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5174,'XYZ-1768194978178-A0F3F15E',11,NULL,'IN_STOCK','GRN','XYZ983007593','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5175,'XYZ-1768194978180-C64C4152',11,NULL,'IN_STOCK','GRN','XYZ663471360','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5176,'XYZ-1768194978182-EF3AF195',11,NULL,'IN_STOCK','GRN','XYZ682653544','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5177,'XYZ-1768194978183-5D4AC11E',11,NULL,'IN_STOCK','GRN','XYZ627615649','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5178,'XYZ-1768194978184-AA75788E',11,NULL,'IN_STOCK','GRN','XYZ607557843','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5179,'XYZ-1768194978186-AAF5837B',11,NULL,'IN_STOCK','GRN','XYZ825238812','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5180,'XYZ-1768194978189-1BBDAAEC',11,NULL,'IN_STOCK','GRN','XYZ604549863','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5181,'XYZ-1768194978192-B8E68F92',11,NULL,'IN_STOCK','GRN','XYZ640353431','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5182,'XYZ-1768194978194-F86807F1',11,NULL,'IN_STOCK','GRN','XYZ622063118','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5183,'XYZ-1768194978196-907A667D',11,NULL,'IN_STOCK','GRN','XYZ740372241','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5184,'XYZ-1768194978198-34196D73',11,NULL,'IN_STOCK','GRN','XYZ845515236','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5185,'XYZ-1768194978200-07FEEF59',11,NULL,'IN_STOCK','GRN','XYZ697313987','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5186,'XYZ-1768194978202-B67015D2',11,NULL,'IN_STOCK','GRN','XYZ552085507','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5187,'XYZ-1768194978204-53CE2742',11,NULL,'IN_STOCK','GRN','XYZ447199738','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5188,'XYZ-1768194978207-F0A5B552',11,NULL,'IN_STOCK','GRN','XYZ381774976','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5189,'XYZ-1768194978210-FE18390A',11,NULL,'IN_STOCK','GRN','XYZ607764903','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5190,'XYZ-1768194978212-85144577',11,NULL,'IN_STOCK','GRN','XYZ374026971','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5191,'XYZ-1768194978214-42616F94',11,NULL,'IN_STOCK','GRN','XYZ240556594','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5192,'XYZ-1768194978216-4FC01E00',11,NULL,'IN_STOCK','GRN','XYZ144299540','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5193,'XYZ-1768194978218-83DEF922',11,NULL,'IN_STOCK','GRN','XYZ075909738','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5194,'XYZ-1768194978221-7BDAC04F',11,NULL,'IN_STOCK','GRN','XYZ555488792','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5195,'XYZ-1768194978224-EF39BCE6',11,NULL,'IN_STOCK','GRN','XYZ620532752','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5196,'XYZ-1768194978226-872D174A',11,NULL,'IN_STOCK','GRN','XYZ133932137','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5197,'XYZ-1768194978228-25156B10',11,NULL,'IN_STOCK','GRN','XYZ528908876','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5198,'XYZ-1768194978230-B31087B4',11,NULL,'IN_STOCK','GRN','XYZ808740426','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5199,'XYZ-1768194978232-528E7F44',11,NULL,'IN_STOCK','GRN','XYZ230302625','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5200,'XYZ-1768194978234-6F8160AE',11,NULL,'IN_STOCK','GRN','XYZ458593547','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5201,'XYZ-1768194978236-4488B0E3',11,NULL,'IN_STOCK','GRN','XYZ719790931','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5202,'XYZ-1768194978238-1D6F7EBD',11,NULL,'IN_STOCK','GRN','XYZ650445392','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5203,'XYZ-1768194978239-B0F78D16',11,NULL,'IN_STOCK','GRN','XYZ708779057','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5204,'XYZ-1768194978241-772F8512',11,NULL,'IN_STOCK','GRN','XYZ883198850','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5205,'XYZ-1768194978243-FECB7CE7',11,NULL,'IN_STOCK','GRN','XYZ643958443','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5206,'XYZ-1768194978244-FE41F69D',11,NULL,'IN_STOCK','GRN','XYZ539632535','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5207,'XYZ-1768194978246-BFAB2461',11,NULL,'IN_STOCK','GRN','XYZ454200906','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5208,'XYZ-1768194978248-98B4C097',11,NULL,'IN_STOCK','GRN','XYZ481053414','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5209,'XYZ-1768194978250-01619278',11,NULL,'IN_STOCK','GRN','XYZ445718227','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5210,'XYZ-1768194978252-45188658',11,NULL,'IN_STOCK','GRN','XYZ486297185','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5211,'XYZ-1768194978253-CDA25B5B',11,NULL,'IN_STOCK','GRN','XYZ237691902','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5212,'XYZ-1768194978255-E49306AB',11,NULL,'IN_STOCK','GRN','XYZ116917772','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5213,'XYZ-1768194978256-3D9C4DCD',11,NULL,'IN_STOCK','GRN','XYZ826688521','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5214,'XYZ-1768194978258-D5F8E212',11,NULL,'IN_STOCK','GRN','XYZ147336354','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5215,'XYZ-1768194978260-94B17977',11,NULL,'IN_STOCK','GRN','XYZ237514590','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5216,'XYZ-1768194978261-97BF79BE',11,NULL,'IN_STOCK','GRN','XYZ906903498','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5217,'XYZ-1768194978262-33C51455',11,NULL,'IN_STOCK','GRN','XYZ978116176','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5218,'XYZ-1768194978263-E1685177',11,NULL,'IN_STOCK','GRN','XYZ043967854','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5219,'XYZ-1768194978265-E6348B4F',11,NULL,'IN_STOCK','GRN','XYZ634397068','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5220,'XYZ-1768194978266-6FBC01F2',11,NULL,'IN_STOCK','GRN','XYZ739036330','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5221,'XYZ-1768194978269-1D50A584',11,NULL,'IN_STOCK','GRN','XYZ131584435','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5222,'XYZ-1768194978272-71EA33D9',11,NULL,'IN_STOCK','GRN','XYZ216947992','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5223,'XYZ-1768194978274-5696A23B',11,NULL,'IN_STOCK','GRN','XYZ755171280','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5224,'XYZ-1768194978277-D6979471',11,NULL,'IN_STOCK','GRN','XYZ581666038','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5225,'XYZ-1768194978279-BD0CE693',11,NULL,'IN_STOCK','GRN','XYZ713445650','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5226,'XYZ-1768194978282-BA803A6E',11,NULL,'IN_STOCK','GRN','XYZ483131331','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5227,'XYZ-1768194978284-AD0AB206',11,NULL,'IN_STOCK','GRN','XYZ376782498','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5228,'XYZ-1768194978287-5FC4DAC1',11,NULL,'IN_STOCK','GRN','XYZ537350245','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5229,'XYZ-1768194978289-0F35E81D',11,NULL,'IN_STOCK','GRN','XYZ864044214','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5230,'XYZ-1768194978290-AD63F529',11,NULL,'IN_STOCK','GRN','XYZ658728478','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5231,'XYZ-1768194978292-7AC21AB1',11,NULL,'IN_STOCK','GRN','XYZ423055899','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5232,'XYZ-1768194978293-450D9150',11,NULL,'IN_STOCK','GRN','XYZ493840423','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5233,'XYZ-1768194978294-05642E79',11,NULL,'IN_STOCK','GRN','XYZ998797288','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5234,'XYZ-1768194978295-1A7B8803',11,NULL,'IN_STOCK','GRN','XYZ161120374','2026-01-12 05:16:18','2026-01-12 05:16:18'),(5235,'XYZ-1768195175817-DCBF9544',1,NULL,'IN_STOCK','GRN','XYZ237701676','2026-01-12 05:19:35','2026-01-12 05:19:35'),(5236,'XYZ-1768195175907-8368DAF7',1,NULL,'IN_STOCK','GRN','XYZ077230323','2026-01-12 05:19:35','2026-01-12 05:19:35'),(5237,'XYZ-1768195175949-22C977EF',1,NULL,'IN_STOCK','GRN','XYZ549430327','2026-01-12 05:19:35','2026-01-12 05:19:35'),(5238,'XYZ-1768195175981-07B04C45',1,NULL,'IN_STOCK','GRN','XYZ182374202','2026-01-12 05:19:35','2026-01-12 05:19:35'),(5239,'XYZ-1768195176011-37777416',1,NULL,'IN_STOCK','GRN','XYZ033312876','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5240,'XYZ-1768195176046-862319D4',1,NULL,'IN_STOCK','GRN','XYZ287196092','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5241,'XYZ-1768195176074-3B9FA978',1,NULL,'IN_STOCK','GRN','XYZ812474675','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5242,'XYZ-1768195176102-1CBDFBC5',1,NULL,'IN_STOCK','GRN','XYZ985686597','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5243,'XYZ-1768195176131-0A169470',1,NULL,'IN_STOCK','GRN','XYZ057840495','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5244,'XYZ-1768195176159-32C6E74D',1,NULL,'IN_STOCK','GRN','XYZ013925426','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5245,'XYZ-1768195176187-21FB2ACE',1,NULL,'IN_STOCK','GRN','XYZ507107561','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5246,'XYZ-1768195176216-B5165F67',1,NULL,'IN_STOCK','GRN','XYZ839436570','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5247,'XYZ-1768195176244-DC72304B',1,NULL,'IN_STOCK','GRN','XYZ104002869','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5248,'XYZ-1768195176274-8FC29BC2',1,NULL,'IN_STOCK','GRN','XYZ940238861','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5249,'XYZ-1768195176306-78E627CB',1,NULL,'IN_STOCK','GRN','XYZ503208567','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5250,'XYZ-1768195176332-4E1C2BB3',1,NULL,'IN_STOCK','GRN','XYZ432054653','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5251,'XYZ-1768195176358-A973008A',1,NULL,'IN_STOCK','GRN','XYZ050373302','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5252,'XYZ-1768195176387-633A77F9',1,NULL,'IN_STOCK','GRN','XYZ884399116','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5253,'XYZ-1768195176415-A8F976FF',1,NULL,'IN_STOCK','GRN','XYZ972807179','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5254,'XYZ-1768195176447-81BDB690',1,NULL,'IN_STOCK','GRN','XYZ925468917','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5255,'XYZ-1768195176473-925671A0',1,NULL,'IN_STOCK','GRN','XYZ754076341','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5256,'XYZ-1768195176500-2808517D',1,NULL,'IN_STOCK','GRN','XYZ099249387','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5257,'XYZ-1768195176527-EECF0186',1,NULL,'IN_STOCK','GRN','XYZ383884516','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5258,'XYZ-1768195176551-D9398671',1,NULL,'IN_STOCK','GRN','XYZ294296525','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5259,'XYZ-1768195176576-997DA820',1,NULL,'IN_STOCK','GRN','XYZ283090756','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5260,'XYZ-1768195176602-55702FB0',1,NULL,'IN_STOCK','GRN','XYZ618794991','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5261,'XYZ-1768195176627-C45EE2D1',1,NULL,'IN_STOCK','GRN','XYZ402347766','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5262,'XYZ-1768195176656-E7BA1307',1,NULL,'IN_STOCK','GRN','XYZ852126972','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5263,'XYZ-1768195176683-4993EE45',1,NULL,'IN_STOCK','GRN','XYZ071603260','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5264,'XYZ-1768195176708-E9FC49E8',1,NULL,'IN_STOCK','GRN','XYZ515941297','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5265,'XYZ-1768195176734-CEA7CA02',1,NULL,'IN_STOCK','GRN','XYZ058510016','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5266,'XYZ-1768195176760-86859F06',1,NULL,'IN_STOCK','GRN','XYZ335201844','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5267,'XYZ-1768195176792-30924335',1,NULL,'IN_STOCK','GRN','XYZ081952012','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5268,'XYZ-1768195176820-F7EC386E',1,NULL,'IN_STOCK','GRN','XYZ780602279','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5269,'XYZ-1768195176848-008AE7A1',1,NULL,'IN_STOCK','GRN','XYZ032456738','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5270,'XYZ-1768195176876-F9CF9C80',1,NULL,'IN_STOCK','GRN','XYZ233609551','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5271,'XYZ-1768195176904-055A9726',1,NULL,'IN_STOCK','GRN','XYZ081490654','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5272,'XYZ-1768195176930-58DFCD91',1,NULL,'IN_STOCK','GRN','XYZ805742845','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5273,'XYZ-1768195176955-B6716FAF',1,NULL,'IN_STOCK','GRN','XYZ288982221','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5274,'XYZ-1768195176979-4D40DDDA',1,NULL,'IN_STOCK','GRN','XYZ875169325','2026-01-12 05:19:36','2026-01-12 05:19:36'),(5275,'XYZ-1768195177004-E950D52F',1,NULL,'IN_STOCK','GRN','XYZ510066767','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5276,'XYZ-1768195177030-93CC8C75',1,NULL,'IN_STOCK','GRN','XYZ725446564','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5277,'XYZ-1768195177053-00A75AED',1,NULL,'IN_STOCK','GRN','XYZ848880158','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5278,'XYZ-1768195177081-88FE804B',1,NULL,'IN_STOCK','GRN','XYZ232216996','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5279,'XYZ-1768195177107-CD8E71EC',1,NULL,'IN_STOCK','GRN','XYZ991636052','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5280,'XYZ-1768195177132-EECF36C8',1,NULL,'IN_STOCK','GRN','XYZ976733116','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5281,'XYZ-1768195177156-1035E8DB',1,NULL,'IN_STOCK','GRN','XYZ769961924','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5282,'XYZ-1768195177184-84C2BE8F',1,NULL,'IN_STOCK','GRN','XYZ501023620','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5283,'XYZ-1768195177209-579905C5',1,NULL,'IN_STOCK','GRN','XYZ166467957','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5284,'XYZ-1768195177233-7DC7E137',1,NULL,'IN_STOCK','GRN','XYZ826611932','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5285,'XYZ-1768195177256-68020378',1,NULL,'IN_STOCK','GRN','XYZ719229370','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5286,'XYZ-1768195177280-4A76850B',1,NULL,'IN_STOCK','GRN','XYZ960851027','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5287,'XYZ-1768195177305-3C6C5228',1,NULL,'IN_STOCK','GRN','XYZ865081258','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5288,'XYZ-1768195177332-54934170',1,NULL,'IN_STOCK','GRN','XYZ747926782','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5289,'XYZ-1768195177356-57CD8547',1,NULL,'IN_STOCK','GRN','XYZ586858028','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5290,'XYZ-1768195177382-BDF281D0',1,NULL,'IN_STOCK','GRN','XYZ965967162','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5291,'XYZ-1768195177408-E34B0FBD',1,NULL,'IN_STOCK','GRN','XYZ001365110','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5292,'XYZ-1768195177435-EE7218A5',1,NULL,'IN_STOCK','GRN','XYZ832289830','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5293,'XYZ-1768195177460-9C98034A',1,NULL,'IN_STOCK','GRN','XYZ336557330','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5294,'XYZ-1768195177484-18D213E9',1,NULL,'IN_STOCK','GRN','XYZ782645530','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5295,'XYZ-1768195177510-24F83714',1,NULL,'IN_STOCK','GRN','XYZ833197153','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5296,'XYZ-1768195177531-D3EEA5FD',1,NULL,'IN_STOCK','GRN','XYZ383635818','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5297,'XYZ-1768195177553-58AFCFEE',1,NULL,'IN_STOCK','GRN','XYZ106852611','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5298,'XYZ-1768195177580-711576B7',1,NULL,'IN_STOCK','GRN','XYZ646274311','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5299,'XYZ-1768195177604-A4D70679',1,NULL,'IN_STOCK','GRN','XYZ353207694','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5300,'XYZ-1768195177631-04F97894',1,NULL,'IN_STOCK','GRN','XYZ086819876','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5301,'XYZ-1768195177657-B4320D5F',1,NULL,'IN_STOCK','GRN','XYZ717621920','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5302,'XYZ-1768195177686-2CFA8819',1,NULL,'IN_STOCK','GRN','XYZ813397460','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5303,'XYZ-1768195177711-D02BAE16',1,NULL,'IN_STOCK','GRN','XYZ214353956','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5304,'XYZ-1768195177737-19B993FD',1,NULL,'IN_STOCK','GRN','XYZ987310421','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5305,'XYZ-1768195177762-22C32793',1,NULL,'IN_STOCK','GRN','XYZ470839941','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5306,'XYZ-1768195177786-B5219719',1,NULL,'IN_STOCK','GRN','XYZ776750595','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5307,'XYZ-1768195177812-062FBEBF',1,NULL,'IN_STOCK','GRN','XYZ452223992','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5308,'XYZ-1768195177840-5B80F590',1,NULL,'IN_STOCK','GRN','XYZ542979865','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5309,'XYZ-1768195177870-1349AF04',1,NULL,'IN_STOCK','GRN','XYZ236431332','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5310,'XYZ-1768195177903-772A49FD',1,NULL,'IN_STOCK','GRN','XYZ425929171','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5311,'XYZ-1768195177931-475389C8',1,NULL,'IN_STOCK','GRN','XYZ772238800','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5312,'XYZ-1768195177961-C53687F2',1,NULL,'IN_STOCK','GRN','XYZ910091310','2026-01-12 05:19:37','2026-01-12 05:19:37'),(5313,'XYZ-1768195177991-A1CF1C82',1,NULL,'IN_STOCK','GRN','XYZ466753167','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5314,'XYZ-1768195178018-CEE6BA26',1,NULL,'IN_STOCK','GRN','XYZ951387217','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5315,'XYZ-1768195178046-C8B0FC84',1,NULL,'IN_STOCK','GRN','XYZ130252915','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5316,'XYZ-1768195178072-D1A0E520',1,NULL,'IN_STOCK','GRN','XYZ590006980','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5317,'XYZ-1768195178097-FF774524',1,NULL,'IN_STOCK','GRN','XYZ980498707','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5318,'XYZ-1768195178120-1A214297',1,NULL,'IN_STOCK','GRN','XYZ292962926','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5319,'XYZ-1768195178143-3E435F82',1,NULL,'IN_STOCK','GRN','XYZ054431883','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5320,'XYZ-1768195178176-4001F272',1,NULL,'IN_STOCK','GRN','XYZ638216601','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5321,'XYZ-1768195178202-42712DB4',1,NULL,'IN_STOCK','GRN','XYZ065770595','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5322,'XYZ-1768195178225-7504EA6F',1,NULL,'IN_STOCK','GRN','XYZ835449862','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5323,'XYZ-1768195178247-6EE8E076',1,NULL,'IN_STOCK','GRN','XYZ670242480','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5324,'XYZ-1768195178272-CD96EAC4',1,NULL,'IN_STOCK','GRN','XYZ826237163','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5325,'XYZ-1768195178294-7892429D',1,NULL,'IN_STOCK','GRN','XYZ263180879','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5326,'XYZ-1768195178317-5010E8EF',1,NULL,'IN_STOCK','GRN','XYZ860460793','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5327,'XYZ-1768195178338-B4A23ECA',1,NULL,'IN_STOCK','GRN','XYZ138837544','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5328,'XYZ-1768195178358-C15372A5',1,NULL,'IN_STOCK','GRN','XYZ477200451','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5329,'XYZ-1768195178385-ADEA3161',1,NULL,'IN_STOCK','GRN','XYZ862079801','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5330,'XYZ-1768195178407-D5A033B2',1,NULL,'IN_STOCK','GRN','XYZ154435217','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5331,'XYZ-1768195178431-14E0D45C',1,NULL,'IN_STOCK','GRN','XYZ484712544','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5332,'XYZ-1768195178454-469E8429',1,NULL,'IN_STOCK','GRN','XYZ679396267','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5333,'XYZ-1768195178478-047EBE4C',1,NULL,'IN_STOCK','GRN','XYZ583388598','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5334,'XYZ-1768195178501-A2450155',1,NULL,'IN_STOCK','GRN','XYZ894641502','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5335,'XYZ-1768195178524-374BED33',1,NULL,'IN_STOCK','GRN','XYZ893402645','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5336,'XYZ-1768195178548-FE8A076D',1,NULL,'IN_STOCK','GRN','XYZ612406327','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5337,'XYZ-1768195178574-63F2F594',1,NULL,'IN_STOCK','GRN','XYZ780299156','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5338,'XYZ-1768195178602-E1B9BAA1',1,NULL,'IN_STOCK','GRN','XYZ716717353','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5339,'XYZ-1768195178627-7228919C',1,NULL,'IN_STOCK','GRN','XYZ835306363','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5340,'XYZ-1768195178650-B1328985',1,NULL,'IN_STOCK','GRN','XYZ346197870','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5341,'XYZ-1768195178675-446B7E36',1,NULL,'IN_STOCK','GRN','XYZ977076228','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5342,'XYZ-1768195178697-D31BAF7E',1,NULL,'IN_STOCK','GRN','XYZ111680000','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5343,'XYZ-1768195178722-3A5475F2',1,NULL,'IN_STOCK','GRN','XYZ364326445','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5344,'XYZ-1768195178747-0E374722',1,NULL,'IN_STOCK','GRN','XYZ980183807','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5345,'XYZ-1768195178773-9F17D75E',1,NULL,'IN_STOCK','GRN','XYZ045105299','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5346,'XYZ-1768195178798-E9843F0B',1,NULL,'IN_STOCK','GRN','XYZ979956632','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5347,'XYZ-1768195178822-01B26B71',1,NULL,'IN_STOCK','GRN','XYZ065274343','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5348,'XYZ-1768195178850-2C666266',1,NULL,'IN_STOCK','GRN','XYZ383164707','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5349,'XYZ-1768195178877-9DB2540A',1,NULL,'IN_STOCK','GRN','XYZ250231051','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5350,'XYZ-1768195178902-9D0CBF54',1,NULL,'IN_STOCK','GRN','XYZ389164359','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5351,'XYZ-1768195178925-D1C06DE0',1,NULL,'IN_STOCK','GRN','XYZ479760092','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5352,'XYZ-1768195178949-DA91E20C',1,NULL,'IN_STOCK','GRN','XYZ978321777','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5353,'XYZ-1768195178975-BBD80B78',1,NULL,'IN_STOCK','GRN','XYZ690099261','2026-01-12 05:19:38','2026-01-12 05:19:38'),(5354,'XYZ-1768195178995-71882C24',1,NULL,'IN_STOCK','GRN','XYZ493501091','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5355,'XYZ-1768195179019-5F9335C3',1,NULL,'IN_STOCK','GRN','XYZ967617776','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5356,'XYZ-1768195179045-C713A1CA',1,NULL,'IN_STOCK','GRN','XYZ102479407','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5357,'XYZ-1768195179066-903E3B24',1,NULL,'IN_STOCK','GRN','XYZ812208549','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5358,'XYZ-1768195179088-1ECF2F83',1,NULL,'IN_STOCK','GRN','XYZ072474560','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5359,'XYZ-1768195179117-78CF48E0',1,NULL,'IN_STOCK','GRN','XYZ920053788','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5360,'XYZ-1768195179141-4CBAE863',1,NULL,'IN_STOCK','GRN','XYZ051640981','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5361,'XYZ-1768195179164-C6A6B4BE',1,NULL,'IN_STOCK','GRN','XYZ090710990','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5362,'XYZ-1768195179189-9DF108B8',1,NULL,'IN_STOCK','GRN','XYZ691806634','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5363,'XYZ-1768195179218-FC703B00',1,NULL,'IN_STOCK','GRN','XYZ649745464','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5364,'XYZ-1768195179245-282BD6DB',1,NULL,'IN_STOCK','GRN','XYZ008464703','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5365,'XYZ-1768195179275-78BFAC7A',1,NULL,'IN_STOCK','GRN','XYZ318362588','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5366,'XYZ-1768195179304-A96841AB',1,NULL,'IN_STOCK','GRN','XYZ546859126','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5367,'XYZ-1768195179331-4B8AD004',1,NULL,'IN_STOCK','GRN','XYZ854710817','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5368,'XYZ-1768195179357-660F9E0C',1,NULL,'IN_STOCK','GRN','XYZ011362710','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5369,'XYZ-1768195179379-8A69A063',1,NULL,'IN_STOCK','GRN','XYZ949648877','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5370,'XYZ-1768195179401-E1BC20AE',1,NULL,'IN_STOCK','GRN','XYZ674383683','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5371,'XYZ-1768195179424-039984DB',1,NULL,'IN_STOCK','GRN','XYZ087571416','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5372,'XYZ-1768195179446-B942BA2B',1,NULL,'IN_STOCK','GRN','XYZ707473285','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5373,'XYZ-1768195179469-F6F10075',1,NULL,'IN_STOCK','GRN','XYZ573186778','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5374,'XYZ-1768195179493-5D549A49',1,NULL,'IN_STOCK','GRN','XYZ045370480','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5375,'XYZ-1768195179515-DA21C9C4',1,NULL,'IN_STOCK','GRN','XYZ791187444','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5376,'XYZ-1768195179539-46A7E79A',1,NULL,'IN_STOCK','GRN','XYZ949189687','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5377,'XYZ-1768195179561-E1C22FBE',1,NULL,'IN_STOCK','GRN','XYZ099840060','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5378,'XYZ-1768195179588-DBAD4D82',1,NULL,'IN_STOCK','GRN','XYZ812392371','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5379,'XYZ-1768195179613-C3560F71',1,NULL,'IN_STOCK','GRN','XYZ513832132','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5380,'XYZ-1768195179635-B948C95D',1,NULL,'IN_STOCK','GRN','XYZ382838986','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5381,'XYZ-1768195179657-1F5E37ED',1,NULL,'IN_STOCK','GRN','XYZ942861445','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5382,'XYZ-1768195179681-C396C9FB',1,NULL,'IN_STOCK','GRN','XYZ101356570','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5383,'XYZ-1768195179705-66F801BD',1,NULL,'IN_STOCK','GRN','XYZ721616424','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5384,'XYZ-1768195179727-F5CE9D42',1,NULL,'IN_STOCK','GRN','XYZ941160478','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5385,'XYZ-1768195179748-FC696139',1,NULL,'IN_STOCK','GRN','XYZ555682989','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5386,'XYZ-1768195179770-D8F045E8',1,NULL,'IN_STOCK','GRN','XYZ975702229','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5387,'XYZ-1768195179791-54307C65',1,NULL,'IN_STOCK','GRN','XYZ648928382','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5388,'XYZ-1768195179815-541EF337',1,NULL,'IN_STOCK','GRN','XYZ381191759','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5389,'XYZ-1768195179839-3B61381E',1,NULL,'IN_STOCK','GRN','XYZ018331499','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5390,'XYZ-1768195179863-82121B8A',1,NULL,'IN_STOCK','GRN','XYZ327870871','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5391,'XYZ-1768195179887-17EF8EE9',1,NULL,'IN_STOCK','GRN','XYZ719870678','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5392,'XYZ-1768195179910-6DACC480',1,NULL,'IN_STOCK','GRN','XYZ267788014','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5393,'XYZ-1768195179932-83EA2CD7',1,NULL,'IN_STOCK','GRN','XYZ719875963','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5394,'XYZ-1768195179954-5933B53B',1,NULL,'IN_STOCK','GRN','XYZ250678269','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5395,'XYZ-1768195179974-4837CBCD',1,NULL,'IN_STOCK','GRN','XYZ183078627','2026-01-12 05:19:39','2026-01-12 05:19:39'),(5396,'XYZ-1768195179995-9C51DC02',1,NULL,'IN_STOCK','GRN','XYZ923212589','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5397,'XYZ-1768195180020-B8E040AD',1,NULL,'IN_STOCK','GRN','XYZ176870219','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5398,'XYZ-1768195180045-961E92CA',1,NULL,'IN_STOCK','GRN','XYZ360261036','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5399,'XYZ-1768195180069-571D6608',1,NULL,'IN_STOCK','GRN','XYZ494419582','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5400,'XYZ-1768195180096-D722D43A',1,NULL,'IN_STOCK','GRN','XYZ801634065','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5401,'XYZ-1768195180121-2BF630F6',1,NULL,'IN_STOCK','GRN','XYZ269761200','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5402,'XYZ-1768195180146-0E89E5F1',1,NULL,'IN_STOCK','GRN','XYZ349728801','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5403,'XYZ-1768195180169-9D8DDC81',1,NULL,'IN_STOCK','GRN','XYZ520293664','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5404,'XYZ-1768195180196-8D63B5C4',1,NULL,'IN_STOCK','GRN','XYZ811219224','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5405,'XYZ-1768195180221-F00AFC73',1,NULL,'IN_STOCK','GRN','XYZ518577314','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5406,'XYZ-1768195180248-27E09CC5',1,NULL,'IN_STOCK','GRN','XYZ856079645','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5407,'XYZ-1768195180275-0171E887',1,NULL,'IN_STOCK','GRN','XYZ767833543','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5408,'XYZ-1768195180300-CCBDFD76',1,NULL,'IN_STOCK','GRN','XYZ952609410','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5409,'XYZ-1768195180327-89EB1284',1,NULL,'IN_STOCK','GRN','XYZ334654258','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5410,'XYZ-1768195180350-D0174F60',1,NULL,'IN_STOCK','GRN','XYZ309059847','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5411,'XYZ-1768195180376-9655A566',1,NULL,'IN_STOCK','GRN','XYZ429124410','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5412,'XYZ-1768195180401-CE5825E5',1,NULL,'IN_STOCK','GRN','XYZ567150318','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5413,'XYZ-1768195180424-EDEA05E2',1,NULL,'IN_STOCK','GRN','XYZ979075553','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5414,'XYZ-1768195180447-416905BE',1,NULL,'IN_STOCK','GRN','XYZ501634826','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5415,'XYZ-1768195180477-54EC5009',1,NULL,'IN_STOCK','GRN','XYZ822042424','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5416,'XYZ-1768195180503-489222D0',1,NULL,'IN_STOCK','GRN','XYZ862472839','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5417,'XYZ-1768195180528-C7F1DDC4',1,NULL,'IN_STOCK','GRN','XYZ639649829','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5418,'XYZ-1768195180553-2FFF5EC7',1,NULL,'IN_STOCK','GRN','XYZ839673002','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5419,'XYZ-1768195180576-F6126324',1,NULL,'IN_STOCK','GRN','XYZ411910666','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5420,'XYZ-1768195180600-037AC04A',1,NULL,'IN_STOCK','GRN','XYZ084043701','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5421,'XYZ-1768195180625-C4BE0111',1,NULL,'IN_STOCK','GRN','XYZ326855562','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5422,'XYZ-1768195180651-EC4E20AC',1,NULL,'IN_STOCK','GRN','XYZ116827969','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5423,'XYZ-1768195180674-560262F0',1,NULL,'IN_STOCK','GRN','XYZ146885348','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5424,'XYZ-1768195180698-870833FB',1,NULL,'IN_STOCK','GRN','XYZ645700527','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5425,'XYZ-1768195180719-C75C6C70',1,NULL,'IN_STOCK','GRN','XYZ274254295','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5426,'XYZ-1768195180740-452056C1',1,NULL,'IN_STOCK','GRN','XYZ691239038','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5427,'XYZ-1768195180765-D18EB6FE',1,NULL,'IN_STOCK','GRN','XYZ517756634','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5428,'XYZ-1768195180790-CB04808D',1,NULL,'IN_STOCK','GRN','XYZ080850258','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5429,'XYZ-1768195180813-FD393CE6',1,NULL,'IN_STOCK','GRN','XYZ715272921','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5430,'XYZ-1768195180835-08AA6F43',1,NULL,'IN_STOCK','GRN','XYZ525950091','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5431,'XYZ-1768195180857-7AC8ECFB',1,NULL,'IN_STOCK','GRN','XYZ472083602','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5432,'XYZ-1768195180878-56A6957F',1,NULL,'IN_STOCK','GRN','XYZ342460115','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5433,'XYZ-1768195180901-D891720D',1,NULL,'IN_STOCK','GRN','XYZ554414586','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5434,'XYZ-1768195180922-7D671DED',1,NULL,'IN_STOCK','GRN','XYZ662115031','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5435,'XYZ-1768195180947-9793AEA9',1,NULL,'IN_STOCK','GRN','XYZ525606708','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5436,'XYZ-1768195180971-1356DE34',1,NULL,'IN_STOCK','GRN','XYZ653961483','2026-01-12 05:19:40','2026-01-12 05:19:40'),(5437,'XYZ-1768195180993-3B64DB29',1,NULL,'IN_STOCK','GRN','XYZ097770836','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5438,'XYZ-1768195181015-DC387E73',1,NULL,'IN_STOCK','GRN','XYZ438997722','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5439,'XYZ-1768195181037-4760D659',1,NULL,'IN_STOCK','GRN','XYZ286838784','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5440,'XYZ-1768195181060-59C9AD4A',1,NULL,'IN_STOCK','GRN','XYZ702732985','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5441,'XYZ-1768195181086-62B65F50',1,NULL,'IN_STOCK','GRN','XYZ102277145','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5442,'XYZ-1768195181109-E161C0E9',1,NULL,'IN_STOCK','GRN','XYZ940151852','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5443,'XYZ-1768195181131-2852ECB2',1,NULL,'IN_STOCK','GRN','XYZ226531484','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5444,'XYZ-1768195181153-BEBCAB52',1,NULL,'IN_STOCK','GRN','XYZ690228638','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5445,'XYZ-1768195181175-A2B8C72E',1,NULL,'IN_STOCK','GRN','XYZ910356208','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5446,'XYZ-1768195181197-F392FD23',1,NULL,'IN_STOCK','GRN','XYZ433941032','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5447,'XYZ-1768195181222-429CE8BB',1,NULL,'IN_STOCK','GRN','XYZ829012909','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5448,'XYZ-1768195181247-BF3B3F16',1,NULL,'IN_STOCK','GRN','XYZ622428791','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5449,'XYZ-1768195181272-016F033A',1,NULL,'IN_STOCK','GRN','XYZ707212566','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5450,'XYZ-1768195181299-D358476B',1,NULL,'IN_STOCK','GRN','XYZ345691734','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5451,'XYZ-1768195181321-D91E3366',1,NULL,'IN_STOCK','GRN','XYZ811265127','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5452,'XYZ-1768195181346-6ECC24BD',1,NULL,'IN_STOCK','GRN','XYZ615080480','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5453,'XYZ-1768195181369-A96D4B7A',1,NULL,'IN_STOCK','GRN','XYZ409471300','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5454,'XYZ-1768195181390-934913AD',1,NULL,'IN_STOCK','GRN','XYZ388374041','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5455,'XYZ-1768195181415-14756AC3',1,NULL,'IN_STOCK','GRN','XYZ367770234','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5456,'XYZ-1768195181437-4D202C91',1,NULL,'IN_STOCK','GRN','XYZ958011362','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5457,'XYZ-1768195181459-6C13869E',1,NULL,'IN_STOCK','GRN','XYZ668106556','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5458,'XYZ-1768195181482-8B9133FB',1,NULL,'IN_STOCK','GRN','XYZ285215507','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5459,'XYZ-1768195181507-FE0BDA3A',1,NULL,'IN_STOCK','GRN','XYZ462101051','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5460,'XYZ-1768195181530-DE426EE8',1,NULL,'IN_STOCK','GRN','XYZ662616680','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5461,'XYZ-1768195181552-FFB9B5C2',1,NULL,'IN_STOCK','GRN','XYZ217942822','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5462,'XYZ-1768195181578-3A7F0809',1,NULL,'IN_STOCK','GRN','XYZ527731907','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5463,'XYZ-1768195181605-9DD1ABE3',1,NULL,'IN_STOCK','GRN','XYZ841642666','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5464,'XYZ-1768195181631-075F20B7',1,NULL,'IN_STOCK','GRN','XYZ935973376','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5465,'XYZ-1768195181655-FFD75659',1,NULL,'IN_STOCK','GRN','XYZ043099427','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5466,'XYZ-1768195181680-04581D54',1,NULL,'IN_STOCK','GRN','XYZ169346071','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5467,'XYZ-1768195181704-DD4634F3',1,NULL,'IN_STOCK','GRN','XYZ136599780','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5468,'XYZ-1768195181729-EF5E3596',1,NULL,'IN_STOCK','GRN','XYZ036754608','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5469,'XYZ-1768195181754-CE9E2BF7',1,NULL,'IN_STOCK','GRN','XYZ373093539','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5470,'XYZ-1768195181779-8E7EF71B',1,NULL,'IN_STOCK','GRN','XYZ232944181','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5471,'XYZ-1768195181804-D982DA18',1,NULL,'IN_STOCK','GRN','XYZ499629629','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5472,'XYZ-1768195181827-DC78DC3D',1,NULL,'IN_STOCK','GRN','XYZ175270248','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5473,'XYZ-1768195181848-3C9CB8B5',1,NULL,'IN_STOCK','GRN','XYZ918045129','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5474,'XYZ-1768195181870-5C151780',1,NULL,'IN_STOCK','GRN','XYZ141581403','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5475,'XYZ-1768195181891-2D65CA38',1,NULL,'IN_STOCK','GRN','XYZ193844556','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5476,'XYZ-1768195181912-CA6E77AC',1,NULL,'IN_STOCK','GRN','XYZ644250952','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5477,'XYZ-1768195181933-F9408835',1,NULL,'IN_STOCK','GRN','XYZ838216455','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5478,'XYZ-1768195181954-796EF9AB',1,NULL,'IN_STOCK','GRN','XYZ720140789','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5479,'XYZ-1768195181976-0B0C7A13',1,NULL,'IN_STOCK','GRN','XYZ710394365','2026-01-12 05:19:41','2026-01-12 05:19:41'),(5480,'XYZ-1768195181997-B5824C8D',1,NULL,'IN_STOCK','GRN','XYZ797946185','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5481,'XYZ-1768195182018-1E32B124',1,NULL,'IN_STOCK','GRN','XYZ022903738','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5482,'XYZ-1768195182041-A2D96B1D',1,NULL,'IN_STOCK','GRN','XYZ100395537','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5483,'XYZ-1768195182063-D7AEE9D8',1,NULL,'IN_STOCK','GRN','XYZ868452043','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5484,'XYZ-1768195182086-0BE79412',1,NULL,'IN_STOCK','GRN','XYZ840219267','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5485,'XYZ-1768195182109-B2A0FB66',1,NULL,'IN_STOCK','GRN','XYZ420042799','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5486,'XYZ-1768195182131-E5367B9C',1,NULL,'IN_STOCK','GRN','XYZ026297688','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5487,'XYZ-1768195182155-FE15ECCC',1,NULL,'IN_STOCK','GRN','XYZ563396034','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5488,'XYZ-1768195182176-24CFC779',1,NULL,'IN_STOCK','GRN','XYZ743352789','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5489,'XYZ-1768195182199-3F33D68F',1,NULL,'IN_STOCK','GRN','XYZ314989506','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5490,'XYZ-1768195182223-79975F3D',1,NULL,'IN_STOCK','GRN','XYZ174687595','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5491,'XYZ-1768195182253-C1B66E20',1,NULL,'IN_STOCK','GRN','XYZ534253472','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5492,'XYZ-1768195182279-FC70A803',1,NULL,'IN_STOCK','GRN','XYZ521779076','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5493,'XYZ-1768195182303-3D4877A6',1,NULL,'IN_STOCK','GRN','XYZ827956899','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5494,'XYZ-1768195182328-55AAF196',1,NULL,'IN_STOCK','GRN','XYZ947233038','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5495,'XYZ-1768195182353-19DACF67',1,NULL,'IN_STOCK','GRN','XYZ794920673','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5496,'XYZ-1768195182377-95D12677',1,NULL,'IN_STOCK','GRN','XYZ397176547','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5497,'XYZ-1768195182398-2B9B60A0',1,NULL,'IN_STOCK','GRN','XYZ351465697','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5498,'XYZ-1768195182423-08B5FB93',1,NULL,'IN_STOCK','GRN','XYZ146453511','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5499,'XYZ-1768195182447-F3EA1A18',1,NULL,'IN_STOCK','GRN','XYZ673841573','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5500,'XYZ-1768195182473-8A91A5C7',1,NULL,'IN_STOCK','GRN','XYZ490620607','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5501,'XYZ-1768195182497-D935B2DF',1,NULL,'IN_STOCK','GRN','XYZ400570597','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5502,'XYZ-1768195182521-A9817256',1,NULL,'IN_STOCK','GRN','XYZ291319408','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5503,'XYZ-1768195182545-AED51D9F',1,NULL,'IN_STOCK','GRN','XYZ110493682','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5504,'XYZ-1768195182569-BFF7B42E',1,NULL,'IN_STOCK','GRN','XYZ719804278','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5505,'XYZ-1768195182593-571E5A8E',1,NULL,'IN_STOCK','GRN','XYZ252597080','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5506,'XYZ-1768195182613-7AEC801D',1,NULL,'IN_STOCK','GRN','XYZ590700201','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5507,'XYZ-1768195182632-76118243',1,NULL,'IN_STOCK','GRN','XYZ614034449','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5508,'XYZ-1768195182650-59FB5AB3',1,NULL,'IN_STOCK','GRN','XYZ208443909','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5509,'XYZ-1768195182676-7F8FB5A3',1,NULL,'IN_STOCK','GRN','XYZ208316041','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5510,'XYZ-1768195182700-F171CF73',1,NULL,'IN_STOCK','GRN','XYZ313956298','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5511,'XYZ-1768195182725-D25F078F',1,NULL,'IN_STOCK','GRN','XYZ529150353','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5512,'XYZ-1768195182746-98780B0E',1,NULL,'IN_STOCK','GRN','XYZ329826654','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5513,'XYZ-1768195182770-F4B482AB',1,NULL,'IN_STOCK','GRN','XYZ842510225','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5514,'XYZ-1768195182793-3FD4EF50',1,NULL,'IN_STOCK','GRN','XYZ992124139','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5515,'XYZ-1768195182817-5A7E1D2E',1,NULL,'IN_STOCK','GRN','XYZ951581698','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5516,'XYZ-1768195182840-51587AB9',1,NULL,'IN_STOCK','GRN','XYZ873260834','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5517,'XYZ-1768195182866-56992307',1,NULL,'IN_STOCK','GRN','XYZ006272575','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5518,'XYZ-1768195182889-B602F0CF',1,NULL,'IN_STOCK','GRN','XYZ417678678','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5519,'XYZ-1768195182910-EA1D7C78',1,NULL,'IN_STOCK','GRN','XYZ459296717','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5520,'XYZ-1768195182931-BCD29CB5',1,NULL,'IN_STOCK','GRN','XYZ868673295','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5521,'XYZ-1768195182951-FC5B2BEB',1,NULL,'IN_STOCK','GRN','XYZ861842449','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5522,'XYZ-1768195182973-7B8471E3',1,NULL,'IN_STOCK','GRN','XYZ861553295','2026-01-12 05:19:42','2026-01-12 05:19:42'),(5523,'XYZ-1768195182996-BFA70F48',1,NULL,'IN_STOCK','GRN','XYZ479387101','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5524,'XYZ-1768195183017-67B2AC01',1,NULL,'IN_STOCK','GRN','XYZ829479032','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5525,'XYZ-1768195183038-EF86DB1C',1,NULL,'IN_STOCK','GRN','XYZ869234971','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5526,'XYZ-1768195183059-F814500B',1,NULL,'IN_STOCK','GRN','XYZ358313479','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5527,'XYZ-1768195183081-1F97FC5D',1,NULL,'IN_STOCK','GRN','XYZ445844526','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5528,'XYZ-1768195183105-A7A84EB7',1,NULL,'IN_STOCK','GRN','XYZ820213195','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5529,'XYZ-1768195183125-ECCA040A',1,NULL,'IN_STOCK','GRN','XYZ829607661','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5530,'XYZ-1768195183147-EB2DBB26',1,NULL,'IN_STOCK','GRN','XYZ167156718','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5531,'XYZ-1768195183168-413B7E59',1,NULL,'IN_STOCK','GRN','XYZ068740479','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5532,'XYZ-1768195183189-C62DD11E',1,NULL,'IN_STOCK','GRN','XYZ759323236','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5533,'XYZ-1768195183212-8668A5D5',1,NULL,'IN_STOCK','GRN','XYZ880588555','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5534,'XYZ-1768195183235-EFE21081',1,NULL,'IN_STOCK','GRN','XYZ168368224','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5535,'XYZ-1768195183257-BE2829EA',1,NULL,'IN_STOCK','GRN','XYZ936263102','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5536,'XYZ-1768195183280-0A8A9794',1,NULL,'IN_STOCK','GRN','XYZ012671086','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5537,'XYZ-1768195183305-7F3C2AF0',1,NULL,'IN_STOCK','GRN','XYZ424956262','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5538,'XYZ-1768195183329-AA20669F',1,NULL,'IN_STOCK','GRN','XYZ364231252','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5539,'XYZ-1768195183354-59F8C19B',1,NULL,'IN_STOCK','GRN','XYZ151747475','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5540,'XYZ-1768195183376-56261B1A',1,NULL,'IN_STOCK','GRN','XYZ067726661','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5541,'XYZ-1768195183397-F86883CD',1,NULL,'IN_STOCK','GRN','XYZ303606209','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5542,'XYZ-1768195183418-BE68D2BB',1,NULL,'IN_STOCK','GRN','XYZ691661349','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5543,'XYZ-1768195183442-0ADE7183',1,NULL,'IN_STOCK','GRN','XYZ904762638','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5544,'XYZ-1768195183466-3CD9DB24',1,NULL,'IN_STOCK','GRN','XYZ424178150','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5545,'XYZ-1768195183491-F8F94A3E',1,NULL,'IN_STOCK','GRN','XYZ053026023','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5546,'XYZ-1768195183515-C3EDE568',1,NULL,'IN_STOCK','GRN','XYZ279926556','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5547,'XYZ-1768195183538-1C4FE14C',1,NULL,'IN_STOCK','GRN','XYZ051051172','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5548,'XYZ-1768195183559-ACAE989B',1,NULL,'IN_STOCK','GRN','XYZ701440211','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5549,'XYZ-1768195183580-F952376D',1,NULL,'IN_STOCK','GRN','XYZ640789282','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5550,'XYZ-1768195183604-EAF327A9',1,NULL,'IN_STOCK','GRN','XYZ713475141','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5551,'XYZ-1768195183628-5CB7923A',1,NULL,'IN_STOCK','GRN','XYZ936051784','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5552,'XYZ-1768195183653-F8A0F3A5',1,NULL,'IN_STOCK','GRN','XYZ739247189','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5553,'XYZ-1768195183678-BB5A0EA1',1,NULL,'IN_STOCK','GRN','XYZ270334016','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5554,'XYZ-1768195183704-8EF40462',1,NULL,'IN_STOCK','GRN','XYZ028352141','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5555,'XYZ-1768195183731-6460662F',1,NULL,'IN_STOCK','GRN','XYZ219101366','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5556,'XYZ-1768195183759-E75B8B14',1,NULL,'IN_STOCK','GRN','XYZ829369654','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5557,'XYZ-1768195183789-5BBDE5B6',1,NULL,'IN_STOCK','GRN','XYZ301024273','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5558,'XYZ-1768195183818-3F148407',1,NULL,'IN_STOCK','GRN','XYZ775357648','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5559,'XYZ-1768195183844-8FA88662',1,NULL,'IN_STOCK','GRN','XYZ141638956','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5560,'XYZ-1768195183871-3961FAD4',1,NULL,'IN_STOCK','GRN','XYZ661499773','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5561,'XYZ-1768195183897-7D3590DA',1,NULL,'IN_STOCK','GRN','XYZ664615053','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5562,'XYZ-1768195183923-12AFF0FE',1,NULL,'IN_STOCK','GRN','XYZ897174465','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5563,'XYZ-1768195183950-8CFB75C2',1,NULL,'IN_STOCK','GRN','XYZ970228042','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5564,'XYZ-1768195183975-47E9FCD2',1,NULL,'IN_STOCK','GRN','XYZ429105334','2026-01-12 05:19:43','2026-01-12 05:19:43'),(5565,'XYZ-1768195184000-9156A6D9',1,NULL,'IN_STOCK','GRN','XYZ497167696','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5566,'XYZ-1768195184024-8E533DA1',1,NULL,'IN_STOCK','GRN','XYZ521205496','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5567,'XYZ-1768195184046-E5FF5EDD',1,NULL,'IN_STOCK','GRN','XYZ711227810','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5568,'XYZ-1768195184071-502AB0A7',1,NULL,'IN_STOCK','GRN','XYZ931223257','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5569,'XYZ-1768195184096-69657CD0',1,NULL,'IN_STOCK','GRN','XYZ708682289','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5570,'XYZ-1768195184118-0CEACF2C',1,NULL,'IN_STOCK','GRN','XYZ067244564','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5571,'XYZ-1768195184139-E01CC779',1,NULL,'IN_STOCK','GRN','XYZ147657454','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5572,'XYZ-1768195184164-2DF9D998',1,NULL,'IN_STOCK','GRN','XYZ175809157','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5573,'XYZ-1768195184188-CDE54A82',1,NULL,'IN_STOCK','GRN','XYZ622477721','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5574,'XYZ-1768195184213-CDFBE951',1,NULL,'IN_STOCK','GRN','XYZ534121540','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5575,'XYZ-1768195184237-AC3B17D8',1,NULL,'IN_STOCK','GRN','XYZ174020794','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5576,'XYZ-1768195184257-63A40F0B',1,NULL,'IN_STOCK','GRN','XYZ935496603','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5577,'XYZ-1768195184282-A71E30EA',1,NULL,'IN_STOCK','GRN','XYZ326693840','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5578,'XYZ-1768195184307-C80838EB',1,NULL,'IN_STOCK','GRN','XYZ990468770','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5579,'XYZ-1768195184331-9CEE5994',1,NULL,'IN_STOCK','GRN','XYZ978804866','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5580,'XYZ-1768195184357-52EB45ED',1,NULL,'IN_STOCK','GRN','XYZ262429865','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5581,'XYZ-1768195184378-28956B13',1,NULL,'IN_STOCK','GRN','XYZ027780621','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5582,'XYZ-1768195184400-8B7E4DFF',1,NULL,'IN_STOCK','GRN','XYZ344296706','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5583,'XYZ-1768195184423-8A6F6BD1',1,NULL,'IN_STOCK','GRN','XYZ756249263','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5584,'XYZ-1768195184447-113F2CC7',1,NULL,'IN_STOCK','GRN','XYZ672256733','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5585,'XYZ-1768195184470-CF7C6FE9',1,NULL,'IN_STOCK','GRN','XYZ401255970','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5586,'XYZ-1768195184495-152D19E9',1,NULL,'IN_STOCK','GRN','XYZ670846269','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5587,'XYZ-1768195184521-E5581848',1,NULL,'IN_STOCK','GRN','XYZ004398560','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5588,'XYZ-1768195184545-3F5DD25A',1,NULL,'IN_STOCK','GRN','XYZ121411050','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5589,'XYZ-1768195184568-5C83064B',1,NULL,'IN_STOCK','GRN','XYZ788878183','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5590,'XYZ-1768195184592-29E9FEAE',1,NULL,'IN_STOCK','GRN','XYZ598872341','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5591,'XYZ-1768195184615-14549FB5',1,NULL,'IN_STOCK','GRN','XYZ399353052','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5592,'XYZ-1768195184638-62801548',1,NULL,'IN_STOCK','GRN','XYZ033105011','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5593,'XYZ-1768195184658-00955491',1,NULL,'IN_STOCK','GRN','XYZ588528749','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5594,'XYZ-1768195184680-1FA37989',1,NULL,'IN_STOCK','GRN','XYZ577557212','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5595,'XYZ-1768195184704-38D72969',1,NULL,'IN_STOCK','GRN','XYZ767069787','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5596,'XYZ-1768195184729-C102E64C',1,NULL,'IN_STOCK','GRN','XYZ170378861','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5597,'XYZ-1768195184757-0F959834',1,NULL,'IN_STOCK','GRN','XYZ595119174','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5598,'XYZ-1768195184783-DB3C798B',1,NULL,'IN_STOCK','GRN','XYZ879180827','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5599,'XYZ-1768195184808-41830836',1,NULL,'IN_STOCK','GRN','XYZ628704887','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5600,'XYZ-1768195184835-F2A170E9',1,NULL,'IN_STOCK','GRN','XYZ599821310','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5601,'XYZ-1768195184862-D7727794',1,NULL,'IN_STOCK','GRN','XYZ531718098','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5602,'XYZ-1768195184889-785B1AB6',1,NULL,'IN_STOCK','GRN','XYZ186473040','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5603,'XYZ-1768195184916-C4FE68A9',1,NULL,'IN_STOCK','GRN','XYZ711978920','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5604,'XYZ-1768195184942-24822364',1,NULL,'IN_STOCK','GRN','XYZ274908885','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5605,'XYZ-1768195184966-FC850E1A',1,NULL,'IN_STOCK','GRN','XYZ901968012','2026-01-12 05:19:44','2026-01-12 05:19:44'),(5606,'XYZ-1768195184990-43EFBEAD',1,NULL,'IN_STOCK','GRN','XYZ014677839','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5607,'XYZ-1768195185031-6E70DB7B',1,NULL,'IN_STOCK','GRN','XYZ327876652','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5608,'XYZ-1768195185064-B5F05466',1,NULL,'IN_STOCK','GRN','XYZ829184951','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5610,'XYZ-1768195185095-6306D498',1,NULL,'IN_STOCK','GRN','XYZ357037038','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5611,'XYZ-1768195185120-77FD5FF5',1,NULL,'IN_STOCK','GRN','XYZ503916691','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5612,'XYZ-1768195185147-F39F1F97',1,NULL,'IN_STOCK','GRN','XYZ078744984','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5613,'XYZ-1768195185174-6AE23B31',1,NULL,'IN_STOCK','GRN','XYZ929459628','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5614,'XYZ-1768195185202-EB89AD5B',1,NULL,'IN_STOCK','GRN','XYZ476494023','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5615,'XYZ-1768195185227-62D88F8D',1,NULL,'IN_STOCK','GRN','XYZ012243505','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5616,'XYZ-1768195185249-E14B8DE4',1,NULL,'IN_STOCK','GRN','XYZ436604748','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5617,'XYZ-1768195185270-947E2D75',1,NULL,'IN_STOCK','GRN','XYZ183187873','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5618,'XYZ-1768195185293-8C2FA2B6',1,NULL,'IN_STOCK','GRN','XYZ837327789','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5619,'XYZ-1768195185321-E4416FCD',1,NULL,'IN_STOCK','GRN','XYZ870383995','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5620,'XYZ-1768195185353-C148A3B7',1,NULL,'IN_STOCK','GRN','XYZ102389940','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5621,'XYZ-1768195185383-D3116431',1,NULL,'IN_STOCK','GRN','XYZ638221788','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5622,'XYZ-1768195185414-87ECD90C',1,NULL,'IN_STOCK','GRN','XYZ413911320','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5623,'XYZ-1768195185444-D16B3B00',1,NULL,'IN_STOCK','GRN','XYZ921694413','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5624,'XYZ-1768195185474-90A819D6',1,NULL,'IN_STOCK','GRN','XYZ595220935','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5625,'XYZ-1768195185501-B8FF9078',1,NULL,'IN_STOCK','GRN','XYZ816984013','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5626,'XYZ-1768195185527-0F02CC58',1,NULL,'IN_STOCK','GRN','XYZ575636846','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5627,'XYZ-1768195185551-73D4E403',1,NULL,'IN_STOCK','GRN','XYZ165922928','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5628,'XYZ-1768195185572-2BD0CF41',1,NULL,'IN_STOCK','GRN','XYZ747948768','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5629,'XYZ-1768195185596-E3949AE2',1,NULL,'IN_STOCK','GRN','XYZ527960308','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5630,'XYZ-1768195185621-E3B3F13C',1,NULL,'IN_STOCK','GRN','XYZ262484727','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5631,'XYZ-1768195185643-AB93B56B',1,NULL,'IN_STOCK','GRN','XYZ141468390','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5632,'XYZ-1768195185666-80CCE704',1,NULL,'IN_STOCK','GRN','XYZ186636600','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5633,'XYZ-1768195185690-7AE1C46F',1,NULL,'IN_STOCK','GRN','XYZ146075985','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5634,'XYZ-1768195185712-32F7C404',1,NULL,'IN_STOCK','GRN','XYZ965124725','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5635,'XYZ-1768195185731-15ED3235',1,NULL,'IN_STOCK','GRN','XYZ341986956','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5636,'XYZ-1768195185749-AE49BA25',1,NULL,'IN_STOCK','GRN','XYZ052022657','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5637,'XYZ-1768195185768-11B90D3F',1,NULL,'IN_STOCK','GRN','XYZ917987429','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5638,'XYZ-1768195185789-8C6F8D74',1,NULL,'IN_STOCK','GRN','XYZ434212748','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5639,'XYZ-1768195185812-C9807EA8',1,NULL,'IN_STOCK','GRN','XYZ343709805','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5640,'XYZ-1768195185834-0517B495',1,NULL,'IN_STOCK','GRN','XYZ244190099','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5641,'XYZ-1768195185856-FE92C39F',1,NULL,'IN_STOCK','GRN','XYZ976862856','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5642,'XYZ-1768195185877-60754A3B',1,NULL,'IN_STOCK','GRN','XYZ453346692','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5643,'XYZ-1768195185900-3BFB3CD8',1,NULL,'IN_STOCK','GRN','XYZ844553391','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5644,'XYZ-1768195185924-9B0E85EA',1,NULL,'IN_STOCK','GRN','XYZ110292874','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5645,'XYZ-1768195185945-24A4C091',1,NULL,'IN_STOCK','GRN','XYZ056786393','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5646,'XYZ-1768195185968-8A88F9F2',1,NULL,'IN_STOCK','GRN','XYZ985737315','2026-01-12 05:19:45','2026-01-12 05:19:45'),(5647,'XYZ-1768195185992-DF8F74F6',1,NULL,'IN_STOCK','GRN','XYZ904748330','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5648,'XYZ-1768195186025-CB151304',1,NULL,'IN_STOCK','GRN','XYZ328176773','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5649,'XYZ-1768195186052-C00E7B3D',1,NULL,'IN_STOCK','GRN','XYZ401996711','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5650,'XYZ-1768195186079-1E4D2BBE',1,NULL,'IN_STOCK','GRN','XYZ028450990','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5651,'XYZ-1768195186106-7B6ED84E',1,NULL,'IN_STOCK','GRN','XYZ522502051','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5652,'XYZ-1768195186133-4476995C',1,NULL,'IN_STOCK','GRN','XYZ441024535','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5653,'XYZ-1768195186160-3FFEC78D',1,NULL,'IN_STOCK','GRN','XYZ625302116','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5654,'XYZ-1768195186184-684E4539',1,NULL,'IN_STOCK','GRN','XYZ509014525','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5655,'XYZ-1768195186212-C94D5BE8',1,NULL,'IN_STOCK','GRN','XYZ190611251','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5656,'XYZ-1768195186239-0C129013',1,NULL,'IN_STOCK','GRN','XYZ638791211','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5657,'XYZ-1768195186269-47BDE750',1,NULL,'IN_STOCK','GRN','XYZ183978287','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5658,'XYZ-1768195186294-2636A50C',1,NULL,'IN_STOCK','GRN','XYZ490453951','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5659,'XYZ-1768195186321-2CC0C69A',1,NULL,'IN_STOCK','GRN','XYZ280049095','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5660,'XYZ-1768195186348-BE2B0C1F',1,NULL,'IN_STOCK','GRN','XYZ830262891','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5661,'XYZ-1768195186372-6A29EA08',1,NULL,'IN_STOCK','GRN','XYZ936906276','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5662,'XYZ-1768195186396-0AD31FDE',1,NULL,'IN_STOCK','GRN','XYZ418739237','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5663,'XYZ-1768195186418-C26F8474',1,NULL,'IN_STOCK','GRN','XYZ898575709','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5664,'XYZ-1768195186442-DC205AE2',1,NULL,'IN_STOCK','GRN','XYZ315836771','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5665,'XYZ-1768195186464-7C1FE708',1,NULL,'IN_STOCK','GRN','XYZ818700004','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5666,'XYZ-1768195186488-EC074A29',1,NULL,'IN_STOCK','GRN','XYZ420268883','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5667,'XYZ-1768195186510-66D74359',1,NULL,'IN_STOCK','GRN','XYZ156822987','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5668,'XYZ-1768195186532-5CAEFA4C',1,NULL,'IN_STOCK','GRN','XYZ768533054','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5669,'XYZ-1768195186556-AFDC7AB5',1,NULL,'IN_STOCK','GRN','XYZ792840141','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5670,'XYZ-1768195186580-CBD3A41D',1,NULL,'IN_STOCK','GRN','XYZ516214315','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5671,'XYZ-1768195186604-567D12A5',1,NULL,'IN_STOCK','GRN','XYZ160230565','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5672,'XYZ-1768195186626-E07A57F4',1,NULL,'IN_STOCK','GRN','XYZ160270156','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5673,'XYZ-1768195186650-02865391',1,NULL,'IN_STOCK','GRN','XYZ324674645','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5674,'XYZ-1768195186681-988B1B74',1,NULL,'IN_STOCK','GRN','XYZ273854402','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5675,'XYZ-1768195186710-027F1A9F',1,NULL,'IN_STOCK','GRN','XYZ353789366','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5676,'XYZ-1768195186756-E6671F2C',1,NULL,'IN_STOCK','GRN','XYZ855122539','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5677,'XYZ-1768195186784-1FFEAEFB',1,NULL,'IN_STOCK','GRN','XYZ142001824','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5678,'XYZ-1768195186808-35D8A958',1,NULL,'IN_STOCK','GRN','XYZ222131782','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5679,'XYZ-1768195186832-0D3B2D30',1,NULL,'IN_STOCK','GRN','XYZ690845769','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5680,'XYZ-1768195186855-4CF0F71D',1,NULL,'IN_STOCK','GRN','XYZ160825089','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5681,'XYZ-1768195186878-EBB9D9AB',1,NULL,'IN_STOCK','GRN','XYZ105790437','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5682,'XYZ-1768195186900-825A4B82',1,NULL,'IN_STOCK','GRN','XYZ593247490','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5683,'XYZ-1768195186920-F6B46E11',1,NULL,'IN_STOCK','GRN','XYZ301450938','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5684,'XYZ-1768195186942-3DD80E43',1,NULL,'IN_STOCK','GRN','XYZ869238021','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5685,'XYZ-1768195186963-25E3E444',1,NULL,'IN_STOCK','GRN','XYZ843967592','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5686,'XYZ-1768195186986-E11BE271',1,NULL,'IN_STOCK','GRN','XYZ770861120','2026-01-12 05:19:46','2026-01-12 05:19:46'),(5687,'XYZ-1768195187007-13297B60',1,NULL,'IN_STOCK','GRN','XYZ293352286','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5688,'XYZ-1768195187029-A41AEEDE',1,NULL,'IN_STOCK','GRN','XYZ832438273','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5689,'XYZ-1768195187051-E84DCB22',1,NULL,'IN_STOCK','GRN','XYZ840644393','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5690,'XYZ-1768195187075-6E4C349C',1,NULL,'IN_STOCK','GRN','XYZ306011950','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5691,'XYZ-1768195187096-F4B77CA2',1,NULL,'IN_STOCK','GRN','XYZ106367767','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5692,'XYZ-1768195187118-6512AE75',1,NULL,'IN_STOCK','GRN','XYZ981686673','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5693,'XYZ-1768195187140-B1210091',1,NULL,'IN_STOCK','GRN','XYZ647913488','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5694,'XYZ-1768195187161-FB631765',1,NULL,'IN_STOCK','GRN','XYZ215888072','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5695,'XYZ-1768195187182-8AFD735D',1,NULL,'IN_STOCK','GRN','XYZ462053167','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5696,'XYZ-1768195187203-DB02DCC2',1,NULL,'IN_STOCK','GRN','XYZ126470849','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5697,'XYZ-1768195187225-BFD20D4E',1,NULL,'IN_STOCK','GRN','XYZ130763943','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5698,'XYZ-1768195187249-51ECB95A',1,NULL,'IN_STOCK','GRN','XYZ499107539','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5699,'XYZ-1768195187272-55E515C9',1,NULL,'IN_STOCK','GRN','XYZ821022218','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5700,'XYZ-1768195187293-8C63BA9E',1,NULL,'IN_STOCK','GRN','XYZ712063206','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5701,'XYZ-1768195187315-3AFDE3BA',1,NULL,'IN_STOCK','GRN','XYZ228828593','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5702,'XYZ-1768195187336-135CD5DE',1,NULL,'IN_STOCK','GRN','XYZ801647932','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5703,'XYZ-1768195187359-4F989A95',1,NULL,'IN_STOCK','GRN','XYZ309698190','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5704,'XYZ-1768195187379-4B07ECB2',1,NULL,'IN_STOCK','GRN','XYZ674458287','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5705,'XYZ-1768195187402-7DD40B90',1,NULL,'IN_STOCK','GRN','XYZ708736221','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5706,'XYZ-1768195187425-8FBE77DC',1,NULL,'IN_STOCK','GRN','XYZ446403791','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5707,'XYZ-1768195187451-8595A4BA',1,NULL,'IN_STOCK','GRN','XYZ495499578','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5708,'XYZ-1768195187476-BE302B28',1,NULL,'IN_STOCK','GRN','XYZ718032685','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5709,'XYZ-1768195187501-D38EF0BE',1,NULL,'IN_STOCK','GRN','XYZ755890254','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5710,'XYZ-1768195187525-B9B7665E',1,NULL,'IN_STOCK','GRN','XYZ900466867','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5711,'XYZ-1768195187551-DB794E76',1,NULL,'IN_STOCK','GRN','XYZ175654893','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5712,'XYZ-1768195187573-0E4CA0B0',1,NULL,'IN_STOCK','GRN','XYZ204829811','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5713,'XYZ-1768195187596-6164D9B8',1,NULL,'IN_STOCK','GRN','XYZ719827250','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5714,'XYZ-1768195187614-40A9B732',1,NULL,'IN_STOCK','GRN','XYZ213605609','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5715,'XYZ-1768195187636-31A9292F',1,NULL,'IN_STOCK','GRN','XYZ691225319','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5716,'XYZ-1768195187661-5282D2BE',1,NULL,'IN_STOCK','GRN','XYZ682386774','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5717,'XYZ-1768195187684-EAE9A785',1,NULL,'IN_STOCK','GRN','XYZ850843641','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5718,'XYZ-1768195187707-7D6AB550',1,NULL,'IN_STOCK','GRN','XYZ032737791','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5719,'XYZ-1768195187731-13DA55BD',1,NULL,'IN_STOCK','GRN','XYZ482750018','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5720,'XYZ-1768195187754-B008F7A5',1,NULL,'IN_STOCK','GRN','XYZ731345150','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5721,'XYZ-1768195187779-D3B9B421',1,NULL,'IN_STOCK','GRN','XYZ359932972','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5722,'XYZ-1768195187806-2A4B4D66',1,NULL,'IN_STOCK','GRN','XYZ411042875','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5723,'XYZ-1768195187828-270C26A8',1,NULL,'IN_STOCK','GRN','XYZ013419534','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5724,'XYZ-1768195187851-7E602AD3',1,NULL,'IN_STOCK','GRN','XYZ008984614','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5725,'XYZ-1768195187877-2C836895',1,NULL,'IN_STOCK','GRN','XYZ515107692','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5726,'XYZ-1768195187902-E488930A',1,NULL,'IN_STOCK','GRN','XYZ819819606','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5727,'XYZ-1768195187929-B999CBB8',1,NULL,'IN_STOCK','GRN','XYZ313767672','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5728,'XYZ-1768195187956-C894A962',1,NULL,'IN_STOCK','GRN','XYZ707881236','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5729,'XYZ-1768195187982-B28CA564',1,NULL,'IN_STOCK','GRN','XYZ754972236','2026-01-12 05:19:47','2026-01-12 05:19:47'),(5730,'XYZ-1768195188009-1F8D2369',1,NULL,'IN_STOCK','GRN','XYZ998153632','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5731,'XYZ-1768195188036-38948BA3',1,NULL,'IN_STOCK','GRN','XYZ215827946','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5732,'XYZ-1768195188062-5697A12B',1,NULL,'IN_STOCK','GRN','XYZ672397660','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5733,'XYZ-1768195188089-DF0E1E03',1,NULL,'IN_STOCK','GRN','XYZ996421026','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5734,'XYZ-1768195188114-328C70BA',1,NULL,'IN_STOCK','GRN','XYZ082953962','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5735,'XYZ-1768195188135-3B5822D6',1,NULL,'IN_STOCK','GRN','XYZ225936511','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5736,'XYZ-1768195188156-BC2BB907',1,NULL,'IN_STOCK','GRN','XYZ913131328','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5737,'XYZ-1768195188180-C3DEC0B1',1,NULL,'IN_STOCK','GRN','XYZ933839350','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5738,'XYZ-1768195188207-D418497F',1,NULL,'IN_STOCK','GRN','XYZ325616280','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5739,'XYZ-1768195188233-BF3FC071',1,NULL,'IN_STOCK','GRN','XYZ091634710','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5740,'XYZ-1768195188256-53D51A98',1,NULL,'IN_STOCK','GRN','XYZ381153124','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5741,'XYZ-1768195188281-5E376801',1,NULL,'IN_STOCK','GRN','XYZ547110912','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5742,'XYZ-1768195188307-14551455',1,NULL,'IN_STOCK','GRN','XYZ344326477','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5743,'XYZ-1768195188336-A75F4633',1,NULL,'IN_STOCK','GRN','XYZ739854816','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5744,'XYZ-1768195188364-F1332D82',1,NULL,'IN_STOCK','GRN','XYZ854282408','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5745,'XYZ-1768195188387-1057D458',1,NULL,'IN_STOCK','GRN','XYZ689518671','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5746,'XYZ-1768195188415-D95FF414',1,NULL,'IN_STOCK','GRN','XYZ770649157','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5747,'XYZ-1768195188441-DEF6A8A8',1,NULL,'IN_STOCK','GRN','XYZ451968553','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5748,'XYZ-1768195188468-291AC070',1,NULL,'IN_STOCK','GRN','XYZ035749286','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5749,'XYZ-1768195188491-75B9018D',1,NULL,'IN_STOCK','GRN','XYZ062026316','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5750,'XYZ-1768195188517-F347E70D',1,NULL,'IN_STOCK','GRN','XYZ296060121','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5751,'XYZ-1768195188543-E7587856',1,NULL,'IN_STOCK','GRN','XYZ303135876','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5752,'XYZ-1768195188563-A1DC8EE7',1,NULL,'IN_STOCK','GRN','XYZ581768104','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5753,'XYZ-1768195188581-9051E42A',1,NULL,'IN_STOCK','GRN','XYZ300801942','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5754,'XYZ-1768195188601-C2FA36CD',1,NULL,'IN_STOCK','GRN','XYZ191925753','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5755,'XYZ-1768195188622-6B96F9E5',1,NULL,'IN_STOCK','GRN','XYZ992543042','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5756,'XYZ-1768195188644-AEB04ACE',1,NULL,'IN_STOCK','GRN','XYZ843540799','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5757,'XYZ-1768195188665-6CAF6AAF',1,NULL,'IN_STOCK','GRN','XYZ441603582','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5758,'XYZ-1768195188687-0B607019',1,NULL,'IN_STOCK','GRN','XYZ820217426','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5759,'XYZ-1768195188708-A3F7487F',1,NULL,'IN_STOCK','GRN','XYZ884087116','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5760,'XYZ-1768195188730-42ED4DA5',1,NULL,'IN_STOCK','GRN','XYZ420536320','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5761,'XYZ-1768195188751-01B44648',1,NULL,'IN_STOCK','GRN','XYZ212563961','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5762,'XYZ-1768195188773-048B9004',1,NULL,'IN_STOCK','GRN','XYZ555830577','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5763,'XYZ-1768195188795-9A84C8D5',1,NULL,'IN_STOCK','GRN','XYZ708878404','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5764,'XYZ-1768195188817-D06823F6',1,NULL,'IN_STOCK','GRN','XYZ768896222','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5765,'XYZ-1768195188839-CF464510',1,NULL,'IN_STOCK','GRN','XYZ065100476','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5766,'XYZ-1768195188861-F0940558',1,NULL,'IN_STOCK','GRN','XYZ481083593','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5767,'XYZ-1768195188886-7132D658',1,NULL,'IN_STOCK','GRN','XYZ373857284','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5768,'XYZ-1768195188910-6E57038B',1,NULL,'IN_STOCK','GRN','XYZ616552319','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5769,'XYZ-1768195188932-453104E6',1,NULL,'IN_STOCK','GRN','XYZ671317984','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5770,'XYZ-1768195188954-48B0141A',1,NULL,'IN_STOCK','GRN','XYZ302367267','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5771,'XYZ-1768195188978-A8F41B58',1,NULL,'IN_STOCK','GRN','XYZ124119755','2026-01-12 05:19:48','2026-01-12 05:19:48'),(5772,'XYZ-1768195189005-712B2446',1,NULL,'IN_STOCK','GRN','XYZ593222829','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5773,'XYZ-1768195189032-5E89310D',1,NULL,'IN_STOCK','GRN','XYZ193940487','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5774,'XYZ-1768195189059-87AB254E',1,NULL,'IN_STOCK','GRN','XYZ398770183','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5775,'XYZ-1768195189087-2392DC5B',1,NULL,'IN_STOCK','GRN','XYZ847222514','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5776,'XYZ-1768195189114-201F4ADA',1,NULL,'IN_STOCK','GRN','XYZ238073290','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5777,'XYZ-1768195189141-5F147950',1,NULL,'IN_STOCK','GRN','XYZ806931277','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5778,'XYZ-1768195189169-5EB78991',1,NULL,'IN_STOCK','GRN','XYZ086558567','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5779,'XYZ-1768195189198-74FECB06',1,NULL,'IN_STOCK','GRN','XYZ316587393','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5780,'XYZ-1768195189245-394CA844',1,NULL,'IN_STOCK','GRN','XYZ491416362','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5782,'XYZ-1768195189277-D2EB23D4',1,NULL,'IN_STOCK','GRN','XYZ842491358','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5783,'XYZ-1768195189299-1481AE4E',1,NULL,'IN_STOCK','GRN','XYZ532676244','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5784,'XYZ-1768195189321-B44C0A65',1,NULL,'IN_STOCK','GRN','XYZ416849876','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5785,'XYZ-1768195189344-9DC6A092',1,NULL,'IN_STOCK','GRN','XYZ742711348','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5786,'XYZ-1768195189369-DC505324',1,NULL,'IN_STOCK','GRN','XYZ851485973','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5787,'XYZ-1768195189397-C3F73073',1,NULL,'IN_STOCK','GRN','XYZ534771315','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5788,'XYZ-1768195189423-8445060B',1,NULL,'IN_STOCK','GRN','XYZ684061287','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5789,'XYZ-1768195189445-E4C708D6',1,NULL,'IN_STOCK','GRN','XYZ295432141','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5790,'XYZ-1768195189467-30D5149B',1,NULL,'IN_STOCK','GRN','XYZ690717855','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5791,'XYZ-1768195189489-2733E116',1,NULL,'IN_STOCK','GRN','XYZ876503718','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5792,'XYZ-1768195189511-2BAB24A5',1,NULL,'IN_STOCK','GRN','XYZ240936806','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5793,'XYZ-1768195189532-B5EB4D73',1,NULL,'IN_STOCK','GRN','XYZ036362150','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5794,'XYZ-1768195189554-6689154C',1,NULL,'IN_STOCK','GRN','XYZ213815094','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5795,'XYZ-1768195189576-C9451FA8',1,NULL,'IN_STOCK','GRN','XYZ114866511','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5796,'XYZ-1768195189597-4EEE0B07',1,NULL,'IN_STOCK','GRN','XYZ350957446','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5797,'XYZ-1768195189621-9784771F',1,NULL,'IN_STOCK','GRN','XYZ021682411','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5798,'XYZ-1768195189642-6C396973',1,NULL,'IN_STOCK','GRN','XYZ908731187','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5799,'XYZ-1768195189665-0E1B707A',1,NULL,'IN_STOCK','GRN','XYZ542787957','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5800,'XYZ-1768195189687-88402BC8',1,NULL,'IN_STOCK','GRN','XYZ983459782','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5801,'XYZ-1768195189708-D72C3A5A',1,NULL,'IN_STOCK','GRN','XYZ782271709','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5802,'XYZ-1768195189730-396BA229',1,NULL,'IN_STOCK','GRN','XYZ446910650','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5803,'XYZ-1768195189754-29F96BCE',1,NULL,'IN_STOCK','GRN','XYZ588375470','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5804,'XYZ-1768195189776-0675AE3D',1,NULL,'IN_STOCK','GRN','XYZ597184596','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5805,'XYZ-1768195189798-73F12EC6',1,NULL,'IN_STOCK','GRN','XYZ819505199','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5806,'XYZ-1768195189821-A7026777',1,NULL,'IN_STOCK','GRN','XYZ174278393','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5807,'XYZ-1768195189843-D7E3F75D',1,NULL,'IN_STOCK','GRN','XYZ765307399','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5808,'XYZ-1768195189867-29E83740',1,NULL,'IN_STOCK','GRN','XYZ704558653','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5809,'XYZ-1768195189888-E21F6B1A',1,NULL,'IN_STOCK','GRN','XYZ423854006','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5810,'XYZ-1768195189909-269ED93E',1,NULL,'IN_STOCK','GRN','XYZ104299397','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5811,'XYZ-1768195189931-AD9ADF9C',1,NULL,'IN_STOCK','GRN','XYZ562735664','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5812,'XYZ-1768195189952-A8FE4127',1,NULL,'IN_STOCK','GRN','XYZ332059487','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5813,'XYZ-1768195189974-DA8AB7E2',1,NULL,'IN_STOCK','GRN','XYZ987249162','2026-01-12 05:19:49','2026-01-12 05:19:49'),(5814,'XYZ-1768195189996-72F56FD8',1,NULL,'IN_STOCK','GRN','XYZ298984038','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5815,'XYZ-1768195190019-86E2F065',1,NULL,'IN_STOCK','GRN','XYZ034266081','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5816,'XYZ-1768195190042-3C7947D9',1,NULL,'IN_STOCK','GRN','XYZ262356880','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5817,'XYZ-1768195190063-01B32F6E',1,NULL,'IN_STOCK','GRN','XYZ210986553','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5818,'XYZ-1768195190085-3A066828',1,NULL,'IN_STOCK','GRN','XYZ916178062','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5819,'XYZ-1768195190106-3F9CC4DF',1,NULL,'IN_STOCK','GRN','XYZ570313728','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5820,'XYZ-1768195190128-4364C891',1,NULL,'IN_STOCK','GRN','XYZ596178874','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5821,'XYZ-1768195190149-70961215',1,NULL,'IN_STOCK','GRN','XYZ807660909','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5822,'XYZ-1768195190171-312236D4',1,NULL,'IN_STOCK','GRN','XYZ258809337','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5823,'XYZ-1768195190192-194E0B7D',1,NULL,'IN_STOCK','GRN','XYZ408996092','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5824,'XYZ-1768195190213-6DB1F05A',1,NULL,'IN_STOCK','GRN','XYZ812643048','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5825,'XYZ-1768195190235-704EEE71',1,NULL,'IN_STOCK','GRN','XYZ343011609','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5826,'XYZ-1768195190256-A43B3926',1,NULL,'IN_STOCK','GRN','XYZ121826481','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5827,'XYZ-1768195190281-2C7CDC85',1,NULL,'IN_STOCK','GRN','XYZ006266747','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5828,'XYZ-1768195190306-2C3AB1E1',1,NULL,'IN_STOCK','GRN','XYZ984357463','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5829,'XYZ-1768195190327-CD6A42B3',1,NULL,'IN_STOCK','GRN','XYZ261607256','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5830,'XYZ-1768195190346-0D90D984',1,NULL,'IN_STOCK','GRN','XYZ688307647','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5831,'XYZ-1768195190369-FA3D3F5B',1,NULL,'IN_STOCK','GRN','XYZ628632345','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5832,'XYZ-1768195190393-54F1B9A7',1,NULL,'IN_STOCK','GRN','XYZ583513679','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5833,'XYZ-1768195190415-14493C7B',1,NULL,'IN_STOCK','GRN','XYZ902998068','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5834,'XYZ-1768195190435-7BA0526F',1,NULL,'IN_STOCK','GRN','XYZ470223550','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5835,'XYZ-1768195190458-18F37C9D',1,NULL,'IN_STOCK','GRN','XYZ371491521','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5836,'XYZ-1768195190482-CEA0616F',1,NULL,'IN_STOCK','GRN','XYZ973596437','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5837,'XYZ-1768195190506-6529EF51',1,NULL,'IN_STOCK','GRN','XYZ753342199','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5838,'XYZ-1768195190527-9EDE91B2',1,NULL,'IN_STOCK','GRN','XYZ014871505','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5839,'XYZ-1768195190550-9C2FF2FC',1,NULL,'IN_STOCK','GRN','XYZ768167976','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5840,'XYZ-1768195190571-0FDDF91D',1,NULL,'IN_STOCK','GRN','XYZ013507338','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5841,'XYZ-1768195190592-D6A1E31A',1,NULL,'IN_STOCK','GRN','XYZ886413353','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5842,'XYZ-1768195190615-0A66BC3A',1,NULL,'IN_STOCK','GRN','XYZ138113708','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5843,'XYZ-1768195190637-0828CA4B',1,NULL,'IN_STOCK','GRN','XYZ338028739','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5844,'XYZ-1768195190658-5FE4D934',1,NULL,'IN_STOCK','GRN','XYZ134906928','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5845,'XYZ-1768195190679-1020F31D',1,NULL,'IN_STOCK','GRN','XYZ957482994','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5846,'XYZ-1768195190701-00C74CAB',1,NULL,'IN_STOCK','GRN','XYZ007231216','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5847,'XYZ-1768195190722-B30D0861',1,NULL,'IN_STOCK','GRN','XYZ798300888','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5848,'XYZ-1768195190747-65129E99',1,NULL,'IN_STOCK','GRN','XYZ255164569','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5849,'XYZ-1768195190772-8235DD64',1,NULL,'IN_STOCK','GRN','XYZ664886612','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5850,'XYZ-1768195190796-920B0278',1,NULL,'IN_STOCK','GRN','XYZ501441409','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5851,'XYZ-1768195190821-F040FD30',1,NULL,'IN_STOCK','GRN','XYZ816993472','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5852,'XYZ-1768195190845-B61BEC69',1,NULL,'IN_STOCK','GRN','XYZ117060458','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5853,'XYZ-1768195190868-B6C4E846',1,NULL,'IN_STOCK','GRN','XYZ140901077','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5854,'XYZ-1768195190892-FF070C0E',1,NULL,'IN_STOCK','GRN','XYZ018507389','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5855,'XYZ-1768195190914-A4D57EFA',1,NULL,'IN_STOCK','GRN','XYZ597162571','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5856,'XYZ-1768195190938-AA3149ED',1,NULL,'IN_STOCK','GRN','XYZ357585642','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5857,'XYZ-1768195190965-221D1F8B',1,NULL,'IN_STOCK','GRN','XYZ720184979','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5858,'XYZ-1768195190988-0CB97782',1,NULL,'IN_STOCK','GRN','XYZ216856816','2026-01-12 05:19:50','2026-01-12 05:19:50'),(5859,'XYZ-1768195191010-72B35246',1,NULL,'IN_STOCK','GRN','XYZ916548418','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5860,'XYZ-1768195191031-EDD19AE4',1,NULL,'IN_STOCK','GRN','XYZ176019780','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5861,'XYZ-1768195191052-A956C593',1,NULL,'IN_STOCK','GRN','XYZ387506680','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5862,'XYZ-1768195191074-4B50C397',1,NULL,'IN_STOCK','GRN','XYZ568542107','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5863,'XYZ-1768195191094-F9594F82',1,NULL,'IN_STOCK','GRN','XYZ738779581','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5864,'XYZ-1768195191115-0A7B1DE6',1,NULL,'IN_STOCK','GRN','XYZ868272060','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5865,'XYZ-1768195191137-6DE979C7',1,NULL,'IN_STOCK','GRN','XYZ136635334','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5866,'XYZ-1768195191158-EB2481C0',1,NULL,'IN_STOCK','GRN','XYZ595683025','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5867,'XYZ-1768195191179-703A8A5F',1,NULL,'IN_STOCK','GRN','XYZ815691759','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5868,'XYZ-1768195191200-640B12DE',1,NULL,'IN_STOCK','GRN','XYZ384384175','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5869,'XYZ-1768195191222-56EB39BA',1,NULL,'IN_STOCK','GRN','XYZ925969406','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5870,'XYZ-1768195191242-5ED213F4',1,NULL,'IN_STOCK','GRN','XYZ254744741','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5871,'XYZ-1768195191263-31938524',1,NULL,'IN_STOCK','GRN','XYZ347558102','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5872,'XYZ-1768195191284-D3E0931B',1,NULL,'IN_STOCK','GRN','XYZ181447531','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5873,'XYZ-1768195191305-F4612BBF',1,NULL,'IN_STOCK','GRN','XYZ939350191','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5874,'XYZ-1768195191326-3DFD1349',1,NULL,'IN_STOCK','GRN','XYZ046490530','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5875,'XYZ-1768195191347-7F315E81',1,NULL,'IN_STOCK','GRN','XYZ688544904','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5876,'XYZ-1768195191368-451218D5',1,NULL,'IN_STOCK','GRN','XYZ333662382','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5877,'XYZ-1768195191390-630F761D',1,NULL,'IN_STOCK','GRN','XYZ178005669','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5878,'XYZ-1768195191411-FC01EC04',1,NULL,'IN_STOCK','GRN','XYZ995072188','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5879,'XYZ-1768195191431-907D0D41',1,NULL,'IN_STOCK','GRN','XYZ685691295','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5880,'XYZ-1768195191452-AA99CCC1',1,NULL,'IN_STOCK','GRN','XYZ378168725','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5881,'XYZ-1768195191473-BC3D15A3',1,NULL,'IN_STOCK','GRN','XYZ713057217','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5882,'XYZ-1768195191495-095512B7',1,NULL,'IN_STOCK','GRN','XYZ152537935','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5883,'XYZ-1768195191516-F69FBE8F',1,NULL,'IN_STOCK','GRN','XYZ301360709','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5884,'XYZ-1768195191537-1CB3E1DA',1,NULL,'IN_STOCK','GRN','XYZ831732600','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5885,'XYZ-1768195191559-8598C5BF',1,NULL,'IN_STOCK','GRN','XYZ774771377','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5886,'XYZ-1768195191580-D7907467',1,NULL,'IN_STOCK','GRN','XYZ497625521','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5887,'XYZ-1768195191601-F58DB5BB',1,NULL,'IN_STOCK','GRN','XYZ829898765','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5888,'XYZ-1768195191623-CF311D6C',1,NULL,'IN_STOCK','GRN','XYZ231035657','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5889,'XYZ-1768195191644-6A078F13',1,NULL,'IN_STOCK','GRN','XYZ446679665','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5890,'XYZ-1768195191669-347E1641',1,NULL,'IN_STOCK','GRN','XYZ437387365','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5891,'XYZ-1768195191694-AB29D70C',1,NULL,'IN_STOCK','GRN','XYZ385528981','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5892,'XYZ-1768195191718-339CCD41',1,NULL,'IN_STOCK','GRN','XYZ404462267','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5893,'XYZ-1768195191739-0690C6E4',1,NULL,'IN_STOCK','GRN','XYZ212400698','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5894,'XYZ-1768195191760-71AC75AC',1,NULL,'IN_STOCK','GRN','XYZ745133272','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5895,'XYZ-1768195191781-98CA8250',1,NULL,'IN_STOCK','GRN','XYZ094457336','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5896,'XYZ-1768195191803-454C9146',1,NULL,'IN_STOCK','GRN','XYZ695397148','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5897,'XYZ-1768195191824-BE82F54C',1,NULL,'IN_STOCK','GRN','XYZ882419621','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5898,'XYZ-1768195191846-053ED727',1,NULL,'IN_STOCK','GRN','XYZ599403118','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5899,'XYZ-1768195191867-2D001383',1,NULL,'IN_STOCK','GRN','XYZ531296722','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5900,'XYZ-1768195191889-127F46E6',1,NULL,'IN_STOCK','GRN','XYZ472151805','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5901,'XYZ-1768195191910-B03632A7',1,NULL,'IN_STOCK','GRN','XYZ332440215','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5902,'XYZ-1768195191933-334C95ED',1,NULL,'IN_STOCK','GRN','XYZ643053953','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5903,'XYZ-1768195191954-6E20E1EC',1,NULL,'IN_STOCK','GRN','XYZ225000236','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5904,'XYZ-1768195191976-B90D0C2D',1,NULL,'IN_STOCK','GRN','XYZ120816172','2026-01-12 05:19:51','2026-01-12 05:19:51'),(5905,'XYZ-1768195191997-AA6314C2',1,NULL,'IN_STOCK','GRN','XYZ100937276','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5906,'XYZ-1768195192018-12D10F85',1,NULL,'IN_STOCK','GRN','XYZ060976390','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5907,'XYZ-1768195192040-8BFB0FA5',1,NULL,'IN_STOCK','GRN','XYZ307176035','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5908,'XYZ-1768195192061-F5E1668E',1,NULL,'IN_STOCK','GRN','XYZ181162409','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5909,'XYZ-1768195192084-CECE5149',1,NULL,'IN_STOCK','GRN','XYZ802274665','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5910,'XYZ-1768195192106-E835BC2D',1,NULL,'IN_STOCK','GRN','XYZ123193381','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5911,'XYZ-1768195192131-5373C8FC',1,NULL,'IN_STOCK','GRN','XYZ847807293','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5912,'XYZ-1768195192155-985C88BA',1,NULL,'IN_STOCK','GRN','XYZ987446812','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5913,'XYZ-1768195192176-89592858',1,NULL,'IN_STOCK','GRN','XYZ435652052','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5914,'XYZ-1768195192197-739542A1',1,NULL,'IN_STOCK','GRN','XYZ587871196','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5915,'XYZ-1768195192219-F5B83E42',1,NULL,'IN_STOCK','GRN','XYZ162370898','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5916,'XYZ-1768195192240-274BB461',1,NULL,'IN_STOCK','GRN','XYZ064154706','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5917,'XYZ-1768195192261-4FE8A37D',1,NULL,'IN_STOCK','GRN','XYZ954452014','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5918,'XYZ-1768195192282-B316B93A',1,NULL,'IN_STOCK','GRN','XYZ138387534','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5919,'XYZ-1768195192304-6F8183D1',1,NULL,'IN_STOCK','GRN','XYZ677999195','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5920,'XYZ-1768195192326-1ECB0296',1,NULL,'IN_STOCK','GRN','XYZ932397052','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5921,'XYZ-1768195192347-F7D5F5B1',1,NULL,'IN_STOCK','GRN','XYZ684523930','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5922,'XYZ-1768195192368-1A7D7C2C',1,NULL,'IN_STOCK','GRN','XYZ043089543','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5923,'XYZ-1768195192390-C501D886',1,NULL,'IN_STOCK','GRN','XYZ493943554','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5924,'XYZ-1768195192414-5F4E75C1',1,NULL,'IN_STOCK','GRN','XYZ626921872','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5925,'XYZ-1768195192441-D261CF2B',1,NULL,'IN_STOCK','GRN','XYZ137658475','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5926,'XYZ-1768195192464-8A71CCF5',1,NULL,'IN_STOCK','GRN','XYZ278331847','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5927,'XYZ-1768195192486-AE6442AE',1,NULL,'IN_STOCK','GRN','XYZ685200904','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5928,'XYZ-1768195192507-9D67DFAD',1,NULL,'IN_STOCK','GRN','XYZ234704474','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5929,'XYZ-1768195192528-0016FE14',1,NULL,'IN_STOCK','GRN','XYZ926721154','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5930,'XYZ-1768195192553-CEA46AF0',1,NULL,'IN_STOCK','GRN','XYZ682091653','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5931,'XYZ-1768195192574-3D9DC7E7',1,NULL,'IN_STOCK','GRN','XYZ380592600','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5932,'XYZ-1768195192596-B162AE56',1,NULL,'IN_STOCK','GRN','XYZ100627045','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5933,'XYZ-1768195192618-C5BB592E',1,NULL,'IN_STOCK','GRN','XYZ166543879','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5934,'XYZ-1768195192642-8BF98CA5',1,NULL,'IN_STOCK','GRN','XYZ595576811','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5935,'XYZ-1768195192663-831D098C',1,NULL,'IN_STOCK','GRN','XYZ954655283','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5936,'XYZ-1768195192684-0AA128C9',1,NULL,'IN_STOCK','GRN','XYZ254932186','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5937,'XYZ-1768195192704-127CE718',1,NULL,'IN_STOCK','GRN','XYZ223404472','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5938,'XYZ-1768195192727-B9F253E6',1,NULL,'IN_STOCK','GRN','XYZ331717035','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5939,'XYZ-1768195192751-712219DF',1,NULL,'IN_STOCK','GRN','XYZ569356201','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5940,'XYZ-1768195192775-6D8BF353',1,NULL,'IN_STOCK','GRN','XYZ810071115','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5941,'XYZ-1768195192800-2431CC5F',1,NULL,'IN_STOCK','GRN','XYZ434709095','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5942,'XYZ-1768195192823-48317427',1,NULL,'IN_STOCK','GRN','XYZ894548090','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5943,'XYZ-1768195192844-3D7028D1',1,NULL,'IN_STOCK','GRN','XYZ296343774','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5944,'XYZ-1768195192866-1E913EC9',1,NULL,'IN_STOCK','GRN','XYZ599208023','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5945,'XYZ-1768195192887-0C4B9E1B',1,NULL,'IN_STOCK','GRN','XYZ276300380','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5946,'XYZ-1768195192908-1FB7B1B3',1,NULL,'IN_STOCK','GRN','XYZ611871989','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5947,'XYZ-1768195192933-15FA1B43',1,NULL,'IN_STOCK','GRN','XYZ687016422','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5948,'XYZ-1768195192955-80D93406',1,NULL,'IN_STOCK','GRN','XYZ905238965','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5949,'XYZ-1768195192976-378ADBC7',1,NULL,'IN_STOCK','GRN','XYZ535997600','2026-01-12 05:19:52','2026-01-12 05:19:52'),(5950,'XYZ-1768195192998-65874003',1,NULL,'IN_STOCK','GRN','XYZ227190295','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5951,'XYZ-1768195193019-DAF740F0',1,NULL,'IN_STOCK','GRN','XYZ450094789','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5952,'XYZ-1768195193041-1164F310',1,NULL,'IN_STOCK','GRN','XYZ836243703','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5953,'XYZ-1768195193063-09CE07F1',1,NULL,'IN_STOCK','GRN','XYZ775224731','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5954,'XYZ-1768195193085-484B71D8',1,NULL,'IN_STOCK','GRN','XYZ984166255','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5955,'XYZ-1768195193106-E1016FED',1,NULL,'IN_STOCK','GRN','XYZ217098002','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5956,'XYZ-1768195193127-5C2766BF',1,NULL,'IN_STOCK','GRN','XYZ862506397','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5957,'XYZ-1768195193148-DAAB036A',1,NULL,'IN_STOCK','GRN','XYZ044866427','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5958,'XYZ-1768195193169-7D8DD66D',1,NULL,'IN_STOCK','GRN','XYZ654622368','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5959,'XYZ-1768195193191-88039A71',1,NULL,'IN_STOCK','GRN','XYZ685910941','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5960,'XYZ-1768195193212-81EC79C8',1,NULL,'IN_STOCK','GRN','XYZ988180036','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5961,'XYZ-1768195193233-8829BC02',1,NULL,'IN_STOCK','GRN','XYZ490055582','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5962,'XYZ-1768195193254-3986F2B9',1,NULL,'IN_STOCK','GRN','XYZ733252910','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5963,'XYZ-1768195193275-05DF726B',1,NULL,'IN_STOCK','GRN','XYZ452560985','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5964,'XYZ-1768195193297-704B4779',1,NULL,'IN_STOCK','GRN','XYZ788570404','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5965,'XYZ-1768195193318-9D13397D',1,NULL,'IN_STOCK','GRN','XYZ151061369','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5966,'XYZ-1768195193340-6A40FE2D',1,NULL,'IN_STOCK','GRN','XYZ896841292','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5967,'XYZ-1768195193361-8E7B1679',1,NULL,'IN_STOCK','GRN','XYZ285663192','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5968,'XYZ-1768195193383-AEC24402',1,NULL,'IN_STOCK','GRN','XYZ055893973','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5969,'XYZ-1768195193406-95B120E1',1,NULL,'IN_STOCK','GRN','XYZ762001218','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5970,'XYZ-1768195193429-46A6F3D9',1,NULL,'IN_STOCK','GRN','XYZ509876407','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5971,'XYZ-1768195193452-F662C9B5',1,NULL,'IN_STOCK','GRN','XYZ147726582','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5972,'XYZ-1768195193473-8338B097',1,NULL,'IN_STOCK','GRN','XYZ513505356','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5973,'XYZ-1768195193494-0C8909F3',1,NULL,'IN_STOCK','GRN','XYZ499989849','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5974,'XYZ-1768195193515-B1EBA8FD',1,NULL,'IN_STOCK','GRN','XYZ544142302','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5975,'XYZ-1768195193536-595B3FEF',1,NULL,'IN_STOCK','GRN','XYZ686153335','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5976,'XYZ-1768195193557-AF0527CF',1,NULL,'IN_STOCK','GRN','XYZ369016585','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5977,'XYZ-1768195193580-26C89FF6',1,NULL,'IN_STOCK','GRN','XYZ381655641','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5978,'XYZ-1768195193602-578272E4',1,NULL,'IN_STOCK','GRN','XYZ882290705','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5979,'XYZ-1768195193628-8641986B',1,NULL,'IN_STOCK','GRN','XYZ124247267','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5980,'XYZ-1768195193653-886FD54A',1,NULL,'IN_STOCK','GRN','XYZ208553647','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5981,'XYZ-1768195193674-5BE07E20',1,NULL,'IN_STOCK','GRN','XYZ100741052','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5982,'XYZ-1768195193697-7E3F8B8F',1,NULL,'IN_STOCK','GRN','XYZ781400310','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5983,'XYZ-1768195193722-417E6D33',1,NULL,'IN_STOCK','GRN','XYZ519055286','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5984,'XYZ-1768195193748-52B62657',1,NULL,'IN_STOCK','GRN','XYZ215413151','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5985,'XYZ-1768195193772-5C7B02CE',1,NULL,'IN_STOCK','GRN','XYZ190524400','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5986,'XYZ-1768195193792-99D15C99',1,NULL,'IN_STOCK','GRN','XYZ409647993','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5987,'XYZ-1768195193812-C91271D9',1,NULL,'IN_STOCK','GRN','XYZ259192002','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5988,'XYZ-1768195193833-2BCCD7AB',1,NULL,'IN_STOCK','GRN','XYZ876845931','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5989,'XYZ-1768195193855-D6BE59F1',1,NULL,'IN_STOCK','GRN','XYZ580944563','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5990,'XYZ-1768195193876-266F5583',1,NULL,'IN_STOCK','GRN','XYZ954876005','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5991,'XYZ-1768195193898-C7366266',1,NULL,'IN_STOCK','GRN','XYZ297297379','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5992,'XYZ-1768195193919-932C0BEA',1,NULL,'IN_STOCK','GRN','XYZ882236760','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5993,'XYZ-1768195193940-240BEF59',1,NULL,'IN_STOCK','GRN','XYZ884988344','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5994,'XYZ-1768195193961-5A2071F9',1,NULL,'IN_STOCK','GRN','XYZ015536427','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5995,'XYZ-1768195193983-678785C6',1,NULL,'IN_STOCK','GRN','XYZ939538844','2026-01-12 05:19:53','2026-01-12 05:19:53'),(5996,'XYZ-1768195194005-FDA7FDC1',1,NULL,'IN_STOCK','GRN','XYZ199385017','2026-01-12 05:19:54','2026-01-12 05:19:54'),(5997,'XYZ-1768195194026-CB322930',1,NULL,'IN_STOCK','GRN','XYZ706430967','2026-01-12 05:19:54','2026-01-12 05:19:54'),(5998,'XYZ-1768195194047-E029302F',1,NULL,'IN_STOCK','GRN','XYZ871735340','2026-01-12 05:19:54','2026-01-12 05:19:54'),(5999,'XYZ-1768195194068-BBB2FFBB',1,NULL,'IN_STOCK','GRN','XYZ768085829','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6000,'XYZ-1768195194092-A8585569',1,NULL,'IN_STOCK','GRN','XYZ299999396','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6001,'XYZ-1768195194113-8BDE3241',1,NULL,'IN_STOCK','GRN','XYZ328099472','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6002,'XYZ-1768195194133-ED6E922A',1,NULL,'IN_STOCK','GRN','XYZ825457072','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6003,'XYZ-1768195194154-E716D707',1,NULL,'IN_STOCK','GRN','XYZ738913207','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6004,'XYZ-1768195194176-01028673',1,NULL,'IN_STOCK','GRN','XYZ233242790','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6005,'XYZ-1768195194197-E60825EC',1,NULL,'IN_STOCK','GRN','XYZ700905824','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6006,'XYZ-1768195194218-E180B95A',1,NULL,'IN_STOCK','GRN','XYZ232798182','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6007,'XYZ-1768195194241-E499E08A',1,NULL,'IN_STOCK','GRN','XYZ732447767','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6008,'XYZ-1768195194262-10F3FAB6',1,NULL,'IN_STOCK','GRN','XYZ059461302','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6009,'XYZ-1768195194283-74741CF5',1,NULL,'IN_STOCK','GRN','XYZ972147857','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6010,'XYZ-1768195194308-D8A4FE4F',1,NULL,'IN_STOCK','GRN','XYZ552903470','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6011,'XYZ-1768195194331-A7E1A9C8',1,NULL,'IN_STOCK','GRN','XYZ492639308','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6012,'XYZ-1768195194356-BAEC5A81',1,NULL,'IN_STOCK','GRN','XYZ348564704','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6013,'XYZ-1768195194378-73950341',1,NULL,'IN_STOCK','GRN','XYZ288046053','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6014,'XYZ-1768195194398-3727A67D',1,NULL,'IN_STOCK','GRN','XYZ763948777','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6015,'XYZ-1768195194419-52F713E4',1,NULL,'IN_STOCK','GRN','XYZ263091300','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6016,'XYZ-1768195194442-11EB71F8',1,NULL,'IN_STOCK','GRN','XYZ479638096','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6017,'XYZ-1768195194463-92045FF8',1,NULL,'IN_STOCK','GRN','XYZ680627178','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6018,'XYZ-1768195194487-F8020624',1,NULL,'IN_STOCK','GRN','XYZ543396756','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6019,'XYZ-1768195194511-CE15F3DD',1,NULL,'IN_STOCK','GRN','XYZ983097776','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6020,'XYZ-1768195194534-6D4E31FC',1,NULL,'IN_STOCK','GRN','XYZ686524614','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6021,'XYZ-1768195194557-875194A1',1,NULL,'IN_STOCK','GRN','XYZ517205931','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6022,'XYZ-1768195194579-2B9DDF25',1,NULL,'IN_STOCK','GRN','XYZ319714603','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6023,'XYZ-1768195194598-66CC1F90',1,NULL,'IN_STOCK','GRN','XYZ656203800','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6024,'XYZ-1768195194619-71AA1E1C',1,NULL,'IN_STOCK','GRN','XYZ663586780','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6025,'XYZ-1768195194640-4FF3395C',1,NULL,'IN_STOCK','GRN','XYZ005930907','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6026,'XYZ-1768195194661-DA174D1D',1,NULL,'IN_STOCK','GRN','XYZ759862472','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6027,'XYZ-1768195194683-C1654A20',1,NULL,'IN_STOCK','GRN','XYZ009352654','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6028,'XYZ-1768195194704-2FE6CDCD',1,NULL,'IN_STOCK','GRN','XYZ170059909','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6029,'XYZ-1768195194725-E222B1A0',1,NULL,'IN_STOCK','GRN','XYZ766918293','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6030,'XYZ-1768195194747-76FBEF39',1,NULL,'IN_STOCK','GRN','XYZ590621766','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6031,'XYZ-1768195194768-5120A26B',1,NULL,'IN_STOCK','GRN','XYZ404038691','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6032,'XYZ-1768195194789-AE9D9D11',1,NULL,'IN_STOCK','GRN','XYZ756673359','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6033,'XYZ-1768195194810-95683D44',1,NULL,'IN_STOCK','GRN','XYZ324728603','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6034,'XYZ-1768195194831-D24719B8',1,NULL,'IN_STOCK','GRN','XYZ519647490','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6035,'XYZ-1768195194853-29BE2662',1,NULL,'IN_STOCK','GRN','XYZ711876079','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6036,'XYZ-1768195194877-E50B9F7F',1,NULL,'IN_STOCK','GRN','XYZ144509922','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6037,'XYZ-1768195194900-1425836A',1,NULL,'IN_STOCK','GRN','XYZ710416931','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6038,'XYZ-1768195194921-773CA599',1,NULL,'IN_STOCK','GRN','XYZ173898189','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6039,'XYZ-1768195194942-AAAC4A58',1,NULL,'IN_STOCK','GRN','XYZ288850523','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6040,'XYZ-1768195194963-A090813B',1,NULL,'IN_STOCK','GRN','XYZ294660828','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6041,'XYZ-1768195194984-D37A06E2',1,NULL,'IN_STOCK','GRN','XYZ131655828','2026-01-12 05:19:54','2026-01-12 05:19:54'),(6042,'XYZ-1768195195005-C694479E',1,NULL,'IN_STOCK','GRN','XYZ480440862','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6043,'XYZ-1768195195026-AC195E36',1,NULL,'IN_STOCK','GRN','XYZ109588775','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6044,'XYZ-1768195195053-6027A11D',1,NULL,'IN_STOCK','GRN','XYZ599324703','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6045,'XYZ-1768195195074-E9F48497',1,NULL,'IN_STOCK','GRN','XYZ480648040','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6046,'XYZ-1768195195095-5F1204C9',1,NULL,'IN_STOCK','GRN','XYZ359562366','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6047,'XYZ-1768195195116-56F37CD9',1,NULL,'IN_STOCK','GRN','XYZ378857646','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6048,'XYZ-1768195195136-C9A0F638',1,NULL,'IN_STOCK','GRN','XYZ447251475','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6049,'XYZ-1768195195158-0120408C',1,NULL,'IN_STOCK','GRN','XYZ142064716','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6050,'XYZ-1768195195183-27A7C9CD',1,NULL,'IN_STOCK','GRN','XYZ195352124','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6051,'XYZ-1768195195206-CE965523',1,NULL,'IN_STOCK','GRN','XYZ734192929','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6052,'XYZ-1768195195227-054CAFB0',1,NULL,'IN_STOCK','GRN','XYZ063468766','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6053,'XYZ-1768195195248-2C8C3B1A',1,NULL,'IN_STOCK','GRN','XYZ760869790','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6054,'XYZ-1768195195271-0F0EE00C',1,NULL,'IN_STOCK','GRN','XYZ553943439','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6055,'XYZ-1768195195294-ED9BD188',1,NULL,'IN_STOCK','GRN','XYZ318847789','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6056,'XYZ-1768195195316-96138EC9',1,NULL,'IN_STOCK','GRN','XYZ259995057','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6057,'XYZ-1768195195337-10CE2DCA',1,NULL,'IN_STOCK','GRN','XYZ003316769','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6058,'XYZ-1768195195358-C3FB8641',1,NULL,'IN_STOCK','GRN','XYZ008542329','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6059,'XYZ-1768195195379-55DCC13E',1,NULL,'IN_STOCK','GRN','XYZ212474370','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6060,'XYZ-1768195195401-FBBC44E8',1,NULL,'IN_STOCK','GRN','XYZ432094616','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6061,'XYZ-1768195195425-124BF9B9',1,NULL,'IN_STOCK','GRN','XYZ617973777','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6062,'XYZ-1768195195450-E4A150A5',1,NULL,'IN_STOCK','GRN','XYZ543373259','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6063,'XYZ-1768195195474-9FE939CA',1,NULL,'IN_STOCK','GRN','XYZ889356706','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6064,'XYZ-1768195195496-F4D12472',1,NULL,'IN_STOCK','GRN','XYZ000116754','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6065,'XYZ-1768195195517-EB639338',1,NULL,'IN_STOCK','GRN','XYZ070461385','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6066,'XYZ-1768195195538-C3AF0C4A',1,NULL,'IN_STOCK','GRN','XYZ289750855','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6067,'XYZ-1768195195559-3AA4BB46',1,NULL,'IN_STOCK','GRN','XYZ746654737','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6068,'XYZ-1768195195580-FA6F8700',1,NULL,'IN_STOCK','GRN','XYZ527325207','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6069,'XYZ-1768195195601-17F6553E',1,NULL,'IN_STOCK','GRN','XYZ226438999','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6070,'XYZ-1768195195622-F5440112',1,NULL,'IN_STOCK','GRN','XYZ298874610','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6071,'XYZ-1768195195644-AD5578F0',1,NULL,'IN_STOCK','GRN','XYZ108812383','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6072,'XYZ-1768195195665-A6197B8E',1,NULL,'IN_STOCK','GRN','XYZ539059504','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6073,'XYZ-1768195195684-8730378E',1,NULL,'IN_STOCK','GRN','XYZ222896417','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6074,'XYZ-1768195195706-1ECFC69D',1,NULL,'IN_STOCK','GRN','XYZ590815324','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6075,'XYZ-1768195195726-0F714835',1,NULL,'IN_STOCK','GRN','XYZ086889710','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6076,'XYZ-1768195195747-12F50B48',1,NULL,'IN_STOCK','GRN','XYZ692158483','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6077,'XYZ-1768195195771-97CAD8F5',1,NULL,'IN_STOCK','GRN','XYZ040029129','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6078,'XYZ-1768195195794-80410014',1,NULL,'IN_STOCK','GRN','XYZ599966661','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6079,'XYZ-1768195195816-1EAF6C67',1,NULL,'IN_STOCK','GRN','XYZ428004264','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6080,'XYZ-1768195195839-6461C156',1,NULL,'IN_STOCK','GRN','XYZ006936426','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6081,'XYZ-1768195195860-72433FA2',1,NULL,'IN_STOCK','GRN','XYZ006411484','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6082,'XYZ-1768195195881-70FE5451',1,NULL,'IN_STOCK','GRN','XYZ069014915','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6083,'XYZ-1768195195902-298EF8D9',1,NULL,'IN_STOCK','GRN','XYZ514131495','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6084,'XYZ-1768195195924-D5B7CCB7',1,NULL,'IN_STOCK','GRN','XYZ753382602','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6085,'XYZ-1768195195945-563B4123',1,NULL,'IN_STOCK','GRN','XYZ385808960','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6086,'XYZ-1768195195966-1B54B926',1,NULL,'IN_STOCK','GRN','XYZ433358287','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6087,'XYZ-1768195195988-701D9092',1,NULL,'IN_STOCK','GRN','XYZ526785676','2026-01-12 05:19:55','2026-01-12 05:19:55'),(6088,'XYZ-1768195196009-A23E588A',1,NULL,'IN_STOCK','GRN','XYZ220312096','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6089,'XYZ-1768195196030-FA8C55BA',1,NULL,'IN_STOCK','GRN','XYZ875706835','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6090,'XYZ-1768195196051-1EA5B53E',1,NULL,'IN_STOCK','GRN','XYZ388992516','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6091,'XYZ-1768195196073-1E623A6F',1,NULL,'IN_STOCK','GRN','XYZ853503149','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6092,'XYZ-1768195196096-775F915B',1,NULL,'IN_STOCK','GRN','XYZ275463700','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6093,'XYZ-1768195196118-042855A1',1,NULL,'IN_STOCK','GRN','XYZ582206611','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6094,'XYZ-1768195196139-827C4336',1,NULL,'IN_STOCK','GRN','XYZ135213725','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6095,'XYZ-1768195196160-902B7479',1,NULL,'IN_STOCK','GRN','XYZ331505523','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6096,'XYZ-1768195196181-A7F1FF44',1,NULL,'IN_STOCK','GRN','XYZ437735083','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6097,'XYZ-1768195196201-A1639E37',1,NULL,'IN_STOCK','GRN','XYZ879116388','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6098,'XYZ-1768195196223-66A912C9',1,NULL,'IN_STOCK','GRN','XYZ001711078','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6099,'XYZ-1768195196247-7C028AE7',1,NULL,'IN_STOCK','GRN','XYZ238603932','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6100,'XYZ-1768195196270-FC9507FD',1,NULL,'IN_STOCK','GRN','XYZ325996450','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6101,'XYZ-1768195196291-989AE10F',1,NULL,'IN_STOCK','GRN','XYZ958434654','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6102,'XYZ-1768195196313-FCF723CB',1,NULL,'IN_STOCK','GRN','XYZ504567522','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6103,'XYZ-1768195196334-C1F224D5',1,NULL,'IN_STOCK','GRN','XYZ324713725','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6104,'XYZ-1768195196355-A998B119',1,NULL,'IN_STOCK','GRN','XYZ714696692','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6105,'XYZ-1768195196378-140E3ABD',1,NULL,'IN_STOCK','GRN','XYZ296733102','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6106,'XYZ-1768195196399-CCCC1B50',1,NULL,'IN_STOCK','GRN','XYZ782283330','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6107,'XYZ-1768195196421-1978A3A1',1,NULL,'IN_STOCK','GRN','XYZ610916986','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6108,'XYZ-1768195196441-79BCDC94',1,NULL,'IN_STOCK','GRN','XYZ435490159','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6109,'XYZ-1768195196463-6FB9F702',1,NULL,'IN_STOCK','GRN','XYZ167607408','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6110,'XYZ-1768195196487-8E45726F',1,NULL,'IN_STOCK','GRN','XYZ372917783','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6111,'XYZ-1768195196508-3D84BBCB',1,NULL,'IN_STOCK','GRN','XYZ086331890','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6112,'XYZ-1768195196529-4D0E81DE',1,NULL,'IN_STOCK','GRN','XYZ747876520','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6113,'XYZ-1768195196553-D8646C94',1,NULL,'IN_STOCK','GRN','XYZ489055017','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6114,'XYZ-1768195196577-EBFFDA12',1,NULL,'IN_STOCK','GRN','XYZ902912514','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6115,'XYZ-1768195196599-857B4918',1,NULL,'IN_STOCK','GRN','XYZ058991024','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6116,'XYZ-1768195196620-4FEF8C2E',1,NULL,'IN_STOCK','GRN','XYZ188420634','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6117,'XYZ-1768195196643-7C53D90E',1,NULL,'IN_STOCK','GRN','XYZ857926475','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6118,'XYZ-1768195196666-E3A475DD',1,NULL,'IN_STOCK','GRN','XYZ097424501','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6119,'XYZ-1768195196690-D3EAF2BD',1,NULL,'IN_STOCK','GRN','XYZ557577765','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6120,'XYZ-1768195196714-045595B0',1,NULL,'IN_STOCK','GRN','XYZ711875334','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6121,'XYZ-1768195196735-DD44A335',1,NULL,'IN_STOCK','GRN','XYZ250187810','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6122,'XYZ-1768195196756-8F4AAE9A',1,NULL,'IN_STOCK','GRN','XYZ818041938','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6123,'XYZ-1768195196777-0A8051C5',1,NULL,'IN_STOCK','GRN','XYZ484613648','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6124,'XYZ-1768195196797-95651B94',1,NULL,'IN_STOCK','GRN','XYZ149736111','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6125,'XYZ-1768195196818-0596AA98',1,NULL,'IN_STOCK','GRN','XYZ954151592','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6126,'XYZ-1768195196839-8196D8ED',1,NULL,'IN_STOCK','GRN','XYZ737885982','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6127,'XYZ-1768195196860-34FD1416',1,NULL,'IN_STOCK','GRN','XYZ857548887','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6128,'XYZ-1768195196882-1AB6CE51',1,NULL,'IN_STOCK','GRN','XYZ163178003','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6129,'XYZ-1768195196902-629C96DF',1,NULL,'IN_STOCK','GRN','XYZ128210285','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6130,'XYZ-1768195196923-8142FC6D',1,NULL,'IN_STOCK','GRN','XYZ403812221','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6131,'XYZ-1768195196944-BA2D7E8F',1,NULL,'IN_STOCK','GRN','XYZ238220629','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6132,'XYZ-1768195196966-55586469',1,NULL,'IN_STOCK','GRN','XYZ241543102','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6133,'XYZ-1768195196988-0419FE33',1,NULL,'IN_STOCK','GRN','XYZ603515339','2026-01-12 05:19:56','2026-01-12 05:19:56'),(6134,'XYZ-1768195197012-B617D2D6',1,NULL,'IN_STOCK','GRN','XYZ479438527','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6135,'XYZ-1768195197033-A29C2EAD',1,NULL,'IN_STOCK','GRN','XYZ289725144','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6136,'XYZ-1768195197054-B33779EB',1,NULL,'IN_STOCK','GRN','XYZ415996832','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6137,'XYZ-1768195197076-8FAA5E5A',1,NULL,'IN_STOCK','GRN','XYZ349670586','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6138,'XYZ-1768195197101-874EBBA1',1,NULL,'IN_STOCK','GRN','XYZ960350367','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6139,'XYZ-1768195197126-81E1297A',1,NULL,'IN_STOCK','GRN','XYZ299493536','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6140,'XYZ-1768195197150-E0993C41',1,NULL,'IN_STOCK','GRN','XYZ769002496','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6141,'XYZ-1768195197172-8221C022',1,NULL,'IN_STOCK','GRN','XYZ874415438','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6142,'XYZ-1768195197195-57B9F95F',1,NULL,'IN_STOCK','GRN','XYZ062870388','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6143,'XYZ-1768195197220-93FFEB8B',1,NULL,'IN_STOCK','GRN','XYZ505231536','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6144,'XYZ-1768195197244-8BF3D0B5',1,NULL,'IN_STOCK','GRN','XYZ625387453','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6145,'XYZ-1768195197265-48DA83FE',1,NULL,'IN_STOCK','GRN','XYZ509275750','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6146,'XYZ-1768195197287-DF48450B',1,NULL,'IN_STOCK','GRN','XYZ140451312','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6147,'XYZ-1768195197310-5A6E49B6',1,NULL,'IN_STOCK','GRN','XYZ004476264','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6148,'XYZ-1768195197334-9A815066',1,NULL,'IN_STOCK','GRN','XYZ649784745','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6149,'XYZ-1768195197356-68D07B32',1,NULL,'IN_STOCK','GRN','XYZ882935675','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6150,'XYZ-1768195197378-5AE660B9',1,NULL,'IN_STOCK','GRN','XYZ963299953','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6151,'XYZ-1768195197399-5E6C3E23',1,NULL,'IN_STOCK','GRN','XYZ285221977','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6152,'XYZ-1768195197419-2D2AD573',1,NULL,'IN_STOCK','GRN','XYZ803839140','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6153,'XYZ-1768195197440-0CA1FC2A',1,NULL,'IN_STOCK','GRN','XYZ331489898','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6154,'XYZ-1768195197463-024C4804',1,NULL,'IN_STOCK','GRN','XYZ959015062','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6155,'XYZ-1768195197486-644FC30A',1,NULL,'IN_STOCK','GRN','XYZ303256025','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6156,'XYZ-1768195197507-EAB9E50D',1,NULL,'IN_STOCK','GRN','XYZ175630638','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6157,'XYZ-1768195197529-D9DBEE2B',1,NULL,'IN_STOCK','GRN','XYZ476074587','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6158,'XYZ-1768195197549-D2E29D51',1,NULL,'IN_STOCK','GRN','XYZ384834673','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6159,'XYZ-1768195197570-DD47A3F7',1,NULL,'IN_STOCK','GRN','XYZ827458594','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6160,'XYZ-1768195197592-E921F3E1',1,NULL,'IN_STOCK','GRN','XYZ642437587','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6161,'XYZ-1768195197614-39CBC660',1,NULL,'IN_STOCK','GRN','XYZ055586990','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6162,'XYZ-1768195197635-523BB91E',1,NULL,'IN_STOCK','GRN','XYZ124597276','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6163,'XYZ-1768195197656-9AC4E3FA',1,NULL,'IN_STOCK','GRN','XYZ038301955','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6164,'XYZ-1768195197677-B35C07B9',1,NULL,'IN_STOCK','GRN','XYZ762990097','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6165,'XYZ-1768195197701-A120450D',1,NULL,'IN_STOCK','GRN','XYZ376368482','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6166,'XYZ-1768195197724-9A0B47B0',1,NULL,'IN_STOCK','GRN','XYZ546700973','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6167,'XYZ-1768195197745-4FCD9E8F',1,NULL,'IN_STOCK','GRN','XYZ323946562','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6168,'XYZ-1768195197766-4959C86D',1,NULL,'IN_STOCK','GRN','XYZ617888126','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6169,'XYZ-1768195197787-A231809E',1,NULL,'IN_STOCK','GRN','XYZ704729732','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6170,'XYZ-1768195197811-B51BC589',1,NULL,'IN_STOCK','GRN','XYZ045270220','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6171,'XYZ-1768195197832-F4B2AE7D',1,NULL,'IN_STOCK','GRN','XYZ596250910','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6172,'XYZ-1768195197855-F80FFB1C',1,NULL,'IN_STOCK','GRN','XYZ028902838','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6173,'XYZ-1768195197878-58F7274A',1,NULL,'IN_STOCK','GRN','XYZ388087390','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6174,'XYZ-1768195197901-5F0F628A',1,NULL,'IN_STOCK','GRN','XYZ193642536','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6175,'XYZ-1768195197926-CACB80FD',1,NULL,'IN_STOCK','GRN','XYZ331891778','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6176,'XYZ-1768195197948-7AA23AEC',1,NULL,'IN_STOCK','GRN','XYZ520024404','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6177,'XYZ-1768195197969-C9171DB9',1,NULL,'IN_STOCK','GRN','XYZ422849028','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6178,'XYZ-1768195197990-3336FFD4',1,NULL,'IN_STOCK','GRN','XYZ508171131','2026-01-12 05:19:57','2026-01-12 05:19:57'),(6179,'XYZ-1768195198011-3D7523EB',1,NULL,'IN_STOCK','GRN','XYZ779124517','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6180,'XYZ-1768195198032-33772A9C',1,NULL,'IN_STOCK','GRN','XYZ519075841','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6181,'XYZ-1768195198053-AB966DAC',1,NULL,'IN_STOCK','GRN','XYZ980863537','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6182,'XYZ-1768195198076-789C4E2C',1,NULL,'IN_STOCK','GRN','XYZ319346211','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6183,'XYZ-1768195198101-7F851C37',1,NULL,'IN_STOCK','GRN','XYZ904291189','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6184,'XYZ-1768195198124-303668B7',1,NULL,'IN_STOCK','GRN','XYZ592115775','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6185,'XYZ-1768195198145-90EF3EA5',1,NULL,'IN_STOCK','GRN','XYZ931689693','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6186,'XYZ-1768195198166-70E67134',1,NULL,'IN_STOCK','GRN','XYZ112506913','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6187,'XYZ-1768195198187-EE1A5B03',1,NULL,'IN_STOCK','GRN','XYZ152739981','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6188,'XYZ-1768195198208-2C3D1AEA',1,NULL,'IN_STOCK','GRN','XYZ426839868','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6189,'XYZ-1768195198228-178B0098',1,NULL,'IN_STOCK','GRN','XYZ626501192','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6190,'XYZ-1768195198250-05F88178',1,NULL,'IN_STOCK','GRN','XYZ502565148','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6191,'XYZ-1768195198271-E55D7AC8',1,NULL,'IN_STOCK','GRN','XYZ649847862','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6192,'XYZ-1768195198292-298933DF',1,NULL,'IN_STOCK','GRN','XYZ836324923','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6193,'XYZ-1768195198313-E9BF322D',1,NULL,'IN_STOCK','GRN','XYZ907850455','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6194,'XYZ-1768195198334-B174B8AD',1,NULL,'IN_STOCK','GRN','XYZ695272631','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6195,'XYZ-1768195198355-A1649322',1,NULL,'IN_STOCK','GRN','XYZ811025331','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6196,'XYZ-1768195198376-F358C1ED',1,NULL,'IN_STOCK','GRN','XYZ990324677','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6197,'XYZ-1768195198397-1240C957',1,NULL,'IN_STOCK','GRN','XYZ853592504','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6198,'XYZ-1768195198417-4611A415',1,NULL,'IN_STOCK','GRN','XYZ438740055','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6199,'XYZ-1768195198439-B970F551',1,NULL,'IN_STOCK','GRN','XYZ341288088','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6200,'XYZ-1768195198463-F9F3860F',1,NULL,'IN_STOCK','GRN','XYZ836976998','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6201,'XYZ-1768195198484-38BDBCB8',1,NULL,'IN_STOCK','GRN','XYZ412918318','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6202,'XYZ-1768195198505-D2F8F637',1,NULL,'IN_STOCK','GRN','XYZ376613840','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6203,'XYZ-1768195198526-4E479865',1,NULL,'IN_STOCK','GRN','XYZ953111765','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6204,'XYZ-1768195198548-E776BA6C',1,NULL,'IN_STOCK','GRN','XYZ281574589','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6205,'XYZ-1768195198569-2FBF1B97',1,NULL,'IN_STOCK','GRN','XYZ040057384','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6206,'XYZ-1768195198590-069D6CB3',1,NULL,'IN_STOCK','GRN','XYZ442156457','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6207,'XYZ-1768195198614-F904DF77',1,NULL,'IN_STOCK','GRN','XYZ106275484','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6208,'XYZ-1768195198636-21A10887',1,NULL,'IN_STOCK','GRN','XYZ903609580','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6209,'XYZ-1768195198657-580059E8',1,NULL,'IN_STOCK','GRN','XYZ196726895','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6210,'XYZ-1768195198678-55A2CD8D',1,NULL,'IN_STOCK','GRN','XYZ106013036','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6211,'XYZ-1768195198699-FFEAD155',1,NULL,'IN_STOCK','GRN','XYZ058394688','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6212,'XYZ-1768195198720-54F316CB',1,NULL,'IN_STOCK','GRN','XYZ454795525','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6213,'XYZ-1768195198742-749378CA',1,NULL,'IN_STOCK','GRN','XYZ419708141','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6214,'XYZ-1768195198763-F8D77382',1,NULL,'IN_STOCK','GRN','XYZ764500363','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6215,'XYZ-1768195198788-758C12C2',1,NULL,'IN_STOCK','GRN','XYZ363763327','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6216,'XYZ-1768195198812-6809C404',1,NULL,'IN_STOCK','GRN','XYZ196793755','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6217,'XYZ-1768195198833-0CB03579',1,NULL,'IN_STOCK','GRN','XYZ826139895','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6218,'XYZ-1768195198855-D8DD79BE',1,NULL,'IN_STOCK','GRN','XYZ635807664','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6219,'XYZ-1768195198875-695EEBB7',1,NULL,'IN_STOCK','GRN','XYZ090305614','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6220,'XYZ-1768195198896-E4DB0E44',1,NULL,'IN_STOCK','GRN','XYZ028879844','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6221,'XYZ-1768195198918-4E506C74',1,NULL,'IN_STOCK','GRN','XYZ998054139','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6222,'XYZ-1768195198941-541EC5A9',1,NULL,'IN_STOCK','GRN','XYZ247821662','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6223,'XYZ-1768195198962-E1BB580B',1,NULL,'IN_STOCK','GRN','XYZ376949742','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6224,'XYZ-1768195198983-0D0F7D51',1,NULL,'IN_STOCK','GRN','XYZ642658827','2026-01-12 05:19:58','2026-01-12 05:19:58'),(6225,'XYZ-1768195199004-FF162A3A',1,NULL,'IN_STOCK','GRN','XYZ505649718','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6226,'XYZ-1768195199025-DDC2D1CA',1,NULL,'IN_STOCK','GRN','XYZ265225100','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6227,'XYZ-1768195199046-88EA21A3',1,NULL,'IN_STOCK','GRN','XYZ899267809','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6228,'XYZ-1768195199067-C952C5A7',1,NULL,'IN_STOCK','GRN','XYZ588992738','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6229,'XYZ-1768195199088-7F2F30BC',1,NULL,'IN_STOCK','GRN','XYZ879394122','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6230,'XYZ-1768195199109-8F0513DB',1,NULL,'IN_STOCK','GRN','XYZ834575371','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6231,'XYZ-1768195199131-136705DA',1,NULL,'IN_STOCK','GRN','XYZ098798654','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6232,'XYZ-1768195199152-A4C52376',1,NULL,'IN_STOCK','GRN','XYZ718735156','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6233,'XYZ-1768195199173-7FC0D9C3',1,NULL,'IN_STOCK','GRN','XYZ584836629','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6234,'XYZ-1768195199194-78BE991B',1,NULL,'IN_STOCK','GRN','XYZ477661531','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6235,'XYZ-1768195199215-69817FC7',1,NULL,'IN_STOCK','GRN','XYZ694854541','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6236,'XYZ-1768195199236-9D8C7A3C',1,NULL,'IN_STOCK','GRN','XYZ243461723','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6237,'XYZ-1768195199257-BA218EDC',1,NULL,'IN_STOCK','GRN','XYZ232603276','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6238,'XYZ-1768195199278-6AD07F24',1,NULL,'IN_STOCK','GRN','XYZ822189550','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6239,'XYZ-1768195199300-9DB97EE8',1,NULL,'IN_STOCK','GRN','XYZ723915852','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6240,'XYZ-1768195199321-A020BD57',1,NULL,'IN_STOCK','GRN','XYZ844768369','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6241,'XYZ-1768195199342-C5A02684',1,NULL,'IN_STOCK','GRN','XYZ529382217','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6242,'XYZ-1768195199363-3AB1D44A',1,NULL,'IN_STOCK','GRN','XYZ091777596','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6243,'XYZ-1768195199385-2507A1C6',1,NULL,'IN_STOCK','GRN','XYZ918355164','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6244,'XYZ-1768195199405-1DF546D1',1,NULL,'IN_STOCK','GRN','XYZ025007841','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6245,'XYZ-1768195199427-F30331EF',1,NULL,'IN_STOCK','GRN','XYZ249900319','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6246,'XYZ-1768195199449-159C450F',1,NULL,'IN_STOCK','GRN','XYZ924847344','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6247,'XYZ-1768195199470-3EFB1E13',1,NULL,'IN_STOCK','GRN','XYZ004056313','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6248,'XYZ-1768195199492-7F45BCCB',1,NULL,'IN_STOCK','GRN','XYZ235517599','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6249,'XYZ-1768195199513-534FCC68',1,NULL,'IN_STOCK','GRN','XYZ925988532','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6250,'XYZ-1768195199534-D1D92898',1,NULL,'IN_STOCK','GRN','XYZ547439499','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6251,'XYZ-1768195199555-D7F0BE50',1,NULL,'IN_STOCK','GRN','XYZ467848907','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6252,'XYZ-1768195199576-91F42C86',1,NULL,'IN_STOCK','GRN','XYZ930381427','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6253,'XYZ-1768195199598-8E6A397C',1,NULL,'IN_STOCK','GRN','XYZ072246258','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6254,'XYZ-1768195199622-2C57C3A7',1,NULL,'IN_STOCK','GRN','XYZ752177373','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6255,'XYZ-1768195199642-83844637',1,NULL,'IN_STOCK','GRN','XYZ418723331','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6256,'XYZ-1768195199663-E17BDDC8',1,NULL,'IN_STOCK','GRN','XYZ367994303','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6257,'XYZ-1768195199685-83717574',1,NULL,'IN_STOCK','GRN','XYZ322975445','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6258,'XYZ-1768195199706-0F2134E7',1,NULL,'IN_STOCK','GRN','XYZ669111926','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6259,'XYZ-1768195199727-35677D0F',1,NULL,'IN_STOCK','GRN','XYZ780530720','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6260,'XYZ-1768195199751-E0D83784',1,NULL,'IN_STOCK','GRN','XYZ376441007','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6261,'XYZ-1768195199775-2E28D02C',1,NULL,'IN_STOCK','GRN','XYZ074430549','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6262,'XYZ-1768195199796-A2545A9A',1,NULL,'IN_STOCK','GRN','XYZ479183916','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6263,'XYZ-1768195199818-38FBC692',1,NULL,'IN_STOCK','GRN','XYZ593169688','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6264,'XYZ-1768195199841-8FECFBFC',1,NULL,'IN_STOCK','GRN','XYZ071462988','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6265,'XYZ-1768195199863-1FFF0F1F',1,NULL,'IN_STOCK','GRN','XYZ188129986','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6266,'XYZ-1768195199884-08ACC003',1,NULL,'IN_STOCK','GRN','XYZ961789110','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6267,'XYZ-1768195199904-D9356695',1,NULL,'IN_STOCK','GRN','XYZ195847267','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6268,'XYZ-1768195199927-32236881',1,NULL,'IN_STOCK','GRN','XYZ578564323','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6269,'XYZ-1768195199948-19F60155',1,NULL,'IN_STOCK','GRN','XYZ118840541','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6270,'XYZ-1768195199969-4F81F6A1',1,NULL,'IN_STOCK','GRN','XYZ691165951','2026-01-12 05:19:59','2026-01-12 05:19:59'),(6271,'XYZ-1768195199993-2273BB56',1,NULL,'IN_STOCK','GRN','XYZ629940874','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6272,'XYZ-1768195200016-96B741B5',1,NULL,'IN_STOCK','GRN','XYZ661354985','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6273,'XYZ-1768195200041-968BC848',1,NULL,'IN_STOCK','GRN','XYZ756351564','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6274,'XYZ-1768195200065-29E9BE55',1,NULL,'IN_STOCK','GRN','XYZ032075331','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6275,'XYZ-1768195200086-74C2EA3D',1,NULL,'IN_STOCK','GRN','XYZ302562656','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6276,'XYZ-1768195200107-24FFE23A',1,NULL,'IN_STOCK','GRN','XYZ244104561','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6277,'XYZ-1768195200128-E93BA95F',1,NULL,'IN_STOCK','GRN','XYZ499552255','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6278,'XYZ-1768195200149-124C956F',1,NULL,'IN_STOCK','GRN','XYZ842870067','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6279,'XYZ-1768195200170-9266F829',1,NULL,'IN_STOCK','GRN','XYZ580491332','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6280,'XYZ-1768195200191-9907073A',1,NULL,'IN_STOCK','GRN','XYZ612887844','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6281,'XYZ-1768195200213-20E07C86',1,NULL,'IN_STOCK','GRN','XYZ427314566','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6282,'XYZ-1768195200238-2096568E',1,NULL,'IN_STOCK','GRN','XYZ189073295','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6283,'XYZ-1768195200259-7879345C',1,NULL,'IN_STOCK','GRN','XYZ074381387','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6284,'XYZ-1768195200280-7A2DAA8B',1,NULL,'IN_STOCK','GRN','XYZ997193677','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6285,'XYZ-1768195200301-0B9BFB61',1,NULL,'IN_STOCK','GRN','XYZ319287388','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6286,'XYZ-1768195200323-CDAAA8BA',1,NULL,'IN_STOCK','GRN','XYZ468712788','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6287,'XYZ-1768195200345-F8236DA1',1,NULL,'IN_STOCK','GRN','XYZ619160142','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6288,'XYZ-1768195200366-18FA9087',1,NULL,'IN_STOCK','GRN','XYZ701211256','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6289,'XYZ-1768195200391-B542A03E',1,NULL,'IN_STOCK','GRN','XYZ783118235','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6290,'XYZ-1768195200414-36C2C319',1,NULL,'IN_STOCK','GRN','XYZ842665037','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6291,'XYZ-1768195200441-2C8B2DD1',1,NULL,'IN_STOCK','GRN','XYZ593437258','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6292,'XYZ-1768195200463-FFCEEFBC',1,NULL,'IN_STOCK','GRN','XYZ242141901','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6293,'XYZ-1768195200484-42343BAC',1,NULL,'IN_STOCK','GRN','XYZ397793747','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6294,'XYZ-1768195200505-37C9781E',1,NULL,'IN_STOCK','GRN','XYZ786947079','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6295,'XYZ-1768195200528-B2D65C67',1,NULL,'IN_STOCK','GRN','XYZ424690097','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6296,'XYZ-1768195200551-FB45B809',1,NULL,'IN_STOCK','GRN','XYZ233584358','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6297,'XYZ-1768195200572-2A3E7871',1,NULL,'IN_STOCK','GRN','XYZ130201037','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6298,'XYZ-1768195200590-D264A0D3',1,NULL,'IN_STOCK','GRN','XYZ191054840','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6299,'XYZ-1768195200608-1BDBBA99',1,NULL,'IN_STOCK','GRN','XYZ384388739','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6300,'XYZ-1768195200627-D72340F4',1,NULL,'IN_STOCK','GRN','XYZ797121598','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6301,'XYZ-1768195200644-123C69E2',1,NULL,'IN_STOCK','GRN','XYZ219563554','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6302,'XYZ-1768195200664-89E71789',1,NULL,'IN_STOCK','GRN','XYZ817847984','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6303,'XYZ-1768195200685-B0CE6DA3',1,NULL,'IN_STOCK','GRN','XYZ951216829','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6304,'XYZ-1768195200706-96880AAA',1,NULL,'IN_STOCK','GRN','XYZ925191855','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6305,'XYZ-1768195200727-33425D7B',1,NULL,'IN_STOCK','GRN','XYZ684000812','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6306,'XYZ-1768195200747-571E70C9',1,NULL,'IN_STOCK','GRN','XYZ177048019','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6307,'XYZ-1768195200768-B69D533A',1,NULL,'IN_STOCK','GRN','XYZ612796082','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6308,'XYZ-1768195200789-5151AB0D',1,NULL,'IN_STOCK','GRN','XYZ502687596','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6309,'XYZ-1768195200810-8375DA6D',1,NULL,'IN_STOCK','GRN','XYZ588853781','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6310,'XYZ-1768195200831-F9BAD0D3',1,NULL,'IN_STOCK','GRN','XYZ933651801','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6311,'XYZ-1768195200853-B449D0A4',1,NULL,'IN_STOCK','GRN','XYZ605643020','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6312,'XYZ-1768195200874-49269F0F',1,NULL,'IN_STOCK','GRN','XYZ303032544','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6313,'XYZ-1768195200895-296F4C7A',1,NULL,'IN_STOCK','GRN','XYZ980103632','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6314,'XYZ-1768195200916-7D05D36B',1,NULL,'IN_STOCK','GRN','XYZ236341780','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6315,'XYZ-1768195200938-110B3F3D',1,NULL,'IN_STOCK','GRN','XYZ148302780','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6316,'XYZ-1768195200961-809E357B',1,NULL,'IN_STOCK','GRN','XYZ345880896','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6317,'XYZ-1768195200982-8BFD3420',1,NULL,'IN_STOCK','GRN','XYZ867186025','2026-01-12 05:20:00','2026-01-12 05:20:00'),(6318,'XYZ-1768195201003-2384F0E0',1,NULL,'IN_STOCK','GRN','XYZ258387009','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6319,'XYZ-1768195201024-17B78691',1,NULL,'IN_STOCK','GRN','XYZ280353461','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6320,'XYZ-1768195201045-3D51D3A1',1,NULL,'IN_STOCK','GRN','XYZ491818126','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6321,'XYZ-1768195201066-55FFCF5E',1,NULL,'IN_STOCK','GRN','XYZ936241964','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6322,'XYZ-1768195201087-245CF3F1',1,NULL,'IN_STOCK','GRN','XYZ638555192','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6323,'XYZ-1768195201109-22DE52B1',1,NULL,'IN_STOCK','GRN','XYZ216402588','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6324,'XYZ-1768195201132-A0E3142D',1,NULL,'IN_STOCK','GRN','XYZ021508523','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6325,'XYZ-1768195201154-58E6E58D',1,NULL,'IN_STOCK','GRN','XYZ541435923','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6326,'XYZ-1768195201178-1E5C7349',1,NULL,'IN_STOCK','GRN','XYZ495694511','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6327,'XYZ-1768195201203-83FC742D',1,NULL,'IN_STOCK','GRN','XYZ385907243','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6328,'XYZ-1768195201225-87A0C79D',1,NULL,'IN_STOCK','GRN','XYZ604341092','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6329,'XYZ-1768195201247-34FD0A6E',1,NULL,'IN_STOCK','GRN','XYZ282594643','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6330,'XYZ-1768195201268-D37A7AC4',1,NULL,'IN_STOCK','GRN','XYZ881390953','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6331,'XYZ-1768195201289-EA73725E',1,NULL,'IN_STOCK','GRN','XYZ295736656','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6332,'XYZ-1768195201311-074BA40D',1,NULL,'IN_STOCK','GRN','XYZ484735826','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6333,'XYZ-1768195201332-0FB9F2C8',1,NULL,'IN_STOCK','GRN','XYZ909305438','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6334,'XYZ-1768195201356-15C51374',1,NULL,'IN_STOCK','GRN','XYZ042543484','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6335,'XYZ-1768195201376-EA677CB4',1,NULL,'IN_STOCK','GRN','XYZ308309158','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6336,'XYZ-1768195201398-A366E137',1,NULL,'IN_STOCK','GRN','XYZ433466573','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6337,'XYZ-1768195201422-702C7A84',1,NULL,'IN_STOCK','GRN','XYZ164944891','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6338,'XYZ-1768195201445-BA7FA7BA',1,NULL,'IN_STOCK','GRN','XYZ015864044','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6339,'XYZ-1768195201468-72DFF63F',1,NULL,'IN_STOCK','GRN','XYZ430484682','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6340,'XYZ-1768195201491-0C533961',1,NULL,'IN_STOCK','GRN','XYZ170780570','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6341,'XYZ-1768195201514-DFCD7C2A',1,NULL,'IN_STOCK','GRN','XYZ967946135','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6342,'XYZ-1768195201532-635F7C33',1,NULL,'IN_STOCK','GRN','XYZ331760827','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6343,'XYZ-1768195201556-AD801C54',1,NULL,'IN_STOCK','GRN','XYZ759663031','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6344,'XYZ-1768195201580-3D44B84D',1,NULL,'IN_STOCK','GRN','XYZ347594714','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6345,'XYZ-1768195201601-3FCBB83B',1,NULL,'IN_STOCK','GRN','XYZ756191057','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6346,'XYZ-1768195201622-31D52A9E',1,NULL,'IN_STOCK','GRN','XYZ950617243','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6347,'XYZ-1768195201644-ED779B23',1,NULL,'IN_STOCK','GRN','XYZ071984783','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6348,'XYZ-1768195201665-F2D53B1C',1,NULL,'IN_STOCK','GRN','XYZ199203828','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6349,'XYZ-1768195201686-A1346260',1,NULL,'IN_STOCK','GRN','XYZ640630068','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6350,'XYZ-1768195201708-2A4E81A7',1,NULL,'IN_STOCK','GRN','XYZ744815606','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6351,'XYZ-1768195201729-88C679C7',1,NULL,'IN_STOCK','GRN','XYZ303674023','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6352,'XYZ-1768195201752-0017F91D',1,NULL,'IN_STOCK','GRN','XYZ220446442','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6353,'XYZ-1768195201774-ECAC5BFE',1,NULL,'IN_STOCK','GRN','XYZ551202651','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6354,'XYZ-1768195201795-111F5C74',1,NULL,'IN_STOCK','GRN','XYZ688423397','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6355,'XYZ-1768195201817-6EDF20D2',1,NULL,'IN_STOCK','GRN','XYZ138308896','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6356,'XYZ-1768195201838-08B62798',1,NULL,'IN_STOCK','GRN','XYZ412243363','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6357,'XYZ-1768195201860-23E890C7',1,NULL,'IN_STOCK','GRN','XYZ552301976','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6358,'XYZ-1768195201881-0F457E17',1,NULL,'IN_STOCK','GRN','XYZ256780820','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6359,'XYZ-1768195201904-5167CAC6',1,NULL,'IN_STOCK','GRN','XYZ758343465','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6360,'XYZ-1768195201925-26B5A60D',1,NULL,'IN_STOCK','GRN','XYZ890518352','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6361,'XYZ-1768195201946-19F065AB',1,NULL,'IN_STOCK','GRN','XYZ416159664','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6362,'XYZ-1768195201967-9356ADE6',1,NULL,'IN_STOCK','GRN','XYZ107260175','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6363,'XYZ-1768195201988-2F4AD4B5',1,NULL,'IN_STOCK','GRN','XYZ300818352','2026-01-12 05:20:01','2026-01-12 05:20:01'),(6364,'XYZ-1768195202009-F4893000',1,NULL,'IN_STOCK','GRN','XYZ367849473','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6365,'XYZ-1768195202030-EC3D028A',1,NULL,'IN_STOCK','GRN','XYZ146515990','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6366,'XYZ-1768195202052-49A7A81F',1,NULL,'IN_STOCK','GRN','XYZ473475457','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6367,'XYZ-1768195202073-F2965CA0',1,NULL,'IN_STOCK','GRN','XYZ904390064','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6368,'XYZ-1768195202094-86BEC43E',1,NULL,'IN_STOCK','GRN','XYZ211201269','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6369,'XYZ-1768195202120-54142932',1,NULL,'IN_STOCK','GRN','XYZ121884442','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6370,'XYZ-1768195202143-498AC5E9',1,NULL,'IN_STOCK','GRN','XYZ321333346','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6371,'XYZ-1768195202164-82B25C91',1,NULL,'IN_STOCK','GRN','XYZ858989547','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6372,'XYZ-1768195202186-B970FF39',1,NULL,'IN_STOCK','GRN','XYZ018337315','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6373,'XYZ-1768195202207-090ED44D',1,NULL,'IN_STOCK','GRN','XYZ827278023','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6374,'XYZ-1768195202228-5C65BC34',1,NULL,'IN_STOCK','GRN','XYZ758267054','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6375,'XYZ-1768195202250-31794F01',1,NULL,'IN_STOCK','GRN','XYZ378899388','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6376,'XYZ-1768195202273-63393E85',1,NULL,'IN_STOCK','GRN','XYZ859403669','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6377,'XYZ-1768195202296-5BD0ED3D',1,NULL,'IN_STOCK','GRN','XYZ759622394','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6378,'XYZ-1768195202317-B1381711',1,NULL,'IN_STOCK','GRN','XYZ818225599','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6379,'XYZ-1768195202338-0E83CD9F',1,NULL,'IN_STOCK','GRN','XYZ179532676','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6380,'XYZ-1768195202359-4480D637',1,NULL,'IN_STOCK','GRN','XYZ668624084','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6381,'XYZ-1768195202380-6EB983BD',1,NULL,'IN_STOCK','GRN','XYZ286583520','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6382,'XYZ-1768195202402-79234411',1,NULL,'IN_STOCK','GRN','XYZ647811704','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6383,'XYZ-1768195202425-A51CDFB2',1,NULL,'IN_STOCK','GRN','XYZ912165631','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6384,'XYZ-1768195202450-D41BD130',1,NULL,'IN_STOCK','GRN','XYZ908836560','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6385,'XYZ-1768195202471-6CD26BFA',1,NULL,'IN_STOCK','GRN','XYZ069968827','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6386,'XYZ-1768195202493-24777344',1,NULL,'IN_STOCK','GRN','XYZ033828371','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6387,'XYZ-1768195202514-05E4A555',1,NULL,'IN_STOCK','GRN','XYZ238527434','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6388,'XYZ-1768195202535-F356D2E6',1,NULL,'IN_STOCK','GRN','XYZ141544946','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6389,'XYZ-1768195202558-5E70545C',1,NULL,'IN_STOCK','GRN','XYZ414317542','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6390,'XYZ-1768195202579-5D8FE8FE',1,NULL,'IN_STOCK','GRN','XYZ325941457','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6391,'XYZ-1768195202599-C6D2269A',1,NULL,'IN_STOCK','GRN','XYZ567545015','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6392,'XYZ-1768195202620-F35AE834',1,NULL,'IN_STOCK','GRN','XYZ901534455','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6393,'XYZ-1768195202641-EE55927A',1,NULL,'IN_STOCK','GRN','XYZ984393542','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6394,'XYZ-1768195202663-DA250DFB',1,NULL,'IN_STOCK','GRN','XYZ123743059','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6395,'XYZ-1768195202685-18E2D1F5',1,NULL,'IN_STOCK','GRN','XYZ949628241','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6396,'XYZ-1768195202710-B9D1B750',1,NULL,'IN_STOCK','GRN','XYZ273167927','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6397,'XYZ-1768195202732-0CB21AF7',1,NULL,'IN_STOCK','GRN','XYZ059180346','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6398,'XYZ-1768195202754-EE480088',1,NULL,'IN_STOCK','GRN','XYZ124414602','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6399,'XYZ-1768195202779-ABCEF1D0',1,NULL,'IN_STOCK','GRN','XYZ605198686','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6400,'XYZ-1768195202800-33118D2B',1,NULL,'IN_STOCK','GRN','XYZ081261702','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6401,'XYZ-1768195202821-9FC077CC',1,NULL,'IN_STOCK','GRN','XYZ133541783','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6402,'XYZ-1768195202843-3A4357E8',1,NULL,'IN_STOCK','GRN','XYZ403828897','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6403,'XYZ-1768195202867-23E96EEC',1,NULL,'IN_STOCK','GRN','XYZ951248373','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6404,'XYZ-1768195202888-B83EA00D',1,NULL,'IN_STOCK','GRN','XYZ662104992','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6405,'XYZ-1768195202909-2642AFCB',1,NULL,'IN_STOCK','GRN','XYZ759028148','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6406,'XYZ-1768195202931-0BE1D146',1,NULL,'IN_STOCK','GRN','XYZ718120439','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6407,'XYZ-1768195202954-A9448CFF',1,NULL,'IN_STOCK','GRN','XYZ717197866','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6408,'XYZ-1768195202979-062069F6',1,NULL,'IN_STOCK','GRN','XYZ946296804','2026-01-12 05:20:02','2026-01-12 05:20:02'),(6409,'XYZ-1768195203002-7F32EC5E',1,NULL,'IN_STOCK','GRN','XYZ137375402','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6410,'XYZ-1768195203024-F30615C6',1,NULL,'IN_STOCK','GRN','XYZ847079400','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6411,'XYZ-1768195203046-51C7613A',1,NULL,'IN_STOCK','GRN','XYZ678653399','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6412,'XYZ-1768195203070-20DE3226',1,NULL,'IN_STOCK','GRN','XYZ125344435','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6413,'XYZ-1768195203091-24078396',1,NULL,'IN_STOCK','GRN','XYZ200665920','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6414,'XYZ-1768195203112-5D759A98',1,NULL,'IN_STOCK','GRN','XYZ194245354','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6415,'XYZ-1768195203134-6D1EC80A',1,NULL,'IN_STOCK','GRN','XYZ171526927','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6416,'XYZ-1768195203155-063A20B9',1,NULL,'IN_STOCK','GRN','XYZ001105082','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6417,'XYZ-1768195203176-D690B126',1,NULL,'IN_STOCK','GRN','XYZ416105181','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6418,'XYZ-1768195203198-74D645B6',1,NULL,'IN_STOCK','GRN','XYZ244073430','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6419,'XYZ-1768195203219-125B5BAF',1,NULL,'IN_STOCK','GRN','XYZ663158534','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6420,'XYZ-1768195203240-BB1AC4B3',1,NULL,'IN_STOCK','GRN','XYZ398633115','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6421,'XYZ-1768195203262-4300D3B9',1,NULL,'IN_STOCK','GRN','XYZ768912916','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6422,'XYZ-1768195203283-E7794808',1,NULL,'IN_STOCK','GRN','XYZ245532108','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6423,'XYZ-1768195203308-860D7A34',1,NULL,'IN_STOCK','GRN','XYZ224809618','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6424,'XYZ-1768195203329-429D5634',1,NULL,'IN_STOCK','GRN','XYZ142038957','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6425,'XYZ-1768195203350-A2D52739',1,NULL,'IN_STOCK','GRN','XYZ297291316','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6426,'XYZ-1768195203375-988E6AAB',1,NULL,'IN_STOCK','GRN','XYZ292842761','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6427,'XYZ-1768195203397-B641FFBF',1,NULL,'IN_STOCK','GRN','XYZ922885527','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6428,'XYZ-1768195203422-69EA107B',1,NULL,'IN_STOCK','GRN','XYZ094803541','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6429,'XYZ-1768195203443-866AD06D',1,NULL,'IN_STOCK','GRN','XYZ351063809','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6430,'XYZ-1768195203464-66ED06C4',1,NULL,'IN_STOCK','GRN','XYZ705195064','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6431,'XYZ-1768195203485-945084C2',1,NULL,'IN_STOCK','GRN','XYZ027065148','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6432,'XYZ-1768195203507-288772DF',1,NULL,'IN_STOCK','GRN','XYZ664739143','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6433,'XYZ-1768195203528-703BC5C3',1,NULL,'IN_STOCK','GRN','XYZ128436392','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6434,'XYZ-1768195203550-0F66E31E',1,NULL,'IN_STOCK','GRN','XYZ945469674','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6435,'XYZ-1768195203574-7F0A84A3',1,NULL,'IN_STOCK','GRN','XYZ329049292','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6436,'XYZ-1768195203595-F83FEF57',1,NULL,'IN_STOCK','GRN','XYZ185676877','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6437,'XYZ-1768195203617-B5ADA1C1',1,NULL,'IN_STOCK','GRN','XYZ061348134','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6438,'XYZ-1768195203638-11154132',1,NULL,'IN_STOCK','GRN','XYZ303148201','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6439,'XYZ-1768195203660-605FC222',1,NULL,'IN_STOCK','GRN','XYZ781180563','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6440,'XYZ-1768195203686-E7DB99AE',1,NULL,'IN_STOCK','GRN','XYZ450179454','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6441,'XYZ-1768195203708-69CDC44C',1,NULL,'IN_STOCK','GRN','XYZ754775102','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6442,'XYZ-1768195203729-A094B248',1,NULL,'IN_STOCK','GRN','XYZ292678472','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6443,'XYZ-1768195203750-4EAA7556',1,NULL,'IN_STOCK','GRN','XYZ907304929','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6444,'XYZ-1768195203772-03179BC9',1,NULL,'IN_STOCK','GRN','XYZ349688766','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6445,'XYZ-1768195203793-16D6DFD2',1,NULL,'IN_STOCK','GRN','XYZ308834671','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6446,'XYZ-1768195203815-50A442E4',1,NULL,'IN_STOCK','GRN','XYZ387109321','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6447,'XYZ-1768195203836-AD5AFB5B',1,NULL,'IN_STOCK','GRN','XYZ828980071','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6448,'XYZ-1768195203857-953BE2B5',1,NULL,'IN_STOCK','GRN','XYZ098513684','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6449,'XYZ-1768195203878-A2485CDC',1,NULL,'IN_STOCK','GRN','XYZ555089981','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6450,'XYZ-1768195203899-265002E1',1,NULL,'IN_STOCK','GRN','XYZ197201328','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6451,'XYZ-1768195203920-BFDD8A14',1,NULL,'IN_STOCK','GRN','XYZ158739040','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6452,'XYZ-1768195203941-4327A696',1,NULL,'IN_STOCK','GRN','XYZ223434584','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6453,'XYZ-1768195203962-E8F093CA',1,NULL,'IN_STOCK','GRN','XYZ181769281','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6454,'XYZ-1768195203983-5B7C0A6F',1,NULL,'IN_STOCK','GRN','XYZ700045781','2026-01-12 05:20:03','2026-01-12 05:20:03'),(6455,'XYZ-1768195204004-CC619E8D',1,NULL,'IN_STOCK','GRN','XYZ433514350','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6456,'XYZ-1768195204026-1D343588',1,NULL,'IN_STOCK','GRN','XYZ265668344','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6457,'XYZ-1768195204047-7EDDBF2A',1,NULL,'IN_STOCK','GRN','XYZ149122482','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6458,'XYZ-1768195204068-9FA4AFB3',1,NULL,'IN_STOCK','GRN','XYZ805255850','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6459,'XYZ-1768195204089-CE04372A',1,NULL,'IN_STOCK','GRN','XYZ110748643','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6460,'XYZ-1768195204110-E9BB2445',1,NULL,'IN_STOCK','GRN','XYZ688612387','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6461,'XYZ-1768195204131-597DF01A',1,NULL,'IN_STOCK','GRN','XYZ615599893','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6462,'XYZ-1768195204152-06DC61F2',1,NULL,'IN_STOCK','GRN','XYZ746571847','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6463,'XYZ-1768195204175-84AA0991',1,NULL,'IN_STOCK','GRN','XYZ830600853','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6464,'XYZ-1768195204197-3539714D',1,NULL,'IN_STOCK','GRN','XYZ922966066','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6465,'XYZ-1768195204219-1B10BDD6',1,NULL,'IN_STOCK','GRN','XYZ752866264','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6466,'XYZ-1768195204240-52D68F05',1,NULL,'IN_STOCK','GRN','XYZ594096983','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6467,'XYZ-1768195204261-E00FBE9F',1,NULL,'IN_STOCK','GRN','XYZ507963043','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6468,'XYZ-1768195204285-8E259B3E',1,NULL,'IN_STOCK','GRN','XYZ060997734','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6469,'XYZ-1768195204310-F48C5696',1,NULL,'IN_STOCK','GRN','XYZ323822602','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6470,'XYZ-1768195204335-BB46F248',1,NULL,'IN_STOCK','GRN','XYZ318780547','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6471,'XYZ-1768195204359-8A83C4AF',1,NULL,'IN_STOCK','GRN','XYZ950550906','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6472,'XYZ-1768195204384-923F6D56',1,NULL,'IN_STOCK','GRN','XYZ161779945','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6473,'XYZ-1768195204407-7EDCD99C',1,NULL,'IN_STOCK','GRN','XYZ916802190','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6474,'XYZ-1768195204432-570AA564',1,NULL,'IN_STOCK','GRN','XYZ286399309','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6475,'XYZ-1768195204454-24F97AF4',1,NULL,'IN_STOCK','GRN','XYZ388429135','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6476,'XYZ-1768195204479-DB2C110F',1,NULL,'IN_STOCK','GRN','XYZ280569008','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6477,'XYZ-1768195204501-58331711',1,NULL,'IN_STOCK','GRN','XYZ248304379','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6478,'XYZ-1768195204526-2C4B20EF',1,NULL,'IN_STOCK','GRN','XYZ357871906','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6479,'XYZ-1768195204549-25EDA0D8',1,NULL,'IN_STOCK','GRN','XYZ349820880','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6480,'XYZ-1768195204572-70160511',1,NULL,'IN_STOCK','GRN','XYZ290540490','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6481,'XYZ-1768195204594-CEDA5FCA',1,NULL,'IN_STOCK','GRN','XYZ464029240','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6482,'XYZ-1768195204616-A41D0816',1,NULL,'IN_STOCK','GRN','XYZ642923545','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6483,'XYZ-1768195204637-07DA05E9',1,NULL,'IN_STOCK','GRN','XYZ293382119','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6484,'XYZ-1768195204658-D0490DF2',1,NULL,'IN_STOCK','GRN','XYZ856344724','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6485,'XYZ-1768195204681-43B91B1E',1,NULL,'IN_STOCK','GRN','XYZ089545074','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6486,'XYZ-1768195204706-611AD5A9',1,NULL,'IN_STOCK','GRN','XYZ250480479','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6487,'XYZ-1768195204727-F5F0FD6E',1,NULL,'IN_STOCK','GRN','XYZ727490416','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6488,'XYZ-1768195204748-AF3632F5',1,NULL,'IN_STOCK','GRN','XYZ306083882','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6489,'XYZ-1768195204769-62F8C216',1,NULL,'IN_STOCK','GRN','XYZ749223386','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6490,'XYZ-1768195204793-58140B02',1,NULL,'IN_STOCK','GRN','XYZ969785933','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6491,'XYZ-1768195204814-6204E0E2',1,NULL,'IN_STOCK','GRN','XYZ559251282','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6492,'XYZ-1768195204836-80997D52',1,NULL,'IN_STOCK','GRN','XYZ371377963','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6493,'XYZ-1768195204858-66850EC2',1,NULL,'IN_STOCK','GRN','XYZ211999642','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6494,'XYZ-1768195204880-0C6215AB',1,NULL,'IN_STOCK','GRN','XYZ164705188','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6495,'XYZ-1768195204905-7C842AD3',1,NULL,'IN_STOCK','GRN','XYZ481720018','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6496,'XYZ-1768195204926-D8AA5A44',1,NULL,'IN_STOCK','GRN','XYZ388852500','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6497,'XYZ-1768195204949-7E0101B2',1,NULL,'IN_STOCK','GRN','XYZ470344350','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6498,'XYZ-1768195204970-93FB0389',1,NULL,'IN_STOCK','GRN','XYZ325584207','2026-01-12 05:20:04','2026-01-12 05:20:04'),(6499,'XYZ-1768195204993-8A81D281',1,NULL,'IN_STOCK','GRN','XYZ403052365','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6500,'XYZ-1768195205016-129E56A5',1,NULL,'IN_STOCK','GRN','XYZ024073385','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6501,'XYZ-1768195205039-35BB9C36',1,NULL,'IN_STOCK','GRN','XYZ758538798','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6502,'XYZ-1768195205060-BD17CAEB',1,NULL,'IN_STOCK','GRN','XYZ292838043','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6503,'XYZ-1768195205083-FA7EBFBE',1,NULL,'IN_STOCK','GRN','XYZ357049682','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6504,'XYZ-1768195205105-73745B3A',1,NULL,'IN_STOCK','GRN','XYZ850704644','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6505,'XYZ-1768195205126-8BA80B12',1,NULL,'IN_STOCK','GRN','XYZ366396173','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6506,'XYZ-1768195205148-A39A5E97',1,NULL,'IN_STOCK','GRN','XYZ713865780','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6507,'XYZ-1768195205169-4C97B4EF',1,NULL,'IN_STOCK','GRN','XYZ912694932','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6508,'XYZ-1768195205190-6BD20B53',1,NULL,'IN_STOCK','GRN','XYZ448231599','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6509,'XYZ-1768195205211-5F2C6E21',1,NULL,'IN_STOCK','GRN','XYZ646321206','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6510,'XYZ-1768195205232-976B9A92',1,NULL,'IN_STOCK','GRN','XYZ629760313','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6511,'XYZ-1768195205253-DEFF81D7',1,NULL,'IN_STOCK','GRN','XYZ733915971','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6512,'XYZ-1768195205274-8B4E2725',1,NULL,'IN_STOCK','GRN','XYZ807792166','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6513,'XYZ-1768195205297-8B795039',1,NULL,'IN_STOCK','GRN','XYZ590173469','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6514,'XYZ-1768195205318-2DE224DD',1,NULL,'IN_STOCK','GRN','XYZ119259748','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6515,'XYZ-1768195205339-8BB85542',1,NULL,'IN_STOCK','GRN','XYZ240413392','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6516,'XYZ-1768195205360-F621D6E4',1,NULL,'IN_STOCK','GRN','XYZ227896463','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6517,'XYZ-1768195205381-6C64F3FC',1,NULL,'IN_STOCK','GRN','XYZ554847066','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6518,'XYZ-1768195205403-4DE5320C',1,NULL,'IN_STOCK','GRN','XYZ055308309','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6519,'XYZ-1768195205424-9A8AC123',1,NULL,'IN_STOCK','GRN','XYZ020013752','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6520,'XYZ-1768195205444-E5423890',1,NULL,'IN_STOCK','GRN','XYZ077058207','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6521,'XYZ-1768195205465-D35B4498',1,NULL,'IN_STOCK','GRN','XYZ748943169','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6522,'XYZ-1768195205488-569090D9',1,NULL,'IN_STOCK','GRN','XYZ237985916','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6523,'XYZ-1768195205508-32F73D90',1,NULL,'IN_STOCK','GRN','XYZ428167335','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6524,'XYZ-1768195205530-64DEEEDD',1,NULL,'IN_STOCK','GRN','XYZ347115521','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6525,'XYZ-1768195205550-70907EA2',1,NULL,'IN_STOCK','GRN','XYZ723150080','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6526,'XYZ-1768195205572-88086608',1,NULL,'IN_STOCK','GRN','XYZ728512448','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6527,'XYZ-1768195205594-09A8FCC5',1,NULL,'IN_STOCK','GRN','XYZ919584024','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6528,'XYZ-1768195205615-D477C0BA',1,NULL,'IN_STOCK','GRN','XYZ608895157','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6529,'XYZ-1768195205639-47CD5EF3',1,NULL,'IN_STOCK','GRN','XYZ614129057','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6530,'XYZ-1768195205661-7A797100',1,NULL,'IN_STOCK','GRN','XYZ929907191','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6531,'XYZ-1768195205682-D345D448',1,NULL,'IN_STOCK','GRN','XYZ859236795','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6532,'XYZ-1768195205705-B57EFE5B',1,NULL,'IN_STOCK','GRN','XYZ251995379','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6533,'XYZ-1768195205727-01E74888',1,NULL,'IN_STOCK','GRN','XYZ865261826','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6534,'XYZ-1768195205758-D0B2F1C7',1,NULL,'IN_STOCK','GRN','XYZ096934619','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6535,'XYZ-1768195205785-6B642576',1,NULL,'IN_STOCK','GRN','XYZ735412654','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6536,'XYZ-1768195205811-23866CB3',1,NULL,'IN_STOCK','GRN','XYZ970461411','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6537,'XYZ-1768195205833-6F637877',1,NULL,'IN_STOCK','GRN','XYZ472587613','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6538,'XYZ-1768195205856-83B9CCD4',1,NULL,'IN_STOCK','GRN','XYZ128806784','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6539,'XYZ-1768195205880-F4569FBE',1,NULL,'IN_STOCK','GRN','XYZ591486789','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6540,'XYZ-1768195205908-328AFD68',1,NULL,'IN_STOCK','GRN','XYZ096135936','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6541,'XYZ-1768195205935-2947BDA2',1,NULL,'IN_STOCK','GRN','XYZ014916962','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6542,'XYZ-1768195205960-A34C6354',1,NULL,'IN_STOCK','GRN','XYZ336429393','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6543,'XYZ-1768195205984-D8F33936',1,NULL,'IN_STOCK','GRN','XYZ497120400','2026-01-12 05:20:05','2026-01-12 05:20:05'),(6544,'XYZ-1768195206006-EE91ED5C',1,NULL,'IN_STOCK','GRN','XYZ527727327','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6545,'XYZ-1768195206029-B07F4EED',1,NULL,'IN_STOCK','GRN','XYZ903941526','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6546,'XYZ-1768195206054-5950BA46',1,NULL,'IN_STOCK','GRN','XYZ759666995','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6547,'XYZ-1768195206083-ABC94E7A',1,NULL,'IN_STOCK','GRN','XYZ568445289','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6548,'XYZ-1768195206111-8AED6006',1,NULL,'IN_STOCK','GRN','XYZ077002078','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6549,'XYZ-1768195206139-9C55BB84',1,NULL,'IN_STOCK','GRN','XYZ049711055','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6550,'XYZ-1768195206167-C31147FE',1,NULL,'IN_STOCK','GRN','XYZ637229649','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6551,'XYZ-1768195206192-4B914DEB',1,NULL,'IN_STOCK','GRN','XYZ638674384','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6552,'XYZ-1768195206219-210FD202',1,NULL,'IN_STOCK','GRN','XYZ335281888','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6553,'XYZ-1768195206244-10472892',1,NULL,'IN_STOCK','GRN','XYZ062158224','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6554,'XYZ-1768195206272-2024A3B9',1,NULL,'IN_STOCK','GRN','XYZ530849917','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6555,'XYZ-1768195206296-0797E55D',1,NULL,'IN_STOCK','GRN','XYZ887478043','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6556,'XYZ-1768195206321-26D135CC',1,NULL,'IN_STOCK','GRN','XYZ588018649','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6557,'XYZ-1768195206348-B6B03F2D',1,NULL,'IN_STOCK','GRN','XYZ917139604','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6558,'XYZ-1768195206376-715DD825',1,NULL,'IN_STOCK','GRN','XYZ604646194','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6559,'XYZ-1768195206403-547B5039',1,NULL,'IN_STOCK','GRN','XYZ040979442','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6560,'XYZ-1768195206428-E54C6017',1,NULL,'IN_STOCK','GRN','XYZ657857325','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6561,'XYZ-1768195206455-1EB65464',1,NULL,'IN_STOCK','GRN','XYZ180636113','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6562,'XYZ-1768195206482-9431B801',1,NULL,'IN_STOCK','GRN','XYZ976673899','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6563,'XYZ-1768195206509-9469C449',1,NULL,'IN_STOCK','GRN','XYZ635031397','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6564,'XYZ-1768195206535-257B6938',1,NULL,'IN_STOCK','GRN','XYZ782225556','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6565,'XYZ-1768195206562-8BED49B3',1,NULL,'IN_STOCK','GRN','XYZ854811035','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6566,'XYZ-1768195206590-AB3E9EEF',1,NULL,'IN_STOCK','GRN','XYZ845824216','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6567,'XYZ-1768195206618-DFFBAAA2',1,NULL,'IN_STOCK','GRN','XYZ812510826','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6568,'XYZ-1768195206645-45AC5B8A',1,NULL,'IN_STOCK','GRN','XYZ904824010','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6569,'XYZ-1768195206673-2CEA5AF2',1,NULL,'IN_STOCK','GRN','XYZ916999562','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6570,'XYZ-1768195206699-5ECB3DBD',1,NULL,'IN_STOCK','GRN','XYZ942494032','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6571,'XYZ-1768195206726-EE570D9C',1,NULL,'IN_STOCK','GRN','XYZ427552755','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6572,'XYZ-1768195206751-FCD940CE',1,NULL,'IN_STOCK','GRN','XYZ333759401','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6573,'XYZ-1768195206773-2CA7E66A',1,NULL,'IN_STOCK','GRN','XYZ423088947','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6574,'XYZ-1768195206801-01588765',1,NULL,'IN_STOCK','GRN','XYZ572962321','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6575,'XYZ-1768195206827-0BAE33FA',1,NULL,'IN_STOCK','GRN','XYZ236361990','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6576,'XYZ-1768195206850-8B8D088C',1,NULL,'IN_STOCK','GRN','XYZ689154042','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6577,'XYZ-1768195206874-6973C5E1',1,NULL,'IN_STOCK','GRN','XYZ462924597','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6578,'XYZ-1768195206895-3E3BCD56',1,NULL,'IN_STOCK','GRN','XYZ373437118','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6579,'XYZ-1768195206921-326743F1',1,NULL,'IN_STOCK','GRN','XYZ631455723','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6580,'XYZ-1768195206944-74A75C8B',1,NULL,'IN_STOCK','GRN','XYZ858350413','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6581,'XYZ-1768195206971-E1FECE0D',1,NULL,'IN_STOCK','GRN','XYZ789138399','2026-01-12 05:20:06','2026-01-12 05:20:06'),(6582,'XYZ-1768195206995-8E9742E5',1,NULL,'IN_STOCK','GRN','XYZ999331346','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6583,'XYZ-1768195207022-FA879382',1,NULL,'IN_STOCK','GRN','XYZ246858363','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6584,'XYZ-1768195207050-327649CC',1,NULL,'IN_STOCK','GRN','XYZ342222880','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6585,'XYZ-1768195207075-DDC122E9',1,NULL,'IN_STOCK','GRN','XYZ323025253','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6586,'XYZ-1768195207100-489EBC87',1,NULL,'IN_STOCK','GRN','XYZ795545554','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6587,'XYZ-1768195207128-F556A17B',1,NULL,'IN_STOCK','GRN','XYZ503953944','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6588,'XYZ-1768195207156-3CE14F74',1,NULL,'IN_STOCK','GRN','XYZ651997437','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6589,'XYZ-1768195207182-9970FC2D',1,NULL,'IN_STOCK','GRN','XYZ333098822','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6590,'XYZ-1768195207207-A699B66E',1,NULL,'IN_STOCK','GRN','XYZ841592567','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6591,'XYZ-1768195207230-31A0F25E',1,NULL,'IN_STOCK','GRN','XYZ881810115','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6592,'XYZ-1768195207256-BD1DAE3B',1,NULL,'IN_STOCK','GRN','XYZ871972073','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6593,'XYZ-1768195207281-C8B170A8',1,NULL,'IN_STOCK','GRN','XYZ295113856','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6594,'XYZ-1768195207308-9D67DE9B',1,NULL,'IN_STOCK','GRN','XYZ066395940','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6595,'XYZ-1768195207336-6C472EFF',1,NULL,'IN_STOCK','GRN','XYZ830655999','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6596,'XYZ-1768195207363-376FA01D',1,NULL,'IN_STOCK','GRN','XYZ258592668','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6597,'XYZ-1768195207389-3D2B25DF',1,NULL,'IN_STOCK','GRN','XYZ088206827','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6598,'XYZ-1768195207416-B573A4F5',1,NULL,'IN_STOCK','GRN','XYZ097880399','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6599,'XYZ-1768195207439-D2EDC678',1,NULL,'IN_STOCK','GRN','XYZ409656691','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6600,'XYZ-1768195207462-08D8BE16',1,NULL,'IN_STOCK','GRN','XYZ751209580','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6601,'XYZ-1768195207487-24A7C64F',1,NULL,'IN_STOCK','GRN','XYZ033284023','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6602,'XYZ-1768195207510-D02669A3',1,NULL,'IN_STOCK','GRN','XYZ086101874','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6603,'XYZ-1768195207533-6F84123B',1,NULL,'IN_STOCK','GRN','XYZ820095516','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6604,'XYZ-1768195207560-7DC5CF9E',1,NULL,'IN_STOCK','GRN','XYZ942093517','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6605,'XYZ-1768195207586-88F13909',1,NULL,'IN_STOCK','GRN','XYZ667999213','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6606,'XYZ-1768195207609-3B26C67B',1,NULL,'IN_STOCK','GRN','XYZ780197097','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6607,'XYZ-1768195207635-6D3645C6',1,NULL,'IN_STOCK','GRN','XYZ275974054','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6608,'XYZ-1768195207662-8A46BAE7',1,NULL,'IN_STOCK','GRN','XYZ090852092','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6609,'XYZ-1768195207690-CC710B8A',1,NULL,'IN_STOCK','GRN','XYZ289649737','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6610,'XYZ-1768195207716-C0973903',1,NULL,'IN_STOCK','GRN','XYZ515366419','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6611,'XYZ-1768195207745-5FC0F753',1,NULL,'IN_STOCK','GRN','XYZ711484014','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6612,'XYZ-1768195207773-28193277',1,NULL,'IN_STOCK','GRN','XYZ001854921','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6613,'XYZ-1768195207801-DAD53FEF',1,NULL,'IN_STOCK','GRN','XYZ437795016','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6614,'XYZ-1768195207827-3FD33DFE',1,NULL,'IN_STOCK','GRN','XYZ953563513','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6615,'XYZ-1768195207855-B47C739E',1,NULL,'IN_STOCK','GRN','XYZ656045692','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6616,'XYZ-1768195207881-9E3CC96C',1,NULL,'IN_STOCK','GRN','XYZ989174447','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6617,'XYZ-1768195207905-0323F64E',1,NULL,'IN_STOCK','GRN','XYZ332630999','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6618,'XYZ-1768195207930-B3DDE85D',1,NULL,'IN_STOCK','GRN','XYZ072839466','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6619,'XYZ-1768195207958-297D8CFA',1,NULL,'IN_STOCK','GRN','XYZ444798494','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6620,'XYZ-1768195207984-4A2B9D1A',1,NULL,'IN_STOCK','GRN','XYZ274447458','2026-01-12 05:20:07','2026-01-12 05:20:07'),(6621,'XYZ-1768195208012-54752233',1,NULL,'IN_STOCK','GRN','XYZ982535338','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6622,'XYZ-1768195208039-FE47E3E7',1,NULL,'IN_STOCK','GRN','XYZ306532973','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6623,'XYZ-1768195208066-B0A1C7B4',1,NULL,'IN_STOCK','GRN','XYZ750493700','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6624,'XYZ-1768195208093-1F187494',1,NULL,'IN_STOCK','GRN','XYZ465069648','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6625,'XYZ-1768195208118-244A870C',1,NULL,'IN_STOCK','GRN','XYZ602597138','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6626,'XYZ-1768195208143-B2BFAFAE',1,NULL,'IN_STOCK','GRN','XYZ011595122','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6627,'XYZ-1768195208170-0E097487',1,NULL,'IN_STOCK','GRN','XYZ819690619','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6628,'XYZ-1768195208197-6000F829',1,NULL,'IN_STOCK','GRN','XYZ625994139','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6629,'XYZ-1768195208224-FB1A4A2D',1,NULL,'IN_STOCK','GRN','XYZ084322737','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6630,'XYZ-1768195208250-E80E3EAF',1,NULL,'IN_STOCK','GRN','XYZ190059485','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6631,'XYZ-1768195208279-C472E188',1,NULL,'IN_STOCK','GRN','XYZ333477072','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6632,'XYZ-1768195208305-26CDB234',1,NULL,'IN_STOCK','GRN','XYZ679240796','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6633,'XYZ-1768195208330-E7D2AFF8',1,NULL,'IN_STOCK','GRN','XYZ763822940','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6634,'XYZ-1768195208356-9BDD7519',1,NULL,'IN_STOCK','GRN','XYZ913280073','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6635,'XYZ-1768195208384-74FDF193',1,NULL,'IN_STOCK','GRN','XYZ983787038','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6636,'XYZ-1768195208411-92300482',1,NULL,'IN_STOCK','GRN','XYZ746484956','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6637,'XYZ-1768195208438-83973F1F',1,NULL,'IN_STOCK','GRN','XYZ475707440','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6638,'XYZ-1768195208467-DF2D3EBC',1,NULL,'IN_STOCK','GRN','XYZ130987026','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6639,'XYZ-1768195208490-A5EF783E',1,NULL,'IN_STOCK','GRN','XYZ539437031','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6640,'XYZ-1768195208511-A501BC0B',1,NULL,'IN_STOCK','GRN','XYZ672793272','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6641,'XYZ-1768195208535-4FC3F5C1',1,NULL,'IN_STOCK','GRN','XYZ004511255','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6642,'XYZ-1768195208562-37CA502D',1,NULL,'IN_STOCK','GRN','XYZ673197031','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6643,'XYZ-1768195208589-053711B0',1,NULL,'IN_STOCK','GRN','XYZ464612824','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6644,'XYZ-1768195208616-E79225D0',1,NULL,'IN_STOCK','GRN','XYZ791347630','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6645,'XYZ-1768195208640-D5FFCE34',1,NULL,'IN_STOCK','GRN','XYZ376083595','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6646,'XYZ-1768195208668-79223F67',1,NULL,'IN_STOCK','GRN','XYZ690671575','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6647,'XYZ-1768195208696-9BFE8021',1,NULL,'IN_STOCK','GRN','XYZ477813681','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6648,'XYZ-1768195208721-266E338A',1,NULL,'IN_STOCK','GRN','XYZ086508972','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6649,'XYZ-1768195208749-70B5DFB3',1,NULL,'IN_STOCK','GRN','XYZ750070413','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6650,'XYZ-1768195208777-D7AA523D',1,NULL,'IN_STOCK','GRN','XYZ784758701','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6651,'XYZ-1768195208805-44A03901',1,NULL,'IN_STOCK','GRN','XYZ499340828','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6652,'XYZ-1768195208831-07237EB5',1,NULL,'IN_STOCK','GRN','XYZ365905394','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6653,'XYZ-1768195208860-AA95723C',1,NULL,'IN_STOCK','GRN','XYZ398927958','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6654,'XYZ-1768195208888-C1D19327',1,NULL,'IN_STOCK','GRN','XYZ011161354','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6655,'XYZ-1768195208912-79B4DBE8',1,NULL,'IN_STOCK','GRN','XYZ467511662','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6656,'XYZ-1768195208935-D052ACB5',1,NULL,'IN_STOCK','GRN','XYZ759413923','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6657,'XYZ-1768195208962-97BB6325',1,NULL,'IN_STOCK','GRN','XYZ712956787','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6658,'XYZ-1768195208987-C511F0BE',1,NULL,'IN_STOCK','GRN','XYZ904271552','2026-01-12 05:20:08','2026-01-12 05:20:08'),(6659,'XYZ-1768195209014-E7868B72',1,NULL,'IN_STOCK','GRN','XYZ720877994','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6660,'XYZ-1768195209040-8E7215C9',1,NULL,'IN_STOCK','GRN','XYZ687393181','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6661,'XYZ-1768195209065-B9F812B1',1,NULL,'IN_STOCK','GRN','XYZ354001558','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6662,'XYZ-1768195209088-B60FC5EB',1,NULL,'IN_STOCK','GRN','XYZ717864663','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6663,'XYZ-1768195209111-54B535A4',1,NULL,'IN_STOCK','GRN','XYZ948195591','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6664,'XYZ-1768195209137-A6117AE1',1,NULL,'IN_STOCK','GRN','XYZ814864824','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6665,'XYZ-1768195209160-2129803C',1,NULL,'IN_STOCK','GRN','XYZ208930741','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6666,'XYZ-1768195209182-BE12DDFC',1,NULL,'IN_STOCK','GRN','XYZ211051085','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6667,'XYZ-1768195209205-0A6F6B28',1,NULL,'IN_STOCK','GRN','XYZ043938402','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6668,'XYZ-1768195209228-B3ADE52C',1,NULL,'IN_STOCK','GRN','XYZ425596036','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6669,'XYZ-1768195209252-5290CAD6',1,NULL,'IN_STOCK','GRN','XYZ099433242','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6670,'XYZ-1768195209280-23FBD4E1',1,NULL,'IN_STOCK','GRN','XYZ020165615','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6671,'XYZ-1768195209303-6D5E5CEF',1,NULL,'IN_STOCK','GRN','XYZ739948347','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6672,'XYZ-1768195209329-26E22717',1,NULL,'IN_STOCK','GRN','XYZ229101480','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6673,'XYZ-1768195209355-315112D0',1,NULL,'IN_STOCK','GRN','XYZ480877159','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6674,'XYZ-1768195209382-0A192F39',1,NULL,'IN_STOCK','GRN','XYZ512903185','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6675,'XYZ-1768195209406-159941B9',1,NULL,'IN_STOCK','GRN','XYZ178752164','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6676,'XYZ-1768195209434-6C232EA1',1,NULL,'IN_STOCK','GRN','XYZ340499874','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6677,'XYZ-1768195209463-FA277784',1,NULL,'IN_STOCK','GRN','XYZ554313178','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6678,'XYZ-1768195209489-77090277',1,NULL,'IN_STOCK','GRN','XYZ191102971','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6679,'XYZ-1768195209515-F0EF640E',1,NULL,'IN_STOCK','GRN','XYZ295133943','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6680,'XYZ-1768195209543-F5CAA851',1,NULL,'IN_STOCK','GRN','XYZ410102138','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6681,'XYZ-1768195209572-B97177DA',1,NULL,'IN_STOCK','GRN','XYZ238665833','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6682,'XYZ-1768195209599-7D172667',1,NULL,'IN_STOCK','GRN','XYZ321112755','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6683,'XYZ-1768195209624-1AE9CFCF',1,NULL,'IN_STOCK','GRN','XYZ880714363','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6684,'XYZ-1768195209650-47BE11EA',1,NULL,'IN_STOCK','GRN','XYZ413634282','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6685,'XYZ-1768195209670-89B96C89',1,NULL,'IN_STOCK','GRN','XYZ917596982','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6686,'XYZ-1768195209690-0A961874',1,NULL,'IN_STOCK','GRN','XYZ412434091','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6687,'XYZ-1768195209709-038EEDB5',1,NULL,'IN_STOCK','GRN','XYZ412759651','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6688,'XYZ-1768195209729-59CB15DF',1,NULL,'IN_STOCK','GRN','XYZ253841072','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6689,'XYZ-1768195209750-8712F7B1',1,NULL,'IN_STOCK','GRN','XYZ082479862','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6690,'XYZ-1768195209773-4E4D2287',1,NULL,'IN_STOCK','GRN','XYZ344523197','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6691,'XYZ-1768195209799-5E1D29BF',1,NULL,'IN_STOCK','GRN','XYZ394184966','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6692,'XYZ-1768195209827-4D9A2C6D',1,NULL,'IN_STOCK','GRN','XYZ036222602','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6693,'XYZ-1768195209851-86CC8474',1,NULL,'IN_STOCK','GRN','XYZ858064736','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6694,'XYZ-1768195209877-C972E45D',1,NULL,'IN_STOCK','GRN','XYZ801923408','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6695,'XYZ-1768195209905-EE41715E',1,NULL,'IN_STOCK','GRN','XYZ298673910','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6696,'XYZ-1768195209931-3039E03B',1,NULL,'IN_STOCK','GRN','XYZ497488497','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6697,'XYZ-1768195209956-5C8F9C13',1,NULL,'IN_STOCK','GRN','XYZ674992278','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6698,'XYZ-1768195209982-7AECB574',1,NULL,'IN_STOCK','GRN','XYZ501892844','2026-01-12 05:20:09','2026-01-12 05:20:09'),(6699,'XYZ-1768195210007-5A048BF1',1,NULL,'IN_STOCK','GRN','XYZ184515954','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6700,'XYZ-1768195210030-0DF28AF2',1,NULL,'IN_STOCK','GRN','XYZ474755267','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6701,'XYZ-1768195210052-2FD3DCC9',1,NULL,'IN_STOCK','GRN','XYZ733693829','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6702,'XYZ-1768195210073-80F7DF0B',1,NULL,'IN_STOCK','GRN','XYZ289322736','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6703,'XYZ-1768195210095-3AF0A0F3',1,NULL,'IN_STOCK','GRN','XYZ281197671','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6704,'XYZ-1768195210116-8E163C74',1,NULL,'IN_STOCK','GRN','XYZ677725032','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6705,'XYZ-1768195210138-A247F92A',1,NULL,'IN_STOCK','GRN','XYZ345847212','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6706,'XYZ-1768195210160-F54FAB00',1,NULL,'IN_STOCK','GRN','XYZ948752883','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6707,'XYZ-1768195210181-285AA533',1,NULL,'IN_STOCK','GRN','XYZ515126128','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6708,'XYZ-1768195210203-0BF10168',1,NULL,'IN_STOCK','GRN','XYZ783716049','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6709,'XYZ-1768195210224-69D9C5F4',1,NULL,'IN_STOCK','GRN','XYZ729193680','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6710,'XYZ-1768195210247-EC04C103',1,NULL,'IN_STOCK','GRN','XYZ145811240','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6711,'XYZ-1768195210269-ED0413DA',1,NULL,'IN_STOCK','GRN','XYZ692338965','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6712,'XYZ-1768195210290-BD0D66C2',1,NULL,'IN_STOCK','GRN','XYZ108796901','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6713,'XYZ-1768195210313-7E8C28C7',1,NULL,'IN_STOCK','GRN','XYZ115994538','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6714,'XYZ-1768195210337-F34DEAC5',1,NULL,'IN_STOCK','GRN','XYZ562424246','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6715,'XYZ-1768195210360-3A5CD036',1,NULL,'IN_STOCK','GRN','XYZ363331891','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6716,'XYZ-1768195210383-9AC81718',1,NULL,'IN_STOCK','GRN','XYZ749067595','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6717,'XYZ-1768195210404-A67A331A',1,NULL,'IN_STOCK','GRN','XYZ221028310','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6718,'XYZ-1768195210427-AB1A3B7A',1,NULL,'IN_STOCK','GRN','XYZ225767939','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6719,'XYZ-1768195210449-8D814135',1,NULL,'IN_STOCK','GRN','XYZ938385718','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6720,'XYZ-1768195210474-6641CC98',1,NULL,'IN_STOCK','GRN','XYZ139583219','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6721,'XYZ-1768195210495-EC1794BB',1,NULL,'IN_STOCK','GRN','XYZ471824725','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6722,'XYZ-1768195210519-FF286B41',1,NULL,'IN_STOCK','GRN','XYZ908951604','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6723,'XYZ-1768195210541-61861F30',1,NULL,'IN_STOCK','GRN','XYZ763872781','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6724,'XYZ-1768195210564-F13A70D7',1,NULL,'IN_STOCK','GRN','XYZ054687160','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6725,'XYZ-1768195210590-EDC1F918',1,NULL,'IN_STOCK','GRN','XYZ821595801','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6726,'XYZ-1768195210612-12B9A12A',1,NULL,'IN_STOCK','GRN','XYZ753556027','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6727,'XYZ-1768195210633-3AE1E40E',1,NULL,'IN_STOCK','GRN','XYZ296185177','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6728,'XYZ-1768195210654-71E917F5',1,NULL,'IN_STOCK','GRN','XYZ953335582','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6729,'XYZ-1768195210679-59E32533',1,NULL,'IN_STOCK','GRN','XYZ435399867','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6730,'XYZ-1768195210700-5D646D43',1,NULL,'IN_STOCK','GRN','XYZ989763426','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6731,'XYZ-1768195210721-40183E34',1,NULL,'IN_STOCK','GRN','XYZ639392756','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6732,'XYZ-1768195210740-D0111241',1,NULL,'IN_STOCK','GRN','XYZ350320461','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6733,'XYZ-1768195210759-17C98D87',1,NULL,'IN_STOCK','GRN','XYZ421584435','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6734,'XYZ-1768195210778-4F8E61DE',1,NULL,'IN_STOCK','GRN','XYZ418833297','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6735,'XYZ-1768195210796-DC496CE7',1,NULL,'IN_STOCK','GRN','XYZ236725000','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6736,'XYZ-1768195210816-F70F5F73',1,NULL,'IN_STOCK','GRN','XYZ896290147','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6737,'XYZ-1768195210837-FDAACE51',1,NULL,'IN_STOCK','GRN','XYZ552588263','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6738,'XYZ-1768195210863-D120BB38',1,NULL,'IN_STOCK','GRN','XYZ475809582','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6739,'XYZ-1768195210887-505D63F3',1,NULL,'IN_STOCK','GRN','XYZ351301870','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6740,'XYZ-1768195210908-5939F005',1,NULL,'IN_STOCK','GRN','XYZ912089441','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6741,'XYZ-1768195210929-A0EDDD74',1,NULL,'IN_STOCK','GRN','XYZ010025822','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6742,'XYZ-1768195210951-2773D425',1,NULL,'IN_STOCK','GRN','XYZ107414596','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6743,'XYZ-1768195210973-84F057DE',1,NULL,'IN_STOCK','GRN','XYZ457056692','2026-01-12 05:20:10','2026-01-12 05:20:10'),(6744,'XYZ-1768195210994-8A00033A',1,NULL,'IN_STOCK','GRN','XYZ742943383','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6745,'XYZ-1768195211016-676CB516',1,NULL,'IN_STOCK','GRN','XYZ375606258','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6746,'XYZ-1768195211038-92127815',1,NULL,'IN_STOCK','GRN','XYZ227325426','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6747,'XYZ-1768195211062-D986AC50',1,NULL,'IN_STOCK','GRN','XYZ792780824','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6748,'XYZ-1768195211084-148A6654',1,NULL,'IN_STOCK','GRN','XYZ318891004','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6749,'XYZ-1768195211105-E567D89E',1,NULL,'IN_STOCK','GRN','XYZ371019455','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6750,'XYZ-1768195211128-B2D9F71A',1,NULL,'IN_STOCK','GRN','XYZ136007449','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6751,'XYZ-1768195211153-9E3A5EB1',1,NULL,'IN_STOCK','GRN','XYZ719694467','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6752,'XYZ-1768195211176-4A2EF01E',1,NULL,'IN_STOCK','GRN','XYZ356695146','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6753,'XYZ-1768195211198-8D29948D',1,NULL,'IN_STOCK','GRN','XYZ019354332','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6754,'XYZ-1768195211219-B9F3D888',1,NULL,'IN_STOCK','GRN','XYZ708023419','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6755,'XYZ-1768195211241-D4625C7E',1,NULL,'IN_STOCK','GRN','XYZ170103025','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6756,'XYZ-1768195211264-D6512E32',1,NULL,'IN_STOCK','GRN','XYZ627059607','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6757,'XYZ-1768195211289-98684FBF',1,NULL,'IN_STOCK','GRN','XYZ517620809','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6758,'XYZ-1768195211313-9703F832',1,NULL,'IN_STOCK','GRN','XYZ339777880','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6759,'XYZ-1768195211335-1B1B4CDD',1,NULL,'IN_STOCK','GRN','XYZ502722540','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6760,'XYZ-1768195211355-03F9873A',1,NULL,'IN_STOCK','GRN','XYZ773065099','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6761,'XYZ-1768195211378-BBAE7E2E',1,NULL,'IN_STOCK','GRN','XYZ915114722','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6762,'XYZ-1768195211400-59C4F1A4',1,NULL,'IN_STOCK','GRN','XYZ419823797','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6763,'XYZ-1768195211421-C380DCAC',1,NULL,'IN_STOCK','GRN','XYZ833233515','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6764,'XYZ-1768195211445-8106213D',1,NULL,'IN_STOCK','GRN','XYZ575479051','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6765,'XYZ-1768195211467-2613D6EF',1,NULL,'IN_STOCK','GRN','XYZ378893274','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6766,'XYZ-1768195211490-7D93DA93',1,NULL,'IN_STOCK','GRN','XYZ879228815','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6767,'XYZ-1768195211511-3F5FD34B',1,NULL,'IN_STOCK','GRN','XYZ902589476','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6768,'XYZ-1768195211533-17A07278',1,NULL,'IN_STOCK','GRN','XYZ554979745','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6769,'XYZ-1768195211554-E81FCB5C',1,NULL,'IN_STOCK','GRN','XYZ356305026','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6770,'XYZ-1768195211576-97B026AC',1,NULL,'IN_STOCK','GRN','XYZ859584574','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6771,'XYZ-1768195211599-2A938A63',1,NULL,'IN_STOCK','GRN','XYZ406571022','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6772,'XYZ-1768195211620-019BBFD8',1,NULL,'IN_STOCK','GRN','XYZ482021309','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6773,'XYZ-1768195211641-3EDAEB29',1,NULL,'IN_STOCK','GRN','XYZ995034805','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6774,'XYZ-1768195211663-5A44A574',1,NULL,'IN_STOCK','GRN','XYZ750108989','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6775,'XYZ-1768195211685-54C11565',1,NULL,'IN_STOCK','GRN','XYZ649485540','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6776,'XYZ-1768195211706-4998427B',1,NULL,'IN_STOCK','GRN','XYZ020569609','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6777,'XYZ-1768195211727-E2F00355',1,NULL,'IN_STOCK','GRN','XYZ199716039','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6778,'XYZ-1768195211750-020DC6CE',1,NULL,'IN_STOCK','GRN','XYZ631663631','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6779,'XYZ-1768195211772-18A35E47',1,NULL,'IN_STOCK','GRN','XYZ567569138','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6780,'XYZ-1768195211795-424522BA',1,NULL,'IN_STOCK','GRN','XYZ656244825','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6781,'XYZ-1768195211816-7EC55CE7',1,NULL,'IN_STOCK','GRN','XYZ136559018','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6782,'XYZ-1768195211837-AC87BFBA',1,NULL,'IN_STOCK','GRN','XYZ704483889','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6783,'XYZ-1768195211859-E35CD85E',1,NULL,'IN_STOCK','GRN','XYZ059494090','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6784,'XYZ-1768195211880-8E8B16DE',1,NULL,'IN_STOCK','GRN','XYZ257193324','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6785,'XYZ-1768195211902-2A6C5F7A',1,NULL,'IN_STOCK','GRN','XYZ661456931','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6786,'XYZ-1768195211923-D33E5BE5',1,NULL,'IN_STOCK','GRN','XYZ546716259','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6787,'XYZ-1768195211945-41984284',1,NULL,'IN_STOCK','GRN','XYZ532731254','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6788,'XYZ-1768195211966-7A8AD620',1,NULL,'IN_STOCK','GRN','XYZ695212089','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6789,'XYZ-1768195211988-DBC9B1EB',1,NULL,'IN_STOCK','GRN','XYZ864776360','2026-01-12 05:20:11','2026-01-12 05:20:11'),(6790,'XYZ-1768195212010-62B87F5E',1,NULL,'IN_STOCK','GRN','XYZ488003857','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6791,'XYZ-1768195212032-7CE6AC39',1,NULL,'IN_STOCK','GRN','XYZ935026443','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6792,'XYZ-1768195212055-CE12A6BA',1,NULL,'IN_STOCK','GRN','XYZ049323871','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6793,'XYZ-1768195212078-79FCC374',1,NULL,'IN_STOCK','GRN','XYZ196528413','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6794,'XYZ-1768195212100-C28CB162',1,NULL,'IN_STOCK','GRN','XYZ246799708','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6795,'XYZ-1768195212124-EDF2DA20',1,NULL,'IN_STOCK','GRN','XYZ209479119','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6796,'XYZ-1768195212147-7DA11A06',1,NULL,'IN_STOCK','GRN','XYZ107637770','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6797,'XYZ-1768195212172-41D59C82',1,NULL,'IN_STOCK','GRN','XYZ621051989','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6798,'XYZ-1768195212197-D3C61444',1,NULL,'IN_STOCK','GRN','XYZ438322896','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6799,'XYZ-1768195212222-E1AA2836',1,NULL,'IN_STOCK','GRN','XYZ667843612','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6800,'XYZ-1768195212244-5D7D2D88',1,NULL,'IN_STOCK','GRN','XYZ554246943','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6801,'XYZ-1768195212266-B3D67FC1',1,NULL,'IN_STOCK','GRN','XYZ949672797','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6802,'XYZ-1768195212289-A788E6E0',1,NULL,'IN_STOCK','GRN','XYZ662550311','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6803,'XYZ-1768195212310-1FA4883F',1,NULL,'IN_STOCK','GRN','XYZ839073842','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6804,'XYZ-1768195212331-E2C4F866',1,NULL,'IN_STOCK','GRN','XYZ985886754','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6805,'XYZ-1768195212353-274FB6E4',1,NULL,'IN_STOCK','GRN','XYZ348170453','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6806,'XYZ-1768195212374-DC36CDC2',1,NULL,'IN_STOCK','GRN','XYZ215803929','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6807,'XYZ-1768195212398-697A38BF',1,NULL,'IN_STOCK','GRN','XYZ119787507','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6808,'XYZ-1768195212420-9C4CFF40',1,NULL,'IN_STOCK','GRN','XYZ767032734','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6809,'XYZ-1768195212443-6836EEBC',1,NULL,'IN_STOCK','GRN','XYZ623810561','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6810,'XYZ-1768195212470-7B621267',1,NULL,'IN_STOCK','GRN','XYZ999169902','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6811,'XYZ-1768195212491-17D4D7FA',1,NULL,'IN_STOCK','GRN','XYZ568696730','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6812,'XYZ-1768195212512-6A237073',1,NULL,'IN_STOCK','GRN','XYZ938836648','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6813,'XYZ-1768195212533-84874E8D',1,NULL,'IN_STOCK','GRN','XYZ800667962','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6814,'XYZ-1768195212555-D407B080',1,NULL,'IN_STOCK','GRN','XYZ687557882','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6815,'XYZ-1768195212576-B43671B7',1,NULL,'IN_STOCK','GRN','XYZ712389325','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6816,'XYZ-1768195212597-5EB14ADF',1,NULL,'IN_STOCK','GRN','XYZ159564397','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6817,'XYZ-1768195212619-C8FF0D44',1,NULL,'IN_STOCK','GRN','XYZ726703780','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6818,'XYZ-1768195212641-9BB7A144',1,NULL,'IN_STOCK','GRN','XYZ763492860','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6819,'XYZ-1768195212661-17FE4C41',1,NULL,'IN_STOCK','GRN','XYZ122513580','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6820,'XYZ-1768195212683-C8A32F11',1,NULL,'IN_STOCK','GRN','XYZ045358162','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6821,'XYZ-1768195212707-3A56EF25',1,NULL,'IN_STOCK','GRN','XYZ451546001','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6822,'XYZ-1768195212730-EDE149A1',1,NULL,'IN_STOCK','GRN','XYZ375625860','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6823,'XYZ-1768195212753-B307868C',1,NULL,'IN_STOCK','GRN','XYZ293229621','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6824,'XYZ-1768195212777-68400312',1,NULL,'IN_STOCK','GRN','XYZ737271498','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6825,'XYZ-1768195212803-624982DE',1,NULL,'IN_STOCK','GRN','XYZ775926135','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6826,'XYZ-1768195212828-6907C9CE',1,NULL,'IN_STOCK','GRN','XYZ686626176','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6827,'XYZ-1768195212853-39F1DA47',1,NULL,'IN_STOCK','GRN','XYZ529410473','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6828,'XYZ-1768195212878-19D13E43',1,NULL,'IN_STOCK','GRN','XYZ295982764','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6829,'XYZ-1768195212903-E31C2989',1,NULL,'IN_STOCK','GRN','XYZ017712924','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6830,'XYZ-1768195212926-13D48482',1,NULL,'IN_STOCK','GRN','XYZ557886549','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6831,'XYZ-1768195212948-3CE1DA79',1,NULL,'IN_STOCK','GRN','XYZ293268904','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6832,'XYZ-1768195212969-49884FA5',1,NULL,'IN_STOCK','GRN','XYZ450316633','2026-01-12 05:20:12','2026-01-12 05:20:12'),(6833,'XYZ-1768195212991-E84CBF90',1,NULL,'IN_STOCK','GRN','XYZ856021390','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6834,'XYZ-1768195213013-6413FCF3',1,NULL,'IN_STOCK','GRN','XYZ047513203','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6835,'XYZ-1768195213035-C4FB3E27',1,NULL,'IN_STOCK','GRN','XYZ299347353','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6836,'XYZ-1768195213056-200F2888',1,NULL,'IN_STOCK','GRN','XYZ906718571','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6837,'XYZ-1768195213077-0A4593D5',1,NULL,'IN_STOCK','GRN','XYZ072299922','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6838,'XYZ-1768195213099-4D27AB75',1,NULL,'IN_STOCK','GRN','XYZ301669325','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6839,'XYZ-1768195213120-00889A44',1,NULL,'IN_STOCK','GRN','XYZ725827086','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6840,'XYZ-1768195213142-0DC376D9',1,NULL,'IN_STOCK','GRN','XYZ741846714','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6841,'XYZ-1768195213163-426D8153',1,NULL,'IN_STOCK','GRN','XYZ490059432','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6842,'XYZ-1768195213188-05FDEDF6',1,NULL,'IN_STOCK','GRN','XYZ506727010','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6843,'XYZ-1768195213206-A78B9D2E',1,NULL,'IN_STOCK','GRN','XYZ424118943','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6844,'XYZ-1768195213228-6F60B477',1,NULL,'IN_STOCK','GRN','XYZ858477856','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6845,'XYZ-1768195213253-BA9AE73C',1,NULL,'IN_STOCK','GRN','XYZ650051482','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6846,'XYZ-1768195213277-F88603F4',1,NULL,'IN_STOCK','GRN','XYZ585654247','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6847,'XYZ-1768195213298-3CFD8604',1,NULL,'IN_STOCK','GRN','XYZ713018240','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6848,'XYZ-1768195213320-86D72638',1,NULL,'IN_STOCK','GRN','XYZ858291145','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6849,'XYZ-1768195213341-9D12C32D',1,NULL,'IN_STOCK','GRN','XYZ300974741','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6850,'XYZ-1768195213362-3ED1B689',1,NULL,'IN_STOCK','GRN','XYZ310308438','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6851,'XYZ-1768195213383-769216C4',1,NULL,'IN_STOCK','GRN','XYZ952201121','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6852,'XYZ-1768195213405-73360CC0',1,NULL,'IN_STOCK','GRN','XYZ080163914','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6853,'XYZ-1768195213427-DF2012CE',1,NULL,'IN_STOCK','GRN','XYZ105534074','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6854,'XYZ-1768195213449-430724B0',1,NULL,'IN_STOCK','GRN','XYZ858008960','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6855,'XYZ-1768195213470-F90DB5A7',1,NULL,'IN_STOCK','GRN','XYZ709345037','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6856,'XYZ-1768195213492-670B079F',1,NULL,'IN_STOCK','GRN','XYZ501329413','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6857,'XYZ-1768195213514-CF8C40B5',1,NULL,'IN_STOCK','GRN','XYZ329936430','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6858,'XYZ-1768195213536-F986BAAF',1,NULL,'IN_STOCK','GRN','XYZ195284950','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6859,'XYZ-1768195213558-127057A0',1,NULL,'IN_STOCK','GRN','XYZ459630973','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6860,'XYZ-1768195213580-45C0C868',1,NULL,'IN_STOCK','GRN','XYZ646655068','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6861,'XYZ-1768195213602-199AA3D3',1,NULL,'IN_STOCK','GRN','XYZ498218379','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6862,'XYZ-1768195213624-E808F10D',1,NULL,'IN_STOCK','GRN','XYZ897376924','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6863,'XYZ-1768195213646-7E6F4F17',1,NULL,'IN_STOCK','GRN','XYZ971090005','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6864,'XYZ-1768195213667-2138BB25',1,NULL,'IN_STOCK','GRN','XYZ582737986','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6865,'XYZ-1768195213688-D478019B',1,NULL,'IN_STOCK','GRN','XYZ476941238','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6866,'XYZ-1768195213715-D514FD1E',1,NULL,'IN_STOCK','GRN','XYZ777608174','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6867,'XYZ-1768195213737-5A9DA4ED',1,NULL,'IN_STOCK','GRN','XYZ176266618','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6868,'XYZ-1768195213759-07411184',1,NULL,'IN_STOCK','GRN','XYZ172378513','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6869,'XYZ-1768195213781-FF81D429',1,NULL,'IN_STOCK','GRN','XYZ955118651','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6870,'XYZ-1768195213803-1A99833B',1,NULL,'IN_STOCK','GRN','XYZ819902662','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6871,'XYZ-1768195213824-98A515C9',1,NULL,'IN_STOCK','GRN','XYZ964697697','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6872,'XYZ-1768195213846-50D51194',1,NULL,'IN_STOCK','GRN','XYZ665740675','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6873,'XYZ-1768195213868-68A370EF',1,NULL,'IN_STOCK','GRN','XYZ196749500','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6874,'XYZ-1768195213889-F37D1D28',1,NULL,'IN_STOCK','GRN','XYZ466146461','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6875,'XYZ-1768195213911-210EAB1B',1,NULL,'IN_STOCK','GRN','XYZ093334951','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6876,'XYZ-1768195213932-FB124077',1,NULL,'IN_STOCK','GRN','XYZ405058506','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6877,'XYZ-1768195213953-063E8699',1,NULL,'IN_STOCK','GRN','XYZ500363461','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6878,'XYZ-1768195213975-DBF62387',1,NULL,'IN_STOCK','GRN','XYZ421439355','2026-01-12 05:20:13','2026-01-12 05:20:13'),(6879,'XYZ-1768195213997-B168FB27',1,NULL,'IN_STOCK','GRN','XYZ481182761','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6880,'XYZ-1768195214018-57E6E6E8',1,NULL,'IN_STOCK','GRN','XYZ226449866','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6881,'XYZ-1768195214040-8A35C124',1,NULL,'IN_STOCK','GRN','XYZ417042750','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6882,'XYZ-1768195214062-5DC0E96A',1,NULL,'IN_STOCK','GRN','XYZ117727673','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6883,'XYZ-1768195214083-8A7F0020',1,NULL,'IN_STOCK','GRN','XYZ366964955','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6884,'XYZ-1768195214105-47A2F81B',1,NULL,'IN_STOCK','GRN','XYZ291746739','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6885,'XYZ-1768195214126-2BA67D15',1,NULL,'IN_STOCK','GRN','XYZ045298112','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6886,'XYZ-1768195214148-94C4AAC3',1,NULL,'IN_STOCK','GRN','XYZ686347953','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6887,'XYZ-1768195214170-73D0D701',1,NULL,'IN_STOCK','GRN','XYZ765884563','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6888,'XYZ-1768195214194-0EA818D8',1,NULL,'IN_STOCK','GRN','XYZ844986760','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6889,'XYZ-1768195214216-DCF5D9EE',1,NULL,'IN_STOCK','GRN','XYZ383473335','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6890,'XYZ-1768195214238-8DC97B8D',1,NULL,'IN_STOCK','GRN','XYZ717461711','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6891,'XYZ-1768195214262-2382A67B',1,NULL,'IN_STOCK','GRN','XYZ366955105','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6892,'XYZ-1768195214284-25773EB4',1,NULL,'IN_STOCK','GRN','XYZ288185672','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6893,'XYZ-1768195214306-9772121E',1,NULL,'IN_STOCK','GRN','XYZ283177895','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6894,'XYZ-1768195214328-13EA6563',1,NULL,'IN_STOCK','GRN','XYZ261529635','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6895,'XYZ-1768195214350-BE92870D',1,NULL,'IN_STOCK','GRN','XYZ675328067','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6896,'XYZ-1768195214371-BB1CEB4A',1,NULL,'IN_STOCK','GRN','XYZ591666993','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6897,'XYZ-1768195214393-E16AD0D9',1,NULL,'IN_STOCK','GRN','XYZ270184933','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6898,'XYZ-1768195214414-DFDDB4B5',1,NULL,'IN_STOCK','GRN','XYZ663317857','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6899,'XYZ-1768195214436-23080688',1,NULL,'IN_STOCK','GRN','XYZ783980028','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6900,'XYZ-1768195214460-60B3B716',1,NULL,'IN_STOCK','GRN','XYZ345973041','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6901,'XYZ-1768195214482-29EF20BE',1,NULL,'IN_STOCK','GRN','XYZ247921667','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6902,'XYZ-1768195214504-4AEA431E',1,NULL,'IN_STOCK','GRN','XYZ104114829','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6903,'XYZ-1768195214526-05E3272F',1,NULL,'IN_STOCK','GRN','XYZ196185242','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6904,'XYZ-1768195214549-5B286EAC',1,NULL,'IN_STOCK','GRN','XYZ233745703','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6905,'XYZ-1768195214574-8331C576',1,NULL,'IN_STOCK','GRN','XYZ690103497','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6906,'XYZ-1768195214595-7768FCF8',1,NULL,'IN_STOCK','GRN','XYZ256781672','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6907,'XYZ-1768195214617-3EDA08B4',1,NULL,'IN_STOCK','GRN','XYZ230957363','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6908,'XYZ-1768195214639-3D226F6A',1,NULL,'IN_STOCK','GRN','XYZ994383038','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6909,'XYZ-1768195214662-A8740B82',1,NULL,'IN_STOCK','GRN','XYZ605417057','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6910,'XYZ-1768195214686-80345885',1,NULL,'IN_STOCK','GRN','XYZ037388256','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6911,'XYZ-1768195214708-1DC31398',1,NULL,'IN_STOCK','GRN','XYZ764503278','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6912,'XYZ-1768195214730-20051C7B',1,NULL,'IN_STOCK','GRN','XYZ732572727','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6913,'XYZ-1768195214752-4BFFA46A',1,NULL,'IN_STOCK','GRN','XYZ444630627','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6914,'XYZ-1768195214773-DF428533',1,NULL,'IN_STOCK','GRN','XYZ960594326','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6915,'XYZ-1768195214795-C7F14040',1,NULL,'IN_STOCK','GRN','XYZ981793701','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6916,'XYZ-1768195214817-B7D02F26',1,NULL,'IN_STOCK','GRN','XYZ183729306','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6917,'XYZ-1768195214838-C6C499C7',1,NULL,'IN_STOCK','GRN','XYZ122235392','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6918,'XYZ-1768195214860-7B65CE8F',1,NULL,'IN_STOCK','GRN','XYZ963523122','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6919,'XYZ-1768195214882-D3238733',1,NULL,'IN_STOCK','GRN','XYZ959485544','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6920,'XYZ-1768195214904-34AAF300',1,NULL,'IN_STOCK','GRN','XYZ327928819','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6921,'XYZ-1768195214926-BDD85FAF',1,NULL,'IN_STOCK','GRN','XYZ579889440','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6922,'XYZ-1768195214949-09BC2DC8',1,NULL,'IN_STOCK','GRN','XYZ860456121','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6923,'XYZ-1768195214974-15E28E62',1,NULL,'IN_STOCK','GRN','XYZ444067624','2026-01-12 05:20:14','2026-01-12 05:20:14'),(6924,'XYZ-1768195215000-32F15FEB',1,NULL,'IN_STOCK','GRN','XYZ272831548','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6925,'XYZ-1768195215028-B2DC3CD1',1,NULL,'IN_STOCK','GRN','XYZ947529527','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6926,'XYZ-1768195215052-0739A155',1,NULL,'IN_STOCK','GRN','XYZ897447386','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6927,'XYZ-1768195215077-F2A3FD22',1,NULL,'IN_STOCK','GRN','XYZ876471157','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6928,'XYZ-1768195215101-7F8C00DC',1,NULL,'IN_STOCK','GRN','XYZ794489718','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6929,'XYZ-1768195215128-7141330C',1,NULL,'IN_STOCK','GRN','XYZ737041186','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6930,'XYZ-1768195215159-7462487A',1,NULL,'IN_STOCK','GRN','XYZ485032325','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6931,'XYZ-1768195215182-0DE7D540',1,NULL,'IN_STOCK','GRN','XYZ366461231','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6932,'XYZ-1768195215202-9453FEC8',1,NULL,'IN_STOCK','GRN','XYZ859784125','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6933,'XYZ-1768195215222-E590961C',1,NULL,'IN_STOCK','GRN','XYZ146323280','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6934,'XYZ-1768195215247-E4AE1E05',1,NULL,'IN_STOCK','GRN','XYZ847596780','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6935,'XYZ-1768195215274-35B70350',1,NULL,'IN_STOCK','GRN','XYZ198301888','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6936,'XYZ-1768195215302-6A2B746F',1,NULL,'IN_STOCK','GRN','XYZ844286703','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6937,'XYZ-1768195215327-77E375F7',1,NULL,'IN_STOCK','GRN','XYZ543368146','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6938,'XYZ-1768195215356-92AFBAEA',1,NULL,'IN_STOCK','GRN','XYZ292920839','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6939,'XYZ-1768195215380-BB280102',1,NULL,'IN_STOCK','GRN','XYZ568987287','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6940,'XYZ-1768195215401-CD1F3256',1,NULL,'IN_STOCK','GRN','XYZ268302395','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6941,'XYZ-1768195215421-CC5FB4F4',1,NULL,'IN_STOCK','GRN','XYZ759319316','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6942,'XYZ-1768195215445-C62197A0',1,NULL,'IN_STOCK','GRN','XYZ799566661','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6943,'XYZ-1768195215471-8D33F8D3',1,NULL,'IN_STOCK','GRN','XYZ399982262','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6944,'XYZ-1768195215496-81E14E5D',1,NULL,'IN_STOCK','GRN','XYZ861780817','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6945,'XYZ-1768195215523-7A10C981',1,NULL,'IN_STOCK','GRN','XYZ052350725','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6946,'XYZ-1768195215550-99CAD2E9',1,NULL,'IN_STOCK','GRN','XYZ591631445','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6947,'XYZ-1768195215577-595081CE',1,NULL,'IN_STOCK','GRN','XYZ271191224','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6948,'XYZ-1768195215603-51EB471A',1,NULL,'IN_STOCK','GRN','XYZ816922904','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6949,'XYZ-1768195215629-716E5624',1,NULL,'IN_STOCK','GRN','XYZ376143330','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6950,'XYZ-1768195215656-6B24747C',1,NULL,'IN_STOCK','GRN','XYZ500126027','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6951,'XYZ-1768195215683-DF295A09',1,NULL,'IN_STOCK','GRN','XYZ775828141','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6952,'XYZ-1768195215707-52AAAABC',1,NULL,'IN_STOCK','GRN','XYZ800648992','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6953,'XYZ-1768195215734-D8B7A6A7',1,NULL,'IN_STOCK','GRN','XYZ253115331','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6954,'XYZ-1768195215758-5A06245A',1,NULL,'IN_STOCK','GRN','XYZ136040769','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6955,'XYZ-1768195215784-6ABA818A',1,NULL,'IN_STOCK','GRN','XYZ876376451','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6956,'XYZ-1768195215811-3C47AD2F',1,NULL,'IN_STOCK','GRN','XYZ221090194','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6957,'XYZ-1768195215835-90EE5B30',1,NULL,'IN_STOCK','GRN','XYZ143454550','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6958,'XYZ-1768195215859-C94DB2A5',1,NULL,'IN_STOCK','GRN','XYZ661328426','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6959,'XYZ-1768195215883-6BBE7A37',1,NULL,'IN_STOCK','GRN','XYZ479488634','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6960,'XYZ-1768195215908-6E920A07',1,NULL,'IN_STOCK','GRN','XYZ670688089','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6961,'XYZ-1768195215936-09CEFC88',1,NULL,'IN_STOCK','GRN','XYZ259309002','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6962,'XYZ-1768195215963-B027B5C1',1,NULL,'IN_STOCK','GRN','XYZ291871743','2026-01-12 05:20:15','2026-01-12 05:20:15'),(6963,'XYZ-1768195215990-90A9EFC6',1,NULL,'IN_STOCK','GRN','XYZ998799081','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6964,'XYZ-1768195216017-39564505',1,NULL,'IN_STOCK','GRN','XYZ637175212','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6965,'XYZ-1768195216044-A792D2F3',1,NULL,'IN_STOCK','GRN','XYZ284049639','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6966,'XYZ-1768195216071-24F4E21B',1,NULL,'IN_STOCK','GRN','XYZ082716941','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6967,'XYZ-1768195216097-EB9DA210',1,NULL,'IN_STOCK','GRN','XYZ297700770','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6968,'XYZ-1768195216124-B2E28E1A',1,NULL,'IN_STOCK','GRN','XYZ616819473','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6969,'XYZ-1768195216149-A498764F',1,NULL,'IN_STOCK','GRN','XYZ133616203','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6970,'XYZ-1768195216176-DBFD9623',1,NULL,'IN_STOCK','GRN','XYZ020544258','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6971,'XYZ-1768195216202-BB658032',1,NULL,'IN_STOCK','GRN','XYZ635178985','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6972,'XYZ-1768195216230-5CF38992',1,NULL,'IN_STOCK','GRN','XYZ246132921','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6973,'XYZ-1768195216258-9BBB7B27',1,NULL,'IN_STOCK','GRN','XYZ558984645','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6974,'XYZ-1768195216285-D78097A1',1,NULL,'IN_STOCK','GRN','XYZ749889977','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6975,'XYZ-1768195216313-80BB48AF',1,NULL,'IN_STOCK','GRN','XYZ923992617','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6976,'XYZ-1768195216339-5D81FAF7',1,NULL,'IN_STOCK','GRN','XYZ884096347','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6977,'XYZ-1768195216366-503C6A3D',1,NULL,'IN_STOCK','GRN','XYZ112015255','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6978,'XYZ-1768195216390-274B88E5',1,NULL,'IN_STOCK','GRN','XYZ687631047','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6979,'XYZ-1768195216416-E43C79CD',1,NULL,'IN_STOCK','GRN','XYZ868663960','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6980,'XYZ-1768195216443-0D4DAA6F',1,NULL,'IN_STOCK','GRN','XYZ767638047','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6981,'XYZ-1768195216472-098DCC41',1,NULL,'IN_STOCK','GRN','XYZ673445190','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6982,'XYZ-1768195216500-6306860A',1,NULL,'IN_STOCK','GRN','XYZ859915817','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6983,'XYZ-1768195216527-21777E2A',1,NULL,'IN_STOCK','GRN','XYZ062283456','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6984,'XYZ-1768195216552-B87721C9',1,NULL,'IN_STOCK','GRN','XYZ496290168','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6985,'XYZ-1768195216579-6A068A62',1,NULL,'IN_STOCK','GRN','XYZ450075747','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6986,'XYZ-1768195216606-F4AA25B4',1,NULL,'IN_STOCK','GRN','XYZ386137656','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6987,'XYZ-1768195216634-52CCDDAE',1,NULL,'IN_STOCK','GRN','XYZ780744771','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6988,'XYZ-1768195216659-C278D24B',1,NULL,'IN_STOCK','GRN','XYZ048519451','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6989,'XYZ-1768195216687-A117C97F',1,NULL,'IN_STOCK','GRN','XYZ411045507','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6990,'XYZ-1768195216714-0A7072A2',1,NULL,'IN_STOCK','GRN','XYZ562573189','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6991,'XYZ-1768195216741-11B2FFAB',1,NULL,'IN_STOCK','GRN','XYZ260602203','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6992,'XYZ-1768195216765-470EC10B',1,NULL,'IN_STOCK','GRN','XYZ610260403','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6993,'XYZ-1768195216792-8AA5BF6F',1,NULL,'IN_STOCK','GRN','XYZ554333487','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6994,'XYZ-1768195216816-CDFEF9EB',1,NULL,'IN_STOCK','GRN','XYZ161692049','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6995,'XYZ-1768195216843-6391CAD9',1,NULL,'IN_STOCK','GRN','XYZ643926143','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6996,'XYZ-1768195216867-54704725',1,NULL,'IN_STOCK','GRN','XYZ589257610','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6997,'XYZ-1768195216895-CBA3D7FD',1,NULL,'IN_STOCK','GRN','XYZ666171025','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6998,'XYZ-1768195216918-E4550955',1,NULL,'IN_STOCK','GRN','XYZ568946204','2026-01-12 05:20:16','2026-01-12 05:20:16'),(6999,'XYZ-1768195216943-458F3AAE',1,NULL,'IN_STOCK','GRN','XYZ666909524','2026-01-12 05:20:16','2026-01-12 05:20:16'),(7000,'XYZ-1768195216966-6CEFB91B',1,NULL,'IN_STOCK','GRN','XYZ341828873','2026-01-12 05:20:16','2026-01-12 05:20:16'),(7001,'XYZ-1768195216992-24108F55',1,NULL,'IN_STOCK','GRN','XYZ277795520','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7002,'XYZ-1768195217018-D5C330BB',1,NULL,'IN_STOCK','GRN','XYZ693928316','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7003,'XYZ-1768195217045-B27FE713',1,NULL,'IN_STOCK','GRN','XYZ354186734','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7004,'XYZ-1768195217073-0F231DF4',1,NULL,'IN_STOCK','GRN','XYZ748303095','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7005,'XYZ-1768195217101-D0C73268',1,NULL,'IN_STOCK','GRN','XYZ107964872','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7006,'XYZ-1768195217126-368A0111',1,NULL,'IN_STOCK','GRN','XYZ985526483','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7007,'XYZ-1768195217150-51FE6C9F',1,NULL,'IN_STOCK','GRN','XYZ742861908','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7008,'XYZ-1768195217178-BE1C7D55',1,NULL,'IN_STOCK','GRN','XYZ912982782','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7009,'XYZ-1768195217205-332DC5C3',1,NULL,'IN_STOCK','GRN','XYZ184741791','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7010,'XYZ-1768195217230-72953EC3',1,NULL,'IN_STOCK','GRN','XYZ661013655','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7011,'XYZ-1768195217256-80427D6F',1,NULL,'IN_STOCK','GRN','XYZ852711482','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7012,'XYZ-1768195217280-E71B780D',1,NULL,'IN_STOCK','GRN','XYZ568081365','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7013,'XYZ-1768195217306-325AC686',1,NULL,'IN_STOCK','GRN','XYZ930837946','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7014,'XYZ-1768195217331-43AC5379',1,NULL,'IN_STOCK','GRN','XYZ661940674','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7015,'XYZ-1768195217358-A411CFF8',1,NULL,'IN_STOCK','GRN','XYZ057374630','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7016,'XYZ-1768195217383-05DC1AE0',1,NULL,'IN_STOCK','GRN','XYZ053002198','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7017,'XYZ-1768195217410-CE179CB2',1,NULL,'IN_STOCK','GRN','XYZ352213543','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7018,'XYZ-1768195217436-7E40211E',1,NULL,'IN_STOCK','GRN','XYZ914567678','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7019,'XYZ-1768195217460-181D1C8C',1,NULL,'IN_STOCK','GRN','XYZ933820530','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7020,'XYZ-1768195217484-F02800F2',1,NULL,'IN_STOCK','GRN','XYZ338869491','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7021,'XYZ-1768195217511-A8A97D5E',1,NULL,'IN_STOCK','GRN','XYZ514527228','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7022,'XYZ-1768195217539-C176BE4C',1,NULL,'IN_STOCK','GRN','XYZ464717789','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7023,'XYZ-1768195217567-72145CD1',1,NULL,'IN_STOCK','GRN','XYZ224503491','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7024,'XYZ-1768195217595-D111EAED',1,NULL,'IN_STOCK','GRN','XYZ627585522','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7025,'XYZ-1768195217622-B8CFBEC9',1,NULL,'IN_STOCK','GRN','XYZ841491974','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7026,'XYZ-1768195217650-14394578',1,NULL,'IN_STOCK','GRN','XYZ412978782','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7027,'XYZ-1768195217677-6632A2EB',1,NULL,'IN_STOCK','GRN','XYZ621643559','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7028,'XYZ-1768195217706-0664F148',1,NULL,'IN_STOCK','GRN','XYZ712540656','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7029,'XYZ-1768195217732-F633FA1E',1,NULL,'IN_STOCK','GRN','XYZ146614795','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7030,'XYZ-1768195217757-28336EB5',1,NULL,'IN_STOCK','GRN','XYZ235988937','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7031,'XYZ-1768195217783-6CA54E04',1,NULL,'IN_STOCK','GRN','XYZ514690590','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7032,'XYZ-1768195217812-8C67BFF2',1,NULL,'IN_STOCK','GRN','XYZ856673287','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7033,'XYZ-1768195217840-4A857698',1,NULL,'IN_STOCK','GRN','XYZ835667437','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7034,'XYZ-1768195217867-EC8F3E55',1,NULL,'IN_STOCK','GRN','XYZ629240356','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7035,'XYZ-1768195217891-574C31A3',1,NULL,'IN_STOCK','GRN','XYZ571211326','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7036,'XYZ-1768195217916-BCE3CF9E',1,NULL,'IN_STOCK','GRN','XYZ969187115','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7037,'XYZ-1768195217940-82AE0172',1,NULL,'IN_STOCK','GRN','XYZ898841207','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7038,'XYZ-1768195217967-AEA89EF5',1,NULL,'IN_STOCK','GRN','XYZ404953059','2026-01-12 05:20:17','2026-01-12 05:20:17'),(7039,'XYZ-1768195217994-3711EA85',1,NULL,'IN_STOCK','GRN','XYZ770855101','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7040,'XYZ-1768195218022-C2B0BB3C',1,NULL,'IN_STOCK','GRN','XYZ765425608','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7041,'XYZ-1768195218047-E4ECA168',1,NULL,'IN_STOCK','GRN','XYZ449629957','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7042,'XYZ-1768195218073-07B4B93F',1,NULL,'IN_STOCK','GRN','XYZ581289904','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7043,'XYZ-1768195218099-8C639838',1,NULL,'IN_STOCK','GRN','XYZ556116987','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7044,'XYZ-1768195218126-12336338',1,NULL,'IN_STOCK','GRN','XYZ882014034','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7045,'XYZ-1768195218151-9CCD5B7B',1,NULL,'IN_STOCK','GRN','XYZ745564796','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7046,'XYZ-1768195218176-04F96E2F',1,NULL,'IN_STOCK','GRN','XYZ357769133','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7047,'XYZ-1768195218203-7C4A3DFE',1,NULL,'IN_STOCK','GRN','XYZ122860905','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7048,'XYZ-1768195218230-C81BC5E8',1,NULL,'IN_STOCK','GRN','XYZ946564521','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7049,'XYZ-1768195218256-4E794A4A',1,NULL,'IN_STOCK','GRN','XYZ560980842','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7050,'XYZ-1768195218283-B0F728B3',1,NULL,'IN_STOCK','GRN','XYZ340388318','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7051,'XYZ-1768195218309-12A581F4',1,NULL,'IN_STOCK','GRN','XYZ015401584','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7052,'XYZ-1768195218336-0F64E7A6',1,NULL,'IN_STOCK','GRN','XYZ355725057','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7053,'XYZ-1768195218364-FC52AE95',1,NULL,'IN_STOCK','GRN','XYZ883349147','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7054,'XYZ-1768195218392-26D0D407',1,NULL,'IN_STOCK','GRN','XYZ088603101','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7055,'XYZ-1768195218420-8D66FED0',1,NULL,'IN_STOCK','GRN','XYZ993838672','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7056,'XYZ-1768195218445-DCAE9F3E',1,NULL,'IN_STOCK','GRN','XYZ956301463','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7057,'XYZ-1768195218470-E49DB70B',1,NULL,'IN_STOCK','GRN','XYZ116874705','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7058,'XYZ-1768195218492-D6FB77D5',1,NULL,'IN_STOCK','GRN','XYZ033169493','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7059,'XYZ-1768195218515-1B285CEA',1,NULL,'IN_STOCK','GRN','XYZ561992478','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7060,'XYZ-1768195218536-2733FD72',1,NULL,'IN_STOCK','GRN','XYZ965859227','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7061,'XYZ-1768195218558-B79224AC',1,NULL,'IN_STOCK','GRN','XYZ309607531','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7062,'XYZ-1768195218583-D89ACDED',1,NULL,'IN_STOCK','GRN','XYZ350254879','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7063,'XYZ-1768195218608-C3B1E866',1,NULL,'IN_STOCK','GRN','XYZ208051459','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7064,'XYZ-1768195218636-BDD9AF1D',1,NULL,'IN_STOCK','GRN','XYZ116321854','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7065,'XYZ-1768195218663-6D75E05C',1,NULL,'IN_STOCK','GRN','XYZ789063797','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7066,'XYZ-1768195218691-8537E21F',1,NULL,'IN_STOCK','GRN','XYZ144397729','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7067,'XYZ-1768195218718-3FE97C0A',1,NULL,'IN_STOCK','GRN','XYZ615863019','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7068,'XYZ-1768195218744-FE8432B6',1,NULL,'IN_STOCK','GRN','XYZ074336965','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7069,'XYZ-1768195218770-3A1A2D04',1,NULL,'IN_STOCK','GRN','XYZ546737911','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7070,'XYZ-1768195218798-52719C3E',1,NULL,'IN_STOCK','GRN','XYZ817420397','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7071,'XYZ-1768195218825-F2929725',1,NULL,'IN_STOCK','GRN','XYZ575521682','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7072,'XYZ-1768195218849-EF767725',1,NULL,'IN_STOCK','GRN','XYZ406706710','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7073,'XYZ-1768195218877-4530672F',1,NULL,'IN_STOCK','GRN','XYZ093852387','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7074,'XYZ-1768195218905-2EE075D9',1,NULL,'IN_STOCK','GRN','XYZ146988670','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7075,'XYZ-1768195218933-FE4AFC3E',1,NULL,'IN_STOCK','GRN','XYZ501911251','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7076,'XYZ-1768195218960-9CE4319D',1,NULL,'IN_STOCK','GRN','XYZ095275490','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7077,'XYZ-1768195218988-F51720CB',1,NULL,'IN_STOCK','GRN','XYZ417084330','2026-01-12 05:20:18','2026-01-12 05:20:18'),(7078,'XYZ-1768195219012-264F3A86',1,NULL,'IN_STOCK','GRN','XYZ062548087','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7079,'XYZ-1768195219041-25A5028B',1,NULL,'IN_STOCK','GRN','XYZ519366621','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7080,'XYZ-1768195219067-57D53D42',1,NULL,'IN_STOCK','GRN','XYZ288123114','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7081,'XYZ-1768195219093-244EB62C',1,NULL,'IN_STOCK','GRN','XYZ109769084','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7082,'XYZ-1768195219120-1E331C61',1,NULL,'IN_STOCK','GRN','XYZ577671620','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7083,'XYZ-1768195219145-E3DE70B6',1,NULL,'IN_STOCK','GRN','XYZ008695191','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7084,'XYZ-1768195219170-5B5C571C',1,NULL,'IN_STOCK','GRN','XYZ650595094','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7085,'XYZ-1768195219201-82D0CB8E',1,NULL,'IN_STOCK','GRN','XYZ886596354','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7086,'XYZ-1768195219230-8F170F67',1,NULL,'IN_STOCK','GRN','XYZ666722783','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7087,'XYZ-1768195219259-730DACFD',1,NULL,'IN_STOCK','GRN','XYZ461512087','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7088,'XYZ-1768195219285-27062839',1,NULL,'IN_STOCK','GRN','XYZ044934134','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7089,'XYZ-1768195219312-02CB39C0',1,NULL,'IN_STOCK','GRN','XYZ694383716','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7090,'XYZ-1768195219340-FD6F663A',1,NULL,'IN_STOCK','GRN','XYZ793708019','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7091,'XYZ-1768195219368-ABEF8846',1,NULL,'IN_STOCK','GRN','XYZ021505057','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7092,'XYZ-1768195219396-7DA02635',1,NULL,'IN_STOCK','GRN','XYZ938209682','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7093,'XYZ-1768195219424-51BA421D',1,NULL,'IN_STOCK','GRN','XYZ117062676','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7094,'XYZ-1768195219453-CE57E110',1,NULL,'IN_STOCK','GRN','XYZ874060654','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7095,'XYZ-1768195219482-FACA5C30',1,NULL,'IN_STOCK','GRN','XYZ965298558','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7096,'XYZ-1768195219511-E6B0FD1F',1,NULL,'IN_STOCK','GRN','XYZ523767433','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7097,'XYZ-1768195219539-6D2A63ED',1,NULL,'IN_STOCK','GRN','XYZ977596586','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7098,'XYZ-1768195219568-B3FA6AE6',1,NULL,'IN_STOCK','GRN','XYZ081349540','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7099,'XYZ-1768195219595-67C3545A',1,NULL,'IN_STOCK','GRN','XYZ845652725','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7100,'XYZ-1768195219626-F74AC897',1,NULL,'IN_STOCK','GRN','XYZ068134530','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7101,'XYZ-1768195219654-C80B6329',1,NULL,'IN_STOCK','GRN','XYZ025089241','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7102,'XYZ-1768195219680-622DED11',1,NULL,'IN_STOCK','GRN','XYZ649890266','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7103,'XYZ-1768195219701-8D93B534',1,NULL,'IN_STOCK','GRN','XYZ121092289','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7104,'XYZ-1768195219721-3A19F4AE',1,NULL,'IN_STOCK','GRN','XYZ293710702','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7105,'XYZ-1768195219742-39356C4D',1,NULL,'IN_STOCK','GRN','XYZ409346966','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7106,'XYZ-1768195219762-34AE3C34',1,NULL,'IN_STOCK','GRN','XYZ878849835','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7107,'XYZ-1768195219782-525979D0',1,NULL,'IN_STOCK','GRN','XYZ640400906','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7108,'XYZ-1768195219802-CA572F08',1,NULL,'IN_STOCK','GRN','XYZ749482391','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7109,'XYZ-1768195219826-7C48AC6A',1,NULL,'IN_STOCK','GRN','XYZ128039030','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7110,'XYZ-1768195219854-85003840',1,NULL,'IN_STOCK','GRN','XYZ568460113','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7111,'XYZ-1768195219884-77D70406',1,NULL,'IN_STOCK','GRN','XYZ581097143','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7112,'XYZ-1768195219910-2CAE3894',1,NULL,'IN_STOCK','GRN','XYZ578421660','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7113,'XYZ-1768195219938-9765CA67',1,NULL,'IN_STOCK','GRN','XYZ635545686','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7114,'XYZ-1768195219964-07DF0124',1,NULL,'IN_STOCK','GRN','XYZ358022144','2026-01-12 05:20:19','2026-01-12 05:20:19'),(7115,'XYZ-1768195219990-D8E6BC83',1,NULL,'IN_STOCK','GRN','XYZ501954731','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7116,'XYZ-1768195220018-930D53AB',1,NULL,'IN_STOCK','GRN','XYZ943192024','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7117,'XYZ-1768195220047-2AB0C86C',1,NULL,'IN_STOCK','GRN','XYZ949277223','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7118,'XYZ-1768195220076-A0072AC0',1,NULL,'IN_STOCK','GRN','XYZ941290253','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7119,'XYZ-1768195220101-0C39B73D',1,NULL,'IN_STOCK','GRN','XYZ516726676','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7120,'XYZ-1768195220129-11547031',1,NULL,'IN_STOCK','GRN','XYZ659835202','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7121,'XYZ-1768195220158-45493A9F',1,NULL,'IN_STOCK','GRN','XYZ014547727','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7122,'XYZ-1768195220188-D7E4FB41',1,NULL,'IN_STOCK','GRN','XYZ766560964','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7123,'XYZ-1768195220219-E7BB8D7A',1,NULL,'IN_STOCK','GRN','XYZ421524247','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7124,'XYZ-1768195220245-2C7B625F',1,NULL,'IN_STOCK','GRN','XYZ139079993','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7125,'XYZ-1768195220274-F8830092',1,NULL,'IN_STOCK','GRN','XYZ056133183','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7126,'XYZ-1768195220301-4A330437',1,NULL,'IN_STOCK','GRN','XYZ114792250','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7127,'XYZ-1768195220331-D1DB5FFB',1,NULL,'IN_STOCK','GRN','XYZ661880222','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7128,'XYZ-1768195220361-929AEEF6',1,NULL,'IN_STOCK','GRN','XYZ848025253','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7129,'XYZ-1768195220393-3E0F3628',1,NULL,'IN_STOCK','GRN','XYZ164505047','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7130,'XYZ-1768195220421-96C88305',1,NULL,'IN_STOCK','GRN','XYZ668486278','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7131,'XYZ-1768195220453-DEF1E254',1,NULL,'IN_STOCK','GRN','XYZ323004463','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7132,'XYZ-1768195220484-3E0D01D0',1,NULL,'IN_STOCK','GRN','XYZ902316942','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7133,'XYZ-1768195220511-2EEFEFF7',1,NULL,'IN_STOCK','GRN','XYZ041628568','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7134,'XYZ-1768195220540-D9CD4D36',1,NULL,'IN_STOCK','GRN','XYZ220571259','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7135,'XYZ-1768195220568-0734C2B3',1,NULL,'IN_STOCK','GRN','XYZ791297193','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7136,'XYZ-1768195220596-88494778',1,NULL,'IN_STOCK','GRN','XYZ094604243','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7137,'XYZ-1768195220621-1ECC0D44',1,NULL,'IN_STOCK','GRN','XYZ670844253','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7138,'XYZ-1768195220647-7882E437',1,NULL,'IN_STOCK','GRN','XYZ302750944','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7139,'XYZ-1768195220672-484E0349',1,NULL,'IN_STOCK','GRN','XYZ602506695','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7140,'XYZ-1768195220698-D08A7EAA',1,NULL,'IN_STOCK','GRN','XYZ857405430','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7141,'XYZ-1768195220724-F5D2BBF3',1,NULL,'IN_STOCK','GRN','XYZ427282949','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7142,'XYZ-1768195220750-F8FAE45F',1,NULL,'IN_STOCK','GRN','XYZ257884139','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7143,'XYZ-1768195220775-79168A53',1,NULL,'IN_STOCK','GRN','XYZ014254829','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7144,'XYZ-1768195220803-62F55ABE',1,NULL,'IN_STOCK','GRN','XYZ805041260','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7145,'XYZ-1768195220829-7486568B',1,NULL,'IN_STOCK','GRN','XYZ289714876','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7146,'XYZ-1768195220856-C76911EC',1,NULL,'IN_STOCK','GRN','XYZ453476302','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7147,'XYZ-1768195220883-3330AF25',1,NULL,'IN_STOCK','GRN','XYZ657830546','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7148,'XYZ-1768195220911-DAD5C659',1,NULL,'IN_STOCK','GRN','XYZ684160047','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7149,'XYZ-1768195220937-FEC60A29',1,NULL,'IN_STOCK','GRN','XYZ527577698','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7150,'XYZ-1768195220968-E607C14A',1,NULL,'IN_STOCK','GRN','XYZ387853642','2026-01-12 05:20:20','2026-01-12 05:20:20'),(7151,'XYZ-1768195220999-ABEB22E2',1,NULL,'IN_STOCK','GRN','XYZ830946525','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7152,'XYZ-1768195221026-3E41E0BB',1,NULL,'IN_STOCK','GRN','XYZ791626869','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7153,'XYZ-1768195221057-E310A50B',1,NULL,'IN_STOCK','GRN','XYZ969105350','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7154,'XYZ-1768195221086-5201177B',1,NULL,'IN_STOCK','GRN','XYZ812845216','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7155,'XYZ-1768195221110-C82FBF64',1,NULL,'IN_STOCK','GRN','XYZ099426173','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7156,'XYZ-1768195221134-6440592B',1,NULL,'IN_STOCK','GRN','XYZ176784740','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7157,'XYZ-1768195221160-91F38514',1,NULL,'IN_STOCK','GRN','XYZ543770521','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7158,'XYZ-1768195221181-45EE697B',1,NULL,'IN_STOCK','GRN','XYZ034947118','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7159,'XYZ-1768195221204-DD2C0F12',1,NULL,'IN_STOCK','GRN','XYZ508484126','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7160,'XYZ-1768195221232-CE02EC05',1,NULL,'IN_STOCK','GRN','XYZ444059131','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7161,'XYZ-1768195221260-3D007B01',1,NULL,'IN_STOCK','GRN','XYZ478508179','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7162,'XYZ-1768195221287-F73727E8',1,NULL,'IN_STOCK','GRN','XYZ531411947','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7163,'XYZ-1768195221316-8721BF44',1,NULL,'IN_STOCK','GRN','XYZ673272295','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7164,'XYZ-1768195221346-EAE4666C',1,NULL,'IN_STOCK','GRN','XYZ062403937','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7165,'XYZ-1768195221373-89E22FFE',1,NULL,'IN_STOCK','GRN','XYZ425183512','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7166,'XYZ-1768195221401-2557F8DC',1,NULL,'IN_STOCK','GRN','XYZ597653506','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7167,'XYZ-1768195221427-AB313FB9',1,NULL,'IN_STOCK','GRN','XYZ832381621','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7168,'XYZ-1768195221457-8D1D5A5D',1,NULL,'IN_STOCK','GRN','XYZ770359699','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7169,'XYZ-1768195221486-D7C367C2',1,NULL,'IN_STOCK','GRN','XYZ486524870','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7170,'XYZ-1768195221514-B6AF0B82',1,NULL,'IN_STOCK','GRN','XYZ757747110','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7171,'XYZ-1768195221541-AB472032',1,NULL,'IN_STOCK','GRN','XYZ937176146','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7172,'XYZ-1768195221572-204BE723',1,NULL,'IN_STOCK','GRN','XYZ842451688','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7173,'XYZ-1768195221601-3D85C3C6',1,NULL,'IN_STOCK','GRN','XYZ219085335','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7174,'XYZ-1768195221630-AEB9AA53',1,NULL,'IN_STOCK','GRN','XYZ971520673','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7175,'XYZ-1768195221661-4B7C5D07',1,NULL,'IN_STOCK','GRN','XYZ090707164','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7176,'XYZ-1768195221691-976189DA',1,NULL,'IN_STOCK','GRN','XYZ185567826','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7177,'XYZ-1768195221719-05F157C9',1,NULL,'IN_STOCK','GRN','XYZ930157761','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7178,'XYZ-1768195221750-BD257225',1,NULL,'IN_STOCK','GRN','XYZ596102517','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7179,'XYZ-1768195221778-552B89CD',1,NULL,'IN_STOCK','GRN','XYZ246144805','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7180,'XYZ-1768195221809-1990C7F0',1,NULL,'IN_STOCK','GRN','XYZ831556850','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7181,'XYZ-1768195221840-712DA745',1,NULL,'IN_STOCK','GRN','XYZ435583414','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7182,'XYZ-1768195221869-CF26F8FD',1,NULL,'IN_STOCK','GRN','XYZ500471262','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7183,'XYZ-1768195221899-54AD456F',1,NULL,'IN_STOCK','GRN','XYZ803117410','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7184,'XYZ-1768195221928-FC5E7598',1,NULL,'IN_STOCK','GRN','XYZ705800410','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7185,'XYZ-1768195221958-2E756DED',1,NULL,'IN_STOCK','GRN','XYZ363643186','2026-01-12 05:20:21','2026-01-12 05:20:21'),(7186,'XYZ-1768195221987-0834B3D4',1,NULL,'IN_STOCK','GRN','XYZ792418615','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7187,'XYZ-1768195222016-12A498A8',1,NULL,'IN_STOCK','GRN','XYZ153212152','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7188,'XYZ-1768195222043-FC96361F',1,NULL,'IN_STOCK','GRN','XYZ721428195','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7189,'XYZ-1768195222070-3DC36B50',1,NULL,'IN_STOCK','GRN','XYZ984605358','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7190,'XYZ-1768195222095-061B7FB0',1,NULL,'IN_STOCK','GRN','XYZ348133935','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7191,'XYZ-1768195222121-1EDBADCF',1,NULL,'IN_STOCK','GRN','XYZ370426176','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7192,'XYZ-1768195222148-6DD7BCC8',1,NULL,'IN_STOCK','GRN','XYZ932536233','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7193,'XYZ-1768195222177-BF0C5DEB',1,NULL,'IN_STOCK','GRN','XYZ689757466','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7194,'XYZ-1768195222206-DC528AAE',1,NULL,'IN_STOCK','GRN','XYZ596642467','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7195,'XYZ-1768195222233-8B247BCE',1,NULL,'IN_STOCK','GRN','XYZ064055469','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7196,'XYZ-1768195222261-5AD92389',1,NULL,'IN_STOCK','GRN','XYZ655194900','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7197,'XYZ-1768195222289-50E58A97',1,NULL,'IN_STOCK','GRN','XYZ897329845','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7198,'XYZ-1768195222315-FD220394',1,NULL,'IN_STOCK','GRN','XYZ872878505','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7199,'XYZ-1768195222340-33A09CE7',1,NULL,'IN_STOCK','GRN','XYZ950871680','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7200,'XYZ-1768195222369-BA5A7C25',1,NULL,'IN_STOCK','GRN','XYZ680872620','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7201,'XYZ-1768195222395-83FF8536',1,NULL,'IN_STOCK','GRN','XYZ038606683','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7202,'XYZ-1768195222419-652F2521',1,NULL,'IN_STOCK','GRN','XYZ039091906','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7203,'XYZ-1768195222446-EE71B3E1',1,NULL,'IN_STOCK','GRN','XYZ196303509','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7204,'XYZ-1768195222471-3D46F666',1,NULL,'IN_STOCK','GRN','XYZ709164804','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7205,'XYZ-1768195222498-E2E2DC87',1,NULL,'IN_STOCK','GRN','XYZ846906348','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7206,'XYZ-1768195222525-92B0B3D7',1,NULL,'IN_STOCK','GRN','XYZ471336374','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7207,'XYZ-1768195222553-24FAD523',1,NULL,'IN_STOCK','GRN','XYZ481232864','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7208,'XYZ-1768195222579-94F35655',1,NULL,'IN_STOCK','GRN','XYZ855619769','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7209,'XYZ-1768195222606-A5811DF3',1,NULL,'IN_STOCK','GRN','XYZ024703937','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7210,'XYZ-1768195222632-9DCB9435',1,NULL,'IN_STOCK','GRN','XYZ460644800','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7211,'XYZ-1768195222657-546F4BD8',1,NULL,'IN_STOCK','GRN','XYZ252308273','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7212,'XYZ-1768195222685-6E8B4877',1,NULL,'IN_STOCK','GRN','XYZ598563632','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7213,'XYZ-1768195222710-615F5F57',1,NULL,'IN_STOCK','GRN','XYZ128664728','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7214,'XYZ-1768195222734-E8E051FA',1,NULL,'IN_STOCK','GRN','XYZ844704661','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7215,'XYZ-1768195222760-B18CAF9A',1,NULL,'IN_STOCK','GRN','XYZ010723608','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7216,'XYZ-1768195222787-D08114F0',1,NULL,'IN_STOCK','GRN','XYZ307441184','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7217,'XYZ-1768195222816-F609C626',1,NULL,'IN_STOCK','GRN','XYZ596676687','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7218,'XYZ-1768195222843-830DC748',1,NULL,'IN_STOCK','GRN','XYZ696191238','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7219,'XYZ-1768195222872-1865579B',1,NULL,'IN_STOCK','GRN','XYZ307280348','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7220,'XYZ-1768195222898-28EC122D',1,NULL,'IN_STOCK','GRN','XYZ724659594','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7221,'XYZ-1768195222925-42B96266',1,NULL,'IN_STOCK','GRN','XYZ525072508','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7222,'XYZ-1768195222951-400C88CF',1,NULL,'IN_STOCK','GRN','XYZ791691655','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7223,'XYZ-1768195222975-243FA599',1,NULL,'IN_STOCK','GRN','XYZ719106192','2026-01-12 05:20:22','2026-01-12 05:20:22'),(7224,'XYZ-1768195223003-F4B41D20',1,NULL,'IN_STOCK','GRN','XYZ814204291','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7225,'XYZ-1768195223031-8F9DCFE3',1,NULL,'IN_STOCK','GRN','XYZ889461820','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7226,'XYZ-1768195223060-2E5B58E0',1,NULL,'IN_STOCK','GRN','XYZ996291255','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7227,'XYZ-1768195223088-9A4DA403',1,NULL,'IN_STOCK','GRN','XYZ407941157','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7228,'XYZ-1768195223114-BE38388E',1,NULL,'IN_STOCK','GRN','XYZ863032376','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7229,'XYZ-1768195223142-E25581D3',1,NULL,'IN_STOCK','GRN','XYZ746345167','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7230,'XYZ-1768195223170-5BFCFE63',1,NULL,'IN_STOCK','GRN','XYZ264041558','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7231,'XYZ-1768195223198-71A52D0A',1,NULL,'IN_STOCK','GRN','XYZ738143712','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7232,'XYZ-1768195223225-5072168C',1,NULL,'IN_STOCK','GRN','XYZ346575934','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7233,'XYZ-1768195223254-FC2F682D',1,NULL,'IN_STOCK','GRN','XYZ694014350','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7234,'XYZ-1768195223282-77F123BA',1,NULL,'IN_STOCK','GRN','XYZ099086634','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7235,'XYZ-1768195223307-699BCE05',1,NULL,'IN_STOCK','GRN','XYZ780383638','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7236,'XYZ-1768195223329-B1B6E4D3',1,NULL,'IN_STOCK','GRN','XYZ599692735','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7237,'XYZ-1768195223350-CC9EBC95',1,NULL,'IN_STOCK','GRN','XYZ932162963','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7238,'XYZ-1768195223370-4E3921A4',1,NULL,'IN_STOCK','GRN','XYZ383020768','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7239,'XYZ-1768195223396-1557C65A',1,NULL,'IN_STOCK','GRN','XYZ869924821','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7240,'XYZ-1768195223424-B74DEB61',1,NULL,'IN_STOCK','GRN','XYZ698381788','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7241,'XYZ-1768195223451-10CE863C',1,NULL,'IN_STOCK','GRN','XYZ873180353','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7242,'XYZ-1768195223473-60AB7B61',1,NULL,'IN_STOCK','GRN','XYZ440100803','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7243,'XYZ-1768195223495-1D468519',1,NULL,'IN_STOCK','GRN','XYZ758418491','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7244,'XYZ-1768195223519-22D697C0',1,NULL,'IN_STOCK','GRN','XYZ038627592','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7245,'XYZ-1768195223541-0A454149',1,NULL,'IN_STOCK','GRN','XYZ941240219','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7246,'XYZ-1768195223564-1D974162',1,NULL,'IN_STOCK','GRN','XYZ351555064','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7247,'XYZ-1768195223587-7F8A894B',1,NULL,'IN_STOCK','GRN','XYZ735553512','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7248,'XYZ-1768195223610-C77EBF4C',1,NULL,'IN_STOCK','GRN','XYZ939836869','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7249,'XYZ-1768195223632-1C7523D9',1,NULL,'IN_STOCK','GRN','XYZ772088234','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7250,'XYZ-1768195223654-8E15759B',1,NULL,'IN_STOCK','GRN','XYZ403316297','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7251,'XYZ-1768195223678-69877E05',1,NULL,'IN_STOCK','GRN','XYZ252617702','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7252,'XYZ-1768195223701-DC6FF9B2',1,NULL,'IN_STOCK','GRN','XYZ905485004','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7253,'XYZ-1768195223723-F8222BB6',1,NULL,'IN_STOCK','GRN','XYZ321785444','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7254,'XYZ-1768195223746-3E4D871D',1,NULL,'IN_STOCK','GRN','XYZ019252859','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7255,'XYZ-1768195223770-EC3E69FD',1,NULL,'IN_STOCK','GRN','XYZ687502133','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7256,'XYZ-1768195223792-C0F13691',1,NULL,'IN_STOCK','GRN','XYZ743840103','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7257,'XYZ-1768195223814-39AB4731',1,NULL,'IN_STOCK','GRN','XYZ781862947','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7258,'XYZ-1768195223836-0F61CA67',1,NULL,'IN_STOCK','GRN','XYZ410679712','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7259,'XYZ-1768195223860-29053D42',1,NULL,'IN_STOCK','GRN','XYZ545282741','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7260,'XYZ-1768195223882-EFA2CF25',1,NULL,'IN_STOCK','GRN','XYZ571810417','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7261,'XYZ-1768195223904-B76A4759',1,NULL,'IN_STOCK','GRN','XYZ618053380','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7262,'XYZ-1768195223926-61E61981',1,NULL,'IN_STOCK','GRN','XYZ855731110','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7263,'XYZ-1768195223950-59591275',1,NULL,'IN_STOCK','GRN','XYZ664918414','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7264,'XYZ-1768195223972-C299E9D6',1,NULL,'IN_STOCK','GRN','XYZ463248614','2026-01-12 05:20:23','2026-01-12 05:20:23'),(7265,'XYZ-1768195223996-5D7017C8',1,NULL,'IN_STOCK','GRN','XYZ563142096','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7266,'XYZ-1768195224019-6A899AE1',1,NULL,'IN_STOCK','GRN','XYZ148839682','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7267,'XYZ-1768195224043-4C924211',1,NULL,'IN_STOCK','GRN','XYZ516114019','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7268,'XYZ-1768195224071-C337550C',1,NULL,'IN_STOCK','GRN','XYZ142008009','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7269,'XYZ-1768195224100-C8113645',1,NULL,'IN_STOCK','GRN','XYZ452560523','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7270,'XYZ-1768195224127-48C4CC53',1,NULL,'IN_STOCK','GRN','XYZ589903801','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7271,'XYZ-1768195224152-DA699416',1,NULL,'IN_STOCK','GRN','XYZ830755375','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7272,'XYZ-1768195224181-13A4F6B8',1,NULL,'IN_STOCK','GRN','XYZ480075386','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7273,'XYZ-1768195224207-1D60A266',1,NULL,'IN_STOCK','GRN','XYZ728174815','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7274,'XYZ-1768195224234-8095BBF7',1,NULL,'IN_STOCK','GRN','XYZ707801396','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7275,'XYZ-1768195224258-F15FBAAC',1,NULL,'IN_STOCK','GRN','XYZ749186001','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7276,'XYZ-1768195224281-17D34090',1,NULL,'IN_STOCK','GRN','XYZ335769697','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7277,'XYZ-1768195224305-6CCC9A13',1,NULL,'IN_STOCK','GRN','XYZ109698291','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7278,'XYZ-1768195224328-7E0DE35A',1,NULL,'IN_STOCK','GRN','XYZ406921294','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7279,'XYZ-1768195224352-D3806A09',1,NULL,'IN_STOCK','GRN','XYZ425727583','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7280,'XYZ-1768195224376-10CB26A2',1,NULL,'IN_STOCK','GRN','XYZ283421432','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7281,'XYZ-1768195224399-BFA7E6AE',1,NULL,'IN_STOCK','GRN','XYZ784768214','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7282,'XYZ-1768195224423-06E724ED',1,NULL,'IN_STOCK','GRN','XYZ230905739','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7283,'XYZ-1768195224452-A50D62D2',1,NULL,'IN_STOCK','GRN','XYZ576225444','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7284,'XYZ-1768195224476-E0C51ACB',1,NULL,'IN_STOCK','GRN','XYZ081638781','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7285,'XYZ-1768195224503-BAD67E9F',1,NULL,'IN_STOCK','GRN','XYZ581221947','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7286,'XYZ-1768195224526-2F007DD8',1,NULL,'IN_STOCK','GRN','XYZ556407339','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7287,'XYZ-1768195224549-2A86384B',1,NULL,'IN_STOCK','GRN','XYZ868141027','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7288,'XYZ-1768195224574-260CDE8E',1,NULL,'IN_STOCK','GRN','XYZ240878752','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7289,'XYZ-1768195224601-AACAFB8A',1,NULL,'IN_STOCK','GRN','XYZ228938919','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7290,'XYZ-1768195224625-8BD53B83',1,NULL,'IN_STOCK','GRN','XYZ406675271','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7291,'XYZ-1768195224648-0969AEDB',1,NULL,'IN_STOCK','GRN','XYZ919863549','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7292,'XYZ-1768195224675-EB9C9ACA',1,NULL,'IN_STOCK','GRN','XYZ380771861','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7293,'XYZ-1768195224698-3540EAFB',1,NULL,'IN_STOCK','GRN','XYZ638860602','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7294,'XYZ-1768195224722-924834C0',1,NULL,'IN_STOCK','GRN','XYZ829940925','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7295,'XYZ-1768195224745-26581151',1,NULL,'IN_STOCK','GRN','XYZ821302491','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7296,'XYZ-1768195224771-B7236C4D',1,NULL,'IN_STOCK','GRN','XYZ119752299','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7297,'XYZ-1768195224794-6278B82C',1,NULL,'IN_STOCK','GRN','XYZ361585684','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7298,'XYZ-1768195224817-32858E2E',1,NULL,'IN_STOCK','GRN','XYZ147591281','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7299,'XYZ-1768195224842-AADE1B58',1,NULL,'IN_STOCK','GRN','XYZ279853373','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7300,'XYZ-1768195224866-46234100',1,NULL,'IN_STOCK','GRN','XYZ422204620','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7301,'XYZ-1768195224889-9AA1B1B5',1,NULL,'IN_STOCK','GRN','XYZ355073623','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7302,'XYZ-1768195224912-ED5FC686',1,NULL,'IN_STOCK','GRN','XYZ070152777','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7303,'XYZ-1768195224935-938AFF35',1,NULL,'IN_STOCK','GRN','XYZ189200458','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7304,'XYZ-1768195224959-A916752C',1,NULL,'IN_STOCK','GRN','XYZ144982101','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7305,'XYZ-1768195224982-39C4466A',1,NULL,'IN_STOCK','GRN','XYZ846984362','2026-01-12 05:20:24','2026-01-12 05:20:24'),(7306,'XYZ-1768195225007-FD35DCCF',1,NULL,'IN_STOCK','GRN','XYZ596119808','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7307,'XYZ-1768195225032-74C2702C',1,NULL,'IN_STOCK','GRN','XYZ358675850','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7308,'XYZ-1768195225058-79F7A7F8',1,NULL,'IN_STOCK','GRN','XYZ046980596','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7309,'XYZ-1768195225083-0D983F34',1,NULL,'IN_STOCK','GRN','XYZ059432905','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7310,'XYZ-1768195225106-10DBFA6B',1,NULL,'IN_STOCK','GRN','XYZ194677138','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7311,'XYZ-1768195225129-1B0CF53F',1,NULL,'IN_STOCK','GRN','XYZ222526791','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7312,'XYZ-1768195225154-816A965A',1,NULL,'IN_STOCK','GRN','XYZ433504152','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7313,'XYZ-1768195225177-811BF36F',1,NULL,'IN_STOCK','GRN','XYZ655742281','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7314,'XYZ-1768195225199-03C3C160',1,NULL,'IN_STOCK','GRN','XYZ426464395','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7315,'XYZ-1768195225221-6D0F5CA4',1,NULL,'IN_STOCK','GRN','XYZ210296511','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7316,'XYZ-1768195225243-86EE2196',1,NULL,'IN_STOCK','GRN','XYZ393589405','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7317,'XYZ-1768195225265-A368B940',1,NULL,'IN_STOCK','GRN','XYZ378084682','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7318,'XYZ-1768195225287-A9C6EBCD',1,NULL,'IN_STOCK','GRN','XYZ611976694','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7319,'XYZ-1768195225309-B5FA7758',1,NULL,'IN_STOCK','GRN','XYZ854084032','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7320,'XYZ-1768195225335-EBC064C7',1,NULL,'IN_STOCK','GRN','XYZ787359423','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7321,'XYZ-1768195225357-D1242E9D',1,NULL,'IN_STOCK','GRN','XYZ226620574','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7322,'XYZ-1768195225382-B88326CC',1,NULL,'IN_STOCK','GRN','XYZ913668287','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7323,'XYZ-1768195225406-277D8772',1,NULL,'IN_STOCK','GRN','XYZ421496953','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7324,'XYZ-1768195225429-9ADD486E',1,NULL,'IN_STOCK','GRN','XYZ866812273','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7325,'XYZ-1768195225451-9D18B606',1,NULL,'IN_STOCK','GRN','XYZ284032344','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7326,'XYZ-1768195225473-D9EBF2C0',1,NULL,'IN_STOCK','GRN','XYZ883745606','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7327,'XYZ-1768195225498-D306E75C',1,NULL,'IN_STOCK','GRN','XYZ185628237','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7328,'XYZ-1768195225520-217B4C5E',1,NULL,'IN_STOCK','GRN','XYZ345006058','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7329,'XYZ-1768195225543-BFDDD0A4',1,NULL,'IN_STOCK','GRN','XYZ738505815','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7330,'XYZ-1768195225565-A712DC4E',1,NULL,'IN_STOCK','GRN','XYZ277103500','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7331,'XYZ-1768195225587-D5E185F7',1,NULL,'IN_STOCK','GRN','XYZ418088026','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7332,'XYZ-1768195225609-3C3E139C',1,NULL,'IN_STOCK','GRN','XYZ233922134','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7333,'XYZ-1768195225631-A04917E1',1,NULL,'IN_STOCK','GRN','XYZ685225724','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7334,'XYZ-1768195225653-C18561ED',1,NULL,'IN_STOCK','GRN','XYZ956284925','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7335,'XYZ-1768195225675-5F98B37D',1,NULL,'IN_STOCK','GRN','XYZ680377716','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7336,'XYZ-1768195225698-E007CC03',1,NULL,'IN_STOCK','GRN','XYZ866542163','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7337,'XYZ-1768195225720-6D6EE6F1',1,NULL,'IN_STOCK','GRN','XYZ360077641','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7338,'XYZ-1768195225742-6F5271C8',1,NULL,'IN_STOCK','GRN','XYZ970464286','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7339,'XYZ-1768195225764-D1A051CF',1,NULL,'IN_STOCK','GRN','XYZ867156562','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7340,'XYZ-1768195225787-A34F68EB',1,NULL,'IN_STOCK','GRN','XYZ437346373','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7341,'XYZ-1768195225809-6DD92D1C',1,NULL,'IN_STOCK','GRN','XYZ996880448','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7342,'XYZ-1768195225832-AAFBF71E',1,NULL,'IN_STOCK','GRN','XYZ904217049','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7343,'XYZ-1768195225854-0B04F437',1,NULL,'IN_STOCK','GRN','XYZ290403744','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7344,'XYZ-1768195225876-26896C00',1,NULL,'IN_STOCK','GRN','XYZ103111590','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7345,'XYZ-1768195225899-7737EDAA',1,NULL,'IN_STOCK','GRN','XYZ336615803','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7346,'XYZ-1768195225921-8F3A9CFF',1,NULL,'IN_STOCK','GRN','XYZ783367338','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7347,'XYZ-1768195225943-A22007EA',1,NULL,'IN_STOCK','GRN','XYZ745946064','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7348,'XYZ-1768195225965-066F649E',1,NULL,'IN_STOCK','GRN','XYZ347389719','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7349,'XYZ-1768195225988-2F96B34B',1,NULL,'IN_STOCK','GRN','XYZ053450694','2026-01-12 05:20:25','2026-01-12 05:20:25'),(7350,'XYZ-1768195226011-C66EF808',1,NULL,'IN_STOCK','GRN','XYZ591293186','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7351,'XYZ-1768195226033-5D94EEBE',1,NULL,'IN_STOCK','GRN','XYZ187056268','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7352,'XYZ-1768195226055-3BF7979C',1,NULL,'IN_STOCK','GRN','XYZ310962553','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7353,'XYZ-1768195226079-8165689E',1,NULL,'IN_STOCK','GRN','XYZ110877452','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7354,'XYZ-1768195226104-B195A851',1,NULL,'IN_STOCK','GRN','XYZ452998176','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7355,'XYZ-1768195226127-E800CB9D',1,NULL,'IN_STOCK','GRN','XYZ399328117','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7356,'XYZ-1768195226150-AD08D40D',1,NULL,'IN_STOCK','GRN','XYZ802718740','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7357,'XYZ-1768195226172-8C2866E2',1,NULL,'IN_STOCK','GRN','XYZ477315165','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7358,'XYZ-1768195226197-748EC9DA',1,NULL,'IN_STOCK','GRN','XYZ255688543','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7359,'XYZ-1768195226220-A6545725',1,NULL,'IN_STOCK','GRN','XYZ437522446','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7360,'XYZ-1768195226243-8DE72011',1,NULL,'IN_STOCK','GRN','XYZ270228559','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7361,'XYZ-1768195226265-03C7A448',1,NULL,'IN_STOCK','GRN','XYZ419818683','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7362,'XYZ-1768195226287-50AAD251',1,NULL,'IN_STOCK','GRN','XYZ493863381','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7363,'XYZ-1768195226309-D47E54D4',1,NULL,'IN_STOCK','GRN','XYZ989278543','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7364,'XYZ-1768195226331-A301B296',1,NULL,'IN_STOCK','GRN','XYZ131754354','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7365,'XYZ-1768195226352-63B59BA6',1,NULL,'IN_STOCK','GRN','XYZ742606089','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7366,'XYZ-1768195226375-EE2022A2',1,NULL,'IN_STOCK','GRN','XYZ397001382','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7367,'XYZ-1768195226401-2CB36E0E',1,NULL,'IN_STOCK','GRN','XYZ821116928','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7368,'XYZ-1768195226426-7F2D5CB4',1,NULL,'IN_STOCK','GRN','XYZ681910407','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7369,'XYZ-1768195226448-2C59098E',1,NULL,'IN_STOCK','GRN','XYZ819534144','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7370,'XYZ-1768195226471-0C68EB91',1,NULL,'IN_STOCK','GRN','XYZ019511638','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7371,'XYZ-1768195226495-4D7CE4C2',1,NULL,'IN_STOCK','GRN','XYZ078765243','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7372,'XYZ-1768195226517-F06E1126',1,NULL,'IN_STOCK','GRN','XYZ904483671','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7373,'XYZ-1768195226539-61F6E343',1,NULL,'IN_STOCK','GRN','XYZ221442555','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7374,'XYZ-1768195226561-547CC3A7',1,NULL,'IN_STOCK','GRN','XYZ078649615','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7375,'XYZ-1768195226583-320BC5B7',1,NULL,'IN_STOCK','GRN','XYZ655004446','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7376,'XYZ-1768195226605-175B8329',1,NULL,'IN_STOCK','GRN','XYZ581469315','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7377,'XYZ-1768195226628-AE876CF9',1,NULL,'IN_STOCK','GRN','XYZ262445978','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7378,'XYZ-1768195226652-F7D429E9',1,NULL,'IN_STOCK','GRN','XYZ922577051','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7379,'XYZ-1768195226674-8DD40172',1,NULL,'IN_STOCK','GRN','XYZ042241650','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7380,'XYZ-1768195226696-DDCFA991',1,NULL,'IN_STOCK','GRN','XYZ806300778','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7381,'XYZ-1768195226718-B89CC63E',1,NULL,'IN_STOCK','GRN','XYZ353284671','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7382,'XYZ-1768195226740-37EF1AE3',1,NULL,'IN_STOCK','GRN','XYZ023794480','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7383,'XYZ-1768195226763-CB77FDE6',1,NULL,'IN_STOCK','GRN','XYZ432333254','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7384,'XYZ-1768195226785-4BFC5DD7',1,NULL,'IN_STOCK','GRN','XYZ265955111','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7385,'XYZ-1768195226806-A437A9C1',1,NULL,'IN_STOCK','GRN','XYZ043519870','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7386,'XYZ-1768195226828-6D14DC61',1,NULL,'IN_STOCK','GRN','XYZ316427364','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7387,'XYZ-1768195226850-A578D95A',1,NULL,'IN_STOCK','GRN','XYZ704659930','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7388,'XYZ-1768195226873-B49B18E7',1,NULL,'IN_STOCK','GRN','XYZ299640019','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7389,'XYZ-1768195226896-F6385D85',1,NULL,'IN_STOCK','GRN','XYZ059893723','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7390,'XYZ-1768195226919-D1428573',1,NULL,'IN_STOCK','GRN','XYZ550618029','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7391,'XYZ-1768195226941-0AA81A37',1,NULL,'IN_STOCK','GRN','XYZ242297380','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7392,'XYZ-1768195226963-4F2D70A9',1,NULL,'IN_STOCK','GRN','XYZ149917790','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7393,'XYZ-1768195226985-1CFDF06C',1,NULL,'IN_STOCK','GRN','XYZ134894160','2026-01-12 05:20:26','2026-01-12 05:20:26'),(7394,'XYZ-1768195227007-9446335B',1,NULL,'IN_STOCK','GRN','XYZ117170107','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7395,'XYZ-1768195227029-9DE85B94',1,NULL,'IN_STOCK','GRN','XYZ989035339','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7396,'XYZ-1768195227052-3931549F',1,NULL,'IN_STOCK','GRN','XYZ846235539','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7397,'XYZ-1768195227074-C7B27882',1,NULL,'IN_STOCK','GRN','XYZ382707866','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7398,'XYZ-1768195227095-75F3AFA2',1,NULL,'IN_STOCK','GRN','XYZ430602173','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7399,'XYZ-1768195227117-E4451233',1,NULL,'IN_STOCK','GRN','XYZ832459432','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7400,'XYZ-1768195227139-458A9A33',1,NULL,'IN_STOCK','GRN','XYZ401950701','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7401,'XYZ-1768195227162-3DD5B006',1,NULL,'IN_STOCK','GRN','XYZ487656928','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7402,'XYZ-1768195227184-39636801',1,NULL,'IN_STOCK','GRN','XYZ642474143','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7403,'XYZ-1768195227206-3E2391BB',1,NULL,'IN_STOCK','GRN','XYZ921484017','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7404,'XYZ-1768195227229-0054DC12',1,NULL,'IN_STOCK','GRN','XYZ522016738','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7405,'XYZ-1768195227253-01BA9613',1,NULL,'IN_STOCK','GRN','XYZ829897490','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7406,'XYZ-1768195227277-F248A549',1,NULL,'IN_STOCK','GRN','XYZ963013217','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7407,'XYZ-1768195227299-20EE0312',1,NULL,'IN_STOCK','GRN','XYZ795848546','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7408,'XYZ-1768195227321-BB2E37AF',1,NULL,'IN_STOCK','GRN','XYZ823654763','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7409,'XYZ-1768195227343-5B2C67AF',1,NULL,'IN_STOCK','GRN','XYZ578881567','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7410,'XYZ-1768195227365-57A0BE5F',1,NULL,'IN_STOCK','GRN','XYZ504255745','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7411,'XYZ-1768195227392-F19A7D7E',1,NULL,'IN_STOCK','GRN','XYZ982549659','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7412,'XYZ-1768195227415-1AC45394',1,NULL,'IN_STOCK','GRN','XYZ525680182','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7413,'XYZ-1768195227437-2AFE6C55',1,NULL,'IN_STOCK','GRN','XYZ015434205','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7414,'XYZ-1768195227462-5DA96A56',1,NULL,'IN_STOCK','GRN','XYZ364286284','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7415,'XYZ-1768195227484-F60950EB',1,NULL,'IN_STOCK','GRN','XYZ797627040','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7416,'XYZ-1768195227506-15ECF73B',1,NULL,'IN_STOCK','GRN','XYZ347735379','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7417,'XYZ-1768195227528-EB6E8E6B',1,NULL,'IN_STOCK','GRN','XYZ076758447','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7418,'XYZ-1768195227550-36FEF241',1,NULL,'IN_STOCK','GRN','XYZ939222899','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7419,'XYZ-1768195227572-104A354E',1,NULL,'IN_STOCK','GRN','XYZ604592379','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7420,'XYZ-1768195227595-FCFB28EB',1,NULL,'IN_STOCK','GRN','XYZ667576521','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7421,'XYZ-1768195227618-E5C4A6B8',1,NULL,'IN_STOCK','GRN','XYZ205599190','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7422,'XYZ-1768195227641-1E32FB8C',1,NULL,'IN_STOCK','GRN','XYZ390368341','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7423,'XYZ-1768195227663-3ADC8F97',1,NULL,'IN_STOCK','GRN','XYZ154922299','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7424,'XYZ-1768195227685-A6451E7D',1,NULL,'IN_STOCK','GRN','XYZ983409136','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7425,'XYZ-1768195227708-23C92069',1,NULL,'IN_STOCK','GRN','XYZ828251723','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7426,'XYZ-1768195227735-C5EE7CB4',1,NULL,'IN_STOCK','GRN','XYZ636854356','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7427,'XYZ-1768195227759-D8A4F925',1,NULL,'IN_STOCK','GRN','XYZ244732175','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7428,'XYZ-1768195227781-0CF11487',1,NULL,'IN_STOCK','GRN','XYZ989650652','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7429,'XYZ-1768195227803-8E9A89CF',1,NULL,'IN_STOCK','GRN','XYZ473961678','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7430,'XYZ-1768195227825-15AB56AB',1,NULL,'IN_STOCK','GRN','XYZ646937028','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7431,'XYZ-1768195227848-D4C6C839',1,NULL,'IN_STOCK','GRN','XYZ154875753','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7432,'XYZ-1768195227871-A1FD325E',1,NULL,'IN_STOCK','GRN','XYZ617846263','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7433,'XYZ-1768195227894-080F4FF1',1,NULL,'IN_STOCK','GRN','XYZ128742170','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7434,'XYZ-1768195227916-9E07D614',1,NULL,'IN_STOCK','GRN','XYZ500556498','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7435,'XYZ-1768195227942-AF3D327A',1,NULL,'IN_STOCK','GRN','XYZ322274082','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7436,'XYZ-1768195227965-203E5073',1,NULL,'IN_STOCK','GRN','XYZ928197174','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7437,'XYZ-1768195227988-9CF538C1',1,NULL,'IN_STOCK','GRN','XYZ065232597','2026-01-12 05:20:27','2026-01-12 05:20:27'),(7438,'XYZ-1768195228010-86F59FA6',1,NULL,'IN_STOCK','GRN','XYZ916288982','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7439,'XYZ-1768195228031-D3FDFC5A',1,NULL,'IN_STOCK','GRN','XYZ482104242','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7440,'XYZ-1768195228056-23E8BC33',1,NULL,'IN_STOCK','GRN','XYZ167650429','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7441,'XYZ-1768195228079-7D5E5204',1,NULL,'IN_STOCK','GRN','XYZ040968699','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7442,'XYZ-1768195228101-73E622D4',1,NULL,'IN_STOCK','GRN','XYZ383320243','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7443,'XYZ-1768195228123-95E22964',1,NULL,'IN_STOCK','GRN','XYZ101801329','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7444,'XYZ-1768195228145-D20C7FF5',1,NULL,'IN_STOCK','GRN','XYZ860303239','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7445,'XYZ-1768195228166-C5448A06',1,NULL,'IN_STOCK','GRN','XYZ497735705','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7446,'XYZ-1768195228188-5BC732D5',1,NULL,'IN_STOCK','GRN','XYZ434628343','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7447,'XYZ-1768195228211-BC5F1265',1,NULL,'IN_STOCK','GRN','XYZ893810743','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7448,'XYZ-1768195228233-22C78B89',1,NULL,'IN_STOCK','GRN','XYZ570235979','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7449,'XYZ-1768195228256-35EB0780',1,NULL,'IN_STOCK','GRN','XYZ840907053','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7450,'XYZ-1768195228278-2F8B2F18',1,NULL,'IN_STOCK','GRN','XYZ241792617','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7451,'XYZ-1768195228300-8E6D6BF7',1,NULL,'IN_STOCK','GRN','XYZ559932517','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7452,'XYZ-1768195228323-C42CD84A',1,NULL,'IN_STOCK','GRN','XYZ463360520','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7453,'XYZ-1768195228344-83A7C767',1,NULL,'IN_STOCK','GRN','XYZ726565631','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7454,'XYZ-1768195228367-89D653A1',1,NULL,'IN_STOCK','GRN','XYZ040619585','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7455,'XYZ-1768195228393-F3B1F00C',1,NULL,'IN_STOCK','GRN','XYZ011944139','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7456,'XYZ-1768195228415-48CD23E2',1,NULL,'IN_STOCK','GRN','XYZ872767786','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7457,'XYZ-1768195228438-46E801BC',1,NULL,'IN_STOCK','GRN','XYZ649784502','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7458,'XYZ-1768195228462-2277781B',1,NULL,'IN_STOCK','GRN','XYZ406182899','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7459,'XYZ-1768195228486-CB3952A1',1,NULL,'IN_STOCK','GRN','XYZ675605944','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7460,'XYZ-1768195228507-2FFC73E2',1,NULL,'IN_STOCK','GRN','XYZ701867398','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7461,'XYZ-1768195228529-B8D31476',1,NULL,'IN_STOCK','GRN','XYZ268563670','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7462,'XYZ-1768195228551-DEC4B5C4',1,NULL,'IN_STOCK','GRN','XYZ002040263','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7463,'XYZ-1768195228573-396ECD95',1,NULL,'IN_STOCK','GRN','XYZ401262895','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7464,'XYZ-1768195228594-F5D72F4E',1,NULL,'IN_STOCK','GRN','XYZ712795592','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7465,'XYZ-1768195228616-2281D292',1,NULL,'IN_STOCK','GRN','XYZ320489348','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7466,'XYZ-1768195228638-29D2F0A4',1,NULL,'IN_STOCK','GRN','XYZ068710918','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7467,'XYZ-1768195228659-2CFBD490',1,NULL,'IN_STOCK','GRN','XYZ144194531','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7468,'XYZ-1768195228681-BB714885',1,NULL,'IN_STOCK','GRN','XYZ219945675','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7469,'XYZ-1768195228703-6C7D1A6D',1,NULL,'IN_STOCK','GRN','XYZ502443624','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7470,'XYZ-1768195228726-A77B0AF9',1,NULL,'IN_STOCK','GRN','XYZ818164950','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7471,'XYZ-1768195228748-6A1D9558',1,NULL,'IN_STOCK','GRN','XYZ133426467','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7472,'XYZ-1768195228770-2ABE7087',1,NULL,'IN_STOCK','GRN','XYZ497568195','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7473,'XYZ-1768195228792-88ACB77D',1,NULL,'IN_STOCK','GRN','XYZ149347481','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7474,'XYZ-1768195228814-752638AA',1,NULL,'IN_STOCK','GRN','XYZ480369465','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7475,'XYZ-1768195228836-13E8D076',1,NULL,'IN_STOCK','GRN','XYZ415064717','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7476,'XYZ-1768195228859-04E9B781',1,NULL,'IN_STOCK','GRN','XYZ502574630','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7477,'XYZ-1768195228881-A0147367',1,NULL,'IN_STOCK','GRN','XYZ579102455','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7478,'XYZ-1768195228903-010182F1',1,NULL,'IN_STOCK','GRN','XYZ432137546','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7479,'XYZ-1768195228925-3AD16711',1,NULL,'IN_STOCK','GRN','XYZ788683438','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7480,'XYZ-1768195228947-7B65D172',1,NULL,'IN_STOCK','GRN','XYZ986361188','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7481,'XYZ-1768195228969-6A3C037D',1,NULL,'IN_STOCK','GRN','XYZ427146952','2026-01-12 05:20:28','2026-01-12 05:20:28'),(7482,'XYZ-1768195228991-FE65A77D',1,NULL,'IN_STOCK','GRN','XYZ393176550','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7483,'XYZ-1768195229014-EA460843',1,NULL,'IN_STOCK','GRN','XYZ799907180','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7484,'XYZ-1768195229036-9AAA0F66',1,NULL,'IN_STOCK','GRN','XYZ116184915','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7485,'XYZ-1768195229058-35DE99D8',1,NULL,'IN_STOCK','GRN','XYZ534451526','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7486,'XYZ-1768195229082-4D9644AD',1,NULL,'IN_STOCK','GRN','XYZ430731055','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7487,'XYZ-1768195229104-7049740A',1,NULL,'IN_STOCK','GRN','XYZ454013773','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7488,'XYZ-1768195229126-4FFA4E7A',1,NULL,'IN_STOCK','GRN','XYZ938597192','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7489,'XYZ-1768195229148-5CB094B3',1,NULL,'IN_STOCK','GRN','XYZ456963770','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7490,'XYZ-1768195229171-8032E7F5',1,NULL,'IN_STOCK','GRN','XYZ816488663','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7491,'XYZ-1768195229193-7AE672AB',1,NULL,'IN_STOCK','GRN','XYZ771742984','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7492,'XYZ-1768195229215-346E37CA',1,NULL,'IN_STOCK','GRN','XYZ993915667','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7493,'XYZ-1768195229239-A8721346',1,NULL,'IN_STOCK','GRN','XYZ259418186','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7494,'XYZ-1768195229260-DF531588',1,NULL,'IN_STOCK','GRN','XYZ196415371','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7495,'XYZ-1768195229282-6E94DF64',1,NULL,'IN_STOCK','GRN','XYZ561836719','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7496,'XYZ-1768195229304-B44456F6',1,NULL,'IN_STOCK','GRN','XYZ056570852','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7497,'XYZ-1768195229326-F18262F9',1,NULL,'IN_STOCK','GRN','XYZ307577468','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7498,'XYZ-1768195229348-0328C34F',1,NULL,'IN_STOCK','GRN','XYZ164460827','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7499,'XYZ-1768195229371-EDE150A8',1,NULL,'IN_STOCK','GRN','XYZ813678229','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7500,'XYZ-1768195229395-C10E5917',1,NULL,'IN_STOCK','GRN','XYZ703374303','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7501,'XYZ-1768195229417-7B40A49C',1,NULL,'IN_STOCK','GRN','XYZ039376787','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7502,'XYZ-1768195229441-506C5BBD',1,NULL,'IN_STOCK','GRN','XYZ012582747','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7503,'XYZ-1768195229465-60FCBD01',1,NULL,'IN_STOCK','GRN','XYZ915914164','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7504,'XYZ-1768195229489-813671F0',1,NULL,'IN_STOCK','GRN','XYZ823471335','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7505,'XYZ-1768195229511-57B05E07',1,NULL,'IN_STOCK','GRN','XYZ030398994','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7506,'XYZ-1768195229535-FE180332',1,NULL,'IN_STOCK','GRN','XYZ721286586','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7507,'XYZ-1768195229559-9C800A31',1,NULL,'IN_STOCK','GRN','XYZ515388636','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7508,'XYZ-1768195229583-A6F3B0BD',1,NULL,'IN_STOCK','GRN','XYZ221809984','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7509,'XYZ-1768195229606-725FD477',1,NULL,'IN_STOCK','GRN','XYZ358719692','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7510,'XYZ-1768195229628-F33DA3DD',1,NULL,'IN_STOCK','GRN','XYZ784716686','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7511,'XYZ-1768195229650-87F45632',1,NULL,'IN_STOCK','GRN','XYZ434047935','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7512,'XYZ-1768195229672-78051F64',1,NULL,'IN_STOCK','GRN','XYZ739997518','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7513,'XYZ-1768195229695-D553BE0C',1,NULL,'IN_STOCK','GRN','XYZ344723169','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7514,'XYZ-1768195229717-F6FA1ACF',1,NULL,'IN_STOCK','GRN','XYZ035707464','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7515,'XYZ-1768195229739-A4ADD6E6',1,NULL,'IN_STOCK','GRN','XYZ192575737','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7516,'XYZ-1768195229761-49AFFC30',1,NULL,'IN_STOCK','GRN','XYZ557094539','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7517,'XYZ-1768195229782-15FC0566',1,NULL,'IN_STOCK','GRN','XYZ833624293','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7518,'XYZ-1768195229805-98950099',1,NULL,'IN_STOCK','GRN','XYZ583559013','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7519,'XYZ-1768195229826-3134EA98',1,NULL,'IN_STOCK','GRN','XYZ767033161','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7520,'XYZ-1768195229849-CD13F114',1,NULL,'IN_STOCK','GRN','XYZ048206492','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7521,'XYZ-1768195229875-452BB68D',1,NULL,'IN_STOCK','GRN','XYZ823151004','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7522,'XYZ-1768195229902-6058D56C',1,NULL,'IN_STOCK','GRN','XYZ415600622','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7523,'XYZ-1768195229925-0F12E685',1,NULL,'IN_STOCK','GRN','XYZ361267792','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7524,'XYZ-1768195229950-C93DE78D',1,NULL,'IN_STOCK','GRN','XYZ069382209','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7525,'XYZ-1768195229972-C7CE25E4',1,NULL,'IN_STOCK','GRN','XYZ312146783','2026-01-12 05:20:29','2026-01-12 05:20:29'),(7526,'XYZ-1768195229994-088EC4BB',1,NULL,'IN_STOCK','GRN','XYZ679201120','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7527,'XYZ-1768195230016-DC692493',1,NULL,'IN_STOCK','GRN','XYZ002648935','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7528,'XYZ-1768195230040-3E254A1E',1,NULL,'IN_STOCK','GRN','XYZ129589861','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7529,'XYZ-1768195230061-C2159026',1,NULL,'IN_STOCK','GRN','XYZ110605745','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7530,'XYZ-1768195230084-FD277527',1,NULL,'IN_STOCK','GRN','XYZ905912977','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7531,'XYZ-1768195230106-7155B586',1,NULL,'IN_STOCK','GRN','XYZ032706612','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7532,'XYZ-1768195230128-28B114AD',1,NULL,'IN_STOCK','GRN','XYZ832469729','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7533,'XYZ-1768195230150-00517E16',1,NULL,'IN_STOCK','GRN','XYZ257723762','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7534,'XYZ-1768195230172-FED20993',1,NULL,'IN_STOCK','GRN','XYZ237241484','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7535,'XYZ-1768195230194-A51D4925',1,NULL,'IN_STOCK','GRN','XYZ300526687','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7536,'XYZ-1768195230216-B7248AAF',1,NULL,'IN_STOCK','GRN','XYZ888399788','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7537,'XYZ-1768195230238-87D352F4',1,NULL,'IN_STOCK','GRN','XYZ752059630','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7538,'XYZ-1768195230260-58DAC2AF',1,NULL,'IN_STOCK','GRN','XYZ283826758','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7539,'XYZ-1768195230282-BE5D4237',1,NULL,'IN_STOCK','GRN','XYZ216673940','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7540,'XYZ-1768195230304-A63CF5CD',1,NULL,'IN_STOCK','GRN','XYZ801047527','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7541,'XYZ-1768195230326-23FF6EF0',1,NULL,'IN_STOCK','GRN','XYZ052214022','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7542,'XYZ-1768195230353-38A31653',1,NULL,'IN_STOCK','GRN','XYZ985829858','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7543,'XYZ-1768195230376-9BB032E9',1,NULL,'IN_STOCK','GRN','XYZ968110087','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7544,'XYZ-1768195230395-D64635BC',1,NULL,'IN_STOCK','GRN','XYZ684533553','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7545,'XYZ-1768195230414-8EFB9533',1,NULL,'IN_STOCK','GRN','XYZ040318527','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7546,'XYZ-1768195230433-B3ECD0D1',1,NULL,'IN_STOCK','GRN','XYZ586355710','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7547,'XYZ-1768195230456-913AA626',1,NULL,'IN_STOCK','GRN','XYZ435557240','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7548,'XYZ-1768195230478-418D44D4',1,NULL,'IN_STOCK','GRN','XYZ413400598','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7549,'XYZ-1768195230500-B6D8558E',1,NULL,'IN_STOCK','GRN','XYZ291494524','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7550,'XYZ-1768195230522-5FC7F954',1,NULL,'IN_STOCK','GRN','XYZ290278841','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7551,'XYZ-1768195230545-480B8E88',1,NULL,'IN_STOCK','GRN','XYZ503614843','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7552,'XYZ-1768195230568-7565C9BB',1,NULL,'IN_STOCK','GRN','XYZ405703148','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7553,'XYZ-1768195230590-21F85C99',1,NULL,'IN_STOCK','GRN','XYZ620725688','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7554,'XYZ-1768195230612-0FC3DE6F',1,NULL,'IN_STOCK','GRN','XYZ442166153','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7555,'XYZ-1768195230637-7CDCF5AE',1,NULL,'IN_STOCK','GRN','XYZ226803044','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7556,'XYZ-1768195230659-CA8D8104',1,NULL,'IN_STOCK','GRN','XYZ486552741','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7557,'XYZ-1768195230682-8D4A6C8F',1,NULL,'IN_STOCK','GRN','XYZ607347710','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7558,'XYZ-1768195230704-112EDC0A',1,NULL,'IN_STOCK','GRN','XYZ988439930','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7559,'XYZ-1768195230726-010012C0',1,NULL,'IN_STOCK','GRN','XYZ942961524','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7560,'XYZ-1768195230751-249FCBF8',1,NULL,'IN_STOCK','GRN','XYZ573721005','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7561,'XYZ-1768195230777-11F6BBFB',1,NULL,'IN_STOCK','GRN','XYZ080041702','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7562,'XYZ-1768195230800-D9CD9105',1,NULL,'IN_STOCK','GRN','XYZ292871570','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7563,'XYZ-1768195230824-E2594A3D',1,NULL,'IN_STOCK','GRN','XYZ658982391','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7564,'XYZ-1768195230846-ACE3FE7F',1,NULL,'IN_STOCK','GRN','XYZ348424998','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7565,'XYZ-1768195230868-83101BD0',1,NULL,'IN_STOCK','GRN','XYZ662001889','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7566,'XYZ-1768195230890-04CC969D',1,NULL,'IN_STOCK','GRN','XYZ134466030','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7567,'XYZ-1768195230913-785AF960',1,NULL,'IN_STOCK','GRN','XYZ720227146','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7568,'XYZ-1768195230937-334FBD76',1,NULL,'IN_STOCK','GRN','XYZ115866605','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7569,'XYZ-1768195230963-FF720C1E',1,NULL,'IN_STOCK','GRN','XYZ359915730','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7570,'XYZ-1768195230985-0783853A',1,NULL,'IN_STOCK','GRN','XYZ715220208','2026-01-12 05:20:30','2026-01-12 05:20:30'),(7571,'XYZ-1768195231007-4543C696',1,NULL,'IN_STOCK','GRN','XYZ509397078','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7572,'XYZ-1768195231029-17FF5EB9',1,NULL,'IN_STOCK','GRN','XYZ132478246','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7573,'XYZ-1768195231054-94FCCC64',1,NULL,'IN_STOCK','GRN','XYZ396187278','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7574,'XYZ-1768195231079-29CF095A',1,NULL,'IN_STOCK','GRN','XYZ524203629','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7575,'XYZ-1768195231102-DF984E7C',1,NULL,'IN_STOCK','GRN','XYZ817721986','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7576,'XYZ-1768195231122-3A367132',1,NULL,'IN_STOCK','GRN','XYZ912972181','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7577,'XYZ-1768195231146-D82F877F',1,NULL,'IN_STOCK','GRN','XYZ793235773','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7578,'XYZ-1768195231169-FF8E13B1',1,NULL,'IN_STOCK','GRN','XYZ469017547','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7579,'XYZ-1768195231192-758050CB',1,NULL,'IN_STOCK','GRN','XYZ220723336','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7580,'XYZ-1768195231222-707FB620',1,NULL,'IN_STOCK','GRN','XYZ309707172','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7581,'XYZ-1768195231245-D0CF0722',1,NULL,'IN_STOCK','GRN','XYZ425557030','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7582,'XYZ-1768195231271-FF48B738',1,NULL,'IN_STOCK','GRN','XYZ418596778','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7583,'XYZ-1768195231293-5514053D',1,NULL,'IN_STOCK','GRN','XYZ783169127','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7584,'XYZ-1768195231315-4208D7EB',1,NULL,'IN_STOCK','GRN','XYZ672593004','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7585,'XYZ-1768195231338-B38DBA20',1,NULL,'IN_STOCK','GRN','XYZ117727932','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7586,'XYZ-1768195231362-80F8B404',1,NULL,'IN_STOCK','GRN','XYZ403145531','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7587,'XYZ-1768195231389-3D945AFB',1,NULL,'IN_STOCK','GRN','XYZ159001984','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7588,'XYZ-1768195231416-299E8177',1,NULL,'IN_STOCK','GRN','XYZ496169828','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7589,'XYZ-1768195231442-15A8EFDC',1,NULL,'IN_STOCK','GRN','XYZ299314392','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7590,'XYZ-1768195231467-FAD08562',1,NULL,'IN_STOCK','GRN','XYZ880489089','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7591,'XYZ-1768195231490-1224A195',1,NULL,'IN_STOCK','GRN','XYZ810207532','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7592,'XYZ-1768195231512-9CAD91E2',1,NULL,'IN_STOCK','GRN','XYZ444708987','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7593,'XYZ-1768195231534-2970F995',1,NULL,'IN_STOCK','GRN','XYZ465465758','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7594,'XYZ-1768195231556-D4969E35',1,NULL,'IN_STOCK','GRN','XYZ100468173','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7595,'XYZ-1768195231580-22284FD9',1,NULL,'IN_STOCK','GRN','XYZ514066448','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7596,'XYZ-1768195231605-161FE615',1,NULL,'IN_STOCK','GRN','XYZ482663021','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7597,'XYZ-1768195231631-4B7AA2A1',1,NULL,'IN_STOCK','GRN','XYZ649530693','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7598,'XYZ-1768195231655-FABFEA05',1,NULL,'IN_STOCK','GRN','XYZ710037588','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7599,'XYZ-1768195231679-7E35D4AE',1,NULL,'IN_STOCK','GRN','XYZ605735085','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7600,'XYZ-1768195231705-2DAE3335',1,NULL,'IN_STOCK','GRN','XYZ296184706','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7601,'XYZ-1768195231731-E86768D7',1,NULL,'IN_STOCK','GRN','XYZ998833678','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7602,'XYZ-1768195231756-20066986',1,NULL,'IN_STOCK','GRN','XYZ758082802','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7603,'XYZ-1768195231779-60D35DDB',1,NULL,'IN_STOCK','GRN','XYZ434546151','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7604,'XYZ-1768195231806-B8EDD160',1,NULL,'IN_STOCK','GRN','XYZ621385240','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7605,'XYZ-1768195231828-B8419B61',1,NULL,'IN_STOCK','GRN','XYZ022595758','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7606,'XYZ-1768195231852-7BC884BB',1,NULL,'IN_STOCK','GRN','XYZ034857579','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7607,'XYZ-1768195231876-F053690C',1,NULL,'IN_STOCK','GRN','XYZ401765277','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7608,'XYZ-1768195231901-F8616BE3',1,NULL,'IN_STOCK','GRN','XYZ985099145','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7609,'XYZ-1768195231924-A79E54A4',1,NULL,'IN_STOCK','GRN','XYZ966522029','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7610,'XYZ-1768195231946-8BA7959D',1,NULL,'IN_STOCK','GRN','XYZ346752205','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7611,'XYZ-1768195231971-2422D410',1,NULL,'IN_STOCK','GRN','XYZ973739783','2026-01-12 05:20:31','2026-01-12 05:20:31'),(7612,'XYZ-1768195231993-E870F61D',1,NULL,'IN_STOCK','GRN','XYZ699701913','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7613,'XYZ-1768195232016-90260304',1,NULL,'IN_STOCK','GRN','XYZ753945057','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7614,'XYZ-1768195232038-45DC5C3E',1,NULL,'IN_STOCK','GRN','XYZ291468885','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7615,'XYZ-1768195232062-59735633',1,NULL,'IN_STOCK','GRN','XYZ708927660','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7616,'XYZ-1768195232083-6207AB3C',1,NULL,'IN_STOCK','GRN','XYZ899377834','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7617,'XYZ-1768195232105-88974766',1,NULL,'IN_STOCK','GRN','XYZ793011736','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7618,'XYZ-1768195232130-1FCD8FF1',1,NULL,'IN_STOCK','GRN','XYZ632967300','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7619,'XYZ-1768195232153-E3758CC9',1,NULL,'IN_STOCK','GRN','XYZ078078684','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7620,'XYZ-1768195232176-01DBF201',1,NULL,'IN_STOCK','GRN','XYZ688951731','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7621,'XYZ-1768195232198-50C79280',1,NULL,'IN_STOCK','GRN','XYZ733543168','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7622,'XYZ-1768195232220-8A029653',1,NULL,'IN_STOCK','GRN','XYZ994588369','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7623,'XYZ-1768195232246-678F9AD3',1,NULL,'IN_STOCK','GRN','XYZ952087725','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7624,'XYZ-1768195232272-A3CA43F0',1,NULL,'IN_STOCK','GRN','XYZ191907433','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7625,'XYZ-1768195232298-21C1D7D5',1,NULL,'IN_STOCK','GRN','XYZ682704141','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7626,'XYZ-1768195232326-198841F6',1,NULL,'IN_STOCK','GRN','XYZ322361922','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7627,'XYZ-1768195232351-12903495',1,NULL,'IN_STOCK','GRN','XYZ417605589','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7628,'XYZ-1768195232373-181469B0',1,NULL,'IN_STOCK','GRN','XYZ344781562','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7629,'XYZ-1768195232398-F7CF8579',1,NULL,'IN_STOCK','GRN','XYZ067525999','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7630,'XYZ-1768195232420-38172FEE',1,NULL,'IN_STOCK','GRN','XYZ889741500','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7631,'XYZ-1768195232446-0F9A888A',1,NULL,'IN_STOCK','GRN','XYZ163300377','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7632,'XYZ-1768195232470-9D8FD39D',1,NULL,'IN_STOCK','GRN','XYZ037574859','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7633,'XYZ-1768195232492-58127B41',1,NULL,'IN_STOCK','GRN','XYZ616256086','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7634,'XYZ-1768195232514-F2464AE0',1,NULL,'IN_STOCK','GRN','XYZ566105129','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7635,'XYZ-1768195232536-E1A8DFC2',1,NULL,'IN_STOCK','GRN','XYZ280797754','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7636,'XYZ-1768195232559-A0C557D6',1,NULL,'IN_STOCK','GRN','XYZ031500562','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7637,'XYZ-1768195232583-7180C5DA',1,NULL,'IN_STOCK','GRN','XYZ473313953','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7638,'XYZ-1768195232605-67135244',1,NULL,'IN_STOCK','GRN','XYZ466170075','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7639,'XYZ-1768195232627-907AE08D',1,NULL,'IN_STOCK','GRN','XYZ842934829','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7640,'XYZ-1768195232649-DE34D0C9',1,NULL,'IN_STOCK','GRN','XYZ145802202','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7641,'XYZ-1768195232673-EB1C2F08',1,NULL,'IN_STOCK','GRN','XYZ052432179','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7642,'XYZ-1768195232697-2DB711F2',1,NULL,'IN_STOCK','GRN','XYZ211298360','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7643,'XYZ-1768195232719-832B508C',1,NULL,'IN_STOCK','GRN','XYZ457584059','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7644,'XYZ-1768195232741-53B567CF',1,NULL,'IN_STOCK','GRN','XYZ914791781','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7645,'XYZ-1768195232764-E6B27AF1',1,NULL,'IN_STOCK','GRN','XYZ391282913','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7646,'XYZ-1768195232787-617FF4C6',1,NULL,'IN_STOCK','GRN','XYZ567913546','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7647,'XYZ-1768195232810-6C16D57C',1,NULL,'IN_STOCK','GRN','XYZ819501774','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7648,'XYZ-1768195232835-63F7E71C',1,NULL,'IN_STOCK','GRN','XYZ109092754','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7649,'XYZ-1768195232861-E8CFAF2F',1,NULL,'IN_STOCK','GRN','XYZ723864966','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7650,'XYZ-1768195232887-CD271DB5',1,NULL,'IN_STOCK','GRN','XYZ385226339','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7651,'XYZ-1768195232913-71FAEF0D',1,NULL,'IN_STOCK','GRN','XYZ556542555','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7652,'XYZ-1768195232936-26A53511',1,NULL,'IN_STOCK','GRN','XYZ348023856','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7653,'XYZ-1768195232961-2B102777',1,NULL,'IN_STOCK','GRN','XYZ279740281','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7654,'XYZ-1768195232987-E6E70F41',1,NULL,'IN_STOCK','GRN','XYZ901795622','2026-01-12 05:20:32','2026-01-12 05:20:32'),(7655,'XYZ-1768195233010-C8D630E2',1,NULL,'IN_STOCK','GRN','XYZ399009320','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7656,'XYZ-1768195233032-05887CCB',1,NULL,'IN_STOCK','GRN','XYZ932704142','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7657,'XYZ-1768195233054-3D1E72E1',1,NULL,'IN_STOCK','GRN','XYZ506672982','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7658,'XYZ-1768195233078-EA2A9019',1,NULL,'IN_STOCK','GRN','XYZ850699271','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7659,'XYZ-1768195233101-09AD399B',1,NULL,'IN_STOCK','GRN','XYZ723701820','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7660,'XYZ-1768195233124-05E2CDDA',1,NULL,'IN_STOCK','GRN','XYZ061230949','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7661,'XYZ-1768195233146-BF2793F7',1,NULL,'IN_STOCK','GRN','XYZ888146440','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7662,'XYZ-1768195233169-7BC7FD6A',1,NULL,'IN_STOCK','GRN','XYZ987057524','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7663,'XYZ-1768195233191-8694CA16',1,NULL,'IN_STOCK','GRN','XYZ585070911','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7664,'XYZ-1768195233213-6458FAB4',1,NULL,'IN_STOCK','GRN','XYZ440059912','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7665,'XYZ-1768195233235-7A902009',1,NULL,'IN_STOCK','GRN','XYZ871119526','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7666,'XYZ-1768195233257-15A86D4F',1,NULL,'IN_STOCK','GRN','XYZ534080881','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7667,'XYZ-1768195233281-9604F97D',1,NULL,'IN_STOCK','GRN','XYZ307041775','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7668,'XYZ-1768195233303-513CE61A',1,NULL,'IN_STOCK','GRN','XYZ089085318','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7669,'XYZ-1768195233325-E9B88F79',1,NULL,'IN_STOCK','GRN','XYZ186370428','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7670,'XYZ-1768195233348-DBAFA90A',1,NULL,'IN_STOCK','GRN','XYZ538553200','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7671,'XYZ-1768195233372-3E798EB5',1,NULL,'IN_STOCK','GRN','XYZ832048708','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7672,'XYZ-1768195233394-DFEA242C',1,NULL,'IN_STOCK','GRN','XYZ178835325','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7673,'XYZ-1768195233415-185D4F39',1,NULL,'IN_STOCK','GRN','XYZ398346139','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7674,'XYZ-1768195233437-00F123D1',1,NULL,'IN_STOCK','GRN','XYZ649478546','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7675,'XYZ-1768195233459-435CAEEE',1,NULL,'IN_STOCK','GRN','XYZ478265610','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7676,'XYZ-1768195233483-A65AC618',1,NULL,'IN_STOCK','GRN','XYZ923941515','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7677,'XYZ-1768195233505-5B28BF82',1,NULL,'IN_STOCK','GRN','XYZ740819951','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7678,'XYZ-1768195233531-D6028B49',1,NULL,'IN_STOCK','GRN','XYZ440097109','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7679,'XYZ-1768195233557-FDCBF835',1,NULL,'IN_STOCK','GRN','XYZ351377318','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7680,'XYZ-1768195233582-374B4C45',1,NULL,'IN_STOCK','GRN','XYZ657113016','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7681,'XYZ-1768195233608-53F2B490',1,NULL,'IN_STOCK','GRN','XYZ363496741','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7682,'XYZ-1768195233630-C2F45FB7',1,NULL,'IN_STOCK','GRN','XYZ199701043','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7683,'XYZ-1768195233652-2D27EC5E',1,NULL,'IN_STOCK','GRN','XYZ460562719','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7684,'XYZ-1768195233677-BF055F2B',1,NULL,'IN_STOCK','GRN','XYZ133028196','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7685,'XYZ-1768195233701-5800D5B0',1,NULL,'IN_STOCK','GRN','XYZ278096445','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7686,'XYZ-1768195233723-A98E47D9',1,NULL,'IN_STOCK','GRN','XYZ289561293','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7687,'XYZ-1768195233745-69D33E38',1,NULL,'IN_STOCK','GRN','XYZ285481723','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7688,'XYZ-1768195233767-394D8B74',1,NULL,'IN_STOCK','GRN','XYZ117734564','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7689,'XYZ-1768195233789-3BA87608',1,NULL,'IN_STOCK','GRN','XYZ221387676','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7690,'XYZ-1768195233811-D385B480',1,NULL,'IN_STOCK','GRN','XYZ877901288','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7691,'XYZ-1768195233832-7223730E',1,NULL,'IN_STOCK','GRN','XYZ997318286','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7692,'XYZ-1768195233856-04789481',1,NULL,'IN_STOCK','GRN','XYZ845825407','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7693,'XYZ-1768195233881-F11BBB4F',1,NULL,'IN_STOCK','GRN','XYZ055750508','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7694,'XYZ-1768195233903-8FCC7F29',1,NULL,'IN_STOCK','GRN','XYZ849709279','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7695,'XYZ-1768195233925-15D33AAC',1,NULL,'IN_STOCK','GRN','XYZ882496739','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7696,'XYZ-1768195233949-3B82CCCA',1,NULL,'IN_STOCK','GRN','XYZ761633274','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7697,'XYZ-1768195233971-8F4F77C9',1,NULL,'IN_STOCK','GRN','XYZ471947116','2026-01-12 05:20:33','2026-01-12 05:20:33'),(7698,'XYZ-1768195233996-D4ED787C',1,NULL,'IN_STOCK','GRN','XYZ322396982','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7699,'XYZ-1768195234019-128CFD81',1,NULL,'IN_STOCK','GRN','XYZ888516758','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7700,'XYZ-1768195234041-9FEE5C43',1,NULL,'IN_STOCK','GRN','XYZ160544705','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7701,'XYZ-1768195234063-B9CD8F01',1,NULL,'IN_STOCK','GRN','XYZ609553496','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7702,'XYZ-1768195234087-4110DF8C',1,NULL,'IN_STOCK','GRN','XYZ175017547','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7703,'XYZ-1768195234109-3E2933E4',1,NULL,'IN_STOCK','GRN','XYZ032886710','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7704,'XYZ-1768195234131-41EF112B',1,NULL,'IN_STOCK','GRN','XYZ175326947','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7705,'XYZ-1768195234152-94266A97',1,NULL,'IN_STOCK','GRN','XYZ608961432','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7706,'XYZ-1768195234174-242551C7',1,NULL,'IN_STOCK','GRN','XYZ819827842','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7707,'XYZ-1768195234200-38B60B85',1,NULL,'IN_STOCK','GRN','XYZ300856355','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7708,'XYZ-1768195234225-969966D1',1,NULL,'IN_STOCK','GRN','XYZ076542086','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7709,'XYZ-1768195234250-2173D8E0',1,NULL,'IN_STOCK','GRN','XYZ571248269','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7710,'XYZ-1768195234273-59CA9DD1',1,NULL,'IN_STOCK','GRN','XYZ549845224','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7711,'XYZ-1768195234295-2BF1F066',1,NULL,'IN_STOCK','GRN','XYZ796958783','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7712,'XYZ-1768195234317-970D73A6',1,NULL,'IN_STOCK','GRN','XYZ115750356','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7713,'XYZ-1768195234339-C5165681',1,NULL,'IN_STOCK','GRN','XYZ432489484','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7714,'XYZ-1768195234361-FF4D2D4C',1,NULL,'IN_STOCK','GRN','XYZ195826083','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7715,'XYZ-1768195234387-7AAF2937',1,NULL,'IN_STOCK','GRN','XYZ257853999','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7716,'XYZ-1768195234409-CF2CEBAA',1,NULL,'IN_STOCK','GRN','XYZ808150261','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7717,'XYZ-1768195234432-36A88C48',1,NULL,'IN_STOCK','GRN','XYZ732194211','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7718,'XYZ-1768195234454-B5E8E691',1,NULL,'IN_STOCK','GRN','XYZ179635804','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7719,'XYZ-1768195234477-298E0568',1,NULL,'IN_STOCK','GRN','XYZ797964853','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7720,'XYZ-1768195234502-9BAB2512',1,NULL,'IN_STOCK','GRN','XYZ114210484','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7721,'XYZ-1768195234524-EB4E69EC',1,NULL,'IN_STOCK','GRN','XYZ670929608','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7722,'XYZ-1768195234546-2DFD3458',1,NULL,'IN_STOCK','GRN','XYZ028651081','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7723,'XYZ-1768195234569-783DD76D',1,NULL,'IN_STOCK','GRN','XYZ036155777','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7724,'XYZ-1768195234592-6DB4192A',1,NULL,'IN_STOCK','GRN','XYZ295039805','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7725,'XYZ-1768195234613-DC5056CA',1,NULL,'IN_STOCK','GRN','XYZ000841171','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7726,'XYZ-1768195234635-8197E847',1,NULL,'IN_STOCK','GRN','XYZ328479286','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7727,'XYZ-1768195234657-25DEEF88',1,NULL,'IN_STOCK','GRN','XYZ199901028','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7728,'XYZ-1768195234679-11E80118',1,NULL,'IN_STOCK','GRN','XYZ418088680','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7729,'XYZ-1768195234701-489AE041',1,NULL,'IN_STOCK','GRN','XYZ947481592','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7730,'XYZ-1768195234723-E3711F1A',1,NULL,'IN_STOCK','GRN','XYZ011593891','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7731,'XYZ-1768195234746-98EC5BFA',1,NULL,'IN_STOCK','GRN','XYZ545942602','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7732,'XYZ-1768195234768-07F9AF6F',1,NULL,'IN_STOCK','GRN','XYZ341415389','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7733,'XYZ-1768195234790-19FE71C8',1,NULL,'IN_STOCK','GRN','XYZ069439745','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7734,'XYZ-1768195234815-0C494644',1,NULL,'IN_STOCK','GRN','XYZ299383287','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7735,'XYZ-1768195234837-D2547864',1,NULL,'IN_STOCK','GRN','XYZ525406701','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7736,'XYZ-1768195234859-46EE5B36',1,NULL,'IN_STOCK','GRN','XYZ729659133','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7737,'XYZ-1768195234881-EDC2EBAC',1,NULL,'IN_STOCK','GRN','XYZ260484516','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7738,'XYZ-1768195234903-E990CA42',1,NULL,'IN_STOCK','GRN','XYZ058261509','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7739,'XYZ-1768195234925-153CB3F8',1,NULL,'IN_STOCK','GRN','XYZ305314899','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7740,'XYZ-1768195234947-8C6E9BD9',1,NULL,'IN_STOCK','GRN','XYZ404696840','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7741,'XYZ-1768195234969-14D04F7A',1,NULL,'IN_STOCK','GRN','XYZ227172145','2026-01-12 05:20:34','2026-01-12 05:20:34'),(7742,'XYZ-1768195234990-F243CD98',1,NULL,'IN_STOCK','GRN','XYZ763988806','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7743,'XYZ-1768195235012-CEFFB9D6',1,NULL,'IN_STOCK','GRN','XYZ500694808','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7744,'XYZ-1768195235034-68D5CE91',1,NULL,'IN_STOCK','GRN','XYZ927467189','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7745,'XYZ-1768195235056-72FC0F47',1,NULL,'IN_STOCK','GRN','XYZ562573789','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7746,'XYZ-1768195235078-2A1AF8F9',1,NULL,'IN_STOCK','GRN','XYZ144024294','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7747,'XYZ-1768195235101-472DE767',1,NULL,'IN_STOCK','GRN','XYZ822049903','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7748,'XYZ-1768195235123-08C3C6D6',1,NULL,'IN_STOCK','GRN','XYZ641812839','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7749,'XYZ-1768195235145-56CE129B',1,NULL,'IN_STOCK','GRN','XYZ547935483','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7750,'XYZ-1768195235167-02F115F6',1,NULL,'IN_STOCK','GRN','XYZ165160657','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7751,'XYZ-1768195235191-3D87EBAD',1,NULL,'IN_STOCK','GRN','XYZ772287295','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7752,'XYZ-1768195235215-5A73D2EC',1,NULL,'IN_STOCK','GRN','XYZ265491565','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7753,'XYZ-1768195235238-AD0AAB64',1,NULL,'IN_STOCK','GRN','XYZ226265281','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7754,'XYZ-1768195235260-EE5AA4F5',1,NULL,'IN_STOCK','GRN','XYZ893217637','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7755,'XYZ-1768195235282-0852E505',1,NULL,'IN_STOCK','GRN','XYZ953689594','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7756,'XYZ-1768195235324-D6549AD3',1,NULL,'IN_STOCK','GRN','XYZ300809307','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7757,'XYZ-1768195235350-1147847A',1,NULL,'IN_STOCK','GRN','XYZ434885005','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7758,'XYZ-1768195235376-64705930',1,NULL,'IN_STOCK','GRN','XYZ180795675','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7759,'XYZ-1768195235399-E6DF3BF7',1,NULL,'IN_STOCK','GRN','XYZ053499853','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7760,'XYZ-1768195235421-247EBF01',1,NULL,'IN_STOCK','GRN','XYZ087044502','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7761,'XYZ-1768195235443-403BF25C',1,NULL,'IN_STOCK','GRN','XYZ350877435','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7762,'XYZ-1768195235466-3E300D3A',1,NULL,'IN_STOCK','GRN','XYZ639499297','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7763,'XYZ-1768195235488-3745DB99',1,NULL,'IN_STOCK','GRN','XYZ236941430','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7764,'XYZ-1768195235512-1A18C818',1,NULL,'IN_STOCK','GRN','XYZ280011397','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7765,'XYZ-1768195235536-DC642F35',1,NULL,'IN_STOCK','GRN','XYZ560075158','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7766,'XYZ-1768195235559-F70054D5',1,NULL,'IN_STOCK','GRN','XYZ239789600','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7767,'XYZ-1768195235581-A5DF0CD9',1,NULL,'IN_STOCK','GRN','XYZ824119374','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7768,'XYZ-1768195235605-B39783C8',1,NULL,'IN_STOCK','GRN','XYZ158158991','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7769,'XYZ-1768195235626-7898BF33',1,NULL,'IN_STOCK','GRN','XYZ798078085','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7770,'XYZ-1768195235646-9ED3BE94',1,NULL,'IN_STOCK','GRN','XYZ058819999','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7771,'XYZ-1768195235666-1D51EA70',1,NULL,'IN_STOCK','GRN','XYZ795884494','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7772,'XYZ-1768195235687-22D84D69',1,NULL,'IN_STOCK','GRN','XYZ812270169','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7773,'XYZ-1768195235709-69904318',1,NULL,'IN_STOCK','GRN','XYZ733342498','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7774,'XYZ-1768195235731-D2BAC41D',1,NULL,'IN_STOCK','GRN','XYZ750651085','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7775,'XYZ-1768195235753-768C1B84',1,NULL,'IN_STOCK','GRN','XYZ007795867','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7776,'XYZ-1768195235776-B9BC9D06',1,NULL,'IN_STOCK','GRN','XYZ699882322','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7777,'XYZ-1768195235798-F2EB2C82',1,NULL,'IN_STOCK','GRN','XYZ448585718','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7778,'XYZ-1768195235820-679231B8',1,NULL,'IN_STOCK','GRN','XYZ406993825','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7779,'XYZ-1768195235844-84EEA33D',1,NULL,'IN_STOCK','GRN','XYZ383062776','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7780,'XYZ-1768195235867-21DFF955',1,NULL,'IN_STOCK','GRN','XYZ673252898','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7781,'XYZ-1768195235889-29273849',1,NULL,'IN_STOCK','GRN','XYZ440428703','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7782,'XYZ-1768195235912-E8C0ECF9',1,NULL,'IN_STOCK','GRN','XYZ915822292','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7783,'XYZ-1768195235934-11F096B0',1,NULL,'IN_STOCK','GRN','XYZ500521910','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7784,'XYZ-1768195235957-ABE3AE00',1,NULL,'IN_STOCK','GRN','XYZ683420034','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7785,'XYZ-1768195235979-11C7CD50',1,NULL,'IN_STOCK','GRN','XYZ337937887','2026-01-12 05:20:35','2026-01-12 05:20:35'),(7786,'XYZ-1768195236002-18DF86B0',1,NULL,'IN_STOCK','GRN','XYZ257173624','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7787,'XYZ-1768195236024-4D7C8375',1,NULL,'IN_STOCK','GRN','XYZ158172994','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7788,'XYZ-1768195236046-6BD21824',1,NULL,'IN_STOCK','GRN','XYZ712586149','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7789,'XYZ-1768195236069-A8255EA0',1,NULL,'IN_STOCK','GRN','XYZ930436544','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7790,'XYZ-1768195236091-E189BEBD',1,NULL,'IN_STOCK','GRN','XYZ927032325','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7791,'XYZ-1768195236114-474BDF0B',1,NULL,'IN_STOCK','GRN','XYZ973833210','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7792,'XYZ-1768195236136-F19AE05F',1,NULL,'IN_STOCK','GRN','XYZ968120204','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7793,'XYZ-1768195236158-198020F9',1,NULL,'IN_STOCK','GRN','XYZ758799290','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7794,'XYZ-1768195236180-0C4AB2B4',1,NULL,'IN_STOCK','GRN','XYZ764609332','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7795,'XYZ-1768195236203-EDB9306E',1,NULL,'IN_STOCK','GRN','XYZ886197553','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7796,'XYZ-1768195236225-0F587332',1,NULL,'IN_STOCK','GRN','XYZ284684111','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7797,'XYZ-1768195236247-C3FA4F3C',1,NULL,'IN_STOCK','GRN','XYZ914476305','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7798,'XYZ-1768195236269-85FA0867',1,NULL,'IN_STOCK','GRN','XYZ162312691','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7799,'XYZ-1768195236292-1092F958',1,NULL,'IN_STOCK','GRN','XYZ430268487','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7800,'XYZ-1768195236314-361BEF1F',1,NULL,'IN_STOCK','GRN','XYZ259241822','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7801,'XYZ-1768195236336-3C69258D',1,NULL,'IN_STOCK','GRN','XYZ662402334','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7802,'XYZ-1768195236358-67BC3FF2',1,NULL,'IN_STOCK','GRN','XYZ903917914','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7803,'XYZ-1768195236381-6D1DCB88',1,NULL,'IN_STOCK','GRN','XYZ744035117','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7804,'XYZ-1768195236403-3EFD6A02',1,NULL,'IN_STOCK','GRN','XYZ010605616','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7805,'XYZ-1768195236425-A3CACC5E',1,NULL,'IN_STOCK','GRN','XYZ970567616','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7806,'XYZ-1768195236446-7BF89AF0',1,NULL,'IN_STOCK','GRN','XYZ533463650','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7807,'XYZ-1768195236474-11F26442',1,NULL,'IN_STOCK','GRN','XYZ762073362','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7808,'XYZ-1768195236497-05FA8EAD',1,NULL,'IN_STOCK','GRN','XYZ853176423','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7809,'XYZ-1768195236519-E8D4EF36',1,NULL,'IN_STOCK','GRN','XYZ571158950','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7810,'XYZ-1768195236540-E317B91E',1,NULL,'IN_STOCK','GRN','XYZ327411306','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7811,'XYZ-1768195236563-971F6EDF',1,NULL,'IN_STOCK','GRN','XYZ648240732','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7812,'XYZ-1768195236584-8E4F0A57',1,NULL,'IN_STOCK','GRN','XYZ837773457','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7813,'XYZ-1768195236607-11ED716A',1,NULL,'IN_STOCK','GRN','XYZ718942021','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7814,'XYZ-1768195236629-0FD2BFE9',1,NULL,'IN_STOCK','GRN','XYZ604557032','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7815,'XYZ-1768195236652-173A2C66',1,NULL,'IN_STOCK','GRN','XYZ190614231','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7816,'XYZ-1768195236674-DB23F0BA',1,NULL,'IN_STOCK','GRN','XYZ998953620','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7817,'XYZ-1768195236696-8DEC2819',1,NULL,'IN_STOCK','GRN','XYZ351657937','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7818,'XYZ-1768195236718-B3205840',1,NULL,'IN_STOCK','GRN','XYZ013376790','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7819,'XYZ-1768195236740-2811D5D5',1,NULL,'IN_STOCK','GRN','XYZ911077581','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7820,'XYZ-1768195236762-59AEB9B7',1,NULL,'IN_STOCK','GRN','XYZ355954014','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7821,'XYZ-1768195236787-7B78C7D6',1,NULL,'IN_STOCK','GRN','XYZ690373898','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7822,'XYZ-1768195236809-BEA2D65E',1,NULL,'IN_STOCK','GRN','XYZ780446073','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7823,'XYZ-1768195236831-BE4A24C1',1,NULL,'IN_STOCK','GRN','XYZ534533619','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7824,'XYZ-1768195236855-22051811',1,NULL,'IN_STOCK','GRN','XYZ316090598','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7825,'XYZ-1768195236877-06DCB564',1,NULL,'IN_STOCK','GRN','XYZ385231104','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7826,'XYZ-1768195236897-1D187229',1,NULL,'IN_STOCK','GRN','XYZ287576256','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7827,'XYZ-1768195236923-755B0E91',1,NULL,'IN_STOCK','GRN','XYZ633575860','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7828,'XYZ-1768195236946-F3B06AC6',1,NULL,'IN_STOCK','GRN','XYZ189887506','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7829,'XYZ-1768195236968-065D2FBB',1,NULL,'IN_STOCK','GRN','XYZ649667645','2026-01-12 05:20:36','2026-01-12 05:20:36'),(7830,'XYZ-1768195236990-F3C2231F',1,NULL,'IN_STOCK','GRN','XYZ182257618','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7831,'XYZ-1768195237013-C7FB0577',1,NULL,'IN_STOCK','GRN','XYZ168709354','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7832,'XYZ-1768195237036-4B1B0850',1,NULL,'IN_STOCK','GRN','XYZ191520238','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7833,'XYZ-1768195237058-A0C3168E',1,NULL,'IN_STOCK','GRN','XYZ980384692','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7834,'XYZ-1768195237083-EE5796E9',1,NULL,'IN_STOCK','GRN','XYZ526522195','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7835,'XYZ-1768195237105-218283CD',1,NULL,'IN_STOCK','GRN','XYZ561969751','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7836,'XYZ-1768195237128-03DD0A62',1,NULL,'IN_STOCK','GRN','XYZ622716735','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7837,'XYZ-1768195237150-334C3C6B',1,NULL,'IN_STOCK','GRN','XYZ306336804','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7838,'XYZ-1768195237172-92DEE376',1,NULL,'IN_STOCK','GRN','XYZ480569084','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7839,'XYZ-1768195237195-EEDDCC57',1,NULL,'IN_STOCK','GRN','XYZ787514804','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7840,'XYZ-1768195237217-97648732',1,NULL,'IN_STOCK','GRN','XYZ029758656','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7841,'XYZ-1768195237240-AA5092A7',1,NULL,'IN_STOCK','GRN','XYZ232865328','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7842,'XYZ-1768195237262-ED5A8F99',1,NULL,'IN_STOCK','GRN','XYZ167098175','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7843,'XYZ-1768195237285-AD05F160',1,NULL,'IN_STOCK','GRN','XYZ817656129','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7844,'XYZ-1768195237307-A3AE5424',1,NULL,'IN_STOCK','GRN','XYZ143157228','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7845,'XYZ-1768195237330-676FE222',1,NULL,'IN_STOCK','GRN','XYZ513094242','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7846,'XYZ-1768195237353-921FDC4E',1,NULL,'IN_STOCK','GRN','XYZ798915078','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7847,'XYZ-1768195237378-5F2036AB',1,NULL,'IN_STOCK','GRN','XYZ274441485','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7848,'XYZ-1768195237404-B716EFC2',1,NULL,'IN_STOCK','GRN','XYZ559217694','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7849,'XYZ-1768195237428-FAE02560',1,NULL,'IN_STOCK','GRN','XYZ108636000','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7850,'XYZ-1768195237452-1915BD1C',1,NULL,'IN_STOCK','GRN','XYZ343299479','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7851,'XYZ-1768195237474-E0B4EBB2',1,NULL,'IN_STOCK','GRN','XYZ456742432','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7852,'XYZ-1768195237496-E0222847',1,NULL,'IN_STOCK','GRN','XYZ582715596','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7853,'XYZ-1768195237519-CE26C11C',1,NULL,'IN_STOCK','GRN','XYZ224135022','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7854,'XYZ-1768195237541-5B6C9D3B',1,NULL,'IN_STOCK','GRN','XYZ663223803','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7855,'XYZ-1768195237563-5673B69C',1,NULL,'IN_STOCK','GRN','XYZ806812253','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7856,'XYZ-1768195237586-D184766C',1,NULL,'IN_STOCK','GRN','XYZ462271579','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7857,'XYZ-1768195237608-4EA48E89',1,NULL,'IN_STOCK','GRN','XYZ186427663','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7858,'XYZ-1768195237630-418B5D11',1,NULL,'IN_STOCK','GRN','XYZ856654108','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7859,'XYZ-1768195237654-602297D4',1,NULL,'IN_STOCK','GRN','XYZ654588738','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7860,'XYZ-1768195237676-22FCD0ED',1,NULL,'IN_STOCK','GRN','XYZ222174914','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7861,'XYZ-1768195237699-39AA74A3',1,NULL,'IN_STOCK','GRN','XYZ929080658','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7862,'XYZ-1768195237721-68806FCE',1,NULL,'IN_STOCK','GRN','XYZ371863667','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7863,'XYZ-1768195237743-B9E89756',1,NULL,'IN_STOCK','GRN','XYZ546059396','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7864,'XYZ-1768195237766-D04B9BA0',1,NULL,'IN_STOCK','GRN','XYZ053486329','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7865,'XYZ-1768195237793-19FE1CAB',1,NULL,'IN_STOCK','GRN','XYZ472245334','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7866,'XYZ-1768195237816-89473EB0',1,NULL,'IN_STOCK','GRN','XYZ656226971','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7867,'XYZ-1768195237839-0F11691E',1,NULL,'IN_STOCK','GRN','XYZ341598216','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7868,'XYZ-1768195237861-070F26BA',1,NULL,'IN_STOCK','GRN','XYZ183726414','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7869,'XYZ-1768195237887-CD2B6369',1,NULL,'IN_STOCK','GRN','XYZ819064219','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7870,'XYZ-1768195237909-23EEAEE2',1,NULL,'IN_STOCK','GRN','XYZ066869012','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7871,'XYZ-1768195237931-271A70D7',1,NULL,'IN_STOCK','GRN','XYZ288239900','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7872,'XYZ-1768195237956-CF33D6E0',1,NULL,'IN_STOCK','GRN','XYZ000862043','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7873,'XYZ-1768195237977-DDB30C1D',1,NULL,'IN_STOCK','GRN','XYZ672902571','2026-01-12 05:20:37','2026-01-12 05:20:37'),(7874,'XYZ-1768195238000-E593339B',1,NULL,'IN_STOCK','GRN','XYZ682953001','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7875,'XYZ-1768195238022-34217CAE',1,NULL,'IN_STOCK','GRN','XYZ428296617','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7876,'XYZ-1768195238047-753F7940',1,NULL,'IN_STOCK','GRN','XYZ373944236','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7877,'XYZ-1768195238070-C1498F7F',1,NULL,'IN_STOCK','GRN','XYZ271992739','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7878,'XYZ-1768195238093-4541D80B',1,NULL,'IN_STOCK','GRN','XYZ063901906','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7879,'XYZ-1768195238114-FB8CBE6F',1,NULL,'IN_STOCK','GRN','XYZ398464823','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7880,'XYZ-1768195238137-2058696D',1,NULL,'IN_STOCK','GRN','XYZ819440562','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7881,'XYZ-1768195238160-FCBCCF01',1,NULL,'IN_STOCK','GRN','XYZ660350098','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7882,'XYZ-1768195238182-48A9C228',1,NULL,'IN_STOCK','GRN','XYZ469966769','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7883,'XYZ-1768195238208-8DF62A64',1,NULL,'IN_STOCK','GRN','XYZ907167819','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7884,'XYZ-1768195238234-249482D3',1,NULL,'IN_STOCK','GRN','XYZ170393077','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7885,'XYZ-1768195238258-2E9DFEBC',1,NULL,'IN_STOCK','GRN','XYZ572581805','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7886,'XYZ-1768195238279-D12389BD',1,NULL,'IN_STOCK','GRN','XYZ713003165','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7887,'XYZ-1768195238301-61DF677B',1,NULL,'IN_STOCK','GRN','XYZ768748984','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7888,'XYZ-1768195238323-FD13516B',1,NULL,'IN_STOCK','GRN','XYZ993844216','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7889,'XYZ-1768195238345-BC50715C',1,NULL,'IN_STOCK','GRN','XYZ357205078','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7890,'XYZ-1768195238367-EE8AEE04',1,NULL,'IN_STOCK','GRN','XYZ553129930','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7891,'XYZ-1768195238390-2E5DF689',1,NULL,'IN_STOCK','GRN','XYZ499742109','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7892,'XYZ-1768195238412-AA6C2A66',1,NULL,'IN_STOCK','GRN','XYZ255643212','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7893,'XYZ-1768195238435-DAE801E6',1,NULL,'IN_STOCK','GRN','XYZ316280297','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7894,'XYZ-1768195238461-19CAEC93',1,NULL,'IN_STOCK','GRN','XYZ545119953','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7895,'XYZ-1768195238483-5F1C13AE',1,NULL,'IN_STOCK','GRN','XYZ323957388','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7896,'XYZ-1768195238505-0E9FCA78',1,NULL,'IN_STOCK','GRN','XYZ638830003','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7897,'XYZ-1768195238528-5895ABF6',1,NULL,'IN_STOCK','GRN','XYZ521046454','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7898,'XYZ-1768195238551-8F7AD430',1,NULL,'IN_STOCK','GRN','XYZ738794041','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7899,'XYZ-1768195238575-8C4AA621',1,NULL,'IN_STOCK','GRN','XYZ626562308','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7900,'XYZ-1768195238597-6BAC4377',1,NULL,'IN_STOCK','GRN','XYZ625963776','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7901,'XYZ-1768195238620-28CA225B',1,NULL,'IN_STOCK','GRN','XYZ973263499','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7902,'XYZ-1768195238642-C6890E77',1,NULL,'IN_STOCK','GRN','XYZ603491278','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7903,'XYZ-1768195238665-2B0E9A9F',1,NULL,'IN_STOCK','GRN','XYZ156784450','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7904,'XYZ-1768195238687-97FC9B9E',1,NULL,'IN_STOCK','GRN','XYZ245336955','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7905,'XYZ-1768195238711-695C3389',1,NULL,'IN_STOCK','GRN','XYZ891477578','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7906,'XYZ-1768195238733-00B0376C',1,NULL,'IN_STOCK','GRN','XYZ788851389','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7907,'XYZ-1768195238756-A0F801A6',1,NULL,'IN_STOCK','GRN','XYZ147463325','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7908,'XYZ-1768195238779-CA5387B4',1,NULL,'IN_STOCK','GRN','XYZ980290185','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7909,'XYZ-1768195238802-28EB5A44',1,NULL,'IN_STOCK','GRN','XYZ448903522','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7910,'XYZ-1768195238824-836DF588',1,NULL,'IN_STOCK','GRN','XYZ560291770','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7911,'XYZ-1768195238847-F83C2797',1,NULL,'IN_STOCK','GRN','XYZ895026099','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7912,'XYZ-1768195238870-8ACCC460',1,NULL,'IN_STOCK','GRN','XYZ264725585','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7913,'XYZ-1768195238894-4BCE863D',1,NULL,'IN_STOCK','GRN','XYZ744426738','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7914,'XYZ-1768195238916-B1D89618',1,NULL,'IN_STOCK','GRN','XYZ360023454','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7915,'XYZ-1768195238939-4BF82266',1,NULL,'IN_STOCK','GRN','XYZ436633295','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7916,'XYZ-1768195238961-FD535126',1,NULL,'IN_STOCK','GRN','XYZ189425231','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7917,'XYZ-1768195238983-02B54F88',1,NULL,'IN_STOCK','GRN','XYZ102649840','2026-01-12 05:20:38','2026-01-12 05:20:38'),(7918,'XYZ-1768195239006-68447604',1,NULL,'IN_STOCK','GRN','XYZ972565888','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7919,'XYZ-1768195239028-CE6ACB5E',1,NULL,'IN_STOCK','GRN','XYZ200983130','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7920,'XYZ-1768195239050-3865B733',1,NULL,'IN_STOCK','GRN','XYZ140424002','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7921,'XYZ-1768195239072-85532C7B',1,NULL,'IN_STOCK','GRN','XYZ843928311','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7922,'XYZ-1768195239094-E174D4E3',1,NULL,'IN_STOCK','GRN','XYZ364757973','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7923,'XYZ-1768195239117-0447CB0B',1,NULL,'IN_STOCK','GRN','XYZ775852115','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7924,'XYZ-1768195239139-7156C795',1,NULL,'IN_STOCK','GRN','XYZ916971259','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7925,'XYZ-1768195239162-1AAC2FAB',1,NULL,'IN_STOCK','GRN','XYZ977219562','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7926,'XYZ-1768195239184-13EADE91',1,NULL,'IN_STOCK','GRN','XYZ673425404','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7927,'XYZ-1768195239206-4CB61502',1,NULL,'IN_STOCK','GRN','XYZ919609157','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7928,'XYZ-1768195239228-310AE3AD',1,NULL,'IN_STOCK','GRN','XYZ197038943','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7929,'XYZ-1768195239251-B4AB6DD0',1,NULL,'IN_STOCK','GRN','XYZ801624903','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7930,'XYZ-1768195239273-8BA69797',1,NULL,'IN_STOCK','GRN','XYZ619044468','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7931,'XYZ-1768195239302-7E83D4DA',1,NULL,'IN_STOCK','GRN','XYZ767930816','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7932,'XYZ-1768195239324-D8996D0F',1,NULL,'IN_STOCK','GRN','XYZ258653890','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7933,'XYZ-1768195239347-5D9A28F1',1,NULL,'IN_STOCK','GRN','XYZ325563649','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7934,'XYZ-1768195239369-47AFE1E1',1,NULL,'IN_STOCK','GRN','XYZ135646486','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7935,'XYZ-1768195239389-D01B1C2C',1,NULL,'IN_STOCK','GRN','XYZ609630099','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7936,'XYZ-1768195239412-A6A9565E',1,NULL,'IN_STOCK','GRN','XYZ500378876','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7937,'XYZ-1768195239435-380A7BA9',1,NULL,'IN_STOCK','GRN','XYZ883240222','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7938,'XYZ-1768195239457-26DB3CEB',1,NULL,'IN_STOCK','GRN','XYZ318910622','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7939,'XYZ-1768195239480-F561C4CD',1,NULL,'IN_STOCK','GRN','XYZ666248690','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7940,'XYZ-1768195239502-FE0020DC',1,NULL,'IN_STOCK','GRN','XYZ452662650','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7941,'XYZ-1768195239525-B07B65EA',1,NULL,'IN_STOCK','GRN','XYZ409238659','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7942,'XYZ-1768195239547-065F7E2C',1,NULL,'IN_STOCK','GRN','XYZ001618040','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7943,'XYZ-1768195239570-98865DDA',1,NULL,'IN_STOCK','GRN','XYZ989727924','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7944,'XYZ-1768195239592-4B045F69',1,NULL,'IN_STOCK','GRN','XYZ187073328','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7945,'XYZ-1768195239615-7DE53103',1,NULL,'IN_STOCK','GRN','XYZ637318068','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7946,'XYZ-1768195239637-A4911366',1,NULL,'IN_STOCK','GRN','XYZ050303995','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7947,'XYZ-1768195239660-D3A4615F',1,NULL,'IN_STOCK','GRN','XYZ836874422','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7948,'XYZ-1768195239686-DFE0DA0A',1,NULL,'IN_STOCK','GRN','XYZ511540096','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7949,'XYZ-1768195239709-5851E0AA',1,NULL,'IN_STOCK','GRN','XYZ482036135','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7950,'XYZ-1768195239732-344519FD',1,NULL,'IN_STOCK','GRN','XYZ321557124','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7951,'XYZ-1768195239753-6176C5C6',1,NULL,'IN_STOCK','GRN','XYZ617974247','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7952,'XYZ-1768195239779-4A5F026D',1,NULL,'IN_STOCK','GRN','XYZ037348720','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7953,'XYZ-1768195239802-E939DF6C',1,NULL,'IN_STOCK','GRN','XYZ397635811','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7954,'XYZ-1768195239825-37A7723D',1,NULL,'IN_STOCK','GRN','XYZ136617577','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7955,'XYZ-1768195239847-0CBC5813',1,NULL,'IN_STOCK','GRN','XYZ832232781','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7956,'XYZ-1768195239870-7CBDC98A',1,NULL,'IN_STOCK','GRN','XYZ835272089','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7957,'XYZ-1768195239892-2EE93665',1,NULL,'IN_STOCK','GRN','XYZ105985296','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7958,'XYZ-1768195239915-BBB1336B',1,NULL,'IN_STOCK','GRN','XYZ527097616','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7959,'XYZ-1768195239937-B7DDA6BA',1,NULL,'IN_STOCK','GRN','XYZ155313816','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7960,'XYZ-1768195239960-1DE416BD',1,NULL,'IN_STOCK','GRN','XYZ404812428','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7961,'XYZ-1768195239983-39B33309',1,NULL,'IN_STOCK','GRN','XYZ407658357','2026-01-12 05:20:39','2026-01-12 05:20:39'),(7962,'XYZ-1768195240005-68186E3A',1,NULL,'IN_STOCK','GRN','XYZ858084181','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7963,'XYZ-1768195240027-C8BAE472',1,NULL,'IN_STOCK','GRN','XYZ920573633','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7964,'XYZ-1768195240050-8B8A6271',1,NULL,'IN_STOCK','GRN','XYZ012122535','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7965,'XYZ-1768195240073-B3BFBB65',1,NULL,'IN_STOCK','GRN','XYZ919252516','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7966,'XYZ-1768195240095-F3D2BD11',1,NULL,'IN_STOCK','GRN','XYZ592660129','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7967,'XYZ-1768195240117-C6CFE14C',1,NULL,'IN_STOCK','GRN','XYZ447087413','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7968,'XYZ-1768195240140-9E85B11B',1,NULL,'IN_STOCK','GRN','XYZ819306398','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7969,'XYZ-1768195240164-6F5322C6',1,NULL,'IN_STOCK','GRN','XYZ509411231','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7970,'XYZ-1768195240186-113BEBB2',1,NULL,'IN_STOCK','GRN','XYZ019053022','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7971,'XYZ-1768195240209-EDAAF025',1,NULL,'IN_STOCK','GRN','XYZ548783307','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7972,'XYZ-1768195240230-D8468D8C',1,NULL,'IN_STOCK','GRN','XYZ343471631','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7973,'XYZ-1768195240253-3BEAA4AE',1,NULL,'IN_STOCK','GRN','XYZ267415597','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7974,'XYZ-1768195240274-5FF04F59',1,NULL,'IN_STOCK','GRN','XYZ692927674','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7975,'XYZ-1768195240297-89723383',1,NULL,'IN_STOCK','GRN','XYZ759408380','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7976,'XYZ-1768195240320-18E6A12A',1,NULL,'IN_STOCK','GRN','XYZ798386305','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7977,'XYZ-1768195240344-1D41075E',1,NULL,'IN_STOCK','GRN','XYZ860040881','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7978,'XYZ-1768195240369-2B6690D7',1,NULL,'IN_STOCK','GRN','XYZ275513570','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7979,'XYZ-1768195240395-94F53ACF',1,NULL,'IN_STOCK','GRN','XYZ584631211','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7980,'XYZ-1768195240418-971A3610',1,NULL,'IN_STOCK','GRN','XYZ968561428','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7981,'XYZ-1768195240442-4BB91D54',1,NULL,'IN_STOCK','GRN','XYZ874839274','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7982,'XYZ-1768195240468-C4A9587D',1,NULL,'IN_STOCK','GRN','XYZ387043371','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7983,'XYZ-1768195240490-8A9E8EA5',1,NULL,'IN_STOCK','GRN','XYZ839269387','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7984,'XYZ-1768195240512-0D6BDDEC',1,NULL,'IN_STOCK','GRN','XYZ902937450','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7985,'XYZ-1768195240534-844AACD1',1,NULL,'IN_STOCK','GRN','XYZ058089762','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7986,'XYZ-1768195240556-9B6AA171',1,NULL,'IN_STOCK','GRN','XYZ833725838','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7987,'XYZ-1768195240581-06A0EB3A',1,NULL,'IN_STOCK','GRN','XYZ322806899','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7988,'XYZ-1768195240604-A6AE89D1',1,NULL,'IN_STOCK','GRN','XYZ249762859','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7989,'XYZ-1768195240627-3F6B7F42',1,NULL,'IN_STOCK','GRN','XYZ340849307','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7990,'XYZ-1768195240649-B15A8969',1,NULL,'IN_STOCK','GRN','XYZ173524173','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7991,'XYZ-1768195240672-17EC0B24',1,NULL,'IN_STOCK','GRN','XYZ217593824','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7992,'XYZ-1768195240697-191626BE',1,NULL,'IN_STOCK','GRN','XYZ471258090','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7993,'XYZ-1768195240722-5BEDF6EA',1,NULL,'IN_STOCK','GRN','XYZ095900695','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7994,'XYZ-1768195240748-FF0D798F',1,NULL,'IN_STOCK','GRN','XYZ164631878','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7995,'XYZ-1768195240773-F93B2C69',1,NULL,'IN_STOCK','GRN','XYZ887549736','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7996,'XYZ-1768195240796-ACC199F7',1,NULL,'IN_STOCK','GRN','XYZ553957732','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7997,'XYZ-1768195240818-215C9A2F',1,NULL,'IN_STOCK','GRN','XYZ127168095','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7998,'XYZ-1768195240840-BB77E713',1,NULL,'IN_STOCK','GRN','XYZ129865115','2026-01-12 05:20:40','2026-01-12 05:20:40'),(7999,'XYZ-1768195240862-7254748D',1,NULL,'IN_STOCK','GRN','XYZ982979652','2026-01-12 05:20:40','2026-01-12 05:20:40'),(8000,'XYZ-1768195240884-40BB23BE',1,NULL,'IN_STOCK','GRN','XYZ673816140','2026-01-12 05:20:40','2026-01-12 05:20:40'),(8001,'XYZ-1768195240906-CC021AA9',1,NULL,'IN_STOCK','GRN','XYZ349015004','2026-01-12 05:20:40','2026-01-12 05:20:40'),(8002,'XYZ-1768195240929-3292DD37',1,NULL,'IN_STOCK','GRN','XYZ380651543','2026-01-12 05:20:40','2026-01-12 05:20:40'),(8003,'XYZ-1768195240951-F42E5F79',1,NULL,'IN_STOCK','GRN','XYZ438385877','2026-01-12 05:20:40','2026-01-12 05:20:40'),(8004,'XYZ-1768195240978-BFCB4A1B',1,NULL,'IN_STOCK','GRN','XYZ079516890','2026-01-12 05:20:40','2026-01-12 05:20:40'),(8005,'XYZ-1768195241001-DFD48A71',1,NULL,'IN_STOCK','GRN','XYZ064169460','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8006,'XYZ-1768195241023-51B6FCFC',1,NULL,'IN_STOCK','GRN','XYZ950030561','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8007,'XYZ-1768195241046-3A003EFF',1,NULL,'IN_STOCK','GRN','XYZ891992810','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8008,'XYZ-1768195241068-89B9F391',1,NULL,'IN_STOCK','GRN','XYZ306482118','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8009,'XYZ-1768195241090-AF3750CE',1,NULL,'IN_STOCK','GRN','XYZ672908666','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8010,'XYZ-1768195241113-E74496F9',1,NULL,'IN_STOCK','GRN','XYZ668294225','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8011,'XYZ-1768195241135-72B3D35E',1,NULL,'IN_STOCK','GRN','XYZ437546785','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8012,'XYZ-1768195241158-265579F3',1,NULL,'IN_STOCK','GRN','XYZ162861817','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8013,'XYZ-1768195241180-CDB92EE6',1,NULL,'IN_STOCK','GRN','XYZ633616683','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8014,'XYZ-1768195241202-96225D87',1,NULL,'IN_STOCK','GRN','XYZ352214314','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8015,'XYZ-1768195241225-86164048',1,NULL,'IN_STOCK','GRN','XYZ132861358','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8016,'XYZ-1768195241248-9B6D7FC0',1,NULL,'IN_STOCK','GRN','XYZ940305296','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8017,'XYZ-1768195241270-DFEE6D44',1,NULL,'IN_STOCK','GRN','XYZ744989564','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8018,'XYZ-1768195241293-35E67C0E',1,NULL,'IN_STOCK','GRN','XYZ778496806','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8019,'XYZ-1768195241316-33648BA0',1,NULL,'IN_STOCK','GRN','XYZ208031690','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8020,'XYZ-1768195241339-40FFFE57',1,NULL,'IN_STOCK','GRN','XYZ993243700','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8021,'XYZ-1768195241362-81ABF05E',1,NULL,'IN_STOCK','GRN','XYZ833392753','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8022,'XYZ-1768195241387-D79E08B4',1,NULL,'IN_STOCK','GRN','XYZ397184408','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8023,'XYZ-1768195241413-9E777E65',1,NULL,'IN_STOCK','GRN','XYZ528347875','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8024,'XYZ-1768195241440-09327BFB',1,NULL,'IN_STOCK','GRN','XYZ749919219','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8025,'XYZ-1768195241466-1FD06018',1,NULL,'IN_STOCK','GRN','XYZ097339525','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8026,'XYZ-1768195241492-94D25AD9',1,NULL,'IN_STOCK','GRN','XYZ556344051','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8027,'XYZ-1768195241517-C7FE5A4E',1,NULL,'IN_STOCK','GRN','XYZ547908437','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8028,'XYZ-1768195241540-8A552F8D',1,NULL,'IN_STOCK','GRN','XYZ277040394','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8029,'XYZ-1768195241563-68C74F99',1,NULL,'IN_STOCK','GRN','XYZ856900581','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8030,'XYZ-1768195241585-04F0754A',1,NULL,'IN_STOCK','GRN','XYZ322609878','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8031,'XYZ-1768195241608-364C02E3',1,NULL,'IN_STOCK','GRN','XYZ279491520','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8032,'XYZ-1768195241631-CD2D12AD',1,NULL,'IN_STOCK','GRN','XYZ026659855','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8033,'XYZ-1768195241653-226F633E',1,NULL,'IN_STOCK','GRN','XYZ705232257','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8034,'XYZ-1768195241676-036C8BFB',1,NULL,'IN_STOCK','GRN','XYZ859823397','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8035,'XYZ-1768195241699-20EC57F9',1,NULL,'IN_STOCK','GRN','XYZ902708716','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8036,'XYZ-1768195241721-767D76D8',1,NULL,'IN_STOCK','GRN','XYZ466676628','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8037,'XYZ-1768195241744-85EFD9EB',1,NULL,'IN_STOCK','GRN','XYZ289840442','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8038,'XYZ-1768195241768-ECC091CF',1,NULL,'IN_STOCK','GRN','XYZ255211768','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8039,'XYZ-1768195241791-40FBA3DD',1,NULL,'IN_STOCK','GRN','XYZ762104604','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8040,'XYZ-1768195241814-1818FC6D',1,NULL,'IN_STOCK','GRN','XYZ885204121','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8041,'XYZ-1768195241836-55880C58',1,NULL,'IN_STOCK','GRN','XYZ723111819','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8042,'XYZ-1768195241859-6E1B9FC1',1,NULL,'IN_STOCK','GRN','XYZ230628177','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8043,'XYZ-1768195241882-DA4BF1D8',1,NULL,'IN_STOCK','GRN','XYZ329061369','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8044,'XYZ-1768195241908-93B392DC',1,NULL,'IN_STOCK','GRN','XYZ496170409','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8045,'XYZ-1768195241930-57826570',1,NULL,'IN_STOCK','GRN','XYZ473743834','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8046,'XYZ-1768195241953-BE2C833D',1,NULL,'IN_STOCK','GRN','XYZ908005061','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8047,'XYZ-1768195241976-B1C2E324',1,NULL,'IN_STOCK','GRN','XYZ591978671','2026-01-12 05:20:41','2026-01-12 05:20:41'),(8048,'XYZ-1768195242001-00A850E8',1,NULL,'IN_STOCK','GRN','XYZ438667900','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8049,'XYZ-1768195242025-C6AE8D34',1,NULL,'IN_STOCK','GRN','XYZ987657201','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8050,'XYZ-1768195242050-C23F34EA',1,NULL,'IN_STOCK','GRN','XYZ990237288','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8051,'XYZ-1768195242073-C0EA906F',1,NULL,'IN_STOCK','GRN','XYZ500115574','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8052,'XYZ-1768195242098-2ACE410C',1,NULL,'IN_STOCK','GRN','XYZ354662913','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8053,'XYZ-1768195242122-280C8B57',1,NULL,'IN_STOCK','GRN','XYZ352256000','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8054,'XYZ-1768195242145-8925BF86',1,NULL,'IN_STOCK','GRN','XYZ765262098','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8055,'XYZ-1768195242167-EC09EC87',1,NULL,'IN_STOCK','GRN','XYZ717343471','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8056,'XYZ-1768195242190-CDD139B9',1,NULL,'IN_STOCK','GRN','XYZ690982790','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8057,'XYZ-1768195242215-CE25EF05',1,NULL,'IN_STOCK','GRN','XYZ687561358','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8058,'XYZ-1768195242237-25A19EFA',1,NULL,'IN_STOCK','GRN','XYZ768709154','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8059,'XYZ-1768195242260-5D1512A2',1,NULL,'IN_STOCK','GRN','XYZ788059322','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8060,'XYZ-1768195242282-5B63E81E',1,NULL,'IN_STOCK','GRN','XYZ021568898','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8061,'XYZ-1768195242303-A832C6B3',1,NULL,'IN_STOCK','GRN','XYZ941081194','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8062,'XYZ-1768195242326-B763D587',1,NULL,'IN_STOCK','GRN','XYZ417261198','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8063,'XYZ-1768195242348-9DC94736',1,NULL,'IN_STOCK','GRN','XYZ972172187','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8064,'XYZ-1768195242370-C288383E',1,NULL,'IN_STOCK','GRN','XYZ720751424','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8065,'XYZ-1768195242393-FBA8595C',1,NULL,'IN_STOCK','GRN','XYZ307385809','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8066,'XYZ-1768195242415-5890A872',1,NULL,'IN_STOCK','GRN','XYZ432915877','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8067,'XYZ-1768195242438-454E8CDE',1,NULL,'IN_STOCK','GRN','XYZ186083324','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8068,'XYZ-1768195242460-3BFB28CB',1,NULL,'IN_STOCK','GRN','XYZ029459986','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8069,'XYZ-1768195242485-3AA4E36E',1,NULL,'IN_STOCK','GRN','XYZ553263502','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8070,'XYZ-1768195242508-93BAF016',1,NULL,'IN_STOCK','GRN','XYZ487205262','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8071,'XYZ-1768195242530-B00EDA99',1,NULL,'IN_STOCK','GRN','XYZ642186085','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8072,'XYZ-1768195242552-B87A13F3',1,NULL,'IN_STOCK','GRN','XYZ367386999','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8073,'XYZ-1768195242574-960056EF',1,NULL,'IN_STOCK','GRN','XYZ409702846','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8074,'XYZ-1768195242597-90F4EC4C',1,NULL,'IN_STOCK','GRN','XYZ459670694','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8075,'XYZ-1768195242619-07FC77C5',1,NULL,'IN_STOCK','GRN','XYZ234618560','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8076,'XYZ-1768195242641-AA8D9B44',1,NULL,'IN_STOCK','GRN','XYZ245206888','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8077,'XYZ-1768195242664-61E602F4',1,NULL,'IN_STOCK','GRN','XYZ899674998','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8078,'XYZ-1768195242688-BE8F7472',1,NULL,'IN_STOCK','GRN','XYZ091665603','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8079,'XYZ-1768195242713-253CD526',1,NULL,'IN_STOCK','GRN','XYZ683920308','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8080,'XYZ-1768195242739-2A08B83A',1,NULL,'IN_STOCK','GRN','XYZ240858974','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8081,'XYZ-1768195242765-966DA2D6',1,NULL,'IN_STOCK','GRN','XYZ973861148','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8082,'XYZ-1768195242788-1386EF0E',1,NULL,'IN_STOCK','GRN','XYZ262100640','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8083,'XYZ-1768195242813-D5B7B5F4',1,NULL,'IN_STOCK','GRN','XYZ552837278','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8084,'XYZ-1768195242839-4F5F1691',1,NULL,'IN_STOCK','GRN','XYZ739851290','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8085,'XYZ-1768195242862-1D14C6C3',1,NULL,'IN_STOCK','GRN','XYZ765106433','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8086,'XYZ-1768195242887-1BFBA325',1,NULL,'IN_STOCK','GRN','XYZ225703749','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8087,'XYZ-1768195242909-69C964EF',1,NULL,'IN_STOCK','GRN','XYZ924599300','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8088,'XYZ-1768195242932-419E1A02',1,NULL,'IN_STOCK','GRN','XYZ445311384','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8089,'XYZ-1768195242955-B92001D1',1,NULL,'IN_STOCK','GRN','XYZ897111591','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8090,'XYZ-1768195242977-33303797',1,NULL,'IN_STOCK','GRN','XYZ566950919','2026-01-12 05:20:42','2026-01-12 05:20:42'),(8091,'XYZ-1768195243003-C609AB5A',1,NULL,'IN_STOCK','GRN','XYZ105461052','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8092,'XYZ-1768195243026-CF96049F',1,NULL,'IN_STOCK','GRN','XYZ833408995','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8093,'XYZ-1768195243048-521ECA13',1,NULL,'IN_STOCK','GRN','XYZ526479039','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8094,'XYZ-1768195243071-4C0548B6',1,NULL,'IN_STOCK','GRN','XYZ676302551','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8095,'XYZ-1768195243098-B6CA51D2',1,NULL,'IN_STOCK','GRN','XYZ700894903','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8096,'XYZ-1768195243122-926B3824',1,NULL,'IN_STOCK','GRN','XYZ355092676','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8097,'XYZ-1768195243144-1A2815AD',1,NULL,'IN_STOCK','GRN','XYZ875748758','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8098,'XYZ-1768195243167-BDDF1946',1,NULL,'IN_STOCK','GRN','XYZ250042316','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8099,'XYZ-1768195243189-32ADF1AD',1,NULL,'IN_STOCK','GRN','XYZ287049402','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8100,'XYZ-1768195243216-8F7F66C0',1,NULL,'IN_STOCK','GRN','XYZ070002924','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8101,'XYZ-1768195243241-36BB3537',1,NULL,'IN_STOCK','GRN','XYZ185785706','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8102,'XYZ-1768195243264-87B3591F',1,NULL,'IN_STOCK','GRN','XYZ502457230','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8103,'XYZ-1768195243286-B6A96968',1,NULL,'IN_STOCK','GRN','XYZ358989471','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8104,'XYZ-1768195243308-1F30B6D5',1,NULL,'IN_STOCK','GRN','XYZ499191599','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8105,'XYZ-1768195243331-255E54E5',1,NULL,'IN_STOCK','GRN','XYZ763366687','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8106,'XYZ-1768195243358-DDDE1CFC',1,NULL,'IN_STOCK','GRN','XYZ343497028','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8107,'XYZ-1768195243383-BF28EF02',1,NULL,'IN_STOCK','GRN','XYZ834106237','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8108,'XYZ-1768195243405-70E2BF33',1,NULL,'IN_STOCK','GRN','XYZ175309262','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8109,'XYZ-1768195243428-2D37EF75',1,NULL,'IN_STOCK','GRN','XYZ316925961','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8110,'XYZ-1768195243452-6547F739',1,NULL,'IN_STOCK','GRN','XYZ139186629','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8111,'XYZ-1768195243477-484F16C3',1,NULL,'IN_STOCK','GRN','XYZ374255492','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8112,'XYZ-1768195243499-E5BDDE17',1,NULL,'IN_STOCK','GRN','XYZ868060664','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8113,'XYZ-1768195243523-06112A4B',1,NULL,'IN_STOCK','GRN','XYZ341345052','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8114,'XYZ-1768195243547-E574DF8A',1,NULL,'IN_STOCK','GRN','XYZ077280474','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8115,'XYZ-1768195243572-E03E73FB',1,NULL,'IN_STOCK','GRN','XYZ360261332','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8116,'XYZ-1768195243595-0E3D3A42',1,NULL,'IN_STOCK','GRN','XYZ873068280','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8117,'XYZ-1768195243618-21D440F3',1,NULL,'IN_STOCK','GRN','XYZ385423884','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8118,'XYZ-1768195243642-CFFC105B',1,NULL,'IN_STOCK','GRN','XYZ137237980','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8119,'XYZ-1768195243666-5A5A0E1D',1,NULL,'IN_STOCK','GRN','XYZ317669280','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8120,'XYZ-1768195243688-452EDF97',1,NULL,'IN_STOCK','GRN','XYZ597907295','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8121,'XYZ-1768195243711-FD2CF154',1,NULL,'IN_STOCK','GRN','XYZ984568262','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8122,'XYZ-1768195243730-81F5D879',1,NULL,'IN_STOCK','GRN','XYZ619831917','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8123,'XYZ-1768195243750-6CFDDBC8',1,NULL,'IN_STOCK','GRN','XYZ430615907','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8124,'XYZ-1768195243769-A5AA61B6',1,NULL,'IN_STOCK','GRN','XYZ060118794','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8125,'XYZ-1768195243791-5BBD19D9',1,NULL,'IN_STOCK','GRN','XYZ824392759','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8126,'XYZ-1768195243813-D625E3B7',1,NULL,'IN_STOCK','GRN','XYZ687047058','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8127,'XYZ-1768195243840-90F50BBD',1,NULL,'IN_STOCK','GRN','XYZ178232350','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8128,'XYZ-1768195243866-F75C7070',1,NULL,'IN_STOCK','GRN','XYZ406642903','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8129,'XYZ-1768195243892-80E33A33',1,NULL,'IN_STOCK','GRN','XYZ584388949','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8130,'XYZ-1768195243914-6C432EAF',1,NULL,'IN_STOCK','GRN','XYZ862064734','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8131,'XYZ-1768195243940-F7D609C5',1,NULL,'IN_STOCK','GRN','XYZ890132983','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8132,'XYZ-1768195243962-5D96396C',1,NULL,'IN_STOCK','GRN','XYZ076048037','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8133,'XYZ-1768195243985-8148A2ED',1,NULL,'IN_STOCK','GRN','XYZ704744967','2026-01-12 05:20:43','2026-01-12 05:20:43'),(8134,'XYZ-1768195244008-2F86A16F',1,NULL,'IN_STOCK','GRN','XYZ440495114','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8135,'XYZ-1768195244031-6502F78B',1,NULL,'IN_STOCK','GRN','XYZ799643520','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8136,'XYZ-1768195244053-3DA29C7E',1,NULL,'IN_STOCK','GRN','XYZ204948846','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8137,'XYZ-1768195244075-F2F1D126',1,NULL,'IN_STOCK','GRN','XYZ371314126','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8138,'XYZ-1768195244097-33CA0161',1,NULL,'IN_STOCK','GRN','XYZ316031126','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8139,'XYZ-1768195244120-419113BA',1,NULL,'IN_STOCK','GRN','XYZ089013349','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8140,'XYZ-1768195244142-FEA0D4C7',1,NULL,'IN_STOCK','GRN','XYZ930291850','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8141,'XYZ-1768195244165-EECA990D',1,NULL,'IN_STOCK','GRN','XYZ437790219','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8142,'XYZ-1768195244188-CA25A405',1,NULL,'IN_STOCK','GRN','XYZ500924124','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8143,'XYZ-1768195244210-B88C55DF',1,NULL,'IN_STOCK','GRN','XYZ620499543','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8144,'XYZ-1768195244233-5309B858',1,NULL,'IN_STOCK','GRN','XYZ903144833','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8145,'XYZ-1768195244256-3F8F688B',1,NULL,'IN_STOCK','GRN','XYZ572574129','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8146,'XYZ-1768195244278-262EBEC6',1,NULL,'IN_STOCK','GRN','XYZ382748851','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8147,'XYZ-1768195244301-771879F6',1,NULL,'IN_STOCK','GRN','XYZ752043271','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8148,'XYZ-1768195244325-46B5F633',1,NULL,'IN_STOCK','GRN','XYZ179740257','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8149,'XYZ-1768195244349-F44E7876',1,NULL,'IN_STOCK','GRN','XYZ408945265','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8150,'XYZ-1768195244373-275DDD71',1,NULL,'IN_STOCK','GRN','XYZ528528542','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8151,'XYZ-1768195244396-10ADA988',1,NULL,'IN_STOCK','GRN','XYZ965889465','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8152,'XYZ-1768195244419-E0B01612',1,NULL,'IN_STOCK','GRN','XYZ585824000','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8153,'XYZ-1768195244443-F4ACED14',1,NULL,'IN_STOCK','GRN','XYZ439752825','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8154,'XYZ-1768195244468-315BCE78',1,NULL,'IN_STOCK','GRN','XYZ689231196','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8155,'XYZ-1768195244493-5D978307',1,NULL,'IN_STOCK','GRN','XYZ136388168','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8156,'XYZ-1768195244516-184AA7E5',1,NULL,'IN_STOCK','GRN','XYZ764444388','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8157,'XYZ-1768195244540-C9C6FFAC',1,NULL,'IN_STOCK','GRN','XYZ518207716','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8158,'XYZ-1768195244563-62C60EB4',1,NULL,'IN_STOCK','GRN','XYZ978372066','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8159,'XYZ-1768195244586-9A9A453D',1,NULL,'IN_STOCK','GRN','XYZ703911875','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8160,'XYZ-1768195244608-4972F679',1,NULL,'IN_STOCK','GRN','XYZ318523779','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8161,'XYZ-1768195244632-ABD83A54',1,NULL,'IN_STOCK','GRN','XYZ205936052','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8162,'XYZ-1768195244655-D5508DC0',1,NULL,'IN_STOCK','GRN','XYZ806849678','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8163,'XYZ-1768195244678-886BC8A7',1,NULL,'IN_STOCK','GRN','XYZ917351968','2026-01-12 05:20:44','2026-01-12 05:20:44'),(8164,'XYZ-1768195244702-47CAEF4E',1,NULL,'IN_STOCK','GRN','XYZ147529722'