/**
 * Application constants
 */

// User roles
export const USER_ROLES = {
  CASHIER: 'cashier',
  MANAGER: 'manager',
  SYSTEM_ADMIN: 'system_admin',
};

// Product types
export const PRODUCT_TYPES = {
  FINISHED_GOODS: 'FG',
  RAW_MATERIALS: 'RM',
};

// Sale types
export const SALE_TYPES = {
  POS: 'POS',
  INVOICE: 'INVOICE',
};

// Sale statuses
export const SALE_STATUSES = {
  DRAFT: 'DRAFT',
  PAID: 'PAID',
  CANCELLED: 'CANCELLED',
};

// Payment methods
export const PAYMENT_METHODS = {
  CASH: 'CASH',
  PAYSTACK: 'PAYSTACK',
  MOBILE_MONEY: 'MOBILE_MONEY',
};

// Customer types
export const CUSTOMER_TYPES = {
  B2C: 'B2C',
  B2B: 'B2B',
};

// Price list types
export const PRICE_LIST_TYPES = {
  RETAIL: 'RETAIL',
  WHOLESALE: 'WHOLESALE',
  B2B: 'B2B',
  CUSTOMER_SPECIFIC: 'CUSTOMER_SPECIFIC',
};

// Tax types
export const TAX_TYPES = {
  VAT: 'VAT',
  EXCISE: 'EXCISE',
  SALES_TAX: 'SALES_TAX',
  OTHER: 'OTHER',
};

// Vendor types
export const VENDOR_TYPES = {
  OPEN_MARKET: 'OPEN_MARKET',
  REGISTERED: 'REGISTERED',
};

// Production order statuses
export const PRODUCTION_ORDER_STATUSES = {
  DRAFT: 'DRAFT',
  CONFIRMED: 'CONFIRMED',
  IN_PROGRESS: 'IN_PROGRESS',
  COMPLETED: 'COMPLETED',
  CANCELLED: 'CANCELLED',
};

// Purchase order statuses
export const PURCHASE_ORDER_STATUSES = {
  DRAFT: 'DRAFT',
  CONFIRMED: 'CONFIRMED',
  RECEIVED: 'RECEIVED',
  CANCELLED: 'CANCELLED',
};

// Return statuses
export const RETURN_STATUSES = {
  DRAFT: 'DRAFT',
  COMPLETED: 'COMPLETED',
  CANCELLED: 'CANCELLED',
};

// Inventory tracking types
export const INVENTORY_TRACKING_TYPES = {
  QUANTITY: 'QUANTITY',
  UID: 'UID',
};

// Inventory movement reasons
export const INVENTORY_MOVEMENT_REASONS = {
  GRN: 'GRN',
  SALE: 'SALE',
  SALE_RETURN: 'SALE_RETURN',
  PRODUCTION_CONSUME: 'PRODUCTION_CONSUME',
  PRODUCTION_OUTPUT: 'PRODUCTION_OUTPUT',
  ADJUSTMENT: 'ADJUSTMENT',
};

// Pagination defaults
export const PAGINATION = {
  DEFAULT_PAGE: 1,
  DEFAULT_LIMIT: 20,
  MAX_LIMIT: 100,
};

