/**
 * Users API endpoints
 */

import apiClient from './client';
import { API_ENDPOINTS } from '@/config/api';

export const usersAPI = {
  /**
   * List users
   * @param {Object} params - Query parameters
   * @returns {Promise}
   */
  list: async (params = {}) => {
    return apiClient.get(API_ENDPOINTS.USERS, { params });
  },

  /**
   * Get user by ID
   * @param {number} id
   * @returns {Promise}
   */
  getById: async (id) => {
    return apiClient.get(`${API_ENDPOINTS.USERS}/${id}`);
  },

  /**
   * Create user
   * @param {Object} userData
   * @returns {Promise}
   */
  create: async (userData) => {
    return apiClient.post(API_ENDPOINTS.USERS, userData);
  },

  /**
   * Update user
   * @param {number} id
   * @param {Object} userData
   * @returns {Promise}
   */
  update: async (id, userData) => {
    return apiClient.put(`${API_ENDPOINTS.USERS}/${id}`, userData);
  },

  /**
   * Delete user (soft delete)
   * @param {number} id
   * @returns {Promise}
   */
  delete: async (id) => {
    return apiClient.delete(`${API_ENDPOINTS.USERS}/${id}`);
  },
};

