/**
 * Sales API endpoints
 */

import apiClient from './client';
import { API_ENDPOINTS } from '@/config/api';

export const salesAPI = {
  /**
   * List sales
   * @param {Object} params - Query parameters
   * @returns {Promise}
   */
  list: async (params = {}) => {
    return apiClient.get(API_ENDPOINTS.SALES, { params });
  },

  /**
   * Get sale by ID
   * @param {number} id
   * @returns {Promise}
   */
  getById: async (id) => {
    return apiClient.get(`${API_ENDPOINTS.SALES}/${id}`);
  },

  /**
   * Create sale
   * @param {Object} saleData - { items, customer_id?, sale_type? }
   * @returns {Promise}
   */
  create: async (saleData) => {
    return apiClient.post(API_ENDPOINTS.SALES, saleData);
  },

  /**
   * Cancel sale
   * @param {number} id
   * @returns {Promise}
   */
  cancel: async (id) => {
    return apiClient.put(`${API_ENDPOINTS.SALES}/${id}/cancel`);
  },

  /**
   * Bulk check stock availability for cart items
   * @param {Array} items - Array of {product_id, variant_id?, quantity}
   * @returns {Promise}
   */
  checkStock: async (items) => {
    return apiClient.post(`${API_ENDPOINTS.SALES}/check-stock`, { items });
  },
};

