/**
 * Procurement API endpoints
 */

import apiClient from './client';
import { API_ENDPOINTS } from '@/config/api';

export const procurementAPI = {
  /**
   * List vendors
   * @param {Object} params - Query parameters
   * @returns {Promise}
   */
  listVendors: async (params = {}) => {
    return apiClient.get(API_ENDPOINTS.PROCUREMENT.VENDORS, { params });
  },

  /**
   * Get vendor by ID
   * @param {number} id
   * @returns {Promise}
   */
  getVendor: async (id) => {
    return apiClient.get(`${API_ENDPOINTS.PROCUREMENT.VENDORS}/${id}`);
  },

  /**
   * Create vendor
   * @param {Object} vendorData
   * @returns {Promise}
   */
  createVendor: async (vendorData) => {
    return apiClient.post(API_ENDPOINTS.PROCUREMENT.VENDORS, vendorData);
  },

  /**
   * Update vendor
   * @param {number} id
   * @param {Object} vendorData
   * @returns {Promise}
   */
  updateVendor: async (id, vendorData) => {
    return apiClient.put(`${API_ENDPOINTS.PROCUREMENT.VENDORS}/${id}`, vendorData);
  },

  /**
   * List purchase orders
   * @param {Object} params - Query parameters
   * @returns {Promise}
   */
  listPurchaseOrders: async (params = {}) => {
    return apiClient.get(API_ENDPOINTS.PROCUREMENT.PURCHASE_ORDERS, { params });
  },

  /**
   * Get purchase order by ID
   * @param {number} id
   * @returns {Promise}
   */
  getPurchaseOrder: async (id) => {
    return apiClient.get(`${API_ENDPOINTS.PROCUREMENT.PURCHASE_ORDERS}/${id}`);
  },

  /**
   * Create purchase order
   * @param {Object} poData
   * @returns {Promise}
   */
  createPurchaseOrder: async (poData) => {
    return apiClient.post(API_ENDPOINTS.PROCUREMENT.PURCHASE_ORDERS, poData);
  },

  /**
   * Update purchase order
   * @param {number} id
   * @param {Object} poData
   * @returns {Promise}
   */
  updatePurchaseOrder: async (id, poData) => {
    return apiClient.put(`${API_ENDPOINTS.PROCUREMENT.PURCHASE_ORDERS}/${id}`, poData);
  },

  /**
   * Update purchase order status
   * @param {number} id
   * @param {string} status
   * @returns {Promise}
   */
  updatePurchaseOrderStatus: async (id, status) => {
    return apiClient.put(`${API_ENDPOINTS.PROCUREMENT.PURCHASE_ORDERS}/${id}/status`, { status });
  },

  /**
   * List GRNs
   * @param {Object} params - Query parameters
   * @returns {Promise}
   */
  listGRNs: async (params = {}) => {
    return apiClient.get(API_ENDPOINTS.PROCUREMENT.GRNS, { params });
  },

  /**
   * Create GRN
   * @param {Object} grnData
   * @returns {Promise}
   */
  createGRN: async (grnData) => {
    return apiClient.post(API_ENDPOINTS.PROCUREMENT.GRNS, grnData);
  },

  /**
   * Get GRN by ID
   * @param {number} id
   * @returns {Promise}
   */
  getGRN: async (id) => {
    return apiClient.get(`${API_ENDPOINTS.PROCUREMENT.GRNS}/${id}`);
  },

  /**
   * Process GRN (add stock to inventory)
   * @param {number} id
   * @returns {Promise}
   */
  processGRN: async (id) => {
    return apiClient.post(`${API_ENDPOINTS.PROCUREMENT.GRNS}/${id}/process`);
  },
};

