/**
 * Pricing API endpoints
 */

import apiClient from './client';
import { API_ENDPOINTS } from '@/config/api';

export const pricingAPI = {
  /**
   * List price lists
   * @param {Object} params - Query parameters
   * @returns {Promise}
   */
  listPriceLists: async (params = {}) => {
    return apiClient.get(API_ENDPOINTS.PRICING.PRICE_LISTS, { params });
  },

  /**
   * Get price list by ID
   * @param {number} id
   * @returns {Promise}
   */
  getPriceList: async (id) => {
    return apiClient.get(`${API_ENDPOINTS.PRICING.PRICE_LISTS}/${id}`);
  },

  /**
   * Get default price list
   * @returns {Promise}
   */
  getDefaultPriceList: async () => {
    return apiClient.get(`${API_ENDPOINTS.PRICING.PRICE_LISTS}/default`);
  },

  /**
   * Create price list
   * @param {Object} priceListData
   * @returns {Promise}
   */
  createPriceList: async (priceListData) => {
    return apiClient.post(API_ENDPOINTS.PRICING.PRICE_LISTS, priceListData);
  },

  /**
   * Update price list
   * @param {number} id
   * @param {Object} priceListData
   * @returns {Promise}
   */
  updatePriceList: async (id, priceListData) => {
    return apiClient.put(`${API_ENDPOINTS.PRICING.PRICE_LISTS}/${id}`, priceListData);
  },

  /**
   * Delete price list
   * @param {number} id
   * @returns {Promise}
   */
  deletePriceList: async (id) => {
    return apiClient.delete(`${API_ENDPOINTS.PRICING.PRICE_LISTS}/${id}`);
  },

  /**
   * List product prices
   * @param {Object} params - Query parameters
   * @returns {Promise}
   */
  listProductPrices: async (params = {}) => {
    return apiClient.get(API_ENDPOINTS.PRICING.PRICES, { params });
  },

  /**
   * Get product price by ID
   * @param {number} id
   * @returns {Promise}
   */
  getProductPrice: async (id) => {
    return apiClient.get(`${API_ENDPOINTS.PRICING.PRICES}/${id}`);
  },

  /**
   * Create product price
   * @param {Object} priceData
   * @returns {Promise}
   */
  createProductPrice: async (priceData) => {
    return apiClient.post(API_ENDPOINTS.PRICING.PRICES, priceData);
  },

  /**
   * Update product price
   * @param {number} id
   * @param {Object} priceData
   * @returns {Promise}
   */
  updateProductPrice: async (id, priceData) => {
    return apiClient.put(`${API_ENDPOINTS.PRICING.PRICES}/${id}`, priceData);
  },

  /**
   * Delete product price
   * @param {number} id
   * @returns {Promise}
   */
  deleteProductPrice: async (id) => {
    return apiClient.delete(`${API_ENDPOINTS.PRICING.PRICES}/${id}`);
  },
};

