/**
 * Customers API endpoints
 */

import apiClient from './client';
import { API_ENDPOINTS } from '@/config/api';

export const customersAPI = {
  /**
   * List customers
   * @param {Object} params - Query parameters
   * @returns {Promise}
   */
  list: async (params = {}) => {
    return apiClient.get(API_ENDPOINTS.CUSTOMERS, { params });
  },

  /**
   * Search customers
   * @param {string} query
   * @returns {Promise}
   */
  search: async (query) => {
    return apiClient.get(`${API_ENDPOINTS.CUSTOMERS}/search`, {
      params: { q: query },
    });
  },

  /**
   * Get customer by ID
   * @param {number} id
   * @returns {Promise}
   */
  getById: async (id) => {
    return apiClient.get(`${API_ENDPOINTS.CUSTOMERS}/${id}`);
  },

  /**
   * Create customer
   * @param {Object} customerData
   * @returns {Promise}
   */
  create: async (customerData) => {
    return apiClient.post(API_ENDPOINTS.CUSTOMERS, customerData);
  },

  /**
   * Update customer
   * @param {number} id
   * @param {Object} customerData
   * @returns {Promise}
   */
  update: async (id, customerData) => {
    return apiClient.put(`${API_ENDPOINTS.CUSTOMERS}/${id}`, customerData);
  },
};

