/**
 * API Configuration
 */

export const API_BASE_URL = process.env.NEXT_PUBLIC_API_URL || 'http://192.168.100.99:4000/api';

export const API_ENDPOINTS = {
  // Auth
  AUTH: {
    LOGIN: '/auth/login',
    LOGIN_WITH_PIN: '/auth/login-pin',
    LOGOUT: '/auth/logout',
    SETUP: '/auth/setup',
    PROFILE: '/auth/profile',
  },
  // Users
  USERS: '/users',
  // Products
  PRODUCTS: '/products',
  // Inventory
  INVENTORY: '/inventory',
  // Sales
  SALES: '/sales',
  // Payments
  PAYMENTS: '/payments',
  // Categories
  CATEGORIES: '/categories',
  // Pricing
  PRICING: {
    PRICE_LISTS: '/pricing/price-lists',
    PRICES: '/pricing/prices',
  },
  // Taxes
  TAXES: {
    TAX_RATES: '/taxes/tax-rates',
    TAX_CATEGORIES: '/taxes/tax-categories',
    TAX_EXEMPTIONS: '/taxes/tax-exemptions',
    CALCULATE: '/taxes/calculate',
  },
  // Discounts
  DISCOUNTS: '/discounts',
  // Customers
  CUSTOMERS: '/customers',
  // Procurement
  PROCUREMENT: {
    VENDORS: '/procurement/vendors',
    PURCHASE_ORDERS: '/procurement/purchase-orders',
    GRNS: '/procurement/grns',
  },
  // Production
  PRODUCTION: {
    BOMS: '/production/boms',
    ORDERS: '/production/orders',
  },
  // Returns
  RETURNS: '/returns',
  // Reports
  REPORTS: '/reports',
  // Label Printing
  LABEL_PRINTING: '/label-printing',
  // Health
  HEALTH: '/health',
};

