# System Restructuring Plan
## Based on Real-World Requirements

This document outlines the comprehensive restructuring plan to align the system with actual business requirements.

---

## 📋 Requirements Summary

### BOM Structure (From Screenshot)
- **Category**: e.g., "Dresses"
- **Type**: e.g., "Wrap maxi", "Button-up midi", "Circular wrap midi sleeves"
- **Multiple RM Items per FG**:
  - Fabric (with input quantity - e.g., "3 mtrs", "2.5 mtrs")
  - Buttons (quantity - e.g., "15", "5")
  - Zipper (quantity)
  - Lining (with input quantity - e.g., "1.5 mtrs", "2 mtrs")
  - Elastic (quantity)

### Core Requirements
1. **Products**: FG and RM
   - **RM (Raw Materials)**: No UUID needed. RM are mostly acquired through procurement.
   - **FG (Finished Goods)**: UUID required, label printing (Honeywell/Zebra ZPL, 2x5 inch, product name + QR code)
2. **Inventory Tracking**: For both FG and RM
   - **Procurement (PO/GRN)**: Can acquire both RM and FG products
     - **RM products**: Tracked by quantity or dimensions (no UUID)
     - **FG products**: Get UUID when procured via GRN (for label printing)
   - **Production**: Increases FG inventory (generates UUID for FG products)
   - **POS Sales**: Decreases FG inventory
   - **Production Consumption**: Decreases RM inventory
   - **Low Stock Threshold**: Ability to set threshold for products to trigger low stock alerts
3. **Discount & Pricing**: Per product or product group (separate treatment)
4. **POS Sales**: Keep stable (no changes)
5. **Tax**: **REMOVE COMPLETELY**
6. **Payments**: Cash, Card, Mpesa (use Cash only for now)
7. **Returns**: Configure returns system
8. **Customers**: **REMOVE customer registration** - walk-in customers only
9. **Product Variants**: **REMOVE COMPLETELY** - variants not needed
10. **Reports**: 
    - P&L
    - Daily sales
    - Discounts
    - Total daily sales
    - Today sales
    - Fast moving products
    - Pending orders
    - Reports on cash/card/mpesa sales
    - Returns
    - Out of stock items
    - In-store items
    - Low stock items

---

## 🗄️ Database Schema Changes

### Tables to REMOVE
1. **Tax-related tables**:
   - `tax_categories`
   - `tax_exemptions`
   - `tax_rates`
2. **Product Variants**:
   - `product_variants` - **REMOVE COMPLETELY**
   - Remove all `variant_id` foreign keys from related tables
3. **Customer-related tables**:
   - `customers` (keep table but remove registration functionality)
   - Customer references from `sales` (make `customer_id` NULL by default)
4. **KRA-ETIMS** (if exists):
   - Remove KRA ETIMS integration module
5. **Fiscal Receipts** (if tax-related):
   - `fiscal_receipts` (if only used for tax)

### Tables to MODIFY
1. **products**:
   - Remove tax-related fields
   - Remove variant relationships
   - Keep: `product_type` (FG/RM), `track_inventory`, `track_by_dimensions`
   - Add `low_stock_threshold` field (for low stock alerts)
   
2. **sales**:
   - Remove `vat` field
   - Remove `customer_id` (or keep but make always NULL)
   - Remove tax-related fields
   
3. **sale_items**:
   - Remove `vat_rate`, `vat_amount` fields
   - Remove `variant_id` field (variants removed)
   
4. **boms**:
   - **Restructure** to match real-world BOM (Category, Type, multiple RM items)
   - Remove `fg_variant_id`, use `fg_product_id` instead (variants removed)
   
5. **bom_items**:
   - **Restructure** to support:
     - Fabric (with quantity/input)
     - Buttons (quantity)
     - Zipper (quantity)
     - Lining (with quantity/input)
     - Elastic (quantity)
   - May need `item_type` field (FABRIC, BUTTONS, ZIPPER, LINING, ELASTIC)
   
6. **payments**:
   - Update to support: CASH, CARD, MPESA
   - Add `payment_method` field
   
7. **inventory_items**:
   - UUID generation for **FG products ONLY** (RM products don't need UUIDs)
   - Add QR code generation/storage for FG products
   - Remove `variant_id` field (variants removed)
   
8. **inventory**:
   - Remove `variant_id` field (variants removed)
   - Keep `reorder_level` field (for low stock threshold)
   
9. **discounts**:
   - Update to support per-product and per-group discounts
   - Remove variant references
   
10. **product_prices**:
    - Update to support per-product and per-group pricing
    - Remove `variant_id` field (variants removed)
    
11. **grn_items**:
    - Remove `variant_id` field (variants removed)
    
12. **purchase_order_items**:
    - Remove `variant_id` field (variants removed)
    
13. **production_orders**:
    - Remove `fg_variant_id`, use `fg_product_id` instead (variants removed)
    
14. **inventory_movements**:
    - Remove `variant_id` field (variants removed)

### Tables to ADD
1. **product_groups** (if needed for group pricing/discounts)
2. **label_print_queue** (for label printing)
3. **label_templates** (for ZPL templates)

---

## 🔧 Module Changes

### Modules to REMOVE/Deprecate
1. **`modules/taxes/`** - Remove entirely
2. **`modules/customers/`** - Remove registration, keep minimal for walk-ins
3. **`modules/kra-etims/`** - Remove if exists
4. **Product Variants** - Remove all variant-related code from products module

### Modules to MODIFY

#### 1. Products Module
- Remove tax references
- Remove variant functionality completely
- Ensure UUID generation for **FG products ONLY** (RM products don't need UUIDs)
- Add low stock threshold management

#### 2. BOM Module (Major Restructuring)
- **Current**: Single-level BOM with RM items
- **New**: Category → Type → FG Product → Multiple RM Items (Fabric, Buttons, Zipper, Lining, Elastic)
- Update BOM creation/editing forms
- Update BOM validation logic

#### 3. Production Module
- Remove tax calculations
- Remove variant references
- Update to match new BOM structure (use `fg_product_id` instead of `fg_variant_id`)
- Ensure UUID generation for FG output (RM products don't need UUIDs)

#### 4. Sales Module (POS)
- Remove customer selection/registration
- Remove tax calculations
- Remove variant references
- Keep stable (minimal changes)
- Update payment methods

#### 5. Payments Module
- Support: CASH, CARD, MPESA
- Default to CASH only for now
- Update payment processing

#### 6. Discounts Module
- Update to support per-product and per-group discounts
- Remove tax-related discount calculations

#### 7. Pricing Module
- Update to support per-product and per-group pricing
- Remove tax-related pricing

#### 8. Reports Module
- **Add Reports**:
  - P&L Report
  - Daily Sales Report
  - Discounts Report
  - Total Daily Sales
  - Today Sales
  - Fast Moving Products
  - Pending Orders
  - Payment Method Reports (Cash/Card/Mpesa)
  - Returns Report
  - Out of Stock Items
  - In-Store Items
  - Low Stock Items
- **Remove Reports**:
  - Tax Reports

#### 9. Inventory Module
- Ensure **FG products ONLY** get UUID on creation (RM products don't need UUIDs)
- Support label printing for FG products (UUID + QR code)
- Add low stock threshold management and alerts
- Remove variant references

#### 10. Returns Module
- Ensure returns are configured and working
- Update to remove customer references

---

## 🎨 Frontend Changes

### Pages/Components to REMOVE
1. Customer registration pages
2. Customer management pages (or simplify to walk-in only)
3. Tax configuration pages
4. Tax reports
5. Product variant pages/components

### Pages/Components to MODIFY
1. **Product Management**:
   - Remove tax fields
   - Remove variant functionality
   - Add UUID display for FG products only (RM products don't show UUID)
   - Add label print button for FG products only
   - Add low stock threshold field
   
2. **BOM Management** (Major Changes):
   - Restructure to match real-world BOM
   - Category → Type → Product selection
   - Support multiple RM items: Fabric, Buttons, Zipper, Lining, Elastic
   - Update forms and validation
   
3. **POS/Sales**:
   - Remove customer selection
   - Remove tax display
   - Update payment methods (Cash/Card/Mpesa, default Cash)
   
4. **Discounts**:
   - Update to support per-product and per-group
   - Remove tax calculations
   
5. **Pricing**:
   - Update to support per-product and per-group
   - Remove tax references
   
6. **Reports**:
   - Add new report pages
   - Remove tax reports
   - Update existing reports to remove tax

### Pages/Components to ADD
1. **Label Printing**:
   - Label print interface
   - ZPL template configuration
   - Print queue management
   
2. **Reports**:
   - P&L Report page
   - Daily Sales Report page
   - Discounts Report page
   - Payment Method Reports page
   - Returns Report page
   - Out of Stock Items page
   - In-Store Items page
   - Low Stock Items page

---

## 🔄 Implementation Phases

### Phase 1: Database Cleanup
1. Create migration scripts to remove tax tables
2. Create migration scripts to remove product_variants table and all variant_id foreign keys
3. Update sales/sale_items to remove tax fields and variant_id
4. Update products to remove tax references and variant relationships
5. Update BOM structure (remove fg_variant_id, use fg_product_id)
6. Update payments to support new methods
7. Add low_stock_threshold field to products/inventory

### Phase 2: Backend API Updates
1. Remove tax services/modules
2. Update sales service (remove tax, customer registration)
3. Update BOM service (restructure)
4. Update payment service
5. Update discount service
6. Update pricing service
7. Update reports service
8. Add label printing service

### Phase 3: Frontend Updates
1. Remove customer registration UI
2. Remove tax UI
3. Update BOM forms
4. Update POS/sales UI
5. Update reports UI
6. Add label printing UI

### Phase 4: Testing & Validation
1. Test all modules
2. Validate BOM structure
3. Test label printing
4. Test reports
5. End-to-end testing

---

## 📝 Detailed Changes

### 1. BOM Restructuring Details

**Current Structure**:
```
BOM
  └── BOMItem (generic RM items)
```

**New Structure** (Based on Screenshot):
```
BOM
  ├── Category (e.g., "Dresses")
  ├── Type (e.g., "Wrap maxi", "Button-up midi")
  ├── FG Product
  └── BOMItems:
      ├── Fabric (with quantity/input - e.g., "3 mtrs")
      ├── Buttons (quantity - e.g., "15")
      ├── Zipper (quantity)
      ├── Lining (with quantity/input - e.g., "1.5 mtrs")
      └── Elastic (quantity)
```

**Database Changes Needed**:
- Add `category` field to BOM or products
- Add `type` field to BOM or products
- Change `boms.fg_variant_id` to `boms.fg_product_id` (remove variant dependency)
- Update `bom_items` to have `item_type` (FABRIC, BUTTONS, ZIPPER, LINING, ELASTIC)
- Update `bom_items` to handle both dimension-based (Fabric, Lining) and quantity-based (Buttons, Zipper, Elastic)

### 2. Tax Removal Details

**Remove**:
- All tax calculation logic
- Tax fields from sales, sale_items, products
- Tax modules/services
- Tax reports
- Tax UI components

**Update**:
- Sales totals (remove VAT)
- Pricing (remove tax components)
- Reports (remove tax columns)

### 3. Customer Removal Details

**Remove**:
- Customer registration functionality
- Customer management pages
- Customer selection in POS

**Keep**:
- `customers` table (for historical data, but always NULL for new sales)
- Or remove `customer_id` from sales entirely

### 4. Payment Method Updates

**Current**: Unknown structure
**New**: 
- Payment methods: CASH, CARD, MPESA
- Default to CASH only for now
- Update payment processing logic

### 5. Label Printing Details

**Requirements**:
- UUID for **FG products ONLY** (RM products don't need UUIDs or labels)
- Label: 2x5 inch
- Format: ZPL (Honeywell/Zebra)
- Content: Product name + QR code
- Print via Network or USB

**Implementation**:
- UUID generation service (for FG products only)
- QR code generation service
- ZPL template engine
- Print service (Network/USB)
- Print queue management

### 7. Product Variants Removal Details

**Remove**:
- `product_variants` table
- All `variant_id` foreign keys from:
  - `inventory`
  - `inventory_items`
  - `inventory_movements`
  - `sale_items`
  - `product_prices`
  - `grn_items`
  - `purchase_order_items`
- Change `boms.fg_variant_id` to `boms.fg_product_id`
- Change `production_orders.fg_variant_id` to `production_orders.fg_product_id`
- All variant-related code in products module
- Variant UI components

### 8. Low Stock Threshold Details

**Add**:
- `low_stock_threshold` field to products/inventory table
- UI to set threshold per product
- Logic to calculate and report low stock items
- Reports for low stock items

### 9. RM Products Clarification

**RM (Raw Materials)**:
- No UUID generation needed
- Mostly acquired through procurement (GRN)
- Tracked by quantity or dimensions (depending on product type)
- No label printing needed

### 6. Reports Details

**Required Reports**:
1. **P&L Report**: Profit & Loss statement
2. **Daily Sales**: Sales for a specific day
3. **Discounts Report**: Discounts applied
4. **Total Daily Sales**: Summary of daily sales
5. **Today Sales**: Today's sales
6. **Fast Moving Products**: Products with highest sales
7. **Pending Orders**: Orders not yet completed
8. **Payment Method Reports**: Sales by payment method (Cash/Card/Mpesa)
9. **Returns Report**: Returned items
10. **Out of Stock Items**: Products with zero inventory
11. **In-Store Items**: Products currently in store (available inventory)
12. **Low Stock Items**: Products below low stock threshold

---

## 🚨 Breaking Changes

1. **BOM Structure**: Complete restructuring - existing BOMs may need migration (change from fg_variant_id to fg_product_id)
2. **Product Variants Removal**: Complete removal - all variant_id references removed, existing data may need migration
3. **Tax Removal**: All tax calculations removed - historical data may need handling
4. **Customer Removal**: Customer registration removed - existing customers may be ignored
5. **Payment Methods**: Payment structure changed
6. **UUID Generation**: Only for FG products - RM products will not have UUIDs

---

## 📅 Next Steps

1. **Review this plan** with stakeholders
2. **Create detailed migration scripts** for database changes
3. **Prioritize phases** based on business needs
4. **Start with Phase 1** (Database Cleanup)
5. **Incremental implementation** with testing at each phase

---

## ⚠️ Notes

- **Historical Data**: Consider how to handle historical sales with tax/customers
- **Backward Compatibility**: May need data migration scripts
- **Testing**: Extensive testing required after each phase
- **Documentation**: Update all documentation after changes
