@echo off
setlocal

set SERVICE_NAME=XYZ Print Service

REM Check for admin privileges
net session >nul 2>&1
if %errorlevel% neq 0 (
  echo ERROR: This script must be run as Administrator
  exit /b 1
)

echo Stopping "%SERVICE_NAME%"...
sc stop "%SERVICE_NAME%"
if %errorlevel% neq 0 (
  echo Service may not be running or does not exist
  exit /b 1
)

timeout /t 2 /nobreak >nul
sc query "%SERVICE_NAME%"

endlocal
