@echo off
setlocal enabledelayedexpansion

echo ========================================
echo Build and Install XYZ Print Service
echo ========================================
echo.

REM Get the script directory
set "SCRIPT_DIR=%~dp0"
set "PROJECT_ROOT=%SCRIPT_DIR%.."

REM Check for admin privileges first
net session >nul 2>&1
if %errorlevel% neq 0 (
  echo ERROR: This script must be run as Administrator
  echo.
  echo Right-click on build-and-install.bat and select
  echo "Run as administrator"
  echo.
  pause
  exit /b 1
)

REM Step 1: Build
echo [1/2] Building service...
echo.
cd /d "%PROJECT_ROOT%"
call "%SCRIPT_DIR%publish.bat"
if %ERRORLEVEL% neq 0 (
    echo.
    echo Build failed! Cannot proceed with installation.
    pause
    exit /b 1
)

echo.
echo [2/2] Installing service...
echo.

REM Step 2: Install
call "%SCRIPT_DIR%install-service.bat"
if %ERRORLEVEL% neq 0 (
    echo.
    echo Installation failed!
    pause
    exit /b 1
)

echo.
echo ========================================
echo All done! Service is installed and running.
echo ========================================
echo.
pause
endlocal
