# XYZ Print Service

Native Windows print service for XYZ POS label printing. Runs as a Windows Service and provides a REST API for printer discovery and ZPL printing.

## Requirements

- .NET 8.0 SDK or Runtime
- Windows 10/11 or Windows Server 2016+
- Administrator privileges (for service installation)

## Quick Start

### One-Step Build and Install (Recommended)

1. **Right-click** `scripts\build-and-install.bat`
2. Select **"Run as administrator"**
3. Wait for build and installation to complete

This will:
- Build the service executable
- Install it as a Windows Service
- Start the service automatically

### Step-by-Step

#### Step 1: Build the Service

```batch
cd PrintService
scripts\publish.bat
```

**Important:** Make sure you're in the `PrintService` directory when running this!

This will:
- Build a self-contained Windows x64 executable
- Output to `PrintService\publish\XYZ.PrintService.exe`
- Show the full path to the created EXE

**Troubleshooting:**
- If you see "Root element is missing" error, make sure you're in the correct directory
- Verify `XYZ.PrintService.csproj` exists and is not empty
- Check that .NET 8.0 SDK is installed: `dotnet --version`

#### Step 2: Install as Windows Service

**Right-click** `scripts\install-service.bat` and select **"Run as administrator"**

This will:
- Check that the EXE exists (will error if Step 1 wasn't completed)
- Create the service named "XYZ Print Service"
- Set it to start automatically
- Start the service immediately

**Troubleshooting:**
- If script crashes, check that `publish\XYZ.PrintService.exe` exists
- Make sure you're running as Administrator
- Check Windows Event Viewer if service fails to start

#### Step 3: Verify Installation

```batch
scripts\check-status.bat
```

This will check:
- Executable exists
- Service is installed
- Service is running
- HTTP endpoint is responding

### Manual Build (Alternative)

If the scripts don't work, you can build manually:

```batch
cd PrintService
dotnet publish -c Release -r win-x64 --self-contained true -p:PublishSingleFile=true -o publish
```

## Service Management

### Start Service
```batch
scripts\start-service.bat
```
Or manually:
```batch
sc start "XYZ Print Service"
```

### Stop Service
```batch
scripts\stop-service.bat
```
Or manually:
```batch
sc stop "XYZ Print Service"
```

### Uninstall Service
```batch
scripts\uninstall-service.bat
```
Or manually:
```batch
sc stop "XYZ Print Service"
sc delete "XYZ Print Service"
```

## API Endpoints

The service listens on `http://127.0.0.1:9101`

### Health Check
```
GET /health
```

### List Printers
```
GET /printers
Headers: X-Print-Agent-Key: xyz-pos-local-token
```

### Print ZPL
```
POST /print
Headers: 
  Content-Type: application/json
  X-Print-Agent-Key: xyz-pos-local-token

Body:
{
  "printerName": "ZDesigner ZT231-203dpi ZPL",
  "zpl": "^XA^FO50,50^A0N50,50^FDHello^FS^XZ"
}
```

## Configuration

### API Key
Default API key: `xyz-pos-local-token`

To change it, edit `PrintService/Security/ApiKeyMiddleware.cs` and rebuild.

### Port
Default port: `9101` (localhost only)

To change it, edit `PrintService/Program.cs` line 7:
```csharp
builder.WebHost.UseUrls("http://127.0.0.1:9101");
```

## Troubleshooting

### Service won't start
1. Check Windows Event Viewer → Windows Logs → Application
2. Verify the EXE path is correct
3. Ensure port 9101 is not in use by another application

### Printers not detected
1. Verify printers are installed in Windows
2. Check printer drivers are properly installed
3. Restart the service after adding printers

### Frontend can't connect
1. Verify service is running: `sc query "XYZ Print Service"`
2. Check firewall isn't blocking localhost:9101
3. **Frontend Configuration (Optional):**
   - The frontend uses default values if not configured:
     - `NEXT_PUBLIC_PRINT_SERVICE_URL=http://127.0.0.1:9101` (default)
     - `NEXT_PUBLIC_PRINT_SERVICE_KEY=xyz-pos-local-token` (default)
   - Only set these in `client/.env.local` if you've changed the service defaults

## Development

### Run in console mode (for debugging)
```batch
dotnet run
```

### Run as service (after installation)
The service runs automatically after installation. Use Windows Service Manager or the batch scripts to control it.

## Project Structure

```
PrintService/
├── Api/              # REST API endpoints
├── Models/           # Data models
├── Native/           # Windows API interop
├── Security/         # API key middleware
├── Services/         # Business logic
├── Tray/             # System tray (future)
├── scripts/          # Build and install scripts
└── Program.cs        # Application entry point
```
