namespace XYZ.PrintService.Models;

public enum PrintJobStatus
{
    Queued,
    Printing,
    Completed,
    CompletedWithErrors,
    Failed
}

public enum PrintJobItemStatus
{
    Queued,
    Printing,
    Success,
    Failed
}

public class PrintJobItem
{
    public string ItemId { get; set; } = "";
    public string Zpl { get; set; } = "";
    public PrintJobItemStatus Status { get; set; } = PrintJobItemStatus.Queued;
    public int Attempts { get; set; } = 0;
    public string? LastError { get; set; } = null;
}

public class PrintJob
{
    public Guid JobId { get; set; } = Guid.NewGuid();
    public string PrinterName { get; set; } = "";
    public DateTime CreatedAt { get; set; } = DateTime.UtcNow;
    public DateTime? CompletedAt { get; set; } = null;
    public PrintJobStatus Status { get; set; } = PrintJobStatus.Queued;
    public List<PrintJobItem> Items { get; set; } = new();
}

